/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils.client.network;

import org.hl7.fhir.dstu3.model.Resource;

public class ResourceRequest<T extends Resource> {
    private T payload;
    private int httpStatus = -1;
    private String location;

    public ResourceRequest(T payload, int httpStatus, String location) {
        this.payload = payload;
        this.httpStatus = httpStatus;
        this.location = location;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public T getPayload() {
        return this.payload;
    }

    public T getReference() {
        T payloadResource = null;
        if (this.payload != null) {
            payloadResource = this.payload;
        }
        return payloadResource;
    }

    public boolean isSuccessfulRequest() {
        return this.httpStatus / 100 == 2;
    }

    public boolean isUnsuccessfulRequest() {
        return !this.isSuccessfulRequest();
    }

    public String getLocation() {
        return this.location;
    }
}

