/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ChargeitemBillingcodes {
    _1100,
    _1210,
    _1320,
    NULL;


    public static ChargeitemBillingcodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1100".equals(codeString)) {
            return _1100;
        }
        if ("1210".equals(codeString)) {
            return _1210;
        }
        if ("1320".equals(codeString)) {
            return _1320;
        }
        throw new FHIRException("Unknown ChargeitemBillingcodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1100: {
                return "1100";
            }
            case _1210: {
                return "1210";
            }
            case _1320: {
                return "1320";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/chargeitem-billingcodes";
    }

    public String getDefinition() {
        switch (this) {
            case _1100: {
                return "From German EBM billing system:\nUnvorhergesehene Inanspruchnahme des Vertragsarztes durch einen Patienten;zwischen 19:00 und 22:00 Uhr;an Samstagen, Sonntagen und gesetzlichen Feiertagen, am 24.12. und 31.12. zwischen 07:00 und 19:00 Uhr.";
            }
            case _1210: {
                return "From German EBM billing system:\nNotfallpauschale im organisierten Not(-fall)dienst und f\u00fcr nicht an der vertrags\u00e4rztlichen Versorgung teilnehmende \u00c4rzte, Institute und Krankenh\u00e4user bei Inanspruchnahme;zwischen 07:00 und 19:00 Uhr.";
            }
            case _1320: {
                return "From German EBM billing system:\nGrundpauschale f\u00fcr \u00c4rzte, Institute und Krankenh\u00e4user, die zur Erbringung von Leistungen innerhalb mindestens eines der Fachgebiete An\u00e4sthesiologie, Frauenheilkunde und Geburtshilfe, Haut- und Geschlechtskrankheiten, Mund-, Kiefer- und Gesichtschirurgie und Humangenetik erm\u00e4chtigt sind.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1100: {
                return "Unvorhergesehene Inanspruchnahme";
            }
            case _1210: {
                return "Notfallpauschale";
            }
            case _1320: {
                return "Grundpauschale";
            }
        }
        return "?";
    }
}

