/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VariableType {
    DICHOTOMOUS,
    CONTINUOUS,
    DESCRIPTIVE,
    NULL;


    public static VariableType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("dichotomous".equals(codeString)) {
            return DICHOTOMOUS;
        }
        if ("continuous".equals(codeString)) {
            return CONTINUOUS;
        }
        if ("descriptive".equals(codeString)) {
            return DESCRIPTIVE;
        }
        throw new FHIRException("Unknown VariableType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DICHOTOMOUS: {
                return "dichotomous";
            }
            case CONTINUOUS: {
                return "continuous";
            }
            case DESCRIPTIVE: {
                return "descriptive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/variable-type";
    }

    public String getDefinition() {
        switch (this) {
            case DICHOTOMOUS: {
                return "The variable is dichotomous, such as present or absent.";
            }
            case CONTINUOUS: {
                return "The variable is a continuous result such as a quantity.";
            }
            case DESCRIPTIVE: {
                return "The variable is described narratively rather than quantitatively.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DICHOTOMOUS: {
                return "Dichotomous";
            }
            case CONTINUOUS: {
                return "Continuous";
            }
            case DESCRIPTIVE: {
                return "Descriptive";
            }
        }
        return "?";
    }
}

