/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultValidationStatus {
    SUCCESSFUL,
    FAILED,
    UNKNOWN,
    NULL;


    public static VerificationresultValidationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("successful".equals(codeString)) {
            return SUCCESSFUL;
        }
        if ("failed".equals(codeString)) {
            return FAILED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown VerificationresultValidationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUCCESSFUL: {
                return "successful";
            }
            case FAILED: {
                return "failed";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/validation-status";
    }

    public String getDefinition() {
        switch (this) {
            case SUCCESSFUL: {
                return "";
            }
            case FAILED: {
                return "";
            }
            case UNKNOWN: {
                return "The validations status has not been determined yet";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUCCESSFUL: {
                return "Successful";
            }
            case FAILED: {
                return "Failed";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

