/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SpecimenDefinition", profile="http://hl7.org/fhir/StructureDefinition/SpecimenDefinition")
public class SpecimenDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier of a kind of specimen", formalDefinition="A business identifier associated with the kind of specimen.")
    protected Identifier identifier;
    @Child(name="typeCollected", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material to collect", formalDefinition="The kind of material to be collected.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    protected CodeableConcept typeCollected;
    @Child(name="patientPreparation", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Patient preparation for collection", formalDefinition="Preparation of the patient for specimen collection.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/prepare-patient-prior-specimen-collection")
    protected List<CodeableConcept> patientPreparation;
    @Child(name="timeAspect", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time aspect for collection", formalDefinition="Time aspect of specimen collection (duration or offset).")
    protected StringType timeAspect;
    @Child(name="collection", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen collection procedure", formalDefinition="The action to be performed for collecting the specimen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-collection")
    protected List<CodeableConcept> collection;
    @Child(name="typeTested", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen in container intended for testing by lab", formalDefinition="Specimen conditioned in a container as expected by the testing laboratory.")
    protected List<SpecimenDefinitionTypeTestedComponent> typeTested;
    private static final long serialVersionUID = -330188872L;
    @SearchParamDefinition(name="container", path="SpecimenDefinition.typeTested.container.type", description="The type of specimen conditioned in container expected by the lab", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="identifier", path="SpecimenDefinition.identifier", description="The unique identifier associated with the specimen", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="SpecimenDefinition.typeCollected", description="The type of collected specimen", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SpecimenDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getTypeCollected() {
        if (this.typeCollected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.typeCollected");
            }
            if (Configuration.doAutoCreate()) {
                this.typeCollected = new CodeableConcept();
            }
        }
        return this.typeCollected;
    }

    public boolean hasTypeCollected() {
        return this.typeCollected != null && !this.typeCollected.isEmpty();
    }

    public SpecimenDefinition setTypeCollected(CodeableConcept value) {
        this.typeCollected = value;
        return this;
    }

    public List<CodeableConcept> getPatientPreparation() {
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        return this.patientPreparation;
    }

    public SpecimenDefinition setPatientPreparation(List<CodeableConcept> thePatientPreparation) {
        this.patientPreparation = thePatientPreparation;
        return this;
    }

    public boolean hasPatientPreparation() {
        if (this.patientPreparation == null) {
            return false;
        }
        for (CodeableConcept item : this.patientPreparation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPatientPreparation() {
        CodeableConcept t = new CodeableConcept();
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        this.patientPreparation.add(t);
        return t;
    }

    public SpecimenDefinition addPatientPreparation(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        this.patientPreparation.add(t);
        return this;
    }

    public CodeableConcept getPatientPreparationFirstRep() {
        if (this.getPatientPreparation().isEmpty()) {
            this.addPatientPreparation();
        }
        return this.getPatientPreparation().get(0);
    }

    public StringType getTimeAspectElement() {
        if (this.timeAspect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.timeAspect");
            }
            if (Configuration.doAutoCreate()) {
                this.timeAspect = new StringType();
            }
        }
        return this.timeAspect;
    }

    public boolean hasTimeAspectElement() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public boolean hasTimeAspect() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public SpecimenDefinition setTimeAspectElement(StringType value) {
        this.timeAspect = value;
        return this;
    }

    public String getTimeAspect() {
        return this.timeAspect == null ? null : (String)this.timeAspect.getValue();
    }

    public SpecimenDefinition setTimeAspect(String value) {
        if (Utilities.noString((String)value)) {
            this.timeAspect = null;
        } else {
            if (this.timeAspect == null) {
                this.timeAspect = new StringType();
            }
            this.timeAspect.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCollection() {
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        return this.collection;
    }

    public SpecimenDefinition setCollection(List<CodeableConcept> theCollection) {
        this.collection = theCollection;
        return this;
    }

    public boolean hasCollection() {
        if (this.collection == null) {
            return false;
        }
        for (CodeableConcept item : this.collection) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCollection() {
        CodeableConcept t = new CodeableConcept();
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return t;
    }

    public SpecimenDefinition addCollection(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return this;
    }

    public CodeableConcept getCollectionFirstRep() {
        if (this.getCollection().isEmpty()) {
            this.addCollection();
        }
        return this.getCollection().get(0);
    }

    public List<SpecimenDefinitionTypeTestedComponent> getTypeTested() {
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        return this.typeTested;
    }

    public SpecimenDefinition setTypeTested(List<SpecimenDefinitionTypeTestedComponent> theTypeTested) {
        this.typeTested = theTypeTested;
        return this;
    }

    public boolean hasTypeTested() {
        if (this.typeTested == null) {
            return false;
        }
        for (SpecimenDefinitionTypeTestedComponent item : this.typeTested) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenDefinitionTypeTestedComponent addTypeTested() {
        SpecimenDefinitionTypeTestedComponent t = new SpecimenDefinitionTypeTestedComponent();
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        this.typeTested.add(t);
        return t;
    }

    public SpecimenDefinition addTypeTested(SpecimenDefinitionTypeTestedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        this.typeTested.add(t);
        return this;
    }

    public SpecimenDefinitionTypeTestedComponent getTypeTestedFirstRep() {
        if (this.getTypeTested().isEmpty()) {
            this.addTypeTested();
        }
        return this.getTypeTested().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A business identifier associated with the kind of specimen.", 0, 1, this.identifier));
        children.add(new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected));
        children.add(new Property("patientPreparation", "CodeableConcept", "Preparation of the patient for specimen collection.", 0, Integer.MAX_VALUE, this.patientPreparation));
        children.add(new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect));
        children.add(new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection));
        children.add(new Property("typeTested", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.typeTested));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A business identifier associated with the kind of specimen.", 0, 1, this.identifier);
            }
            case 588504367: {
                return new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected);
            }
            case -879411630: {
                return new Property("patientPreparation", "CodeableConcept", "Preparation of the patient for specimen collection.", 0, Integer.MAX_VALUE, this.patientPreparation);
            }
            case 276972933: {
                return new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect);
            }
            case -1741312354: {
                return new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection);
            }
            case -1407902581: {
                return new Property("typeTested", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.typeTested);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 588504367: {
                Base[] baseArray;
                if (this.typeCollected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.typeCollected;
                }
                return baseArray;
            }
            case -879411630: {
                return this.patientPreparation == null ? new Base[]{} : this.patientPreparation.toArray(new Base[this.patientPreparation.size()]);
            }
            case 276972933: {
                Base[] baseArray;
                if (this.timeAspect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.timeAspect;
                }
                return baseArray;
            }
            case -1741312354: {
                return this.collection == null ? new Base[]{} : this.collection.toArray(new Base[this.collection.size()]);
            }
            case -1407902581: {
                return this.typeTested == null ? new Base[]{} : this.typeTested.toArray(new Base[this.typeTested.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 588504367: {
                this.typeCollected = this.castToCodeableConcept(value);
                return value;
            }
            case -879411630: {
                this.getPatientPreparation().add(this.castToCodeableConcept(value));
                return value;
            }
            case 276972933: {
                this.timeAspect = this.castToString(value);
                return value;
            }
            case -1741312354: {
                this.getCollection().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1407902581: {
                this.getTypeTested().add((SpecimenDefinitionTypeTestedComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("typeCollected")) {
            this.typeCollected = this.castToCodeableConcept(value);
        } else if (name.equals("patientPreparation")) {
            this.getPatientPreparation().add(this.castToCodeableConcept(value));
        } else if (name.equals("timeAspect")) {
            this.timeAspect = this.castToString(value);
        } else if (name.equals("collection")) {
            this.getCollection().add(this.castToCodeableConcept(value));
        } else if (name.equals("typeTested")) {
            this.getTypeTested().add((SpecimenDefinitionTypeTestedComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 588504367: {
                return this.getTypeCollected();
            }
            case -879411630: {
                return this.addPatientPreparation();
            }
            case 276972933: {
                return this.getTimeAspectElement();
            }
            case -1741312354: {
                return this.addCollection();
            }
            case -1407902581: {
                return this.addTypeTested();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 588504367: {
                return new String[]{"CodeableConcept"};
            }
            case -879411630: {
                return new String[]{"CodeableConcept"};
            }
            case 276972933: {
                return new String[]{"string"};
            }
            case -1741312354: {
                return new String[]{"CodeableConcept"};
            }
            case -1407902581: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("typeCollected")) {
            this.typeCollected = new CodeableConcept();
            return this.typeCollected;
        }
        if (name.equals("patientPreparation")) {
            return this.addPatientPreparation();
        }
        if (name.equals("timeAspect")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.timeAspect");
        }
        if (name.equals("collection")) {
            return this.addCollection();
        }
        if (name.equals("typeTested")) {
            return this.addTypeTested();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SpecimenDefinition";
    }

    @Override
    public SpecimenDefinition copy() {
        SpecimenDefinition dst = new SpecimenDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SpecimenDefinition dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        CodeableConcept codeableConcept = dst.typeCollected = this.typeCollected == null ? null : this.typeCollected.copy();
        if (this.patientPreparation != null) {
            dst.patientPreparation = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.patientPreparation) {
                dst.patientPreparation.add(codeableConcept2.copy());
            }
        }
        StringType stringType = dst.timeAspect = this.timeAspect == null ? null : this.timeAspect.copy();
        if (this.collection != null) {
            dst.collection = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.collection) {
                dst.collection.add(codeableConcept3.copy());
            }
        }
        if (this.typeTested != null) {
            dst.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
            for (SpecimenDefinitionTypeTestedComponent specimenDefinitionTypeTestedComponent : this.typeTested) {
                dst.typeTested.add(specimenDefinitionTypeTestedComponent.copy());
            }
        }
    }

    protected SpecimenDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other_;
        return SpecimenDefinition.compareDeep(this.identifier, o.identifier, true) && SpecimenDefinition.compareDeep(this.typeCollected, o.typeCollected, true) && SpecimenDefinition.compareDeep(this.patientPreparation, o.patientPreparation, true) && SpecimenDefinition.compareDeep(this.timeAspect, o.timeAspect, true) && SpecimenDefinition.compareDeep(this.collection, o.collection, true) && SpecimenDefinition.compareDeep(this.typeTested, o.typeTested, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other_;
        return SpecimenDefinition.compareValues(this.timeAspect, o.timeAspect, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.typeCollected, this.patientPreparation, this.timeAspect, this.collection, this.typeTested});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SpecimenDefinition;
    }

    @Block
    public static class SpecimenDefinitionTypeTestedHandlingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="temperatureQualifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Temperature qualifier", formalDefinition="It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/handling-condition")
        protected CodeableConcept temperatureQualifier;
        @Child(name="temperatureRange", type={Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Temperature range", formalDefinition="The temperature interval for this set of handling instructions.")
        protected Range temperatureRange;
        @Child(name="maxDuration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum preservation time", formalDefinition="The maximum time interval of preservation of the specimen with these conditions.")
        protected Duration maxDuration;
        @Child(name="instruction", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Preservation instruction", formalDefinition="Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.")
        protected StringType instruction;
        private static final long serialVersionUID = 2130906844L;

        public CodeableConcept getTemperatureQualifier() {
            if (this.temperatureQualifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.temperatureQualifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.temperatureQualifier = new CodeableConcept();
                }
            }
            return this.temperatureQualifier;
        }

        public boolean hasTemperatureQualifier() {
            return this.temperatureQualifier != null && !this.temperatureQualifier.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setTemperatureQualifier(CodeableConcept value) {
            this.temperatureQualifier = value;
            return this;
        }

        public Range getTemperatureRange() {
            if (this.temperatureRange == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.temperatureRange");
                }
                if (Configuration.doAutoCreate()) {
                    this.temperatureRange = new Range();
                }
            }
            return this.temperatureRange;
        }

        public boolean hasTemperatureRange() {
            return this.temperatureRange != null && !this.temperatureRange.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setTemperatureRange(Range value) {
            this.temperatureRange = value;
            return this;
        }

        public Duration getMaxDuration() {
            if (this.maxDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.maxDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDuration = new Duration();
                }
            }
            return this.maxDuration;
        }

        public boolean hasMaxDuration() {
            return this.maxDuration != null && !this.maxDuration.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setMaxDuration(Duration value) {
            this.maxDuration = value;
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("temperatureQualifier", "CodeableConcept", "It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.", 0, 1, this.temperatureQualifier));
            children.add(new Property("temperatureRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.temperatureRange));
            children.add(new Property("maxDuration", "Duration", "The maximum time interval of preservation of the specimen with these conditions.", 0, 1, this.maxDuration));
            children.add(new Property("instruction", "string", "Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.", 0, 1, this.instruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 548941206: {
                    return new Property("temperatureQualifier", "CodeableConcept", "It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.", 0, 1, this.temperatureQualifier);
                }
                case -39203799: {
                    return new Property("temperatureRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.temperatureRange);
                }
                case 40284952: {
                    return new Property("maxDuration", "Duration", "The maximum time interval of preservation of the specimen with these conditions.", 0, 1, this.maxDuration);
                }
                case 301526158: {
                    return new Property("instruction", "string", "Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.", 0, 1, this.instruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    Base[] baseArray;
                    if (this.temperatureQualifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.temperatureQualifier;
                    }
                    return baseArray;
                }
                case -39203799: {
                    Base[] baseArray;
                    if (this.temperatureRange == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.temperatureRange;
                    }
                    return baseArray;
                }
                case 40284952: {
                    Base[] baseArray;
                    if (this.maxDuration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.maxDuration;
                    }
                    return baseArray;
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    this.temperatureQualifier = this.castToCodeableConcept(value);
                    return value;
                }
                case -39203799: {
                    this.temperatureRange = this.castToRange(value);
                    return value;
                }
                case 40284952: {
                    this.maxDuration = this.castToDuration(value);
                    return value;
                }
                case 301526158: {
                    this.instruction = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("temperatureQualifier")) {
                this.temperatureQualifier = this.castToCodeableConcept(value);
            } else if (name.equals("temperatureRange")) {
                this.temperatureRange = this.castToRange(value);
            } else if (name.equals("maxDuration")) {
                this.maxDuration = this.castToDuration(value);
            } else if (name.equals("instruction")) {
                this.instruction = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    return this.getTemperatureQualifier();
                }
                case -39203799: {
                    return this.getTemperatureRange();
                }
                case 40284952: {
                    return this.getMaxDuration();
                }
                case 301526158: {
                    return this.getInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    return new String[]{"CodeableConcept"};
                }
                case -39203799: {
                    return new String[]{"Range"};
                }
                case 40284952: {
                    return new String[]{"Duration"};
                }
                case 301526158: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("temperatureQualifier")) {
                this.temperatureQualifier = new CodeableConcept();
                return this.temperatureQualifier;
            }
            if (name.equals("temperatureRange")) {
                this.temperatureRange = new Range();
                return this.temperatureRange;
            }
            if (name.equals("maxDuration")) {
                this.maxDuration = new Duration();
                return this.maxDuration;
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedHandlingComponent copy() {
            SpecimenDefinitionTypeTestedHandlingComponent dst = new SpecimenDefinitionTypeTestedHandlingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedHandlingComponent dst) {
            super.copyValues(dst);
            dst.temperatureQualifier = this.temperatureQualifier == null ? null : this.temperatureQualifier.copy();
            dst.temperatureRange = this.temperatureRange == null ? null : this.temperatureRange.copy();
            dst.maxDuration = this.maxDuration == null ? null : this.maxDuration.copy();
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedHandlingComponent o = (SpecimenDefinitionTypeTestedHandlingComponent)other_;
            return SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.temperatureQualifier, o.temperatureQualifier, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.temperatureRange, o.temperatureRange, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.maxDuration, o.maxDuration, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedHandlingComponent o = (SpecimenDefinitionTypeTestedHandlingComponent)other_;
            return SpecimenDefinitionTypeTestedHandlingComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.temperatureQualifier, this.temperatureRange, this.maxDuration, this.instruction});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.handling";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedContainerAdditiveComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="additive", type={CodeableConcept.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0371")
        protected Type additive;
        private static final long serialVersionUID = 1819209272L;

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent() {
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent(Type additive) {
            this.additive = additive;
        }

        public Type getAdditive() {
            return this.additive;
        }

        public CodeableConcept getAdditiveCodeableConcept() throws FHIRException {
            if (this.additive == null) {
                this.additive = new CodeableConcept();
            }
            if (!(this.additive instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.additive;
        }

        public boolean hasAdditiveCodeableConcept() {
            return this != null && this.additive instanceof CodeableConcept;
        }

        public Reference getAdditiveReference() throws FHIRException {
            if (this.additive == null) {
                this.additive = new Reference();
            }
            if (!(this.additive instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (Reference)this.additive;
        }

        public boolean hasAdditiveReference() {
            return this != null && this.additive instanceof Reference;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent setAdditive(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for SpecimenDefinition.typeTested.container.additive.additive[x]: " + value.fhirType());
            }
            this.additive = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 261915956: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -1226589236: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case 1330272821: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -386783009: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    Base[] baseArray;
                    if (this.additive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.additive;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    this.additive = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("additive[x]")) {
                return super.setProperty(name, value);
            }
            this.additive = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 261915956: {
                    return this.getAdditive();
                }
                case -1226589236: {
                    return this.getAdditive();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("additiveCodeableConcept")) {
                this.additive = new CodeableConcept();
                return this.additive;
            }
            if (name.equals("additiveReference")) {
                this.additive = new Reference();
                return this.additive;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedContainerAdditiveComponent copy() {
            SpecimenDefinitionTypeTestedContainerAdditiveComponent dst = new SpecimenDefinitionTypeTestedContainerAdditiveComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedContainerAdditiveComponent dst) {
            super.copyValues(dst);
            dst.additive = this.additive == null ? null : this.additive.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerAdditiveComponent o = (SpecimenDefinitionTypeTestedContainerAdditiveComponent)other_;
            return SpecimenDefinitionTypeTestedContainerAdditiveComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerAdditiveComponent o = (SpecimenDefinitionTypeTestedContainerAdditiveComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.additive});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.container.additive";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedContainerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="material", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container material", formalDefinition="The type of material of the container.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/container-material")
        protected CodeableConcept material;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container associated with the kind of specimen", formalDefinition="The type of container used to contain this kind of specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
        protected CodeableConcept type;
        @Child(name="cap", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Color of container cap", formalDefinition="Color of container cap.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/container-cap")
        protected CodeableConcept cap;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container description", formalDefinition="The textual description of the kind of container.")
        protected StringType description;
        @Child(name="capacity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container capacity", formalDefinition="The capacity (volume or other measure) of this kind of container.")
        protected Quantity capacity;
        @Child(name="minimumVolume", type={Quantity.class, StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum volume", formalDefinition="The minimum volume to be conditioned in the container.")
        protected Type minimumVolume;
        @Child(name="additive", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        protected List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> additive;
        @Child(name="preparation", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen container preparation", formalDefinition="Special processing that should be applied to the container for this kind of specimen.")
        protected StringType preparation;
        private static final long serialVersionUID = 175789710L;

        public CodeableConcept getMaterial() {
            if (this.material == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.material");
                }
                if (Configuration.doAutoCreate()) {
                    this.material = new CodeableConcept();
                }
            }
            return this.material;
        }

        public boolean hasMaterial() {
            return this.material != null && !this.material.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setMaterial(CodeableConcept value) {
            this.material = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getCap() {
            if (this.cap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.cap");
                }
                if (Configuration.doAutoCreate()) {
                    this.cap = new CodeableConcept();
                }
            }
            return this.cap;
        }

        public boolean hasCap() {
            return this.cap != null && !this.cap.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setCap(CodeableConcept value) {
            this.cap = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Quantity getCapacity() {
            if (this.capacity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.capacity");
                }
                if (Configuration.doAutoCreate()) {
                    this.capacity = new Quantity();
                }
            }
            return this.capacity;
        }

        public boolean hasCapacity() {
            return this.capacity != null && !this.capacity.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setCapacity(Quantity value) {
            this.capacity = value;
            return this;
        }

        public Type getMinimumVolume() {
            return this.minimumVolume;
        }

        public Quantity getMinimumVolumeQuantity() throws FHIRException {
            if (this.minimumVolume == null) {
                this.minimumVolume = new Quantity();
            }
            if (!(this.minimumVolume instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.minimumVolume.getClass().getName() + " was encountered");
            }
            return (Quantity)this.minimumVolume;
        }

        public boolean hasMinimumVolumeQuantity() {
            return this != null && this.minimumVolume instanceof Quantity;
        }

        public StringType getMinimumVolumeStringType() throws FHIRException {
            if (this.minimumVolume == null) {
                this.minimumVolume = new StringType();
            }
            if (!(this.minimumVolume instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.minimumVolume.getClass().getName() + " was encountered");
            }
            return (StringType)this.minimumVolume;
        }

        public boolean hasMinimumVolumeStringType() {
            return this != null && this.minimumVolume instanceof StringType;
        }

        public boolean hasMinimumVolume() {
            return this.minimumVolume != null && !this.minimumVolume.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setMinimumVolume(Type value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SpecimenDefinition.typeTested.container.minimumVolume[x]: " + value.fhirType());
            }
            this.minimumVolume = value;
            return this;
        }

        public List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> getAdditive() {
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            return this.additive;
        }

        public SpecimenDefinitionTypeTestedContainerComponent setAdditive(List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> theAdditive) {
            this.additive = theAdditive;
            return this;
        }

        public boolean hasAdditive() {
            if (this.additive == null) {
                return false;
            }
            for (SpecimenDefinitionTypeTestedContainerAdditiveComponent item : this.additive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent addAdditive() {
            SpecimenDefinitionTypeTestedContainerAdditiveComponent t = new SpecimenDefinitionTypeTestedContainerAdditiveComponent();
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            this.additive.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedContainerComponent addAdditive(SpecimenDefinitionTypeTestedContainerAdditiveComponent t) {
            if (t == null) {
                return this;
            }
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            this.additive.add(t);
            return this;
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent getAdditiveFirstRep() {
            if (this.getAdditive().isEmpty()) {
                this.addAdditive();
            }
            return this.getAdditive().get(0);
        }

        public StringType getPreparationElement() {
            if (this.preparation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.preparation");
                }
                if (Configuration.doAutoCreate()) {
                    this.preparation = new StringType();
                }
            }
            return this.preparation;
        }

        public boolean hasPreparationElement() {
            return this.preparation != null && !this.preparation.isEmpty();
        }

        public boolean hasPreparation() {
            return this.preparation != null && !this.preparation.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setPreparationElement(StringType value) {
            this.preparation = value;
            return this;
        }

        public String getPreparation() {
            return this.preparation == null ? null : (String)this.preparation.getValue();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setPreparation(String value) {
            if (Utilities.noString((String)value)) {
                this.preparation = null;
            } else {
                if (this.preparation == null) {
                    this.preparation = new StringType();
                }
                this.preparation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("material", "CodeableConcept", "The type of material of the container.", 0, 1, this.material));
            children.add(new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.type));
            children.add(new Property("cap", "CodeableConcept", "Color of container cap.", 0, 1, this.cap));
            children.add(new Property("description", "string", "The textual description of the kind of container.", 0, 1, this.description));
            children.add(new Property("capacity", "SimpleQuantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.capacity));
            children.add(new Property("minimumVolume[x]", "SimpleQuantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume));
            children.add(new Property("additive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.additive));
            children.add(new Property("preparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.preparation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 299066663: {
                    return new Property("material", "CodeableConcept", "The type of material of the container.", 0, 1, this.material);
                }
                case 3575610: {
                    return new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.type);
                }
                case 98258: {
                    return new Property("cap", "CodeableConcept", "Color of container cap.", 0, 1, this.cap);
                }
                case -1724546052: {
                    return new Property("description", "string", "The textual description of the kind of container.", 0, 1, this.description);
                }
                case -67824454: {
                    return new Property("capacity", "SimpleQuantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.capacity);
                }
                case 371830456: {
                    return new Property("minimumVolume[x]", "SimpleQuantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -1674665784: {
                    return new Property("minimumVolume[x]", "SimpleQuantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -532143757: {
                    return new Property("minimumVolume[x]", "SimpleQuantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case 248461049: {
                    return new Property("minimumVolume[x]", "SimpleQuantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -1226589236: {
                    return new Property("additive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.additive);
                }
                case -1315428713: {
                    return new Property("preparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.preparation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    Base[] baseArray;
                    if (this.material == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.material;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 98258: {
                    Base[] baseArray;
                    if (this.cap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cap;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -67824454: {
                    Base[] baseArray;
                    if (this.capacity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.capacity;
                    }
                    return baseArray;
                }
                case -1674665784: {
                    Base[] baseArray;
                    if (this.minimumVolume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.minimumVolume;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    return this.additive == null ? new Base[]{} : this.additive.toArray(new Base[this.additive.size()]);
                }
                case -1315428713: {
                    Base[] baseArray;
                    if (this.preparation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.preparation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    this.material = this.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 98258: {
                    this.cap = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -67824454: {
                    this.capacity = this.castToQuantity(value);
                    return value;
                }
                case -1674665784: {
                    this.minimumVolume = this.castToType(value);
                    return value;
                }
                case -1226589236: {
                    this.getAdditive().add((SpecimenDefinitionTypeTestedContainerAdditiveComponent)value);
                    return value;
                }
                case -1315428713: {
                    this.preparation = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("material")) {
                this.material = this.castToCodeableConcept(value);
            } else if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("cap")) {
                this.cap = this.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("capacity")) {
                this.capacity = this.castToQuantity(value);
            } else if (name.equals("minimumVolume[x]")) {
                this.minimumVolume = this.castToType(value);
            } else if (name.equals("additive")) {
                this.getAdditive().add((SpecimenDefinitionTypeTestedContainerAdditiveComponent)value);
            } else if (name.equals("preparation")) {
                this.preparation = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    return this.getMaterial();
                }
                case 3575610: {
                    return this.getType();
                }
                case 98258: {
                    return this.getCap();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -67824454: {
                    return this.getCapacity();
                }
                case 371830456: {
                    return this.getMinimumVolume();
                }
                case -1674665784: {
                    return this.getMinimumVolume();
                }
                case -1226589236: {
                    return this.addAdditive();
                }
                case -1315428713: {
                    return this.getPreparationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 98258: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -67824454: {
                    return new String[]{"SimpleQuantity"};
                }
                case -1674665784: {
                    return new String[]{"SimpleQuantity", "string"};
                }
                case -1226589236: {
                    return new String[0];
                }
                case -1315428713: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("material")) {
                this.material = new CodeableConcept();
                return this.material;
            }
            if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("cap")) {
                this.cap = new CodeableConcept();
                return this.cap;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.description");
            }
            if (name.equals("capacity")) {
                this.capacity = new Quantity();
                return this.capacity;
            }
            if (name.equals("minimumVolumeQuantity")) {
                this.minimumVolume = new Quantity();
                return this.minimumVolume;
            }
            if (name.equals("minimumVolumeString")) {
                this.minimumVolume = new StringType();
                return this.minimumVolume;
            }
            if (name.equals("additive")) {
                return this.addAdditive();
            }
            if (name.equals("preparation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.preparation");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedContainerComponent copy() {
            SpecimenDefinitionTypeTestedContainerComponent dst = new SpecimenDefinitionTypeTestedContainerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedContainerComponent dst) {
            super.copyValues(dst);
            dst.material = this.material == null ? null : this.material.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.cap = this.cap == null ? null : this.cap.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.capacity = this.capacity == null ? null : this.capacity.copy();
            Type type = dst.minimumVolume = this.minimumVolume == null ? null : this.minimumVolume.copy();
            if (this.additive != null) {
                dst.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
                for (SpecimenDefinitionTypeTestedContainerAdditiveComponent i : this.additive) {
                    dst.additive.add(i.copy());
                }
            }
            dst.preparation = this.preparation == null ? null : this.preparation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerComponent o = (SpecimenDefinitionTypeTestedContainerComponent)other_;
            return SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.material, o.material, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.type, o.type, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.cap, o.cap, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.description, o.description, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.capacity, o.capacity, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.minimumVolume, o.minimumVolume, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.additive, o.additive, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.preparation, o.preparation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerComponent o = (SpecimenDefinitionTypeTestedContainerComponent)other_;
            return SpecimenDefinitionTypeTestedContainerComponent.compareValues(this.description, o.description, true) && SpecimenDefinitionTypeTestedContainerComponent.compareValues(this.preparation, o.preparation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.material, this.type, this.cap, this.description, this.capacity, this.minimumVolume, this.additive, this.preparation});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.container";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="isDerived", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Primary or secondary specimen", formalDefinition="Primary of secondary specimen.")
        protected BooleanType isDerived;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of intended specimen", formalDefinition="The kind of specimen conditioned for testing expected by lab.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
        protected CodeableConcept type;
        @Child(name="preference", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="preferred | alternate", formalDefinition="The preference for this type of conditioned specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-contained-preference")
        protected Enumeration<SpecimenContainedPreference> preference;
        @Child(name="container", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specimen's container", formalDefinition="The specimen's container.")
        protected SpecimenDefinitionTypeTestedContainerComponent container;
        @Child(name="requirement", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen requirements", formalDefinition="Requirements for delivery and special handling of this kind of conditioned specimen.")
        protected StringType requirement;
        @Child(name="retentionTime", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen retention time", formalDefinition="The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.")
        protected Duration retentionTime;
        @Child(name="rejectionCriterion", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rejection criterion", formalDefinition="Criterion for rejection of the specimen in its container by the laboratory.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/rejection-criteria")
        protected List<CodeableConcept> rejectionCriterion;
        @Child(name="handling", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen handling before testing", formalDefinition="Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.")
        protected List<SpecimenDefinitionTypeTestedHandlingComponent> handling;
        private static final long serialVersionUID = 308313920L;

        public SpecimenDefinitionTypeTestedComponent() {
        }

        public SpecimenDefinitionTypeTestedComponent(Enumeration<SpecimenContainedPreference> preference) {
            this.preference = preference;
        }

        public BooleanType getIsDerivedElement() {
            if (this.isDerived == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.isDerived");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDerived = new BooleanType();
                }
            }
            return this.isDerived;
        }

        public boolean hasIsDerivedElement() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public boolean hasIsDerived() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setIsDerivedElement(BooleanType value) {
            this.isDerived = value;
            return this;
        }

        public boolean getIsDerived() {
            return this.isDerived == null || this.isDerived.isEmpty() ? false : (Boolean)this.isDerived.getValue();
        }

        public SpecimenDefinitionTypeTestedComponent setIsDerived(boolean value) {
            if (this.isDerived == null) {
                this.isDerived = new BooleanType();
            }
            this.isDerived.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<SpecimenContainedPreference> getPreferenceElement() {
            if (this.preference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.preference");
                }
                if (Configuration.doAutoCreate()) {
                    this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
                }
            }
            return this.preference;
        }

        public boolean hasPreferenceElement() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public boolean hasPreference() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setPreferenceElement(Enumeration<SpecimenContainedPreference> value) {
            this.preference = value;
            return this;
        }

        public SpecimenContainedPreference getPreference() {
            return this.preference == null ? null : (SpecimenContainedPreference)((Object)this.preference.getValue());
        }

        public SpecimenDefinitionTypeTestedComponent setPreference(SpecimenContainedPreference value) {
            if (this.preference == null) {
                this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
            }
            this.preference.setValue((Object)value);
            return this;
        }

        public SpecimenDefinitionTypeTestedContainerComponent getContainer() {
            if (this.container == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.container");
                }
                if (Configuration.doAutoCreate()) {
                    this.container = new SpecimenDefinitionTypeTestedContainerComponent();
                }
            }
            return this.container;
        }

        public boolean hasContainer() {
            return this.container != null && !this.container.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setContainer(SpecimenDefinitionTypeTestedContainerComponent value) {
            this.container = value;
            return this;
        }

        public StringType getRequirementElement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new StringType();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirementElement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setRequirementElement(StringType value) {
            this.requirement = value;
            return this;
        }

        public String getRequirement() {
            return this.requirement == null ? null : (String)this.requirement.getValue();
        }

        public SpecimenDefinitionTypeTestedComponent setRequirement(String value) {
            if (Utilities.noString((String)value)) {
                this.requirement = null;
            } else {
                if (this.requirement == null) {
                    this.requirement = new StringType();
                }
                this.requirement.setValue(value);
            }
            return this;
        }

        public Duration getRetentionTime() {
            if (this.retentionTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.retentionTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.retentionTime = new Duration();
                }
            }
            return this.retentionTime;
        }

        public boolean hasRetentionTime() {
            return this.retentionTime != null && !this.retentionTime.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setRetentionTime(Duration value) {
            this.retentionTime = value;
            return this;
        }

        public List<CodeableConcept> getRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            return this.rejectionCriterion;
        }

        public SpecimenDefinitionTypeTestedComponent setRejectionCriterion(List<CodeableConcept> theRejectionCriterion) {
            this.rejectionCriterion = theRejectionCriterion;
            return this;
        }

        public boolean hasRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                return false;
            }
            for (CodeableConcept item : this.rejectionCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRejectionCriterion() {
            CodeableConcept t = new CodeableConcept();
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedComponent addRejectionCriterion(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return this;
        }

        public CodeableConcept getRejectionCriterionFirstRep() {
            if (this.getRejectionCriterion().isEmpty()) {
                this.addRejectionCriterion();
            }
            return this.getRejectionCriterion().get(0);
        }

        public List<SpecimenDefinitionTypeTestedHandlingComponent> getHandling() {
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            return this.handling;
        }

        public SpecimenDefinitionTypeTestedComponent setHandling(List<SpecimenDefinitionTypeTestedHandlingComponent> theHandling) {
            this.handling = theHandling;
            return this;
        }

        public boolean hasHandling() {
            if (this.handling == null) {
                return false;
            }
            for (SpecimenDefinitionTypeTestedHandlingComponent item : this.handling) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionTypeTestedHandlingComponent addHandling() {
            SpecimenDefinitionTypeTestedHandlingComponent t = new SpecimenDefinitionTypeTestedHandlingComponent();
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            this.handling.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedComponent addHandling(SpecimenDefinitionTypeTestedHandlingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            this.handling.add(t);
            return this;
        }

        public SpecimenDefinitionTypeTestedHandlingComponent getHandlingFirstRep() {
            if (this.getHandling().isEmpty()) {
                this.addHandling();
            }
            return this.getHandling().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived));
            children.add(new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type));
            children.add(new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference));
            children.add(new Property(SpecimenDefinition.SP_CONTAINER, "", "The specimen's container.", 0, 1, this.container));
            children.add(new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement));
            children.add(new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime));
            children.add(new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion));
            children.add(new Property("handling", "", "Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 976346515: {
                    return new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived);
                }
                case 3575610: {
                    return new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type);
                }
                case -1459831589: {
                    return new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference);
                }
                case -410956671: {
                    return new Property(SpecimenDefinition.SP_CONTAINER, "", "The specimen's container.", 0, 1, this.container);
                }
                case 363387971: {
                    return new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement);
                }
                case 1434969867: {
                    return new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime);
                }
                case -553706344: {
                    return new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion);
                }
                case 2072805: {
                    return new Property("handling", "", "Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    Base[] baseArray;
                    if (this.isDerived == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.isDerived;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1459831589: {
                    Base[] baseArray;
                    if (this.preference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preference;
                    }
                    return baseArray;
                }
                case -410956671: {
                    Base[] baseArray;
                    if (this.container == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.container;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1434969867: {
                    Base[] baseArray;
                    if (this.retentionTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.retentionTime;
                    }
                    return baseArray;
                }
                case -553706344: {
                    return this.rejectionCriterion == null ? new Base[]{} : this.rejectionCriterion.toArray(new Base[this.rejectionCriterion.size()]);
                }
                case 2072805: {
                    return this.handling == null ? new Base[]{} : this.handling.toArray(new Base[this.handling.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    this.isDerived = this.castToBoolean(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1459831589: {
                    value = new SpecimenContainedPreferenceEnumFactory().fromType(this.castToCode(value));
                    this.preference = value;
                    return value;
                }
                case -410956671: {
                    this.container = (SpecimenDefinitionTypeTestedContainerComponent)((Object)value);
                    return value;
                }
                case 363387971: {
                    this.requirement = this.castToString(value);
                    return value;
                }
                case 1434969867: {
                    this.retentionTime = this.castToDuration(value);
                    return value;
                }
                case -553706344: {
                    this.getRejectionCriterion().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 2072805: {
                    this.getHandling().add((SpecimenDefinitionTypeTestedHandlingComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("isDerived")) {
                this.isDerived = this.castToBoolean(value);
            } else if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("preference")) {
                value = new SpecimenContainedPreferenceEnumFactory().fromType(this.castToCode(value));
                this.preference = value;
            } else if (name.equals(SpecimenDefinition.SP_CONTAINER)) {
                this.container = (SpecimenDefinitionTypeTestedContainerComponent)((Object)value);
            } else if (name.equals("requirement")) {
                this.requirement = this.castToString(value);
            } else if (name.equals("retentionTime")) {
                this.retentionTime = this.castToDuration(value);
            } else if (name.equals("rejectionCriterion")) {
                this.getRejectionCriterion().add(this.castToCodeableConcept(value));
            } else if (name.equals("handling")) {
                this.getHandling().add((SpecimenDefinitionTypeTestedHandlingComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return this.getIsDerivedElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1459831589: {
                    return this.getPreferenceElement();
                }
                case -410956671: {
                    return this.getContainer();
                }
                case 363387971: {
                    return this.getRequirementElement();
                }
                case 1434969867: {
                    return this.getRetentionTime();
                }
                case -553706344: {
                    return this.addRejectionCriterion();
                }
                case 2072805: {
                    return this.addHandling();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return new String[]{"boolean"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1459831589: {
                    return new String[]{"code"};
                }
                case -410956671: {
                    return new String[0];
                }
                case 363387971: {
                    return new String[]{"string"};
                }
                case 1434969867: {
                    return new String[]{"Duration"};
                }
                case -553706344: {
                    return new String[]{"CodeableConcept"};
                }
                case 2072805: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("isDerived")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.isDerived");
            }
            if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("preference")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.preference");
            }
            if (name.equals(SpecimenDefinition.SP_CONTAINER)) {
                this.container = new SpecimenDefinitionTypeTestedContainerComponent();
                return this.container;
            }
            if (name.equals("requirement")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.requirement");
            }
            if (name.equals("retentionTime")) {
                this.retentionTime = new Duration();
                return this.retentionTime;
            }
            if (name.equals("rejectionCriterion")) {
                return this.addRejectionCriterion();
            }
            if (name.equals("handling")) {
                return this.addHandling();
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedComponent copy() {
            SpecimenDefinitionTypeTestedComponent dst = new SpecimenDefinitionTypeTestedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedComponent dst) {
            super.copyValues(dst);
            dst.isDerived = this.isDerived == null ? null : this.isDerived.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.preference = this.preference == null ? null : this.preference.copy();
            dst.container = this.container == null ? null : this.container.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            Duration duration = dst.retentionTime = this.retentionTime == null ? null : this.retentionTime.copy();
            if (this.rejectionCriterion != null) {
                dst.rejectionCriterion = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rejectionCriterion) {
                    dst.rejectionCriterion.add(codeableConcept.copy());
                }
            }
            if (this.handling != null) {
                dst.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
                for (SpecimenDefinitionTypeTestedHandlingComponent specimenDefinitionTypeTestedHandlingComponent : this.handling) {
                    dst.handling.add(specimenDefinitionTypeTestedHandlingComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedComponent o = (SpecimenDefinitionTypeTestedComponent)other_;
            return SpecimenDefinitionTypeTestedComponent.compareDeep(this.isDerived, o.isDerived, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.type, o.type, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.preference, o.preference, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.container, o.container, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.requirement, o.requirement, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.retentionTime, o.retentionTime, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.rejectionCriterion, o.rejectionCriterion, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.handling, o.handling, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedComponent o = (SpecimenDefinitionTypeTestedComponent)other_;
            return SpecimenDefinitionTypeTestedComponent.compareValues(this.isDerived, o.isDerived, true) && SpecimenDefinitionTypeTestedComponent.compareValues(this.preference, o.preference, true) && SpecimenDefinitionTypeTestedComponent.compareValues(this.requirement, o.requirement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.isDerived, this.type, this.preference, this.container, this.requirement, this.retentionTime, this.rejectionCriterion, this.handling});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested";
        }
    }

    public static class SpecimenContainedPreferenceEnumFactory
    implements EnumFactory<SpecimenContainedPreference> {
        @Override
        public SpecimenContainedPreference fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return SpecimenContainedPreference.PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return SpecimenContainedPreference.ALTERNATE;
            }
            throw new IllegalArgumentException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public Enumeration<SpecimenContainedPreference> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenContainedPreference>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.PREFERRED);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.ALTERNATE);
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenContainedPreference code) {
            if (code == SpecimenContainedPreference.PREFERRED) {
                return "preferred";
            }
            if (code == SpecimenContainedPreference.ALTERNATE) {
                return "alternate";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenContainedPreference code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenContainedPreference {
        PREFERRED,
        ALTERNATE,
        NULL;


        public static SpecimenContainedPreference fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREFERRED: {
                    return "preferred";
                }
                case ALTERNATE: {
                    return "alternate";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREFERRED: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREFERRED: {
                    return "This type of contained specimen is preferred to collect this kind of specimen.";
                }
                case ALTERNATE: {
                    return "This type of conditioned specimen is an alternate.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREFERRED: {
                    return "Preferred";
                }
                case ALTERNATE: {
                    return "Alternate";
                }
            }
            return "?";
        }
    }
}

