/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CdshooksIndicator {
    INFO,
    WARNING,
    CRITICAL,
    NULL;


    public static CdshooksIndicator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("info".equals(codeString)) {
            return INFO;
        }
        if ("warning".equals(codeString)) {
            return WARNING;
        }
        if ("critical".equals(codeString)) {
            return CRITICAL;
        }
        throw new FHIRException("Unknown CdshooksIndicator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INFO: {
                return "info";
            }
            case WARNING: {
                return "warning";
            }
            case CRITICAL: {
                return "critical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://cds-hooks.hl7.org/CodeSystem/indicator";
    }

    public String getDefinition() {
        switch (this) {
            case INFO: {
                return "";
            }
            case WARNING: {
                return "";
            }
            case CRITICAL: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INFO: {
                return "The response is informational";
            }
            case WARNING: {
                return "The response is a warning";
            }
            case CRITICAL: {
                return "The response is critical and indicates the workflow should not be allowed to proceed";
            }
        }
        return "?";
    }
}

