/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import org.hl7.fhir.r4.model.ImplementationGuide;

public class IGHelper {
    public static String readStringParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, ImplementationGuide.GuideParameterCode name) {
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent p : ig.getParameter()) {
            if (!name.toCode().equals(p.getCode())) continue;
            return p.getValue();
        }
        return null;
    }

    public static boolean getBooleanParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, ImplementationGuide.GuideParameterCode name, boolean defaultValue) {
        String v = IGHelper.readStringParameter(ig, name);
        return v == null ? false : Boolean.parseBoolean(v);
    }

    public static void setParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, ImplementationGuide.GuideParameterCode name, String value) {
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent p : ig.getParameter()) {
            if (!name.toCode().equals(p.getCode())) continue;
            p.setValue(value);
            return;
        }
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent p = ig.addParameter();
        p.setCode(name.toCode());
        p.setValue(value);
    }

    public static void setParameter(ImplementationGuide.ImplementationGuideDefinitionComponent ig, ImplementationGuide.GuideParameterCode name, boolean value) {
        IGHelper.setParameter(ig, name, Boolean.toString(value));
    }
}

