/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PrecisionEstimateType {
    CI,
    IQR,
    SD,
    SE,
    NULL;


    public static PrecisionEstimateType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("CI".equals(codeString)) {
            return CI;
        }
        if ("IQR".equals(codeString)) {
            return IQR;
        }
        if ("SD".equals(codeString)) {
            return SD;
        }
        if ("SE".equals(codeString)) {
            return SE;
        }
        throw new FHIRException("Unknown PrecisionEstimateType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CI: {
                return "CI";
            }
            case IQR: {
                return "IQR";
            }
            case SD: {
                return "SD";
            }
            case SE: {
                return "SE";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/precision-estimate-type";
    }

    public String getDefinition() {
        switch (this) {
            case CI: {
                return "confidence interval.";
            }
            case IQR: {
                return "interquartile range.";
            }
            case SD: {
                return "standard deviation.";
            }
            case SE: {
                return "standard error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CI: {
                return "confidence interval";
            }
            case IQR: {
                return "interquartile range";
            }
            case SD: {
                return "standard deviation";
            }
            case SE: {
                return "standard error";
            }
        }
        return "?";
    }
}

