/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.util.ElementUtil;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Quantity;

@DatatypeDef(name="MoneyQuantity", profileOf=Quantity.class)
public class MoneyQuantity
extends Quantity {
    private static final long serialVersionUID = 1069574054L;

    @Override
    public MoneyQuantity copy() {
        MoneyQuantity dst = new MoneyQuantity();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MoneyQuantity dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.comparator = this.comparator == null ? null : this.comparator.copy();
        dst.unit = this.unit == null ? null : this.unit.copy();
        dst.system = this.system == null ? null : this.system.copy();
        dst.code = this.code == null ? null : this.code.copy();
    }

    @Override
    protected MoneyQuantity typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MoneyQuantity)) {
            return false;
        }
        MoneyQuantity o = (MoneyQuantity)other_;
        return MoneyQuantity.compareDeep(this.value, o.value, true) && MoneyQuantity.compareDeep(this.comparator, o.comparator, true) && MoneyQuantity.compareDeep(this.unit, o.unit, true) && MoneyQuantity.compareDeep(this.system, o.system, true) && MoneyQuantity.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MoneyQuantity)) {
            return false;
        }
        MoneyQuantity o = (MoneyQuantity)other_;
        return MoneyQuantity.compareValues(this.value, o.value, true) && MoneyQuantity.compareValues(this.comparator, o.comparator, true) && MoneyQuantity.compareValues(this.unit, o.unit, true) && MoneyQuantity.compareValues(this.system, o.system, true) && MoneyQuantity.compareValues(this.code, o.code, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.comparator, this.unit, this.system, this.code});
    }
}

