/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PermittedDataType {
    QUANTITY,
    CODEABLECONCEPT,
    STRING,
    BOOLEAN,
    INTEGER,
    RANGE,
    RATIO,
    SAMPLEDDATA,
    TIME,
    DATETIME,
    PERIOD,
    NULL;


    public static PermittedDataType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Quantity".equals(codeString)) {
            return QUANTITY;
        }
        if ("CodeableConcept".equals(codeString)) {
            return CODEABLECONCEPT;
        }
        if ("string".equals(codeString)) {
            return STRING;
        }
        if ("boolean".equals(codeString)) {
            return BOOLEAN;
        }
        if ("integer".equals(codeString)) {
            return INTEGER;
        }
        if ("Range".equals(codeString)) {
            return RANGE;
        }
        if ("Ratio".equals(codeString)) {
            return RATIO;
        }
        if ("SampledData".equals(codeString)) {
            return SAMPLEDDATA;
        }
        if ("time".equals(codeString)) {
            return TIME;
        }
        if ("dateTime".equals(codeString)) {
            return DATETIME;
        }
        if ("Period".equals(codeString)) {
            return PERIOD;
        }
        throw new FHIRException("Unknown PermittedDataType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case QUANTITY: {
                return "Quantity";
            }
            case CODEABLECONCEPT: {
                return "CodeableConcept";
            }
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "integer";
            }
            case RANGE: {
                return "Range";
            }
            case RATIO: {
                return "Ratio";
            }
            case SAMPLEDDATA: {
                return "SampledData";
            }
            case TIME: {
                return "time";
            }
            case DATETIME: {
                return "dateTime";
            }
            case PERIOD: {
                return "Period";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/permitted-data-type";
    }

    public String getDefinition() {
        switch (this) {
            case QUANTITY: {
                return "A measured amount.";
            }
            case CODEABLECONCEPT: {
                return "A coded concept from a reference terminology and/or text.";
            }
            case STRING: {
                return "A sequence of Unicode characters.";
            }
            case BOOLEAN: {
                return "true or false.";
            }
            case INTEGER: {
                return "A signed integer.";
            }
            case RANGE: {
                return "A set of values bounded by low and high.";
            }
            case RATIO: {
                return "A ratio of two Quantity values - a numerator and a denominator.";
            }
            case SAMPLEDDATA: {
                return "A series of measurements taken by a device.";
            }
            case TIME: {
                return "A time during the day, in the format hh:mm:ss.";
            }
            case DATETIME: {
                return "A date, date-time or partial date (e.g. just year or year + month) as used in human communication.";
            }
            case PERIOD: {
                return "A time range defined by start and end date/time.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case QUANTITY: {
                return "Quantity";
            }
            case CODEABLECONCEPT: {
                return "CodeableConcept";
            }
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "integer";
            }
            case RANGE: {
                return "Range";
            }
            case RATIO: {
                return "Ratio";
            }
            case SAMPLEDDATA: {
                return "SampledData";
            }
            case TIME: {
                return "time";
            }
            case DATETIME: {
                return "dateTime";
            }
            case PERIOD: {
                return "Period";
            }
        }
        return "?";
    }
}

