/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ClaimUse;

public class ClaimUseEnumFactory
implements EnumFactory<ClaimUse> {
    @Override
    public ClaimUse fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("claim".equals(codeString)) {
            return ClaimUse.CLAIM;
        }
        if ("preauthorization".equals(codeString)) {
            return ClaimUse.PREAUTHORIZATION;
        }
        if ("predetermination".equals(codeString)) {
            return ClaimUse.PREDETERMINATION;
        }
        throw new IllegalArgumentException("Unknown ClaimUse code '" + codeString + "'");
    }

    @Override
    public String toCode(ClaimUse code) {
        if (code == ClaimUse.CLAIM) {
            return "claim";
        }
        if (code == ClaimUse.PREAUTHORIZATION) {
            return "preauthorization";
        }
        if (code == ClaimUse.PREDETERMINATION) {
            return "predetermination";
        }
        return "?";
    }

    @Override
    public String toSystem(ClaimUse code) {
        return code.getSystem();
    }
}

