/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DocumentMode {
    PRODUCER,
    CONSUMER,
    NULL;


    public static DocumentMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("producer".equals(codeString)) {
            return PRODUCER;
        }
        if ("consumer".equals(codeString)) {
            return CONSUMER;
        }
        throw new FHIRException("Unknown DocumentMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRODUCER: {
                return "producer";
            }
            case CONSUMER: {
                return "consumer";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/document-mode";
    }

    public String getDefinition() {
        switch (this) {
            case PRODUCER: {
                return "The application produces documents of the specified type.";
            }
            case CONSUMER: {
                return "The application consumes documents of the specified type.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRODUCER: {
                return "Producer";
            }
            case CONSUMER: {
                return "Consumer";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

