/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ImmunizationOrigin;

public class ImmunizationOriginEnumFactory
implements EnumFactory<ImmunizationOrigin> {
    @Override
    public ImmunizationOrigin fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("provider".equals(codeString)) {
            return ImmunizationOrigin.PROVIDER;
        }
        if ("record".equals(codeString)) {
            return ImmunizationOrigin.RECORD;
        }
        if ("recall".equals(codeString)) {
            return ImmunizationOrigin.RECALL;
        }
        if ("school".equals(codeString)) {
            return ImmunizationOrigin.SCHOOL;
        }
        if ("jurisdiction".equals(codeString)) {
            return ImmunizationOrigin.JURISDICTION;
        }
        throw new IllegalArgumentException("Unknown ImmunizationOrigin code '" + codeString + "'");
    }

    @Override
    public String toCode(ImmunizationOrigin code) {
        if (code == ImmunizationOrigin.PROVIDER) {
            return "provider";
        }
        if (code == ImmunizationOrigin.RECORD) {
            return "record";
        }
        if (code == ImmunizationOrigin.RECALL) {
            return "recall";
        }
        if (code == ImmunizationOrigin.SCHOOL) {
            return "school";
        }
        if (code == ImmunizationOrigin.JURISDICTION) {
            return "jurisdiction";
        }
        return "?";
    }

    @Override
    public String toSystem(ImmunizationOrigin code) {
        return code.getSystem();
    }
}

