/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationAdminCategory {
    INPATIENT,
    OUTPATIENT,
    COMMUNITY,
    NULL;


    public static MedicationAdminCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return COMMUNITY;
        }
        throw new FHIRException("Unknown MedicationAdminCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPATIENT: {
                return "inpatient";
            }
            case OUTPATIENT: {
                return "outpatient";
            }
            case COMMUNITY: {
                return "community";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/medication-admin-category";
    }

    public String getDefinition() {
        switch (this) {
            case INPATIENT: {
                return "Includes administrations in an inpatient or acute care setting";
            }
            case OUTPATIENT: {
                return "Includes administrations in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)";
            }
            case COMMUNITY: {
                return "Includes administrations by the patient in their home (this would include long term care or nursing homes, hospices, etc.)";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPATIENT: {
                return "Inpatient";
            }
            case OUTPATIENT: {
                return "Outpatient";
            }
            case COMMUNITY: {
                return "Community";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

