/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CatalogType;

public class CatalogTypeEnumFactory
implements EnumFactory<CatalogType> {
    @Override
    public CatalogType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return CatalogType.MEDICATION;
        }
        if ("device".equals(codeString)) {
            return CatalogType.DEVICE;
        }
        if ("protocol".equals(codeString)) {
            return CatalogType.PROTOCOL;
        }
        throw new IllegalArgumentException("Unknown CatalogType code '" + codeString + "'");
    }

    @Override
    public String toCode(CatalogType code) {
        if (code == CatalogType.MEDICATION) {
            return "medication";
        }
        if (code == CatalogType.DEVICE) {
            return "device";
        }
        if (code == CatalogType.PROTOCOL) {
            return "protocol";
        }
        return "?";
    }

    @Override
    public String toSystem(CatalogType code) {
        return code.getSystem();
    }
}

