package org.hl7.fhir.r4.formats;

import java.io.IOException;

import org.hl7.fhir.exceptions.FHIRFormatError;



/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Thu, Dec 13, 2018 14:07+1100 for FHIR v4.0.0
import org.hl7.fhir.r4.model.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser.PresentedBigDecimal;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class JsonParser extends JsonParserBase {

  public JsonParser() {
    super();
  }

  public JsonParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  public JsonParser(boolean allowUnknownContent, boolean allowComments) {
    super();
    setAllowUnknownContent(allowUnknownContent);
    setAllowComments(allowComments);
  }

  protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    super.parseElementProperties(json, element);
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        element.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseBackboneElementProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseBackboneElementProperties(JsonObject json, BackboneType element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
    UrlType res = new UrlType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    if (v instanceof PresentedBigDecimal)
      res.setRepresentation(((PresentedBigDecimal) v).getPresentation());
    return res;
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseExtensionProperties(json, res);
    return res;
  }

  protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseNarrativeProperties(json, res);
    return res;
  }

  protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseMetaProperties(json, res);
    return res;
  }

  protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(getJObject(json, "_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(getJObject(json, "_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("security")) {
      JsonArray array = json.getAsJsonArray("security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseAddressProperties(json, res);
    return res;
  }

  protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = json.getAsJsonArray("line");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLine().add(new StringType());
        } else {
          res.getLine().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_line")) {
      JsonArray array = json.getAsJsonArray("_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
      }
    };
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(getJObject(json, "_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(getJObject(json, "_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(getJObject(json, "_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(getJObject(json, "_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(getJObject(json, "_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseContributorProperties(json, res);
    return res;
  }

  protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseAttachmentProperties(json, res);
    return res;
  }

  protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(getJObject(json, "_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseUnsignedInt(json.get("size").getAsString()));
    if (json.has("_size"))
      parseElementProperties(getJObject(json, "_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(getJObject(json, "_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(getJObject(json, "_creation"), res.getCreationElement());
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseCountProperties(json, res);
    return res;
  }

  protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseDataRequirementProperties(json, res);
    return res;
  }

  protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getMustSupport().add(new StringType());
        } else {
          res.getMustSupport().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    };
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter().add(parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter().add(parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("limit"))
      res.setLimitElement(parsePositiveInt(json.get("limit").getAsString()));
    if (json.has("_limit"))
      parseElementProperties(getJObject(json, "_limit"), res.getLimitElement());
    if (json.has("sort")) {
      JsonArray array = json.getAsJsonArray("sort");
      for (int i = 0; i < array.size(); i++) {
        res.getSort().add(parseDataRequirementDataRequirementSortComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseDataRequirementDataRequirementCodeFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(getJObject(json, "_searchParam"), res.getSearchParamElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseDataRequirementDataRequirementDateFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(getJObject(json, "_searchParam"), res.getSearchParamElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementDataRequirementSortComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseDataRequirementDataRequirementSortComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementSortComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(getJObject(json, "_direction"), res.getDirectionElement());
  }

  protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseDosageProperties(json, res);
    return res;
  }

  protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("additionalInstruction")) {
      JsonArray array = json.getAsJsonArray("additionalInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalInstruction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(getJObject(json, "timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("site"))
      res.setSite(parseCodeableConcept(getJObject(json, "site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(getJObject(json, "route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("doseAndRate")) {
      JsonArray array = json.getAsJsonArray("doseAndRate");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseAndRate().add(parseDosageDosageDoseAndRateComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(getJObject(json, "maxDosePerPeriod")));
    if (json.has("maxDosePerAdministration"))
      res.setMaxDosePerAdministration(parseQuantity(getJObject(json, "maxDosePerAdministration")));
    if (json.has("maxDosePerLifetime"))
      res.setMaxDosePerLifetime(parseQuantity(getJObject(json, "maxDosePerLifetime")));
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDosageDoseAndRateComponent(JsonObject json, Dosage owner) throws IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseDosageDosageDoseAndRateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDosageDosageDoseAndRateComponentProperties(JsonObject json, Dosage owner, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseMoneyProperties(json, res);
    return res;
  }

  protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("currency"))
      res.setCurrencyElement(parseCode(json.get("currency").getAsString()));
    if (json.has("_currency"))
      parseElementProperties(getJObject(json, "_currency"), res.getCurrencyElement());
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseHumanNameProperties(json, res);
    return res;
  }

  protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("family"))
      res.setFamilyElement(parseString(json.get("family").getAsString()));
    if (json.has("_family"))
      parseElementProperties(getJObject(json, "_family"), res.getFamilyElement());
    if (json.has("given")) {
      JsonArray array = json.getAsJsonArray("given");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getGiven().add(new StringType());
        } else {
          res.getGiven().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_given")) {
      JsonArray array = json.getAsJsonArray("_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
      }
    };
    if (json.has("prefix")) {
      JsonArray array = json.getAsJsonArray("prefix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPrefix().add(new StringType());
        } else {
          res.getPrefix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_prefix")) {
      JsonArray array = json.getAsJsonArray("_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
      }
    };
    if (json.has("suffix")) {
      JsonArray array = json.getAsJsonArray("suffix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSuffix().add(new StringType());
        } else {
          res.getSuffix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_suffix")) {
      JsonArray array = json.getAsJsonArray("_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseContactPointProperties(json, res);
    return res;
  }

  protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(getJObject(json, "_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseMarketingStatusProperties(json, res);
    return res;
  }

  protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(getJObject(json, "country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(getJObject(json, "jurisdiction")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("dateRange"))
      res.setDateRange(parsePeriod(getJObject(json, "dateRange")));
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(getJObject(json, "_restoreDate"), res.getRestoreDateElement());
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseIdentifierProperties(json, res);
    return res;
  }

  protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(getJObject(json, "assigner")));
  }

  protected SubstanceAmount parseSubstanceAmount(JsonObject json) throws IOException, FHIRFormatError {
    SubstanceAmount res = new SubstanceAmount();
    parseSubstanceAmountProperties(json, res);
    return res;
  }

  protected void parseSubstanceAmountProperties(JsonObject json, SubstanceAmount res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type amount = parseType("amount", json);
    if (amount != null)
      res.setAmount(amount);
    if (json.has("amountType"))
      res.setAmountType(parseCodeableConcept(getJObject(json, "amountType")));
    if (json.has("amountText"))
      res.setAmountTextElement(parseString(json.get("amountText").getAsString()));
    if (json.has("_amountText"))
      parseElementProperties(getJObject(json, "_amountText"), res.getAmountTextElement());
    if (json.has("referenceRange"))
      res.setReferenceRange(parseSubstanceAmountSubstanceAmountReferenceRangeComponent(getJObject(json, "referenceRange"), res));
  }

  protected SubstanceAmount.SubstanceAmountReferenceRangeComponent parseSubstanceAmountSubstanceAmountReferenceRangeComponent(JsonObject json, SubstanceAmount owner) throws IOException, FHIRFormatError {
    SubstanceAmount.SubstanceAmountReferenceRangeComponent res = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
    parseSubstanceAmountSubstanceAmountReferenceRangeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSubstanceAmountSubstanceAmountReferenceRangeComponentProperties(JsonObject json, SubstanceAmount owner, SubstanceAmount.SubstanceAmountReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("lowLimit"))
      res.setLowLimit(parseQuantity(getJObject(json, "lowLimit")));
    if (json.has("highLimit"))
      res.setHighLimit(parseQuantity(getJObject(json, "highLimit")));
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseCodingProperties(json, res);
    return res;
  }

  protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(getJObject(json, "_userSelected"), res.getUserSelectedElement());
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseSampledDataProperties(json, res);
    return res;
  }

  protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseQuantity(getJObject(json, "origin")));
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(getJObject(json, "_period"), res.getPeriodElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(getJObject(json, "_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(getJObject(json, "_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(getJObject(json, "_dimensions"), res.getDimensionsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected Population parsePopulation(JsonObject json) throws IOException, FHIRFormatError {
    Population res = new Population();
    parsePopulationProperties(json, res);
    return res;
  }

  protected void parsePopulationProperties(JsonObject json, Population res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(getJObject(json, "gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(getJObject(json, "race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(getJObject(json, "physiologicalCondition")));
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseRatioProperties(json, res);
    return res;
  }

  protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(getJObject(json, "numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(getJObject(json, "denominator")));
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseDistanceProperties(json, res);
    return res;
  }

  protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseAgeProperties(json, res);
    return res;
  }

  protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseReferenceProperties(json, res);
    return res;
  }

  protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
    if (json.has("type"))
      res.setTypeElement(parseUri(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTriggerDefinitionProperties(json, res);
    return res;
  }

  protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition"))
      res.setCondition(parseExpression(getJObject(json, "condition")));
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseQuantityProperties(json, res);
    return res;
  }

  protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(getJObject(json, "_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(getJObject(json, "_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parsePeriodProperties(json, res);
    return res;
  }

  protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseDurationProperties(json, res);
    return res;
  }

  protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseRangeProperties(json, res);
    return res;
  }

  protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(getJObject(json, "low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(getJObject(json, "high")));
  }

  protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseRelatedArtifactProperties(json, res);
    return res;
  }

  protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseMarkdown(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(getJObject(json, "_citation"), res.getCitationElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(getJObject(json, "document")));
    if (json.has("resource"))
      res.setResourceElement(parseCanonical(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(getJObject(json, "_resource"), res.getResourceElement());
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseAnnotationProperties(json, res);
    return res;
  }

  protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseProductShelfLifeProperties(json, res);
    return res;
  }

  protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("period"))
      res.setPeriod(parseQuantity(getJObject(json, "period")));
    if (json.has("specialPrecautionsForStorage")) {
      JsonArray array = json.getAsJsonArray("specialPrecautionsForStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseContactDetailProperties(json, res);
    return res;
  }

  protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseUsageContextProperties(json, res);
    return res;
  }

  protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(getJObject(json, "code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
    Expression res = new Expression();
    parseExpressionProperties(json, res);
    return res;
  }

  protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseSignatureProperties(json, res);
    return res;
  }

  protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(getJObject(json, "_when"), res.getWhenElement());
    if (json.has("who"))
      res.setWho(parseReference(getJObject(json, "who")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(getJObject(json, "onBehalfOf")));
    if (json.has("targetFormat"))
      res.setTargetFormatElement(parseCode(json.get("targetFormat").getAsString()));
    if (json.has("_targetFormat"))
      parseElementProperties(getJObject(json, "_targetFormat"), res.getTargetFormatElement());
    if (json.has("sigFormat"))
      res.setSigFormatElement(parseCode(json.get("sigFormat").getAsString()));
    if (json.has("_sigFormat"))
      parseElementProperties(getJObject(json, "_sigFormat"), res.getSigFormatElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTimingProperties(json, res);
    return res;
  }

  protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getEvent().add(new DateTimeType());
        } else {
          res.getEvent().add(parseDateTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_event")) {
      JsonArray array = json.getAsJsonArray("_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
      }
    };
    if (json.has("repeat"))
      res.setRepeat(parseTimingTimingRepeatComponent(getJObject(json, "repeat"), res));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseTimingTimingRepeatComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTimingTimingRepeatComponentProperties(JsonObject json, Timing owner, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parsePositiveInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parsePositiveInt(json.get("countMax").getAsString()));
    if (json.has("_countMax"))
      parseElementProperties(getJObject(json, "_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(getJObject(json, "_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(getJObject(json, "_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(getJObject(json, "_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parsePositiveInt(json.get("frequency").getAsString()));
    if (json.has("_frequency"))
      parseElementProperties(getJObject(json, "_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parsePositiveInt(json.get("frequencyMax").getAsString()));
    if (json.has("_frequencyMax"))
      parseElementProperties(getJObject(json, "_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(getJObject(json, "_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(getJObject(json, "_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(getJObject(json, "_periodUnit"), res.getPeriodUnitElement());
    if (json.has("dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDayOfWeek().add(new Enumeration<Timing.DayOfWeek>());
        } else {
          res.getDayOfWeek().add(parseEnumeration(array.get(i).getAsString(), Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("_dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDayOfWeek().size())
          res.getDayOfWeek().add(parseEnumeration(null, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
      }
    };
    if (json.has("timeOfDay")) {
      JsonArray array = json.getAsJsonArray("timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTimeOfDay().add(new TimeType());
        } else {
          res.getTimeOfDay().add(parseTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_timeOfDay")) {
      JsonArray array = json.getAsJsonArray("_timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTimeOfDay().size())
          res.getTimeOfDay().add(parseTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
      }
    };
    if (json.has("when")) {
      JsonArray array = json.getAsJsonArray("when");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getWhen().add(new Enumeration<Timing.EventTiming>());
        } else {
          res.getWhen().add(parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        }
      }
    };
    if (json.has("_when")) {
      JsonArray array = json.getAsJsonArray("_when");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWhen().size())
          res.getWhen().add(parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
      }
    };
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(getJObject(json, "_offset"), res.getOffsetElement());
  }

  protected ProdCharacteristic parseProdCharacteristic(JsonObject json) throws IOException, FHIRFormatError {
    ProdCharacteristic res = new ProdCharacteristic();
    parseProdCharacteristicProperties(json, res);
    return res;
  }

  protected void parseProdCharacteristicProperties(JsonObject json, ProdCharacteristic res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("height"))
      res.setHeight(parseQuantity(getJObject(json, "height")));
    if (json.has("width"))
      res.setWidth(parseQuantity(getJObject(json, "width")));
    if (json.has("depth"))
      res.setDepth(parseQuantity(getJObject(json, "depth")));
    if (json.has("weight"))
      res.setWeight(parseQuantity(getJObject(json, "weight")));
    if (json.has("nominalVolume"))
      res.setNominalVolume(parseQuantity(getJObject(json, "nominalVolume")));
    if (json.has("externalDiameter"))
      res.setExternalDiameter(parseQuantity(getJObject(json, "externalDiameter")));
    if (json.has("shape"))
      res.setShapeElement(parseString(json.get("shape").getAsString()));
    if (json.has("_shape"))
      parseElementProperties(getJObject(json, "_shape"), res.getShapeElement());
    if (json.has("color")) {
      JsonArray array = json.getAsJsonArray("color");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getColor().add(new StringType());
        } else {
          res.getColor().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_color")) {
      JsonArray array = json.getAsJsonArray("_color");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getColor().size())
          res.getColor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getColor().get(i));
      }
    };
    if (json.has("imprint")) {
      JsonArray array = json.getAsJsonArray("imprint");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImprint().add(new StringType());
        } else {
          res.getImprint().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imprint")) {
      JsonArray array = json.getAsJsonArray("_imprint");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImprint().size())
          res.getImprint().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImprint().get(i));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(getJObject(json, "scoring")));
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseCodeableConceptProperties(json, res);
    return res;
  }

  protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = json.getAsJsonArray("coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseParameterDefinitionProperties(json, res);
    return res;
  }

  protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementDefinitionProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = json.getAsJsonArray("representation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRepresentation().add(new Enumeration<ElementDefinition.PropertyRepresentation>());
        } else {
          res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        }
      }
    };
    if (json.has("_representation")) {
      JsonArray array = json.getAsJsonArray("_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRepresentation().get(i));
      }
    };
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(getJObject(json, "_sliceName"), res.getSliceNameElement());
    if (json.has("sliceIsConstraining"))
      res.setSliceIsConstrainingElement(parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
    if (json.has("_sliceIsConstraining"))
      parseElementProperties(getJObject(json, "_sliceIsConstraining"), res.getSliceIsConstrainingElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(getJObject(json, "slicing"), res));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(getJObject(json, "_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(getJObject(json, "_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionElementDefinitionBaseComponent(getJObject(json, "base"), res));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(getJObject(json, "_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(getJObject(json, "_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    if (json.has("orderMeaning"))
      res.setOrderMeaningElement(parseString(json.get("orderMeaning").getAsString()));
    if (json.has("_orderMeaning"))
      parseElementProperties(getJObject(json, "_orderMeaning"), res.getOrderMeaningElement());
    Type fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    Type pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    if (json.has("example")) {
      JsonArray array = json.getAsJsonArray("example");
      for (int i = 0; i < array.size(); i++) {
        res.getExample().add(parseElementDefinitionElementDefinitionExampleComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    Type maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(getJObject(json, "_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCondition().add(new IdType());
        } else {
          res.getCondition().add(parseId(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_condition")) {
      JsonArray array = json.getAsJsonArray("_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
      }
    };
    if (json.has("constraint")) {
      JsonArray array = json.getAsJsonArray("constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint().add(parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(getJObject(json, "_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(getJObject(json, "_isModifier"), res.getIsModifierElement());
    if (json.has("isModifierReason"))
      res.setIsModifierReasonElement(parseString(json.get("isModifierReason").getAsString()));
    if (json.has("_isModifierReason"))
      parseElementProperties(getJObject(json, "_isModifierReason"), res.getIsModifierReasonElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(getJObject(json, "_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(getJObject(json, "binding"), res));
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementDefinitionElementDefinitionSlicingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = json.getAsJsonArray("discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(getJObject(json, "_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(getJObject(json, "_rules"), res.getRulesElement());
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementDefinitionElementDefinitionBaseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementDefinitionTypeRefComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseUri(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("targetProfile")) {
      JsonArray array = json.getAsJsonArray("targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTargetProfile().add(new CanonicalType());
        } else {
          res.getTargetProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_targetProfile")) {
      JsonArray array = json.getAsJsonArray("_targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTargetProfile().size())
          res.getTargetProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTargetProfile().get(i));
      }
    };
    if (json.has("aggregation")) {
      JsonArray array = json.getAsJsonArray("aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAggregation().add(new Enumeration<ElementDefinition.AggregationMode>());
        } else {
          res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        }
      }
    };
    if (json.has("_aggregation")) {
      JsonArray array = json.getAsJsonArray("_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(getJObject(json, "_versioning"), res.getVersioningElement());
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementDefinitionElementDefinitionExampleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementDefinitionElementDefinitionConstraintComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(getJObject(json, "_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(getJObject(json, "_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(getJObject(json, "_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(getJObject(json, "_xpath"), res.getXpathElement());
    if (json.has("source"))
      res.setSourceElement(parseCanonical(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementDefinitionElementDefinitionBindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(getJObject(json, "_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementDefinitionElementDefinitionMappingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(getJObject(json, "_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(getJObject(json, "_map"), res.getMapElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(getJObject(json, "text")));
    if (json.has("contained")) {
      JsonArray array = json.getAsJsonArray("contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseParametersProperties(json, res);
    return res;
  }

  protected void parseParametersProperties(JsonObject json, Parameters res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseParametersParametersParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseParametersParametersParameterComponentProperties(JsonObject json, Parameters owner, Parameters.ParametersParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("resource"))
      res.setResource(parseResource(getJObject(json, "resource")));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(getJObject(json, "_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(getJObject(json, "meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(getJObject(json, "_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseAccountProperties(json, res);
    return res;
  }

  protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("servicePeriod"))
      res.setServicePeriod(parsePeriod(getJObject(json, "servicePeriod")));
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseAccountCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("guarantor")) {
      JsonArray array = json.getAsJsonArray("guarantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGuarantor().add(parseAccountGuarantorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(getJObject(json, "partOf")));
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseAccountCoverageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountCoverageComponentProperties(JsonObject json, Account owner, Account.CoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("priority"))
      res.setPriorityElement(parsePositiveInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseAccountGuarantorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountGuarantorComponentProperties(JsonObject json, Account owner, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
    if (json.has("onHold"))
      res.setOnHoldElement(parseBoolean(json.get("onHold").getAsBoolean()));
    if (json.has("_onHold"))
      parseElementProperties(getJObject(json, "_onHold"), res.getOnHoldElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseActivityDefinitionProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), ActivityDefinition.RequestIntent.NULL, new ActivityDefinition.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), ActivityDefinition.RequestPriority.NULL, new ActivityDefinition.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseActivityDefinitionActivityDefinitionParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimenRequirement")) {
      JsonArray array = json.getAsJsonArray("specimenRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimenRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationRequirement")) {
      JsonArray array = json.getAsJsonArray("observationRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationResultRequirement")) {
      JsonArray array = json.getAsJsonArray("observationResultRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationResultRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("transform"))
      res.setTransformElement(parseCanonical(json.get("transform").getAsString()));
    if (json.has("_transform"))
      parseElementProperties(getJObject(json, "_transform"), res.getTransformElement());
    if (json.has("dynamicValue")) {
      JsonArray array = json.getAsJsonArray("dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parseActivityDefinitionActivityDefinitionDynamicValueComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseActivityDefinitionActivityDefinitionParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("expression"))
      res.setExpression(parseExpression(getJObject(json, "expression")));
  }

  protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseAdverseEventProperties(json, res);
    return res;
  }

  protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("actuality"))
      res.setActualityElement(parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
    if (json.has("_actuality"))
      parseElementProperties(getJObject(json, "_actuality"), res.getActualityElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event"))
      res.setEvent(parseCodeableConcept(getJObject(json, "event")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("detected"))
      res.setDetectedElement(parseDateTime(json.get("detected").getAsString()));
    if (json.has("_detected"))
      parseElementProperties(getJObject(json, "_detected"), res.getDetectedElement());
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("resultingCondition")) {
      JsonArray array = json.getAsJsonArray("resultingCondition");
      for (int i = 0; i < array.size(); i++) {
        res.getResultingCondition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("seriousness"))
      res.setSeriousness(parseCodeableConcept(getJObject(json, "seriousness")));
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(getJObject(json, "severity")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(getJObject(json, "outcome")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(getJObject(json, "recorder")));
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("suspectEntity")) {
      JsonArray array = json.getAsJsonArray("suspectEntity");
      for (int i = 0; i < array.size(); i++) {
        res.getSuspectEntity().add(parseAdverseEventAdverseEventSuspectEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subjectMedicalHistory")) {
      JsonArray array = json.getAsJsonArray("subjectMedicalHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getSubjectMedicalHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceDocument")) {
      JsonArray array = json.getAsJsonArray("referenceDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseAdverseEventAdverseEventSuspectEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAdverseEventAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("instance"))
      res.setInstance(parseReference(getJObject(json, "instance")));
    if (json.has("causality")) {
      JsonArray array = json.getAsJsonArray("causality");
      for (int i = 0; i < array.size(); i++) {
        res.getCausality().add(parseAdverseEventAdverseEventSuspectEntityCausalityComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventAdverseEventSuspectEntityCausalityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseAdverseEventAdverseEventSuspectEntityCausalityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAdverseEventAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("assessment"))
      res.setAssessment(parseCodeableConcept(getJObject(json, "assessment")));
    if (json.has("productRelatedness"))
      res.setProductRelatednessElement(parseString(json.get("productRelatedness").getAsString()));
    if (json.has("_productRelatedness"))
      parseElementProperties(getJObject(json, "_productRelatedness"), res.getProductRelatednessElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseAllergyIntoleranceProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(getJObject(json, "clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(getJObject(json, "verificationStatus")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCategory().add(new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>());
        } else {
          res.getCategory().add(parseEnumeration(array.get(i).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        }
      }
    };
    if (json.has("_category")) {
      JsonArray array = json.getAsJsonArray("_category");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCategory().size())
          res.getCategory().add(parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCategory().get(i));
      }
    };
    if (json.has("criticality"))
      res.setCriticalityElement(parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(getJObject(json, "_criticality"), res.getCriticalityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(getJObject(json, "recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(getJObject(json, "asserter")));
    if (json.has("lastOccurrence"))
      res.setLastOccurrenceElement(parseDateTime(json.get("lastOccurrence").getAsString()));
    if (json.has("_lastOccurrence"))
      parseElementProperties(getJObject(json, "_lastOccurrence"), res.getLastOccurrenceElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(getJObject(json, "substance")));
    if (json.has("manifestation")) {
      JsonArray array = json.getAsJsonArray("manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(getJObject(json, "_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(getJObject(json, "exposureRoute")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseAppointmentProperties(json, res);
    return res;
  }

  protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("cancelationReason"))
      res.setCancelationReason(parseCodeableConcept(getJObject(json, "cancelationReason")));
    if (json.has("serviceCategory")) {
      JsonArray array = json.getAsJsonArray("serviceCategory");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(getJObject(json, "appointmentType")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseUnsignedInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(getJObject(json, "_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("slot")) {
      JsonArray array = json.getAsJsonArray("slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("requestedPeriod")) {
      JsonArray array = json.getAsJsonArray("requestedPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestedPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseAppointmentAppointmentParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAppointmentAppointmentParticipantComponentProperties(JsonObject json, Appointment owner, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
    if (json.has("required"))
      res.setRequiredElement(parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
    if (json.has("_required"))
      parseElementProperties(getJObject(json, "_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseAppointmentResponseProperties(json, res);
    return res;
  }

  protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(getJObject(json, "appointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
    if (json.has("_participantStatus"))
      parseElementProperties(getJObject(json, "_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseAuditEventProperties(json, res);
    return res;
  }

  protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(getJObject(json, "_action"), res.getActionElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(getJObject(json, "_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("outcomeDesc"))
      res.setOutcomeDescElement(parseString(json.get("outcomeDesc").getAsString()));
    if (json.has("_outcomeDesc"))
      parseElementProperties(getJObject(json, "_outcomeDesc"), res.getOutcomeDescElement());
    if (json.has("purposeOfEvent")) {
      JsonArray array = json.getAsJsonArray("purposeOfEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("source"))
      res.setSource(parseAuditEventAuditEventSourceComponent(getJObject(json, "source"), res));
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseAuditEventAuditEventAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("who"))
      res.setWho(parseReference(getJObject(json, "who")));
    if (json.has("altId"))
      res.setAltIdElement(parseString(json.get("altId").getAsString()));
    if (json.has("_altId"))
      parseElementProperties(getJObject(json, "_altId"), res.getAltIdElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(getJObject(json, "_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPolicy().add(new UriType());
        } else {
          res.getPolicy().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    };
    if (json.has("media"))
      res.setMedia(parseCoding(getJObject(json, "media")));
    if (json.has("network"))
      res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(getJObject(json, "network"), owner));
    if (json.has("purposeOfUse")) {
      JsonArray array = json.getAsJsonArray("purposeOfUse");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfUse().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseAuditEventAuditEventAgentNetworkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("address"))
      res.setAddressElement(parseString(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(getJObject(json, "_address"), res.getAddressElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseAuditEventAuditEventSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventSourceComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site"))
      res.setSiteElement(parseString(json.get("site").getAsString()));
    if (json.has("_site"))
      parseElementProperties(getJObject(json, "_site"), res.getSiteElement());
    if (json.has("observer"))
      res.setObserver(parseReference(getJObject(json, "observer")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseAuditEventAuditEventEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("what"))
      res.setWhat(parseReference(getJObject(json, "what")));
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
    if (json.has("role"))
      res.setRole(parseCoding(getJObject(json, "role")));
    if (json.has("lifecycle"))
      res.setLifecycle(parseCoding(getJObject(json, "lifecycle")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(getJObject(json, "_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseAuditEventAuditEventEntityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseBasicProperties(json, res);
    return res;
  }

  protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDate(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseBinaryProperties(json, res);
    return res;
  }

  protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(getJObject(json, "_contentType"), res.getContentTypeElement());
    if (json.has("securityContext"))
      res.setSecurityContext(parseReference(getJObject(json, "securityContext")));
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseBiologicallyDerivedProductProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productCategory"))
      res.setProductCategoryElement(parseEnumeration(json.get("productCategory").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
    if (json.has("_productCategory"))
      parseElementProperties(getJObject(json, "_productCategory"), res.getProductCategoryElement());
    if (json.has("productCode"))
      res.setProductCode(parseCodeableConcept(getJObject(json, "productCode")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("request")) {
      JsonArray array = json.getAsJsonArray("request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantityElement(parseInteger(json.get("quantity").getAsLong()));
    if (json.has("_quantity"))
      parseElementProperties(getJObject(json, "_quantity"), res.getQuantityElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("collection"))
      res.setCollection(parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(getJObject(json, "collection"), res));
    if (json.has("processing")) {
      JsonArray array = json.getAsJsonArray("processing");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessing().add(parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("manipulation"))
      res.setManipulation(parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(getJObject(json, "manipulation"), res));
    if (json.has("storage")) {
      JsonArray array = json.getAsJsonArray("storage");
      for (int i = 0; i < array.size(); i++) {
        res.getStorage().add(parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(getJObject(json, "collector")));
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    Type collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("procedure"))
      res.setProcedure(parseCodeableConcept(getJObject(json, "procedure")));
    if (json.has("additive"))
      res.setAdditive(parseReference(getJObject(json, "additive")));
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("temperature"))
      res.setTemperatureElement(parseDecimal(json.get("temperature").getAsBigDecimal()));
    if (json.has("_temperature"))
      parseElementProperties(getJObject(json, "_temperature"), res.getTemperatureElement());
    if (json.has("scale"))
      res.setScaleElement(parseEnumeration(json.get("scale").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
    if (json.has("_scale"))
      parseElementProperties(getJObject(json, "_scale"), res.getScaleElement());
    if (json.has("duration"))
      res.setDuration(parsePeriod(getJObject(json, "duration")));
  }

  protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseBodyStructureProperties(json, res);
    return res;
  }

  protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("morphology"))
      res.setMorphology(parseCodeableConcept(getJObject(json, "morphology")));
    if (json.has("location"))
      res.setLocation(parseCodeableConcept(getJObject(json, "location")));
    if (json.has("locationQualifier")) {
      JsonArray array = json.getAsJsonArray("locationQualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getLocationQualifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseBundleProperties(json, res);
    return res;
  }

  protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(getJObject(json, "_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(getJObject(json, "_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("signature"))
      res.setSignature(parseSignature(getJObject(json, "signature")));
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBundleBundleLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleLinkComponentProperties(JsonObject json, Bundle owner, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseString(json.get("relation").getAsString()));
    if (json.has("_relation"))
      parseElementProperties(getJObject(json, "_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBundleBundleEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(getJObject(json, "_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(getJObject(json, "resource")));
    if (json.has("search"))
      res.setSearch(parseBundleBundleEntrySearchComponent(getJObject(json, "search"), owner));
    if (json.has("request"))
      res.setRequest(parseBundleBundleEntryRequestComponent(getJObject(json, "request"), owner));
    if (json.has("response"))
      res.setResponse(parseBundleBundleEntryResponseComponent(getJObject(json, "response"), owner));
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBundleBundleEntrySearchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntrySearchComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(getJObject(json, "_score"), res.getScoreElement());
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBundleBundleEntryRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryRequestComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(getJObject(json, "_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(getJObject(json, "_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(getJObject(json, "_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(getJObject(json, "_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(getJObject(json, "_ifNoneExist"), res.getIfNoneExistElement());
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBundleBundleEntryResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryResponseComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(getJObject(json, "_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(getJObject(json, "_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(getJObject(json, "_lastModified"), res.getLastModifiedElement());
    if (json.has("outcome"))
      res.setOutcome(parseResource(getJObject(json, "outcome")));
  }

  protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseCapabilityStatementProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new CanonicalType());
        } else {
          res.getInstantiates().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("imports")) {
      JsonArray array = json.getAsJsonArray("imports");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImports().add(new CanonicalType());
        } else {
          res.getImports().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imports")) {
      JsonArray array = json.getAsJsonArray("_imports");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImports().size())
          res.getImports().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatementCapabilityStatementSoftwareComponent(getJObject(json, "software"), res));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatementCapabilityStatementImplementationComponent(getJObject(json, "implementation"), res));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    if (json.has("_fhirVersion"))
      parseElementProperties(getJObject(json, "_fhirVersion"), res.getFhirVersionElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFormat().add(new CodeType());
        } else {
          res.getFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = json.getAsJsonArray("patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPatchFormat().add(new CodeType());
        } else {
          res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = json.getAsJsonArray("_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = json.getAsJsonArray("implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImplementationGuide().add(new CanonicalType());
        } else {
          res.getImplementationGuide().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = json.getAsJsonArray("_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatementCapabilityStatementRestComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("messaging")) {
      JsonArray array = json.getAsJsonArray("messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseCapabilityStatementCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("document")) {
      JsonArray array = json.getAsJsonArray("document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseCapabilityStatementCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(getJObject(json, "_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseCapabilityStatementCapabilityStatementImplementationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseCapabilityStatementCapabilityStatementRestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseCapabilityStatementCapabilityStatementRestSecurityComponent(getJObject(json, "security"), owner));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatementCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCompartment().add(new CanonicalType());
        } else {
          res.getCompartment().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(getJObject(json, "_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("supportedProfile")) {
      JsonArray array = json.getAsJsonArray("supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportedProfile().add(new CanonicalType());
        } else {
          res.getSupportedProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportedProfile")) {
      JsonArray array = json.getAsJsonArray("_supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportedProfile().size())
          res.getSupportedProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(getJObject(json, "_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(getJObject(json, "_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(getJObject(json, "_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(getJObject(json, "_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalRead"))
      res.setConditionalReadElement(parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    if (json.has("_conditionalRead"))
      parseElementProperties(getJObject(json, "_conditionalRead"), res.getConditionalReadElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(getJObject(json, "_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(getJObject(json, "_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("referencePolicy")) {
      JsonArray array = json.getAsJsonArray("referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReferencePolicy().add(new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>());
        } else {
          res.getReferencePolicy().add(parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        }
      }
    };
    if (json.has("_referencePolicy")) {
      JsonArray array = json.getAsJsonArray("_referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReferencePolicy().size())
          res.getReferencePolicy().add(parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
      }
    };
    if (json.has("searchInclude")) {
      JsonArray array = json.getAsJsonArray("searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchInclude().add(new StringType());
        } else {
          res.getSearchInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchInclude")) {
      JsonArray array = json.getAsJsonArray("_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
      }
    };
    if (json.has("searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchRevInclude().add(new StringType());
        } else {
          res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseCapabilityStatementResourceInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseCapabilityStatementCapabilityStatementRestResourceOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseCapabilityStatementSystemInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseCapabilityStatementCapabilityStatementMessagingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(getJObject(json, "_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("supportedMessage")) {
      JsonArray array = json.getAsJsonArray("supportedMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedMessage().add(parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(getJObject(json, "protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(getJObject(json, "_address"), res.getAddressElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseCapabilityStatementCapabilityStatementDocumentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseCarePlanProperties(json, res);
    return res;
  }

  protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseCarePlanCarePlanActivityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("outcomeCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("outcomeCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("progress")) {
      JsonArray array = json.getAsJsonArray("progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("detail"))
      res.setDetail(parseCarePlanCarePlanActivityDetailComponent(getJObject(json, "detail"), owner));
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseCarePlanCarePlanActivityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("dailyAmount"))
      res.setDailyAmount(parseQuantity(getJObject(json, "dailyAmount")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseCareTeamProperties(json, res);
    return res;
  }

  protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization")) {
      JsonArray array = json.getAsJsonArray("managingOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getManagingOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json, CareTeam owner) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseCareTeamCareTeamParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCareTeamCareTeamParticipantComponentProperties(JsonObject json, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("member"))
      res.setMember(parseReference(getJObject(json, "member")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(getJObject(json, "onBehalfOf")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected CatalogEntry parseCatalogEntry(JsonObject json) throws IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseCatalogEntryProperties(json, res);
    return res;
  }

  protected void parseCatalogEntryProperties(JsonObject json, CatalogEntry res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("orderable"))
      res.setOrderableElement(parseBoolean(json.get("orderable").getAsBoolean()));
    if (json.has("_orderable"))
      parseElementProperties(getJObject(json, "_orderable"), res.getOrderableElement());
    if (json.has("referencedItem"))
      res.setReferencedItem(parseReference(getJObject(json, "referencedItem")));
    if (json.has("additionalIdentifier")) {
      JsonArray array = json.getAsJsonArray("additionalIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("classification")) {
      JsonArray array = json.getAsJsonArray("classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(getJObject(json, "validityPeriod")));
    if (json.has("validTo"))
      res.setValidToElement(parseDateTime(json.get("validTo").getAsString()));
    if (json.has("_validTo"))
      parseElementProperties(getJObject(json, "_validTo"), res.getValidToElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseDateTime(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(getJObject(json, "_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("additionalCharacteristic")) {
      JsonArray array = json.getAsJsonArray("additionalCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("additionalClassification")) {
      JsonArray array = json.getAsJsonArray("additionalClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedEntry")) {
      JsonArray array = json.getAsJsonArray("relatedEntry");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedEntry().add(parseCatalogEntryCatalogEntryRelatedEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryCatalogEntryRelatedEntryComponent(JsonObject json, CatalogEntry owner) throws IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
    parseCatalogEntryCatalogEntryRelatedEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCatalogEntryCatalogEntryRelatedEntryComponentProperties(JsonObject json, CatalogEntry owner, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationtype"))
      res.setRelationtypeElement(parseEnumeration(json.get("relationtype").getAsString(), CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
    if (json.has("_relationtype"))
      parseElementProperties(getJObject(json, "_relationtype"), res.getRelationtypeElement());
    if (json.has("item"))
      res.setItem(parseReference(getJObject(json, "item")));
  }

  protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseChargeItemProperties(json, res);
    return res;
  }

  protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definitionUri")) {
      JsonArray array = json.getAsJsonArray("definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionUri().add(new UriType());
        } else {
          res.getDefinitionUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionUri")) {
      JsonArray array = json.getAsJsonArray("_definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionUri().size())
          res.getDefinitionUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinitionUri().get(i));
      }
    };
    if (json.has("definitionCanonical")) {
      JsonArray array = json.getAsJsonArray("definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionCanonical().add(new CanonicalType());
        } else {
          res.getDefinitionCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionCanonical")) {
      JsonArray array = json.getAsJsonArray("_definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionCanonical().size())
          res.getDefinitionCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinitionCanonical().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseChargeItemChargeItemPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("performingOrganization"))
      res.setPerformingOrganization(parseReference(getJObject(json, "performingOrganization")));
    if (json.has("requestingOrganization"))
      res.setRequestingOrganization(parseReference(getJObject(json, "requestingOrganization")));
    if (json.has("costCenter"))
      res.setCostCenter(parseReference(getJObject(json, "costCenter")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("bodysite")) {
      JsonArray array = json.getAsJsonArray("bodysite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodysite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("factorOverride"))
      res.setFactorOverrideElement(parseDecimal(json.get("factorOverride").getAsBigDecimal()));
    if (json.has("_factorOverride"))
      parseElementProperties(getJObject(json, "_factorOverride"), res.getFactorOverrideElement());
    if (json.has("priceOverride"))
      res.setPriceOverride(parseMoney(getJObject(json, "priceOverride")));
    if (json.has("overrideReason"))
      res.setOverrideReasonElement(parseString(json.get("overrideReason").getAsString()));
    if (json.has("_overrideReason"))
      parseElementProperties(getJObject(json, "_overrideReason"), res.getOverrideReasonElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("enteredDate"))
      res.setEnteredDateElement(parseDateTime(json.get("enteredDate").getAsString()));
    if (json.has("_enteredDate"))
      parseElementProperties(getJObject(json, "_enteredDate"), res.getEnteredDateElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemChargeItemPerformerComponent(JsonObject json, ChargeItem owner) throws IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseChargeItemChargeItemPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemChargeItemPerformerComponentProperties(JsonObject json, ChargeItem owner, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseChargeItemDefinitionProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDerivedFromUri().add(new UriType());
        } else {
          res.getDerivedFromUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("_derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDerivedFromUri().size())
          res.getDerivedFromUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDerivedFromUri().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPartOf().add(new CanonicalType());
        } else {
          res.getPartOf().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_partOf")) {
      JsonArray array = json.getAsJsonArray("_partOf");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPartOf().size())
          res.getPartOf().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPartOf().get(i));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReplaces().add(new CanonicalType());
        } else {
          res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("propertyGroup")) {
      JsonArray array = json.getAsJsonArray("propertyGroup");
      for (int i = 0; i < array.size(); i++) {
        res.getPropertyGroup().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
    parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.NULL, new ChargeItemDefinition.ChargeItemDefinitionPriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseClaimProperties(json, res);
    return res;
  }

  protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(getJObject(json, "billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(getJObject(json, "prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(getJObject(json, "originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(getJObject(json, "payee"), res));
    if (json.has("referral"))
      res.setReferral(parseReference(getJObject(json, "referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseClaimCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseClaimSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseClaimAccidentComponent(getJObject(json, "accident"), res));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total"))
      res.setTotal(parseMoney(getJObject(json, "total")));
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseClaimRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim owner, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(getJObject(json, "reference")));
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseClaimPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimPayeeComponentProperties(JsonObject json, Claim owner, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseClaimCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim owner, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(getJObject(json, "_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(getJObject(json, "qualification")));
  }

  protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
    parseClaimSupportingInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSupportingInformationComponentProperties(JsonObject json, Claim owner, Claim.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseClaimDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim owner, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(getJObject(json, "onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(getJObject(json, "packageCode")));
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseClaimProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimProcedureComponentProperties(JsonObject json, Claim owner, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseClaimInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim owner, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseClaimAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimAccidentComponentProperties(JsonObject json, Claim owner, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected Claim.ItemComponent parseClaimItemComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseClaimItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimItemComponentProperties(JsonObject json, Claim owner, Claim.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseClaimDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDetailComponentProperties(JsonObject json, Claim owner, Claim.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseClaimSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim owner, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseClaimResponseProperties(json, res);
    return res;
  }

  protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ClaimResponse.Use.NULL, new ClaimResponse.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("requestor"))
      res.setRequestor(parseReference(getJObject(json, "requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), ClaimResponse.RemittanceOutcome.NULL, new ClaimResponse.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("preAuthPeriod"))
      res.setPreAuthPeriod(parsePeriod(getJObject(json, "preAuthPeriod")));
    if (json.has("payeeType"))
      res.setPayeeType(parseCodeableConcept(getJObject(json, "payeeType")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseClaimResponseTotalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseClaimResponsePaymentComponent(getJObject(json, "payment"), res));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(getJObject(json, "formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(getJObject(json, "form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = json.getAsJsonArray("communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseClaimResponseItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(getJObject(json, "_itemSequence"), res.getItemSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseClaimResponseAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseClaimResponseItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseClaimResponseSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseClaimResponseAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubdetailSequence().add(new PositiveIntType());
        } else {
          res.getSubdetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubdetailSequence().size())
          res.getSubdetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubdetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseClaimResponseAddedItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseClaimResponseAddedItemSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseClaimResponseTotalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseClaimResponsePaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(getJObject(json, "adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(getJObject(json, "adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseClaimResponseNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseClaimResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseClaimResponseErrorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(getJObject(json, "_itemSequence"), res.getItemSequenceElement());
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseClinicalImpressionProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("assessor"))
      res.setAssessor(parseReference(getJObject(json, "assessor")));
    if (json.has("previous"))
      res.setPrevious(parseReference(getJObject(json, "previous")));
    if (json.has("problem")) {
      JsonArray array = json.getAsJsonArray("problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("investigation")) {
      JsonArray array = json.getAsJsonArray("investigation");
      for (int i = 0; i < array.size(); i++) {
        res.getInvestigation().add(parseClinicalImpressionClinicalImpressionInvestigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("protocol")) {
      JsonArray array = json.getAsJsonArray("protocol");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProtocol().add(new UriType());
        } else {
          res.getProtocol().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_protocol")) {
      JsonArray array = json.getAsJsonArray("_protocol");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProtocol().size())
          res.getProtocol().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
      }
    };
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(getJObject(json, "_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = json.getAsJsonArray("finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding().add(parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prognosisCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prognosisReference")) {
      JsonArray array = json.getAsJsonArray("prognosisReference");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
    parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseClinicalImpressionClinicalImpressionFindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemCodeableConcept"))
      res.setItemCodeableConcept(parseCodeableConcept(getJObject(json, "itemCodeableConcept")));
    if (json.has("itemReference"))
      res.setItemReference(parseReference(getJObject(json, "itemReference")));
    if (json.has("basis"))
      res.setBasisElement(parseString(json.get("basis").getAsString()));
    if (json.has("_basis"))
      parseElementProperties(getJObject(json, "_basis"), res.getBasisElement());
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseCodeSystemProperties(json, res);
    return res;
  }

  protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(getJObject(json, "_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("hierarchyMeaning"))
      res.setHierarchyMeaningElement(parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    if (json.has("_hierarchyMeaning"))
      parseElementProperties(getJObject(json, "_hierarchyMeaning"), res.getHierarchyMeaningElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(getJObject(json, "_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(getJObject(json, "_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(getJObject(json, "_content"), res.getContentElement());
    if (json.has("supplements"))
      res.setSupplementsElement(parseCanonical(json.get("supplements").getAsString()));
    if (json.has("_supplements"))
      parseElementProperties(getJObject(json, "_supplements"), res.getSupplementsElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseCodeSystemCodeSystemFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemCodeSystemFilterComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = json.getAsJsonArray("operator");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOperator().add(new Enumeration<CodeSystem.FilterOperator>());
        } else {
          res.getOperator().add(parseEnumeration(array.get(i).getAsString(), CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        }
      }
    };
    if (json.has("_operator")) {
      JsonArray array = json.getAsJsonArray("_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseEnumeration(null, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseCodeSystemPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseCodeSystemConceptDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseCodeSystemConceptDefinitionDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(getJObject(json, "use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseCodeSystemConceptPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseCommunicationProperties(json, res);
    return res;
  }

  protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("inResponseTo")) {
      JsonArray array = json.getAsJsonArray("inResponseTo");
      for (int i = 0; i < array.size(); i++) {
        res.getInResponseTo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Communication.CommunicationPriority.NULL, new Communication.CommunicationPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("topic"))
      res.setTopic(parseCodeableConcept(getJObject(json, "topic")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(getJObject(json, "_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(getJObject(json, "_received"), res.getReceivedElement());
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(getJObject(json, "sender")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseCommunicationCommunicationPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationCommunicationPayloadComponentProperties(JsonObject json, Communication owner, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseCommunicationRequestProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(getJObject(json, "groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(getJObject(json, "requester")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(getJObject(json, "sender")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseCommunicationRequestCommunicationRequestPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationRequestCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseCompartmentDefinitionProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(getJObject(json, "_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getParam().add(new StringType());
        } else {
          res.getParam().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_param")) {
      JsonArray array = json.getAsJsonArray("_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseCompositionProperties(json, res);
    return res;
  }

  protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("confidentiality"))
      res.setConfidentialityElement(parseEnumeration(json.get("confidentiality").getAsString(), Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
    if (json.has("_confidentiality"))
      parseElementProperties(getJObject(json, "_confidentiality"), res.getConfidentialityElement());
    if (json.has("attester")) {
      JsonArray array = json.getAsJsonArray("attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseCompositionCompositionRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseCompositionCompositionAttesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionAttesterComponentProperties(JsonObject json, Composition owner, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseCompositionCompositionRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionRelatesToComponentProperties(JsonObject json, Composition owner, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseCompositionCompositionEventComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionEventComponentProperties(JsonObject json, Composition owner, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseCompositionSectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionSectionComponentProperties(JsonObject json, Composition owner, Composition.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("focus"))
      res.setFocus(parseReference(getJObject(json, "focus")));
    if (json.has("text"))
      res.setText(parseNarrative(getJObject(json, "text")));
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(getJObject(json, "orderedBy")));
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(getJObject(json, "emptyReason")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseConceptMapProperties(json, res);
    return res;
  }

  protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseConceptMapConceptMapGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseConceptMapConceptMapGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("sourceVersion"))
      res.setSourceVersionElement(parseString(json.get("sourceVersion").getAsString()));
    if (json.has("_sourceVersion"))
      parseElementProperties(getJObject(json, "_sourceVersion"), res.getSourceVersionElement());
    if (json.has("target"))
      res.setTargetElement(parseUri(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(getJObject(json, "_target"), res.getTargetElement());
    if (json.has("targetVersion"))
      res.setTargetVersionElement(parseString(json.get("targetVersion").getAsString()));
    if (json.has("_targetVersion"))
      parseElementProperties(getJObject(json, "_targetVersion"), res.getTargetVersionElement());
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("unmapped"))
      res.setUnmapped(parseConceptMapConceptMapGroupUnmappedComponent(getJObject(json, "unmapped"), owner));
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseConceptMapSourceElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseConceptMapTargetElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("equivalence"))
      res.setEquivalenceElement(parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
    if (json.has("_equivalence"))
      parseElementProperties(getJObject(json, "_equivalence"), res.getEquivalenceElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("product")) {
      JsonArray array = json.getAsJsonArray("product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseConceptMapOtherElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseUri(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(getJObject(json, "_property"), res.getPropertyElement());
    if (json.has("system"))
      res.setSystemElement(parseCanonical(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseConceptMapConceptMapGroupUnmappedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("url"))
      res.setUrlElement(parseCanonical(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseConditionProperties(json, res);
    return res;
  }

  protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(getJObject(json, "clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(getJObject(json, "verificationStatus")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(getJObject(json, "severity")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    Type abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(getJObject(json, "recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(getJObject(json, "asserter")));
    if (json.has("stage")) {
      JsonArray array = json.getAsJsonArray("stage");
      for (int i = 0; i < array.size(); i++) {
        res.getStage().add(parseConditionConditionStageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseConditionConditionStageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionStageComponentProperties(JsonObject json, Condition owner, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(getJObject(json, "summary")));
    if (json.has("assessment")) {
      JsonArray array = json.getAsJsonArray("assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseConditionConditionEvidenceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionEvidenceComponentProperties(JsonObject json, Condition owner, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
    Consent res = new Consent();
    parseConsentProperties(json, res);
    return res;
  }

  protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(getJObject(json, "scope")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(getJObject(json, "_dateTime"), res.getDateTimeElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("organization")) {
      JsonArray array = json.getAsJsonArray("organization");
      for (int i = 0; i < array.size(); i++) {
        res.getOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseConsentConsentPolicyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("policyRule"))
      res.setPolicyRule(parseCodeableConcept(getJObject(json, "policyRule")));
    if (json.has("verification")) {
      JsonArray array = json.getAsJsonArray("verification");
      for (int i = 0; i < array.size(); i++) {
        res.getVerification().add(parseConsentConsentVerificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("provision"))
      res.setProvision(parseConsentprovisionComponent(getJObject(json, "provision"), res));
  }

  protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseConsentConsentPolicyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentPolicyComponentProperties(JsonObject json, Consent owner, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("authority"))
      res.setAuthorityElement(parseUri(json.get("authority").getAsString()));
    if (json.has("_authority"))
      parseElementProperties(getJObject(json, "_authority"), res.getAuthorityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
  }

  protected Consent.ConsentVerificationComponent parseConsentConsentVerificationComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseConsentConsentVerificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentVerificationComponentProperties(JsonObject json, Consent owner, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("verified"))
      res.setVerifiedElement(parseBoolean(json.get("verified").getAsBoolean()));
    if (json.has("_verified"))
      parseElementProperties(getJObject(json, "_verified"), res.getVerifiedElement());
    if (json.has("verifiedWith"))
      res.setVerifiedWith(parseReference(getJObject(json, "verifiedWith")));
    if (json.has("verificationDate"))
      res.setVerificationDateElement(parseDateTime(json.get("verificationDate").getAsString()));
    if (json.has("_verificationDate"))
      parseElementProperties(getJObject(json, "_verificationDate"), res.getVerificationDateElement());
  }

  protected Consent.provisionComponent parseConsentprovisionComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionComponent res = new Consent.provisionComponent();
    parseConsentprovisionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionComponentProperties(JsonObject json, Consent owner, Consent.provisionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentprovisionActorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(getJObject(json, "dataPeriod")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentprovisionDataComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("provision")) {
      JsonArray array = json.getAsJsonArray("provision");
      for (int i = 0; i < array.size(); i++) {
        res.getProvision().add(parseConsentprovisionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Consent.provisionActorComponent parseConsentprovisionActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionActorComponent res = new Consent.provisionActorComponent();
    parseConsentprovisionActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionActorComponentProperties(JsonObject json, Consent owner, Consent.provisionActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Consent.provisionDataComponent parseConsentprovisionDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionDataComponent res = new Consent.provisionDataComponent();
    parseConsentprovisionDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionDataComponentProperties(JsonObject json, Consent owner, Consent.provisionDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(getJObject(json, "_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseContractProperties(json, res);
    return res;
  }

  protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("legalState"))
      res.setLegalState(parseCodeableConcept(getJObject(json, "legalState")));
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonical(parseReference(getJObject(json, "instantiatesCanonical")));
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("contentDerivative"))
      res.setContentDerivative(parseCodeableConcept(getJObject(json, "contentDerivative")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(getJObject(json, "applies")));
    if (json.has("expirationType"))
      res.setExpirationType(parseCodeableConcept(getJObject(json, "expirationType")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authority")) {
      JsonArray array = json.getAsJsonArray("authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("domain")) {
      JsonArray array = json.getAsJsonArray("domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("site")) {
      JsonArray array = json.getAsJsonArray("site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(getJObject(json, "scope")));
    Type topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contentDefinition"))
      res.setContentDefinition(parseContractContentDefinitionComponent(getJObject(json, "contentDefinition"), res));
    if (json.has("term")) {
      JsonArray array = json.getAsJsonArray("term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("signer")) {
      JsonArray array = json.getAsJsonArray("signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("friendly")) {
      JsonArray array = json.getAsJsonArray("friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("legal")) {
      JsonArray array = json.getAsJsonArray("legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type legallyBinding = parseType("legallyBinding", json);
    if (legallyBinding != null)
      res.setLegallyBinding(legallyBinding);
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseContractContentDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract owner, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("publisher"))
      res.setPublisher(parseReference(getJObject(json, "publisher")));
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(getJObject(json, "_publicationDate"), res.getPublicationDateElement());
    if (json.has("publicationStatus"))
      res.setPublicationStatusElement(parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractPublicationStatus.NULL, new Contract.ContractPublicationStatusEnumFactory()));
    if (json.has("_publicationStatus"))
      parseElementProperties(getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseContractTermComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractTermComponentProperties(JsonObject json, Contract owner, Contract.TermComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(getJObject(json, "applies")));
    Type topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseContractSecurityLabelComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("offer"))
      res.setOffer(parseContractContractOfferComponent(getJObject(json, "offer"), owner));
    if (json.has("asset")) {
      JsonArray array = json.getAsJsonArray("asset");
      for (int i = 0; i < array.size(); i++) {
        res.getAsset().add(parseContractContractAssetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseContractActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseContractSecurityLabelComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract owner, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number")) {
      JsonArray array = json.getAsJsonArray("number");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumber().add(new UnsignedIntType());
        } else {
          res.getNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_number")) {
      JsonArray array = json.getAsJsonArray("_number");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumber().size())
          res.getNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
      }
    };
    if (json.has("classification"))
      res.setClassification(parseCoding(getJObject(json, "classification")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("control")) {
      JsonArray array = json.getAsJsonArray("control");
      for (int i = 0; i < array.size(); i++) {
        res.getControl().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.ContractOfferComponent parseContractContractOfferComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseContractContractOfferComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractOfferComponentProperties(JsonObject json, Contract owner, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("party")) {
      JsonArray array = json.getAsJsonArray("party");
      for (int i = 0; i < array.size(); i++) {
        res.getParty().add(parseContractContractPartyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("topic"))
      res.setTopic(parseReference(getJObject(json, "topic")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("decisionMode")) {
      JsonArray array = json.getAsJsonArray("decisionMode");
      for (int i = 0; i < array.size(); i++) {
        res.getDecisionMode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ContractPartyComponent parseContractContractPartyComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseContractContractPartyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractPartyComponentProperties(JsonObject json, Contract owner, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseContractAnswerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractAnswerComponentProperties(JsonObject json, Contract owner, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Contract.ContractAssetComponent parseContractContractAssetComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseContractContractAssetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractAssetComponentProperties(JsonObject json, Contract owner, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(getJObject(json, "scope")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("typeReference")) {
      JsonArray array = json.getAsJsonArray("typeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getTypeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relationship"))
      res.setRelationship(parseCoding(getJObject(json, "relationship")));
    if (json.has("context")) {
      JsonArray array = json.getAsJsonArray("context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseContractAssetContextComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(getJObject(json, "_condition"), res.getConditionElement());
    if (json.has("periodType")) {
      JsonArray array = json.getAsJsonArray("periodType");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriodType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period")) {
      JsonArray array = json.getAsJsonArray("period");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usePeriod")) {
      JsonArray array = json.getAsJsonArray("usePeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getUsePeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseContractAssetContextComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractAssetContextComponentProperties(JsonObject json, Contract owner, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseContractValuedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractValuedItemComponentProperties(JsonObject json, Contract owner, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(getJObject(json, "_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(getJObject(json, "_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("payment"))
      res.setPaymentElement(parseString(json.get("payment").getAsString()));
    if (json.has("_payment"))
      parseElementProperties(getJObject(json, "_payment"), res.getPaymentElement());
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDateTime(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(getJObject(json, "_paymentDate"), res.getPaymentDateElement());
    if (json.has("responsible"))
      res.setResponsible(parseReference(getJObject(json, "responsible")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(getJObject(json, "recipient")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionComponent parseContractActionComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseContractActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractActionComponentProperties(JsonObject json, Contract owner, Contract.ActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseContractActionSubjectComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("intent"))
      res.setIntent(parseCodeableConcept(getJObject(json, "intent")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    if (json.has("contextLinkId")) {
      JsonArray array = json.getAsJsonArray("contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getContextLinkId().add(new StringType());
        } else {
          res.getContextLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_contextLinkId")) {
      JsonArray array = json.getAsJsonArray("_contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContextLinkId().size())
          res.getContextLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContextLinkId().get(i));
      }
    };
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("requester")) {
      JsonArray array = json.getAsJsonArray("requester");
      for (int i = 0; i < array.size(); i++) {
        res.getRequester().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRequesterLinkId().add(new StringType());
        } else {
          res.getRequesterLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("_requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRequesterLinkId().size())
          res.getRequesterLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRequesterLinkId().get(i));
      }
    };
    if (json.has("performerType")) {
      JsonArray array = json.getAsJsonArray("performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performerRole"))
      res.setPerformerRole(parseCodeableConcept(getJObject(json, "performerRole")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("performerLinkId")) {
      JsonArray array = json.getAsJsonArray("performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPerformerLinkId().add(new StringType());
        } else {
          res.getPerformerLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_performerLinkId")) {
      JsonArray array = json.getAsJsonArray("_performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPerformerLinkId().size())
          res.getPerformerLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPerformerLinkId().get(i));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReason().add(new StringType());
        } else {
          res.getReason().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_reason")) {
      JsonArray array = json.getAsJsonArray("_reason");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReason().size())
          res.getReason().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReason().get(i));
      }
    };
    if (json.has("reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReasonLinkId().add(new StringType());
        } else {
          res.getReasonLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("_reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReasonLinkId().size())
          res.getReasonLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReasonLinkId().get(i));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseContractActionSubjectComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract owner, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseContractSignatoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractSignatoryComponentProperties(JsonObject json, Contract owner, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseContractFriendlyLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract owner, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseContractLegalLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract owner, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseContractComputableLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract owner, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseCoverageProperties(json, res);
    return res;
  }

  protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("policyHolder"))
      res.setPolicyHolder(parseReference(getJObject(json, "policyHolder")));
    if (json.has("subscriber"))
      res.setSubscriber(parseReference(getJObject(json, "subscriber")));
    if (json.has("subscriberId"))
      res.setSubscriberIdElement(parseString(json.get("subscriberId").getAsString()));
    if (json.has("_subscriberId"))
      parseElementProperties(getJObject(json, "_subscriberId"), res.getSubscriberIdElement());
    if (json.has("beneficiary"))
      res.setBeneficiary(parseReference(getJObject(json, "beneficiary")));
    if (json.has("dependent"))
      res.setDependentElement(parseString(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(getJObject(json, "_dependent"), res.getDependentElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("payor")) {
      JsonArray array = json.getAsJsonArray("payor");
      for (int i = 0; i < array.size(); i++) {
        res.getPayor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoverageClassComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("order"))
      res.setOrderElement(parsePositiveInt(json.get("order").getAsString()));
    if (json.has("_order"))
      parseElementProperties(getJObject(json, "_order"), res.getOrderElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(getJObject(json, "_network"), res.getNetworkElement());
    if (json.has("costToBeneficiary")) {
      JsonArray array = json.getAsJsonArray("costToBeneficiary");
      for (int i = 0; i < array.size(); i++) {
        res.getCostToBeneficiary().add(parseCoverageCostToBeneficiaryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subrogation"))
      res.setSubrogationElement(parseBoolean(json.get("subrogation").getAsBoolean()));
    if (json.has("_subrogation"))
      parseElementProperties(getJObject(json, "_subrogation"), res.getSubrogationElement());
    if (json.has("contract")) {
      JsonArray array = json.getAsJsonArray("contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseCoverageClassComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageClassComponentProperties(JsonObject json, Coverage owner, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
  }

  protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
    parseCoverageCostToBeneficiaryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageCostToBeneficiaryComponentProperties(JsonObject json, Coverage owner, Coverage.CostToBeneficiaryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exception")) {
      JsonArray array = json.getAsJsonArray("exception");
      for (int i = 0; i < array.size(); i++) {
        res.getException().add(parseCoverageExemptionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Coverage.ExemptionComponent parseCoverageExemptionComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
    parseCoverageExemptionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageExemptionComponentProperties(JsonObject json, Coverage owner, Coverage.ExemptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseCoverageEligibilityRequestProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CoverageEligibilityRequest.EligibilityRequestStatus.NULL, new CoverageEligibilityRequest.EligibilityRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>());
        } else {
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseCoverageEligibilityRequestSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
    parseCoverageEligibilityRequestSupportingInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestSupportingInformationComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("information"))
      res.setInformation(parseReference(getJObject(json, "information")));
    if (json.has("appliesToAll"))
      res.setAppliesToAllElement(parseBoolean(json.get("appliesToAll").getAsBoolean()));
    if (json.has("_appliesToAll"))
      parseElementProperties(getJObject(json, "_appliesToAll"), res.getAppliesToAllElement());
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseCoverageEligibilityRequestInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseCoverageEligibilityRequestDetailsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("supportingInfoSequence")) {
      JsonArray array = json.getAsJsonArray("supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportingInfoSequence().add(new PositiveIntType());
        } else {
          res.getSupportingInfoSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportingInfoSequence")) {
      JsonArray array = json.getAsJsonArray("_supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportingInfoSequence().size())
          res.getSupportingInfoSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportingInfoSequence().get(i));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseCoverageEligibilityRequestDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseCoverageEligibilityResponseProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CoverageEligibilityResponse.EligibilityResponseStatus.NULL, new CoverageEligibilityResponse.EligibilityResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>());
        } else {
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("requestor"))
      res.setRequestor(parseReference(getJObject(json, "requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("form"))
      res.setForm(parseCodeableConcept(getJObject(json, "form")));
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCoverageEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseCoverageEligibilityResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(getJObject(json, "_inforce"), res.getInforceElement());
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(getJObject(json, "benefitPeriod")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityResponseItemsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseCoverageEligibilityResponseItemsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(getJObject(json, "_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(getJObject(json, "network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("authorizationRequired"))
      res.setAuthorizationRequiredElement(parseBoolean(json.get("authorizationRequired").getAsBoolean()));
    if (json.has("_authorizationRequired"))
      parseElementProperties(getJObject(json, "_authorizationRequired"), res.getAuthorizationRequiredElement());
    if (json.has("authorizationSupporting")) {
      JsonArray array = json.getAsJsonArray("authorizationSupporting");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizationSupporting().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authorizationUrl"))
      res.setAuthorizationUrlElement(parseUri(json.get("authorizationUrl").getAsString()));
    if (json.has("_authorizationUrl"))
      parseElementProperties(getJObject(json, "_authorizationUrl"), res.getAuthorizationUrlElement());
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseCoverageEligibilityResponseBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseCoverageEligibilityResponseErrorsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDetectedIssueProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    Type identified = parseType("identified", json);
    if (identified != null)
      res.setIdentified(identified);
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("implicated")) {
      JsonArray array = json.getAsJsonArray("implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseDetectedIssueDetectedIssueEvidenceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(getJObject(json, "_detail"), res.getDetailElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = json.getAsJsonArray("mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation().add(parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueDetectedIssueEvidenceComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
    parseDetectedIssueDetectedIssueEvidenceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDetectedIssueDetectedIssueEvidenceComponentProperties(JsonObject json, DetectedIssue owner, DetectedIssue.DetectedIssueEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseDetectedIssueDetectedIssueMitigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDetectedIssueDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(getJObject(json, "action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDeviceProperties(json, res);
    return res;
  }

  protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseReference(getJObject(json, "definition")));
    if (json.has("udiCarrier")) {
      JsonArray array = json.getAsJsonArray("udiCarrier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiCarrier().add(parseDeviceDeviceUdiCarrierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("distinctIdentifier"))
      res.setDistinctIdentifierElement(parseString(json.get("distinctIdentifier").getAsString()));
    if (json.has("_distinctIdentifier"))
      parseElementProperties(getJObject(json, "_distinctIdentifier"), res.getDistinctIdentifierElement());
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(getJObject(json, "_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(getJObject(json, "_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(getJObject(json, "_serialNumber"), res.getSerialNumberElement());
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDeviceDeviceNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(getJObject(json, "_modelNumber"), res.getModelNumberElement());
    if (json.has("partNumber"))
      res.setPartNumberElement(parseString(json.get("partNumber").getAsString()));
    if (json.has("_partNumber"))
      parseElementProperties(getJObject(json, "_partNumber"), res.getPartNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceDeviceSpecializationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseDeviceDeviceVersionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDevicePropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parent"))
      res.setParent(parseReference(getJObject(json, "parent")));
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceDeviceUdiCarrierComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseDeviceDeviceUdiCarrierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceUdiCarrierComponentProperties(JsonObject json, Device owner, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(getJObject(json, "_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseBase64Binary(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(getJObject(json, "_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(getJObject(json, "_carrierHRF"), res.getCarrierHRFElement());
    if (json.has("entryType"))
      res.setEntryTypeElement(parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    if (json.has("_entryType"))
      parseElementProperties(getJObject(json, "_entryType"), res.getEntryTypeElement());
  }

  protected Device.DeviceDeviceNameComponent parseDeviceDeviceDeviceNameComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
    parseDeviceDeviceDeviceNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceDeviceNameComponentProperties(JsonObject json, Device owner, Device.DeviceDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Device.DeviceNameType.NULL, new Device.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected Device.DeviceSpecializationComponent parseDeviceDeviceSpecializationComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
    parseDeviceDeviceSpecializationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceSpecializationComponentProperties(JsonObject json, Device owner, Device.DeviceSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemType(parseCodeableConcept(getJObject(json, "systemType")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
  }

  protected Device.DeviceVersionComponent parseDeviceDeviceVersionComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseDeviceDeviceVersionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceVersionComponentProperties(JsonObject json, Device owner, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("component"))
      res.setComponent(parseIdentifier(getJObject(json, "component")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected Device.DevicePropertyComponent parseDeviceDevicePropertyComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseDeviceDevicePropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDevicePropertyComponentProperties(JsonObject json, Device owner, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("valueQuantity")) {
      JsonArray array = json.getAsJsonArray("valueQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuantity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseDeviceDefinitionProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("udiDeviceIdentifier")) {
      JsonArray array = json.getAsJsonArray("udiDeviceIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type manufacturer = parseType("manufacturer", json);
    if (manufacturer != null)
      res.setManufacturer(manufacturer);
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(getJObject(json, "_modelNumber"), res.getModelNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceDefinitionDeviceDefinitionSpecializationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getVersion().add(new StringType());
        } else {
          res.getVersion().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_version")) {
      JsonArray array = json.getAsJsonArray("_version");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVersion().size())
          res.getVersion().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVersion().get(i));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(getJObject(json, "physicalCharacteristics")));
    if (json.has("languageCode")) {
      JsonArray array = json.getAsJsonArray("languageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getLanguageCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("capability")) {
      JsonArray array = json.getAsJsonArray("capability");
      for (int i = 0; i < array.size(); i++) {
        res.getCapability().add(parseDeviceDefinitionDeviceDefinitionCapabilityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDefinitionDeviceDefinitionPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("onlineInformation"))
      res.setOnlineInformationElement(parseUri(json.get("onlineInformation").getAsString()));
    if (json.has("_onlineInformation"))
      parseElementProperties(getJObject(json, "_onlineInformation"), res.getOnlineInformationElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("parentDevice"))
      res.setParentDevice(parseReference(getJObject(json, "parentDevice")));
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseDeviceDefinitionDeviceDefinitionMaterialComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(getJObject(json, "_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseDeviceDefinitionDeviceDefinitionDeviceNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceDefinition.DeviceNameType.NULL, new DeviceDefinition.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionDeviceDefinitionSpecializationComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
    parseDeviceDefinitionDeviceDefinitionSpecializationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionSpecializationComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemTypeElement(parseString(json.get("systemType").getAsString()));
    if (json.has("_systemType"))
      parseElementProperties(getJObject(json, "_systemType"), res.getSystemTypeElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
  }

  protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionDeviceDefinitionCapabilityComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
    parseDeviceDefinitionDeviceDefinitionCapabilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionCapabilityComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("description")) {
      JsonArray array = json.getAsJsonArray("description");
      for (int i = 0; i < array.size(); i++) {
        res.getDescription().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionDeviceDefinitionPropertyComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseDeviceDefinitionDeviceDefinitionPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("valueQuantity")) {
      JsonArray array = json.getAsJsonArray("valueQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuantity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionDeviceDefinitionMaterialComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseDeviceDefinitionDeviceDefinitionMaterialComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(getJObject(json, "substance")));
    if (json.has("alternate"))
      res.setAlternateElement(parseBoolean(json.get("alternate").getAsBoolean()));
    if (json.has("_alternate"))
      parseElementProperties(getJObject(json, "_alternate"), res.getAlternateElement());
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDeviceMetricProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    if (json.has("parent"))
      res.setParent(parseReference(getJObject(json, "parent")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(getJObject(json, "_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
    if (json.has("_color"))
      parseElementProperties(getJObject(json, "_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(getJObject(json, "_category"), res.getCategoryElement());
    if (json.has("measurementPeriod"))
      res.setMeasurementPeriod(parseTiming(getJObject(json, "measurementPeriod")));
    if (json.has("calibration")) {
      JsonArray array = json.getAsJsonArray("calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration().add(parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseDeviceMetricDeviceMetricCalibrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceMetricDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(getJObject(json, "_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
  }

  protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDeviceRequestProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priorRequest")) {
      JsonArray array = json.getAsJsonArray("priorRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getPriorRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(getJObject(json, "groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), DeviceRequest.RequestIntent.NULL, new DeviceRequest.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    Type code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseDeviceRequestDeviceRequestParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(getJObject(json, "requester")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(getJObject(json, "performerType")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestDeviceRequestParameterComponent(JsonObject json, DeviceRequest owner) throws IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseDeviceRequestDeviceRequestParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceRequestDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest owner, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDeviceUseStatementProperties(json, res);
    return res;
  }

  protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(getJObject(json, "_recordedOn"), res.getRecordedOnElement());
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDiagnosticReportProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("resultsInterpreter")) {
      JsonArray array = json.getAsJsonArray("resultsInterpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getResultsInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("result")) {
      JsonArray array = json.getAsJsonArray("result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("imagingStudy")) {
      JsonArray array = json.getAsJsonArray("imagingStudy");
      for (int i = 0; i < array.size(); i++) {
        res.getImagingStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("media")) {
      JsonArray array = json.getAsJsonArray("media");
      for (int i = 0; i < array.size(); i++) {
        res.getMedia().add(parseDiagnosticReportDiagnosticReportMediaComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("conclusion"))
      res.setConclusionElement(parseString(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(getJObject(json, "_conclusion"), res.getConclusionElement());
    if (json.has("conclusionCode")) {
      JsonArray array = json.getAsJsonArray("conclusionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getConclusionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("presentedForm")) {
      JsonArray array = json.getAsJsonArray("presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportDiagnosticReportMediaComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseDiagnosticReportDiagnosticReportMediaComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDiagnosticReportDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(getJObject(json, "link")));
  }

  protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDocumentManifestProperties(json, res);
    return res;
  }

  protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(getJObject(json, "masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseDocumentManifestDocumentManifestRelatedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentManifestDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(getJObject(json, "ref")));
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDocumentReferenceProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(getJObject(json, "masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatusElement(parseEnumeration(json.get("docStatus").getAsString(), DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
    if (json.has("_docStatus"))
      parseElementProperties(getJObject(json, "_docStatus"), res.getDocStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("date"))
      res.setDateElement(parseInstant(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authenticator"))
      res.setAuthenticator(parseReference(getJObject(json, "authenticator")));
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("context"))
      res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(getJObject(json, "context"), res));
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseReference(getJObject(json, "target")));
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseDocumentReferenceDocumentReferenceContentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(getJObject(json, "attachment")));
    if (json.has("format"))
      res.setFormat(parseCoding(getJObject(json, "format")));
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseDocumentReferenceDocumentReferenceContextComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContextComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(getJObject(json, "facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(getJObject(json, "practiceSetting")));
    if (json.has("sourcePatientInfo"))
      res.setSourcePatientInfo(parseReference(getJObject(json, "sourcePatientInfo")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EffectEvidenceSynthesis parseEffectEvidenceSynthesis(JsonObject json) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis res = new EffectEvidenceSynthesis();
    parseEffectEvidenceSynthesisProperties(json, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisProperties(JsonObject json, EffectEvidenceSynthesis res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("synthesisType"))
      res.setSynthesisType(parseCodeableConcept(getJObject(json, "synthesisType")));
    if (json.has("studyType"))
      res.setStudyType(parseCodeableConcept(getJObject(json, "studyType")));
    if (json.has("population"))
      res.setPopulation(parseReference(getJObject(json, "population")));
    if (json.has("exposure"))
      res.setExposure(parseReference(getJObject(json, "exposure")));
    if (json.has("exposureAlternative"))
      res.setExposureAlternative(parseReference(getJObject(json, "exposureAlternative")));
    if (json.has("outcome"))
      res.setOutcome(parseReference(getJObject(json, "outcome")));
    if (json.has("sampleSize"))
      res.setSampleSize(parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(getJObject(json, "sampleSize"), res));
    if (json.has("resultsByExposure")) {
      JsonArray array = json.getAsJsonArray("resultsByExposure");
      for (int i = 0; i < array.size(); i++) {
        res.getResultsByExposure().add(parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("effectEstimate")) {
      JsonArray array = json.getAsJsonArray("effectEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getEffectEstimate().add(parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("certainty")) {
      JsonArray array = json.getAsJsonArray("certainty");
      for (int i = 0; i < array.size(); i++) {
        res.getCertainty().add(parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("numberOfStudies"))
      res.setNumberOfStudiesElement(parseInteger(json.get("numberOfStudies").getAsLong()));
    if (json.has("_numberOfStudies"))
      parseElementProperties(getJObject(json, "_numberOfStudies"), res.getNumberOfStudiesElement());
    if (json.has("numberOfParticipants"))
      res.setNumberOfParticipantsElement(parseInteger(json.get("numberOfParticipants").getAsLong()));
    if (json.has("_numberOfParticipants"))
      parseElementProperties(getJObject(json, "_numberOfParticipants"), res.getNumberOfParticipantsElement());
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("exposureState"))
      res.setExposureStateElement(parseEnumeration(json.get("exposureState").getAsString(), EffectEvidenceSynthesis.ExposureState.NULL, new EffectEvidenceSynthesis.ExposureStateEnumFactory()));
    if (json.has("_exposureState"))
      parseElementProperties(getJObject(json, "_exposureState"), res.getExposureStateElement());
    if (json.has("variantState"))
      res.setVariantState(parseCodeableConcept(getJObject(json, "variantState")));
    if (json.has("riskEvidenceSynthesis"))
      res.setRiskEvidenceSynthesis(parseReference(getJObject(json, "riskEvidenceSynthesis")));
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("variantState"))
      res.setVariantState(parseCodeableConcept(getJObject(json, "variantState")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("unitOfMeasure"))
      res.setUnitOfMeasure(parseCodeableConcept(getJObject(json, "unitOfMeasure")));
    if (json.has("precisionEstimate")) {
      JsonArray array = json.getAsJsonArray("precisionEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getPrecisionEstimate().add(parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("level"))
      res.setLevelElement(parseDecimal(json.get("level").getAsBigDecimal()));
    if (json.has("_level"))
      parseElementProperties(getJObject(json, "_level"), res.getLevelElement());
    if (json.has("from"))
      res.setFromElement(parseDecimal(json.get("from").getAsBigDecimal()));
    if (json.has("_from"))
      parseElementProperties(getJObject(json, "_from"), res.getFromElement());
    if (json.has("to"))
      res.setToElement(parseDecimal(json.get("to").getAsBigDecimal()));
    if (json.has("_to"))
      parseElementProperties(getJObject(json, "_to"), res.getToElement());
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("rating")) {
      JsonArray array = json.getAsJsonArray("rating");
      for (int i = 0; i < array.size(); i++) {
        res.getRating().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("certaintySubcomponent")) {
      JsonArray array = json.getAsJsonArray("certaintySubcomponent");
      for (int i = 0; i < array.size(); i++) {
        res.getCertaintySubcomponent().add(parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(JsonObject json, EffectEvidenceSynthesis owner) throws IOException, FHIRFormatError {
    EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
    parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponentProperties(JsonObject json, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("rating")) {
      JsonArray array = json.getAsJsonArray("rating");
      for (int i = 0; i < array.size(); i++) {
        res.getRating().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseEncounterProperties(json, res);
    return res;
  }

  protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("class"))
      res.setClass_(parseCoding(getJObject(json, "class")));
    if (json.has("classHistory")) {
      JsonArray array = json.getAsJsonArray("classHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType"))
      res.setServiceType(parseCodeableConcept(getJObject(json, "serviceType")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("episodeOfCare")) {
      JsonArray array = json.getAsJsonArray("episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("appointment")) {
      JsonArray array = json.getAsJsonArray("appointment");
      for (int i = 0; i < array.size(); i++) {
        res.getAppointment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("length"))
      res.setLength(parseDuration(getJObject(json, "length")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("hospitalization"))
      res.setHospitalization(parseEncounterEncounterHospitalizationComponent(getJObject(json, "hospitalization"), res));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(getJObject(json, "serviceProvider")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(getJObject(json, "partOf")));
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseEncounterStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseEncounterClassHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("class"))
      res.setClass_(parseCoding(getJObject(json, "class")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseEncounterEncounterParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterParticipantComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("individual"))
      res.setIndividual(parseReference(getJObject(json, "individual")));
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseEncounterDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter owner, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(getJObject(json, "condition")));
    if (json.has("use"))
      res.setUse(parseCodeableConcept(getJObject(json, "use")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(getJObject(json, "_rank"), res.getRankElement());
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseEncounterEncounterHospitalizationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterHospitalizationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(getJObject(json, "preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(getJObject(json, "origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(getJObject(json, "admitSource")));
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(getJObject(json, "reAdmission")));
    if (json.has("dietPreference")) {
      JsonArray array = json.getAsJsonArray("dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialCourtesy")) {
      JsonArray array = json.getAsJsonArray("specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialArrangement")) {
      JsonArray array = json.getAsJsonArray("specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("destination"))
      res.setDestination(parseReference(getJObject(json, "destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(getJObject(json, "dischargeDisposition")));
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseEncounterEncounterLocationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterLocationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(getJObject(json, "physicalType")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseEndpointProperties(json, res);
    return res;
  }

  protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("connectionType"))
      res.setConnectionType(parseCoding(getJObject(json, "connectionType")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(getJObject(json, "managingOrganization")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("payloadType")) {
      JsonArray array = json.getAsJsonArray("payloadType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPayloadMimeType().add(new CodeType());
        } else {
          res.getPayloadMimeType().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("_payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPayloadMimeType().size())
          res.getPayloadMimeType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
      }
    };
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(getJObject(json, "_address"), res.getAddressElement());
    if (json.has("header")) {
      JsonArray array = json.getAsJsonArray("header");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getHeader().add(new StringType());
        } else {
          res.getHeader().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_header")) {
      JsonArray array = json.getAsJsonArray("_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
      }
    };
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseEnrollmentRequestProperties(json, res);
    return res;
  }

  protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("candidate"))
      res.setCandidate(parseReference(getJObject(json, "candidate")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseEnrollmentResponseProperties(json, res);
    return res;
  }

  protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(getJObject(json, "organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(getJObject(json, "requestProvider")));
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseEpisodeOfCareProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(getJObject(json, "managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("referralRequest")) {
      JsonArray array = json.getAsJsonArray("referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careManager"))
      res.setCareManager(parseReference(getJObject(json, "careManager")));
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseEpisodeOfCareDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(getJObject(json, "condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(getJObject(json, "_rank"), res.getRankElement());
  }

  protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseEventDefinitionProperties(json, res);
    return res;
  }

  protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("trigger")) {
      JsonArray array = json.getAsJsonArray("trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Evidence parseEvidence(JsonObject json) throws IOException, FHIRFormatError {
    Evidence res = new Evidence();
    parseEvidenceProperties(json, res);
    return res;
  }

  protected void parseEvidenceProperties(JsonObject json, Evidence res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("shortTitle"))
      res.setShortTitleElement(parseString(json.get("shortTitle").getAsString()));
    if (json.has("_shortTitle"))
      parseElementProperties(getJObject(json, "_shortTitle"), res.getShortTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("exposureBackground"))
      res.setExposureBackground(parseReference(getJObject(json, "exposureBackground")));
    if (json.has("exposureVariant")) {
      JsonArray array = json.getAsJsonArray("exposureVariant");
      for (int i = 0; i < array.size(); i++) {
        res.getExposureVariant().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcome")) {
      JsonArray array = json.getAsJsonArray("outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EvidenceVariable parseEvidenceVariable(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable res = new EvidenceVariable();
    parseEvidenceVariableProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableProperties(JsonObject json, EvidenceVariable res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("shortTitle"))
      res.setShortTitleElement(parseString(json.get("shortTitle").getAsString()));
    if (json.has("_shortTitle"))
      parseElementProperties(getJObject(json, "_shortTitle"), res.getShortTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), EvidenceVariable.EvidenceVariableType.NULL, new EvidenceVariable.EvidenceVariableTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseEvidenceVariableEvidenceVariableCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableEvidenceVariableCharacteristicComponent(JsonObject json, EvidenceVariable owner) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
    parseEvidenceVariableEvidenceVariableCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEvidenceVariableEvidenceVariableCharacteristicComponentProperties(JsonObject json, EvidenceVariable owner, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    Type definition = parseType("definition", json);
    if (definition != null)
      res.setDefinition(definition);
    if (json.has("usageContext")) {
      JsonArray array = json.getAsJsonArray("usageContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUsageContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(getJObject(json, "_exclude"), res.getExcludeElement());
    Type participantEffective = parseType("participantEffective", json);
    if (participantEffective != null)
      res.setParticipantEffective(participantEffective);
    if (json.has("timeFromStart"))
      res.setTimeFromStart(parseDuration(getJObject(json, "timeFromStart")));
    if (json.has("groupMeasure"))
      res.setGroupMeasureElement(parseEnumeration(json.get("groupMeasure").getAsString(), EvidenceVariable.GroupMeasure.NULL, new EvidenceVariable.GroupMeasureEnumFactory()));
    if (json.has("_groupMeasure"))
      parseElementProperties(getJObject(json, "_groupMeasure"), res.getGroupMeasureElement());
  }

  protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseExampleScenarioProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseExampleScenarioExampleScenarioActorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseExampleScenarioExampleScenarioInstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("workflow")) {
      JsonArray array = json.getAsJsonArray("workflow");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getWorkflow().add(new CanonicalType());
        } else {
          res.getWorkflow().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_workflow")) {
      JsonArray array = json.getAsJsonArray("_workflow");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWorkflow().size())
          res.getWorkflow().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWorkflow().get(i));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioExampleScenarioActorComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseExampleScenarioExampleScenarioActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("actorId"))
      res.setActorIdElement(parseString(json.get("actorId").getAsString()));
    if (json.has("_actorId"))
      parseElementProperties(getJObject(json, "_actorId"), res.getActorIdElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioExampleScenarioInstanceComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseExampleScenarioExampleScenarioInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(getJObject(json, "_resourceId"), res.getResourceIdElement());
    if (json.has("resourceType"))
      res.setResourceTypeElement(parseEnumeration(json.get("resourceType").getAsString(), ExampleScenario.FHIRResourceType.NULL, new ExampleScenario.FHIRResourceTypeEnumFactory()));
    if (json.has("_resourceType"))
      parseElementProperties(getJObject(json, "_resourceType"), res.getResourceTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseExampleScenarioExampleScenarioInstanceVersionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("containedInstance")) {
      JsonArray array = json.getAsJsonArray("containedInstance");
      for (int i = 0; i < array.size(); i++) {
        res.getContainedInstance().add(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioExampleScenarioInstanceVersionComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseExampleScenarioExampleScenarioInstanceVersionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(getJObject(json, "_versionId"), res.getVersionIdElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(getJObject(json, "_resourceId"), res.getResourceIdElement());
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(getJObject(json, "_versionId"), res.getVersionIdElement());
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioExampleScenarioProcessComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseExampleScenarioExampleScenarioProcessComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("preConditions"))
      res.setPreConditionsElement(parseMarkdown(json.get("preConditions").getAsString()));
    if (json.has("_preConditions"))
      parseElementProperties(getJObject(json, "_preConditions"), res.getPreConditionsElement());
    if (json.has("postConditions"))
      res.setPostConditionsElement(parseMarkdown(json.get("postConditions").getAsString()));
    if (json.has("_postConditions"))
      parseElementProperties(getJObject(json, "_postConditions"), res.getPostConditionsElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioExampleScenarioProcessStepComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseExampleScenarioExampleScenarioProcessStepComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("pause"))
      res.setPauseElement(parseBoolean(json.get("pause").getAsBoolean()));
    if (json.has("_pause"))
      parseElementProperties(getJObject(json, "_pause"), res.getPauseElement());
    if (json.has("operation"))
      res.setOperation(parseExampleScenarioExampleScenarioProcessStepOperationComponent(getJObject(json, "operation"), owner));
    if (json.has("alternative")) {
      JsonArray array = json.getAsJsonArray("alternative");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternative().add(parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioExampleScenarioProcessStepOperationComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseExampleScenarioExampleScenarioProcessStepOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parseString(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("initiator"))
      res.setInitiatorElement(parseString(json.get("initiator").getAsString()));
    if (json.has("_initiator"))
      parseElementProperties(getJObject(json, "_initiator"), res.getInitiatorElement());
    if (json.has("receiver"))
      res.setReceiverElement(parseString(json.get("receiver").getAsString()));
    if (json.has("_receiver"))
      parseElementProperties(getJObject(json, "_receiver"), res.getReceiverElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("initiatorActive"))
      res.setInitiatorActiveElement(parseBoolean(json.get("initiatorActive").getAsBoolean()));
    if (json.has("_initiatorActive"))
      parseElementProperties(getJObject(json, "_initiatorActive"), res.getInitiatorActiveElement());
    if (json.has("receiverActive"))
      res.setReceiverActiveElement(parseBoolean(json.get("receiverActive").getAsBoolean()));
    if (json.has("_receiverActive"))
      parseElementProperties(getJObject(json, "_receiverActive"), res.getReceiverActiveElement());
    if (json.has("request"))
      res.setRequest(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(getJObject(json, "request"), owner));
    if (json.has("response"))
      res.setResponse(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(getJObject(json, "response"), owner));
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseExampleScenarioExampleScenarioProcessStepAlternativeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseExplanationOfBenefitProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ExplanationOfBenefit.Use.NULL, new ExplanationOfBenefit.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(getJObject(json, "billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("fundsReserveRequested"))
      res.setFundsReserveRequested(parseCodeableConcept(getJObject(json, "fundsReserveRequested")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(getJObject(json, "prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(getJObject(json, "originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(getJObject(json, "payee"), res));
    if (json.has("referral"))
      res.setReferral(parseReference(getJObject(json, "referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), ExplanationOfBenefit.RemittanceOutcome.NULL, new ExplanationOfBenefit.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("preAuthRefPeriod")) {
      JsonArray array = json.getAsJsonArray("preAuthRefPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRefPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(getJObject(json, "_precedence"), res.getPrecedenceElement());
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseExplanationOfBenefitAccidentComponent(getJObject(json, "accident"), res));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseExplanationOfBenefitTotalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseExplanationOfBenefitPaymentComponent(getJObject(json, "payment"), res));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(getJObject(json, "formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(getJObject(json, "form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(getJObject(json, "benefitPeriod")));
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseExplanationOfBenefitRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(getJObject(json, "reference")));
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseExplanationOfBenefitPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseExplanationOfBenefitCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(getJObject(json, "_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(getJObject(json, "qualification")));
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseExplanationOfBenefitSupportingInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCoding(getJObject(json, "reason")));
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseExplanationOfBenefitDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(getJObject(json, "onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(getJObject(json, "packageCode")));
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseExplanationOfBenefitProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseExplanationOfBenefitInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseExplanationOfBenefitAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseExplanationOfBenefitItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseExplanationOfBenefitAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseExplanationOfBenefitDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseExplanationOfBenefitSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseExplanationOfBenefitAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubDetailSequence().add(new PositiveIntType());
        } else {
          res.getSubDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubDetailSequence().size())
          res.getSubDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubDetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseExplanationOfBenefitAddedItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseExplanationOfBenefitTotalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseExplanationOfBenefitPaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(getJObject(json, "adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(getJObject(json, "adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseExplanationOfBenefitNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseExplanationOfBenefitBenefitBalanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(getJObject(json, "_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(getJObject(json, "network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseExplanationOfBenefitBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseFamilyMemberHistoryProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(getJObject(json, "dataAbsentReason")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("sex"))
      res.setSex(parseCodeableConcept(getJObject(json, "sex")));
    Type born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("estimatedAge"))
      res.setEstimatedAgeElement(parseBoolean(json.get("estimatedAge").getAsBoolean()));
    if (json.has("_estimatedAge"))
      parseElementProperties(getJObject(json, "_estimatedAge"), res.getEstimatedAgeElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(getJObject(json, "outcome")));
    if (json.has("contributedToDeath"))
      res.setContributedToDeathElement(parseBoolean(json.get("contributedToDeath").getAsBoolean()));
    if (json.has("_contributedToDeath"))
      parseElementProperties(getJObject(json, "_contributedToDeath"), res.getContributedToDeathElement());
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseFlagProperties(json, res);
    return res;
  }

  protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseGoalProperties(json, res);
    return res;
  }

  protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("lifecycleStatus"))
      res.setLifecycleStatusElement(parseEnumeration(json.get("lifecycleStatus").getAsString(), Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
    if (json.has("_lifecycleStatus"))
      parseElementProperties(getJObject(json, "_lifecycleStatus"), res.getLifecycleStatusElement());
    if (json.has("achievementStatus"))
      res.setAchievementStatus(parseCodeableConcept(getJObject(json, "achievementStatus")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(getJObject(json, "description")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    Type start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGoalGoalTargetComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(getJObject(json, "_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(getJObject(json, "_statusReason"), res.getStatusReasonElement());
    if (json.has("expressedBy"))
      res.setExpressedBy(parseReference(getJObject(json, "expressedBy")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeCode")) {
      JsonArray array = json.getAsJsonArray("outcomeCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseGoalGoalTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGoalGoalTargetComponentProperties(JsonObject json, Goal owner, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(getJObject(json, "measure")));
    Type detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    Type due = parseType("due", json);
    if (due != null)
      res.setDue(due);
  }

  protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseGraphDefinitionProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("start"))
      res.setStartElement(parseCode(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseGraphDefinitionGraphDefinitionLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(getJObject(json, "_sliceName"), res.getSliceNameElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGraphDefinitionGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(getJObject(json, "_params"), res.getParamsElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("rule"))
      res.setRuleElement(parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    if (json.has("_rule"))
      parseElementProperties(getJObject(json, "_rule"), res.getRuleElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseGroupProperties(json, res);
    return res;
  }

  protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(getJObject(json, "_actual"), res.getActualElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(getJObject(json, "_quantity"), res.getQuantityElement());
    if (json.has("managingEntity"))
      res.setManagingEntity(parseReference(getJObject(json, "managingEntity")));
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("member")) {
      JsonArray array = json.getAsJsonArray("member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseGroupGroupCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupCharacteristicComponentProperties(JsonObject json, Group owner, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(getJObject(json, "_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseGroupGroupMemberComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupMemberComponentProperties(JsonObject json, Group owner, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(getJObject(json, "entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(getJObject(json, "_inactive"), res.getInactiveElement());
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseGuidanceResponseProperties(json, res);
    return res;
  }

  protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("requestIdentifier"))
      res.setRequestIdentifier(parseIdentifier(getJObject(json, "requestIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    Type module = parseType("module", json);
    if (module != null)
      res.setModule(module);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("occurrenceDateTime"))
      res.setOccurrenceDateTimeElement(parseDateTime(json.get("occurrenceDateTime").getAsString()));
    if (json.has("_occurrenceDateTime"))
      parseElementProperties(getJObject(json, "_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evaluationMessage")) {
      JsonArray array = json.getAsJsonArray("evaluationMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluationMessage().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(getJObject(json, "outputParameters")));
    if (json.has("result"))
      res.setResult(parseReference(getJObject(json, "result")));
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseHealthcareServiceProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(getJObject(json, "providedBy")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseMarkdown(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(getJObject(json, "_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(getJObject(json, "photo")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceProvisionCode")) {
      JsonArray array = json.getAsJsonArray("serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eligibility")) {
      JsonArray array = json.getAsJsonArray("eligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getEligibility().add(parseHealthcareServiceHealthcareServiceEligibilityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("program")) {
      JsonArray array = json.getAsJsonArray("program");
      for (int i = 0; i < array.size(); i++) {
        res.getProgram().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referralMethod")) {
      JsonArray array = json.getAsJsonArray("referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(getJObject(json, "_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable().add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(getJObject(json, "_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceHealthcareServiceEligibilityComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
    parseHealthcareServiceHealthcareServiceEligibilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceEligibilityComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceEligibilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDaysOfWeek().add(new Enumeration<HealthcareService.DaysOfWeek>());
        } else {
          res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(getJObject(json, "_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(getJObject(json, "_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(getJObject(json, "_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(getJObject(json, "during")));
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseImagingStudyProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("modality")) {
      JsonArray array = json.getAsJsonArray("modality");
      for (int i = 0; i < array.size(); i++) {
        res.getModality().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(getJObject(json, "_started"), res.getStartedElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(getJObject(json, "referrer")));
    if (json.has("interpreter")) {
      JsonArray array = json.getAsJsonArray("interpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(getJObject(json, "_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedureReference"))
      res.setProcedureReference(parseReference(getJObject(json, "procedureReference")));
    if (json.has("procedureCode")) {
      JsonArray array = json.getAsJsonArray("procedureCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseImagingStudyImagingStudySeriesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(getJObject(json, "_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCoding(getJObject(json, "modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(getJObject(json, "bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCoding(getJObject(json, "laterality")));
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(getJObject(json, "_started"), res.getStartedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImagingStudyImagingStudySeriesPerformerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudyImagingStudySeriesPerformerComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseImagingStudyImagingStudySeriesPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesPerformerComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseImagingStudyImagingStudySeriesInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(getJObject(json, "_uid"), res.getUidElement());
    if (json.has("sopClass"))
      res.setSopClass(parseCoding(getJObject(json, "sopClass")));
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseImmunizationProperties(json, res);
    return res;
  }

  protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(getJObject(json, "vaccineCode")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("recorded"))
      res.setRecordedElement(parseDateTime(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(getJObject(json, "_recorded"), res.getRecordedElement());
    if (json.has("primarySource"))
      res.setPrimarySourceElement(parseBoolean(json.get("primarySource").getAsBoolean()));
    if (json.has("_primarySource"))
      parseElementProperties(getJObject(json, "_primarySource"), res.getPrimarySourceElement());
    if (json.has("reportOrigin"))
      res.setReportOrigin(parseCodeableConcept(getJObject(json, "reportOrigin")));
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(getJObject(json, "manufacturer")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(getJObject(json, "site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(getJObject(json, "route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseQuantity(getJObject(json, "doseQuantity")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImmunizationImmunizationPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("isSubpotent"))
      res.setIsSubpotentElement(parseBoolean(json.get("isSubpotent").getAsBoolean()));
    if (json.has("_isSubpotent"))
      parseElementProperties(getJObject(json, "_isSubpotent"), res.getIsSubpotentElement());
    if (json.has("subpotentReason")) {
      JsonArray array = json.getAsJsonArray("subpotentReason");
      for (int i = 0; i < array.size(); i++) {
        res.getSubpotentReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("education")) {
      JsonArray array = json.getAsJsonArray("education");
      for (int i = 0; i < array.size(); i++) {
        res.getEducation().add(parseImmunizationImmunizationEducationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("programEligibility")) {
      JsonArray array = json.getAsJsonArray("programEligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramEligibility().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fundingSource"))
      res.setFundingSource(parseCodeableConcept(getJObject(json, "fundingSource")));
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("protocolApplied")) {
      JsonArray array = json.getAsJsonArray("protocolApplied");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocolApplied().add(parseImmunizationImmunizationProtocolAppliedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationImmunizationPerformerComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseImmunizationImmunizationPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationPerformerComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Immunization.ImmunizationEducationComponent parseImmunizationImmunizationEducationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
    parseImmunizationImmunizationEducationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationEducationComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationEducationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("documentType"))
      res.setDocumentTypeElement(parseString(json.get("documentType").getAsString()));
    if (json.has("_documentType"))
      parseElementProperties(getJObject(json, "_documentType"), res.getDocumentTypeElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(getJObject(json, "_publicationDate"), res.getPublicationDateElement());
    if (json.has("presentationDate"))
      res.setPresentationDateElement(parseDateTime(json.get("presentationDate").getAsString()));
    if (json.has("_presentationDate"))
      parseElementProperties(getJObject(json, "_presentationDate"), res.getPresentationDateElement());
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseImmunizationImmunizationReactionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationReactionComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("detail"))
      res.setDetail(parseReference(getJObject(json, "detail")));
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(getJObject(json, "_reported"), res.getReportedElement());
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationImmunizationProtocolAppliedComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseImmunizationImmunizationProtocolAppliedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationProtocolAppliedComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationProtocolAppliedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("targetDisease")) {
      JsonArray array = json.getAsJsonArray("targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    Type seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseImmunizationEvaluationProperties(json, res);
    return res;
  }

  protected void parseImmunizationEvaluationProperties(JsonObject json, ImmunizationEvaluation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImmunizationEvaluation.ImmunizationEvaluationStatus.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(getJObject(json, "targetDisease")));
    if (json.has("immunizationEvent"))
      res.setImmunizationEvent(parseReference(getJObject(json, "immunizationEvent")));
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(getJObject(json, "doseStatus")));
    if (json.has("doseStatusReason")) {
      JsonArray array = json.getAsJsonArray("doseStatusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    Type seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseImmunizationRecommendationProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("recommendation")) {
      JsonArray array = json.getAsJsonArray("recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("vaccineCode")) {
      JsonArray array = json.getAsJsonArray("vaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(getJObject(json, "targetDisease")));
    if (json.has("contraindicatedVaccineCode")) {
      JsonArray array = json.getAsJsonArray("contraindicatedVaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindicatedVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(getJObject(json, "forecastStatus")));
    if (json.has("forecastReason")) {
      JsonArray array = json.getAsJsonArray("forecastReason");
      for (int i = 0; i < array.size(); i++) {
        res.getForecastReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dateCriterion")) {
      JsonArray array = json.getAsJsonArray("dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    Type seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
    if (json.has("supportingImmunization")) {
      JsonArray array = json.getAsJsonArray("supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingPatientInformation")) {
      JsonArray array = json.getAsJsonArray("supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseImplementationGuideProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(getJObject(json, "_packageId"), res.getPackageIdElement());
    if (json.has("license"))
      res.setLicenseElement(parseEnumeration(json.get("license").getAsString(), ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
    if (json.has("_license"))
      parseElementProperties(getJObject(json, "_license"), res.getLicenseElement());
    if (json.has("fhirVersion")) {
      JsonArray array = json.getAsJsonArray("fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>());
        } else {
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = json.getAsJsonArray("_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
      }
    };
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseImplementationGuideImplementationGuideDependsOnComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("global")) {
      JsonArray array = json.getAsJsonArray("global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal().add(parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseImplementationGuideImplementationGuideDefinitionComponent(getJObject(json, "definition"), res));
    if (json.has("manifest"))
      res.setManifest(parseImplementationGuideImplementationGuideManifestComponent(getJObject(json, "manifest"), res));
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideImplementationGuideDependsOnComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseImplementationGuideImplementationGuideDependsOnComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDependsOnComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uri"))
      res.setUriElement(parseCanonical(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(getJObject(json, "_packageId"), res.getPackageIdElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseImplementationGuideImplementationGuideGlobalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideImplementationGuideDefinitionComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseImplementationGuideImplementationGuideDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("grouping")) {
      JsonArray array = json.getAsJsonArray("grouping");
      for (int i = 0; i < array.size(); i++) {
        res.getGrouping().add(parseImplementationGuideImplementationGuideDefinitionGroupingComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideImplementationGuideDefinitionResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("page"))
      res.setPage(parseImplementationGuideImplementationGuideDefinitionPageComponent(getJObject(json, "page"), owner));
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseImplementationGuideImplementationGuideDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("template")) {
      JsonArray array = json.getAsJsonArray("template");
      for (int i = 0; i < array.size(); i++) {
        res.getTemplate().add(parseImplementationGuideImplementationGuideDefinitionTemplateComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideImplementationGuideDefinitionGroupingComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
    parseImplementationGuideImplementationGuideDefinitionGroupingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionGroupingComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideImplementationGuideDefinitionResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseImplementationGuideImplementationGuideDefinitionResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("fhirVersion")) {
      JsonArray array = json.getAsJsonArray("fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>());
        } else {
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = json.getAsJsonArray("_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    Type example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("groupingId"))
      res.setGroupingIdElement(parseId(json.get("groupingId").getAsString()));
    if (json.has("_groupingId"))
      parseElementProperties(getJObject(json, "_groupingId"), res.getGroupingIdElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideImplementationGuideDefinitionPageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseImplementationGuideImplementationGuideDefinitionPageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionPageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type name = parseType("name", json);
    if (name != null)
      res.setName(name);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("generation"))
      res.setGenerationElement(parseEnumeration(json.get("generation").getAsString(), ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
    if (json.has("_generation"))
      parseElementProperties(getJObject(json, "_generation"), res.getGenerationElement());
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideImplementationGuideDefinitionPageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideImplementationGuideDefinitionParameterComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseImplementationGuideImplementationGuideDefinitionParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionParameterComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseString(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideImplementationGuideDefinitionTemplateComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseImplementationGuideImplementationGuideDefinitionTemplateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionTemplateComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("scope"))
      res.setScopeElement(parseString(json.get("scope").getAsString()));
    if (json.has("_scope"))
      parseElementProperties(getJObject(json, "_scope"), res.getScopeElement());
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideImplementationGuideManifestComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseImplementationGuideImplementationGuideManifestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideManifestComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideManifestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("rendering"))
      res.setRenderingElement(parseUrl(json.get("rendering").getAsString()));
    if (json.has("_rendering"))
      parseElementProperties(getJObject(json, "_rendering"), res.getRenderingElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideManifestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideManifestPageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImage().add(new StringType());
        } else {
          res.getImage().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_image")) {
      JsonArray array = json.getAsJsonArray("_image");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImage().size())
          res.getImage().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImage().get(i));
      }
    };
    if (json.has("other")) {
      JsonArray array = json.getAsJsonArray("other");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOther().add(new StringType());
        } else {
          res.getOther().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_other")) {
      JsonArray array = json.getAsJsonArray("_other");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOther().size())
          res.getOther().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOther().get(i));
      }
    };
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseImplementationGuideManifestResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideManifestResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ManifestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    Type example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("relativePath"))
      res.setRelativePathElement(parseUrl(json.get("relativePath").getAsString()));
    if (json.has("_relativePath"))
      parseElementProperties(getJObject(json, "_relativePath"), res.getRelativePathElement());
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseImplementationGuideManifestPageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideManifestPageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ManifestPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("anchor")) {
      JsonArray array = json.getAsJsonArray("anchor");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAnchor().add(new StringType());
        } else {
          res.getAnchor().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_anchor")) {
      JsonArray array = json.getAsJsonArray("_anchor");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAnchor().size())
          res.getAnchor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAnchor().get(i));
      }
    };
  }

  protected InsurancePlan parseInsurancePlan(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseInsurancePlanProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanProperties(JsonObject json, InsurancePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("ownedBy"))
      res.setOwnedBy(parseReference(getJObject(json, "ownedBy")));
    if (json.has("administeredBy"))
      res.setAdministeredBy(parseReference(getJObject(json, "administeredBy")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseInsurancePlanInsurancePlanContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseInsurancePlanInsurancePlanCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("plan")) {
      JsonArray array = json.getAsJsonArray("plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseInsurancePlanInsurancePlanPlanComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanInsurancePlanContactComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
    parseInsurancePlanInsurancePlanContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanContactComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(getJObject(json, "purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(getJObject(json, "name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(getJObject(json, "address")));
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanInsurancePlanCoverageComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseInsurancePlanInsurancePlanCoverageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanCoverageComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanCoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseInsurancePlanCoverageBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.CoverageBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("requirement"))
      res.setRequirementElement(parseString(json.get("requirement").getAsString()));
    if (json.has("_requirement"))
      parseElementProperties(getJObject(json, "_requirement"), res.getRequirementElement());
    if (json.has("limit")) {
      JsonArray array = json.getAsJsonArray("limit");
      for (int i = 0; i < array.size(); i++) {
        res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseInsurancePlanCoverageBenefitLimitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitLimitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.CoverageBenefitLimitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanInsurancePlanPlanComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseInsurancePlanInsurancePlanPlanComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("generalCost")) {
      JsonArray array = json.getAsJsonArray("generalCost");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralCost().add(parseInsurancePlanInsurancePlanPlanGeneralCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("specificCost")) {
      JsonArray array = json.getAsJsonArray("specificCost");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecificCost().add(parseInsurancePlanInsurancePlanPlanSpecificCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanInsurancePlanPlanGeneralCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseInsurancePlanInsurancePlanPlanGeneralCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanGeneralCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("groupSize"))
      res.setGroupSizeElement(parsePositiveInt(json.get("groupSize").getAsString()));
    if (json.has("_groupSize"))
      parseElementProperties(getJObject(json, "_groupSize"), res.getGroupSizeElement());
    if (json.has("cost"))
      res.setCost(parseMoney(getJObject(json, "cost")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanInsurancePlanPlanSpecificCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseInsurancePlanInsurancePlanPlanSpecificCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanSpecificCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseInsurancePlanPlanBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.PlanBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseInsurancePlanPlanBenefitCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.PlanBenefitCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("applicability"))
      res.setApplicability(parseCodeableConcept(getJObject(json, "applicability")));
    if (json.has("qualifiers")) {
      JsonArray array = json.getAsJsonArray("qualifiers");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiers().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
  }

  protected Invoice parseInvoice(JsonObject json) throws IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseInvoiceProperties(json, res);
    return res;
  }

  protected void parseInvoiceProperties(JsonObject json, Invoice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("cancelledReason"))
      res.setCancelledReasonElement(parseString(json.get("cancelledReason").getAsString()));
    if (json.has("_cancelledReason"))
      parseElementProperties(getJObject(json, "_cancelledReason"), res.getCancelledReasonElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(getJObject(json, "recipient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseInvoiceInvoiceParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("issuer"))
      res.setIssuer(parseReference(getJObject(json, "issuer")));
    if (json.has("account"))
      res.setAccount(parseReference(getJObject(json, "account")));
    if (json.has("lineItem")) {
      JsonArray array = json.getAsJsonArray("lineItem");
      for (int i = 0; i < array.size(); i++) {
        res.getLineItem().add(parseInvoiceInvoiceLineItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalPriceComponent")) {
      JsonArray array = json.getAsJsonArray("totalPriceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getTotalPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalNet"))
      res.setTotalNet(parseMoney(getJObject(json, "totalNet")));
    if (json.has("totalGross"))
      res.setTotalGross(parseMoney(getJObject(json, "totalGross")));
    if (json.has("paymentTerms"))
      res.setPaymentTermsElement(parseMarkdown(json.get("paymentTerms").getAsString()));
    if (json.has("_paymentTerms"))
      parseElementProperties(getJObject(json, "_paymentTerms"), res.getPaymentTermsElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceInvoiceParticipantComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseInvoiceInvoiceParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceParticipantComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceInvoiceLineItemComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseInvoiceInvoiceLineItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceLineItemComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceLineItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    Type chargeItem = parseType("chargeItem", json);
    if (chargeItem != null)
      res.setChargeItem(chargeItem);
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceInvoiceLineItemPriceComponentComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
    parseInvoiceInvoiceLineItemPriceComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceLineItemPriceComponentComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceLineItemPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Invoice.InvoicePriceComponentType.NULL, new Invoice.InvoicePriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseLibraryProperties(json, res);
    return res;
  }

  protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseLinkageProperties(json, res);
    return res;
  }

  protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner) throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseLinkageLinkageItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLinkageLinkageItemComponentProperties(JsonObject json, Linkage owner, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(getJObject(json, "resource")));
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseListResourceProperties(json, res);
    return res;
  }

  protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(getJObject(json, "orderedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(getJObject(json, "emptyReason")));
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner) throws IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseListResourceListEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseListResourceListEntryComponentProperties(JsonObject json, ListResource owner, ListResource.ListEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(getJObject(json, "flag")));
    if (json.has("deleted"))
      res.setDeletedElement(parseBoolean(json.get("deleted").getAsBoolean()));
    if (json.has("_deleted"))
      parseElementProperties(getJObject(json, "_deleted"), res.getDeletedElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("item"))
      res.setItem(parseReference(getJObject(json, "item")));
  }

  protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
    Location res = new Location();
    parseLocationProperties(json, res);
    return res;
  }

  protected void parseLocationProperties(JsonObject json, Location res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("operationalStatus"))
      res.setOperationalStatus(parseCoding(getJObject(json, "operationalStatus")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(getJObject(json, "address")));
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(getJObject(json, "physicalType")));
    if (json.has("position"))
      res.setPosition(parseLocationLocationPositionComponent(getJObject(json, "position"), res));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(getJObject(json, "managingOrganization")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(getJObject(json, "partOf")));
    if (json.has("hoursOfOperation")) {
      JsonArray array = json.getAsJsonArray("hoursOfOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getHoursOfOperation().add(parseLocationLocationHoursOfOperationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(getJObject(json, "_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseLocationLocationPositionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLocationLocationPositionComponentProperties(JsonObject json, Location owner, Location.LocationPositionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("longitude"))
      res.setLongitudeElement(parseDecimal(json.get("longitude").getAsBigDecimal()));
    if (json.has("_longitude"))
      parseElementProperties(getJObject(json, "_longitude"), res.getLongitudeElement());
    if (json.has("latitude"))
      res.setLatitudeElement(parseDecimal(json.get("latitude").getAsBigDecimal()));
    if (json.has("_latitude"))
      parseElementProperties(getJObject(json, "_latitude"), res.getLatitudeElement());
    if (json.has("altitude"))
      res.setAltitudeElement(parseDecimal(json.get("altitude").getAsBigDecimal()));
    if (json.has("_altitude"))
      parseElementProperties(getJObject(json, "_altitude"), res.getAltitudeElement());
  }

  protected Location.LocationHoursOfOperationComponent parseLocationLocationHoursOfOperationComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
    Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
    parseLocationLocationHoursOfOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLocationLocationHoursOfOperationComponentProperties(JsonObject json, Location owner, Location.LocationHoursOfOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDaysOfWeek().add(new Enumeration<Location.DaysOfWeek>());
        } else {
          res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(getJObject(json, "_allDay"), res.getAllDayElement());
    if (json.has("openingTime"))
      res.setOpeningTimeElement(parseTime(json.get("openingTime").getAsString()));
    if (json.has("_openingTime"))
      parseElementProperties(getJObject(json, "_openingTime"), res.getOpeningTimeElement());
    if (json.has("closingTime"))
      res.setClosingTimeElement(parseTime(json.get("closingTime").getAsString()));
    if (json.has("_closingTime"))
      parseElementProperties(getJObject(json, "_closingTime"), res.getClosingTimeElement());
  }

  protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
    Measure res = new Measure();
    parseMeasureProperties(json, res);
    return res;
  }

  protected void parseMeasureProperties(JsonObject json, Measure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("disclaimer"))
      res.setDisclaimerElement(parseMarkdown(json.get("disclaimer").getAsString()));
    if (json.has("_disclaimer"))
      parseElementProperties(getJObject(json, "_disclaimer"), res.getDisclaimerElement());
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(getJObject(json, "scoring")));
    if (json.has("compositeScoring"))
      res.setCompositeScoring(parseCodeableConcept(getJObject(json, "compositeScoring")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("riskAdjustment"))
      res.setRiskAdjustmentElement(parseString(json.get("riskAdjustment").getAsString()));
    if (json.has("_riskAdjustment"))
      parseElementProperties(getJObject(json, "_riskAdjustment"), res.getRiskAdjustmentElement());
    if (json.has("rateAggregation"))
      res.setRateAggregationElement(parseString(json.get("rateAggregation").getAsString()));
    if (json.has("_rateAggregation"))
      parseElementProperties(getJObject(json, "_rateAggregation"), res.getRateAggregationElement());
    if (json.has("rationale"))
      res.setRationaleElement(parseMarkdown(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(getJObject(json, "_rationale"), res.getRationaleElement());
    if (json.has("clinicalRecommendationStatement"))
      res.setClinicalRecommendationStatementElement(parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
    if (json.has("_clinicalRecommendationStatement"))
      parseElementProperties(getJObject(json, "_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
    if (json.has("improvementNotation"))
      res.setImprovementNotation(parseCodeableConcept(getJObject(json, "improvementNotation")));
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinition().add(new MarkdownType());
        } else {
          res.getDefinition().add(parseMarkdown(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseMarkdown(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("guidance"))
      res.setGuidanceElement(parseMarkdown(json.get("guidance").getAsString()));
    if (json.has("_guidance"))
      parseElementProperties(getJObject(json, "_guidance"), res.getGuidanceElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData().add(parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseMeasureMeasureGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseMeasureMeasureGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupPopulationComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(getJObject(json, "criteria")));
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseMeasureMeasureGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupStratifierComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(getJObject(json, "criteria")));
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseMeasureMeasureGroupStratifierComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Measure.MeasureGroupStratifierComponentComponent parseMeasureMeasureGroupStratifierComponentComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
    parseMeasureMeasureGroupStratifierComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupStratifierComponentComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupStratifierComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(getJObject(json, "criteria")));
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseMeasureMeasureSupplementalDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureSupplementalDataComponentProperties(JsonObject json, Measure owner, Measure.MeasureSupplementalDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("usage")) {
      JsonArray array = json.getAsJsonArray("usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(getJObject(json, "criteria")));
  }

  protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseMeasureReportProperties(json, res);
    return res;
  }

  protected void parseMeasureReportProperties(JsonObject json, MeasureReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("measure"))
      res.setMeasureElement(parseCanonical(json.get("measure").getAsString()));
    if (json.has("_measure"))
      parseElementProperties(getJObject(json, "_measure"), res.getMeasureElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("reporter"))
      res.setReporter(parseReference(getJObject(json, "reporter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("improvementNotation"))
      res.setImprovementNotation(parseCodeableConcept(getJObject(json, "improvementNotation")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("evaluatedResource")) {
      JsonArray array = json.getAsJsonArray("evaluatedResource");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluatedResource().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseMeasureReportMeasureReportGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(getJObject(json, "measureScore")));
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseMeasureReportMeasureReportGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(getJObject(json, "subjectResults")));
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseMeasureReportMeasureReportGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupStratifierComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("stratum")) {
      JsonArray array = json.getAsJsonArray("stratum");
      for (int i = 0; i < array.size(); i++) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseMeasureReportStratifierGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseCodeableConcept(getJObject(json, "value")));
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseMeasureReportStratifierGroupComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(getJObject(json, "measureScore")));
  }

  protected MeasureReport.StratifierGroupComponentComponent parseMeasureReportStratifierGroupComponentComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponentComponent res = new MeasureReport.StratifierGroupComponentComponent();
    parseMeasureReportStratifierGroupComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("value"))
      res.setValue(parseCodeableConcept(getJObject(json, "value")));
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseMeasureReportStratifierGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(getJObject(json, "subjectResults")));
  }

  protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
    Media res = new Media();
    parseMediaProperties(json, res);
    return res;
  }

  protected void parseMediaProperties(JsonObject json, Media res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Media.MediaStatus.NULL, new Media.MediaStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("modality"))
      res.setModality(parseCodeableConcept(getJObject(json, "modality")));
    if (json.has("view"))
      res.setView(parseCodeableConcept(getJObject(json, "view")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type created = parseType("created", json);
    if (created != null)
      res.setCreated(created);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("operator"))
      res.setOperator(parseReference(getJObject(json, "operator")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("deviceName"))
      res.setDeviceNameElement(parseString(json.get("deviceName").getAsString()));
    if (json.has("_deviceName"))
      parseElementProperties(getJObject(json, "_deviceName"), res.getDeviceNameElement());
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(getJObject(json, "_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(getJObject(json, "_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(getJObject(json, "_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(getJObject(json, "_duration"), res.getDurationElement());
    if (json.has("content"))
      res.setContent(parseAttachment(getJObject(json, "content")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
    Medication res = new Medication();
    parseMedicationProperties(json, res);
    return res;
  }

  protected void parseMedicationProperties(JsonObject json, Medication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(getJObject(json, "manufacturer")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(getJObject(json, "form")));
    if (json.has("amount"))
      res.setAmount(parseRatio(getJObject(json, "amount")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationMedicationIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("batch"))
      res.setBatch(parseMedicationMedicationBatchComponent(getJObject(json, "batch"), res));
  }

  protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseMedicationMedicationIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationIngredientComponentProperties(JsonObject json, Medication owner, Medication.MedicationIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(getJObject(json, "_isActive"), res.getIsActiveElement());
    if (json.has("strength"))
      res.setStrength(parseRatio(getJObject(json, "strength")));
  }

  protected Medication.MedicationBatchComponent parseMedicationMedicationBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
    parseMedicationMedicationBatchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationBatchComponentProperties(JsonObject json, Medication owner, Medication.MedicationBatchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
  }

  protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseMedicationAdministrationProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationProperties(JsonObject json, MedicationAdministration res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new UriType());
        } else {
          res.getInstantiates().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationAdministrationMedicationAdministrationPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage"))
      res.setDosage(parseMedicationAdministrationMedicationAdministrationDosageComponent(getJObject(json, "dosage"), res));
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(getJObject(json, "site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(getJObject(json, "route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("dose"))
      res.setDose(parseQuantity(getJObject(json, "dose")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseMedicationDispenseProperties(json, res);
    return res;
  }

  protected void parseMedicationDispenseProperties(JsonObject json, MedicationDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    Type statusReason = parseType("statusReason", json);
    if (statusReason != null)
      res.setStatusReason(statusReason);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationDispenseMedicationDispensePerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("authorizingPrescription")) {
      JsonArray array = json.getAsJsonArray("authorizingPrescription");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizingPrescription().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("daysSupply"))
      res.setDaysSupply(parseQuantity(getJObject(json, "daysSupply")));
    if (json.has("whenPrepared"))
      res.setWhenPreparedElement(parseDateTime(json.get("whenPrepared").getAsString()));
    if (json.has("_whenPrepared"))
      parseElementProperties(getJObject(json, "_whenPrepared"), res.getWhenPreparedElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(getJObject(json, "_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(getJObject(json, "destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationDispenseMedicationDispenseSubstitutionComponent(getJObject(json, "substitution"), res));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseMedicationDispenseMedicationDispensePerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispensePerformerComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("wasSubstituted"))
      res.setWasSubstitutedElement(parseBoolean(json.get("wasSubstituted").getAsBoolean()));
    if (json.has("_wasSubstituted"))
      parseElementProperties(getJObject(json, "_wasSubstituted"), res.getWasSubstitutedElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsibleParty")) {
      JsonArray array = json.getAsJsonArray("responsibleParty");
      for (int i = 0; i < array.size(); i++) {
        res.getResponsibleParty().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge parseMedicationKnowledge(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge res = new MedicationKnowledge();
    parseMedicationKnowledgeProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeProperties(JsonObject json, MedicationKnowledge res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationKnowledge.MedicationKnowledgeStatus.NULL, new MedicationKnowledge.MedicationKnowledgeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(getJObject(json, "manufacturer")));
    if (json.has("doseForm"))
      res.setDoseForm(parseCodeableConcept(getJObject(json, "doseForm")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(getJObject(json, "amount")));
    if (json.has("synonym")) {
      JsonArray array = json.getAsJsonArray("synonym");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSynonym().add(new StringType());
        } else {
          res.getSynonym().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_synonym")) {
      JsonArray array = json.getAsJsonArray("_synonym");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSynonym().size())
          res.getSynonym().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSynonym().get(i));
      }
    };
    if (json.has("relatedMedicationKnowledge")) {
      JsonArray array = json.getAsJsonArray("relatedMedicationKnowledge");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedMedicationKnowledge().add(parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("associatedMedication")) {
      JsonArray array = json.getAsJsonArray("associatedMedication");
      for (int i = 0; i < array.size(); i++) {
        res.getAssociatedMedication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productType")) {
      JsonArray array = json.getAsJsonArray("productType");
      for (int i = 0; i < array.size(); i++) {
        res.getProductType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("monograph")) {
      JsonArray array = json.getAsJsonArray("monograph");
      for (int i = 0; i < array.size(); i++) {
        res.getMonograph().add(parseMedicationKnowledgeMedicationKnowledgeMonographComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("preparationInstruction"))
      res.setPreparationInstructionElement(parseMarkdown(json.get("preparationInstruction").getAsString()));
    if (json.has("_preparationInstruction"))
      parseElementProperties(getJObject(json, "_preparationInstruction"), res.getPreparationInstructionElement());
    if (json.has("intendedRoute")) {
      JsonArray array = json.getAsJsonArray("intendedRoute");
      for (int i = 0; i < array.size(); i++) {
        res.getIntendedRoute().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseMedicationKnowledgeMedicationKnowledgeCostComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("monitoringProgram")) {
      JsonArray array = json.getAsJsonArray("monitoringProgram");
      for (int i = 0; i < array.size(); i++) {
        res.getMonitoringProgram().add(parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("administrationGuidelines")) {
      JsonArray array = json.getAsJsonArray("administrationGuidelines");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministrationGuidelines().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("medicineClassification")) {
      JsonArray array = json.getAsJsonArray("medicineClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getMedicineClassification().add(parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("packaging"))
      res.setPackaging(parseMedicationKnowledgeMedicationKnowledgePackagingComponent(getJObject(json, "packaging"), res));
    if (json.has("drugCharacteristic")) {
      JsonArray array = json.getAsJsonArray("drugCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getDrugCharacteristic().add(parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("contraindication")) {
      JsonArray array = json.getAsJsonArray("contraindication");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("regulatory")) {
      JsonArray array = json.getAsJsonArray("regulatory");
      for (int i = 0; i < array.size(); i++) {
        res.getRegulatory().add(parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("kinetics")) {
      JsonArray array = json.getAsJsonArray("kinetics");
      for (int i = 0; i < array.size(); i++) {
        res.getKinetics().add(parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
    parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMedicationKnowledgeMonographComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
    parseMedicationKnowledgeMedicationKnowledgeMonographComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMonographComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
  }

  protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
    parseMedicationKnowledgeMedicationKnowledgeIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeIngredientComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(getJObject(json, "_isActive"), res.getIsActiveElement());
    if (json.has("strength"))
      res.setStrength(parseRatio(getJObject(json, "strength")));
  }

  protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeMedicationKnowledgeCostComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
    parseMedicationKnowledgeMedicationKnowledgeCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeCostComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("cost"))
      res.setCost(parseMoney(getJObject(json, "cost")));
  }

  protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
    parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    Type indication = parseType("indication", json);
    if (indication != null)
      res.setIndication(indication);
    if (json.has("patientCharacteristics")) {
      JsonArray array = json.getAsJsonArray("patientCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getPatientCharacteristics().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type characteristic = parseType("characteristic", json);
    if (characteristic != null)
      res.setCharacteristic(characteristic);
    if (json.has("value")) {
      JsonArray array = json.getAsJsonArray("value");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getValue().add(new StringType());
        } else {
          res.getValue().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_value")) {
      JsonArray array = json.getAsJsonArray("_value");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValue().size())
          res.getValue().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValue().get(i));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
    parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("classification")) {
      JsonArray array = json.getAsJsonArray("classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgeMedicationKnowledgePackagingComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
    parseMedicationKnowledgeMedicationKnowledgePackagingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgePackagingComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
  }

  protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
    parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("regulatoryAuthority"))
      res.setRegulatoryAuthority(parseReference(getJObject(json, "regulatoryAuthority")));
    if (json.has("substitution")) {
      JsonArray array = json.getAsJsonArray("substitution");
      for (int i = 0; i < array.size(); i++) {
        res.getSubstitution().add(parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("maxDispense"))
      res.setMaxDispense(parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(getJObject(json, "maxDispense"), owner));
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("allowed"))
      res.setAllowedElement(parseBoolean(json.get("allowed").getAsBoolean()));
    if (json.has("_allowed"))
      parseElementProperties(getJObject(json, "_allowed"), res.getAllowedElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseCodeableConcept(getJObject(json, "schedule")));
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("period"))
      res.setPeriod(parseDuration(getJObject(json, "period")));
  }

  protected MedicationKnowledge.MedicationKnowledgeKineticsComponent parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeKineticsComponent res = new MedicationKnowledge.MedicationKnowledgeKineticsComponent();
    parseMedicationKnowledgeMedicationKnowledgeKineticsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeKineticsComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeKineticsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("areaUnderCurve")) {
      JsonArray array = json.getAsJsonArray("areaUnderCurve");
      for (int i = 0; i < array.size(); i++) {
        res.getAreaUnderCurve().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("lethalDose50")) {
      JsonArray array = json.getAsJsonArray("lethalDose50");
      for (int i = 0; i < array.size(); i++) {
        res.getLethalDose50().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("halfLifePeriod"))
      res.setHalfLifePeriod(parseDuration(getJObject(json, "halfLifePeriod")));
  }

  protected MedicationRequest parseMedicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseMedicationRequestProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestProperties(JsonObject json, MedicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    Type reported = parseType("reported", json);
    if (reported != null)
      res.setReported(reported);
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(getJObject(json, "requester")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(getJObject(json, "performerType")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(getJObject(json, "recorder")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(getJObject(json, "groupIdentifier")));
    if (json.has("courseOfTherapyType"))
      res.setCourseOfTherapyType(parseCodeableConcept(getJObject(json, "courseOfTherapyType")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dispenseRequest"))
      res.setDispenseRequest(parseMedicationRequestMedicationRequestDispenseRequestComponent(getJObject(json, "dispenseRequest"), res));
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationRequestMedicationRequestSubstitutionComponent(getJObject(json, "substitution"), res));
    if (json.has("priorPrescription"))
      res.setPriorPrescription(parseReference(getJObject(json, "priorPrescription")));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("initialFill"))
      res.setInitialFill(parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(getJObject(json, "initialFill"), owner));
    if (json.has("dispenseInterval"))
      res.setDispenseInterval(parseDuration(getJObject(json, "dispenseInterval")));
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(getJObject(json, "validityPeriod")));
    if (json.has("numberOfRepeatsAllowed"))
      res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(json.get("numberOfRepeatsAllowed").getAsString()));
    if (json.has("_numberOfRepeatsAllowed"))
      parseElementProperties(getJObject(json, "_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("expectedSupplyDuration"))
      res.setExpectedSupplyDuration(parseDuration(getJObject(json, "expectedSupplyDuration")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
  }

  protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
    parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("duration"))
      res.setDuration(parseDuration(getJObject(json, "duration")));
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseMedicationRequestMedicationRequestSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestSubstitutionComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
  }

  protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseMedicationStatementProperties(json, res);
    return res;
  }

  protected void parseMedicationStatementProperties(JsonObject json, MedicationStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(getJObject(json, "_dateAsserted"), res.getDateAssertedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(getJObject(json, "informationSource")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProduct parseMedicinalProduct(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProduct res = new MedicinalProduct();
    parseMedicinalProductProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductProperties(JsonObject json, MedicinalProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("domain"))
      res.setDomain(parseCoding(getJObject(json, "domain")));
    if (json.has("combinedPharmaceuticalDoseForm"))
      res.setCombinedPharmaceuticalDoseForm(parseCodeableConcept(getJObject(json, "combinedPharmaceuticalDoseForm")));
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(getJObject(json, "legalStatusOfSupply")));
    if (json.has("additionalMonitoringIndicator"))
      res.setAdditionalMonitoringIndicator(parseCodeableConcept(getJObject(json, "additionalMonitoringIndicator")));
    if (json.has("specialMeasures")) {
      JsonArray array = json.getAsJsonArray("specialMeasures");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSpecialMeasures().add(new StringType());
        } else {
          res.getSpecialMeasures().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_specialMeasures")) {
      JsonArray array = json.getAsJsonArray("_specialMeasures");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSpecialMeasures().size())
          res.getSpecialMeasures().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSpecialMeasures().get(i));
      }
    };
    if (json.has("paediatricUseIndicator"))
      res.setPaediatricUseIndicator(parseCodeableConcept(getJObject(json, "paediatricUseIndicator")));
    if (json.has("productClassification")) {
      JsonArray array = json.getAsJsonArray("productClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getProductClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingStatus")) {
      JsonArray array = json.getAsJsonArray("marketingStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketingStatus().add(parseMarketingStatus(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("pharmaceuticalProduct")) {
      JsonArray array = json.getAsJsonArray("pharmaceuticalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPharmaceuticalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packagedMedicinalProduct")) {
      JsonArray array = json.getAsJsonArray("packagedMedicinalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPackagedMedicinalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("attachedDocument")) {
      JsonArray array = json.getAsJsonArray("attachedDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getAttachedDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("masterFile")) {
      JsonArray array = json.getAsJsonArray("masterFile");
      for (int i = 0; i < array.size(); i++) {
        res.getMasterFile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalTrial")) {
      JsonArray array = json.getAsJsonArray("clinicalTrial");
      for (int i = 0; i < array.size(); i++) {
        res.getClinicalTrial().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseMedicinalProductMedicinalProductNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("crossReference")) {
      JsonArray array = json.getAsJsonArray("crossReference");
      for (int i = 0; i < array.size(); i++) {
        res.getCrossReference().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturingBusinessOperation")) {
      JsonArray array = json.getAsJsonArray("manufacturingBusinessOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturingBusinessOperation().add(parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("specialDesignation")) {
      JsonArray array = json.getAsJsonArray("specialDesignation");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialDesignation().add(parseMedicinalProductMedicinalProductSpecialDesignationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProduct.MedicinalProductNameComponent parseMedicinalProductMedicinalProductNameComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameComponent res = new MedicinalProduct.MedicinalProductNameComponent();
    parseMedicinalProductMedicinalProductNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(getJObject(json, "_productName"), res.getProductNameElement());
    if (json.has("namePart")) {
      JsonArray array = json.getAsJsonArray("namePart");
      for (int i = 0; i < array.size(); i++) {
        res.getNamePart().add(parseMedicinalProductMedicinalProductNameNamePartComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("countryLanguage")) {
      JsonArray array = json.getAsJsonArray("countryLanguage");
      for (int i = 0; i < array.size(); i++) {
        res.getCountryLanguage().add(parseMedicinalProductMedicinalProductNameCountryLanguageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProduct.MedicinalProductNameNamePartComponent parseMedicinalProductMedicinalProductNameNamePartComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameNamePartComponent res = new MedicinalProduct.MedicinalProductNameNamePartComponent();
    parseMedicinalProductMedicinalProductNameNamePartComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameNamePartComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameNamePartComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("part"))
      res.setPartElement(parseString(json.get("part").getAsString()));
    if (json.has("_part"))
      parseElementProperties(getJObject(json, "_part"), res.getPartElement());
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
  }

  protected MedicinalProduct.MedicinalProductNameCountryLanguageComponent parseMedicinalProductMedicinalProductNameCountryLanguageComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameCountryLanguageComponent res = new MedicinalProduct.MedicinalProductNameCountryLanguageComponent();
    parseMedicinalProductMedicinalProductNameCountryLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameCountryLanguageComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameCountryLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(getJObject(json, "country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(getJObject(json, "jurisdiction")));
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
  }

  protected MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res = new MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent();
    parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("operationType"))
      res.setOperationType(parseCodeableConcept(getJObject(json, "operationType")));
    if (json.has("authorisationReferenceNumber"))
      res.setAuthorisationReferenceNumber(parseIdentifier(getJObject(json, "authorisationReferenceNumber")));
    if (json.has("effectiveDate"))
      res.setEffectiveDateElement(parseDateTime(json.get("effectiveDate").getAsString()));
    if (json.has("_effectiveDate"))
      parseElementProperties(getJObject(json, "_effectiveDate"), res.getEffectiveDateElement());
    if (json.has("confidentialityIndicator"))
      res.setConfidentialityIndicator(parseCodeableConcept(getJObject(json, "confidentialityIndicator")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("regulator"))
      res.setRegulator(parseReference(getJObject(json, "regulator")));
  }

  protected MedicinalProduct.MedicinalProductSpecialDesignationComponent parseMedicinalProductMedicinalProductSpecialDesignationComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductSpecialDesignationComponent res = new MedicinalProduct.MedicinalProductSpecialDesignationComponent();
    parseMedicinalProductMedicinalProductSpecialDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductSpecialDesignationComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductSpecialDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("intendedUse"))
      res.setIntendedUse(parseCodeableConcept(getJObject(json, "intendedUse")));
    Type indication = parseType("indication", json);
    if (indication != null)
      res.setIndication(indication);
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("species"))
      res.setSpecies(parseCodeableConcept(getJObject(json, "species")));
  }

  protected MedicinalProductAuthorization parseMedicinalProductAuthorization(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization res = new MedicinalProductAuthorization();
    parseMedicinalProductAuthorizationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationProperties(JsonObject json, MedicinalProductAuthorization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDateTime(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(getJObject(json, "_statusDate"), res.getStatusDateElement());
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(getJObject(json, "_restoreDate"), res.getRestoreDateElement());
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(getJObject(json, "validityPeriod")));
    if (json.has("dataExclusivityPeriod"))
      res.setDataExclusivityPeriod(parsePeriod(getJObject(json, "dataExclusivityPeriod")));
    if (json.has("dateOfFirstAuthorization"))
      res.setDateOfFirstAuthorizationElement(parseDateTime(json.get("dateOfFirstAuthorization").getAsString()));
    if (json.has("_dateOfFirstAuthorization"))
      parseElementProperties(getJObject(json, "_dateOfFirstAuthorization"), res.getDateOfFirstAuthorizationElement());
    if (json.has("internationalBirthDate"))
      res.setInternationalBirthDateElement(parseDateTime(json.get("internationalBirthDate").getAsString()));
    if (json.has("_internationalBirthDate"))
      parseElementProperties(getJObject(json, "_internationalBirthDate"), res.getInternationalBirthDateElement());
    if (json.has("legalBasis"))
      res.setLegalBasis(parseCodeableConcept(getJObject(json, "legalBasis")));
    if (json.has("jurisdictionalAuthorization")) {
      JsonArray array = json.getAsJsonArray("jurisdictionalAuthorization");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdictionalAuthorization().add(parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("holder"))
      res.setHolder(parseReference(getJObject(json, "holder")));
    if (json.has("regulator"))
      res.setRegulator(parseReference(getJObject(json, "regulator")));
    if (json.has("procedure"))
      res.setProcedure(parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(getJObject(json, "procedure"), res));
  }

  protected MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(JsonObject json, MedicinalProductAuthorization owner) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent();
    parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentProperties(JsonObject json, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(getJObject(json, "country")));
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(getJObject(json, "legalStatusOfSupply")));
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(getJObject(json, "validityPeriod")));
  }

  protected MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(JsonObject json, MedicinalProductAuthorization owner) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent();
    parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentProperties(JsonObject json, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    Type date = parseType("date", json);
    if (date != null)
      res.setDate(date);
    if (json.has("application")) {
      JsonArray array = json.getAsJsonArray("application");
      for (int i = 0; i < array.size(); i++) {
        res.getApplication().add(parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductContraindication parseMedicinalProductContraindication(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductContraindication res = new MedicinalProductContraindication();
    parseMedicinalProductContraindicationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductContraindicationProperties(JsonObject json, MedicinalProductContraindication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("disease"))
      res.setDisease(parseCodeableConcept(getJObject(json, "disease")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(getJObject(json, "diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("therapeuticIndication")) {
      JsonArray array = json.getAsJsonArray("therapeuticIndication");
      for (int i = 0; i < array.size(); i++) {
        res.getTherapeuticIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parsePopulation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(JsonObject json, MedicinalProductContraindication owner) throws IOException, FHIRFormatError {
    MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res = new MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent();
    parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentProperties(JsonObject json, MedicinalProductContraindication owner, MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(getJObject(json, "therapyRelationshipType")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected MedicinalProductIndication parseMedicinalProductIndication(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductIndication res = new MedicinalProductIndication();
    parseMedicinalProductIndicationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductIndicationProperties(JsonObject json, MedicinalProductIndication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableConcept(getJObject(json, "diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(getJObject(json, "diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intendedEffect"))
      res.setIntendedEffect(parseCodeableConcept(getJObject(json, "intendedEffect")));
    if (json.has("duration"))
      res.setDuration(parseQuantity(getJObject(json, "duration")));
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("undesirableEffect")) {
      JsonArray array = json.getAsJsonArray("undesirableEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffect().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parsePopulation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(JsonObject json, MedicinalProductIndication owner) throws IOException, FHIRFormatError {
    MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res = new MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent();
    parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentProperties(JsonObject json, MedicinalProductIndication owner, MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(getJObject(json, "therapyRelationshipType")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected MedicinalProductIngredient parseMedicinalProductIngredient(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductIngredient res = new MedicinalProductIngredient();
    parseMedicinalProductIngredientProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductIngredientProperties(JsonObject json, MedicinalProductIngredient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specifiedSubstance")) {
      JsonArray array = json.getAsJsonArray("specifiedSubstance");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecifiedSubstance().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("substance"))
      res.setSubstance(parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(getJObject(json, "substance"), res));
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("group"))
      res.setGroup(parseCodeableConcept(getJObject(json, "group")));
    if (json.has("confidentiality"))
      res.setConfidentiality(parseCodeableConcept(getJObject(json, "confidentiality")));
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("presentation"))
      res.setPresentation(parseRatio(getJObject(json, "presentation")));
    if (json.has("presentationLowLimit"))
      res.setPresentationLowLimit(parseRatio(getJObject(json, "presentationLowLimit")));
    if (json.has("concentration"))
      res.setConcentration(parseRatio(getJObject(json, "concentration")));
    if (json.has("concentrationLowLimit"))
      res.setConcentrationLowLimit(parseRatio(getJObject(json, "concentrationLowLimit")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceStrength")) {
      JsonArray array = json.getAsJsonArray("referenceStrength");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(getJObject(json, "substance")));
    if (json.has("strength"))
      res.setStrength(parseRatio(getJObject(json, "strength")));
    if (json.has("strengthLowLimit"))
      res.setStrengthLowLimit(parseRatio(getJObject(json, "strengthLowLimit")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductInteraction parseMedicinalProductInteraction(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductInteraction res = new MedicinalProductInteraction();
    parseMedicinalProductInteractionProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductInteractionProperties(JsonObject json, MedicinalProductInteraction res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("interactant")) {
      JsonArray array = json.getAsJsonArray("interactant");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractant().add(parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("effect"))
      res.setEffect(parseCodeableConcept(getJObject(json, "effect")));
    if (json.has("incidence"))
      res.setIncidence(parseCodeableConcept(getJObject(json, "incidence")));
    if (json.has("management"))
      res.setManagement(parseCodeableConcept(getJObject(json, "management")));
  }

  protected MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(JsonObject json, MedicinalProductInteraction owner) throws IOException, FHIRFormatError {
    MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent res = new MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent();
    parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponentProperties(JsonObject json, MedicinalProductInteraction owner, MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected MedicinalProductManufactured parseMedicinalProductManufactured(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductManufactured res = new MedicinalProductManufactured();
    parseMedicinalProductManufacturedProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductManufacturedProperties(JsonObject json, MedicinalProductManufactured res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("manufacturedDoseForm"))
      res.setManufacturedDoseForm(parseCodeableConcept(getJObject(json, "manufacturedDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(getJObject(json, "unitOfPresentation")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(getJObject(json, "physicalCharacteristics")));
    if (json.has("otherCharacteristics")) {
      JsonArray array = json.getAsJsonArray("otherCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherCharacteristics().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductPackaged parseMedicinalProductPackaged(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductPackaged res = new MedicinalProductPackaged();
    parseMedicinalProductPackagedProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductPackagedProperties(JsonObject json, MedicinalProductPackaged res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(getJObject(json, "legalStatusOfSupply")));
    if (json.has("marketingStatus")) {
      JsonArray array = json.getAsJsonArray("marketingStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketingStatus().add(parseMarketingStatus(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingAuthorization"))
      res.setMarketingAuthorization(parseReference(getJObject(json, "marketingAuthorization")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("batchIdentifier")) {
      JsonArray array = json.getAsJsonArray("batchIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getBatchIdentifier().add(parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("packageItem")) {
      JsonArray array = json.getAsJsonArray("packageItem");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageItem().add(parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(JsonObject json, MedicinalProductPackaged owner) throws IOException, FHIRFormatError {
    MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res = new MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent();
    parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentProperties(JsonObject json, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("outerPackaging"))
      res.setOuterPackaging(parseIdentifier(getJObject(json, "outerPackaging")));
    if (json.has("immediatePackaging"))
      res.setImmediatePackaging(parseIdentifier(getJObject(json, "immediatePackaging")));
  }

  protected MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(JsonObject json, MedicinalProductPackaged owner) throws IOException, FHIRFormatError {
    MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res = new MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent();
    parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentProperties(JsonObject json, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("alternateMaterial")) {
      JsonArray array = json.getAsJsonArray("alternateMaterial");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternateMaterial().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturedItem")) {
      JsonArray array = json.getAsJsonArray("manufacturedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturedItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packageItem")) {
      JsonArray array = json.getAsJsonArray("packageItem");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageItem().add(parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(getJObject(json, "physicalCharacteristics")));
    if (json.has("otherCharacteristics")) {
      JsonArray array = json.getAsJsonArray("otherCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherCharacteristics().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductPharmaceutical parseMedicinalProductPharmaceutical(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical res = new MedicinalProductPharmaceutical();
    parseMedicinalProductPharmaceuticalProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalProperties(JsonObject json, MedicinalProductPharmaceutical res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("administrableDoseForm"))
      res.setAdministrableDoseForm(parseCodeableConcept(getJObject(json, "administrableDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(getJObject(json, "unitOfPresentation")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristics")) {
      JsonArray array = json.getAsJsonArray("characteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristics().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("routeOfAdministration")) {
      JsonArray array = json.getAsJsonArray("routeOfAdministration");
      for (int i = 0; i < array.size(); i++) {
        res.getRouteOfAdministration().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("firstDose"))
      res.setFirstDose(parseQuantity(getJObject(json, "firstDose")));
    if (json.has("maxSingleDose"))
      res.setMaxSingleDose(parseQuantity(getJObject(json, "maxSingleDose")));
    if (json.has("maxDosePerDay"))
      res.setMaxDosePerDay(parseQuantity(getJObject(json, "maxDosePerDay")));
    if (json.has("maxDosePerTreatmentPeriod"))
      res.setMaxDosePerTreatmentPeriod(parseRatio(getJObject(json, "maxDosePerTreatmentPeriod")));
    if (json.has("maxTreatmentPeriod"))
      res.setMaxTreatmentPeriod(parseDuration(getJObject(json, "maxTreatmentPeriod")));
    if (json.has("targetSpecies")) {
      JsonArray array = json.getAsJsonArray("targetSpecies");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetSpecies().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("withdrawalPeriod")) {
      JsonArray array = json.getAsJsonArray("withdrawalPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getWithdrawalPeriod().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("tissue"))
      res.setTissue(parseCodeableConcept(getJObject(json, "tissue")));
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
    if (json.has("supportingInformation"))
      res.setSupportingInformationElement(parseString(json.get("supportingInformation").getAsString()));
    if (json.has("_supportingInformation"))
      parseElementProperties(getJObject(json, "_supportingInformation"), res.getSupportingInformationElement());
  }

  protected MedicinalProductUndesirableEffect parseMedicinalProductUndesirableEffect(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductUndesirableEffect res = new MedicinalProductUndesirableEffect();
    parseMedicinalProductUndesirableEffectProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductUndesirableEffectProperties(JsonObject json, MedicinalProductUndesirableEffect res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("symptomConditionEffect"))
      res.setSymptomConditionEffect(parseCodeableConcept(getJObject(json, "symptomConditionEffect")));
    if (json.has("classification"))
      res.setClassification(parseCodeableConcept(getJObject(json, "classification")));
    if (json.has("frequencyOfOccurrence"))
      res.setFrequencyOfOccurrence(parseCodeableConcept(getJObject(json, "frequencyOfOccurrence")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parsePopulation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MessageDefinition parseMessageDefinition(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseMessageDefinitionProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionProperties(JsonObject json, MessageDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReplaces().add(new CanonicalType());
        } else {
          res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("base"))
      res.setBaseElement(parseCanonical(json.get("base").getAsString()));
    if (json.has("_base"))
      parseElementProperties(getJObject(json, "_base"), res.getBaseElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getParent().add(new CanonicalType());
        } else {
          res.getParent().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_parent")) {
      JsonArray array = json.getAsJsonArray("_parent");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParent().size())
          res.getParent().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParent().get(i));
      }
    };
    Type event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(getJObject(json, "_category"), res.getCategoryElement());
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseMessageDefinitionMessageDefinitionFocusComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("responseRequired"))
      res.setResponseRequiredElement(parseEnumeration(json.get("responseRequired").getAsString(), MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
    if (json.has("_responseRequired"))
      parseElementProperties(getJObject(json, "_responseRequired"), res.getResponseRequiredElement());
    if (json.has("allowedResponse")) {
      JsonArray array = json.getAsJsonArray("allowedResponse");
      for (int i = 0; i < array.size(); i++) {
        res.getAllowedResponse().add(parseMessageDefinitionMessageDefinitionAllowedResponseComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("graph")) {
      JsonArray array = json.getAsJsonArray("graph");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getGraph().add(new CanonicalType());
        } else {
          res.getGraph().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_graph")) {
      JsonArray array = json.getAsJsonArray("_graph");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGraph().size())
          res.getGraph().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGraph().get(i));
      }
    };
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseMessageDefinitionMessageDefinitionFocusComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionFocusComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("message"))
      res.setMessageElement(parseCanonical(json.get("message").getAsString()));
    if (json.has("_message"))
      parseElementProperties(getJObject(json, "_message"), res.getMessageElement());
    if (json.has("situation"))
      res.setSituationElement(parseMarkdown(json.get("situation").getAsString()));
    if (json.has("_situation"))
      parseElementProperties(getJObject(json, "_situation"), res.getSituationElement());
  }

  protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseMessageHeaderProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderProperties(JsonObject json, MessageHeader res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    Type event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(getJObject(json, "sender")));
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("source"))
      res.setSource(parseMessageHeaderMessageSourceComponent(getJObject(json, "source"), res));
    if (json.has("responsible"))
      res.setResponsible(parseReference(getJObject(json, "responsible")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
    if (json.has("response"))
      res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(getJObject(json, "response"), res));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseMessageHeaderMessageDestinationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageDestinationComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("target"))
      res.setTarget(parseReference(getJObject(json, "target")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(getJObject(json, "_endpoint"), res.getEndpointElement());
    if (json.has("receiver"))
      res.setReceiver(parseReference(getJObject(json, "receiver")));
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseMessageHeaderMessageSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageSourceComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("software"))
      res.setSoftwareElement(parseString(json.get("software").getAsString()));
    if (json.has("_software"))
      parseElementProperties(getJObject(json, "_software"), res.getSoftwareElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("contact"))
      res.setContact(parseContactPoint(getJObject(json, "contact")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(getJObject(json, "_endpoint"), res.getEndpointElement());
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseMessageHeaderMessageHeaderResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageHeaderResponseComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseId(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(getJObject(json, "_identifier"), res.getIdentifierElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseReference(getJObject(json, "details")));
  }

  protected MolecularSequence parseMolecularSequence(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence res = new MolecularSequence();
    parseMolecularSequenceProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceProperties(JsonObject json, MolecularSequence res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.SequenceType.NULL, new MolecularSequence.SequenceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("coordinateSystem"))
      res.setCoordinateSystemElement(parseInteger(json.get("coordinateSystem").getAsLong()));
    if (json.has("_coordinateSystem"))
      parseElementProperties(getJObject(json, "_coordinateSystem"), res.getCoordinateSystemElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(getJObject(json, "specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("referenceSeq"))
      res.setReferenceSeq(parseMolecularSequenceMolecularSequenceReferenceSeqComponent(getJObject(json, "referenceSeq"), res));
    if (json.has("variant")) {
      JsonArray array = json.getAsJsonArray("variant");
      for (int i = 0; i < array.size(); i++) {
        res.getVariant().add(parseMolecularSequenceMolecularSequenceVariantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("observedSeq"))
      res.setObservedSeqElement(parseString(json.get("observedSeq").getAsString()));
    if (json.has("_observedSeq"))
      parseElementProperties(getJObject(json, "_observedSeq"), res.getObservedSeqElement());
    if (json.has("quality")) {
      JsonArray array = json.getAsJsonArray("quality");
      for (int i = 0; i < array.size(); i++) {
        res.getQuality().add(parseMolecularSequenceMolecularSequenceQualityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("readCoverage"))
      res.setReadCoverageElement(parseInteger(json.get("readCoverage").getAsLong()));
    if (json.has("_readCoverage"))
      parseElementProperties(getJObject(json, "_readCoverage"), res.getReadCoverageElement());
    if (json.has("repository")) {
      JsonArray array = json.getAsJsonArray("repository");
      for (int i = 0; i < array.size(); i++) {
        res.getRepository().add(parseMolecularSequenceMolecularSequenceRepositoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("pointer")) {
      JsonArray array = json.getAsJsonArray("pointer");
      for (int i = 0; i < array.size(); i++) {
        res.getPointer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("structureVariant")) {
      JsonArray array = json.getAsJsonArray("structureVariant");
      for (int i = 0; i < array.size(); i++) {
        res.getStructureVariant().add(parseMolecularSequenceMolecularSequenceStructureVariantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MolecularSequence.MolecularSequenceReferenceSeqComponent parseMolecularSequenceMolecularSequenceReferenceSeqComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceReferenceSeqComponent res = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
    parseMolecularSequenceMolecularSequenceReferenceSeqComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceReferenceSeqComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceReferenceSeqComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("chromosome"))
      res.setChromosome(parseCodeableConcept(getJObject(json, "chromosome")));
    if (json.has("genomeBuild"))
      res.setGenomeBuildElement(parseString(json.get("genomeBuild").getAsString()));
    if (json.has("_genomeBuild"))
      parseElementProperties(getJObject(json, "_genomeBuild"), res.getGenomeBuildElement());
    if (json.has("orientation"))
      res.setOrientationElement(parseEnumeration(json.get("orientation").getAsString(), MolecularSequence.OrientationType.NULL, new MolecularSequence.OrientationTypeEnumFactory()));
    if (json.has("_orientation"))
      parseElementProperties(getJObject(json, "_orientation"), res.getOrientationElement());
    if (json.has("referenceSeqId"))
      res.setReferenceSeqId(parseCodeableConcept(getJObject(json, "referenceSeqId")));
    if (json.has("referenceSeqPointer"))
      res.setReferenceSeqPointer(parseReference(getJObject(json, "referenceSeqPointer")));
    if (json.has("referenceSeqString"))
      res.setReferenceSeqStringElement(parseString(json.get("referenceSeqString").getAsString()));
    if (json.has("_referenceSeqString"))
      parseElementProperties(getJObject(json, "_referenceSeqString"), res.getReferenceSeqStringElement());
    if (json.has("strand"))
      res.setStrandElement(parseEnumeration(json.get("strand").getAsString(), MolecularSequence.StrandType.NULL, new MolecularSequence.StrandTypeEnumFactory()));
    if (json.has("_strand"))
      parseElementProperties(getJObject(json, "_strand"), res.getStrandElement());
    if (json.has("windowStart"))
      res.setWindowStartElement(parseInteger(json.get("windowStart").getAsLong()));
    if (json.has("_windowStart"))
      parseElementProperties(getJObject(json, "_windowStart"), res.getWindowStartElement());
    if (json.has("windowEnd"))
      res.setWindowEndElement(parseInteger(json.get("windowEnd").getAsLong()));
    if (json.has("_windowEnd"))
      parseElementProperties(getJObject(json, "_windowEnd"), res.getWindowEndElement());
  }

  protected MolecularSequence.MolecularSequenceVariantComponent parseMolecularSequenceMolecularSequenceVariantComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceVariantComponent res = new MolecularSequence.MolecularSequenceVariantComponent();
    parseMolecularSequenceMolecularSequenceVariantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceVariantComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceVariantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("observedAllele"))
      res.setObservedAlleleElement(parseString(json.get("observedAllele").getAsString()));
    if (json.has("_observedAllele"))
      parseElementProperties(getJObject(json, "_observedAllele"), res.getObservedAlleleElement());
    if (json.has("referenceAllele"))
      res.setReferenceAlleleElement(parseString(json.get("referenceAllele").getAsString()));
    if (json.has("_referenceAllele"))
      parseElementProperties(getJObject(json, "_referenceAllele"), res.getReferenceAlleleElement());
    if (json.has("cigar"))
      res.setCigarElement(parseString(json.get("cigar").getAsString()));
    if (json.has("_cigar"))
      parseElementProperties(getJObject(json, "_cigar"), res.getCigarElement());
    if (json.has("variantPointer"))
      res.setVariantPointer(parseReference(getJObject(json, "variantPointer")));
  }

  protected MolecularSequence.MolecularSequenceQualityComponent parseMolecularSequenceMolecularSequenceQualityComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityComponent res = new MolecularSequence.MolecularSequenceQualityComponent();
    parseMolecularSequenceMolecularSequenceQualityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceQualityComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.QualityType.NULL, new MolecularSequence.QualityTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("standardSequence"))
      res.setStandardSequence(parseCodeableConcept(getJObject(json, "standardSequence")));
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("score"))
      res.setScore(parseQuantity(getJObject(json, "score")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("truthTP"))
      res.setTruthTPElement(parseDecimal(json.get("truthTP").getAsBigDecimal()));
    if (json.has("_truthTP"))
      parseElementProperties(getJObject(json, "_truthTP"), res.getTruthTPElement());
    if (json.has("queryTP"))
      res.setQueryTPElement(parseDecimal(json.get("queryTP").getAsBigDecimal()));
    if (json.has("_queryTP"))
      parseElementProperties(getJObject(json, "_queryTP"), res.getQueryTPElement());
    if (json.has("truthFN"))
      res.setTruthFNElement(parseDecimal(json.get("truthFN").getAsBigDecimal()));
    if (json.has("_truthFN"))
      parseElementProperties(getJObject(json, "_truthFN"), res.getTruthFNElement());
    if (json.has("queryFP"))
      res.setQueryFPElement(parseDecimal(json.get("queryFP").getAsBigDecimal()));
    if (json.has("_queryFP"))
      parseElementProperties(getJObject(json, "_queryFP"), res.getQueryFPElement());
    if (json.has("gtFP"))
      res.setGtFPElement(parseDecimal(json.get("gtFP").getAsBigDecimal()));
    if (json.has("_gtFP"))
      parseElementProperties(getJObject(json, "_gtFP"), res.getGtFPElement());
    if (json.has("precision"))
      res.setPrecisionElement(parseDecimal(json.get("precision").getAsBigDecimal()));
    if (json.has("_precision"))
      parseElementProperties(getJObject(json, "_precision"), res.getPrecisionElement());
    if (json.has("recall"))
      res.setRecallElement(parseDecimal(json.get("recall").getAsBigDecimal()));
    if (json.has("_recall"))
      parseElementProperties(getJObject(json, "_recall"), res.getRecallElement());
    if (json.has("fScore"))
      res.setFScoreElement(parseDecimal(json.get("fScore").getAsBigDecimal()));
    if (json.has("_fScore"))
      parseElementProperties(getJObject(json, "_fScore"), res.getFScoreElement());
    if (json.has("roc"))
      res.setRoc(parseMolecularSequenceMolecularSequenceQualityRocComponent(getJObject(json, "roc"), owner));
  }

  protected MolecularSequence.MolecularSequenceQualityRocComponent parseMolecularSequenceMolecularSequenceQualityRocComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityRocComponent res = new MolecularSequence.MolecularSequenceQualityRocComponent();
    parseMolecularSequenceMolecularSequenceQualityRocComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceQualityRocComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityRocComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("score")) {
      JsonArray array = json.getAsJsonArray("score");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getScore().add(new IntegerType());
        } else {
          res.getScore().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_score")) {
      JsonArray array = json.getAsJsonArray("_score");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getScore().size())
          res.getScore().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getScore().get(i));
      }
    };
    if (json.has("numTP")) {
      JsonArray array = json.getAsJsonArray("numTP");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumTP().add(new IntegerType());
        } else {
          res.getNumTP().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numTP")) {
      JsonArray array = json.getAsJsonArray("_numTP");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumTP().size())
          res.getNumTP().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumTP().get(i));
      }
    };
    if (json.has("numFP")) {
      JsonArray array = json.getAsJsonArray("numFP");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumFP().add(new IntegerType());
        } else {
          res.getNumFP().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numFP")) {
      JsonArray array = json.getAsJsonArray("_numFP");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumFP().size())
          res.getNumFP().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumFP().get(i));
      }
    };
    if (json.has("numFN")) {
      JsonArray array = json.getAsJsonArray("numFN");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumFN().add(new IntegerType());
        } else {
          res.getNumFN().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numFN")) {
      JsonArray array = json.getAsJsonArray("_numFN");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumFN().size())
          res.getNumFN().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumFN().get(i));
      }
    };
    if (json.has("precision")) {
      JsonArray array = json.getAsJsonArray("precision");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPrecision().add(new DecimalType());
        } else {
          res.getPrecision().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_precision")) {
      JsonArray array = json.getAsJsonArray("_precision");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrecision().size())
          res.getPrecision().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrecision().get(i));
      }
    };
    if (json.has("sensitivity")) {
      JsonArray array = json.getAsJsonArray("sensitivity");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSensitivity().add(new DecimalType());
        } else {
          res.getSensitivity().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_sensitivity")) {
      JsonArray array = json.getAsJsonArray("_sensitivity");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSensitivity().size())
          res.getSensitivity().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSensitivity().get(i));
      }
    };
    if (json.has("fMeasure")) {
      JsonArray array = json.getAsJsonArray("fMeasure");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFMeasure().add(new DecimalType());
        } else {
          res.getFMeasure().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_fMeasure")) {
      JsonArray array = json.getAsJsonArray("_fMeasure");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFMeasure().size())
          res.getFMeasure().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFMeasure().get(i));
      }
    };
  }

  protected MolecularSequence.MolecularSequenceRepositoryComponent parseMolecularSequenceMolecularSequenceRepositoryComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceRepositoryComponent res = new MolecularSequence.MolecularSequenceRepositoryComponent();
    parseMolecularSequenceMolecularSequenceRepositoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceRepositoryComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceRepositoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.RepositoryType.NULL, new MolecularSequence.RepositoryTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("datasetId"))
      res.setDatasetIdElement(parseString(json.get("datasetId").getAsString()));
    if (json.has("_datasetId"))
      parseElementProperties(getJObject(json, "_datasetId"), res.getDatasetIdElement());
    if (json.has("variantsetId"))
      res.setVariantsetIdElement(parseString(json.get("variantsetId").getAsString()));
    if (json.has("_variantsetId"))
      parseElementProperties(getJObject(json, "_variantsetId"), res.getVariantsetIdElement());
    if (json.has("readsetId"))
      res.setReadsetIdElement(parseString(json.get("readsetId").getAsString()));
    if (json.has("_readsetId"))
      parseElementProperties(getJObject(json, "_readsetId"), res.getReadsetIdElement());
  }

  protected MolecularSequence.MolecularSequenceStructureVariantComponent parseMolecularSequenceMolecularSequenceStructureVariantComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantComponent res = new MolecularSequence.MolecularSequenceStructureVariantComponent();
    parseMolecularSequenceMolecularSequenceStructureVariantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceStructureVariantComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("variantType"))
      res.setVariantType(parseCodeableConcept(getJObject(json, "variantType")));
    if (json.has("exact"))
      res.setExactElement(parseBoolean(json.get("exact").getAsBoolean()));
    if (json.has("_exact"))
      parseElementProperties(getJObject(json, "_exact"), res.getExactElement());
    if (json.has("length"))
      res.setLengthElement(parseInteger(json.get("length").getAsLong()));
    if (json.has("_length"))
      parseElementProperties(getJObject(json, "_length"), res.getLengthElement());
    if (json.has("outer"))
      res.setOuter(parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(getJObject(json, "outer"), owner));
    if (json.has("inner"))
      res.setInner(parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(getJObject(json, "inner"), owner));
  }

  protected MolecularSequence.MolecularSequenceStructureVariantOuterComponent parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantOuterComponent res = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
    parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantOuterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
  }

  protected MolecularSequence.MolecularSequenceStructureVariantInnerComponent parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(JsonObject json, MolecularSequence owner) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantInnerComponent res = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
    parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentProperties(JsonObject json, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantInnerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
  }

  protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseNamingSystemProperties(json, res);
    return res;
  }

  protected void parseNamingSystemProperties(JsonObject json, NamingSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsible"))
      res.setResponsibleElement(parseString(json.get("responsible").getAsString()));
    if (json.has("_responsible"))
      parseElementProperties(getJObject(json, "_responsible"), res.getResponsibleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("uniqueId")) {
      JsonArray array = json.getAsJsonArray("uniqueId");
      for (int i = 0; i < array.size(); i++) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseNamingSystemNamingSystemUniqueIdComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNamingSystemNamingSystemUniqueIdComponentProperties(JsonObject json, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(getJObject(json, "_preferred"), res.getPreferredElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseNutritionOrderProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderProperties(JsonObject json, NutritionOrder res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new UriType());
        } else {
          res.getInstantiates().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), NutritionOrder.NutritiionOrderIntent.NULL, new NutritionOrder.NutritiionOrderIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(getJObject(json, "_dateTime"), res.getDateTimeElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(getJObject(json, "orderer")));
    if (json.has("allergyIntolerance")) {
      JsonArray array = json.getAsJsonArray("allergyIntolerance");
      for (int i = 0; i < array.size(); i++) {
        res.getAllergyIntolerance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("foodPreferenceModifier")) {
      JsonArray array = json.getAsJsonArray("foodPreferenceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("excludeFoodModifier")) {
      JsonArray array = json.getAsJsonArray("excludeFoodModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("oralDiet"))
      res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(getJObject(json, "oralDiet"), res));
    if (json.has("supplement")) {
      JsonArray array = json.getAsJsonArray("supplement");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplement().add(parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("enteralFormula"))
      res.setEnteralFormula(parseNutritionOrderNutritionOrderEnteralFormulaComponent(getJObject(json, "enteralFormula"), res));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseNutritionOrderNutritionOrderOralDietComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("nutrient")) {
      JsonArray array = json.getAsJsonArray("nutrient");
      for (int i = 0; i < array.size(); i++) {
        res.getNutrient().add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("texture")) {
      JsonArray array = json.getAsJsonArray("texture");
      for (int i = 0; i < array.size(); i++) {
        res.getTexture().add(parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fluidConsistencyType")) {
      JsonArray array = json.getAsJsonArray("fluidConsistencyType");
      for (int i = 0; i < array.size(); i++) {
        res.getFluidConsistencyType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(getJObject(json, "_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(getJObject(json, "modifier")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(getJObject(json, "amount")));
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(getJObject(json, "modifier")));
    if (json.has("foodType"))
      res.setFoodType(parseCodeableConcept(getJObject(json, "foodType")));
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseNutritionOrderNutritionOrderSupplementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderSupplementComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(getJObject(json, "_productName"), res.getProductNameElement());
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(getJObject(json, "_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("baseFormulaType"))
      res.setBaseFormulaType(parseCodeableConcept(getJObject(json, "baseFormulaType")));
    if (json.has("baseFormulaProductName"))
      res.setBaseFormulaProductNameElement(parseString(json.get("baseFormulaProductName").getAsString()));
    if (json.has("_baseFormulaProductName"))
      parseElementProperties(getJObject(json, "_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
    if (json.has("additiveType"))
      res.setAdditiveType(parseCodeableConcept(getJObject(json, "additiveType")));
    if (json.has("additiveProductName"))
      res.setAdditiveProductNameElement(parseString(json.get("additiveProductName").getAsString()));
    if (json.has("_additiveProductName"))
      parseElementProperties(getJObject(json, "_additiveProductName"), res.getAdditiveProductNameElement());
    if (json.has("caloricDensity"))
      res.setCaloricDensity(parseQuantity(getJObject(json, "caloricDensity")));
    if (json.has("routeofAdministration"))
      res.setRouteofAdministration(parseCodeableConcept(getJObject(json, "routeofAdministration")));
    if (json.has("administration")) {
      JsonArray array = json.getAsJsonArray("administration");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("maxVolumeToDeliver"))
      res.setMaxVolumeToDeliver(parseQuantity(getJObject(json, "maxVolumeToDeliver")));
    if (json.has("administrationInstruction"))
      res.setAdministrationInstructionElement(parseString(json.get("administrationInstruction").getAsString()));
    if (json.has("_administrationInstruction"))
      parseElementProperties(getJObject(json, "_administrationInstruction"), res.getAdministrationInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseTiming(getJObject(json, "schedule")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
    Observation res = new Observation();
    parseObservationProperties(json, res);
    return res;
  }

  protected void parseObservationProperties(JsonObject json, Observation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(getJObject(json, "dataAbsentReason")));
    if (json.has("interpretation")) {
      JsonArray array = json.getAsJsonArray("interpretation");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpretation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(getJObject(json, "specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("hasMember")) {
      JsonArray array = json.getAsJsonArray("hasMember");
      for (int i = 0; i < array.size(); i++) {
        res.getHasMember().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseObservationObservationReferenceRangeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationReferenceRangeComponentProperties(JsonObject json, Observation owner, Observation.ObservationReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(getJObject(json, "low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(getJObject(json, "high")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("appliesTo")) {
      JsonArray array = json.getAsJsonArray("appliesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getAppliesTo().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("age"))
      res.setAge(parseRange(getJObject(json, "age")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseObservationObservationComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationComponentComponentProperties(JsonObject json, Observation owner, Observation.ObservationComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(getJObject(json, "dataAbsentReason")));
    if (json.has("interpretation")) {
      JsonArray array = json.getAsJsonArray("interpretation");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpretation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ObservationDefinition parseObservationDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ObservationDefinition res = new ObservationDefinition();
    parseObservationDefinitionProperties(json, res);
    return res;
  }

  protected void parseObservationDefinitionProperties(JsonObject json, ObservationDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("permittedDataType")) {
      JsonArray array = json.getAsJsonArray("permittedDataType");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPermittedDataType().add(new Enumeration<ObservationDefinition.ObservationDataType>());
        } else {
          res.getPermittedDataType().add(parseEnumeration(array.get(i).getAsString(), ObservationDefinition.ObservationDataType.NULL, new ObservationDefinition.ObservationDataTypeEnumFactory()));
        }
      }
    };
    if (json.has("_permittedDataType")) {
      JsonArray array = json.getAsJsonArray("_permittedDataType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPermittedDataType().size())
          res.getPermittedDataType().add(parseEnumeration(null, ObservationDefinition.ObservationDataType.NULL, new ObservationDefinition.ObservationDataTypeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPermittedDataType().get(i));
      }
    };
    if (json.has("multipleResultsAllowed"))
      res.setMultipleResultsAllowedElement(parseBoolean(json.get("multipleResultsAllowed").getAsBoolean()));
    if (json.has("_multipleResultsAllowed"))
      parseElementProperties(getJObject(json, "_multipleResultsAllowed"), res.getMultipleResultsAllowedElement());
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("preferredReportName"))
      res.setPreferredReportNameElement(parseString(json.get("preferredReportName").getAsString()));
    if (json.has("_preferredReportName"))
      parseElementProperties(getJObject(json, "_preferredReportName"), res.getPreferredReportNameElement());
    if (json.has("quantitativeDetails"))
      res.setQuantitativeDetails(parseObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(getJObject(json, "quantitativeDetails"), res));
    if (json.has("qualifiedInterval")) {
      JsonArray array = json.getAsJsonArray("qualifiedInterval");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiedInterval().add(parseObservationDefinitionObservationDefinitionQualifiedIntervalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("validCodedValueSet"))
      res.setValidCodedValueSet(