/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="Linkage", profile="http://hl7.org/fhir/StructureDefinition/Linkage")
public class Linkage
extends DomainResource {
    @Child(name="active", type={BooleanType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this linkage assertion is active or not", formalDefinition="Indicates whether the asserted set of linkages are considered to be \"in effect\".")
    protected BooleanType active;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for linkages", formalDefinition="Identifies the user or organization responsible for asserting the linkages as well as the user or organization who establishes the context in which the nature of each linkage is evaluated.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="item", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Item to be linked", formalDefinition="Identifies which record considered as the reference to the same real-world occurrence as well as how the items should be evaluated within the collection of linked items.")
    protected List<LinkageItemComponent> item;
    private static final long serialVersionUID = 25900306L;
    @SearchParamDefinition(name="item", path="Linkage.item.resource", description="Matches on any item in the Linkage", type="reference")
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    public static final Include INCLUDE_ITEM = new Include("Linkage:item").toLocked();
    @SearchParamDefinition(name="author", path="Linkage.author", description="Author of the Linkage", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Linkage:author").toLocked();
    @SearchParamDefinition(name="source", path="Linkage.item.resource", description="Matches on any item in the Linkage with a type of 'source'", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("Linkage:source").toLocked();

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Linkage.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Linkage setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Linkage setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Linkage.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Linkage setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Linkage setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public List<LinkageItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        return this.item;
    }

    public Linkage setItem(List<LinkageItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (LinkageItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LinkageItemComponent addItem() {
        LinkageItemComponent t = new LinkageItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Linkage addItem(LinkageItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public LinkageItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("active", "boolean", "Indicates whether the asserted set of linkages are considered to be \"in effect\".", 0, 1, this.active));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the user or organization responsible for asserting the linkages as well as the user or organization who establishes the context in which the nature of each linkage is evaluated.", 0, 1, this.author));
        children.add(new Property(SP_ITEM, "", "Identifies which record considered as the reference to the same real-world occurrence as well as how the items should be evaluated within the collection of linked items.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1422950650: {
                return new Property("active", "boolean", "Indicates whether the asserted set of linkages are considered to be \"in effect\".", 0, 1, this.active);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the user or organization responsible for asserting the linkages as well as the user or organization who establishes the context in which the nature of each linkage is evaluated.", 0, 1, this.author);
            }
            case 3242771: {
                return new Property(SP_ITEM, "", "Identifies which record considered as the reference to the same real-world occurrence as well as how the items should be evaluated within the collection of linked items.", 0, Integer.MAX_VALUE, this.item);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.author;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((LinkageItemComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("active")) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_ITEM)) {
            this.getItem().add((LinkageItemComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1422950650: {
                return this.getActiveElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 3242771: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a primitive type Linkage.active");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_ITEM)) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Linkage";
    }

    @Override
    public Linkage copy() {
        Linkage dst = new Linkage();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Linkage dst) {
        super.copyValues(dst);
        dst.active = this.active == null ? null : this.active.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.item != null) {
            dst.item = new ArrayList<LinkageItemComponent>();
            for (LinkageItemComponent i : this.item) {
                dst.item.add(i.copy());
            }
        }
    }

    protected Linkage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Linkage)) {
            return false;
        }
        Linkage o = (Linkage)other_;
        return Linkage.compareDeep(this.active, o.active, true) && Linkage.compareDeep(this.author, o.author, true) && Linkage.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Linkage)) {
            return false;
        }
        Linkage o = (Linkage)other_;
        return Linkage.compareValues(this.active, o.active, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.active, this.author, this.item});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Linkage;
    }

    @Block
    public static class LinkageItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | alternate | historical", formalDefinition="Distinguishes which item is \"source of truth\" (if any) and which items are no longer considered to be current representations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/linkage-type")
        protected Enumeration<LinkageType> type;
        @Child(name="resource", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Resource being linked", formalDefinition="The resource instance being linked as part of the group.")
        protected Reference resource;
        protected Resource resourceTarget;
        private static final long serialVersionUID = -209332008L;

        public LinkageItemComponent() {
        }

        public LinkageItemComponent(Enumeration<LinkageType> type, Reference resource) {
            this.type = type;
            this.resource = resource;
        }

        public Enumeration<LinkageType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LinkageItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<LinkageType>(new LinkageTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public LinkageItemComponent setTypeElement(Enumeration<LinkageType> value) {
            this.type = value;
            return this;
        }

        public LinkageType getType() {
            return this.type == null ? null : (LinkageType)((Object)this.type.getValue());
        }

        public LinkageItemComponent setType(LinkageType value) {
            if (this.type == null) {
                this.type = new Enumeration<LinkageType>(new LinkageTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LinkageItemComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public LinkageItemComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public LinkageItemComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Distinguishes which item is \"source of truth\" (if any) and which items are no longer considered to be current representations.", 0, 1, this.type));
            children.add(new Property("resource", "Reference(Any)", "The resource instance being linked as part of the group.", 0, 1, this.resource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Distinguishes which item is \"source of truth\" (if any) and which items are no longer considered to be current representations.", 0, 1, this.type);
                }
                case -341064690: {
                    return new Property("resource", "Reference(Any)", "The resource instance being linked as part of the group.", 0, 1, this.resource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new LinkageTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new LinkageTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -341064690: {
                    return this.getResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -341064690: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Linkage.type");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            return super.addChild(name);
        }

        @Override
        public LinkageItemComponent copy() {
            LinkageItemComponent dst = new LinkageItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(LinkageItemComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof LinkageItemComponent)) {
                return false;
            }
            LinkageItemComponent o = (LinkageItemComponent)other_;
            return LinkageItemComponent.compareDeep(this.type, o.type, true) && LinkageItemComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof LinkageItemComponent)) {
                return false;
            }
            LinkageItemComponent o = (LinkageItemComponent)other_;
            return LinkageItemComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.resource});
        }

        @Override
        public String fhirType() {
            return "Linkage.item";
        }
    }

    public static class LinkageTypeEnumFactory
    implements EnumFactory<LinkageType> {
        @Override
        public LinkageType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return LinkageType.SOURCE;
            }
            if ("alternate".equals(codeString)) {
                return LinkageType.ALTERNATE;
            }
            if ("historical".equals(codeString)) {
                return LinkageType.HISTORICAL;
            }
            throw new IllegalArgumentException("Unknown LinkageType code '" + codeString + "'");
        }

        public Enumeration<LinkageType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<LinkageType>(this, LinkageType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.NULL, code);
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.SOURCE, code);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.ALTERNATE, code);
            }
            if ("historical".equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.HISTORICAL, code);
            }
            throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
        }

        @Override
        public String toCode(LinkageType code) {
            if (code == LinkageType.SOURCE) {
                return Linkage.SP_SOURCE;
            }
            if (code == LinkageType.ALTERNATE) {
                return "alternate";
            }
            if (code == LinkageType.HISTORICAL) {
                return "historical";
            }
            return "?";
        }

        @Override
        public String toSystem(LinkageType code) {
            return code.getSystem();
        }
    }

    public static enum LinkageType {
        SOURCE,
        ALTERNATE,
        HISTORICAL,
        NULL;


        public static LinkageType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return SOURCE;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if ("historical".equals(codeString)) {
                return HISTORICAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return Linkage.SP_SOURCE;
                }
                case ALTERNATE: {
                    return "alternate";
                }
                case HISTORICAL: {
                    return "historical";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case HISTORICAL: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "The resource represents the \"source of truth\" (from the perspective of this Linkage resource) for the underlying event/condition/etc.";
                }
                case ALTERNATE: {
                    return "The resource represents an alternative view of the underlying event/condition/etc.  The resource may still be actively maintained, even though it is not considered to be the source of truth.";
                }
                case HISTORICAL: {
                    return "The resource represents an obsolete record of the underlying event/condition/etc.  It is not expected to be actively maintained.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source of Truth";
                }
                case ALTERNATE: {
                    return "Alternate Record";
                }
                case HISTORICAL: {
                    return "Historical/Obsolete Record";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

