/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchElementDefinition", profile="http://hl7.org/fhir/StructureDefinition/ResearchElementDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "shortTitle", "subtitle", "status", "experimental", "subject[x]", "date", "publisher", "contact", "description", "comment", "useContext", "jurisdiction", "purpose", "usage", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact", "library", "type", "variableType", "characteristic"})
public class ResearchElementDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the research element definition", formalDefinition="A formal identifier that is used to identify this research element definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="shortTitle", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Title for use in informal contexts", formalDefinition="The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.")
    protected StringType shortTitle;
    @Child(name="subtitle", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the ResearchElementDefinition", formalDefinition="An explanatory or alternate title for the ResearchElementDefinition giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="subject", type={CodeableConcept.class, Group.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Patient, Practitioner, RelatedPerson, Organization, Location, Device", formalDefinition="The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    protected Type subject;
    @Child(name="comment", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
    protected List<StringType> comment;
    @Child(name="purpose", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this research element definition is defined", formalDefinition="Explanation of why this research element definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the ResearchElementDefinition", formalDefinition="A detailed description, from a clinical perspective, of how the ResearchElementDefinition is used.")
    protected StringType usage;
    @Child(name="copyright", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the research element definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the research element definition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the research element definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the research element definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the research element definition is expected to be used", formalDefinition="The period during which the research element definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the ResearchElementDefinition, such as Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the ResearchElementDefinition. Topics provide a high-level categorization grouping types of ResearchElementDefinitions that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={CanonicalType.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the ResearchElementDefinition", formalDefinition="A reference to a Library resource containing the formal logic used by the ResearchElementDefinition.")
    protected List<CanonicalType> library;
    @Child(name="type", type={CodeType.class}, order=18, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="population | exposure | outcome", formalDefinition="The type of research element, a population, an exposure, or an outcome.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-element-type")
    protected Enumeration<ResearchElementType> type;
    @Child(name="variableType", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="dichotomous | continuous | descriptive", formalDefinition="The type of the outcome (e.g. Dichotomous, Continuous, or Descriptive).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-type")
    protected Enumeration<VariableType> variableType;
    @Child(name="characteristic", type={}, order=20, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What defines the members of the research element", formalDefinition="A characteristic that defines the members of the research element. Multiple characteristics are applied with \"and\" semantics.")
    protected List<ResearchElementDefinitionCharacteristicComponent> characteristic;
    private static final long serialVersionUID = 1483216033L;
    @SearchParamDefinition(name="date", path="ResearchElementDefinition.date", description="The research element definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchElementDefinition.identifier", description="External identifier for the research element definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="ResearchElementDefinition.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("ResearchElementDefinition:successor").toLocked();
    @SearchParamDefinition(name="context-type-value", path="ResearchElementDefinition.useContext", description="A use context type and value assigned to the research element definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="ResearchElementDefinition.jurisdiction", description="Intended jurisdiction for the research element definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ResearchElementDefinition.description", description="The description of the research element definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="ResearchElementDefinition.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ResearchElementDefinition:derived-from").toLocked();
    @SearchParamDefinition(name="context-type", path="ResearchElementDefinition.useContext.code", description="A type of use context assigned to the research element definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="predecessor", path="ResearchElementDefinition.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("ResearchElementDefinition:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="ResearchElementDefinition.title", description="The human-friendly name of the research element definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="ResearchElementDefinition.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("ResearchElementDefinition:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="ResearchElementDefinition.version", description="The business version of the research element definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ResearchElementDefinition.url", description="The uri that identifies the research element definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(ResearchElementDefinition.useContext.value as Quantity) | (ResearchElementDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the research element definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="ResearchElementDefinition.effectivePeriod", description="The time during which the research element definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="ResearchElementDefinition.relatedArtifact.where(type='depends-on').resource | ResearchElementDefinition.library", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("ResearchElementDefinition:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="ResearchElementDefinition.name", description="Computationally friendly name of the research element definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(ResearchElementDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the research element definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="ResearchElementDefinition.publisher", description="Name of the publisher of the research element definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="ResearchElementDefinition.topic", description="Topics associated with the ResearchElementDefinition", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="context-type-quantity", path="ResearchElementDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the research element definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="ResearchElementDefinition.status", description="The current status of the research element definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ResearchElementDefinition() {
    }

    public ResearchElementDefinition(Enumeration<Enumerations.PublicationStatus> status, Enumeration<ResearchElementType> type) {
        this.status = status;
        this.type = type;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ResearchElementDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ResearchElementDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchElementDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchElementDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ResearchElementDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ResearchElementDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ResearchElementDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ResearchElementDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ResearchElementDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ResearchElementDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getShortTitleElement() {
        if (this.shortTitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.shortTitle");
            }
            if (Configuration.doAutoCreate()) {
                this.shortTitle = new StringType();
            }
        }
        return this.shortTitle;
    }

    public boolean hasShortTitleElement() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public boolean hasShortTitle() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public ResearchElementDefinition setShortTitleElement(StringType value) {
        this.shortTitle = value;
        return this;
    }

    public String getShortTitle() {
        return this.shortTitle == null ? null : (String)this.shortTitle.getValue();
    }

    public ResearchElementDefinition setShortTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.shortTitle = null;
        } else {
            if (this.shortTitle == null) {
                this.shortTitle = new StringType();
            }
            this.shortTitle.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public ResearchElementDefinition setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public ResearchElementDefinition setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ResearchElementDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ResearchElementDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ResearchElementDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ResearchElementDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public Type getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ResearchElementDefinition setSubject(Type value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for ResearchElementDefinition.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ResearchElementDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ResearchElementDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ResearchElementDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ResearchElementDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ResearchElementDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ResearchElementDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ResearchElementDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ResearchElementDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<StringType> getComment() {
        if (this.comment == null) {
            this.comment = new ArrayList<StringType>();
        }
        return this.comment;
    }

    public ResearchElementDefinition setComment(List<StringType> theComment) {
        this.comment = theComment;
        return this;
    }

    public boolean hasComment() {
        if (this.comment == null) {
            return false;
        }
        for (StringType item : this.comment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addCommentElement() {
        StringType t = new StringType();
        if (this.comment == null) {
            this.comment = new ArrayList<StringType>();
        }
        this.comment.add(t);
        return t;
    }

    public ResearchElementDefinition addComment(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.comment == null) {
            this.comment = new ArrayList<StringType>();
        }
        this.comment.add(t);
        return this;
    }

    public boolean hasComment(String value) {
        if (this.comment == null) {
            return false;
        }
        for (StringType v : this.comment) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ResearchElementDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ResearchElementDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ResearchElementDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ResearchElementDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ResearchElementDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ResearchElementDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public ResearchElementDefinition setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public ResearchElementDefinition setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ResearchElementDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ResearchElementDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ResearchElementDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ResearchElementDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ResearchElementDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ResearchElementDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ResearchElementDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public ResearchElementDefinition setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public ResearchElementDefinition addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public ResearchElementDefinition setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public ResearchElementDefinition addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public ResearchElementDefinition setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public ResearchElementDefinition addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public ResearchElementDefinition setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public ResearchElementDefinition addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public ResearchElementDefinition setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public ResearchElementDefinition addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ResearchElementDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ResearchElementDefinition addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CanonicalType> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        return this.library;
    }

    public ResearchElementDefinition setLibrary(List<CanonicalType> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addLibraryElement() {
        CanonicalType t = new CanonicalType();
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return t;
    }

    public ResearchElementDefinition addLibrary(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return this;
    }

    public boolean hasLibrary(String value) {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType v : this.library) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ResearchElementType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ResearchElementType>(new ResearchElementTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ResearchElementDefinition setTypeElement(Enumeration<ResearchElementType> value) {
        this.type = value;
        return this;
    }

    public ResearchElementType getType() {
        return this.type == null ? null : (ResearchElementType)((Object)this.type.getValue());
    }

    public ResearchElementDefinition setType(ResearchElementType value) {
        if (this.type == null) {
            this.type = new Enumeration<ResearchElementType>(new ResearchElementTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Enumeration<VariableType> getVariableTypeElement() {
        if (this.variableType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchElementDefinition.variableType");
            }
            if (Configuration.doAutoCreate()) {
                this.variableType = new Enumeration<VariableType>(new VariableTypeEnumFactory());
            }
        }
        return this.variableType;
    }

    public boolean hasVariableTypeElement() {
        return this.variableType != null && !this.variableType.isEmpty();
    }

    public boolean hasVariableType() {
        return this.variableType != null && !this.variableType.isEmpty();
    }

    public ResearchElementDefinition setVariableTypeElement(Enumeration<VariableType> value) {
        this.variableType = value;
        return this;
    }

    public VariableType getVariableType() {
        return this.variableType == null ? null : (VariableType)((Object)this.variableType.getValue());
    }

    public ResearchElementDefinition setVariableType(VariableType value) {
        if (value == null) {
            this.variableType = null;
        } else {
            if (this.variableType == null) {
                this.variableType = new Enumeration<VariableType>(new VariableTypeEnumFactory());
            }
            this.variableType.setValue((Object)value);
        }
        return this;
    }

    public List<ResearchElementDefinitionCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ResearchElementDefinitionCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public ResearchElementDefinition setCharacteristic(List<ResearchElementDefinitionCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (ResearchElementDefinitionCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchElementDefinitionCharacteristicComponent addCharacteristic() {
        ResearchElementDefinitionCharacteristicComponent t = new ResearchElementDefinitionCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ResearchElementDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public ResearchElementDefinition addCharacteristic(ResearchElementDefinitionCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ResearchElementDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public ResearchElementDefinitionCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this research element definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this research element definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the research element definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this research element definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the research element definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the research element definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the research element definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the research element definition.", 0, 1, this.title));
        children.add(new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the ResearchElementDefinition giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this research element definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this research element definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the research element definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the research element definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the research element definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the research element definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("comment", "string", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.comment));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate research element definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the research element definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this research element definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description, from a clinical perspective, of how the ResearchElementDefinition is used.", 0, 1, this.usage));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the research element definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the research element definition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the research element definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the ResearchElementDefinition. Topics provide a high-level categorization grouping types of ResearchElementDefinitions that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "canonical(Library)", "A reference to a Library resource containing the formal logic used by the ResearchElementDefinition.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("type", "code", "The type of research element, a population, an exposure, or an outcome.", 0, 1, this.type));
        children.add(new Property("variableType", "code", "The type of the outcome (e.g. Dichotomous, Continuous, or Descriptive).", 0, 1, this.variableType));
        children.add(new Property("characteristic", "", "A characteristic that defines the members of the research element. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this research element definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this research element definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the research element definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this research element definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the research element definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the research element definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the research element definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the research element definition.", 0, 1, this.title);
            }
            case 1555503932: {
                return new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the ResearchElementDefinition giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this research element definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this research element definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the ResearchElementDefinition. If this element is not provided, a Patient subject is assumed, but the subject of the ResearchElementDefinition can be anything.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the research element definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the research element definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the research element definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the research element definition from a consumer's perspective.", 0, 1, this.description);
            }
            case 950398559: {
                return new Property("comment", "string", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.comment);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate research element definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the research element definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this research element definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description, from a clinical perspective, of how the ResearchElementDefinition is used.", 0, 1, this.usage);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the research element definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the research element definition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the research element definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the ResearchElementDefinition. Topics provide a high-level categorization grouping types of ResearchElementDefinitions that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "canonical(Library)", "A reference to a Library resource containing the formal logic used by the ResearchElementDefinition.", 0, Integer.MAX_VALUE, this.library);
            }
            case 3575610: {
                return new Property("type", "code", "The type of research element, a population, an exposure, or an outcome.", 0, 1, this.type);
            }
            case -372820010: {
                return new Property("variableType", "code", "The type of the outcome (e.g. Dichotomous, Continuous, or Descriptive).", 0, 1, this.variableType);
            }
            case 366313883: {
                return new Property("characteristic", "", "A characteristic that defines the members of the research element. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 1555503932: {
                Base[] baseArray;
                if (this.shortTitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.shortTitle;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.description;
                }
                return baseArray;
            }
            case 950398559: {
                return this.comment == null ? new Base[]{} : this.comment.toArray(new Base[this.comment.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.usage;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.type;
                }
                return baseArray;
            }
            case -372820010: {
                Base[] baseArray;
                if (this.variableType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.variableType;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case 1555503932: {
                this.shortTitle = this.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 950398559: {
                this.getComment().add(this.castToString(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(this.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(this.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(this.castToCanonical(value));
                return value;
            }
            case 3575610: {
                value = new ResearchElementTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case -372820010: {
                value = new VariableTypeEnumFactory().fromType(this.castToCode(value));
                this.variableType = value;
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((ResearchElementDefinitionCharacteristicComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("shortTitle")) {
            this.shortTitle = this.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("subject[x]")) {
            this.subject = this.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("comment")) {
            this.getComment().add(this.castToString(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToCanonical(value));
        } else if (name.equals("type")) {
            value = new ResearchElementTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("variableType")) {
            value = new VariableTypeEnumFactory().fromType(this.castToCode(value));
            this.variableType = value;
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((ResearchElementDefinitionCharacteristicComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1555503932: {
                return this.getShortTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 950398559: {
                return this.addCommentElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibraryElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -372820010: {
                return this.getVariableTypeElement();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1555503932: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"canonical"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -372820010: {
                return new String[]{"code"};
            }
            case 366313883: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.title");
        }
        if (name.equals("shortTitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.shortTitle");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.experimental");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.description");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.comment");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.usage");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.library");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.type");
        }
        if (name.equals("variableType")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.variableType");
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchElementDefinition";
    }

    @Override
    public ResearchElementDefinition copy() {
        ResearchElementDefinition dst = new ResearchElementDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchElementDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.shortTitle = this.shortTitle == null ? null : this.shortTitle.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.comment != null) {
            dst.comment = new ArrayList<StringType>();
            for (StringType stringType2 : this.comment) {
                dst.comment.add(stringType2.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.library) {
                dst.library.add(canonicalType.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        Enumeration<VariableType> enumeration = dst.variableType = this.variableType == null ? null : this.variableType.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<ResearchElementDefinitionCharacteristicComponent>();
            for (ResearchElementDefinitionCharacteristicComponent researchElementDefinitionCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(researchElementDefinitionCharacteristicComponent.copy());
            }
        }
    }

    protected ResearchElementDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchElementDefinition)) {
            return false;
        }
        ResearchElementDefinition o = (ResearchElementDefinition)other_;
        return ResearchElementDefinition.compareDeep(this.identifier, o.identifier, true) && ResearchElementDefinition.compareDeep(this.shortTitle, o.shortTitle, true) && ResearchElementDefinition.compareDeep(this.subtitle, o.subtitle, true) && ResearchElementDefinition.compareDeep(this.subject, o.subject, true) && ResearchElementDefinition.compareDeep(this.comment, o.comment, true) && ResearchElementDefinition.compareDeep(this.purpose, o.purpose, true) && ResearchElementDefinition.compareDeep(this.usage, o.usage, true) && ResearchElementDefinition.compareDeep(this.copyright, o.copyright, true) && ResearchElementDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ResearchElementDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ResearchElementDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ResearchElementDefinition.compareDeep(this.topic, o.topic, true) && ResearchElementDefinition.compareDeep(this.author, o.author, true) && ResearchElementDefinition.compareDeep(this.editor, o.editor, true) && ResearchElementDefinition.compareDeep(this.reviewer, o.reviewer, true) && ResearchElementDefinition.compareDeep(this.endorser, o.endorser, true) && ResearchElementDefinition.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ResearchElementDefinition.compareDeep(this.library, o.library, true) && ResearchElementDefinition.compareDeep(this.type, o.type, true) && ResearchElementDefinition.compareDeep(this.variableType, o.variableType, true) && ResearchElementDefinition.compareDeep(this.characteristic, o.characteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchElementDefinition)) {
            return false;
        }
        ResearchElementDefinition o = (ResearchElementDefinition)other_;
        return ResearchElementDefinition.compareValues(this.shortTitle, o.shortTitle, true) && ResearchElementDefinition.compareValues(this.subtitle, o.subtitle, true) && ResearchElementDefinition.compareValues(this.comment, o.comment, true) && ResearchElementDefinition.compareValues(this.purpose, o.purpose, true) && ResearchElementDefinition.compareValues(this.usage, o.usage, true) && ResearchElementDefinition.compareValues(this.copyright, o.copyright, true) && ResearchElementDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ResearchElementDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ResearchElementDefinition.compareValues(this.type, o.type, true) && ResearchElementDefinition.compareValues(this.variableType, o.variableType, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.shortTitle, this.subtitle, this.subject, this.comment, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.type, this.variableType, this.characteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchElementDefinition;
    }

    @Block
    public static class ResearchElementDefinitionCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="definition", type={CodeableConcept.class, CanonicalType.class, Expression.class, DataRequirement.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What code or expression defines members?", formalDefinition="Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).")
        protected Type definition;
        @Child(name="usageContext", type={UsageContext.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What code/value pairs define members?", formalDefinition="Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.")
        protected List<UsageContext> usageContext;
        @Child(name="exclude", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the characteristic includes or excludes members", formalDefinition="When true, members with this characteristic are excluded from the element.")
        protected BooleanType exclude;
        @Child(name="unitOfMeasure", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What unit is the outcome described in?", formalDefinition="Specifies the UCUM unit for the outcome.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        protected CodeableConcept unitOfMeasure;
        @Child(name="studyEffectiveDescription", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What time period does the study cover", formalDefinition="A narrative description of the time period the study covers.")
        protected StringType studyEffectiveDescription;
        @Child(name="studyEffective", type={DateTimeType.class, Period.class, Duration.class, Timing.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What time period does the study cover", formalDefinition="Indicates what effective period the study covers.")
        protected Type studyEffective;
        @Child(name="studyEffectiveTimeFromStart", type={Duration.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Observation time from study start", formalDefinition="Indicates duration from the study initiation.")
        protected Duration studyEffectiveTimeFromStart;
        @Child(name="studyEffectiveGroupMeasure", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mean | median | mean-of-mean | mean-of-median | median-of-mean | median-of-median", formalDefinition="Indicates how elements are aggregated within the study effective period.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/group-measure")
        protected Enumeration<GroupMeasure> studyEffectiveGroupMeasure;
        @Child(name="participantEffectiveDescription", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What time period do participants cover", formalDefinition="A narrative description of the time period the study covers.")
        protected StringType participantEffectiveDescription;
        @Child(name="participantEffective", type={DateTimeType.class, Period.class, Duration.class, Timing.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What time period do participants cover", formalDefinition="Indicates what effective period the study covers.")
        protected Type participantEffective;
        @Child(name="participantEffectiveTimeFromStart", type={Duration.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Observation time from study start", formalDefinition="Indicates duration from the participant's study entry.")
        protected Duration participantEffectiveTimeFromStart;
        @Child(name="participantEffectiveGroupMeasure", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mean | median | mean-of-mean | mean-of-median | median-of-mean | median-of-median", formalDefinition="Indicates how elements are aggregated within the study effective period.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/group-measure")
        protected Enumeration<GroupMeasure> participantEffectiveGroupMeasure;
        private static final long serialVersionUID = -1102952665L;

        public ResearchElementDefinitionCharacteristicComponent() {
        }

        public ResearchElementDefinitionCharacteristicComponent(Type definition) {
            this.definition = definition;
        }

        public Type getDefinition() {
            return this.definition;
        }

        public CodeableConcept getDefinitionCodeableConcept() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CodeableConcept();
            }
            if (!(this.definition instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.definition;
        }

        public boolean hasDefinitionCodeableConcept() {
            return this != null && this.definition instanceof CodeableConcept;
        }

        public CanonicalType getDefinitionCanonicalType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            if (!(this.definition instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.definition;
        }

        public boolean hasDefinitionCanonicalType() {
            return this != null && this.definition instanceof CanonicalType;
        }

        public Expression getDefinitionExpression() throws FHIRException {
            if (this.definition == null) {
                this.definition = new Expression();
            }
            if (!(this.definition instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (Expression)this.definition;
        }

        public boolean hasDefinitionExpression() {
            return this != null && this.definition instanceof Expression;
        }

        public DataRequirement getDefinitionDataRequirement() throws FHIRException {
            if (this.definition == null) {
                this.definition = new DataRequirement();
            }
            if (!(this.definition instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.definition;
        }

        public boolean hasDefinitionDataRequirement() {
            return this != null && this.definition instanceof DataRequirement;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setDefinition(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof CanonicalType || value instanceof Expression || value instanceof DataRequirement)) {
                throw new Error("Not the right type for ResearchElementDefinition.characteristic.definition[x]: " + value.fhirType());
            }
            this.definition = value;
            return this;
        }

        public List<UsageContext> getUsageContext() {
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            return this.usageContext;
        }

        public ResearchElementDefinitionCharacteristicComponent setUsageContext(List<UsageContext> theUsageContext) {
            this.usageContext = theUsageContext;
            return this;
        }

        public boolean hasUsageContext() {
            if (this.usageContext == null) {
                return false;
            }
            for (UsageContext item : this.usageContext) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UsageContext addUsageContext() {
            UsageContext t = new UsageContext();
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            this.usageContext.add(t);
            return t;
        }

        public ResearchElementDefinitionCharacteristicComponent addUsageContext(UsageContext t) {
            if (t == null) {
                return this;
            }
            if (this.usageContext == null) {
                this.usageContext = new ArrayList<UsageContext>();
            }
            this.usageContext.add(t);
            return this;
        }

        public UsageContext getUsageContextFirstRep() {
            if (this.getUsageContext().isEmpty()) {
                this.addUsageContext();
            }
            return this.getUsageContext().get(0);
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public ResearchElementDefinitionCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public CodeableConcept getUnitOfMeasure() {
            if (this.unitOfMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.unitOfMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitOfMeasure = new CodeableConcept();
                }
            }
            return this.unitOfMeasure;
        }

        public boolean hasUnitOfMeasure() {
            return this.unitOfMeasure != null && !this.unitOfMeasure.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setUnitOfMeasure(CodeableConcept value) {
            this.unitOfMeasure = value;
            return this;
        }

        public StringType getStudyEffectiveDescriptionElement() {
            if (this.studyEffectiveDescription == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.studyEffectiveDescription");
                }
                if (Configuration.doAutoCreate()) {
                    this.studyEffectiveDescription = new StringType();
                }
            }
            return this.studyEffectiveDescription;
        }

        public boolean hasStudyEffectiveDescriptionElement() {
            return this.studyEffectiveDescription != null && !this.studyEffectiveDescription.isEmpty();
        }

        public boolean hasStudyEffectiveDescription() {
            return this.studyEffectiveDescription != null && !this.studyEffectiveDescription.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffectiveDescriptionElement(StringType value) {
            this.studyEffectiveDescription = value;
            return this;
        }

        public String getStudyEffectiveDescription() {
            return this.studyEffectiveDescription == null ? null : (String)this.studyEffectiveDescription.getValue();
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffectiveDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.studyEffectiveDescription = null;
            } else {
                if (this.studyEffectiveDescription == null) {
                    this.studyEffectiveDescription = new StringType();
                }
                this.studyEffectiveDescription.setValue(value);
            }
            return this;
        }

        public Type getStudyEffective() {
            return this.studyEffective;
        }

        public DateTimeType getStudyEffectiveDateTimeType() throws FHIRException {
            if (this.studyEffective == null) {
                this.studyEffective = new DateTimeType();
            }
            if (!(this.studyEffective instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.studyEffective.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.studyEffective;
        }

        public boolean hasStudyEffectiveDateTimeType() {
            return this != null && this.studyEffective instanceof DateTimeType;
        }

        public Period getStudyEffectivePeriod() throws FHIRException {
            if (this.studyEffective == null) {
                this.studyEffective = new Period();
            }
            if (!(this.studyEffective instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.studyEffective.getClass().getName() + " was encountered");
            }
            return (Period)this.studyEffective;
        }

        public boolean hasStudyEffectivePeriod() {
            return this != null && this.studyEffective instanceof Period;
        }

        public Duration getStudyEffectiveDuration() throws FHIRException {
            if (this.studyEffective == null) {
                this.studyEffective = new Duration();
            }
            if (!(this.studyEffective instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.studyEffective.getClass().getName() + " was encountered");
            }
            return (Duration)this.studyEffective;
        }

        public boolean hasStudyEffectiveDuration() {
            return this != null && this.studyEffective instanceof Duration;
        }

        public Timing getStudyEffectiveTiming() throws FHIRException {
            if (this.studyEffective == null) {
                this.studyEffective = new Timing();
            }
            if (!(this.studyEffective instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.studyEffective.getClass().getName() + " was encountered");
            }
            return (Timing)this.studyEffective;
        }

        public boolean hasStudyEffectiveTiming() {
            return this != null && this.studyEffective instanceof Timing;
        }

        public boolean hasStudyEffective() {
            return this.studyEffective != null && !this.studyEffective.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffective(Type value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration || value instanceof Timing)) {
                throw new Error("Not the right type for ResearchElementDefinition.characteristic.studyEffective[x]: " + value.fhirType());
            }
            this.studyEffective = value;
            return this;
        }

        public Duration getStudyEffectiveTimeFromStart() {
            if (this.studyEffectiveTimeFromStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.studyEffectiveTimeFromStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.studyEffectiveTimeFromStart = new Duration();
                }
            }
            return this.studyEffectiveTimeFromStart;
        }

        public boolean hasStudyEffectiveTimeFromStart() {
            return this.studyEffectiveTimeFromStart != null && !this.studyEffectiveTimeFromStart.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffectiveTimeFromStart(Duration value) {
            this.studyEffectiveTimeFromStart = value;
            return this;
        }

        public Enumeration<GroupMeasure> getStudyEffectiveGroupMeasureElement() {
            if (this.studyEffectiveGroupMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.studyEffectiveGroupMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.studyEffectiveGroupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
            }
            return this.studyEffectiveGroupMeasure;
        }

        public boolean hasStudyEffectiveGroupMeasureElement() {
            return this.studyEffectiveGroupMeasure != null && !this.studyEffectiveGroupMeasure.isEmpty();
        }

        public boolean hasStudyEffectiveGroupMeasure() {
            return this.studyEffectiveGroupMeasure != null && !this.studyEffectiveGroupMeasure.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffectiveGroupMeasureElement(Enumeration<GroupMeasure> value) {
            this.studyEffectiveGroupMeasure = value;
            return this;
        }

        public GroupMeasure getStudyEffectiveGroupMeasure() {
            return this.studyEffectiveGroupMeasure == null ? null : (GroupMeasure)((Object)this.studyEffectiveGroupMeasure.getValue());
        }

        public ResearchElementDefinitionCharacteristicComponent setStudyEffectiveGroupMeasure(GroupMeasure value) {
            if (value == null) {
                this.studyEffectiveGroupMeasure = null;
            } else {
                if (this.studyEffectiveGroupMeasure == null) {
                    this.studyEffectiveGroupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
                this.studyEffectiveGroupMeasure.setValue((Object)value);
            }
            return this;
        }

        public StringType getParticipantEffectiveDescriptionElement() {
            if (this.participantEffectiveDescription == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.participantEffectiveDescription");
                }
                if (Configuration.doAutoCreate()) {
                    this.participantEffectiveDescription = new StringType();
                }
            }
            return this.participantEffectiveDescription;
        }

        public boolean hasParticipantEffectiveDescriptionElement() {
            return this.participantEffectiveDescription != null && !this.participantEffectiveDescription.isEmpty();
        }

        public boolean hasParticipantEffectiveDescription() {
            return this.participantEffectiveDescription != null && !this.participantEffectiveDescription.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffectiveDescriptionElement(StringType value) {
            this.participantEffectiveDescription = value;
            return this;
        }

        public String getParticipantEffectiveDescription() {
            return this.participantEffectiveDescription == null ? null : (String)this.participantEffectiveDescription.getValue();
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffectiveDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.participantEffectiveDescription = null;
            } else {
                if (this.participantEffectiveDescription == null) {
                    this.participantEffectiveDescription = new StringType();
                }
                this.participantEffectiveDescription.setValue(value);
            }
            return this;
        }

        public Type getParticipantEffective() {
            return this.participantEffective;
        }

        public DateTimeType getParticipantEffectiveDateTimeType() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new DateTimeType();
            }
            if (!(this.participantEffective instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.participantEffective;
        }

        public boolean hasParticipantEffectiveDateTimeType() {
            return this != null && this.participantEffective instanceof DateTimeType;
        }

        public Period getParticipantEffectivePeriod() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Period();
            }
            if (!(this.participantEffective instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Period)this.participantEffective;
        }

        public boolean hasParticipantEffectivePeriod() {
            return this != null && this.participantEffective instanceof Period;
        }

        public Duration getParticipantEffectiveDuration() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Duration();
            }
            if (!(this.participantEffective instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Duration)this.participantEffective;
        }

        public boolean hasParticipantEffectiveDuration() {
            return this != null && this.participantEffective instanceof Duration;
        }

        public Timing getParticipantEffectiveTiming() throws FHIRException {
            if (this.participantEffective == null) {
                this.participantEffective = new Timing();
            }
            if (!(this.participantEffective instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.participantEffective.getClass().getName() + " was encountered");
            }
            return (Timing)this.participantEffective;
        }

        public boolean hasParticipantEffectiveTiming() {
            return this != null && this.participantEffective instanceof Timing;
        }

        public boolean hasParticipantEffective() {
            return this.participantEffective != null && !this.participantEffective.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffective(Type value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration || value instanceof Timing)) {
                throw new Error("Not the right type for ResearchElementDefinition.characteristic.participantEffective[x]: " + value.fhirType());
            }
            this.participantEffective = value;
            return this;
        }

        public Duration getParticipantEffectiveTimeFromStart() {
            if (this.participantEffectiveTimeFromStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.participantEffectiveTimeFromStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.participantEffectiveTimeFromStart = new Duration();
                }
            }
            return this.participantEffectiveTimeFromStart;
        }

        public boolean hasParticipantEffectiveTimeFromStart() {
            return this.participantEffectiveTimeFromStart != null && !this.participantEffectiveTimeFromStart.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffectiveTimeFromStart(Duration value) {
            this.participantEffectiveTimeFromStart = value;
            return this;
        }

        public Enumeration<GroupMeasure> getParticipantEffectiveGroupMeasureElement() {
            if (this.participantEffectiveGroupMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchElementDefinitionCharacteristicComponent.participantEffectiveGroupMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.participantEffectiveGroupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
            }
            return this.participantEffectiveGroupMeasure;
        }

        public boolean hasParticipantEffectiveGroupMeasureElement() {
            return this.participantEffectiveGroupMeasure != null && !this.participantEffectiveGroupMeasure.isEmpty();
        }

        public boolean hasParticipantEffectiveGroupMeasure() {
            return this.participantEffectiveGroupMeasure != null && !this.participantEffectiveGroupMeasure.isEmpty();
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffectiveGroupMeasureElement(Enumeration<GroupMeasure> value) {
            this.participantEffectiveGroupMeasure = value;
            return this;
        }

        public GroupMeasure getParticipantEffectiveGroupMeasure() {
            return this.participantEffectiveGroupMeasure == null ? null : (GroupMeasure)((Object)this.participantEffectiveGroupMeasure.getValue());
        }

        public ResearchElementDefinitionCharacteristicComponent setParticipantEffectiveGroupMeasure(GroupMeasure value) {
            if (value == null) {
                this.participantEffectiveGroupMeasure = null;
            } else {
                if (this.participantEffectiveGroupMeasure == null) {
                    this.participantEffectiveGroupMeasure = new Enumeration<GroupMeasure>(new GroupMeasureEnumFactory());
                }
                this.participantEffectiveGroupMeasure.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition));
            children.add(new Property("usageContext", "UsageContext", "Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.", 0, Integer.MAX_VALUE, this.usageContext));
            children.add(new Property("exclude", "boolean", "When true, members with this characteristic are excluded from the element.", 0, 1, this.exclude));
            children.add(new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure));
            children.add(new Property("studyEffectiveDescription", "string", "A narrative description of the time period the study covers.", 0, 1, this.studyEffectiveDescription));
            children.add(new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective));
            children.add(new Property("studyEffectiveTimeFromStart", "Duration", "Indicates duration from the study initiation.", 0, 1, this.studyEffectiveTimeFromStart));
            children.add(new Property("studyEffectiveGroupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.studyEffectiveGroupMeasure));
            children.add(new Property("participantEffectiveDescription", "string", "A narrative description of the time period the study covers.", 0, 1, this.participantEffectiveDescription));
            children.add(new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective));
            children.add(new Property("participantEffectiveTimeFromStart", "Duration", "Indicates duration from the participant's study entry.", 0, 1, this.participantEffectiveTimeFromStart));
            children.add(new Property("participantEffectiveGroupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.participantEffectiveGroupMeasure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1139422643: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -1014418093: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -1446002226: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 933485793: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 1463703627: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case -660350874: {
                    return new Property("definition[x]", "CodeableConcept|canonical(ValueSet)|Expression|DataRequirement", "Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).", 0, 1, this.definition);
                }
                case 907012302: {
                    return new Property("usageContext", "UsageContext", "Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.", 0, Integer.MAX_VALUE, this.usageContext);
                }
                case -1321148966: {
                    return new Property("exclude", "boolean", "When true, members with this characteristic are excluded from the element.", 0, 1, this.exclude);
                }
                case -750257565: {
                    return new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure);
                }
                case 237553470: {
                    return new Property("studyEffectiveDescription", "string", "A narrative description of the time period the study covers.", 0, 1, this.studyEffectiveDescription);
                }
                case -1832549918: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case -836391458: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case 439780249: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case -497045185: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case 949985682: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case -378983480: {
                    return new Property("studyEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.studyEffective);
                }
                case -2107828915: {
                    return new Property("studyEffectiveTimeFromStart", "Duration", "Indicates duration from the study initiation.", 0, 1, this.studyEffectiveTimeFromStart);
                }
                case 1284435677: {
                    return new Property("studyEffectiveGroupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.studyEffectiveGroupMeasure);
                }
                case 1333186472: {
                    return new Property("participantEffectiveDescription", "string", "A narrative description of the time period the study covers.", 0, 1, this.participantEffectiveDescription);
                }
                case 1777308748: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case 1376306100: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -1721146513: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -883650923: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -1210941080: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -765589218: {
                    return new Property("participantEffective[x]", "dateTime|Period|Duration|Timing", "Indicates what effective period the study covers.", 0, 1, this.participantEffective);
                }
                case -1471501513: {
                    return new Property("participantEffectiveTimeFromStart", "Duration", "Indicates duration from the participant's study entry.", 0, 1, this.participantEffectiveTimeFromStart);
                }
                case 889320371: {
                    return new Property("participantEffectiveGroupMeasure", "code", "Indicates how elements are aggregated within the study effective period.", 0, 1, this.participantEffectiveGroupMeasure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.definition;
                    }
                    return baseArray;
                }
                case 907012302: {
                    return this.usageContext == null ? new Base[]{} : this.usageContext.toArray(new Base[this.usageContext.size()]);
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exclude;
                    }
                    return baseArray;
                }
                case -750257565: {
                    Base[] baseArray;
                    if (this.unitOfMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unitOfMeasure;
                    }
                    return baseArray;
                }
                case 237553470: {
                    Base[] baseArray;
                    if (this.studyEffectiveDescription == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.studyEffectiveDescription;
                    }
                    return baseArray;
                }
                case -836391458: {
                    Base[] baseArray;
                    if (this.studyEffective == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.studyEffective;
                    }
                    return baseArray;
                }
                case -2107828915: {
                    Base[] baseArray;
                    if (this.studyEffectiveTimeFromStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.studyEffectiveTimeFromStart;
                    }
                    return baseArray;
                }
                case 1284435677: {
                    Base[] baseArray;
                    if (this.studyEffectiveGroupMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.studyEffectiveGroupMeasure;
                    }
                    return baseArray;
                }
                case 1333186472: {
                    Base[] baseArray;
                    if (this.participantEffectiveDescription == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.participantEffectiveDescription;
                    }
                    return baseArray;
                }
                case 1376306100: {
                    Base[] baseArray;
                    if (this.participantEffective == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.participantEffective;
                    }
                    return baseArray;
                }
                case -1471501513: {
                    Base[] baseArray;
                    if (this.participantEffectiveTimeFromStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.participantEffectiveTimeFromStart;
                    }
                    return baseArray;
                }
                case 889320371: {
                    Base[] baseArray;
                    if (this.participantEffectiveGroupMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.participantEffectiveGroupMeasure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    this.definition = this.castToType(value);
                    return value;
                }
                case 907012302: {
                    this.getUsageContext().add(this.castToUsageContext(value));
                    return value;
                }
                case -1321148966: {
                    this.exclude = this.castToBoolean(value);
                    return value;
                }
                case -750257565: {
                    this.unitOfMeasure = this.castToCodeableConcept(value);
                    return value;
                }
                case 237553470: {
                    this.studyEffectiveDescription = this.castToString(value);
                    return value;
                }
                case -836391458: {
                    this.studyEffective = this.castToType(value);
                    return value;
                }
                case -2107828915: {
                    this.studyEffectiveTimeFromStart = this.castToDuration(value);
                    return value;
                }
                case 1284435677: {
                    value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                    this.studyEffectiveGroupMeasure = value;
                    return value;
                }
                case 1333186472: {
                    this.participantEffectiveDescription = this.castToString(value);
                    return value;
                }
                case 1376306100: {
                    this.participantEffective = this.castToType(value);
                    return value;
                }
                case -1471501513: {
                    this.participantEffectiveTimeFromStart = this.castToDuration(value);
                    return value;
                }
                case 889320371: {
                    value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                    this.participantEffectiveGroupMeasure = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("definition[x]")) {
                this.definition = this.castToType(value);
            } else if (name.equals("usageContext")) {
                this.getUsageContext().add(this.castToUsageContext(value));
            } else if (name.equals("exclude")) {
                this.exclude = this.castToBoolean(value);
            } else if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = this.castToCodeableConcept(value);
            } else if (name.equals("studyEffectiveDescription")) {
                this.studyEffectiveDescription = this.castToString(value);
            } else if (name.equals("studyEffective[x]")) {
                this.studyEffective = this.castToType(value);
            } else if (name.equals("studyEffectiveTimeFromStart")) {
                this.studyEffectiveTimeFromStart = this.castToDuration(value);
            } else if (name.equals("studyEffectiveGroupMeasure")) {
                value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                this.studyEffectiveGroupMeasure = value;
            } else if (name.equals("participantEffectiveDescription")) {
                this.participantEffectiveDescription = this.castToString(value);
            } else if (name.equals("participantEffective[x]")) {
                this.participantEffective = this.castToType(value);
            } else if (name.equals("participantEffectiveTimeFromStart")) {
                this.participantEffectiveTimeFromStart = this.castToDuration(value);
            } else if (name.equals("participantEffectiveGroupMeasure")) {
                value = new GroupMeasureEnumFactory().fromType(this.castToCode(value));
                this.participantEffectiveGroupMeasure = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1139422643: {
                    return this.getDefinition();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 907012302: {
                    return this.addUsageContext();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case -750257565: {
                    return this.getUnitOfMeasure();
                }
                case 237553470: {
                    return this.getStudyEffectiveDescriptionElement();
                }
                case -1832549918: {
                    return this.getStudyEffective();
                }
                case -836391458: {
                    return this.getStudyEffective();
                }
                case -2107828915: {
                    return this.getStudyEffectiveTimeFromStart();
                }
                case 1284435677: {
                    return this.getStudyEffectiveGroupMeasureElement();
                }
                case 1333186472: {
                    return this.getParticipantEffectiveDescriptionElement();
                }
                case 1777308748: {
                    return this.getParticipantEffective();
                }
                case 1376306100: {
                    return this.getParticipantEffective();
                }
                case -1471501513: {
                    return this.getParticipantEffectiveTimeFromStart();
                }
                case 889320371: {
                    return this.getParticipantEffectiveGroupMeasureElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return new String[]{"CodeableConcept", "canonical", "Expression", "DataRequirement"};
                }
                case 907012302: {
                    return new String[]{"UsageContext"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case -750257565: {
                    return new String[]{"CodeableConcept"};
                }
                case 237553470: {
                    return new String[]{"string"};
                }
                case -836391458: {
                    return new String[]{"dateTime", "Period", "Duration", "Timing"};
                }
                case -2107828915: {
                    return new String[]{"Duration"};
                }
                case 1284435677: {
                    return new String[]{"code"};
                }
                case 1333186472: {
                    return new String[]{"string"};
                }
                case 1376306100: {
                    return new String[]{"dateTime", "Period", "Duration", "Timing"};
                }
                case -1471501513: {
                    return new String[]{"Duration"};
                }
                case 889320371: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("definitionCodeableConcept")) {
                this.definition = new CodeableConcept();
                return this.definition;
            }
            if (name.equals("definitionCanonical")) {
                this.definition = new CanonicalType();
                return this.definition;
            }
            if (name.equals("definitionExpression")) {
                this.definition = new Expression();
                return this.definition;
            }
            if (name.equals("definitionDataRequirement")) {
                this.definition = new DataRequirement();
                return this.definition;
            }
            if (name.equals("usageContext")) {
                return this.addUsageContext();
            }
            if (name.equals("exclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.exclude");
            }
            if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = new CodeableConcept();
                return this.unitOfMeasure;
            }
            if (name.equals("studyEffectiveDescription")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.studyEffectiveDescription");
            }
            if (name.equals("studyEffectiveDateTime")) {
                this.studyEffective = new DateTimeType();
                return this.studyEffective;
            }
            if (name.equals("studyEffectivePeriod")) {
                this.studyEffective = new Period();
                return this.studyEffective;
            }
            if (name.equals("studyEffectiveDuration")) {
                this.studyEffective = new Duration();
                return this.studyEffective;
            }
            if (name.equals("studyEffectiveTiming")) {
                this.studyEffective = new Timing();
                return this.studyEffective;
            }
            if (name.equals("studyEffectiveTimeFromStart")) {
                this.studyEffectiveTimeFromStart = new Duration();
                return this.studyEffectiveTimeFromStart;
            }
            if (name.equals("studyEffectiveGroupMeasure")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.studyEffectiveGroupMeasure");
            }
            if (name.equals("participantEffectiveDescription")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.participantEffectiveDescription");
            }
            if (name.equals("participantEffectiveDateTime")) {
                this.participantEffective = new DateTimeType();
                return this.participantEffective;
            }
            if (name.equals("participantEffectivePeriod")) {
                this.participantEffective = new Period();
                return this.participantEffective;
            }
            if (name.equals("participantEffectiveDuration")) {
                this.participantEffective = new Duration();
                return this.participantEffective;
            }
            if (name.equals("participantEffectiveTiming")) {
                this.participantEffective = new Timing();
                return this.participantEffective;
            }
            if (name.equals("participantEffectiveTimeFromStart")) {
                this.participantEffectiveTimeFromStart = new Duration();
                return this.participantEffectiveTimeFromStart;
            }
            if (name.equals("participantEffectiveGroupMeasure")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchElementDefinition.participantEffectiveGroupMeasure");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchElementDefinitionCharacteristicComponent copy() {
            ResearchElementDefinitionCharacteristicComponent dst = new ResearchElementDefinitionCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchElementDefinitionCharacteristicComponent dst) {
            super.copyValues(dst);
            Type type = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.usageContext != null) {
                dst.usageContext = new ArrayList<UsageContext>();
                for (UsageContext i : this.usageContext) {
                    dst.usageContext.add(i.copy());
                }
            }
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.unitOfMeasure = this.unitOfMeasure == null ? null : this.unitOfMeasure.copy();
            dst.studyEffectiveDescription = this.studyEffectiveDescription == null ? null : this.studyEffectiveDescription.copy();
            dst.studyEffective = this.studyEffective == null ? null : this.studyEffective.copy();
            dst.studyEffectiveTimeFromStart = this.studyEffectiveTimeFromStart == null ? null : this.studyEffectiveTimeFromStart.copy();
            dst.studyEffectiveGroupMeasure = this.studyEffectiveGroupMeasure == null ? null : this.studyEffectiveGroupMeasure.copy();
            dst.participantEffectiveDescription = this.participantEffectiveDescription == null ? null : this.participantEffectiveDescription.copy();
            dst.participantEffective = this.participantEffective == null ? null : this.participantEffective.copy();
            dst.participantEffectiveTimeFromStart = this.participantEffectiveTimeFromStart == null ? null : this.participantEffectiveTimeFromStart.copy();
            dst.participantEffectiveGroupMeasure = this.participantEffectiveGroupMeasure == null ? null : this.participantEffectiveGroupMeasure.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchElementDefinitionCharacteristicComponent)) {
                return false;
            }
            ResearchElementDefinitionCharacteristicComponent o = (ResearchElementDefinitionCharacteristicComponent)other_;
            return ResearchElementDefinitionCharacteristicComponent.compareDeep(this.definition, o.definition, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.usageContext, o.usageContext, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.unitOfMeasure, o.unitOfMeasure, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.studyEffectiveDescription, o.studyEffectiveDescription, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.studyEffective, o.studyEffective, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.studyEffectiveTimeFromStart, o.studyEffectiveTimeFromStart, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.studyEffectiveGroupMeasure, o.studyEffectiveGroupMeasure, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.participantEffectiveDescription, o.participantEffectiveDescription, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.participantEffective, o.participantEffective, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.participantEffectiveTimeFromStart, o.participantEffectiveTimeFromStart, true) && ResearchElementDefinitionCharacteristicComponent.compareDeep(this.participantEffectiveGroupMeasure, o.participantEffectiveGroupMeasure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchElementDefinitionCharacteristicComponent)) {
                return false;
            }
            ResearchElementDefinitionCharacteristicComponent o = (ResearchElementDefinitionCharacteristicComponent)other_;
            return ResearchElementDefinitionCharacteristicComponent.compareValues(this.exclude, o.exclude, true) && ResearchElementDefinitionCharacteristicComponent.compareValues(this.studyEffectiveDescription, o.studyEffectiveDescription, true) && ResearchElementDefinitionCharacteristicComponent.compareValues(this.studyEffectiveGroupMeasure, o.studyEffectiveGroupMeasure, true) && ResearchElementDefinitionCharacteristicComponent.compareValues(this.participantEffectiveDescription, o.participantEffectiveDescription, true) && ResearchElementDefinitionCharacteristicComponent.compareValues(this.participantEffectiveGroupMeasure, o.participantEffectiveGroupMeasure, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.definition, this.usageContext, this.exclude, this.unitOfMeasure, this.studyEffectiveDescription, this.studyEffective, this.studyEffectiveTimeFromStart, this.studyEffectiveGroupMeasure, this.participantEffectiveDescription, this.participantEffective, this.participantEffectiveTimeFromStart, this.participantEffectiveGroupMeasure});
        }

        @Override
        public String fhirType() {
            return "ResearchElementDefinition.characteristic";
        }
    }

    public static class GroupMeasureEnumFactory
    implements EnumFactory<GroupMeasure> {
        @Override
        public GroupMeasure fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mean".equals(codeString)) {
                return GroupMeasure.MEAN;
            }
            if ("median".equals(codeString)) {
                return GroupMeasure.MEDIAN;
            }
            if ("mean-of-mean".equals(codeString)) {
                return GroupMeasure.MEANOFMEAN;
            }
            if ("mean-of-median".equals(codeString)) {
                return GroupMeasure.MEANOFMEDIAN;
            }
            if ("median-of-mean".equals(codeString)) {
                return GroupMeasure.MEDIANOFMEAN;
            }
            if ("median-of-median".equals(codeString)) {
                return GroupMeasure.MEDIANOFMEDIAN;
            }
            throw new IllegalArgumentException("Unknown GroupMeasure code '" + codeString + "'");
        }

        public Enumeration<GroupMeasure> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.NULL, code);
            }
            if ("mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEAN, code);
            }
            if ("median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIAN, code);
            }
            if ("mean-of-mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEANOFMEAN, code);
            }
            if ("mean-of-median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEANOFMEDIAN, code);
            }
            if ("median-of-mean".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIANOFMEAN, code);
            }
            if ("median-of-median".equals(codeString)) {
                return new Enumeration<GroupMeasure>(this, GroupMeasure.MEDIANOFMEDIAN, code);
            }
            throw new FHIRException("Unknown GroupMeasure code '" + codeString + "'");
        }

        @Override
        public String toCode(GroupMeasure code) {
            if (code == GroupMeasure.MEAN) {
                return "mean";
            }
            if (code == GroupMeasure.MEDIAN) {
                return "median";
            }
            if (code == GroupMeasure.MEANOFMEAN) {
                return "mean-of-mean";
            }
            if (code == GroupMeasure.MEANOFMEDIAN) {
                return "mean-of-median";
            }
            if (code == GroupMeasure.MEDIANOFMEAN) {
                return "median-of-mean";
            }
            if (code == GroupMeasure.MEDIANOFMEDIAN) {
                return "median-of-median";
            }
            return "?";
        }

        @Override
        public String toSystem(GroupMeasure code) {
            return code.getSystem();
        }
    }

    public static enum GroupMeasure {
        MEAN,
        MEDIAN,
        MEANOFMEAN,
        MEANOFMEDIAN,
        MEDIANOFMEAN,
        MEDIANOFMEDIAN,
        NULL;


        public static GroupMeasure fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mean".equals(codeString)) {
                return MEAN;
            }
            if ("median".equals(codeString)) {
                return MEDIAN;
            }
            if ("mean-of-mean".equals(codeString)) {
                return MEANOFMEAN;
            }
            if ("mean-of-median".equals(codeString)) {
                return MEANOFMEDIAN;
            }
            if ("median-of-mean".equals(codeString)) {
                return MEDIANOFMEAN;
            }
            if ("median-of-median".equals(codeString)) {
                return MEDIANOFMEDIAN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GroupMeasure code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MEAN: {
                    return "mean";
                }
                case MEDIAN: {
                    return "median";
                }
                case MEANOFMEAN: {
                    return "mean-of-mean";
                }
                case MEANOFMEDIAN: {
                    return "mean-of-median";
                }
                case MEDIANOFMEAN: {
                    return "median-of-mean";
                }
                case MEDIANOFMEDIAN: {
                    return "median-of-median";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEANOFMEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEANOFMEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIANOFMEAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case MEDIANOFMEDIAN: {
                    return "http://hl7.org/fhir/group-measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MEAN: {
                    return "Aggregated using Mean of participant values.";
                }
                case MEDIAN: {
                    return "Aggregated using Median of participant values.";
                }
                case MEANOFMEAN: {
                    return "Aggregated using Mean of study mean values.";
                }
                case MEANOFMEDIAN: {
                    return "Aggregated using Mean of study median values.";
                }
                case MEDIANOFMEAN: {
                    return "Aggregated using Median of study mean values.";
                }
                case MEDIANOFMEDIAN: {
                    return "Aggregated using Median of study median values.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MEAN: {
                    return "Mean";
                }
                case MEDIAN: {
                    return "Median";
                }
                case MEANOFMEAN: {
                    return "Mean of Study Means";
                }
                case MEANOFMEDIAN: {
                    return "Mean of Study Medins";
                }
                case MEDIANOFMEAN: {
                    return "Median of Study Means";
                }
                case MEDIANOFMEDIAN: {
                    return "Median of Study Medians";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class VariableTypeEnumFactory
    implements EnumFactory<VariableType> {
        @Override
        public VariableType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("dichotomous".equals(codeString)) {
                return VariableType.DICHOTOMOUS;
            }
            if ("continuous".equals(codeString)) {
                return VariableType.CONTINUOUS;
            }
            if ("descriptive".equals(codeString)) {
                return VariableType.DESCRIPTIVE;
            }
            throw new IllegalArgumentException("Unknown VariableType code '" + codeString + "'");
        }

        public Enumeration<VariableType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<VariableType>(this, VariableType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<VariableType>(this, VariableType.NULL, code);
            }
            if ("dichotomous".equals(codeString)) {
                return new Enumeration<VariableType>(this, VariableType.DICHOTOMOUS, code);
            }
            if ("continuous".equals(codeString)) {
                return new Enumeration<VariableType>(this, VariableType.CONTINUOUS, code);
            }
            if ("descriptive".equals(codeString)) {
                return new Enumeration<VariableType>(this, VariableType.DESCRIPTIVE, code);
            }
            throw new FHIRException("Unknown VariableType code '" + codeString + "'");
        }

        @Override
        public String toCode(VariableType code) {
            if (code == VariableType.DICHOTOMOUS) {
                return "dichotomous";
            }
            if (code == VariableType.CONTINUOUS) {
                return "continuous";
            }
            if (code == VariableType.DESCRIPTIVE) {
                return "descriptive";
            }
            return "?";
        }

        @Override
        public String toSystem(VariableType code) {
            return code.getSystem();
        }
    }

    public static enum VariableType {
        DICHOTOMOUS,
        CONTINUOUS,
        DESCRIPTIVE,
        NULL;


        public static VariableType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("dichotomous".equals(codeString)) {
                return DICHOTOMOUS;
            }
            if ("continuous".equals(codeString)) {
                return CONTINUOUS;
            }
            if ("descriptive".equals(codeString)) {
                return DESCRIPTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown VariableType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "dichotomous";
                }
                case CONTINUOUS: {
                    return "continuous";
                }
                case DESCRIPTIVE: {
                    return "descriptive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case CONTINUOUS: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case DESCRIPTIVE: {
                    return "http://hl7.org/fhir/variable-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "The variable is dichotomous, such as present or absent.";
                }
                case CONTINUOUS: {
                    return "The variable is a continuous result such as a quantity.";
                }
                case DESCRIPTIVE: {
                    return "The variable is described narratively rather than quantitatively.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DICHOTOMOUS: {
                    return "Dichotomous";
                }
                case CONTINUOUS: {
                    return "Continuous";
                }
                case DESCRIPTIVE: {
                    return "Descriptive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ResearchElementTypeEnumFactory
    implements EnumFactory<ResearchElementType> {
        @Override
        public ResearchElementType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("population".equals(codeString)) {
                return ResearchElementType.POPULATION;
            }
            if ("exposure".equals(codeString)) {
                return ResearchElementType.EXPOSURE;
            }
            if ("outcome".equals(codeString)) {
                return ResearchElementType.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown ResearchElementType code '" + codeString + "'");
        }

        public Enumeration<ResearchElementType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResearchElementType>(this, ResearchElementType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ResearchElementType>(this, ResearchElementType.NULL, code);
            }
            if ("population".equals(codeString)) {
                return new Enumeration<ResearchElementType>(this, ResearchElementType.POPULATION, code);
            }
            if ("exposure".equals(codeString)) {
                return new Enumeration<ResearchElementType>(this, ResearchElementType.EXPOSURE, code);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<ResearchElementType>(this, ResearchElementType.OUTCOME, code);
            }
            throw new FHIRException("Unknown ResearchElementType code '" + codeString + "'");
        }

        @Override
        public String toCode(ResearchElementType code) {
            if (code == ResearchElementType.POPULATION) {
                return "population";
            }
            if (code == ResearchElementType.EXPOSURE) {
                return "exposure";
            }
            if (code == ResearchElementType.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(ResearchElementType code) {
            return code.getSystem();
        }
    }

    public static enum ResearchElementType {
        POPULATION,
        EXPOSURE,
        OUTCOME,
        NULL;


        public static ResearchElementType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("population".equals(codeString)) {
                return POPULATION;
            }
            if ("exposure".equals(codeString)) {
                return EXPOSURE;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResearchElementType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case POPULATION: {
                    return "population";
                }
                case EXPOSURE: {
                    return "exposure";
                }
                case OUTCOME: {
                    return "outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case POPULATION: {
                    return "http://hl7.org/fhir/research-element-type";
                }
                case EXPOSURE: {
                    return "http://hl7.org/fhir/research-element-type";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/research-element-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case POPULATION: {
                    return "The element defines the population that forms the basis for research.";
                }
                case EXPOSURE: {
                    return "The element defines an exposure within the population that is being researched.";
                }
                case OUTCOME: {
                    return "The element defines an outcome within the population that is being researched.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case POPULATION: {
                    return "Population";
                }
                case EXPOSURE: {
                    return "Exposure";
                }
                case OUTCOME: {
                    return "Outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

