/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="VerificationResult", profile="http://hl7.org/fhir/StructureDefinition/VerificationResult")
public class VerificationResult
extends DomainResource {
    @Child(name="target", type={Reference.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A resource that was validated", formalDefinition="A resource that was validated.")
    protected List<Reference> target;
    protected List<Resource> targetTarget;
    @Child(name="targetLocation", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The fhirpath location(s) within the resource that was validated", formalDefinition="The fhirpath location(s) within the resource that was validated.")
    protected List<StringType> targetLocation;
    @Child(name="need", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="none | initial | periodic", formalDefinition="The frequency with which the target must be validated (none; initial; periodic).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-need")
    protected CodeableConcept need;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="attested | validated | in-process | req-revalid | val-fail | reval-fail", formalDefinition="The validation status of the target (attested; validated; in process; requires revalidation; validation failed; revalidation failed).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-status")
    protected Enumeration<Status> status;
    @Child(name="statusDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the validation status was updated", formalDefinition="When the validation status was updated.")
    protected DateTimeType statusDate;
    @Child(name="validationType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="nothing | primary | multiple", formalDefinition="What the target is validated against (nothing; primary source; multiple sources).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-type")
    protected CodeableConcept validationType;
    @Child(name="validationProcess", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The primary process by which the target is validated (edit check; value set; primary source; multiple sources; standalone; in context)", formalDefinition="The primary process by which the target is validated (edit check; value set; primary source; multiple sources; standalone; in context).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-process")
    protected List<CodeableConcept> validationProcess;
    @Child(name="frequency", type={Timing.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Frequency of revalidation", formalDefinition="Frequency of revalidation.")
    protected Timing frequency;
    @Child(name="lastPerformed", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The date/time validation was last completed (including failed validations)", formalDefinition="The date/time validation was last completed (including failed validations).")
    protected DateTimeType lastPerformed;
    @Child(name="nextScheduled", type={DateType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The date when target is next validated, if appropriate", formalDefinition="The date when target is next validated, if appropriate.")
    protected DateType nextScheduled;
    @Child(name="failureAction", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="fatal | warn | rec-only | none", formalDefinition="The result if validation fails (fatal; warning; record only; none).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-failure-action")
    protected CodeableConcept failureAction;
    @Child(name="primarySource", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the primary source(s) involved in validation", formalDefinition="Information about the primary source(s) involved in validation.")
    protected List<VerificationResultPrimarySourceComponent> primarySource;
    @Child(name="attestation", type={}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the entity attesting to information", formalDefinition="Information about the entity attesting to information.")
    protected VerificationResultAttestationComponent attestation;
    @Child(name="validator", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the entity validating information", formalDefinition="Information about the entity validating information.")
    protected List<VerificationResultValidatorComponent> validator;
    private static final long serialVersionUID = -284059204L;
    @SearchParamDefinition(name="target", path="VerificationResult.target", description="A resource that was validated", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("VerificationResult:target").toLocked();

    public VerificationResult() {
    }

    public VerificationResult(Enumeration<Status> status) {
        this.status = status;
    }

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public VerificationResult setTarget(List<Reference> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (Reference item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTarget() {
        Reference t = new Reference();
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return t;
    }

    public VerificationResult addTarget(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return this;
    }

    public Reference getTargetFirstRep() {
        if (this.getTarget().isEmpty()) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    @Deprecated
    public List<Resource> getTargetTarget() {
        if (this.targetTarget == null) {
            this.targetTarget = new ArrayList<Resource>();
        }
        return this.targetTarget;
    }

    public List<StringType> getTargetLocation() {
        if (this.targetLocation == null) {
            this.targetLocation = new ArrayList<StringType>();
        }
        return this.targetLocation;
    }

    public VerificationResult setTargetLocation(List<StringType> theTargetLocation) {
        this.targetLocation = theTargetLocation;
        return this;
    }

    public boolean hasTargetLocation() {
        if (this.targetLocation == null) {
            return false;
        }
        for (StringType item : this.targetLocation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addTargetLocationElement() {
        StringType t = new StringType();
        if (this.targetLocation == null) {
            this.targetLocation = new ArrayList<StringType>();
        }
        this.targetLocation.add(t);
        return t;
    }

    public VerificationResult addTargetLocation(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.targetLocation == null) {
            this.targetLocation = new ArrayList<StringType>();
        }
        this.targetLocation.add(t);
        return this;
    }

    public boolean hasTargetLocation(String value) {
        if (this.targetLocation == null) {
            return false;
        }
        for (StringType v : this.targetLocation) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept getNeed() {
        if (this.need == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.need");
            }
            if (Configuration.doAutoCreate()) {
                this.need = new CodeableConcept();
            }
        }
        return this.need;
    }

    public boolean hasNeed() {
        return this.need != null && !this.need.isEmpty();
    }

    public VerificationResult setNeed(CodeableConcept value) {
        this.need = value;
        return this;
    }

    public Enumeration<Status> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Status>(new StatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public VerificationResult setStatusElement(Enumeration<Status> value) {
        this.status = value;
        return this;
    }

    public Status getStatus() {
        return this.status == null ? null : (Status)((Object)this.status.getValue());
    }

    public VerificationResult setStatus(Status value) {
        if (this.status == null) {
            this.status = new Enumeration<Status>(new StatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public VerificationResult setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public VerificationResult setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public CodeableConcept getValidationType() {
        if (this.validationType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.validationType");
            }
            if (Configuration.doAutoCreate()) {
                this.validationType = new CodeableConcept();
            }
        }
        return this.validationType;
    }

    public boolean hasValidationType() {
        return this.validationType != null && !this.validationType.isEmpty();
    }

    public VerificationResult setValidationType(CodeableConcept value) {
        this.validationType = value;
        return this;
    }

    public List<CodeableConcept> getValidationProcess() {
        if (this.validationProcess == null) {
            this.validationProcess = new ArrayList<CodeableConcept>();
        }
        return this.validationProcess;
    }

    public VerificationResult setValidationProcess(List<CodeableConcept> theValidationProcess) {
        this.validationProcess = theValidationProcess;
        return this;
    }

    public boolean hasValidationProcess() {
        if (this.validationProcess == null) {
            return false;
        }
        for (CodeableConcept item : this.validationProcess) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addValidationProcess() {
        CodeableConcept t = new CodeableConcept();
        if (this.validationProcess == null) {
            this.validationProcess = new ArrayList<CodeableConcept>();
        }
        this.validationProcess.add(t);
        return t;
    }

    public VerificationResult addValidationProcess(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.validationProcess == null) {
            this.validationProcess = new ArrayList<CodeableConcept>();
        }
        this.validationProcess.add(t);
        return this;
    }

    public CodeableConcept getValidationProcessFirstRep() {
        if (this.getValidationProcess().isEmpty()) {
            this.addValidationProcess();
        }
        return this.getValidationProcess().get(0);
    }

    public Timing getFrequency() {
        if (this.frequency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.frequency");
            }
            if (Configuration.doAutoCreate()) {
                this.frequency = new Timing();
            }
        }
        return this.frequency;
    }

    public boolean hasFrequency() {
        return this.frequency != null && !this.frequency.isEmpty();
    }

    public VerificationResult setFrequency(Timing value) {
        this.frequency = value;
        return this;
    }

    public DateTimeType getLastPerformedElement() {
        if (this.lastPerformed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.lastPerformed");
            }
            if (Configuration.doAutoCreate()) {
                this.lastPerformed = new DateTimeType();
            }
        }
        return this.lastPerformed;
    }

    public boolean hasLastPerformedElement() {
        return this.lastPerformed != null && !this.lastPerformed.isEmpty();
    }

    public boolean hasLastPerformed() {
        return this.lastPerformed != null && !this.lastPerformed.isEmpty();
    }

    public VerificationResult setLastPerformedElement(DateTimeType value) {
        this.lastPerformed = value;
        return this;
    }

    public Date getLastPerformed() {
        return this.lastPerformed == null ? null : (Date)this.lastPerformed.getValue();
    }

    public VerificationResult setLastPerformed(Date value) {
        if (value == null) {
            this.lastPerformed = null;
        } else {
            if (this.lastPerformed == null) {
                this.lastPerformed = new DateTimeType();
            }
            this.lastPerformed.setValue(value);
        }
        return this;
    }

    public DateType getNextScheduledElement() {
        if (this.nextScheduled == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.nextScheduled");
            }
            if (Configuration.doAutoCreate()) {
                this.nextScheduled = new DateType();
            }
        }
        return this.nextScheduled;
    }

    public boolean hasNextScheduledElement() {
        return this.nextScheduled != null && !this.nextScheduled.isEmpty();
    }

    public boolean hasNextScheduled() {
        return this.nextScheduled != null && !this.nextScheduled.isEmpty();
    }

    public VerificationResult setNextScheduledElement(DateType value) {
        this.nextScheduled = value;
        return this;
    }

    public Date getNextScheduled() {
        return this.nextScheduled == null ? null : (Date)this.nextScheduled.getValue();
    }

    public VerificationResult setNextScheduled(Date value) {
        if (value == null) {
            this.nextScheduled = null;
        } else {
            if (this.nextScheduled == null) {
                this.nextScheduled = new DateType();
            }
            this.nextScheduled.setValue(value);
        }
        return this;
    }

    public CodeableConcept getFailureAction() {
        if (this.failureAction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.failureAction");
            }
            if (Configuration.doAutoCreate()) {
                this.failureAction = new CodeableConcept();
            }
        }
        return this.failureAction;
    }

    public boolean hasFailureAction() {
        return this.failureAction != null && !this.failureAction.isEmpty();
    }

    public VerificationResult setFailureAction(CodeableConcept value) {
        this.failureAction = value;
        return this;
    }

    public List<VerificationResultPrimarySourceComponent> getPrimarySource() {
        if (this.primarySource == null) {
            this.primarySource = new ArrayList<VerificationResultPrimarySourceComponent>();
        }
        return this.primarySource;
    }

    public VerificationResult setPrimarySource(List<VerificationResultPrimarySourceComponent> thePrimarySource) {
        this.primarySource = thePrimarySource;
        return this;
    }

    public boolean hasPrimarySource() {
        if (this.primarySource == null) {
            return false;
        }
        for (VerificationResultPrimarySourceComponent item : this.primarySource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VerificationResultPrimarySourceComponent addPrimarySource() {
        VerificationResultPrimarySourceComponent t = new VerificationResultPrimarySourceComponent();
        if (this.primarySource == null) {
            this.primarySource = new ArrayList<VerificationResultPrimarySourceComponent>();
        }
        this.primarySource.add(t);
        return t;
    }

    public VerificationResult addPrimarySource(VerificationResultPrimarySourceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.primarySource == null) {
            this.primarySource = new ArrayList<VerificationResultPrimarySourceComponent>();
        }
        this.primarySource.add(t);
        return this;
    }

    public VerificationResultPrimarySourceComponent getPrimarySourceFirstRep() {
        if (this.getPrimarySource().isEmpty()) {
            this.addPrimarySource();
        }
        return this.getPrimarySource().get(0);
    }

    public VerificationResultAttestationComponent getAttestation() {
        if (this.attestation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VerificationResult.attestation");
            }
            if (Configuration.doAutoCreate()) {
                this.attestation = new VerificationResultAttestationComponent();
            }
        }
        return this.attestation;
    }

    public boolean hasAttestation() {
        return this.attestation != null && !this.attestation.isEmpty();
    }

    public VerificationResult setAttestation(VerificationResultAttestationComponent value) {
        this.attestation = value;
        return this;
    }

    public List<VerificationResultValidatorComponent> getValidator() {
        if (this.validator == null) {
            this.validator = new ArrayList<VerificationResultValidatorComponent>();
        }
        return this.validator;
    }

    public VerificationResult setValidator(List<VerificationResultValidatorComponent> theValidator) {
        this.validator = theValidator;
        return this;
    }

    public boolean hasValidator() {
        if (this.validator == null) {
            return false;
        }
        for (VerificationResultValidatorComponent item : this.validator) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VerificationResultValidatorComponent addValidator() {
        VerificationResultValidatorComponent t = new VerificationResultValidatorComponent();
        if (this.validator == null) {
            this.validator = new ArrayList<VerificationResultValidatorComponent>();
        }
        this.validator.add(t);
        return t;
    }

    public VerificationResult addValidator(VerificationResultValidatorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.validator == null) {
            this.validator = new ArrayList<VerificationResultValidatorComponent>();
        }
        this.validator.add(t);
        return this;
    }

    public VerificationResultValidatorComponent getValidatorFirstRep() {
        if (this.getValidator().isEmpty()) {
            this.addValidator();
        }
        return this.getValidator().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_TARGET, "Reference(Any)", "A resource that was validated.", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("targetLocation", "string", "The fhirpath location(s) within the resource that was validated.", 0, Integer.MAX_VALUE, this.targetLocation));
        children.add(new Property("need", "CodeableConcept", "The frequency with which the target must be validated (none; initial; periodic).", 0, 1, this.need));
        children.add(new Property("status", "code", "The validation status of the target (attested; validated; in process; requires revalidation; validation failed; revalidation failed).", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "When the validation status was updated.", 0, 1, this.statusDate));
        children.add(new Property("validationType", "CodeableConcept", "What the target is validated against (nothing; primary source; multiple sources).", 0, 1, this.validationType));
        children.add(new Property("validationProcess", "CodeableConcept", "The primary process by which the target is validated (edit check; value set; primary source; multiple sources; standalone; in context).", 0, Integer.MAX_VALUE, this.validationProcess));
        children.add(new Property("frequency", "Timing", "Frequency of revalidation.", 0, 1, this.frequency));
        children.add(new Property("lastPerformed", "dateTime", "The date/time validation was last completed (including failed validations).", 0, 1, this.lastPerformed));
        children.add(new Property("nextScheduled", "date", "The date when target is next validated, if appropriate.", 0, 1, this.nextScheduled));
        children.add(new Property("failureAction", "CodeableConcept", "The result if validation fails (fatal; warning; record only; none).", 0, 1, this.failureAction));
        children.add(new Property("primarySource", "", "Information about the primary source(s) involved in validation.", 0, Integer.MAX_VALUE, this.primarySource));
        children.add(new Property("attestation", "", "Information about the entity attesting to information.", 0, 1, this.attestation));
        children.add(new Property("validator", "", "Information about the entity validating information.", 0, Integer.MAX_VALUE, this.validator));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -880905839: {
                return new Property(SP_TARGET, "Reference(Any)", "A resource that was validated.", 0, Integer.MAX_VALUE, this.target);
            }
            case 308958310: {
                return new Property("targetLocation", "string", "The fhirpath location(s) within the resource that was validated.", 0, Integer.MAX_VALUE, this.targetLocation);
            }
            case 3377302: {
                return new Property("need", "CodeableConcept", "The frequency with which the target must be validated (none; initial; periodic).", 0, 1, this.need);
            }
            case -892481550: {
                return new Property("status", "code", "The validation status of the target (attested; validated; in process; requires revalidation; validation failed; revalidation failed).", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "When the validation status was updated.", 0, 1, this.statusDate);
            }
            case -279681197: {
                return new Property("validationType", "CodeableConcept", "What the target is validated against (nothing; primary source; multiple sources).", 0, 1, this.validationType);
            }
            case 797680566: {
                return new Property("validationProcess", "CodeableConcept", "The primary process by which the target is validated (edit check; value set; primary source; multiple sources; standalone; in context).", 0, Integer.MAX_VALUE, this.validationProcess);
            }
            case -70023844: {
                return new Property("frequency", "Timing", "Frequency of revalidation.", 0, 1, this.frequency);
            }
            case -1313229366: {
                return new Property("lastPerformed", "dateTime", "The date/time validation was last completed (including failed validations).", 0, 1, this.lastPerformed);
            }
            case 1874589434: {
                return new Property("nextScheduled", "date", "The date when target is next validated, if appropriate.", 0, 1, this.nextScheduled);
            }
            case 1816382560: {
                return new Property("failureAction", "CodeableConcept", "The result if validation fails (fatal; warning; record only; none).", 0, 1, this.failureAction);
            }
            case -528721731: {
                return new Property("primarySource", "", "Information about the primary source(s) involved in validation.", 0, Integer.MAX_VALUE, this.primarySource);
            }
            case -709624112: {
                return new Property("attestation", "", "Information about the entity attesting to information.", 0, 1, this.attestation);
            }
            case -1109783726: {
                return new Property("validator", "", "Information about the entity validating information.", 0, Integer.MAX_VALUE, this.validator);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case 308958310: {
                return this.targetLocation == null ? new Base[]{} : this.targetLocation.toArray(new Base[this.targetLocation.size()]);
            }
            case 3377302: {
                Base[] baseArray;
                if (this.need == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.need;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.statusDate;
                }
                return baseArray;
            }
            case -279681197: {
                Base[] baseArray;
                if (this.validationType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.validationType;
                }
                return baseArray;
            }
            case 797680566: {
                return this.validationProcess == null ? new Base[]{} : this.validationProcess.toArray(new Base[this.validationProcess.size()]);
            }
            case -70023844: {
                Base[] baseArray;
                if (this.frequency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.frequency;
                }
                return baseArray;
            }
            case -1313229366: {
                Base[] baseArray;
                if (this.lastPerformed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.lastPerformed;
                }
                return baseArray;
            }
            case 1874589434: {
                Base[] baseArray;
                if (this.nextScheduled == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.nextScheduled;
                }
                return baseArray;
            }
            case 1816382560: {
                Base[] baseArray;
                if (this.failureAction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.failureAction;
                }
                return baseArray;
            }
            case -528721731: {
                return this.primarySource == null ? new Base[]{} : this.primarySource.toArray(new Base[this.primarySource.size()]);
            }
            case -709624112: {
                Base[] baseArray;
                if (this.attestation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.attestation;
                }
                return baseArray;
            }
            case -1109783726: {
                return this.validator == null ? new Base[]{} : this.validator.toArray(new Base[this.validator.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -880905839: {
                this.getTarget().add(this.castToReference(value));
                return value;
            }
            case 308958310: {
                this.getTargetLocation().add(this.castToString(value));
                return value;
            }
            case 3377302: {
                this.need = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new StatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 247524032: {
                this.statusDate = this.castToDateTime(value);
                return value;
            }
            case -279681197: {
                this.validationType = this.castToCodeableConcept(value);
                return value;
            }
            case 797680566: {
                this.getValidationProcess().add(this.castToCodeableConcept(value));
                return value;
            }
            case -70023844: {
                this.frequency = this.castToTiming(value);
                return value;
            }
            case -1313229366: {
                this.lastPerformed = this.castToDateTime(value);
                return value;
            }
            case 1874589434: {
                this.nextScheduled = this.castToDate(value);
                return value;
            }
            case 1816382560: {
                this.failureAction = this.castToCodeableConcept(value);
                return value;
            }
            case -528721731: {
                this.getPrimarySource().add((VerificationResultPrimarySourceComponent)((Object)value));
                return value;
            }
            case -709624112: {
                this.attestation = (VerificationResultAttestationComponent)((Object)value);
                return value;
            }
            case -1109783726: {
                this.getValidator().add((VerificationResultValidatorComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            this.getTarget().add(this.castToReference(value));
        } else if (name.equals("targetLocation")) {
            this.getTargetLocation().add(this.castToString(value));
        } else if (name.equals("need")) {
            this.need = this.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            value = new StatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusDate")) {
            this.statusDate = this.castToDateTime(value);
        } else if (name.equals("validationType")) {
            this.validationType = this.castToCodeableConcept(value);
        } else if (name.equals("validationProcess")) {
            this.getValidationProcess().add(this.castToCodeableConcept(value));
        } else if (name.equals("frequency")) {
            this.frequency = this.castToTiming(value);
        } else if (name.equals("lastPerformed")) {
            this.lastPerformed = this.castToDateTime(value);
        } else if (name.equals("nextScheduled")) {
            this.nextScheduled = this.castToDate(value);
        } else if (name.equals("failureAction")) {
            this.failureAction = this.castToCodeableConcept(value);
        } else if (name.equals("primarySource")) {
            this.getPrimarySource().add((VerificationResultPrimarySourceComponent)((Object)value));
        } else if (name.equals("attestation")) {
            this.attestation = (VerificationResultAttestationComponent)((Object)value);
        } else if (name.equals("validator")) {
            this.getValidator().add((VerificationResultValidatorComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.addTarget();
            }
            case 308958310: {
                return this.addTargetLocationElement();
            }
            case 3377302: {
                return this.getNeed();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -279681197: {
                return this.getValidationType();
            }
            case 797680566: {
                return this.addValidationProcess();
            }
            case -70023844: {
                return this.getFrequency();
            }
            case -1313229366: {
                return this.getLastPerformedElement();
            }
            case 1874589434: {
                return this.getNextScheduledElement();
            }
            case 1816382560: {
                return this.getFailureAction();
            }
            case -528721731: {
                return this.addPrimarySource();
            }
            case -709624112: {
                return this.getAttestation();
            }
            case -1109783726: {
                return this.addValidator();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return new String[]{"Reference"};
            }
            case 308958310: {
                return new String[]{"string"};
            }
            case 3377302: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -279681197: {
                return new String[]{"CodeableConcept"};
            }
            case 797680566: {
                return new String[]{"CodeableConcept"};
            }
            case -70023844: {
                return new String[]{"Timing"};
            }
            case -1313229366: {
                return new String[]{"dateTime"};
            }
            case 1874589434: {
                return new String[]{"date"};
            }
            case 1816382560: {
                return new String[]{"CodeableConcept"};
            }
            case -528721731: {
                return new String[0];
            }
            case -709624112: {
                return new String[0];
            }
            case -1109783726: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            return this.addTarget();
        }
        if (name.equals("targetLocation")) {
            throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.targetLocation");
        }
        if (name.equals("need")) {
            this.need = new CodeableConcept();
            return this.need;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.status");
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.statusDate");
        }
        if (name.equals("validationType")) {
            this.validationType = new CodeableConcept();
            return this.validationType;
        }
        if (name.equals("validationProcess")) {
            return this.addValidationProcess();
        }
        if (name.equals("frequency")) {
            this.frequency = new Timing();
            return this.frequency;
        }
        if (name.equals("lastPerformed")) {
            throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.lastPerformed");
        }
        if (name.equals("nextScheduled")) {
            throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.nextScheduled");
        }
        if (name.equals("failureAction")) {
            this.failureAction = new CodeableConcept();
            return this.failureAction;
        }
        if (name.equals("primarySource")) {
            return this.addPrimarySource();
        }
        if (name.equals("attestation")) {
            this.attestation = new VerificationResultAttestationComponent();
            return this.attestation;
        }
        if (name.equals("validator")) {
            return this.addValidator();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VerificationResult";
    }

    @Override
    public VerificationResult copy() {
        VerificationResult dst = new VerificationResult();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(VerificationResult dst) {
        super.copyValues(dst);
        if (this.target != null) {
            dst.target = new ArrayList<Reference>();
            for (Reference reference : this.target) {
                dst.target.add(reference.copy());
            }
        }
        if (this.targetLocation != null) {
            dst.targetLocation = new ArrayList<StringType>();
            for (StringType stringType : this.targetLocation) {
                dst.targetLocation.add(stringType.copy());
            }
        }
        dst.need = this.need == null ? null : this.need.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        CodeableConcept codeableConcept = dst.validationType = this.validationType == null ? null : this.validationType.copy();
        if (this.validationProcess != null) {
            dst.validationProcess = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.validationProcess) {
                dst.validationProcess.add(codeableConcept2.copy());
            }
        }
        dst.frequency = this.frequency == null ? null : this.frequency.copy();
        dst.lastPerformed = this.lastPerformed == null ? null : this.lastPerformed.copy();
        dst.nextScheduled = this.nextScheduled == null ? null : this.nextScheduled.copy();
        CodeableConcept codeableConcept3 = dst.failureAction = this.failureAction == null ? null : this.failureAction.copy();
        if (this.primarySource != null) {
            dst.primarySource = new ArrayList<VerificationResultPrimarySourceComponent>();
            for (VerificationResultPrimarySourceComponent verificationResultPrimarySourceComponent : this.primarySource) {
                dst.primarySource.add(verificationResultPrimarySourceComponent.copy());
            }
        }
        VerificationResultAttestationComponent verificationResultAttestationComponent = dst.attestation = this.attestation == null ? null : this.attestation.copy();
        if (this.validator != null) {
            dst.validator = new ArrayList<VerificationResultValidatorComponent>();
            for (VerificationResultValidatorComponent verificationResultValidatorComponent : this.validator) {
                dst.validator.add(verificationResultValidatorComponent.copy());
            }
        }
    }

    protected VerificationResult typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof VerificationResult)) {
            return false;
        }
        VerificationResult o = (VerificationResult)other_;
        return VerificationResult.compareDeep(this.target, o.target, true) && VerificationResult.compareDeep(this.targetLocation, o.targetLocation, true) && VerificationResult.compareDeep(this.need, o.need, true) && VerificationResult.compareDeep(this.status, o.status, true) && VerificationResult.compareDeep(this.statusDate, o.statusDate, true) && VerificationResult.compareDeep(this.validationType, o.validationType, true) && VerificationResult.compareDeep(this.validationProcess, o.validationProcess, true) && VerificationResult.compareDeep(this.frequency, o.frequency, true) && VerificationResult.compareDeep(this.lastPerformed, o.lastPerformed, true) && VerificationResult.compareDeep(this.nextScheduled, o.nextScheduled, true) && VerificationResult.compareDeep(this.failureAction, o.failureAction, true) && VerificationResult.compareDeep(this.primarySource, o.primarySource, true) && VerificationResult.compareDeep(this.attestation, o.attestation, true) && VerificationResult.compareDeep(this.validator, o.validator, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof VerificationResult)) {
            return false;
        }
        VerificationResult o = (VerificationResult)other_;
        return VerificationResult.compareValues(this.targetLocation, o.targetLocation, true) && VerificationResult.compareValues(this.status, o.status, true) && VerificationResult.compareValues(this.statusDate, o.statusDate, true) && VerificationResult.compareValues(this.lastPerformed, o.lastPerformed, true) && VerificationResult.compareValues(this.nextScheduled, o.nextScheduled, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.target, this.targetLocation, this.need, this.status, this.statusDate, this.validationType, this.validationProcess, this.frequency, this.lastPerformed, this.nextScheduled, this.failureAction, this.primarySource, this.attestation, this.validator});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.VerificationResult;
    }

    @Block
    public static class VerificationResultValidatorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="organization", type={Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the organization validating information", formalDefinition="Reference to the organization validating information.")
        protected Reference organization;
        protected Organization organizationTarget;
        @Child(name="identityCertificate", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A digital identity certificate associated with the validator", formalDefinition="A digital identity certificate associated with the validator.")
        protected StringType identityCertificate;
        @Child(name="attestationSignature", type={Signature.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Validator signature", formalDefinition="Signed assertion by the validator that they have validated the information.")
        protected Signature attestationSignature;
        private static final long serialVersionUID = 35580619L;

        public VerificationResultValidatorComponent() {
        }

        public VerificationResultValidatorComponent(Reference organization) {
            this.organization = organization;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultValidatorComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public VerificationResultValidatorComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Organization getOrganizationTarget() {
            if (this.organizationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultValidatorComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organizationTarget = new Organization();
                }
            }
            return this.organizationTarget;
        }

        public VerificationResultValidatorComponent setOrganizationTarget(Organization value) {
            this.organizationTarget = value;
            return this;
        }

        public StringType getIdentityCertificateElement() {
            if (this.identityCertificate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultValidatorComponent.identityCertificate");
                }
                if (Configuration.doAutoCreate()) {
                    this.identityCertificate = new StringType();
                }
            }
            return this.identityCertificate;
        }

        public boolean hasIdentityCertificateElement() {
            return this.identityCertificate != null && !this.identityCertificate.isEmpty();
        }

        public boolean hasIdentityCertificate() {
            return this.identityCertificate != null && !this.identityCertificate.isEmpty();
        }

        public VerificationResultValidatorComponent setIdentityCertificateElement(StringType value) {
            this.identityCertificate = value;
            return this;
        }

        public String getIdentityCertificate() {
            return this.identityCertificate == null ? null : (String)this.identityCertificate.getValue();
        }

        public VerificationResultValidatorComponent setIdentityCertificate(String value) {
            if (Utilities.noString((String)value)) {
                this.identityCertificate = null;
            } else {
                if (this.identityCertificate == null) {
                    this.identityCertificate = new StringType();
                }
                this.identityCertificate.setValue(value);
            }
            return this;
        }

        public Signature getAttestationSignature() {
            if (this.attestationSignature == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultValidatorComponent.attestationSignature");
                }
                if (Configuration.doAutoCreate()) {
                    this.attestationSignature = new Signature();
                }
            }
            return this.attestationSignature;
        }

        public boolean hasAttestationSignature() {
            return this.attestationSignature != null && !this.attestationSignature.isEmpty();
        }

        public VerificationResultValidatorComponent setAttestationSignature(Signature value) {
            this.attestationSignature = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("organization", "Reference(Organization)", "Reference to the organization validating information.", 0, 1, this.organization));
            children.add(new Property("identityCertificate", "string", "A digital identity certificate associated with the validator.", 0, 1, this.identityCertificate));
            children.add(new Property("attestationSignature", "Signature", "Signed assertion by the validator that they have validated the information.", 0, 1, this.attestationSignature));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1178922291: {
                    return new Property("organization", "Reference(Organization)", "Reference to the organization validating information.", 0, 1, this.organization);
                }
                case -854379015: {
                    return new Property("identityCertificate", "string", "A digital identity certificate associated with the validator.", 0, 1, this.identityCertificate);
                }
                case -184196152: {
                    return new Property("attestationSignature", "Signature", "Signed assertion by the validator that they have validated the information.", 0, 1, this.attestationSignature);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    Base[] baseArray;
                    if (this.organization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.organization;
                    }
                    return baseArray;
                }
                case -854379015: {
                    Base[] baseArray;
                    if (this.identityCertificate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identityCertificate;
                    }
                    return baseArray;
                }
                case -184196152: {
                    Base[] baseArray;
                    if (this.attestationSignature == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.attestationSignature;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    this.organization = this.castToReference(value);
                    return value;
                }
                case -854379015: {
                    this.identityCertificate = this.castToString(value);
                    return value;
                }
                case -184196152: {
                    this.attestationSignature = this.castToSignature(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("organization")) {
                this.organization = this.castToReference(value);
            } else if (name.equals("identityCertificate")) {
                this.identityCertificate = this.castToString(value);
            } else if (name.equals("attestationSignature")) {
                this.attestationSignature = this.castToSignature(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    return this.getOrganization();
                }
                case -854379015: {
                    return this.getIdentityCertificateElement();
                }
                case -184196152: {
                    return this.getAttestationSignature();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    return new String[]{"Reference"};
                }
                case -854379015: {
                    return new String[]{"string"};
                }
                case -184196152: {
                    return new String[]{"Signature"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("organization")) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals("identityCertificate")) {
                throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.identityCertificate");
            }
            if (name.equals("attestationSignature")) {
                this.attestationSignature = new Signature();
                return this.attestationSignature;
            }
            return super.addChild(name);
        }

        @Override
        public VerificationResultValidatorComponent copy() {
            VerificationResultValidatorComponent dst = new VerificationResultValidatorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(VerificationResultValidatorComponent dst) {
            super.copyValues(dst);
            dst.organization = this.organization == null ? null : this.organization.copy();
            dst.identityCertificate = this.identityCertificate == null ? null : this.identityCertificate.copy();
            dst.attestationSignature = this.attestationSignature == null ? null : this.attestationSignature.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultValidatorComponent)) {
                return false;
            }
            VerificationResultValidatorComponent o = (VerificationResultValidatorComponent)other_;
            return VerificationResultValidatorComponent.compareDeep(this.organization, o.organization, true) && VerificationResultValidatorComponent.compareDeep(this.identityCertificate, o.identityCertificate, true) && VerificationResultValidatorComponent.compareDeep(this.attestationSignature, o.attestationSignature, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultValidatorComponent)) {
                return false;
            }
            VerificationResultValidatorComponent o = (VerificationResultValidatorComponent)other_;
            return VerificationResultValidatorComponent.compareValues(this.identityCertificate, o.identityCertificate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.organization, this.identityCertificate, this.attestationSignature});
        }

        @Override
        public String fhirType() {
            return "VerificationResult.validator";
        }
    }

    @Block
    public static class VerificationResultAttestationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="who", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The individual or organization attesting to information", formalDefinition="The individual or organization attesting to information.")
        protected Reference who;
        protected Resource whoTarget;
        @Child(name="onBehalfOf", type={Organization.class, Practitioner.class, PractitionerRole.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the who is asserting on behalf of another (organization or individual)", formalDefinition="When the who is asserting on behalf of another (organization or individual).")
        protected Reference onBehalfOf;
        protected Resource onBehalfOfTarget;
        @Child(name="communicationMethod", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The method by which attested information was submitted/retrieved", formalDefinition="The method by which attested information was submitted/retrieved (manual; API; Push).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-communication-method")
        protected CodeableConcept communicationMethod;
        @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date the information was attested to", formalDefinition="The date the information was attested to.")
        protected DateType date;
        @Child(name="sourceIdentityCertificate", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A digital identity certificate associated with the attestation source", formalDefinition="A digital identity certificate associated with the attestation source.")
        protected StringType sourceIdentityCertificate;
        @Child(name="proxyIdentityCertificate", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A digital identity certificate associated with the proxy entity submitting attested information on behalf of the attestation source", formalDefinition="A digital identity certificate associated with the proxy entity submitting attested information on behalf of the attestation source.")
        protected StringType proxyIdentityCertificate;
        @Child(name="proxySignature", type={Signature.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Proxy signature", formalDefinition="Signed assertion by the proxy entity indicating that they have the right to submit attested information on behalf of the attestation source.")
        protected Signature proxySignature;
        @Child(name="sourceSignature", type={Signature.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Attester signature", formalDefinition="Signed assertion by the attestation source that they have attested to the information.")
        protected Signature sourceSignature;
        private static final long serialVersionUID = -900018800L;

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public VerificationResultAttestationComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Resource getWhoTarget() {
            return this.whoTarget;
        }

        public VerificationResultAttestationComponent setWhoTarget(Resource value) {
            this.whoTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public VerificationResultAttestationComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Resource getOnBehalfOfTarget() {
            return this.onBehalfOfTarget;
        }

        public VerificationResultAttestationComponent setOnBehalfOfTarget(Resource value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        public CodeableConcept getCommunicationMethod() {
            if (this.communicationMethod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.communicationMethod");
                }
                if (Configuration.doAutoCreate()) {
                    this.communicationMethod = new CodeableConcept();
                }
            }
            return this.communicationMethod;
        }

        public boolean hasCommunicationMethod() {
            return this.communicationMethod != null && !this.communicationMethod.isEmpty();
        }

        public VerificationResultAttestationComponent setCommunicationMethod(CodeableConcept value) {
            this.communicationMethod = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public VerificationResultAttestationComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public VerificationResultAttestationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public StringType getSourceIdentityCertificateElement() {
            if (this.sourceIdentityCertificate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.sourceIdentityCertificate");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceIdentityCertificate = new StringType();
                }
            }
            return this.sourceIdentityCertificate;
        }

        public boolean hasSourceIdentityCertificateElement() {
            return this.sourceIdentityCertificate != null && !this.sourceIdentityCertificate.isEmpty();
        }

        public boolean hasSourceIdentityCertificate() {
            return this.sourceIdentityCertificate != null && !this.sourceIdentityCertificate.isEmpty();
        }

        public VerificationResultAttestationComponent setSourceIdentityCertificateElement(StringType value) {
            this.sourceIdentityCertificate = value;
            return this;
        }

        public String getSourceIdentityCertificate() {
            return this.sourceIdentityCertificate == null ? null : (String)this.sourceIdentityCertificate.getValue();
        }

        public VerificationResultAttestationComponent setSourceIdentityCertificate(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceIdentityCertificate = null;
            } else {
                if (this.sourceIdentityCertificate == null) {
                    this.sourceIdentityCertificate = new StringType();
                }
                this.sourceIdentityCertificate.setValue(value);
            }
            return this;
        }

        public StringType getProxyIdentityCertificateElement() {
            if (this.proxyIdentityCertificate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.proxyIdentityCertificate");
                }
                if (Configuration.doAutoCreate()) {
                    this.proxyIdentityCertificate = new StringType();
                }
            }
            return this.proxyIdentityCertificate;
        }

        public boolean hasProxyIdentityCertificateElement() {
            return this.proxyIdentityCertificate != null && !this.proxyIdentityCertificate.isEmpty();
        }

        public boolean hasProxyIdentityCertificate() {
            return this.proxyIdentityCertificate != null && !this.proxyIdentityCertificate.isEmpty();
        }

        public VerificationResultAttestationComponent setProxyIdentityCertificateElement(StringType value) {
            this.proxyIdentityCertificate = value;
            return this;
        }

        public String getProxyIdentityCertificate() {
            return this.proxyIdentityCertificate == null ? null : (String)this.proxyIdentityCertificate.getValue();
        }

        public VerificationResultAttestationComponent setProxyIdentityCertificate(String value) {
            if (Utilities.noString((String)value)) {
                this.proxyIdentityCertificate = null;
            } else {
                if (this.proxyIdentityCertificate == null) {
                    this.proxyIdentityCertificate = new StringType();
                }
                this.proxyIdentityCertificate.setValue(value);
            }
            return this;
        }

        public Signature getProxySignature() {
            if (this.proxySignature == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.proxySignature");
                }
                if (Configuration.doAutoCreate()) {
                    this.proxySignature = new Signature();
                }
            }
            return this.proxySignature;
        }

        public boolean hasProxySignature() {
            return this.proxySignature != null && !this.proxySignature.isEmpty();
        }

        public VerificationResultAttestationComponent setProxySignature(Signature value) {
            this.proxySignature = value;
            return this;
        }

        public Signature getSourceSignature() {
            if (this.sourceSignature == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultAttestationComponent.sourceSignature");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceSignature = new Signature();
                }
            }
            return this.sourceSignature;
        }

        public boolean hasSourceSignature() {
            return this.sourceSignature != null && !this.sourceSignature.isEmpty();
        }

        public VerificationResultAttestationComponent setSourceSignature(Signature value) {
            this.sourceSignature = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("who", "Reference(Practitioner|PractitionerRole|Organization)", "The individual or organization attesting to information.", 0, 1, this.who));
            children.add(new Property("onBehalfOf", "Reference(Organization|Practitioner|PractitionerRole)", "When the who is asserting on behalf of another (organization or individual).", 0, 1, this.onBehalfOf));
            children.add(new Property("communicationMethod", "CodeableConcept", "The method by which attested information was submitted/retrieved (manual; API; Push).", 0, 1, this.communicationMethod));
            children.add(new Property("date", "date", "The date the information was attested to.", 0, 1, this.date));
            children.add(new Property("sourceIdentityCertificate", "string", "A digital identity certificate associated with the attestation source.", 0, 1, this.sourceIdentityCertificate));
            children.add(new Property("proxyIdentityCertificate", "string", "A digital identity certificate associated with the proxy entity submitting attested information on behalf of the attestation source.", 0, 1, this.proxyIdentityCertificate));
            children.add(new Property("proxySignature", "Signature", "Signed assertion by the proxy entity indicating that they have the right to submit attested information on behalf of the attestation source.", 0, 1, this.proxySignature));
            children.add(new Property("sourceSignature", "Signature", "Signed assertion by the attestation source that they have attested to the information.", 0, 1, this.sourceSignature));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 117694: {
                    return new Property("who", "Reference(Practitioner|PractitionerRole|Organization)", "The individual or organization attesting to information.", 0, 1, this.who);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization|Practitioner|PractitionerRole)", "When the who is asserting on behalf of another (organization or individual).", 0, 1, this.onBehalfOf);
                }
                case 1314116695: {
                    return new Property("communicationMethod", "CodeableConcept", "The method by which attested information was submitted/retrieved (manual; API; Push).", 0, 1, this.communicationMethod);
                }
                case 3076014: {
                    return new Property("date", "date", "The date the information was attested to.", 0, 1, this.date);
                }
                case -799067682: {
                    return new Property("sourceIdentityCertificate", "string", "A digital identity certificate associated with the attestation source.", 0, 1, this.sourceIdentityCertificate);
                }
                case 431558827: {
                    return new Property("proxyIdentityCertificate", "string", "A digital identity certificate associated with the proxy entity submitting attested information on behalf of the attestation source.", 0, 1, this.proxyIdentityCertificate);
                }
                case 1455540714: {
                    return new Property("proxySignature", "Signature", "Signed assertion by the proxy entity indicating that they have the right to submit attested information on behalf of the attestation source.", 0, 1, this.proxySignature);
                }
                case 1754480349: {
                    return new Property("sourceSignature", "Signature", "Signed assertion by the attestation source that they have attested to the information.", 0, 1, this.sourceSignature);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.who;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
                case 1314116695: {
                    Base[] baseArray;
                    if (this.communicationMethod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.communicationMethod;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case -799067682: {
                    Base[] baseArray;
                    if (this.sourceIdentityCertificate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.sourceIdentityCertificate;
                    }
                    return baseArray;
                }
                case 431558827: {
                    Base[] baseArray;
                    if (this.proxyIdentityCertificate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.proxyIdentityCertificate;
                    }
                    return baseArray;
                }
                case 1455540714: {
                    Base[] baseArray;
                    if (this.proxySignature == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.proxySignature;
                    }
                    return baseArray;
                }
                case 1754480349: {
                    Base[] baseArray;
                    if (this.sourceSignature == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.sourceSignature;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 117694: {
                    this.who = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
                case 1314116695: {
                    this.communicationMethod = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case -799067682: {
                    this.sourceIdentityCertificate = this.castToString(value);
                    return value;
                }
                case 431558827: {
                    this.proxyIdentityCertificate = this.castToString(value);
                    return value;
                }
                case 1455540714: {
                    this.proxySignature = this.castToSignature(value);
                    return value;
                }
                case 1754480349: {
                    this.sourceSignature = this.castToSignature(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("who")) {
                this.who = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else if (name.equals("communicationMethod")) {
                this.communicationMethod = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("sourceIdentityCertificate")) {
                this.sourceIdentityCertificate = this.castToString(value);
            } else if (name.equals("proxyIdentityCertificate")) {
                this.proxyIdentityCertificate = this.castToString(value);
            } else if (name.equals("proxySignature")) {
                this.proxySignature = this.castToSignature(value);
            } else if (name.equals("sourceSignature")) {
                this.sourceSignature = this.castToSignature(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 117694: {
                    return this.getWho();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
                case 1314116695: {
                    return this.getCommunicationMethod();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -799067682: {
                    return this.getSourceIdentityCertificateElement();
                }
                case 431558827: {
                    return this.getProxyIdentityCertificateElement();
                }
                case 1455540714: {
                    return this.getProxySignature();
                }
                case 1754480349: {
                    return this.getSourceSignature();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 117694: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
                case 1314116695: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case -799067682: {
                    return new String[]{"string"};
                }
                case 431558827: {
                    return new String[]{"string"};
                }
                case 1455540714: {
                    return new String[]{"Signature"};
                }
                case 1754480349: {
                    return new String[]{"Signature"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            if (name.equals("communicationMethod")) {
                this.communicationMethod = new CodeableConcept();
                return this.communicationMethod;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.date");
            }
            if (name.equals("sourceIdentityCertificate")) {
                throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.sourceIdentityCertificate");
            }
            if (name.equals("proxyIdentityCertificate")) {
                throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.proxyIdentityCertificate");
            }
            if (name.equals("proxySignature")) {
                this.proxySignature = new Signature();
                return this.proxySignature;
            }
            if (name.equals("sourceSignature")) {
                this.sourceSignature = new Signature();
                return this.sourceSignature;
            }
            return super.addChild(name);
        }

        @Override
        public VerificationResultAttestationComponent copy() {
            VerificationResultAttestationComponent dst = new VerificationResultAttestationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(VerificationResultAttestationComponent dst) {
            super.copyValues(dst);
            dst.who = this.who == null ? null : this.who.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            dst.communicationMethod = this.communicationMethod == null ? null : this.communicationMethod.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.sourceIdentityCertificate = this.sourceIdentityCertificate == null ? null : this.sourceIdentityCertificate.copy();
            dst.proxyIdentityCertificate = this.proxyIdentityCertificate == null ? null : this.proxyIdentityCertificate.copy();
            dst.proxySignature = this.proxySignature == null ? null : this.proxySignature.copy();
            dst.sourceSignature = this.sourceSignature == null ? null : this.sourceSignature.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultAttestationComponent)) {
                return false;
            }
            VerificationResultAttestationComponent o = (VerificationResultAttestationComponent)other_;
            return VerificationResultAttestationComponent.compareDeep(this.who, o.who, true) && VerificationResultAttestationComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true) && VerificationResultAttestationComponent.compareDeep(this.communicationMethod, o.communicationMethod, true) && VerificationResultAttestationComponent.compareDeep(this.date, o.date, true) && VerificationResultAttestationComponent.compareDeep(this.sourceIdentityCertificate, o.sourceIdentityCertificate, true) && VerificationResultAttestationComponent.compareDeep(this.proxyIdentityCertificate, o.proxyIdentityCertificate, true) && VerificationResultAttestationComponent.compareDeep(this.proxySignature, o.proxySignature, true) && VerificationResultAttestationComponent.compareDeep(this.sourceSignature, o.sourceSignature, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultAttestationComponent)) {
                return false;
            }
            VerificationResultAttestationComponent o = (VerificationResultAttestationComponent)other_;
            return VerificationResultAttestationComponent.compareValues(this.date, o.date, true) && VerificationResultAttestationComponent.compareValues(this.sourceIdentityCertificate, o.sourceIdentityCertificate, true) && VerificationResultAttestationComponent.compareValues(this.proxyIdentityCertificate, o.proxyIdentityCertificate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.who, this.onBehalfOf, this.communicationMethod, this.date, this.sourceIdentityCertificate, this.proxyIdentityCertificate, this.proxySignature, this.sourceSignature});
        }

        @Override
        public String fhirType() {
            return "VerificationResult.attestation";
        }
    }

    @Block
    public static class VerificationResultPrimarySourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="who", type={Organization.class, Practitioner.class, PractitionerRole.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the primary source", formalDefinition="Reference to the primary source.")
        protected Reference who;
        protected Resource whoTarget;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Type of primary source (License Board; Primary Education; Continuing Education; Postal Service; Relationship owner; Registration Authority; legal source; issuing source; authoritative source)", formalDefinition="Type of primary source (License Board; Primary Education; Continuing Education; Postal Service; Relationship owner; Registration Authority; legal source; issuing source; authoritative source).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-primary-source-type")
        protected List<CodeableConcept> type;
        @Child(name="communicationMethod", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Method for exchanging information with the primary source", formalDefinition="Method for communicating with the primary source (manual; API; Push).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-communication-method")
        protected List<CodeableConcept> communicationMethod;
        @Child(name="validationStatus", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="successful | failed | unknown", formalDefinition="Status of the validation of the target against the primary source (successful; failed; unknown).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-status")
        protected CodeableConcept validationStatus;
        @Child(name="validationDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the target was validated against the primary source", formalDefinition="When the target was validated against the primary source.")
        protected DateTimeType validationDate;
        @Child(name="canPushUpdates", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="yes | no | undetermined", formalDefinition="Ability of the primary source to push updates/alerts (yes; no; undetermined).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-can-push-updates")
        protected CodeableConcept canPushUpdates;
        @Child(name="pushTypeAvailable", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="specific | any | source", formalDefinition="Type of alerts/updates the primary source can send (specific requested changes; any changes; as defined by source).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/verificationresult-push-type-available")
        protected List<CodeableConcept> pushTypeAvailable;
        private static final long serialVersionUID = -928858332L;

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultPrimarySourceComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public VerificationResultPrimarySourceComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Resource getWhoTarget() {
            return this.whoTarget;
        }

        public VerificationResultPrimarySourceComponent setWhoTarget(Resource value) {
            this.whoTarget = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public VerificationResultPrimarySourceComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public VerificationResultPrimarySourceComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<CodeableConcept> getCommunicationMethod() {
            if (this.communicationMethod == null) {
                this.communicationMethod = new ArrayList<CodeableConcept>();
            }
            return this.communicationMethod;
        }

        public VerificationResultPrimarySourceComponent setCommunicationMethod(List<CodeableConcept> theCommunicationMethod) {
            this.communicationMethod = theCommunicationMethod;
            return this;
        }

        public boolean hasCommunicationMethod() {
            if (this.communicationMethod == null) {
                return false;
            }
            for (CodeableConcept item : this.communicationMethod) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCommunicationMethod() {
            CodeableConcept t = new CodeableConcept();
            if (this.communicationMethod == null) {
                this.communicationMethod = new ArrayList<CodeableConcept>();
            }
            this.communicationMethod.add(t);
            return t;
        }

        public VerificationResultPrimarySourceComponent addCommunicationMethod(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.communicationMethod == null) {
                this.communicationMethod = new ArrayList<CodeableConcept>();
            }
            this.communicationMethod.add(t);
            return this;
        }

        public CodeableConcept getCommunicationMethodFirstRep() {
            if (this.getCommunicationMethod().isEmpty()) {
                this.addCommunicationMethod();
            }
            return this.getCommunicationMethod().get(0);
        }

        public CodeableConcept getValidationStatus() {
            if (this.validationStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultPrimarySourceComponent.validationStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.validationStatus = new CodeableConcept();
                }
            }
            return this.validationStatus;
        }

        public boolean hasValidationStatus() {
            return this.validationStatus != null && !this.validationStatus.isEmpty();
        }

        public VerificationResultPrimarySourceComponent setValidationStatus(CodeableConcept value) {
            this.validationStatus = value;
            return this;
        }

        public DateTimeType getValidationDateElement() {
            if (this.validationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultPrimarySourceComponent.validationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.validationDate = new DateTimeType();
                }
            }
            return this.validationDate;
        }

        public boolean hasValidationDateElement() {
            return this.validationDate != null && !this.validationDate.isEmpty();
        }

        public boolean hasValidationDate() {
            return this.validationDate != null && !this.validationDate.isEmpty();
        }

        public VerificationResultPrimarySourceComponent setValidationDateElement(DateTimeType value) {
            this.validationDate = value;
            return this;
        }

        public Date getValidationDate() {
            return this.validationDate == null ? null : (Date)this.validationDate.getValue();
        }

        public VerificationResultPrimarySourceComponent setValidationDate(Date value) {
            if (value == null) {
                this.validationDate = null;
            } else {
                if (this.validationDate == null) {
                    this.validationDate = new DateTimeType();
                }
                this.validationDate.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCanPushUpdates() {
            if (this.canPushUpdates == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VerificationResultPrimarySourceComponent.canPushUpdates");
                }
                if (Configuration.doAutoCreate()) {
                    this.canPushUpdates = new CodeableConcept();
                }
            }
            return this.canPushUpdates;
        }

        public boolean hasCanPushUpdates() {
            return this.canPushUpdates != null && !this.canPushUpdates.isEmpty();
        }

        public VerificationResultPrimarySourceComponent setCanPushUpdates(CodeableConcept value) {
            this.canPushUpdates = value;
            return this;
        }

        public List<CodeableConcept> getPushTypeAvailable() {
            if (this.pushTypeAvailable == null) {
                this.pushTypeAvailable = new ArrayList<CodeableConcept>();
            }
            return this.pushTypeAvailable;
        }

        public VerificationResultPrimarySourceComponent setPushTypeAvailable(List<CodeableConcept> thePushTypeAvailable) {
            this.pushTypeAvailable = thePushTypeAvailable;
            return this;
        }

        public boolean hasPushTypeAvailable() {
            if (this.pushTypeAvailable == null) {
                return false;
            }
            for (CodeableConcept item : this.pushTypeAvailable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPushTypeAvailable() {
            CodeableConcept t = new CodeableConcept();
            if (this.pushTypeAvailable == null) {
                this.pushTypeAvailable = new ArrayList<CodeableConcept>();
            }
            this.pushTypeAvailable.add(t);
            return t;
        }

        public VerificationResultPrimarySourceComponent addPushTypeAvailable(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.pushTypeAvailable == null) {
                this.pushTypeAvailable = new ArrayList<CodeableConcept>();
            }
            this.pushTypeAvailable.add(t);
            return this;
        }

        public CodeableConcept getPushTypeAvailableFirstRep() {
            if (this.getPushTypeAvailable().isEmpty()) {
                this.addPushTypeAvailable();
            }
            return this.getPushTypeAvailable().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("who", "Reference(Organization|Practitioner|PractitionerRole)", "Reference to the primary source.", 0, 1, this.who));
            children.add(new Property("type", "CodeableConcept", "Type of primary source (License Board; Primary Education; Continuing Education; Postal Service; Relationship owner; Registration Authority; legal source; issuing source; authoritative source).", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("communicationMethod", "CodeableConcept", "Method for communicating with the primary source (manual; API; Push).", 0, Integer.MAX_VALUE, this.communicationMethod));
            children.add(new Property("validationStatus", "CodeableConcept", "Status of the validation of the target against the primary source (successful; failed; unknown).", 0, 1, this.validationStatus));
            children.add(new Property("validationDate", "dateTime", "When the target was validated against the primary source.", 0, 1, this.validationDate));
            children.add(new Property("canPushUpdates", "CodeableConcept", "Ability of the primary source to push updates/alerts (yes; no; undetermined).", 0, 1, this.canPushUpdates));
            children.add(new Property("pushTypeAvailable", "CodeableConcept", "Type of alerts/updates the primary source can send (specific requested changes; any changes; as defined by source).", 0, Integer.MAX_VALUE, this.pushTypeAvailable));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 117694: {
                    return new Property("who", "Reference(Organization|Practitioner|PractitionerRole)", "Reference to the primary source.", 0, 1, this.who);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of primary source (License Board; Primary Education; Continuing Education; Postal Service; Relationship owner; Registration Authority; legal source; issuing source; authoritative source).", 0, Integer.MAX_VALUE, this.type);
                }
                case 1314116695: {
                    return new Property("communicationMethod", "CodeableConcept", "Method for communicating with the primary source (manual; API; Push).", 0, Integer.MAX_VALUE, this.communicationMethod);
                }
                case 1775633867: {
                    return new Property("validationStatus", "CodeableConcept", "Status of the validation of the target against the primary source (successful; failed; unknown).", 0, 1, this.validationStatus);
                }
                case -280180793: {
                    return new Property("validationDate", "dateTime", "When the target was validated against the primary source.", 0, 1, this.validationDate);
                }
                case 1463787104: {
                    return new Property("canPushUpdates", "CodeableConcept", "Ability of the primary source to push updates/alerts (yes; no; undetermined).", 0, 1, this.canPushUpdates);
                }
                case 945223605: {
                    return new Property("pushTypeAvailable", "CodeableConcept", "Type of alerts/updates the primary source can send (specific requested changes; any changes; as defined by source).", 0, Integer.MAX_VALUE, this.pushTypeAvailable);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.who;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 1314116695: {
                    return this.communicationMethod == null ? new Base[]{} : this.communicationMethod.toArray(new Base[this.communicationMethod.size()]);
                }
                case 1775633867: {
                    Base[] baseArray;
                    if (this.validationStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.validationStatus;
                    }
                    return baseArray;
                }
                case -280180793: {
                    Base[] baseArray;
                    if (this.validationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.validationDate;
                    }
                    return baseArray;
                }
                case 1463787104: {
                    Base[] baseArray;
                    if (this.canPushUpdates == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.canPushUpdates;
                    }
                    return baseArray;
                }
                case 945223605: {
                    return this.pushTypeAvailable == null ? new Base[]{} : this.pushTypeAvailable.toArray(new Base[this.pushTypeAvailable.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 117694: {
                    this.who = this.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1314116695: {
                    this.getCommunicationMethod().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1775633867: {
                    this.validationStatus = this.castToCodeableConcept(value);
                    return value;
                }
                case -280180793: {
                    this.validationDate = this.castToDateTime(value);
                    return value;
                }
                case 1463787104: {
                    this.canPushUpdates = this.castToCodeableConcept(value);
                    return value;
                }
                case 945223605: {
                    this.getPushTypeAvailable().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("who")) {
                this.who = this.castToReference(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("communicationMethod")) {
                this.getCommunicationMethod().add(this.castToCodeableConcept(value));
            } else if (name.equals("validationStatus")) {
                this.validationStatus = this.castToCodeableConcept(value);
            } else if (name.equals("validationDate")) {
                this.validationDate = this.castToDateTime(value);
            } else if (name.equals("canPushUpdates")) {
                this.canPushUpdates = this.castToCodeableConcept(value);
            } else if (name.equals("pushTypeAvailable")) {
                this.getPushTypeAvailable().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 117694: {
                    return this.getWho();
                }
                case 3575610: {
                    return this.addType();
                }
                case 1314116695: {
                    return this.addCommunicationMethod();
                }
                case 1775633867: {
                    return this.getValidationStatus();
                }
                case -280180793: {
                    return this.getValidationDateElement();
                }
                case 1463787104: {
                    return this.getCanPushUpdates();
                }
                case 945223605: {
                    return this.addPushTypeAvailable();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 117694: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1314116695: {
                    return new String[]{"CodeableConcept"};
                }
                case 1775633867: {
                    return new String[]{"CodeableConcept"};
                }
                case -280180793: {
                    return new String[]{"dateTime"};
                }
                case 1463787104: {
                    return new String[]{"CodeableConcept"};
                }
                case 945223605: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("communicationMethod")) {
                return this.addCommunicationMethod();
            }
            if (name.equals("validationStatus")) {
                this.validationStatus = new CodeableConcept();
                return this.validationStatus;
            }
            if (name.equals("validationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type VerificationResult.validationDate");
            }
            if (name.equals("canPushUpdates")) {
                this.canPushUpdates = new CodeableConcept();
                return this.canPushUpdates;
            }
            if (name.equals("pushTypeAvailable")) {
                return this.addPushTypeAvailable();
            }
            return super.addChild(name);
        }

        @Override
        public VerificationResultPrimarySourceComponent copy() {
            VerificationResultPrimarySourceComponent dst = new VerificationResultPrimarySourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(VerificationResultPrimarySourceComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.who = this.who == null ? null : this.who.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            if (this.communicationMethod != null) {
                dst.communicationMethod = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.communicationMethod) {
                    dst.communicationMethod.add(i.copy());
                }
            }
            dst.validationStatus = this.validationStatus == null ? null : this.validationStatus.copy();
            dst.validationDate = this.validationDate == null ? null : this.validationDate.copy();
            CodeableConcept codeableConcept = dst.canPushUpdates = this.canPushUpdates == null ? null : this.canPushUpdates.copy();
            if (this.pushTypeAvailable != null) {
                dst.pushTypeAvailable = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.pushTypeAvailable) {
                    dst.pushTypeAvailable.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultPrimarySourceComponent)) {
                return false;
            }
            VerificationResultPrimarySourceComponent o = (VerificationResultPrimarySourceComponent)other_;
            return VerificationResultPrimarySourceComponent.compareDeep(this.who, o.who, true) && VerificationResultPrimarySourceComponent.compareDeep(this.type, o.type, true) && VerificationResultPrimarySourceComponent.compareDeep(this.communicationMethod, o.communicationMethod, true) && VerificationResultPrimarySourceComponent.compareDeep(this.validationStatus, o.validationStatus, true) && VerificationResultPrimarySourceComponent.compareDeep(this.validationDate, o.validationDate, true) && VerificationResultPrimarySourceComponent.compareDeep(this.canPushUpdates, o.canPushUpdates, true) && VerificationResultPrimarySourceComponent.compareDeep(this.pushTypeAvailable, o.pushTypeAvailable, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof VerificationResultPrimarySourceComponent)) {
                return false;
            }
            VerificationResultPrimarySourceComponent o = (VerificationResultPrimarySourceComponent)other_;
            return VerificationResultPrimarySourceComponent.compareValues(this.validationDate, o.validationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.who, this.type, this.communicationMethod, this.validationStatus, this.validationDate, this.canPushUpdates, this.pushTypeAvailable});
        }

        @Override
        public String fhirType() {
            return "VerificationResult.primarySource";
        }
    }

    public static class StatusEnumFactory
    implements EnumFactory<Status> {
        @Override
        public Status fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("attested".equals(codeString)) {
                return Status.ATTESTED;
            }
            if ("validated".equals(codeString)) {
                return Status.VALIDATED;
            }
            if ("in-process".equals(codeString)) {
                return Status.INPROCESS;
            }
            if ("req-revalid".equals(codeString)) {
                return Status.REQREVALID;
            }
            if ("val-fail".equals(codeString)) {
                return Status.VALFAIL;
            }
            if ("reval-fail".equals(codeString)) {
                return Status.REVALFAIL;
            }
            throw new IllegalArgumentException("Unknown Status code '" + codeString + "'");
        }

        public Enumeration<Status> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Status>(this, Status.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<Status>(this, Status.NULL, code);
            }
            if ("attested".equals(codeString)) {
                return new Enumeration<Status>(this, Status.ATTESTED, code);
            }
            if ("validated".equals(codeString)) {
                return new Enumeration<Status>(this, Status.VALIDATED, code);
            }
            if ("in-process".equals(codeString)) {
                return new Enumeration<Status>(this, Status.INPROCESS, code);
            }
            if ("req-revalid".equals(codeString)) {
                return new Enumeration<Status>(this, Status.REQREVALID, code);
            }
            if ("val-fail".equals(codeString)) {
                return new Enumeration<Status>(this, Status.VALFAIL, code);
            }
            if ("reval-fail".equals(codeString)) {
                return new Enumeration<Status>(this, Status.REVALFAIL, code);
            }
            throw new FHIRException("Unknown Status code '" + codeString + "'");
        }

        @Override
        public String toCode(Status code) {
            if (code == Status.ATTESTED) {
                return "attested";
            }
            if (code == Status.VALIDATED) {
                return "validated";
            }
            if (code == Status.INPROCESS) {
                return "in-process";
            }
            if (code == Status.REQREVALID) {
                return "req-revalid";
            }
            if (code == Status.VALFAIL) {
                return "val-fail";
            }
            if (code == Status.REVALFAIL) {
                return "reval-fail";
            }
            return "?";
        }

        @Override
        public String toSystem(Status code) {
            return code.getSystem();
        }
    }

    public static enum Status {
        ATTESTED,
        VALIDATED,
        INPROCESS,
        REQREVALID,
        VALFAIL,
        REVALFAIL,
        NULL;


        public static Status fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("attested".equals(codeString)) {
                return ATTESTED;
            }
            if ("validated".equals(codeString)) {
                return VALIDATED;
            }
            if ("in-process".equals(codeString)) {
                return INPROCESS;
            }
            if ("req-revalid".equals(codeString)) {
                return REQREVALID;
            }
            if ("val-fail".equals(codeString)) {
                return VALFAIL;
            }
            if ("reval-fail".equals(codeString)) {
                return REVALFAIL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Status code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ATTESTED: {
                    return "attested";
                }
                case VALIDATED: {
                    return "validated";
                }
                case INPROCESS: {
                    return "in-process";
                }
                case REQREVALID: {
                    return "req-revalid";
                }
                case VALFAIL: {
                    return "val-fail";
                }
                case REVALFAIL: {
                    return "reval-fail";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ATTESTED: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case VALIDATED: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case INPROCESS: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case REQREVALID: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case VALFAIL: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case REVALFAIL: {
                    return "http://hl7.org/fhir/CodeSystem/status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ATTESTED: {
                    return "***TODO***";
                }
                case VALIDATED: {
                    return "***TODO***";
                }
                case INPROCESS: {
                    return "***TODO***";
                }
                case REQREVALID: {
                    return "***TODO***";
                }
                case VALFAIL: {
                    return "***TODO***";
                }
                case REVALFAIL: {
                    return "***TODO***";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ATTESTED: {
                    return "Attested";
                }
                case VALIDATED: {
                    return "Validated";
                }
                case INPROCESS: {
                    return "In process";
                }
                case REQREVALID: {
                    return "Requires revalidation";
                }
                case VALFAIL: {
                    return "Validation failed";
                }
                case REVALFAIL: {
                    return "Re-Validation failed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

