/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.SpecimenDefinition;

@ResourceDef(name="CatalogEntry", profile="http://hl7.org/fhir/StructureDefinition/CatalogEntry")
public class CatalogEntry
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier of the catalog item", formalDefinition="Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The type of item - medication, device, service, protocol or other", formalDefinition="The type of item - medication, device, service, protocol or other.")
    protected CodeableConcept type;
    @Child(name="orderable", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the entry represents an orderable item", formalDefinition="Whether the entry represents an orderable item.")
    protected BooleanType orderable;
    @Child(name="referencedItem", type={Medication.class, Device.class, Organization.class, Practitioner.class, PractitionerRole.class, HealthcareService.class, ActivityDefinition.class, PlanDefinition.class, SpecimenDefinition.class, ObservationDefinition.class, Binary.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The item that is being defined", formalDefinition="The item in a catalog or definition.")
    protected Reference referencedItem;
    protected Resource referencedItemTarget;
    @Child(name="additionalIdentifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any additional identifier(s) for the catalog item, in the same granularity or concept", formalDefinition="Used in supporting related concepts, e.g. NDC to RxNorm.")
    protected List<Identifier> additionalIdentifier;
    @Child(name="classification", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Classification (category or class) of the item entry", formalDefinition="Classes of devices, or ATC for medication.")
    protected List<CodeableConcept> classification;
    @Child(name="status", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="validityPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The time period in which this catalog entry is expected to be active", formalDefinition="The time period in which this catalog entry is expected to be active.")
    protected Period validityPeriod;
    @Child(name="validTo", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The date until which this catalog entry is expected to be active", formalDefinition="The date until which this catalog entry is expected to be active.")
    protected DateTimeType validTo;
    @Child(name="lastUpdated", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When was this catalog last updated", formalDefinition="Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.")
    protected DateTimeType lastUpdated;
    @Child(name="additionalCharacteristic", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional characteristics of the catalog entry", formalDefinition="Used for examplefor Out of Formulary, or any specifics.")
    protected List<CodeableConcept> additionalCharacteristic;
    @Child(name="additionalClassification", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional classification of the catalog entry", formalDefinition="User for example for ATC classification, or.")
    protected List<CodeableConcept> additionalClassification;
    @Child(name="relatedEntry", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An item that this catalog entry is related to", formalDefinition="Used for example, to point to a substance, or to a device used to administer a medication.")
    protected List<CatalogEntryRelatedEntryComponent> relatedEntry;
    private static final long serialVersionUID = 57448275L;

    public CatalogEntry() {
    }

    public CatalogEntry(BooleanType orderable, Reference referencedItem) {
        this.orderable = orderable;
        this.referencedItem = referencedItem;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CatalogEntry setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CatalogEntry addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public CatalogEntry setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public BooleanType getOrderableElement() {
        if (this.orderable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.orderable");
            }
            if (Configuration.doAutoCreate()) {
                this.orderable = new BooleanType();
            }
        }
        return this.orderable;
    }

    public boolean hasOrderableElement() {
        return this.orderable != null && !this.orderable.isEmpty();
    }

    public boolean hasOrderable() {
        return this.orderable != null && !this.orderable.isEmpty();
    }

    public CatalogEntry setOrderableElement(BooleanType value) {
        this.orderable = value;
        return this;
    }

    public boolean getOrderable() {
        return this.orderable == null || this.orderable.isEmpty() ? false : (Boolean)this.orderable.getValue();
    }

    public CatalogEntry setOrderable(boolean value) {
        if (this.orderable == null) {
            this.orderable = new BooleanType();
        }
        this.orderable.setValue((Object)value);
        return this;
    }

    public Reference getReferencedItem() {
        if (this.referencedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.referencedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.referencedItem = new Reference();
            }
        }
        return this.referencedItem;
    }

    public boolean hasReferencedItem() {
        return this.referencedItem != null && !this.referencedItem.isEmpty();
    }

    public CatalogEntry setReferencedItem(Reference value) {
        this.referencedItem = value;
        return this;
    }

    public Resource getReferencedItemTarget() {
        return this.referencedItemTarget;
    }

    public CatalogEntry setReferencedItemTarget(Resource value) {
        this.referencedItemTarget = value;
        return this;
    }

    public List<Identifier> getAdditionalIdentifier() {
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        return this.additionalIdentifier;
    }

    public CatalogEntry setAdditionalIdentifier(List<Identifier> theAdditionalIdentifier) {
        this.additionalIdentifier = theAdditionalIdentifier;
        return this;
    }

    public boolean hasAdditionalIdentifier() {
        if (this.additionalIdentifier == null) {
            return false;
        }
        for (Identifier item : this.additionalIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addAdditionalIdentifier() {
        Identifier t = new Identifier();
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        this.additionalIdentifier.add(t);
        return t;
    }

    public CatalogEntry addAdditionalIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        this.additionalIdentifier.add(t);
        return this;
    }

    public Identifier getAdditionalIdentifierFirstRep() {
        if (this.getAdditionalIdentifier().isEmpty()) {
            this.addAdditionalIdentifier();
        }
        return this.getAdditionalIdentifier().get(0);
    }

    public List<CodeableConcept> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        return this.classification;
    }

    public CatalogEntry setClassification(List<CodeableConcept> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CodeableConcept item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return t;
    }

    public CatalogEntry addClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return this;
    }

    public CodeableConcept getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CatalogEntry setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public CatalogEntry setStatus(Enumerations.PublicationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Period getValidityPeriod() {
        if (this.validityPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.validityPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.validityPeriod = new Period();
            }
        }
        return this.validityPeriod;
    }

    public boolean hasValidityPeriod() {
        return this.validityPeriod != null && !this.validityPeriod.isEmpty();
    }

    public CatalogEntry setValidityPeriod(Period value) {
        this.validityPeriod = value;
        return this;
    }

    public DateTimeType getValidToElement() {
        if (this.validTo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.validTo");
            }
            if (Configuration.doAutoCreate()) {
                this.validTo = new DateTimeType();
            }
        }
        return this.validTo;
    }

    public boolean hasValidToElement() {
        return this.validTo != null && !this.validTo.isEmpty();
    }

    public boolean hasValidTo() {
        return this.validTo != null && !this.validTo.isEmpty();
    }

    public CatalogEntry setValidToElement(DateTimeType value) {
        this.validTo = value;
        return this;
    }

    public Date getValidTo() {
        return this.validTo == null ? null : (Date)this.validTo.getValue();
    }

    public CatalogEntry setValidTo(Date value) {
        if (value == null) {
            this.validTo = null;
        } else {
            if (this.validTo == null) {
                this.validTo = new DateTimeType();
            }
            this.validTo.setValue(value);
        }
        return this;
    }

    public DateTimeType getLastUpdatedElement() {
        if (this.lastUpdated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CatalogEntry.lastUpdated");
            }
            if (Configuration.doAutoCreate()) {
                this.lastUpdated = new DateTimeType();
            }
        }
        return this.lastUpdated;
    }

    public boolean hasLastUpdatedElement() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public CatalogEntry setLastUpdatedElement(DateTimeType value) {
        this.lastUpdated = value;
        return this;
    }

    public Date getLastUpdated() {
        return this.lastUpdated == null ? null : (Date)this.lastUpdated.getValue();
    }

    public CatalogEntry setLastUpdated(Date value) {
        if (value == null) {
            this.lastUpdated = null;
        } else {
            if (this.lastUpdated == null) {
                this.lastUpdated = new DateTimeType();
            }
            this.lastUpdated.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getAdditionalCharacteristic() {
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        return this.additionalCharacteristic;
    }

    public CatalogEntry setAdditionalCharacteristic(List<CodeableConcept> theAdditionalCharacteristic) {
        this.additionalCharacteristic = theAdditionalCharacteristic;
        return this;
    }

    public boolean hasAdditionalCharacteristic() {
        if (this.additionalCharacteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        this.additionalCharacteristic.add(t);
        return t;
    }

    public CatalogEntry addAdditionalCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        this.additionalCharacteristic.add(t);
        return this;
    }

    public CodeableConcept getAdditionalCharacteristicFirstRep() {
        if (this.getAdditionalCharacteristic().isEmpty()) {
            this.addAdditionalCharacteristic();
        }
        return this.getAdditionalCharacteristic().get(0);
    }

    public List<CodeableConcept> getAdditionalClassification() {
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        return this.additionalClassification;
    }

    public CatalogEntry setAdditionalClassification(List<CodeableConcept> theAdditionalClassification) {
        this.additionalClassification = theAdditionalClassification;
        return this;
    }

    public boolean hasAdditionalClassification() {
        if (this.additionalClassification == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        this.additionalClassification.add(t);
        return t;
    }

    public CatalogEntry addAdditionalClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        this.additionalClassification.add(t);
        return this;
    }

    public CodeableConcept getAdditionalClassificationFirstRep() {
        if (this.getAdditionalClassification().isEmpty()) {
            this.addAdditionalClassification();
        }
        return this.getAdditionalClassification().get(0);
    }

    public List<CatalogEntryRelatedEntryComponent> getRelatedEntry() {
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        return this.relatedEntry;
    }

    public CatalogEntry setRelatedEntry(List<CatalogEntryRelatedEntryComponent> theRelatedEntry) {
        this.relatedEntry = theRelatedEntry;
        return this;
    }

    public boolean hasRelatedEntry() {
        if (this.relatedEntry == null) {
            return false;
        }
        for (CatalogEntryRelatedEntryComponent item : this.relatedEntry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CatalogEntryRelatedEntryComponent addRelatedEntry() {
        CatalogEntryRelatedEntryComponent t = new CatalogEntryRelatedEntryComponent();
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return t;
    }

    public CatalogEntry addRelatedEntry(CatalogEntryRelatedEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return this;
    }

    public CatalogEntryRelatedEntryComponent getRelatedEntryFirstRep() {
        if (this.getRelatedEntry().isEmpty()) {
            this.addRelatedEntry();
        }
        return this.getRelatedEntry().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("type", "CodeableConcept", "The type of item - medication, device, service, protocol or other.", 0, 1, this.type));
        children.add(new Property("orderable", "boolean", "Whether the entry represents an orderable item.", 0, 1, this.orderable));
        children.add(new Property("referencedItem", "Reference(Medication|Device|Organization|Practitioner|PractitionerRole|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|Binary)", "The item in a catalog or definition.", 0, 1, this.referencedItem));
        children.add(new Property("additionalIdentifier", "Identifier", "Used in supporting related concepts, e.g. NDC to RxNorm.", 0, Integer.MAX_VALUE, this.additionalIdentifier));
        children.add(new Property("classification", "CodeableConcept", "Classes of devices, or ATC for medication.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("status", "code", "Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.", 0, 1, this.status));
        children.add(new Property("validityPeriod", "Period", "The time period in which this catalog entry is expected to be active.", 0, 1, this.validityPeriod));
        children.add(new Property("validTo", "dateTime", "The date until which this catalog entry is expected to be active.", 0, 1, this.validTo));
        children.add(new Property("lastUpdated", "dateTime", "Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.", 0, 1, this.lastUpdated));
        children.add(new Property("additionalCharacteristic", "CodeableConcept", "Used for examplefor Out of Formulary, or any specifics.", 0, Integer.MAX_VALUE, this.additionalCharacteristic));
        children.add(new Property("additionalClassification", "CodeableConcept", "User for example for ATC classification, or.", 0, Integer.MAX_VALUE, this.additionalClassification));
        children.add(new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of item - medication, device, service, protocol or other.", 0, 1, this.type);
            }
            case -391199320: {
                return new Property("orderable", "boolean", "Whether the entry represents an orderable item.", 0, 1, this.orderable);
            }
            case -1896630996: {
                return new Property("referencedItem", "Reference(Medication|Device|Organization|Practitioner|PractitionerRole|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|Binary)", "The item in a catalog or definition.", 0, 1, this.referencedItem);
            }
            case 1195162672: {
                return new Property("additionalIdentifier", "Identifier", "Used in supporting related concepts, e.g. NDC to RxNorm.", 0, Integer.MAX_VALUE, this.additionalIdentifier);
            }
            case 382350310: {
                return new Property("classification", "CodeableConcept", "Classes of devices, or ATC for medication.", 0, Integer.MAX_VALUE, this.classification);
            }
            case -892481550: {
                return new Property("status", "code", "Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.", 0, 1, this.status);
            }
            case -1434195053: {
                return new Property("validityPeriod", "Period", "The time period in which this catalog entry is expected to be active.", 0, 1, this.validityPeriod);
            }
            case 231246743: {
                return new Property("validTo", "dateTime", "The date until which this catalog entry is expected to be active.", 0, 1, this.validTo);
            }
            case 1649733957: {
                return new Property("lastUpdated", "dateTime", "Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.", 0, 1, this.lastUpdated);
            }
            case -1638369886: {
                return new Property("additionalCharacteristic", "CodeableConcept", "Used for examplefor Out of Formulary, or any specifics.", 0, Integer.MAX_VALUE, this.additionalCharacteristic);
            }
            case -1622333459: {
                return new Property("additionalClassification", "CodeableConcept", "User for example for ATC classification, or.", 0, Integer.MAX_VALUE, this.additionalClassification);
            }
            case 130178823: {
                return new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -391199320: {
                Base[] baseArray;
                if (this.orderable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.orderable;
                }
                return baseArray;
            }
            case -1896630996: {
                Base[] baseArray;
                if (this.referencedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.referencedItem;
                }
                return baseArray;
            }
            case 1195162672: {
                return this.additionalIdentifier == null ? new Base[]{} : this.additionalIdentifier.toArray(new Base[this.additionalIdentifier.size()]);
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -1434195053: {
                Base[] baseArray;
                if (this.validityPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.validityPeriod;
                }
                return baseArray;
            }
            case 231246743: {
                Base[] baseArray;
                if (this.validTo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.validTo;
                }
                return baseArray;
            }
            case 1649733957: {
                Base[] baseArray;
                if (this.lastUpdated == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.lastUpdated;
                }
                return baseArray;
            }
            case -1638369886: {
                return this.additionalCharacteristic == null ? new Base[]{} : this.additionalCharacteristic.toArray(new Base[this.additionalCharacteristic.size()]);
            }
            case -1622333459: {
                return this.additionalClassification == null ? new Base[]{} : this.additionalClassification.toArray(new Base[this.additionalClassification.size()]);
            }
            case 130178823: {
                return this.relatedEntry == null ? new Base[]{} : this.relatedEntry.toArray(new Base[this.relatedEntry.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -391199320: {
                this.orderable = this.castToBoolean(value);
                return value;
            }
            case -1896630996: {
                this.referencedItem = this.castToReference(value);
                return value;
            }
            case 1195162672: {
                this.getAdditionalIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 382350310: {
                this.getClassification().add(this.castToCodeableConcept(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1434195053: {
                this.validityPeriod = this.castToPeriod(value);
                return value;
            }
            case 231246743: {
                this.validTo = this.castToDateTime(value);
                return value;
            }
            case 1649733957: {
                this.lastUpdated = this.castToDateTime(value);
                return value;
            }
            case -1638369886: {
                this.getAdditionalCharacteristic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1622333459: {
                this.getAdditionalClassification().add(this.castToCodeableConcept(value));
                return value;
            }
            case 130178823: {
                this.getRelatedEntry().add((CatalogEntryRelatedEntryComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("orderable")) {
            this.orderable = this.castToBoolean(value);
        } else if (name.equals("referencedItem")) {
            this.referencedItem = this.castToReference(value);
        } else if (name.equals("additionalIdentifier")) {
            this.getAdditionalIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("classification")) {
            this.getClassification().add(this.castToCodeableConcept(value));
        } else if (name.equals("status")) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("validityPeriod")) {
            this.validityPeriod = this.castToPeriod(value);
        } else if (name.equals("validTo")) {
            this.validTo = this.castToDateTime(value);
        } else if (name.equals("lastUpdated")) {
            this.lastUpdated = this.castToDateTime(value);
        } else if (name.equals("additionalCharacteristic")) {
            this.getAdditionalCharacteristic().add(this.castToCodeableConcept(value));
        } else if (name.equals("additionalClassification")) {
            this.getAdditionalClassification().add(this.castToCodeableConcept(value));
        } else if (name.equals("relatedEntry")) {
            this.getRelatedEntry().add((CatalogEntryRelatedEntryComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -391199320: {
                return this.getOrderableElement();
            }
            case -1896630996: {
                return this.getReferencedItem();
            }
            case 1195162672: {
                return this.addAdditionalIdentifier();
            }
            case 382350310: {
                return this.addClassification();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1434195053: {
                return this.getValidityPeriod();
            }
            case 231246743: {
                return this.getValidToElement();
            }
            case 1649733957: {
                return this.getLastUpdatedElement();
            }
            case -1638369886: {
                return this.addAdditionalCharacteristic();
            }
            case -1622333459: {
                return this.addAdditionalClassification();
            }
            case 130178823: {
                return this.addRelatedEntry();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -391199320: {
                return new String[]{"boolean"};
            }
            case -1896630996: {
                return new String[]{"Reference"};
            }
            case 1195162672: {
                return new String[]{"Identifier"};
            }
            case 382350310: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1434195053: {
                return new String[]{"Period"};
            }
            case 231246743: {
                return new String[]{"dateTime"};
            }
            case 1649733957: {
                return new String[]{"dateTime"};
            }
            case -1638369886: {
                return new String[]{"CodeableConcept"};
            }
            case -1622333459: {
                return new String[]{"CodeableConcept"};
            }
            case 130178823: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("orderable")) {
            throw new FHIRException("Cannot call addChild on a singleton property CatalogEntry.orderable");
        }
        if (name.equals("referencedItem")) {
            this.referencedItem = new Reference();
            return this.referencedItem;
        }
        if (name.equals("additionalIdentifier")) {
            return this.addAdditionalIdentifier();
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property CatalogEntry.status");
        }
        if (name.equals("validityPeriod")) {
            this.validityPeriod = new Period();
            return this.validityPeriod;
        }
        if (name.equals("validTo")) {
            throw new FHIRException("Cannot call addChild on a singleton property CatalogEntry.validTo");
        }
        if (name.equals("lastUpdated")) {
            throw new FHIRException("Cannot call addChild on a singleton property CatalogEntry.lastUpdated");
        }
        if (name.equals("additionalCharacteristic")) {
            return this.addAdditionalCharacteristic();
        }
        if (name.equals("additionalClassification")) {
            return this.addAdditionalClassification();
        }
        if (name.equals("relatedEntry")) {
            return this.addRelatedEntry();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CatalogEntry";
    }

    @Override
    public CatalogEntry copy() {
        CatalogEntry dst = new CatalogEntry();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CatalogEntry dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.orderable = this.orderable == null ? null : this.orderable.copy();
        Reference reference = dst.referencedItem = this.referencedItem == null ? null : this.referencedItem.copy();
        if (this.additionalIdentifier != null) {
            dst.additionalIdentifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.additionalIdentifier) {
                dst.additionalIdentifier.add(identifier.copy());
            }
        }
        if (this.classification != null) {
            dst.classification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.classification) {
                dst.classification.add(codeableConcept.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
        dst.validTo = this.validTo == null ? null : this.validTo.copy();
        DateTimeType dateTimeType = dst.lastUpdated = this.lastUpdated == null ? null : this.lastUpdated.copy();
        if (this.additionalCharacteristic != null) {
            dst.additionalCharacteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.additionalCharacteristic) {
                dst.additionalCharacteristic.add(codeableConcept.copy());
            }
        }
        if (this.additionalClassification != null) {
            dst.additionalClassification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.additionalClassification) {
                dst.additionalClassification.add(codeableConcept.copy());
            }
        }
        if (this.relatedEntry != null) {
            dst.relatedEntry = new ArrayList<CatalogEntryRelatedEntryComponent>();
            for (CatalogEntryRelatedEntryComponent catalogEntryRelatedEntryComponent : this.relatedEntry) {
                dst.relatedEntry.add(catalogEntryRelatedEntryComponent.copy());
            }
        }
    }

    protected CatalogEntry typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CatalogEntry)) {
            return false;
        }
        CatalogEntry o = (CatalogEntry)other_;
        return CatalogEntry.compareDeep(this.identifier, o.identifier, true) && CatalogEntry.compareDeep(this.type, o.type, true) && CatalogEntry.compareDeep(this.orderable, o.orderable, true) && CatalogEntry.compareDeep(this.referencedItem, o.referencedItem, true) && CatalogEntry.compareDeep(this.additionalIdentifier, o.additionalIdentifier, true) && CatalogEntry.compareDeep(this.classification, o.classification, true) && CatalogEntry.compareDeep(this.status, o.status, true) && CatalogEntry.compareDeep(this.validityPeriod, o.validityPeriod, true) && CatalogEntry.compareDeep(this.validTo, o.validTo, true) && CatalogEntry.compareDeep(this.lastUpdated, o.lastUpdated, true) && CatalogEntry.compareDeep(this.additionalCharacteristic, o.additionalCharacteristic, true) && CatalogEntry.compareDeep(this.additionalClassification, o.additionalClassification, true) && CatalogEntry.compareDeep(this.relatedEntry, o.relatedEntry, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CatalogEntry)) {
            return false;
        }
        CatalogEntry o = (CatalogEntry)other_;
        return CatalogEntry.compareValues(this.orderable, o.orderable, true) && CatalogEntry.compareValues(this.status, o.status, true) && CatalogEntry.compareValues(this.validTo, o.validTo, true) && CatalogEntry.compareValues(this.lastUpdated, o.lastUpdated, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.orderable, this.referencedItem, this.additionalIdentifier, this.classification, this.status, this.validityPeriod, this.validTo, this.lastUpdated, this.additionalCharacteristic, this.additionalClassification, this.relatedEntry});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CatalogEntry;
    }

    @Block
    public static class CatalogEntryRelatedEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationtype", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="triggers | is-replaced-by", formalDefinition="The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/relation-type")
        protected Enumeration<CatalogEntryRelationType> relationtype;
        @Child(name="item", type={CatalogEntry.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The reference to the related item", formalDefinition="The reference to the related item.")
        protected Reference item;
        protected CatalogEntry itemTarget;
        private static final long serialVersionUID = -1367020813L;

        public CatalogEntryRelatedEntryComponent() {
        }

        public CatalogEntryRelatedEntryComponent(Enumeration<CatalogEntryRelationType> relationtype, Reference item) {
            this.relationtype = relationtype;
            this.item = item;
        }

        public Enumeration<CatalogEntryRelationType> getRelationtypeElement() {
            if (this.relationtype == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CatalogEntryRelatedEntryComponent.relationtype");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationtype = new Enumeration<CatalogEntryRelationType>(new CatalogEntryRelationTypeEnumFactory());
                }
            }
            return this.relationtype;
        }

        public boolean hasRelationtypeElement() {
            return this.relationtype != null && !this.relationtype.isEmpty();
        }

        public boolean hasRelationtype() {
            return this.relationtype != null && !this.relationtype.isEmpty();
        }

        public CatalogEntryRelatedEntryComponent setRelationtypeElement(Enumeration<CatalogEntryRelationType> value) {
            this.relationtype = value;
            return this;
        }

        public CatalogEntryRelationType getRelationtype() {
            return this.relationtype == null ? null : (CatalogEntryRelationType)((Object)this.relationtype.getValue());
        }

        public CatalogEntryRelatedEntryComponent setRelationtype(CatalogEntryRelationType value) {
            if (this.relationtype == null) {
                this.relationtype = new Enumeration<CatalogEntryRelationType>(new CatalogEntryRelationTypeEnumFactory());
            }
            this.relationtype.setValue((Object)value);
            return this;
        }

        public Reference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CatalogEntryRelatedEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new Reference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public CatalogEntryRelatedEntryComponent setItem(Reference value) {
            this.item = value;
            return this;
        }

        public CatalogEntry getItemTarget() {
            if (this.itemTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CatalogEntryRelatedEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemTarget = new CatalogEntry();
                }
            }
            return this.itemTarget;
        }

        public CatalogEntryRelatedEntryComponent setItemTarget(CatalogEntry value) {
            this.itemTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationtype", "code", "The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.", 0, 1, this.relationtype));
            children.add(new Property("item", "Reference(CatalogEntry)", "The reference to the related item.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -261805258: {
                    return new Property("relationtype", "code", "The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.", 0, 1, this.relationtype);
                }
                case 3242771: {
                    return new Property("item", "Reference(CatalogEntry)", "The reference to the related item.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    Base[] baseArray;
                    if (this.relationtype == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationtype;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    value = new CatalogEntryRelationTypeEnumFactory().fromType(this.castToCode(value));
                    this.relationtype = value;
                    return value;
                }
                case 3242771: {
                    this.item = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationtype")) {
                value = new CatalogEntryRelationTypeEnumFactory().fromType(this.castToCode(value));
                this.relationtype = value;
            } else if (name.equals("item")) {
                this.item = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    return this.getRelationtypeElement();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    return new String[]{"code"};
                }
                case 3242771: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationtype")) {
                throw new FHIRException("Cannot call addChild on a singleton property CatalogEntry.relationtype");
            }
            if (name.equals("item")) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public CatalogEntryRelatedEntryComponent copy() {
            CatalogEntryRelatedEntryComponent dst = new CatalogEntryRelatedEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CatalogEntryRelatedEntryComponent dst) {
            super.copyValues(dst);
            dst.relationtype = this.relationtype == null ? null : this.relationtype.copy();
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CatalogEntryRelatedEntryComponent)) {
                return false;
            }
            CatalogEntryRelatedEntryComponent o = (CatalogEntryRelatedEntryComponent)other_;
            return CatalogEntryRelatedEntryComponent.compareDeep(this.relationtype, o.relationtype, true) && CatalogEntryRelatedEntryComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CatalogEntryRelatedEntryComponent)) {
                return false;
            }
            CatalogEntryRelatedEntryComponent o = (CatalogEntryRelatedEntryComponent)other_;
            return CatalogEntryRelatedEntryComponent.compareValues(this.relationtype, o.relationtype, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relationtype, this.item});
        }

        @Override
        public String fhirType() {
            return "CatalogEntry.relatedEntry";
        }
    }

    public static class CatalogEntryRelationTypeEnumFactory
    implements EnumFactory<CatalogEntryRelationType> {
        @Override
        public CatalogEntryRelationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("triggers".equals(codeString)) {
                return CatalogEntryRelationType.TRIGGERS;
            }
            if ("is-replaced-by".equals(codeString)) {
                return CatalogEntryRelationType.ISREPLACEDBY;
            }
            throw new IllegalArgumentException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        public Enumeration<CatalogEntryRelationType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.NULL, code);
            }
            if ("triggers".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.TRIGGERS, code);
            }
            if ("is-replaced-by".equals(codeString)) {
                return new Enumeration<CatalogEntryRelationType>(this, CatalogEntryRelationType.ISREPLACEDBY, code);
            }
            throw new FHIRException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        @Override
        public String toCode(CatalogEntryRelationType code) {
            if (code == CatalogEntryRelationType.TRIGGERS) {
                return "triggers";
            }
            if (code == CatalogEntryRelationType.ISREPLACEDBY) {
                return "is-replaced-by";
            }
            return "?";
        }

        @Override
        public String toSystem(CatalogEntryRelationType code) {
            return code.getSystem();
        }
    }

    public static enum CatalogEntryRelationType {
        TRIGGERS,
        ISREPLACEDBY,
        NULL;


        public static CatalogEntryRelationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("triggers".equals(codeString)) {
                return TRIGGERS;
            }
            if ("is-replaced-by".equals(codeString)) {
                return ISREPLACEDBY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CatalogEntryRelationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TRIGGERS: {
                    return "triggers";
                }
                case ISREPLACEDBY: {
                    return "is-replaced-by";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TRIGGERS: {
                    return "http://hl7.org/fhir/relation-type";
                }
                case ISREPLACEDBY: {
                    return "http://hl7.org/fhir/relation-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TRIGGERS: {
                    return "the related entry represents an activity that may be triggered by the current item.";
                }
                case ISREPLACEDBY: {
                    return "the related entry represents an item that replaces the current retired item.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TRIGGERS: {
                    return "Triggers";
                }
                case ISREPLACEDBY: {
                    return "Replaced By";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

