/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EvidenceVariable;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.RiskEvidenceSynthesis;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EffectEvidenceSynthesis", profile="http://hl7.org/fhir/StructureDefinition/EffectEvidenceSynthesis")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "date", "publisher", "contact", "description", "note", "useContext", "jurisdiction", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact", "synthesisType", "studyType", "population", "exposure", "exposureAlternative", "outcome", "sampleSize", "resultsByExposure", "effectEstimate", "certainty"})
public class EffectEvidenceSynthesis
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the effect evidence synthesis", formalDefinition="A formal identifier that is used to identify this effect evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="note", type={Annotation.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
    protected List<Annotation> note;
    @Child(name="copyright", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the effect evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the effect evidence synthesis.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the effect evidence synthesis was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the effect evidence synthesis was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the effect evidence synthesis is expected to be used", formalDefinition="The period during which the effect evidence synthesis content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the EffectEvidenceSynthesis, such as Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the EffectEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="synthesisType", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of synthesis", formalDefinition="Type of synthesis eg meta-analysis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/synthesis-type")
    protected CodeableConcept synthesisType;
    @Child(name="studyType", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of study", formalDefinition="Type of study eg randomized trial.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/study-type")
    protected CodeableConcept studyType;
    @Child(name="population", type={EvidenceVariable.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What population?", formalDefinition="A reference to a EvidenceVariable resource that defines the population for the research.")
    protected Reference population;
    protected EvidenceVariable populationTarget;
    @Child(name="exposure", type={EvidenceVariable.class}, order=15, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What exposure?", formalDefinition="A reference to a EvidenceVariable resource that defines the exposure for the research.")
    protected Reference exposure;
    protected EvidenceVariable exposureTarget;
    @Child(name="exposureAlternative", type={EvidenceVariable.class}, order=16, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What comparison exposure?", formalDefinition="A reference to a EvidenceVariable resource that defines the comparison exposure for the research.")
    protected Reference exposureAlternative;
    protected EvidenceVariable exposureAlternativeTarget;
    @Child(name="outcome", type={EvidenceVariable.class}, order=17, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What outcome?", formalDefinition="A reference to a EvidenceVariable resomece that defines the outcome for the research.")
    protected Reference outcome;
    protected EvidenceVariable outcomeTarget;
    @Child(name="sampleSize", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What sample size was involved?", formalDefinition="A description of the size of the sample involved in the synthesis.")
    protected EffectEvidenceSynthesisSampleSizeComponent sampleSize;
    @Child(name="resultsByExposure", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was the result per exposure?", formalDefinition="A description of the results for each exposure considered in the effect estimate.")
    protected List<EffectEvidenceSynthesisResultsByExposureComponent> resultsByExposure;
    @Child(name="effectEstimate", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What was the estimated effect", formalDefinition="The estimated effect of the exposure variant.")
    protected List<EffectEvidenceSynthesisEffectEstimateComponent> effectEstimate;
    @Child(name="certainty", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="How certain is the effect", formalDefinition="A description of the certainty of the effect estimate.")
    protected List<EffectEvidenceSynthesisCertaintyComponent> certainty;
    private static final long serialVersionUID = 23150467L;
    @SearchParamDefinition(name="date", path="EffectEvidenceSynthesis.date", description="The effect evidence synthesis publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="EffectEvidenceSynthesis.identifier", description="External identifier for the effect evidence synthesis", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="context-type-value", path="EffectEvidenceSynthesis.useContext", description="A use context type and value assigned to the effect evidence synthesis", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="EffectEvidenceSynthesis.jurisdiction", description="Intended jurisdiction for the effect evidence synthesis", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="EffectEvidenceSynthesis.description", description="The description of the effect evidence synthesis", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="EffectEvidenceSynthesis.useContext.code", description="A type of use context assigned to the effect evidence synthesis", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="EffectEvidenceSynthesis.title", description="The human-friendly name of the effect evidence synthesis", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="EffectEvidenceSynthesis.version", description="The business version of the effect evidence synthesis", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="EffectEvidenceSynthesis.url", description="The uri that identifies the effect evidence synthesis", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(EffectEvidenceSynthesis.useContext.value as Quantity) | (EffectEvidenceSynthesis.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the effect evidence synthesis", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="EffectEvidenceSynthesis.effectivePeriod", description="The time during which the effect evidence synthesis is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="name", path="EffectEvidenceSynthesis.name", description="Computationally friendly name of the effect evidence synthesis", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(EffectEvidenceSynthesis.useContext.value as CodeableConcept)", description="A use context assigned to the effect evidence synthesis", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="EffectEvidenceSynthesis.publisher", description="Name of the publisher of the effect evidence synthesis", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="EffectEvidenceSynthesis.useContext", description="A use context type and quantity- or range-based value assigned to the effect evidence synthesis", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="EffectEvidenceSynthesis.status", description="The current status of the effect evidence synthesis", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public EffectEvidenceSynthesis() {
    }

    public EffectEvidenceSynthesis(Enumeration<Enumerations.PublicationStatus> status, Reference population, Reference exposure, Reference exposureAlternative, Reference outcome) {
        this.status = status;
        this.population = population;
        this.exposure = exposure;
        this.exposureAlternative = exposureAlternative;
        this.outcome = outcome;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EffectEvidenceSynthesis setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public EffectEvidenceSynthesis setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public EffectEvidenceSynthesis setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public EffectEvidenceSynthesis addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public EffectEvidenceSynthesis setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public EffectEvidenceSynthesis setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public EffectEvidenceSynthesis setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public EffectEvidenceSynthesis setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public EffectEvidenceSynthesis addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public EffectEvidenceSynthesis setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public EffectEvidenceSynthesis addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public EffectEvidenceSynthesis setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public EffectEvidenceSynthesis setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public EffectEvidenceSynthesis setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public EffectEvidenceSynthesis setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public EffectEvidenceSynthesis setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public EffectEvidenceSynthesis setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public EffectEvidenceSynthesis setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public EffectEvidenceSynthesis setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public EffectEvidenceSynthesis setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public EffectEvidenceSynthesis setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public EffectEvidenceSynthesis setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public EffectEvidenceSynthesis setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public EffectEvidenceSynthesis setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public CodeableConcept getSynthesisType() {
        if (this.synthesisType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.synthesisType");
            }
            if (Configuration.doAutoCreate()) {
                this.synthesisType = new CodeableConcept();
            }
        }
        return this.synthesisType;
    }

    public boolean hasSynthesisType() {
        return this.synthesisType != null && !this.synthesisType.isEmpty();
    }

    public EffectEvidenceSynthesis setSynthesisType(CodeableConcept value) {
        this.synthesisType = value;
        return this;
    }

    public CodeableConcept getStudyType() {
        if (this.studyType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.studyType");
            }
            if (Configuration.doAutoCreate()) {
                this.studyType = new CodeableConcept();
            }
        }
        return this.studyType;
    }

    public boolean hasStudyType() {
        return this.studyType != null && !this.studyType.isEmpty();
    }

    public EffectEvidenceSynthesis setStudyType(CodeableConcept value) {
        this.studyType = value;
        return this;
    }

    public Reference getPopulation() {
        if (this.population == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.population");
            }
            if (Configuration.doAutoCreate()) {
                this.population = new Reference();
            }
        }
        return this.population;
    }

    public boolean hasPopulation() {
        return this.population != null && !this.population.isEmpty();
    }

    public EffectEvidenceSynthesis setPopulation(Reference value) {
        this.population = value;
        return this;
    }

    public EvidenceVariable getPopulationTarget() {
        if (this.populationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.population");
            }
            if (Configuration.doAutoCreate()) {
                this.populationTarget = new EvidenceVariable();
            }
        }
        return this.populationTarget;
    }

    public EffectEvidenceSynthesis setPopulationTarget(EvidenceVariable value) {
        this.populationTarget = value;
        return this;
    }

    public Reference getExposure() {
        if (this.exposure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.exposure");
            }
            if (Configuration.doAutoCreate()) {
                this.exposure = new Reference();
            }
        }
        return this.exposure;
    }

    public boolean hasExposure() {
        return this.exposure != null && !this.exposure.isEmpty();
    }

    public EffectEvidenceSynthesis setExposure(Reference value) {
        this.exposure = value;
        return this;
    }

    public EvidenceVariable getExposureTarget() {
        if (this.exposureTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.exposure");
            }
            if (Configuration.doAutoCreate()) {
                this.exposureTarget = new EvidenceVariable();
            }
        }
        return this.exposureTarget;
    }

    public EffectEvidenceSynthesis setExposureTarget(EvidenceVariable value) {
        this.exposureTarget = value;
        return this;
    }

    public Reference getExposureAlternative() {
        if (this.exposureAlternative == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.exposureAlternative");
            }
            if (Configuration.doAutoCreate()) {
                this.exposureAlternative = new Reference();
            }
        }
        return this.exposureAlternative;
    }

    public boolean hasExposureAlternative() {
        return this.exposureAlternative != null && !this.exposureAlternative.isEmpty();
    }

    public EffectEvidenceSynthesis setExposureAlternative(Reference value) {
        this.exposureAlternative = value;
        return this;
    }

    public EvidenceVariable getExposureAlternativeTarget() {
        if (this.exposureAlternativeTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.exposureAlternative");
            }
            if (Configuration.doAutoCreate()) {
                this.exposureAlternativeTarget = new EvidenceVariable();
            }
        }
        return this.exposureAlternativeTarget;
    }

    public EffectEvidenceSynthesis setExposureAlternativeTarget(EvidenceVariable value) {
        this.exposureAlternativeTarget = value;
        return this;
    }

    public Reference getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Reference();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public EffectEvidenceSynthesis setOutcome(Reference value) {
        this.outcome = value;
        return this;
    }

    public EvidenceVariable getOutcomeTarget() {
        if (this.outcomeTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcomeTarget = new EvidenceVariable();
            }
        }
        return this.outcomeTarget;
    }

    public EffectEvidenceSynthesis setOutcomeTarget(EvidenceVariable value) {
        this.outcomeTarget = value;
        return this;
    }

    public EffectEvidenceSynthesisSampleSizeComponent getSampleSize() {
        if (this.sampleSize == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EffectEvidenceSynthesis.sampleSize");
            }
            if (Configuration.doAutoCreate()) {
                this.sampleSize = new EffectEvidenceSynthesisSampleSizeComponent();
            }
        }
        return this.sampleSize;
    }

    public boolean hasSampleSize() {
        return this.sampleSize != null && !this.sampleSize.isEmpty();
    }

    public EffectEvidenceSynthesis setSampleSize(EffectEvidenceSynthesisSampleSizeComponent value) {
        this.sampleSize = value;
        return this;
    }

    public List<EffectEvidenceSynthesisResultsByExposureComponent> getResultsByExposure() {
        if (this.resultsByExposure == null) {
            this.resultsByExposure = new ArrayList<EffectEvidenceSynthesisResultsByExposureComponent>();
        }
        return this.resultsByExposure;
    }

    public EffectEvidenceSynthesis setResultsByExposure(List<EffectEvidenceSynthesisResultsByExposureComponent> theResultsByExposure) {
        this.resultsByExposure = theResultsByExposure;
        return this;
    }

    public boolean hasResultsByExposure() {
        if (this.resultsByExposure == null) {
            return false;
        }
        for (EffectEvidenceSynthesisResultsByExposureComponent item : this.resultsByExposure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EffectEvidenceSynthesisResultsByExposureComponent addResultsByExposure() {
        EffectEvidenceSynthesisResultsByExposureComponent t = new EffectEvidenceSynthesisResultsByExposureComponent();
        if (this.resultsByExposure == null) {
            this.resultsByExposure = new ArrayList<EffectEvidenceSynthesisResultsByExposureComponent>();
        }
        this.resultsByExposure.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addResultsByExposure(EffectEvidenceSynthesisResultsByExposureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.resultsByExposure == null) {
            this.resultsByExposure = new ArrayList<EffectEvidenceSynthesisResultsByExposureComponent>();
        }
        this.resultsByExposure.add(t);
        return this;
    }

    public EffectEvidenceSynthesisResultsByExposureComponent getResultsByExposureFirstRep() {
        if (this.getResultsByExposure().isEmpty()) {
            this.addResultsByExposure();
        }
        return this.getResultsByExposure().get(0);
    }

    public List<EffectEvidenceSynthesisEffectEstimateComponent> getEffectEstimate() {
        if (this.effectEstimate == null) {
            this.effectEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimateComponent>();
        }
        return this.effectEstimate;
    }

    public EffectEvidenceSynthesis setEffectEstimate(List<EffectEvidenceSynthesisEffectEstimateComponent> theEffectEstimate) {
        this.effectEstimate = theEffectEstimate;
        return this;
    }

    public boolean hasEffectEstimate() {
        if (this.effectEstimate == null) {
            return false;
        }
        for (EffectEvidenceSynthesisEffectEstimateComponent item : this.effectEstimate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EffectEvidenceSynthesisEffectEstimateComponent addEffectEstimate() {
        EffectEvidenceSynthesisEffectEstimateComponent t = new EffectEvidenceSynthesisEffectEstimateComponent();
        if (this.effectEstimate == null) {
            this.effectEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimateComponent>();
        }
        this.effectEstimate.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addEffectEstimate(EffectEvidenceSynthesisEffectEstimateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.effectEstimate == null) {
            this.effectEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimateComponent>();
        }
        this.effectEstimate.add(t);
        return this;
    }

    public EffectEvidenceSynthesisEffectEstimateComponent getEffectEstimateFirstRep() {
        if (this.getEffectEstimate().isEmpty()) {
            this.addEffectEstimate();
        }
        return this.getEffectEstimate().get(0);
    }

    public List<EffectEvidenceSynthesisCertaintyComponent> getCertainty() {
        if (this.certainty == null) {
            this.certainty = new ArrayList<EffectEvidenceSynthesisCertaintyComponent>();
        }
        return this.certainty;
    }

    public EffectEvidenceSynthesis setCertainty(List<EffectEvidenceSynthesisCertaintyComponent> theCertainty) {
        this.certainty = theCertainty;
        return this;
    }

    public boolean hasCertainty() {
        if (this.certainty == null) {
            return false;
        }
        for (EffectEvidenceSynthesisCertaintyComponent item : this.certainty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EffectEvidenceSynthesisCertaintyComponent addCertainty() {
        EffectEvidenceSynthesisCertaintyComponent t = new EffectEvidenceSynthesisCertaintyComponent();
        if (this.certainty == null) {
            this.certainty = new ArrayList<EffectEvidenceSynthesisCertaintyComponent>();
        }
        this.certainty.add(t);
        return t;
    }

    public EffectEvidenceSynthesis addCertainty(EffectEvidenceSynthesisCertaintyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.certainty == null) {
            this.certainty = new ArrayList<EffectEvidenceSynthesisCertaintyComponent>();
        }
        this.certainty.add(t);
        return this;
    }

    public EffectEvidenceSynthesisCertaintyComponent getCertaintyFirstRep() {
        if (this.getCertainty().isEmpty()) {
            this.addCertainty();
        }
        return this.getCertainty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this effect evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this effect evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the effect evidence synthesis is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this effect evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the effect evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the effect evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the effect evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the effect evidence synthesis.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this effect evidence synthesis. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the effect evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the effect evidence synthesis changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the effect evidence synthesis.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the effect evidence synthesis from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate effect evidence synthesis instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the effect evidence synthesis is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the effect evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the effect evidence synthesis.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the effect evidence synthesis content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("topic", "CodeableConcept", "Descriptive topics related to the content of the EffectEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("synthesisType", "CodeableConcept", "Type of synthesis eg meta-analysis.", 0, 1, this.synthesisType));
        children.add(new Property("studyType", "CodeableConcept", "Type of study eg randomized trial.", 0, 1, this.studyType));
        children.add(new Property("population", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1, this.population));
        children.add(new Property("exposure", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0, 1, this.exposure));
        children.add(new Property("exposureAlternative", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the comparison exposure for the research.", 0, 1, this.exposureAlternative));
        children.add(new Property("outcome", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0, 1, this.outcome));
        children.add(new Property("sampleSize", "", "A description of the size of the sample involved in the synthesis.", 0, 1, this.sampleSize));
        children.add(new Property("resultsByExposure", "", "A description of the results for each exposure considered in the effect estimate.", 0, Integer.MAX_VALUE, this.resultsByExposure));
        children.add(new Property("effectEstimate", "", "The estimated effect of the exposure variant.", 0, Integer.MAX_VALUE, this.effectEstimate));
        children.add(new Property("certainty", "", "A description of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.certainty));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this effect evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this effect evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the effect evidence synthesis is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this effect evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the effect evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the effect evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the effect evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the effect evidence synthesis.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this effect evidence synthesis. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the effect evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the effect evidence synthesis changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the effect evidence synthesis.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the effect evidence synthesis from a consumer's perspective.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate effect evidence synthesis instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the effect evidence synthesis is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the effect evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the effect evidence synthesis.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the effect evidence synthesis content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property("topic", "CodeableConcept", "Descriptive topics related to the content of the EffectEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 672726254: {
                return new Property("synthesisType", "CodeableConcept", "Type of synthesis eg meta-analysis.", 0, 1, this.synthesisType);
            }
            case -1955265373: {
                return new Property("studyType", "CodeableConcept", "Type of study eg randomized trial.", 0, 1, this.studyType);
            }
            case -2023558323: {
                return new Property("population", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1, this.population);
            }
            case -1926005497: {
                return new Property("exposure", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0, 1, this.exposure);
            }
            case -1875462106: {
                return new Property("exposureAlternative", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the comparison exposure for the research.", 0, 1, this.exposureAlternative);
            }
            case -1106507950: {
                return new Property("outcome", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0, 1, this.outcome);
            }
            case 143123659: {
                return new Property("sampleSize", "", "A description of the size of the sample involved in the synthesis.", 0, 1, this.sampleSize);
            }
            case 553042708: {
                return new Property("resultsByExposure", "", "A description of the results for each exposure considered in the effect estimate.", 0, Integer.MAX_VALUE, this.resultsByExposure);
            }
            case 707469785: {
                return new Property("effectEstimate", "", "The estimated effect of the exposure variant.", 0, Integer.MAX_VALUE, this.effectEstimate);
            }
            case -1404142937: {
                return new Property("certainty", "", "A description of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.certainty);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 672726254: {
                Base[] baseArray;
                if (this.synthesisType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.synthesisType;
                }
                return baseArray;
            }
            case -1955265373: {
                Base[] baseArray;
                if (this.studyType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.studyType;
                }
                return baseArray;
            }
            case -2023558323: {
                Base[] baseArray;
                if (this.population == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.population;
                }
                return baseArray;
            }
            case -1926005497: {
                Base[] baseArray;
                if (this.exposure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.exposure;
                }
                return baseArray;
            }
            case -1875462106: {
                Base[] baseArray;
                if (this.exposureAlternative == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.exposureAlternative;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.outcome;
                }
                return baseArray;
            }
            case 143123659: {
                Base[] baseArray;
                if (this.sampleSize == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.sampleSize;
                }
                return baseArray;
            }
            case 553042708: {
                return this.resultsByExposure == null ? new Base[]{} : this.resultsByExposure.toArray(new Base[this.resultsByExposure.size()]);
            }
            case 707469785: {
                return this.effectEstimate == null ? new Base[]{} : this.effectEstimate.toArray(new Base[this.effectEstimate.size()]);
            }
            case -1404142937: {
                return this.certainty == null ? new Base[]{} : this.certainty.toArray(new Base[this.certainty.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(this.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(this.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 672726254: {
                this.synthesisType = this.castToCodeableConcept(value);
                return value;
            }
            case -1955265373: {
                this.studyType = this.castToCodeableConcept(value);
                return value;
            }
            case -2023558323: {
                this.population = this.castToReference(value);
                return value;
            }
            case -1926005497: {
                this.exposure = this.castToReference(value);
                return value;
            }
            case -1875462106: {
                this.exposureAlternative = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToReference(value);
                return value;
            }
            case 143123659: {
                this.sampleSize = (EffectEvidenceSynthesisSampleSizeComponent)((Object)value);
                return value;
            }
            case 553042708: {
                this.getResultsByExposure().add((EffectEvidenceSynthesisResultsByExposureComponent)((Object)value));
                return value;
            }
            case 707469785: {
                this.getEffectEstimate().add((EffectEvidenceSynthesisEffectEstimateComponent)((Object)value));
                return value;
            }
            case -1404142937: {
                this.getCertainty().add((EffectEvidenceSynthesisCertaintyComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("topic")) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("synthesisType")) {
            this.synthesisType = this.castToCodeableConcept(value);
        } else if (name.equals("studyType")) {
            this.studyType = this.castToCodeableConcept(value);
        } else if (name.equals("population")) {
            this.population = this.castToReference(value);
        } else if (name.equals("exposure")) {
            this.exposure = this.castToReference(value);
        } else if (name.equals("exposureAlternative")) {
            this.exposureAlternative = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToReference(value);
        } else if (name.equals("sampleSize")) {
            this.sampleSize = (EffectEvidenceSynthesisSampleSizeComponent)((Object)value);
        } else if (name.equals("resultsByExposure")) {
            this.getResultsByExposure().add((EffectEvidenceSynthesisResultsByExposureComponent)((Object)value));
        } else if (name.equals("effectEstimate")) {
            this.getEffectEstimate().add((EffectEvidenceSynthesisEffectEstimateComponent)((Object)value));
        } else if (name.equals("certainty")) {
            this.getCertainty().add((EffectEvidenceSynthesisCertaintyComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 672726254: {
                return this.getSynthesisType();
            }
            case -1955265373: {
                return this.getStudyType();
            }
            case -2023558323: {
                return this.getPopulation();
            }
            case -1926005497: {
                return this.getExposure();
            }
            case -1875462106: {
                return this.getExposureAlternative();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case 143123659: {
                return this.getSampleSize();
            }
            case 553042708: {
                return this.addResultsByExposure();
            }
            case 707469785: {
                return this.addEffectEstimate();
            }
            case -1404142937: {
                return this.addCertainty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 672726254: {
                return new String[]{"CodeableConcept"};
            }
            case -1955265373: {
                return new String[]{"CodeableConcept"};
            }
            case -2023558323: {
                return new String[]{"Reference"};
            }
            case -1926005497: {
                return new String[]{"Reference"};
            }
            case -1875462106: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"Reference"};
            }
            case 143123659: {
                return new String[0];
            }
            case 553042708: {
                return new String[0];
            }
            case 707469785: {
                return new String[0];
            }
            case -1404142937: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("topic")) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("synthesisType")) {
            this.synthesisType = new CodeableConcept();
            return this.synthesisType;
        }
        if (name.equals("studyType")) {
            this.studyType = new CodeableConcept();
            return this.studyType;
        }
        if (name.equals("population")) {
            this.population = new Reference();
            return this.population;
        }
        if (name.equals("exposure")) {
            this.exposure = new Reference();
            return this.exposure;
        }
        if (name.equals("exposureAlternative")) {
            this.exposureAlternative = new Reference();
            return this.exposureAlternative;
        }
        if (name.equals("outcome")) {
            this.outcome = new Reference();
            return this.outcome;
        }
        if (name.equals("sampleSize")) {
            this.sampleSize = new EffectEvidenceSynthesisSampleSizeComponent();
            return this.sampleSize;
        }
        if (name.equals("resultsByExposure")) {
            return this.addResultsByExposure();
        }
        if (name.equals("effectEstimate")) {
            return this.addEffectEstimate();
        }
        if (name.equals("certainty")) {
            return this.addCertainty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EffectEvidenceSynthesis";
    }

    @Override
    public EffectEvidenceSynthesis copy() {
        EffectEvidenceSynthesis dst = new EffectEvidenceSynthesis();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EffectEvidenceSynthesis dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.synthesisType = this.synthesisType == null ? null : this.synthesisType.copy();
        dst.studyType = this.studyType == null ? null : this.studyType.copy();
        dst.population = this.population == null ? null : this.population.copy();
        dst.exposure = this.exposure == null ? null : this.exposure.copy();
        dst.exposureAlternative = this.exposureAlternative == null ? null : this.exposureAlternative.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        EffectEvidenceSynthesisSampleSizeComponent effectEvidenceSynthesisSampleSizeComponent = dst.sampleSize = this.sampleSize == null ? null : this.sampleSize.copy();
        if (this.resultsByExposure != null) {
            dst.resultsByExposure = new ArrayList<EffectEvidenceSynthesisResultsByExposureComponent>();
            for (EffectEvidenceSynthesisResultsByExposureComponent effectEvidenceSynthesisResultsByExposureComponent : this.resultsByExposure) {
                dst.resultsByExposure.add(effectEvidenceSynthesisResultsByExposureComponent.copy());
            }
        }
        if (this.effectEstimate != null) {
            dst.effectEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimateComponent>();
            for (EffectEvidenceSynthesisEffectEstimateComponent effectEvidenceSynthesisEffectEstimateComponent : this.effectEstimate) {
                dst.effectEstimate.add(effectEvidenceSynthesisEffectEstimateComponent.copy());
            }
        }
        if (this.certainty != null) {
            dst.certainty = new ArrayList<EffectEvidenceSynthesisCertaintyComponent>();
            for (EffectEvidenceSynthesisCertaintyComponent effectEvidenceSynthesisCertaintyComponent : this.certainty) {
                dst.certainty.add(effectEvidenceSynthesisCertaintyComponent.copy());
            }
        }
    }

    protected EffectEvidenceSynthesis typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EffectEvidenceSynthesis)) {
            return false;
        }
        EffectEvidenceSynthesis o = (EffectEvidenceSynthesis)other_;
        return EffectEvidenceSynthesis.compareDeep(this.identifier, o.identifier, true) && EffectEvidenceSynthesis.compareDeep(this.note, o.note, true) && EffectEvidenceSynthesis.compareDeep(this.copyright, o.copyright, true) && EffectEvidenceSynthesis.compareDeep(this.approvalDate, o.approvalDate, true) && EffectEvidenceSynthesis.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && EffectEvidenceSynthesis.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && EffectEvidenceSynthesis.compareDeep(this.topic, o.topic, true) && EffectEvidenceSynthesis.compareDeep(this.author, o.author, true) && EffectEvidenceSynthesis.compareDeep(this.editor, o.editor, true) && EffectEvidenceSynthesis.compareDeep(this.reviewer, o.reviewer, true) && EffectEvidenceSynthesis.compareDeep(this.endorser, o.endorser, true) && EffectEvidenceSynthesis.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && EffectEvidenceSynthesis.compareDeep(this.synthesisType, o.synthesisType, true) && EffectEvidenceSynthesis.compareDeep(this.studyType, o.studyType, true) && EffectEvidenceSynthesis.compareDeep(this.population, o.population, true) && EffectEvidenceSynthesis.compareDeep(this.exposure, o.exposure, true) && EffectEvidenceSynthesis.compareDeep(this.exposureAlternative, o.exposureAlternative, true) && EffectEvidenceSynthesis.compareDeep(this.outcome, o.outcome, true) && EffectEvidenceSynthesis.compareDeep(this.sampleSize, o.sampleSize, true) && EffectEvidenceSynthesis.compareDeep(this.resultsByExposure, o.resultsByExposure, true) && EffectEvidenceSynthesis.compareDeep(this.effectEstimate, o.effectEstimate, true) && EffectEvidenceSynthesis.compareDeep(this.certainty, o.certainty, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EffectEvidenceSynthesis)) {
            return false;
        }
        EffectEvidenceSynthesis o = (EffectEvidenceSynthesis)other_;
        return EffectEvidenceSynthesis.compareValues(this.copyright, o.copyright, true) && EffectEvidenceSynthesis.compareValues(this.approvalDate, o.approvalDate, true) && EffectEvidenceSynthesis.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.note, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.synthesisType, this.studyType, this.population, this.exposure, this.exposureAlternative, this.outcome, this.sampleSize, this.resultsByExposure, this.effectEstimate, this.certainty});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EffectEvidenceSynthesis;
    }

    @Block
    public static class EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of subcomponent of certainty rating", formalDefinition="Type of subcomponent of certainty rating.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-type")
        protected CodeableConcept type;
        @Child(name="rating", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subcomponent certainty rating", formalDefinition="A rating of a subcomponent of rating certainty.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating")
        protected List<CodeableConcept> rating;
        @Child(name="note", type={Annotation.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -411994816L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of subcomponent of certainty rating.", 0, 1, this.type));
            children.add(new Property("rating", "CodeableConcept", "A rating of a subcomponent of rating certainty.", 0, Integer.MAX_VALUE, this.rating));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of subcomponent of certainty rating.", 0, 1, this.type);
                }
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "A rating of a subcomponent of rating certainty.", 0, Integer.MAX_VALUE, this.rating);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -938102371: {
                    return this.addRating();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("rating")) {
                return this.addRating();
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent copy() {
            EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent dst = new EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.rating) {
                    dst.rating.add(codeableConcept2.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent o = (EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)other_;
            return EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.type, o.type, true) && EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.rating, o.rating, true) && EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent o = (EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.rating, this.note});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.certainty.certaintySubcomponent";
        }
    }

    @Block
    public static class EffectEvidenceSynthesisCertaintyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="rating", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Certainty rating", formalDefinition="A rating of the certainty of the effect estimate.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-quality")
        protected List<CodeableConcept> rating;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
        protected List<Annotation> note;
        @Child(name="certaintySubcomponent", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A component that contributes to the overall certainty", formalDefinition="A description of a component of the overall certainty.")
        protected List<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent> certaintySubcomponent;
        private static final long serialVersionUID = 647101417L;

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public EffectEvidenceSynthesisCertaintyComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public EffectEvidenceSynthesisCertaintyComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EffectEvidenceSynthesisCertaintyComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EffectEvidenceSynthesisCertaintyComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public List<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent> getCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            return this.certaintySubcomponent;
        }

        public EffectEvidenceSynthesisCertaintyComponent setCertaintySubcomponent(List<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent> theCertaintySubcomponent) {
            this.certaintySubcomponent = theCertaintySubcomponent;
            return this;
        }

        public boolean hasCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                return false;
            }
            for (EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent item : this.certaintySubcomponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent addCertaintySubcomponent() {
            EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent t = new EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return t;
        }

        public EffectEvidenceSynthesisCertaintyComponent addCertaintySubcomponent(EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return this;
        }

        public EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent getCertaintySubcomponentFirstRep() {
            if (this.getCertaintySubcomponent().isEmpty()) {
                this.addCertaintySubcomponent();
            }
            return this.getCertaintySubcomponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("rating", "CodeableConcept", "A rating of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.rating));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("certaintySubcomponent", "", "A description of a component of the overall certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "A rating of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.rating);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
                }
                case 1806398212: {
                    return new Property("certaintySubcomponent", "", "A description of a component of the overall certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 1806398212: {
                    return this.certaintySubcomponent == null ? new Base[]{} : this.certaintySubcomponent.toArray(new Base[this.certaintySubcomponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
                case 1806398212: {
                    this.getCertaintySubcomponent().add((EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else if (name.equals("certaintySubcomponent")) {
                this.getCertaintySubcomponent().add((EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return this.addRating();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 1806398212: {
                    return this.addCertaintySubcomponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 1806398212: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rating")) {
                return this.addRating();
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("certaintySubcomponent")) {
                return this.addCertaintySubcomponent();
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisCertaintyComponent copy() {
            EffectEvidenceSynthesisCertaintyComponent dst = new EffectEvidenceSynthesisCertaintyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisCertaintyComponent dst) {
            super.copyValues(dst);
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rating) {
                    dst.rating.add(codeableConcept.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            if (this.certaintySubcomponent != null) {
                dst.certaintySubcomponent = new ArrayList<EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
                for (EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent effectEvidenceSynthesisCertaintyCertaintySubcomponentComponent : this.certaintySubcomponent) {
                    dst.certaintySubcomponent.add(effectEvidenceSynthesisCertaintyCertaintySubcomponentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisCertaintyComponent)) {
                return false;
            }
            EffectEvidenceSynthesisCertaintyComponent o = (EffectEvidenceSynthesisCertaintyComponent)other_;
            return EffectEvidenceSynthesisCertaintyComponent.compareDeep(this.rating, o.rating, true) && EffectEvidenceSynthesisCertaintyComponent.compareDeep(this.note, o.note, true) && EffectEvidenceSynthesisCertaintyComponent.compareDeep(this.certaintySubcomponent, o.certaintySubcomponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisCertaintyComponent)) {
                return false;
            }
            EffectEvidenceSynthesisCertaintyComponent o = (EffectEvidenceSynthesisCertaintyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.rating, this.note, this.certaintySubcomponent});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.certainty";
        }
    }

    @Block
    public static class EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of precision estimate", formalDefinition="Examples include confidence interval and interquartile range.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/precision-estimate-type")
        protected CodeableConcept type;
        @Child(name="level", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Level of confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="from", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lower bound", formalDefinition="Lower bound of confidence interval.")
        protected DecimalType from;
        @Child(name="to", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Upper bound", formalDefinition="Upper bound of confidence interval.")
        protected DecimalType to;
        private static final long serialVersionUID = -110178057L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public DecimalType getFromElement() {
            if (this.from == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.from");
                }
                if (Configuration.doAutoCreate()) {
                    this.from = new DecimalType();
                }
            }
            return this.from;
        }

        public boolean hasFromElement() {
            return this.from != null && !this.from.isEmpty();
        }

        public boolean hasFrom() {
            return this.from != null && !this.from.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setFromElement(DecimalType value) {
            this.from = value;
            return this;
        }

        public BigDecimal getFrom() {
            return this.from == null ? null : (BigDecimal)this.from.getValue();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setFrom(BigDecimal value) {
            if (value == null) {
                this.from = null;
            } else {
                if (this.from == null) {
                    this.from = new DecimalType();
                }
                this.from.setValue(value);
            }
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setFrom(long value) {
            this.from = new DecimalType();
            this.from.setValue(value);
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setFrom(double value) {
            this.from = new DecimalType();
            this.from.setValue(value);
            return this;
        }

        public DecimalType getToElement() {
            if (this.to == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.to");
                }
                if (Configuration.doAutoCreate()) {
                    this.to = new DecimalType();
                }
            }
            return this.to;
        }

        public boolean hasToElement() {
            return this.to != null && !this.to.isEmpty();
        }

        public boolean hasTo() {
            return this.to != null && !this.to.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setToElement(DecimalType value) {
            this.to = value;
            return this;
        }

        public BigDecimal getTo() {
            return this.to == null ? null : (BigDecimal)this.to.getValue();
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setTo(BigDecimal value) {
            if (value == null) {
                this.to = null;
            } else {
                if (this.to == null) {
                    this.to = new DecimalType();
                }
                this.to.setValue(value);
            }
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setTo(long value) {
            this.to = new DecimalType();
            this.to.setValue(value);
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent setTo(double value) {
            this.to = new DecimalType();
            this.to.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Examples include confidence interval and interquartile range.", 0, 1, this.type));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("from", "decimal", "Lower bound of confidence interval.", 0, 1, this.from));
            children.add(new Property("to", "decimal", "Upper bound of confidence interval.", 0, 1, this.to));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Examples include confidence interval and interquartile range.", 0, 1, this.type);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 3151786: {
                    return new Property("from", "decimal", "Lower bound of confidence interval.", 0, 1, this.from);
                }
                case 3707: {
                    return new Property("to", "decimal", "Upper bound of confidence interval.", 0, 1, this.to);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.level;
                    }
                    return baseArray;
                }
                case 3151786: {
                    Base[] baseArray;
                    if (this.from == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.from;
                    }
                    return baseArray;
                }
                case 3707: {
                    Base[] baseArray;
                    if (this.to == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.to;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 102865796: {
                    this.level = this.castToDecimal(value);
                    return value;
                }
                case 3151786: {
                    this.from = this.castToDecimal(value);
                    return value;
                }
                case 3707: {
                    this.to = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("level")) {
                this.level = this.castToDecimal(value);
            } else if (name.equals("from")) {
                this.from = this.castToDecimal(value);
            } else if (name.equals("to")) {
                this.to = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 3151786: {
                    return this.getFromElement();
                }
                case 3707: {
                    return this.getToElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 3151786: {
                    return new String[]{"decimal"};
                }
                case 3707: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.level");
            }
            if (name.equals("from")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.from");
            }
            if (name.equals("to")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.to");
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent copy() {
            EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent dst = new EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.level = this.level == null ? null : this.level.copy();
            dst.from = this.from == null ? null : this.from.copy();
            dst.to = this.to == null ? null : this.to.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)) {
                return false;
            }
            EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent o = (EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)other_;
            return EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareDeep(this.type, o.type, true) && EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareDeep(this.level, o.level, true) && EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareDeep(this.from, o.from, true) && EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareDeep(this.to, o.to, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)) {
                return false;
            }
            EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent o = (EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)other_;
            return EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareValues(this.level, o.level, true) && EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareValues(this.from, o.from, true) && EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent.compareValues(this.to, o.to, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.level, this.from, this.to});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.effectEstimate.precisionEstimate";
        }
    }

    @Block
    public static class EffectEvidenceSynthesisEffectEstimateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of effect estimate", formalDefinition="Human-readable summary of effect estimate.")
        protected StringType description;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of efffect estimate", formalDefinition="Examples include relative risk and mean difference.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/effect-estimate-type")
        protected CodeableConcept type;
        @Child(name="variantState", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Variant exposure states", formalDefinition="Used to define variant exposure states such as low-risk state.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-variant-state")
        protected CodeableConcept variantState;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Point estimate", formalDefinition="The point estimate of the effect estimate.")
        protected DecimalType value;
        @Child(name="unitOfMeasure", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What unit is the outcome described in?", formalDefinition="Specifies the UCUM unit for the outcome.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        protected CodeableConcept unitOfMeasure;
        @Child(name="precisionEstimate", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="How precise the estimate is", formalDefinition="A description of the precision of the estimate for the effect.")
        protected List<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent> precisionEstimate;
        private static final long serialVersionUID = -1075065083L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getVariantState() {
            if (this.variantState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimateComponent.variantState");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantState = new CodeableConcept();
                }
            }
            return this.variantState;
        }

        public boolean hasVariantState() {
            return this.variantState != null && !this.variantState.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setVariantState(CodeableConcept value) {
            this.variantState = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimateComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public CodeableConcept getUnitOfMeasure() {
            if (this.unitOfMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisEffectEstimateComponent.unitOfMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitOfMeasure = new CodeableConcept();
                }
            }
            return this.unitOfMeasure;
        }

        public boolean hasUnitOfMeasure() {
            return this.unitOfMeasure != null && !this.unitOfMeasure.isEmpty();
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setUnitOfMeasure(CodeableConcept value) {
            this.unitOfMeasure = value;
            return this;
        }

        public List<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent> getPrecisionEstimate() {
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent>();
            }
            return this.precisionEstimate;
        }

        public EffectEvidenceSynthesisEffectEstimateComponent setPrecisionEstimate(List<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent> thePrecisionEstimate) {
            this.precisionEstimate = thePrecisionEstimate;
            return this;
        }

        public boolean hasPrecisionEstimate() {
            if (this.precisionEstimate == null) {
                return false;
            }
            for (EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent item : this.precisionEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent addPrecisionEstimate() {
            EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent t = new EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent();
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent>();
            }
            this.precisionEstimate.add(t);
            return t;
        }

        public EffectEvidenceSynthesisEffectEstimateComponent addPrecisionEstimate(EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent>();
            }
            this.precisionEstimate.add(t);
            return this;
        }

        public EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent getPrecisionEstimateFirstRep() {
            if (this.getPrecisionEstimate().isEmpty()) {
                this.addPrecisionEstimate();
            }
            return this.getPrecisionEstimate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of effect estimate.", 0, 1, this.description));
            children.add(new Property("type", "CodeableConcept", "Examples include relative risk and mean difference.", 0, 1, this.type));
            children.add(new Property("variantState", "CodeableConcept", "Used to define variant exposure states such as low-risk state.", 0, 1, this.variantState));
            children.add(new Property("value", "decimal", "The point estimate of the effect estimate.", 0, 1, this.value));
            children.add(new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure));
            children.add(new Property("precisionEstimate", "", "A description of the precision of the estimate for the effect.", 0, Integer.MAX_VALUE, this.precisionEstimate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of effect estimate.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Examples include relative risk and mean difference.", 0, 1, this.type);
                }
                case 1900629772: {
                    return new Property("variantState", "CodeableConcept", "Used to define variant exposure states such as low-risk state.", 0, 1, this.variantState);
                }
                case 111972721: {
                    return new Property("value", "decimal", "The point estimate of the effect estimate.", 0, 1, this.value);
                }
                case -750257565: {
                    return new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure);
                }
                case 339632070: {
                    return new Property("precisionEstimate", "", "A description of the precision of the estimate for the effect.", 0, Integer.MAX_VALUE, this.precisionEstimate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1900629772: {
                    Base[] baseArray;
                    if (this.variantState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.variantState;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
                case -750257565: {
                    Base[] baseArray;
                    if (this.unitOfMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitOfMeasure;
                    }
                    return baseArray;
                }
                case 339632070: {
                    return this.precisionEstimate == null ? new Base[]{} : this.precisionEstimate.toArray(new Base[this.precisionEstimate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1900629772: {
                    this.variantState = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    return value;
                }
                case -750257565: {
                    this.unitOfMeasure = this.castToCodeableConcept(value);
                    return value;
                }
                case 339632070: {
                    this.getPrecisionEstimate().add((EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("variantState")) {
                this.variantState = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = this.castToCodeableConcept(value);
            } else if (name.equals("precisionEstimate")) {
                this.getPrecisionEstimate().add((EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1900629772: {
                    return this.getVariantState();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case -750257565: {
                    return this.getUnitOfMeasure();
                }
                case 339632070: {
                    return this.addPrecisionEstimate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1900629772: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"decimal"};
                }
                case -750257565: {
                    return new String[]{"CodeableConcept"};
                }
                case 339632070: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.description");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("variantState")) {
                this.variantState = new CodeableConcept();
                return this.variantState;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.value");
            }
            if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = new CodeableConcept();
                return this.unitOfMeasure;
            }
            if (name.equals("precisionEstimate")) {
                return this.addPrecisionEstimate();
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisEffectEstimateComponent copy() {
            EffectEvidenceSynthesisEffectEstimateComponent dst = new EffectEvidenceSynthesisEffectEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisEffectEstimateComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.variantState = this.variantState == null ? null : this.variantState.copy();
            dst.value = this.value == null ? null : this.value.copy();
            CodeableConcept codeableConcept = dst.unitOfMeasure = this.unitOfMeasure == null ? null : this.unitOfMeasure.copy();
            if (this.precisionEstimate != null) {
                dst.precisionEstimate = new ArrayList<EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent>();
                for (EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent i : this.precisionEstimate) {
                    dst.precisionEstimate.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisEffectEstimateComponent)) {
                return false;
            }
            EffectEvidenceSynthesisEffectEstimateComponent o = (EffectEvidenceSynthesisEffectEstimateComponent)other_;
            return EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.description, o.description, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.type, o.type, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.variantState, o.variantState, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.value, o.value, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.unitOfMeasure, o.unitOfMeasure, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareDeep(this.precisionEstimate, o.precisionEstimate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisEffectEstimateComponent)) {
                return false;
            }
            EffectEvidenceSynthesisEffectEstimateComponent o = (EffectEvidenceSynthesisEffectEstimateComponent)other_;
            return EffectEvidenceSynthesisEffectEstimateComponent.compareValues(this.description, o.description, true) && EffectEvidenceSynthesisEffectEstimateComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.type, this.variantState, this.value, this.unitOfMeasure, this.precisionEstimate});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.effectEstimate";
        }
    }

    @Block
    public static class EffectEvidenceSynthesisResultsByExposureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of results by exposure", formalDefinition="Human-readable summary of results by exposure state.")
        protected StringType description;
        @Child(name="exposureState", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="exposure | exposure-alternative", formalDefinition="Whether these results are for the exposure state or alternative exposure state.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/exposure-state")
        protected Enumeration<ExposureState> exposureState;
        @Child(name="variantState", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Variant exposure states", formalDefinition="Used to define variant exposure states such as low-risk state.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-variant-state")
        protected CodeableConcept variantState;
        @Child(name="riskEvidenceSynthesis", type={RiskEvidenceSynthesis.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Risk evidence synthesis", formalDefinition="Reference to a RiskEvidenceSynthesis resource.")
        protected Reference riskEvidenceSynthesis;
        protected RiskEvidenceSynthesis riskEvidenceSynthesisTarget;
        private static final long serialVersionUID = 144886133L;

        public EffectEvidenceSynthesisResultsByExposureComponent() {
        }

        public EffectEvidenceSynthesisResultsByExposureComponent(Reference riskEvidenceSynthesis) {
            this.riskEvidenceSynthesis = riskEvidenceSynthesis;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisResultsByExposureComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<ExposureState> getExposureStateElement() {
            if (this.exposureState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisResultsByExposureComponent.exposureState");
                }
                if (Configuration.doAutoCreate()) {
                    this.exposureState = new Enumeration<ExposureState>(new ExposureStateEnumFactory());
                }
            }
            return this.exposureState;
        }

        public boolean hasExposureStateElement() {
            return this.exposureState != null && !this.exposureState.isEmpty();
        }

        public boolean hasExposureState() {
            return this.exposureState != null && !this.exposureState.isEmpty();
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setExposureStateElement(Enumeration<ExposureState> value) {
            this.exposureState = value;
            return this;
        }

        public ExposureState getExposureState() {
            return this.exposureState == null ? null : (ExposureState)((Object)this.exposureState.getValue());
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setExposureState(ExposureState value) {
            if (value == null) {
                this.exposureState = null;
            } else {
                if (this.exposureState == null) {
                    this.exposureState = new Enumeration<ExposureState>(new ExposureStateEnumFactory());
                }
                this.exposureState.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getVariantState() {
            if (this.variantState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisResultsByExposureComponent.variantState");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantState = new CodeableConcept();
                }
            }
            return this.variantState;
        }

        public boolean hasVariantState() {
            return this.variantState != null && !this.variantState.isEmpty();
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setVariantState(CodeableConcept value) {
            this.variantState = value;
            return this;
        }

        public Reference getRiskEvidenceSynthesis() {
            if (this.riskEvidenceSynthesis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisResultsByExposureComponent.riskEvidenceSynthesis");
                }
                if (Configuration.doAutoCreate()) {
                    this.riskEvidenceSynthesis = new Reference();
                }
            }
            return this.riskEvidenceSynthesis;
        }

        public boolean hasRiskEvidenceSynthesis() {
            return this.riskEvidenceSynthesis != null && !this.riskEvidenceSynthesis.isEmpty();
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setRiskEvidenceSynthesis(Reference value) {
            this.riskEvidenceSynthesis = value;
            return this;
        }

        public RiskEvidenceSynthesis getRiskEvidenceSynthesisTarget() {
            if (this.riskEvidenceSynthesisTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisResultsByExposureComponent.riskEvidenceSynthesis");
                }
                if (Configuration.doAutoCreate()) {
                    this.riskEvidenceSynthesisTarget = new RiskEvidenceSynthesis();
                }
            }
            return this.riskEvidenceSynthesisTarget;
        }

        public EffectEvidenceSynthesisResultsByExposureComponent setRiskEvidenceSynthesisTarget(RiskEvidenceSynthesis value) {
            this.riskEvidenceSynthesisTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of results by exposure state.", 0, 1, this.description));
            children.add(new Property("exposureState", "code", "Whether these results are for the exposure state or alternative exposure state.", 0, 1, this.exposureState));
            children.add(new Property("variantState", "CodeableConcept", "Used to define variant exposure states such as low-risk state.", 0, 1, this.variantState));
            children.add(new Property("riskEvidenceSynthesis", "Reference(RiskEvidenceSynthesis)", "Reference to a RiskEvidenceSynthesis resource.", 0, 1, this.riskEvidenceSynthesis));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of results by exposure state.", 0, 1, this.description);
                }
                case 422339530: {
                    return new Property("exposureState", "code", "Whether these results are for the exposure state or alternative exposure state.", 0, 1, this.exposureState);
                }
                case 1900629772: {
                    return new Property("variantState", "CodeableConcept", "Used to define variant exposure states such as low-risk state.", 0, 1, this.variantState);
                }
                case 109085678: {
                    return new Property("riskEvidenceSynthesis", "Reference(RiskEvidenceSynthesis)", "Reference to a RiskEvidenceSynthesis resource.", 0, 1, this.riskEvidenceSynthesis);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 422339530: {
                    Base[] baseArray;
                    if (this.exposureState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exposureState;
                    }
                    return baseArray;
                }
                case 1900629772: {
                    Base[] baseArray;
                    if (this.variantState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.variantState;
                    }
                    return baseArray;
                }
                case 109085678: {
                    Base[] baseArray;
                    if (this.riskEvidenceSynthesis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.riskEvidenceSynthesis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 422339530: {
                    value = new ExposureStateEnumFactory().fromType(this.castToCode(value));
                    this.exposureState = value;
                    return value;
                }
                case 1900629772: {
                    this.variantState = this.castToCodeableConcept(value);
                    return value;
                }
                case 109085678: {
                    this.riskEvidenceSynthesis = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("exposureState")) {
                value = new ExposureStateEnumFactory().fromType(this.castToCode(value));
                this.exposureState = value;
            } else if (name.equals("variantState")) {
                this.variantState = this.castToCodeableConcept(value);
            } else if (name.equals("riskEvidenceSynthesis")) {
                this.riskEvidenceSynthesis = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 422339530: {
                    return this.getExposureStateElement();
                }
                case 1900629772: {
                    return this.getVariantState();
                }
                case 109085678: {
                    return this.getRiskEvidenceSynthesis();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 422339530: {
                    return new String[]{"code"};
                }
                case 1900629772: {
                    return new String[]{"CodeableConcept"};
                }
                case 109085678: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.description");
            }
            if (name.equals("exposureState")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.exposureState");
            }
            if (name.equals("variantState")) {
                this.variantState = new CodeableConcept();
                return this.variantState;
            }
            if (name.equals("riskEvidenceSynthesis")) {
                this.riskEvidenceSynthesis = new Reference();
                return this.riskEvidenceSynthesis;
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisResultsByExposureComponent copy() {
            EffectEvidenceSynthesisResultsByExposureComponent dst = new EffectEvidenceSynthesisResultsByExposureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisResultsByExposureComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.exposureState = this.exposureState == null ? null : this.exposureState.copy();
            dst.variantState = this.variantState == null ? null : this.variantState.copy();
            dst.riskEvidenceSynthesis = this.riskEvidenceSynthesis == null ? null : this.riskEvidenceSynthesis.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisResultsByExposureComponent)) {
                return false;
            }
            EffectEvidenceSynthesisResultsByExposureComponent o = (EffectEvidenceSynthesisResultsByExposureComponent)other_;
            return EffectEvidenceSynthesisResultsByExposureComponent.compareDeep(this.description, o.description, true) && EffectEvidenceSynthesisResultsByExposureComponent.compareDeep(this.exposureState, o.exposureState, true) && EffectEvidenceSynthesisResultsByExposureComponent.compareDeep(this.variantState, o.variantState, true) && EffectEvidenceSynthesisResultsByExposureComponent.compareDeep(this.riskEvidenceSynthesis, o.riskEvidenceSynthesis, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisResultsByExposureComponent)) {
                return false;
            }
            EffectEvidenceSynthesisResultsByExposureComponent o = (EffectEvidenceSynthesisResultsByExposureComponent)other_;
            return EffectEvidenceSynthesisResultsByExposureComponent.compareValues(this.description, o.description, true) && EffectEvidenceSynthesisResultsByExposureComponent.compareValues(this.exposureState, o.exposureState, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.exposureState, this.variantState, this.riskEvidenceSynthesis});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.resultsByExposure";
        }
    }

    @Block
    public static class EffectEvidenceSynthesisSampleSizeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of sample size", formalDefinition="Human-readable summary of sample size.")
        protected StringType description;
        @Child(name="numberOfStudies", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many studies?", formalDefinition="Number of studies included in this evidence synthesis.")
        protected IntegerType numberOfStudies;
        @Child(name="numberOfParticipants", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many participants?", formalDefinition="Number of participants included in this evidence synthesis.")
        protected IntegerType numberOfParticipants;
        private static final long serialVersionUID = -1116074476L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisSampleSizeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public IntegerType getNumberOfStudiesElement() {
            if (this.numberOfStudies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisSampleSizeComponent.numberOfStudies");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfStudies = new IntegerType();
                }
            }
            return this.numberOfStudies;
        }

        public boolean hasNumberOfStudiesElement() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public boolean hasNumberOfStudies() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setNumberOfStudiesElement(IntegerType value) {
            this.numberOfStudies = value;
            return this;
        }

        public int getNumberOfStudies() {
            return this.numberOfStudies == null || this.numberOfStudies.isEmpty() ? 0 : (Integer)this.numberOfStudies.getValue();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setNumberOfStudies(int value) {
            if (this.numberOfStudies == null) {
                this.numberOfStudies = new IntegerType();
            }
            this.numberOfStudies.setValue((Object)value);
            return this;
        }

        public IntegerType getNumberOfParticipantsElement() {
            if (this.numberOfParticipants == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EffectEvidenceSynthesisSampleSizeComponent.numberOfParticipants");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfParticipants = new IntegerType();
                }
            }
            return this.numberOfParticipants;
        }

        public boolean hasNumberOfParticipantsElement() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public boolean hasNumberOfParticipants() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setNumberOfParticipantsElement(IntegerType value) {
            this.numberOfParticipants = value;
            return this;
        }

        public int getNumberOfParticipants() {
            return this.numberOfParticipants == null || this.numberOfParticipants.isEmpty() ? 0 : (Integer)this.numberOfParticipants.getValue();
        }

        public EffectEvidenceSynthesisSampleSizeComponent setNumberOfParticipants(int value) {
            if (this.numberOfParticipants == null) {
                this.numberOfParticipants = new IntegerType();
            }
            this.numberOfParticipants.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of sample size.", 0, 1, this.description));
            children.add(new Property("numberOfStudies", "integer", "Number of studies included in this evidence synthesis.", 0, 1, this.numberOfStudies));
            children.add(new Property("numberOfParticipants", "integer", "Number of participants included in this evidence synthesis.", 0, 1, this.numberOfParticipants));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(EffectEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of sample size.", 0, 1, this.description);
                }
                case -177467129: {
                    return new Property("numberOfStudies", "integer", "Number of studies included in this evidence synthesis.", 0, 1, this.numberOfStudies);
                }
                case 1799357120: {
                    return new Property("numberOfParticipants", "integer", "Number of participants included in this evidence synthesis.", 0, 1, this.numberOfParticipants);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -177467129: {
                    Base[] baseArray;
                    if (this.numberOfStudies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfStudies;
                    }
                    return baseArray;
                }
                case 1799357120: {
                    Base[] baseArray;
                    if (this.numberOfParticipants == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.numberOfParticipants;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -177467129: {
                    this.numberOfStudies = this.castToInteger(value);
                    return value;
                }
                case 1799357120: {
                    this.numberOfParticipants = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("numberOfStudies")) {
                this.numberOfStudies = this.castToInteger(value);
            } else if (name.equals("numberOfParticipants")) {
                this.numberOfParticipants = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -177467129: {
                    return this.getNumberOfStudiesElement();
                }
                case 1799357120: {
                    return this.getNumberOfParticipantsElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -177467129: {
                    return new String[]{"integer"};
                }
                case 1799357120: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EffectEvidenceSynthesis.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.description");
            }
            if (name.equals("numberOfStudies")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.numberOfStudies");
            }
            if (name.equals("numberOfParticipants")) {
                throw new FHIRException("Cannot call addChild on a singleton property EffectEvidenceSynthesis.numberOfParticipants");
            }
            return super.addChild(name);
        }

        @Override
        public EffectEvidenceSynthesisSampleSizeComponent copy() {
            EffectEvidenceSynthesisSampleSizeComponent dst = new EffectEvidenceSynthesisSampleSizeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EffectEvidenceSynthesisSampleSizeComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.numberOfStudies = this.numberOfStudies == null ? null : this.numberOfStudies.copy();
            dst.numberOfParticipants = this.numberOfParticipants == null ? null : this.numberOfParticipants.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisSampleSizeComponent)) {
                return false;
            }
            EffectEvidenceSynthesisSampleSizeComponent o = (EffectEvidenceSynthesisSampleSizeComponent)other_;
            return EffectEvidenceSynthesisSampleSizeComponent.compareDeep(this.description, o.description, true) && EffectEvidenceSynthesisSampleSizeComponent.compareDeep(this.numberOfStudies, o.numberOfStudies, true) && EffectEvidenceSynthesisSampleSizeComponent.compareDeep(this.numberOfParticipants, o.numberOfParticipants, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EffectEvidenceSynthesisSampleSizeComponent)) {
                return false;
            }
            EffectEvidenceSynthesisSampleSizeComponent o = (EffectEvidenceSynthesisSampleSizeComponent)other_;
            return EffectEvidenceSynthesisSampleSizeComponent.compareValues(this.description, o.description, true) && EffectEvidenceSynthesisSampleSizeComponent.compareValues(this.numberOfStudies, o.numberOfStudies, true) && EffectEvidenceSynthesisSampleSizeComponent.compareValues(this.numberOfParticipants, o.numberOfParticipants, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.numberOfStudies, this.numberOfParticipants});
        }

        @Override
        public String fhirType() {
            return "EffectEvidenceSynthesis.sampleSize";
        }
    }

    public static class ExposureStateEnumFactory
    implements EnumFactory<ExposureState> {
        @Override
        public ExposureState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("exposure".equals(codeString)) {
                return ExposureState.EXPOSURE;
            }
            if ("exposure-alternative".equals(codeString)) {
                return ExposureState.EXPOSUREALTERNATIVE;
            }
            throw new IllegalArgumentException("Unknown ExposureState code '" + codeString + "'");
        }

        public Enumeration<ExposureState> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExposureState>(this, ExposureState.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ExposureState>(this, ExposureState.NULL, code);
            }
            if ("exposure".equals(codeString)) {
                return new Enumeration<ExposureState>(this, ExposureState.EXPOSURE, code);
            }
            if ("exposure-alternative".equals(codeString)) {
                return new Enumeration<ExposureState>(this, ExposureState.EXPOSUREALTERNATIVE, code);
            }
            throw new FHIRException("Unknown ExposureState code '" + codeString + "'");
        }

        @Override
        public String toCode(ExposureState code) {
            if (code == ExposureState.EXPOSURE) {
                return "exposure";
            }
            if (code == ExposureState.EXPOSUREALTERNATIVE) {
                return "exposure-alternative";
            }
            return "?";
        }

        @Override
        public String toSystem(ExposureState code) {
            return code.getSystem();
        }
    }

    public static enum ExposureState {
        EXPOSURE,
        EXPOSUREALTERNATIVE,
        NULL;


        public static ExposureState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("exposure".equals(codeString)) {
                return EXPOSURE;
            }
            if ("exposure-alternative".equals(codeString)) {
                return EXPOSUREALTERNATIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExposureState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EXPOSURE: {
                    return "exposure";
                }
                case EXPOSUREALTERNATIVE: {
                    return "exposure-alternative";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EXPOSURE: {
                    return "http://hl7.org/fhir/exposure-state";
                }
                case EXPOSUREALTERNATIVE: {
                    return "http://hl7.org/fhir/exposure-state";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EXPOSURE: {
                    return "used when the results by exposure is describing the results for the primary exposure of interest.";
                }
                case EXPOSUREALTERNATIVE: {
                    return "used when the results by exposure is describing the results for the alternative exposure state, control state or comparator state.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EXPOSURE: {
                    return "Exposure";
                }
                case EXPOSUREALTERNATIVE: {
                    return "Exposure Alternative";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

