/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;

@ResourceDef(name="Provenance", profile="http://hl7.org/fhir/StructureDefinition/Provenance")
public class Provenance
extends DomainResource {
    @Child(name="target", type={Reference.class}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target Reference(s) (usually version specific)", formalDefinition="The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.")
    protected List<Reference> target;
    protected List<Resource> targetTarget;
    @Child(name="occurred", type={Period.class, DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The period during which the activity occurred.")
    protected Type occurred;
    @Child(name="recorded", type={InstantType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity was recorded / updated", formalDefinition="The instant of time at which the activity was recorded.")
    protected InstantType recorded;
    @Child(name="policy", type={UriType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Policy or plan the activity was defined by", formalDefinition="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.")
    protected List<UriType> policy;
    @Child(name="location", type={Location.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the activity occurred, if relevant", formalDefinition="Where the activity occurred, if relevant.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason the activity is occurring", formalDefinition="The reason that the activity was taking place.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    protected List<CodeableConcept> reason;
    @Child(name="activity", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Activity that occurred", formalDefinition="An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-activity-type")
    protected CodeableConcept activity;
    @Child(name="agent", type={}, order=7, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actor involved", formalDefinition="An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.")
    protected List<ProvenanceAgentComponent> agent;
    @Child(name="entity", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An entity used in this activity", formalDefinition="An entity used in this activity.")
    protected List<ProvenanceEntityComponent> entity;
    @Child(name="signature", type={Signature.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Signature on target", formalDefinition="A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.")
    protected List<Signature> signature;
    private static final long serialVersionUID = -1991881518L;
    @SearchParamDefinition(name="agent-type", path="Provenance.agent.type", description="How the agent participated", type="token")
    public static final String SP_AGENT_TYPE = "agent-type";
    public static final TokenClientParam AGENT_TYPE = new TokenClientParam("agent-type");
    @SearchParamDefinition(name="agent", path="Provenance.agent.who", description="Who participated", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("Provenance:agent").toLocked();
    @SearchParamDefinition(name="signature-type", path="Provenance.signature.type", description="Indication of the reason the entity signed the object(s)", type="token")
    public static final String SP_SIGNATURE_TYPE = "signature-type";
    public static final TokenClientParam SIGNATURE_TYPE = new TokenClientParam("signature-type");
    @SearchParamDefinition(name="patient", path="Provenance.target.where(resolve() is Patient)", description="Target Reference(s) (usually version specific)", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Provenance:patient").toLocked();
    @SearchParamDefinition(name="location", path="Provenance.location", description="Where the activity occurred, if relevant", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Provenance:location").toLocked();
    @SearchParamDefinition(name="recorded", path="Provenance.recorded", description="When the activity was recorded / updated", type="date")
    public static final String SP_RECORDED = "recorded";
    public static final DateClientParam RECORDED = new DateClientParam("recorded");
    @SearchParamDefinition(name="agent-role", path="Provenance.agent.role", description="What the agents role was", type="token")
    public static final String SP_AGENT_ROLE = "agent-role";
    public static final TokenClientParam AGENT_ROLE = new TokenClientParam("agent-role");
    @SearchParamDefinition(name="when", path="(Provenance.occurred as dateTime)", description="When the activity occurred", type="date")
    public static final String SP_WHEN = "when";
    public static final DateClientParam WHEN = new DateClientParam("when");
    @SearchParamDefinition(name="entity", path="Provenance.entity.what", description="Identity of entity", type="reference")
    public static final String SP_ENTITY = "entity";
    public static final ReferenceClientParam ENTITY = new ReferenceClientParam("entity");
    public static final Include INCLUDE_ENTITY = new Include("Provenance:entity").toLocked();
    @SearchParamDefinition(name="target", path="Provenance.target", description="Target Reference(s) (usually version specific)", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Provenance:target").toLocked();

    public Provenance() {
    }

    public Provenance(InstantType recorded) {
        this.recorded = recorded;
    }

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public Provenance setTarget(List<Reference> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (Reference item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTarget() {
        Reference t = new Reference();
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return t;
    }

    public Provenance addTarget(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return this;
    }

    public Reference getTargetFirstRep() {
        if (this.getTarget().isEmpty()) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    @Deprecated
    public List<Resource> getTargetTarget() {
        if (this.targetTarget == null) {
            this.targetTarget = new ArrayList<Resource>();
        }
        return this.targetTarget;
    }

    public Type getOccurred() {
        return this.occurred;
    }

    public Period getOccurredPeriod() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new Period();
        }
        if (!(this.occurred instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (Period)this.occurred;
    }

    public boolean hasOccurredPeriod() {
        return this != null && this.occurred instanceof Period;
    }

    public DateTimeType getOccurredDateTimeType() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new DateTimeType();
        }
        if (!(this.occurred instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurred;
    }

    public boolean hasOccurredDateTimeType() {
        return this != null && this.occurred instanceof DateTimeType;
    }

    public boolean hasOccurred() {
        return this.occurred != null && !this.occurred.isEmpty();
    }

    public Provenance setOccurred(Type value) {
        if (value != null && !(value instanceof Period) && !(value instanceof DateTimeType)) {
            throw new Error("Not the right type for Provenance.occurred[x]: " + value.fhirType());
        }
        this.occurred = value;
        return this;
    }

    public InstantType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new InstantType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public Provenance setRecordedElement(InstantType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public Provenance setRecorded(Date value) {
        if (this.recorded == null) {
            this.recorded = new InstantType();
        }
        this.recorded.setValue(value);
        return this;
    }

    public List<UriType> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        return this.policy;
    }

    public Provenance setPolicy(List<UriType> thePolicy) {
        this.policy = thePolicy;
        return this;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (UriType item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addPolicyElement() {
        UriType t = new UriType();
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return t;
    }

    public Provenance addPolicy(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return this;
    }

    public boolean hasPolicy(String value) {
        if (this.policy == null) {
            return false;
        }
        for (UriType v : this.policy) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Provenance setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Provenance setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public Provenance setReason(List<CodeableConcept> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public Provenance addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableConcept getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableConcept getActivity() {
        if (this.activity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.activity");
            }
            if (Configuration.doAutoCreate()) {
                this.activity = new CodeableConcept();
            }
        }
        return this.activity;
    }

    public boolean hasActivity() {
        return this.activity != null && !this.activity.isEmpty();
    }

    public Provenance setActivity(CodeableConcept value) {
        this.activity = value;
        return this;
    }

    public List<ProvenanceAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        return this.agent;
    }

    public Provenance setAgent(List<ProvenanceAgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (ProvenanceAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceAgentComponent addAgent() {
        ProvenanceAgentComponent t = new ProvenanceAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public Provenance addAgent(ProvenanceAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public ProvenanceAgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public List<ProvenanceEntityComponent> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        return this.entity;
    }

    public Provenance setEntity(List<ProvenanceEntityComponent> theEntity) {
        this.entity = theEntity;
        return this;
    }

    public boolean hasEntity() {
        if (this.entity == null) {
            return false;
        }
        for (ProvenanceEntityComponent item : this.entity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceEntityComponent addEntity() {
        ProvenanceEntityComponent t = new ProvenanceEntityComponent();
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return t;
    }

    public Provenance addEntity(ProvenanceEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return this;
    }

    public ProvenanceEntityComponent getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            this.addEntity();
        }
        return this.getEntity().get(0);
    }

    public List<Signature> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        return this.signature;
    }

    public Provenance setSignature(List<Signature> theSignature) {
        this.signature = theSignature;
        return this;
    }

    public boolean hasSignature() {
        if (this.signature == null) {
            return false;
        }
        for (Signature item : this.signature) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Signature addSignature() {
        Signature t = new Signature();
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return t;
    }

    public Provenance addSignature(Signature t) {
        if (t == null) {
            return this;
        }
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return this;
    }

    public Signature getSignatureFirstRep() {
        if (this.getSignature().isEmpty()) {
            this.addSignature();
        }
        return this.getSignature().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_TARGET, "Reference(Any)", "The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred));
        children.add(new Property(SP_RECORDED, "instant", "The instant of time at which the activity was recorded.", 0, 1, this.recorded));
        children.add(new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "Where the activity occurred, if relevant.", 0, 1, this.location));
        children.add(new Property("reason", "CodeableConcept", "The reason that the activity was taking place.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("activity", "CodeableConcept", "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.", 0, 1, this.activity));
        children.add(new Property(SP_AGENT, "", "An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_ENTITY, "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity));
        children.add(new Property("signature", "Signature", "A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.", 0, Integer.MAX_VALUE, this.signature));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -880905839: {
                return new Property(SP_TARGET, "Reference(Any)", "The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target);
            }
            case 784181563: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 792816933: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 894082886: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 1579027424: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case -799233872: {
                return new Property(SP_RECORDED, "instant", "The instant of time at which the activity was recorded.", 0, 1, this.recorded);
            }
            case -982670030: {
                return new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "Where the activity occurred, if relevant.", 0, 1, this.location);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "The reason that the activity was taking place.", 0, Integer.MAX_VALUE, this.reason);
            }
            case -1655966961: {
                return new Property("activity", "CodeableConcept", "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.", 0, 1, this.activity);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent);
            }
            case -1298275357: {
                return new Property(SP_ENTITY, "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity);
            }
            case 1073584312: {
                return new Property("signature", "Signature", "A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.", 0, Integer.MAX_VALUE, this.signature);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case 792816933: {
                Base[] baseArray;
                if (this.occurred == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.occurred;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.recorded;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.location;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -1655966961: {
                Base[] baseArray;
                if (this.activity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.activity;
                }
                return baseArray;
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -1298275357: {
                return this.entity == null ? new Base[]{} : this.entity.toArray(new Base[this.entity.size()]);
            }
            case 1073584312: {
                return this.signature == null ? new Base[]{} : this.signature.toArray(new Base[this.signature.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -880905839: {
                this.getTarget().add(this.castToReference(value));
                return value;
            }
            case 792816933: {
                this.occurred = this.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = this.castToInstant(value);
                return value;
            }
            case -982670030: {
                this.getPolicy().add(this.castToUri(value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1655966961: {
                this.activity = this.castToCodeableConcept(value);
                return value;
            }
            case 92750597: {
                this.getAgent().add((ProvenanceAgentComponent)value);
                return value;
            }
            case -1298275357: {
                this.getEntity().add((ProvenanceEntityComponent)value);
                return value;
            }
            case 1073584312: {
                this.getSignature().add(this.castToSignature(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            this.getTarget().add(this.castToReference(value));
        } else if (name.equals("occurred[x]")) {
            this.occurred = this.castToType(value);
        } else if (name.equals(SP_RECORDED)) {
            this.recorded = this.castToInstant(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add(this.castToUri(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("activity")) {
            this.activity = this.castToCodeableConcept(value);
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((ProvenanceAgentComponent)value);
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().add((ProvenanceEntityComponent)value);
        } else if (name.equals("signature")) {
            this.getSignature().add(this.castToSignature(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.addTarget();
            }
            case 784181563: {
                return this.getOccurred();
            }
            case 792816933: {
                return this.getOccurred();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -982670030: {
                return this.addPolicyElement();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -934964668: {
                return this.addReason();
            }
            case -1655966961: {
                return this.getActivity();
            }
            case 92750597: {
                return this.addAgent();
            }
            case -1298275357: {
                return this.addEntity();
            }
            case 1073584312: {
                return this.addSignature();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return new String[]{"Reference"};
            }
            case 792816933: {
                return new String[]{"Period", "dateTime"};
            }
            case -799233872: {
                return new String[]{"instant"};
            }
            case -982670030: {
                return new String[]{"uri"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case -1655966961: {
                return new String[]{"CodeableConcept"};
            }
            case 92750597: {
                return new String[0];
            }
            case -1298275357: {
                return new String[0];
            }
            case 1073584312: {
                return new String[]{"Signature"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            return this.addTarget();
        }
        if (name.equals("occurredPeriod")) {
            this.occurred = new Period();
            return this.occurred;
        }
        if (name.equals("occurredDateTime")) {
            this.occurred = new DateTimeType();
            return this.occurred;
        }
        if (name.equals(SP_RECORDED)) {
            throw new FHIRException("Cannot call addChild on a singleton property Provenance.recorded");
        }
        if (name.equals("policy")) {
            throw new FHIRException("Cannot call addChild on a singleton property Provenance.policy");
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("activity")) {
            this.activity = new CodeableConcept();
            return this.activity;
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_ENTITY)) {
            return this.addEntity();
        }
        if (name.equals("signature")) {
            return this.addSignature();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Provenance";
    }

    @Override
    public Provenance copy() {
        Provenance dst = new Provenance();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Provenance dst) {
        super.copyValues(dst);
        if (this.target != null) {
            dst.target = new ArrayList<Reference>();
            for (Reference reference : this.target) {
                dst.target.add(reference.copy());
            }
        }
        dst.occurred = this.occurred == null ? null : this.occurred.copy();
        InstantType instantType = dst.recorded = this.recorded == null ? null : this.recorded.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<UriType>();
            for (UriType uriType : this.policy) {
                dst.policy.add(uriType.copy());
            }
        }
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.activity = this.activity == null ? null : this.activity.copy();
        if (this.agent != null) {
            dst.agent = new ArrayList<ProvenanceAgentComponent>();
            for (ProvenanceAgentComponent provenanceAgentComponent : this.agent) {
                dst.agent.add(provenanceAgentComponent.copy());
            }
        }
        if (this.entity != null) {
            dst.entity = new ArrayList<ProvenanceEntityComponent>();
            for (ProvenanceEntityComponent provenanceEntityComponent : this.entity) {
                dst.entity.add(provenanceEntityComponent.copy());
            }
        }
        if (this.signature != null) {
            dst.signature = new ArrayList<Signature>();
            for (Signature signature : this.signature) {
                dst.signature.add(signature.copy());
            }
        }
    }

    protected Provenance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other_;
        return Provenance.compareDeep(this.target, o.target, true) && Provenance.compareDeep(this.occurred, o.occurred, true) && Provenance.compareDeep(this.recorded, o.recorded, true) && Provenance.compareDeep(this.policy, o.policy, true) && Provenance.compareDeep(this.location, o.location, true) && Provenance.compareDeep(this.reason, o.reason, true) && Provenance.compareDeep(this.activity, o.activity, true) && Provenance.compareDeep(this.agent, o.agent, true) && Provenance.compareDeep(this.entity, o.entity, true) && Provenance.compareDeep(this.signature, o.signature, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other_;
        return Provenance.compareValues(this.recorded, o.recorded, true) && Provenance.compareValues(this.policy, o.policy, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.target, this.occurred, this.recorded, this.policy, this.location, this.reason, this.activity, this.agent, this.entity, this.signature});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Provenance;
    }

    @Block
    public static class ProvenanceEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="derivation | revision | quotation | source | removal", formalDefinition="How the entity was used during the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-entity-role")
        protected Enumeration<ProvenanceEntityRole> role;
        @Child(name="what", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identity of entity", formalDefinition="Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.")
        protected Reference what;
        protected Resource whatTarget;
        @Child(name="agent", type={ProvenanceAgentComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity is attributed to this agent", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.")
        protected List<ProvenanceAgentComponent> agent;
        private static final long serialVersionUID = 144967401L;

        public ProvenanceEntityComponent() {
        }

        public ProvenanceEntityComponent(Enumeration<ProvenanceEntityRole> role, Reference what) {
            this.role = role;
            this.what = what;
        }

        public Enumeration<ProvenanceEntityRole> getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvenanceEntityComponent setRoleElement(Enumeration<ProvenanceEntityRole> value) {
            this.role = value;
            return this;
        }

        public ProvenanceEntityRole getRole() {
            return this.role == null ? null : (ProvenanceEntityRole)((Object)this.role.getValue());
        }

        public ProvenanceEntityComponent setRole(ProvenanceEntityRole value) {
            if (this.role == null) {
                this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
            }
            this.role.setValue((Object)value);
            return this;
        }

        public Reference getWhat() {
            if (this.what == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.what");
                }
                if (Configuration.doAutoCreate()) {
                    this.what = new Reference();
                }
            }
            return this.what;
        }

        public boolean hasWhat() {
            return this.what != null && !this.what.isEmpty();
        }

        public ProvenanceEntityComponent setWhat(Reference value) {
            this.what = value;
            return this;
        }

        public Resource getWhatTarget() {
            return this.whatTarget;
        }

        public ProvenanceEntityComponent setWhatTarget(Resource value) {
            this.whatTarget = value;
            return this;
        }

        public List<ProvenanceAgentComponent> getAgent() {
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            return this.agent;
        }

        public ProvenanceEntityComponent setAgent(List<ProvenanceAgentComponent> theAgent) {
            this.agent = theAgent;
            return this;
        }

        public boolean hasAgent() {
            if (this.agent == null) {
                return false;
            }
            for (ProvenanceAgentComponent item : this.agent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvenanceAgentComponent addAgent() {
            ProvenanceAgentComponent t = new ProvenanceAgentComponent();
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            this.agent.add(t);
            return t;
        }

        public ProvenanceEntityComponent addAgent(ProvenanceAgentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            this.agent.add(t);
            return this;
        }

        public ProvenanceAgentComponent getAgentFirstRep() {
            if (this.getAgent().isEmpty()) {
                this.addAgent();
            }
            return this.getAgent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "code", "How the entity was used during the activity.", 0, 1, this.role));
            children.add(new Property("what", "Reference(Any)", "Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.", 0, 1, this.what));
            children.add(new Property(Provenance.SP_AGENT, "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.", 0, Integer.MAX_VALUE, this.agent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "code", "How the entity was used during the activity.", 0, 1, this.role);
                }
                case 3648196: {
                    return new Property("what", "Reference(Any)", "Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.", 0, 1, this.what);
                }
                case 92750597: {
                    return new Property(Provenance.SP_AGENT, "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.", 0, Integer.MAX_VALUE, this.agent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 3648196: {
                    Base[] baseArray;
                    if (this.what == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.what;
                    }
                    return baseArray;
                }
                case 92750597: {
                    return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    value = new ProvenanceEntityRoleEnumFactory().fromType(this.castToCode(value));
                    this.role = value;
                    return value;
                }
                case 3648196: {
                    this.what = this.castToReference(value);
                    return value;
                }
                case 92750597: {
                    this.getAgent().add((ProvenanceAgentComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                value = new ProvenanceEntityRoleEnumFactory().fromType(this.castToCode(value));
                this.role = value;
            } else if (name.equals("what")) {
                this.what = this.castToReference(value);
            } else if (name.equals(Provenance.SP_AGENT)) {
                this.getAgent().add((ProvenanceAgentComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRoleElement();
                }
                case 3648196: {
                    return this.getWhat();
                }
                case 92750597: {
                    return this.addAgent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"code"};
                }
                case 3648196: {
                    return new String[]{"Reference"};
                }
                case 92750597: {
                    return new String[]{"@Provenance.agent"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a singleton property Provenance.role");
            }
            if (name.equals("what")) {
                this.what = new Reference();
                return this.what;
            }
            if (name.equals(Provenance.SP_AGENT)) {
                return this.addAgent();
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceEntityComponent copy() {
            ProvenanceEntityComponent dst = new ProvenanceEntityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvenanceEntityComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            Reference reference = dst.what = this.what == null ? null : this.what.copy();
            if (this.agent != null) {
                dst.agent = new ArrayList<ProvenanceAgentComponent>();
                for (ProvenanceAgentComponent i : this.agent) {
                    dst.agent.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other_;
            return ProvenanceEntityComponent.compareDeep(this.role, o.role, true) && ProvenanceEntityComponent.compareDeep(this.what, o.what, true) && ProvenanceEntityComponent.compareDeep(this.agent, o.agent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other_;
            return ProvenanceEntityComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.role, this.what, this.agent});
        }

        @Override
        public String fhirType() {
            return "Provenance.entity";
        }
    }

    @Block
    public static class ProvenanceAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How the agent participated", formalDefinition="The participation the agent had with respect to the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-type")
        protected CodeableConcept type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What the agents role was", formalDefinition="The function of the agent with respect to the activity. The security role enabling the agent with respect to the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected List<CodeableConcept> role;
        @Child(name="who", type={Practitioner.class, PractitionerRole.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who participated", formalDefinition="The individual, device or organization that participated in the event.")
        protected Reference who;
        protected Resource whoTarget;
        @Child(name="onBehalfOf", type={Practitioner.class, PractitionerRole.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who the agent is representing", formalDefinition="The individual, device, or organization for whom the change was made.")
        protected Reference onBehalfOf;
        protected Resource onBehalfOfTarget;
        private static final long serialVersionUID = -1363252586L;

        public ProvenanceAgentComponent() {
        }

        public ProvenanceAgentComponent(Reference who) {
            this.who = who;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvenanceAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public ProvenanceAgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public ProvenanceAgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public ProvenanceAgentComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Resource getWhoTarget() {
            return this.whoTarget;
        }

        public ProvenanceAgentComponent setWhoTarget(Resource value) {
            this.whoTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ProvenanceAgentComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Resource getOnBehalfOfTarget() {
            return this.onBehalfOfTarget;
        }

        public ProvenanceAgentComponent setOnBehalfOfTarget(Resource value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The participation the agent had with respect to the activity.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The function of the agent with respect to the activity. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role));
            children.add(new Property("who", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Device|Organization)", "The individual, device or organization that participated in the event.", 0, 1, this.who));
            children.add(new Property("onBehalfOf", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Device|Organization)", "The individual, device, or organization for whom the change was made.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The participation the agent had with respect to the activity.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The function of the agent with respect to the activity. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role);
                }
                case 117694: {
                    return new Property("who", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Device|Organization)", "The individual, device or organization that participated in the event.", 0, 1, this.who);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Practitioner|PractitionerRole|RelatedPerson|Patient|Device|Organization)", "The individual, device, or organization for whom the change was made.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.who;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 117694: {
                    this.who = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else if (name.equals("who")) {
                this.who = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3506294: {
                    return this.addRole();
                }
                case 117694: {
                    return this.getWho();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 117694: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceAgentComponent copy() {
            ProvenanceAgentComponent dst = new ProvenanceAgentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvenanceAgentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            dst.who = this.who == null ? null : this.who.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other_;
            return ProvenanceAgentComponent.compareDeep(this.type, o.type, true) && ProvenanceAgentComponent.compareDeep(this.role, o.role, true) && ProvenanceAgentComponent.compareDeep(this.who, o.who, true) && ProvenanceAgentComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.role, this.who, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "Provenance.agent";
        }
    }

    public static class ProvenanceEntityRoleEnumFactory
    implements EnumFactory<ProvenanceEntityRole> {
        @Override
        public ProvenanceEntityRole fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("derivation".equals(codeString)) {
                return ProvenanceEntityRole.DERIVATION;
            }
            if ("revision".equals(codeString)) {
                return ProvenanceEntityRole.REVISION;
            }
            if ("quotation".equals(codeString)) {
                return ProvenanceEntityRole.QUOTATION;
            }
            if ("source".equals(codeString)) {
                return ProvenanceEntityRole.SOURCE;
            }
            if ("removal".equals(codeString)) {
                return ProvenanceEntityRole.REMOVAL;
            }
            throw new IllegalArgumentException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public Enumeration<ProvenanceEntityRole> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.NULL, code);
            }
            if ("derivation".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.DERIVATION, code);
            }
            if ("revision".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REVISION, code);
            }
            if ("quotation".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.QUOTATION, code);
            }
            if ("source".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.SOURCE, code);
            }
            if ("removal".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REMOVAL, code);
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        @Override
        public String toCode(ProvenanceEntityRole code) {
            if (code == ProvenanceEntityRole.DERIVATION) {
                return "derivation";
            }
            if (code == ProvenanceEntityRole.REVISION) {
                return "revision";
            }
            if (code == ProvenanceEntityRole.QUOTATION) {
                return "quotation";
            }
            if (code == ProvenanceEntityRole.SOURCE) {
                return "source";
            }
            if (code == ProvenanceEntityRole.REMOVAL) {
                return "removal";
            }
            return "?";
        }

        @Override
        public String toSystem(ProvenanceEntityRole code) {
            return code.getSystem();
        }
    }

    public static enum ProvenanceEntityRole {
        DERIVATION,
        REVISION,
        QUOTATION,
        SOURCE,
        REMOVAL,
        NULL;


        public static ProvenanceEntityRole fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("derivation".equals(codeString)) {
                return DERIVATION;
            }
            if ("revision".equals(codeString)) {
                return REVISION;
            }
            if ("quotation".equals(codeString)) {
                return QUOTATION;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("removal".equals(codeString)) {
                return REMOVAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DERIVATION: {
                    return "derivation";
                }
                case REVISION: {
                    return "revision";
                }
                case QUOTATION: {
                    return "quotation";
                }
                case SOURCE: {
                    return "source";
                }
                case REMOVAL: {
                    return "removal";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DERIVATION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case REVISION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case QUOTATION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case SOURCE: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case REMOVAL: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DERIVATION: {
                    return "A transformation of an entity into another, an update of an entity resulting in a new one, or the construction of a new entity based on a pre-existing entity.";
                }
                case REVISION: {
                    return "A derivation for which the resulting entity is a revised version of some original.";
                }
                case QUOTATION: {
                    return "The repeat of (some or all of) an entity, such as text or image, by someone who might or might not be its original author.";
                }
                case SOURCE: {
                    return "A primary source for a topic refers to something produced by some agent with direct experience and knowledge about the topic, at the time of the topic's study, without benefit from hindsight.";
                }
                case REMOVAL: {
                    return "A derivation for which the entity is removed from accessibility usually through the use of the Delete operation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DERIVATION: {
                    return "Derivation";
                }
                case REVISION: {
                    return "Revision";
                }
                case QUOTATION: {
                    return "Quotation";
                }
                case SOURCE: {
                    return "Source";
                }
                case REMOVAL: {
                    return "Removal";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

