/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchStudy", profile="http://hl7.org/fhir/StructureDefinition/ResearchStudy")
public class ResearchStudy
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for study", formalDefinition="Identifiers assigned to this research study by the sponsor or other systems.")
    protected List<Identifier> identifier;
    @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this study", formalDefinition="A short, descriptive user-friendly label for the study.")
    protected StringType title;
    @Child(name="protocol", type={PlanDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Steps followed in executing study", formalDefinition="The set of steps expected to be performed as part of the execution of the study.")
    protected List<Reference> protocol;
    protected List<PlanDefinition> protocolTarget;
    @Child(name="partOf", type={ResearchStudy.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of larger study", formalDefinition="A larger research study of which this particular study is a component or step.")
    protected List<Reference> partOf;
    protected List<ResearchStudy> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn", formalDefinition="The current state of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-status")
    protected Enumeration<ResearchStudyStatus> status;
    @Child(name="primaryPurposeType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="treatment | prevention | diagnostic | supportive-care | screening | health-services-research | basic-science | device-feasibility", formalDefinition="The type of study based upon the intent of the study's activities. A classification of the intent of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-prim-purp-type")
    protected CodeableConcept primaryPurposeType;
    @Child(name="phase", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 | phase-4", formalDefinition="The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-phase")
    protected CodeableConcept phase;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classifications for the study", formalDefinition="Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.")
    protected List<CodeableConcept> category;
    @Child(name="focus", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Drugs, devices, etc. under study", formalDefinition="The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.")
    protected List<CodeableConcept> focus;
    @Child(name="condition", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition being studied", formalDefinition="The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableConcept> condition;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the study", formalDefinition="Contact details to assist a user in learning more about or engaging with the study.")
    protected List<ContactDetail> contact;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="References and dependencies", formalDefinition="Citations, references and other related documents.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="keyword", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Used to search for the study", formalDefinition="Key terms to aid in searching for or filtering the study.")
    protected List<CodeableConcept> keyword;
    @Child(name="location", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Geographic region(s) for study", formalDefinition="Indicates a country, state or other region where the study is taking place.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> location;
    @Child(name="description", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What this is study doing", formalDefinition="A full description of how the study is being conducted.")
    protected MarkdownType description;
    @Child(name="enrollment", type={Group.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Inclusion & exclusion criteria", formalDefinition="Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".")
    protected List<Reference> enrollment;
    protected List<Group> enrollmentTarget;
    @Child(name="period", type={Period.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study began and ended", formalDefinition="Identifies the start date and the expected (or actual, depending on status) end date for the study.")
    protected Period period;
    @Child(name="sponsor", type={Organization.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that initiates and is legally responsible for the study", formalDefinition="An organization that initiates the investigation and is legally responsible for the study.")
    protected Reference sponsor;
    protected Organization sponsorTarget;
    @Child(name="principalInvestigator", type={Practitioner.class, PractitionerRole.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Researcher who oversees multiple aspects of the study", formalDefinition="A researcher in a study who oversees multiple aspects of the study, such as concept development, protocol writing, protocol submission for IRB approval, participant recruitment, informed consent, data collection, analysis, interpretation and presentation.")
    protected Reference principalInvestigator;
    protected Resource principalInvestigatorTarget;
    @Child(name="site", type={Location.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Facility where study activities are conducted", formalDefinition="A facility in which study activities are conducted.")
    protected List<Reference> site;
    protected List<Location> siteTarget;
    @Child(name="reasonStopped", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design", formalDefinition="A description and/or code explaining the premature termination of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-reason-stopped")
    protected CodeableConcept reasonStopped;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the study", formalDefinition="Comments made about the study by the performer, subject or other participants.")
    protected List<Annotation> note;
    @Child(name="arm", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Defined path through the study for a subject", formalDefinition="Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.")
    protected List<ResearchStudyArmComponent> arm;
    @Child(name="objective", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A goal for the study", formalDefinition="A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.")
    protected List<ResearchStudyObjectiveComponent> objective;
    private static final long serialVersionUID = -911538323L;
    @SearchParamDefinition(name="date", path="ResearchStudy.period", description="When the study began and ended", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchStudy.identifier", description="Business Identifier for study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="ResearchStudy.partOf", description="Part of larger study", type="reference", target={ResearchStudy.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("ResearchStudy:partof").toLocked();
    @SearchParamDefinition(name="sponsor", path="ResearchStudy.sponsor", description="Organization that initiates and is legally responsible for the study", type="reference", target={Organization.class})
    public static final String SP_SPONSOR = "sponsor";
    public static final ReferenceClientParam SPONSOR = new ReferenceClientParam("sponsor");
    public static final Include INCLUDE_SPONSOR = new Include("ResearchStudy:sponsor").toLocked();
    @SearchParamDefinition(name="focus", path="ResearchStudy.focus", description="Drugs, devices, etc. under study", type="token")
    public static final String SP_FOCUS = "focus";
    public static final TokenClientParam FOCUS = new TokenClientParam("focus");
    @SearchParamDefinition(name="principalinvestigator", path="ResearchStudy.principalInvestigator", description="Researcher who oversees multiple aspects of the study", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_PRINCIPALINVESTIGATOR = "principalinvestigator";
    public static final ReferenceClientParam PRINCIPALINVESTIGATOR = new ReferenceClientParam("principalinvestigator");
    public static final Include INCLUDE_PRINCIPALINVESTIGATOR = new Include("ResearchStudy:principalinvestigator").toLocked();
    @SearchParamDefinition(name="title", path="ResearchStudy.title", description="Name for this study", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="protocol", path="ResearchStudy.protocol", description="Steps followed in executing study", type="reference", target={PlanDefinition.class})
    public static final String SP_PROTOCOL = "protocol";
    public static final ReferenceClientParam PROTOCOL = new ReferenceClientParam("protocol");
    public static final Include INCLUDE_PROTOCOL = new Include("ResearchStudy:protocol").toLocked();
    @SearchParamDefinition(name="site", path="ResearchStudy.site", description="Facility where study activities are conducted", type="reference", target={Location.class})
    public static final String SP_SITE = "site";
    public static final ReferenceClientParam SITE = new ReferenceClientParam("site");
    public static final Include INCLUDE_SITE = new Include("ResearchStudy:site").toLocked();
    @SearchParamDefinition(name="location", path="ResearchStudy.location", description="Geographic region(s) for study", type="token")
    public static final String SP_LOCATION = "location";
    public static final TokenClientParam LOCATION = new TokenClientParam("location");
    @SearchParamDefinition(name="category", path="ResearchStudy.category", description="Classifications for the study", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="keyword", path="ResearchStudy.keyword", description="Used to search for the study", type="token")
    public static final String SP_KEYWORD = "keyword";
    public static final TokenClientParam KEYWORD = new TokenClientParam("keyword");
    @SearchParamDefinition(name="status", path="ResearchStudy.status", description="active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ResearchStudy() {
    }

    public ResearchStudy(Enumeration<ResearchStudyStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ResearchStudy setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ResearchStudy setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<Reference> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        return this.protocol;
    }

    public ResearchStudy setProtocol(List<Reference> theProtocol) {
        this.protocol = theProtocol;
        return this;
    }

    public boolean hasProtocol() {
        if (this.protocol == null) {
            return false;
        }
        for (Reference item : this.protocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProtocol() {
        Reference t = new Reference();
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return t;
    }

    public ResearchStudy addProtocol(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return this;
    }

    public Reference getProtocolFirstRep() {
        if (this.getProtocol().isEmpty()) {
            this.addProtocol();
        }
        return this.getProtocol().get(0);
    }

    @Deprecated
    public List<PlanDefinition> getProtocolTarget() {
        if (this.protocolTarget == null) {
            this.protocolTarget = new ArrayList<PlanDefinition>();
        }
        return this.protocolTarget;
    }

    @Deprecated
    public PlanDefinition addProtocolTarget() {
        PlanDefinition r = new PlanDefinition();
        if (this.protocolTarget == null) {
            this.protocolTarget = new ArrayList<PlanDefinition>();
        }
        this.protocolTarget.add(r);
        return r;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public ResearchStudy setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public ResearchStudy addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<ResearchStudy> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<ResearchStudy>();
        }
        return this.partOfTarget;
    }

    @Deprecated
    public ResearchStudy addPartOfTarget() {
        ResearchStudy r = new ResearchStudy();
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<ResearchStudy>();
        }
        this.partOfTarget.add(r);
        return r;
    }

    public Enumeration<ResearchStudyStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ResearchStudyStatus>(new ResearchStudyStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchStudy setStatusElement(Enumeration<ResearchStudyStatus> value) {
        this.status = value;
        return this;
    }

    public ResearchStudyStatus getStatus() {
        return this.status == null ? null : (ResearchStudyStatus)((Object)this.status.getValue());
    }

    public ResearchStudy setStatus(ResearchStudyStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ResearchStudyStatus>(new ResearchStudyStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getPrimaryPurposeType() {
        if (this.primaryPurposeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.primaryPurposeType");
            }
            if (Configuration.doAutoCreate()) {
                this.primaryPurposeType = new CodeableConcept();
            }
        }
        return this.primaryPurposeType;
    }

    public boolean hasPrimaryPurposeType() {
        return this.primaryPurposeType != null && !this.primaryPurposeType.isEmpty();
    }

    public ResearchStudy setPrimaryPurposeType(CodeableConcept value) {
        this.primaryPurposeType = value;
        return this;
    }

    public CodeableConcept getPhase() {
        if (this.phase == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.phase");
            }
            if (Configuration.doAutoCreate()) {
                this.phase = new CodeableConcept();
            }
        }
        return this.phase;
    }

    public boolean hasPhase() {
        return this.phase != null && !this.phase.isEmpty();
    }

    public ResearchStudy setPhase(CodeableConcept value) {
        this.phase = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ResearchStudy setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ResearchStudy addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        return this.focus;
    }

    public ResearchStudy setFocus(List<CodeableConcept> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (CodeableConcept item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFocus() {
        CodeableConcept t = new CodeableConcept();
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        this.focus.add(t);
        return t;
    }

    public ResearchStudy addFocus(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        this.focus.add(t);
        return this;
    }

    public CodeableConcept getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public List<CodeableConcept> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        return this.condition;
    }

    public ResearchStudy setCondition(List<CodeableConcept> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (CodeableConcept item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCondition() {
        CodeableConcept t = new CodeableConcept();
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return t;
    }

    public ResearchStudy addCondition(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return this;
    }

    public CodeableConcept getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public ResearchStudy setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public ResearchStudy addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ResearchStudy setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ResearchStudy addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CodeableConcept> getKeyword() {
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        return this.keyword;
    }

    public ResearchStudy setKeyword(List<CodeableConcept> theKeyword) {
        this.keyword = theKeyword;
        return this;
    }

    public boolean hasKeyword() {
        if (this.keyword == null) {
            return false;
        }
        for (CodeableConcept item : this.keyword) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addKeyword() {
        CodeableConcept t = new CodeableConcept();
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return t;
    }

    public ResearchStudy addKeyword(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return this;
    }

    public CodeableConcept getKeywordFirstRep() {
        if (this.getKeyword().isEmpty()) {
            this.addKeyword();
        }
        return this.getKeyword().get(0);
    }

    public List<CodeableConcept> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<CodeableConcept>();
        }
        return this.location;
    }

    public ResearchStudy setLocation(List<CodeableConcept> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (CodeableConcept item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addLocation() {
        CodeableConcept t = new CodeableConcept();
        if (this.location == null) {
            this.location = new ArrayList<CodeableConcept>();
        }
        this.location.add(t);
        return t;
    }

    public ResearchStudy addLocation(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<CodeableConcept>();
        }
        this.location.add(t);
        return this;
    }

    public CodeableConcept getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ResearchStudy setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ResearchStudy setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getEnrollment() {
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        return this.enrollment;
    }

    public ResearchStudy setEnrollment(List<Reference> theEnrollment) {
        this.enrollment = theEnrollment;
        return this;
    }

    public boolean hasEnrollment() {
        if (this.enrollment == null) {
            return false;
        }
        for (Reference item : this.enrollment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEnrollment() {
        Reference t = new Reference();
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        this.enrollment.add(t);
        return t;
    }

    public ResearchStudy addEnrollment(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        this.enrollment.add(t);
        return this;
    }

    public Reference getEnrollmentFirstRep() {
        if (this.getEnrollment().isEmpty()) {
            this.addEnrollment();
        }
        return this.getEnrollment().get(0);
    }

    @Deprecated
    public List<Group> getEnrollmentTarget() {
        if (this.enrollmentTarget == null) {
            this.enrollmentTarget = new ArrayList<Group>();
        }
        return this.enrollmentTarget;
    }

    @Deprecated
    public Group addEnrollmentTarget() {
        Group r = new Group();
        if (this.enrollmentTarget == null) {
            this.enrollmentTarget = new ArrayList<Group>();
        }
        this.enrollmentTarget.add(r);
        return r;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchStudy setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getSponsor() {
        if (this.sponsor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.sponsor");
            }
            if (Configuration.doAutoCreate()) {
                this.sponsor = new Reference();
            }
        }
        return this.sponsor;
    }

    public boolean hasSponsor() {
        return this.sponsor != null && !this.sponsor.isEmpty();
    }

    public ResearchStudy setSponsor(Reference value) {
        this.sponsor = value;
        return this;
    }

    public Organization getSponsorTarget() {
        if (this.sponsorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.sponsor");
            }
            if (Configuration.doAutoCreate()) {
                this.sponsorTarget = new Organization();
            }
        }
        return this.sponsorTarget;
    }

    public ResearchStudy setSponsorTarget(Organization value) {
        this.sponsorTarget = value;
        return this;
    }

    public Reference getPrincipalInvestigator() {
        if (this.principalInvestigator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.principalInvestigator");
            }
            if (Configuration.doAutoCreate()) {
                this.principalInvestigator = new Reference();
            }
        }
        return this.principalInvestigator;
    }

    public boolean hasPrincipalInvestigator() {
        return this.principalInvestigator != null && !this.principalInvestigator.isEmpty();
    }

    public ResearchStudy setPrincipalInvestigator(Reference value) {
        this.principalInvestigator = value;
        return this;
    }

    public Resource getPrincipalInvestigatorTarget() {
        return this.principalInvestigatorTarget;
    }

    public ResearchStudy setPrincipalInvestigatorTarget(Resource value) {
        this.principalInvestigatorTarget = value;
        return this;
    }

    public List<Reference> getSite() {
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        return this.site;
    }

    public ResearchStudy setSite(List<Reference> theSite) {
        this.site = theSite;
        return this;
    }

    public boolean hasSite() {
        if (this.site == null) {
            return false;
        }
        for (Reference item : this.site) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSite() {
        Reference t = new Reference();
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return t;
    }

    public ResearchStudy addSite(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return this;
    }

    public Reference getSiteFirstRep() {
        if (this.getSite().isEmpty()) {
            this.addSite();
        }
        return this.getSite().get(0);
    }

    @Deprecated
    public List<Location> getSiteTarget() {
        if (this.siteTarget == null) {
            this.siteTarget = new ArrayList<Location>();
        }
        return this.siteTarget;
    }

    @Deprecated
    public Location addSiteTarget() {
        Location r = new Location();
        if (this.siteTarget == null) {
            this.siteTarget = new ArrayList<Location>();
        }
        this.siteTarget.add(r);
        return r;
    }

    public CodeableConcept getReasonStopped() {
        if (this.reasonStopped == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.reasonStopped");
            }
            if (Configuration.doAutoCreate()) {
                this.reasonStopped = new CodeableConcept();
            }
        }
        return this.reasonStopped;
    }

    public boolean hasReasonStopped() {
        return this.reasonStopped != null && !this.reasonStopped.isEmpty();
    }

    public ResearchStudy setReasonStopped(CodeableConcept value) {
        this.reasonStopped = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ResearchStudy setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ResearchStudy addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ResearchStudyArmComponent> getArm() {
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        return this.arm;
    }

    public ResearchStudy setArm(List<ResearchStudyArmComponent> theArm) {
        this.arm = theArm;
        return this;
    }

    public boolean hasArm() {
        if (this.arm == null) {
            return false;
        }
        for (ResearchStudyArmComponent item : this.arm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyArmComponent addArm() {
        ResearchStudyArmComponent t = new ResearchStudyArmComponent();
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        this.arm.add(t);
        return t;
    }

    public ResearchStudy addArm(ResearchStudyArmComponent t) {
        if (t == null) {
            return this;
        }
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        this.arm.add(t);
        return this;
    }

    public ResearchStudyArmComponent getArmFirstRep() {
        if (this.getArm().isEmpty()) {
            this.addArm();
        }
        return this.getArm().get(0);
    }

    public List<ResearchStudyObjectiveComponent> getObjective() {
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        return this.objective;
    }

    public ResearchStudy setObjective(List<ResearchStudyObjectiveComponent> theObjective) {
        this.objective = theObjective;
        return this;
    }

    public boolean hasObjective() {
        if (this.objective == null) {
            return false;
        }
        for (ResearchStudyObjectiveComponent item : this.objective) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyObjectiveComponent addObjective() {
        ResearchStudyObjectiveComponent t = new ResearchStudyObjectiveComponent();
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        this.objective.add(t);
        return t;
    }

    public ResearchStudy addObjective(ResearchStudyObjectiveComponent t) {
        if (t == null) {
            return this;
        }
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        this.objective.add(t);
        return this;
    }

    public ResearchStudyObjectiveComponent getObjectiveFirstRep() {
        if (this.getObjective().isEmpty()) {
            this.addObjective();
        }
        return this.getObjective().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive user-friendly label for the study.", 0, 1, this.title));
        children.add(new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol));
        children.add(new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "The current state of the study.", 0, 1, this.status));
        children.add(new Property("primaryPurposeType", "CodeableConcept", "The type of study based upon the intent of the study's activities. A classification of the intent of the study.", 0, 1, this.primaryPurposeType));
        children.add(new Property("phase", "CodeableConcept", "The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.", 0, 1, this.phase));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_FOCUS, "CodeableConcept", "The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("condition", "CodeableConcept", "The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in learning more about or engaging with the study.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Citations, references and other related documents.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword));
        children.add(new Property(SP_LOCATION, "CodeableConcept", "Indicates a country, state or other region where the study is taking place.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("description", "markdown", "A full description of how the study is being conducted.", 0, 1, this.description));
        children.add(new Property("enrollment", "Reference(Group)", "Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".", 0, Integer.MAX_VALUE, this.enrollment));
        children.add(new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period));
        children.add(new Property(SP_SPONSOR, "Reference(Organization)", "An organization that initiates the investigation and is legally responsible for the study.", 0, 1, this.sponsor));
        children.add(new Property("principalInvestigator", "Reference(Practitioner|PractitionerRole)", "A researcher in a study who oversees multiple aspects of the study, such as concept development, protocol writing, protocol submission for IRB approval, participant recruitment, informed consent, data collection, analysis, interpretation and presentation.", 0, 1, this.principalInvestigator));
        children.add(new Property(SP_SITE, "Reference(Location)", "A facility in which study activities are conducted.", 0, Integer.MAX_VALUE, this.site));
        children.add(new Property("reasonStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.reasonStopped));
        children.add(new Property("note", "Annotation", "Comments made about the study by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("arm", "", "Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.", 0, Integer.MAX_VALUE, this.arm));
        children.add(new Property("objective", "", "A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.", 0, Integer.MAX_VALUE, this.objective));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive user-friendly label for the study.", 0, 1, this.title);
            }
            case -989163880: {
                return new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol);
            }
            case -995410646: {
                return new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the study.", 0, 1, this.status);
            }
            case -2132842986: {
                return new Property("primaryPurposeType", "CodeableConcept", "The type of study based upon the intent of the study's activities. A classification of the intent of the study.", 0, 1, this.primaryPurposeType);
            }
            case 106629499: {
                return new Property("phase", "CodeableConcept", "The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.", 0, 1, this.phase);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "CodeableConcept", "The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus);
            }
            case -861311717: {
                return new Property("condition", "CodeableConcept", "The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.", 0, Integer.MAX_VALUE, this.condition);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in learning more about or engaging with the study.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Citations, references and other related documents.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -814408215: {
                return new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "CodeableConcept", "Indicates a country, state or other region where the study is taking place.", 0, Integer.MAX_VALUE, this.location);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A full description of how the study is being conducted.", 0, 1, this.description);
            }
            case 116089604: {
                return new Property("enrollment", "Reference(Group)", "Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".", 0, Integer.MAX_VALUE, this.enrollment);
            }
            case -991726143: {
                return new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period);
            }
            case -1998892262: {
                return new Property(SP_SPONSOR, "Reference(Organization)", "An organization that initiates the investigation and is legally responsible for the study.", 0, 1, this.sponsor);
            }
            case 1437117175: {
                return new Property("principalInvestigator", "Reference(Practitioner|PractitionerRole)", "A researcher in a study who oversees multiple aspects of the study, such as concept development, protocol writing, protocol submission for IRB approval, participant recruitment, informed consent, data collection, analysis, interpretation and presentation.", 0, 1, this.principalInvestigator);
            }
            case 3530567: {
                return new Property(SP_SITE, "Reference(Location)", "A facility in which study activities are conducted.", 0, Integer.MAX_VALUE, this.site);
            }
            case 1181369065: {
                return new Property("reasonStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.reasonStopped);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the study by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
            case 96860: {
                return new Property("arm", "", "Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.", 0, Integer.MAX_VALUE, this.arm);
            }
            case -1489585863: {
                return new Property("objective", "", "A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.", 0, Integer.MAX_VALUE, this.objective);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.title;
                }
                return baseArray;
            }
            case -989163880: {
                return this.protocol == null ? new Base[]{} : this.protocol.toArray(new Base[this.protocol.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -2132842986: {
                Base[] baseArray;
                if (this.primaryPurposeType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.primaryPurposeType;
                }
                return baseArray;
            }
            case 106629499: {
                Base[] baseArray;
                if (this.phase == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.phase;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -814408215: {
                return this.keyword == null ? new Base[]{} : this.keyword.toArray(new Base[this.keyword.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case 116089604: {
                return this.enrollment == null ? new Base[]{} : this.enrollment.toArray(new Base[this.enrollment.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.period;
                }
                return baseArray;
            }
            case -1998892262: {
                Base[] baseArray;
                if (this.sponsor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.sponsor;
                }
                return baseArray;
            }
            case 1437117175: {
                Base[] baseArray;
                if (this.principalInvestigator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.principalInvestigator;
                }
                return baseArray;
            }
            case 3530567: {
                return this.site == null ? new Base[]{} : this.site.toArray(new Base[this.site.size()]);
            }
            case 1181369065: {
                Base[] baseArray;
                if (this.reasonStopped == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reasonStopped;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 96860: {
                return this.arm == null ? new Base[]{} : this.arm.toArray(new Base[this.arm.size()]);
            }
            case -1489585863: {
                return this.objective == null ? new Base[]{} : this.objective.toArray(new Base[this.objective.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -989163880: {
                this.getProtocol().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new ResearchStudyStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -2132842986: {
                this.primaryPurposeType = this.castToCodeableConcept(value);
                return value;
            }
            case 106629499: {
                this.phase = this.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 97604824: {
                this.getFocus().add(this.castToCodeableConcept(value));
                return value;
            }
            case -861311717: {
                this.getCondition().add(this.castToCodeableConcept(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case -814408215: {
                this.getKeyword().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 116089604: {
                this.getEnrollment().add(this.castToReference(value));
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1998892262: {
                this.sponsor = this.castToReference(value);
                return value;
            }
            case 1437117175: {
                this.principalInvestigator = this.castToReference(value);
                return value;
            }
            case 3530567: {
                this.getSite().add(this.castToReference(value));
                return value;
            }
            case 1181369065: {
                this.reasonStopped = this.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 96860: {
                this.getArm().add((ResearchStudyArmComponent)((Object)value));
                return value;
            }
            case -1489585863: {
                this.getObjective().add((ResearchStudyObjectiveComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_PROTOCOL)) {
            this.getProtocol().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ResearchStudyStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("primaryPurposeType")) {
            this.primaryPurposeType = this.castToCodeableConcept(value);
        } else if (name.equals("phase")) {
            this.phase = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(this.castToCodeableConcept(value));
        } else if (name.equals("condition")) {
            this.getCondition().add(this.castToCodeableConcept(value));
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals(SP_KEYWORD)) {
            this.getKeyword().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("enrollment")) {
            this.getEnrollment().add(this.castToReference(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_SPONSOR)) {
            this.sponsor = this.castToReference(value);
        } else if (name.equals("principalInvestigator")) {
            this.principalInvestigator = this.castToReference(value);
        } else if (name.equals(SP_SITE)) {
            this.getSite().add(this.castToReference(value));
        } else if (name.equals("reasonStopped")) {
            this.reasonStopped = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("arm")) {
            this.getArm().add((ResearchStudyArmComponent)((Object)value));
        } else if (name.equals("objective")) {
            this.getObjective().add((ResearchStudyObjectiveComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -989163880: {
                return this.addProtocol();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -2132842986: {
                return this.getPrimaryPurposeType();
            }
            case 106629499: {
                return this.getPhase();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 97604824: {
                return this.addFocus();
            }
            case -861311717: {
                return this.addCondition();
            }
            case 951526432: {
                return this.addContact();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -814408215: {
                return this.addKeyword();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 116089604: {
                return this.addEnrollment();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1998892262: {
                return this.getSponsor();
            }
            case 1437117175: {
                return this.getPrincipalInvestigator();
            }
            case 3530567: {
                return this.addSite();
            }
            case 1181369065: {
                return this.getReasonStopped();
            }
            case 3387378: {
                return this.addNote();
            }
            case 96860: {
                return this.addArm();
            }
            case -1489585863: {
                return this.addObjective();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -989163880: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -2132842986: {
                return new String[]{"CodeableConcept"};
            }
            case 106629499: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 97604824: {
                return new String[]{"CodeableConcept"};
            }
            case -861311717: {
                return new String[]{"CodeableConcept"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -814408215: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 116089604: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1998892262: {
                return new String[]{"Reference"};
            }
            case 1437117175: {
                return new String[]{"Reference"};
            }
            case 3530567: {
                return new String[]{"Reference"};
            }
            case 1181369065: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 96860: {
                return new String[0];
            }
            case -1489585863: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.title");
        }
        if (name.equals(SP_PROTOCOL)) {
            return this.addProtocol();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.status");
        }
        if (name.equals("primaryPurposeType")) {
            this.primaryPurposeType = new CodeableConcept();
            return this.primaryPurposeType;
        }
        if (name.equals("phase")) {
            this.phase = new CodeableConcept();
            return this.phase;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals(SP_KEYWORD)) {
            return this.addKeyword();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.description");
        }
        if (name.equals("enrollment")) {
            return this.addEnrollment();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_SPONSOR)) {
            this.sponsor = new Reference();
            return this.sponsor;
        }
        if (name.equals("principalInvestigator")) {
            this.principalInvestigator = new Reference();
            return this.principalInvestigator;
        }
        if (name.equals(SP_SITE)) {
            return this.addSite();
        }
        if (name.equals("reasonStopped")) {
            this.reasonStopped = new CodeableConcept();
            return this.reasonStopped;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("arm")) {
            return this.addArm();
        }
        if (name.equals("objective")) {
            return this.addObjective();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchStudy";
    }

    @Override
    public ResearchStudy copy() {
        ResearchStudy dst = new ResearchStudy();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchStudy dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.protocol != null) {
            dst.protocol = new ArrayList<Reference>();
            for (Reference reference : this.protocol) {
                dst.protocol.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.primaryPurposeType = this.primaryPurposeType == null ? null : this.primaryPurposeType.copy();
        CodeableConcept codeableConcept = dst.phase = this.phase == null ? null : this.phase.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        if (this.focus != null) {
            dst.focus = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.focus) {
                dst.focus.add(codeableConcept3.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.condition) {
                dst.condition.add(codeableConcept4.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.keyword != null) {
            dst.keyword = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.keyword) {
                dst.keyword.add(codeableConcept5.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept6 : this.location) {
                dst.location.add(codeableConcept6.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.enrollment != null) {
            dst.enrollment = new ArrayList<Reference>();
            for (Reference reference : this.enrollment) {
                dst.enrollment.add(reference.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.sponsor = this.sponsor == null ? null : this.sponsor.copy();
        Reference reference = dst.principalInvestigator = this.principalInvestigator == null ? null : this.principalInvestigator.copy();
        if (this.site != null) {
            dst.site = new ArrayList<Reference>();
            for (Reference reference2 : this.site) {
                dst.site.add(reference2.copy());
            }
        }
        CodeableConcept codeableConcept7 = dst.reasonStopped = this.reasonStopped == null ? null : this.reasonStopped.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.arm != null) {
            dst.arm = new ArrayList<ResearchStudyArmComponent>();
            for (ResearchStudyArmComponent researchStudyArmComponent : this.arm) {
                dst.arm.add(researchStudyArmComponent.copy());
            }
        }
        if (this.objective != null) {
            dst.objective = new ArrayList<ResearchStudyObjectiveComponent>();
            for (ResearchStudyObjectiveComponent researchStudyObjectiveComponent : this.objective) {
                dst.objective.add(researchStudyObjectiveComponent.copy());
            }
        }
    }

    protected ResearchStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareDeep(this.identifier, o.identifier, true) && ResearchStudy.compareDeep(this.title, o.title, true) && ResearchStudy.compareDeep(this.protocol, o.protocol, true) && ResearchStudy.compareDeep(this.partOf, o.partOf, true) && ResearchStudy.compareDeep(this.status, o.status, true) && ResearchStudy.compareDeep(this.primaryPurposeType, o.primaryPurposeType, true) && ResearchStudy.compareDeep(this.phase, o.phase, true) && ResearchStudy.compareDeep(this.category, o.category, true) && ResearchStudy.compareDeep(this.focus, o.focus, true) && ResearchStudy.compareDeep(this.condition, o.condition, true) && ResearchStudy.compareDeep(this.contact, o.contact, true) && ResearchStudy.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ResearchStudy.compareDeep(this.keyword, o.keyword, true) && ResearchStudy.compareDeep(this.location, o.location, true) && ResearchStudy.compareDeep(this.description, o.description, true) && ResearchStudy.compareDeep(this.enrollment, o.enrollment, true) && ResearchStudy.compareDeep(this.period, o.period, true) && ResearchStudy.compareDeep(this.sponsor, o.sponsor, true) && ResearchStudy.compareDeep(this.principalInvestigator, o.principalInvestigator, true) && ResearchStudy.compareDeep(this.site, o.site, true) && ResearchStudy.compareDeep(this.reasonStopped, o.reasonStopped, true) && ResearchStudy.compareDeep(this.note, o.note, true) && ResearchStudy.compareDeep(this.arm, o.arm, true) && ResearchStudy.compareDeep(this.objective, o.objective, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareValues(this.title, o.title, true) && ResearchStudy.compareValues(this.status, o.status, true) && ResearchStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.title, this.protocol, this.partOf, this.status, this.primaryPurposeType, this.phase, this.category, this.focus, this.condition, this.contact, this.relatedArtifact, this.keyword, this.location, this.description, this.enrollment, this.period, this.sponsor, this.principalInvestigator, this.site, this.reasonStopped, this.note, this.arm, this.objective});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchStudy;
    }

    @Block
    public static class ResearchStudyObjectiveComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the objective", formalDefinition="Unique, human-readable label for this objective of the study.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="primary | secondary | exploratory", formalDefinition="The kind of study objective.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-objective-type")
        protected CodeableConcept type;
        private static final long serialVersionUID = -1935215997L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyObjectiveComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyObjectiveComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyObjectiveComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyObjectiveComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchStudyObjectiveComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Unique, human-readable label for this objective of the study.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "The kind of study objective.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Unique, human-readable label for this objective of the study.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of study objective.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyObjectiveComponent copy() {
            ResearchStudyObjectiveComponent dst = new ResearchStudyObjectiveComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyObjectiveComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyObjectiveComponent)) {
                return false;
            }
            ResearchStudyObjectiveComponent o = (ResearchStudyObjectiveComponent)other_;
            return ResearchStudyObjectiveComponent.compareDeep(this.name, o.name, true) && ResearchStudyObjectiveComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyObjectiveComponent)) {
                return false;
            }
            ResearchStudyObjectiveComponent o = (ResearchStudyObjectiveComponent)other_;
            return ResearchStudyObjectiveComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.objective";
        }
    }

    @Block
    public static class ResearchStudyArmComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for study arm", formalDefinition="Unique, human-readable label for this arm of the study.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Categorization of study arm", formalDefinition="Categorization of study arm, e.g. experimental, active comparator, placebo comparater.")
        protected CodeableConcept type;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short explanation of study path", formalDefinition="A succinct description of the path through the study that would be followed by a subject adhering to this arm.")
        protected StringType description;
        private static final long serialVersionUID = 311445244L;

        public ResearchStudyArmComponent() {
        }

        public ResearchStudyArmComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyArmComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyArmComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchStudyArmComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ResearchStudyArmComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ResearchStudyArmComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Unique, human-readable label for this arm of the study.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "Categorization of study arm, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.type));
            children.add(new Property("description", "string", "A succinct description of the path through the study that would be followed by a subject adhering to this arm.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Unique, human-readable label for this arm of the study.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Categorization of study arm, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "string", "A succinct description of the path through the study that would be followed by a subject adhering to this arm.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.description");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyArmComponent copy() {
            ResearchStudyArmComponent dst = new ResearchStudyArmComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyArmComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyArmComponent)) {
                return false;
            }
            ResearchStudyArmComponent o = (ResearchStudyArmComponent)other_;
            return ResearchStudyArmComponent.compareDeep(this.name, o.name, true) && ResearchStudyArmComponent.compareDeep(this.type, o.type, true) && ResearchStudyArmComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyArmComponent)) {
                return false;
            }
            ResearchStudyArmComponent o = (ResearchStudyArmComponent)other_;
            return ResearchStudyArmComponent.compareValues(this.name, o.name, true) && ResearchStudyArmComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type, this.description});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.arm";
        }
    }

    public static class ResearchStudyStatusEnumFactory
    implements EnumFactory<ResearchStudyStatus> {
        @Override
        public ResearchStudyStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ResearchStudyStatus.ACTIVE;
            }
            if ("administratively-completed".equals(codeString)) {
                return ResearchStudyStatus.ADMINISTRATIVELYCOMPLETED;
            }
            if ("approved".equals(codeString)) {
                return ResearchStudyStatus.APPROVED;
            }
            if ("closed-to-accrual".equals(codeString)) {
                return ResearchStudyStatus.CLOSEDTOACCRUAL;
            }
            if ("closed-to-accrual-and-intervention".equals(codeString)) {
                return ResearchStudyStatus.CLOSEDTOACCRUALANDINTERVENTION;
            }
            if ("completed".equals(codeString)) {
                return ResearchStudyStatus.COMPLETED;
            }
            if ("disapproved".equals(codeString)) {
                return ResearchStudyStatus.DISAPPROVED;
            }
            if ("in-review".equals(codeString)) {
                return ResearchStudyStatus.INREVIEW;
            }
            if ("temporarily-closed-to-accrual".equals(codeString)) {
                return ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUAL;
            }
            if ("temporarily-closed-to-accrual-and-intervention".equals(codeString)) {
                return ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION;
            }
            if ("withdrawn".equals(codeString)) {
                return ResearchStudyStatus.WITHDRAWN;
            }
            throw new IllegalArgumentException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        public Enumeration<ResearchStudyStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.ACTIVE, code);
            }
            if ("administratively-completed".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.ADMINISTRATIVELYCOMPLETED, code);
            }
            if ("approved".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.APPROVED, code);
            }
            if ("closed-to-accrual".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.CLOSEDTOACCRUAL, code);
            }
            if ("closed-to-accrual-and-intervention".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.CLOSEDTOACCRUALANDINTERVENTION, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.COMPLETED, code);
            }
            if ("disapproved".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.DISAPPROVED, code);
            }
            if ("in-review".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.INREVIEW, code);
            }
            if ("temporarily-closed-to-accrual".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUAL, code);
            }
            if ("temporarily-closed-to-accrual-and-intervention".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION, code);
            }
            if ("withdrawn".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.WITHDRAWN, code);
            }
            throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ResearchStudyStatus code) {
            if (code == ResearchStudyStatus.ACTIVE) {
                return "active";
            }
            if (code == ResearchStudyStatus.ADMINISTRATIVELYCOMPLETED) {
                return "administratively-completed";
            }
            if (code == ResearchStudyStatus.APPROVED) {
                return "approved";
            }
            if (code == ResearchStudyStatus.CLOSEDTOACCRUAL) {
                return "closed-to-accrual";
            }
            if (code == ResearchStudyStatus.CLOSEDTOACCRUALANDINTERVENTION) {
                return "closed-to-accrual-and-intervention";
            }
            if (code == ResearchStudyStatus.COMPLETED) {
                return "completed";
            }
            if (code == ResearchStudyStatus.DISAPPROVED) {
                return "disapproved";
            }
            if (code == ResearchStudyStatus.INREVIEW) {
                return "in-review";
            }
            if (code == ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUAL) {
                return "temporarily-closed-to-accrual";
            }
            if (code == ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION) {
                return "temporarily-closed-to-accrual-and-intervention";
            }
            if (code == ResearchStudyStatus.WITHDRAWN) {
                return "withdrawn";
            }
            return "?";
        }

        @Override
        public String toSystem(ResearchStudyStatus code) {
            return code.getSystem();
        }
    }

    public static enum ResearchStudyStatus {
        ACTIVE,
        ADMINISTRATIVELYCOMPLETED,
        APPROVED,
        CLOSEDTOACCRUAL,
        CLOSEDTOACCRUALANDINTERVENTION,
        COMPLETED,
        DISAPPROVED,
        INREVIEW,
        TEMPORARILYCLOSEDTOACCRUAL,
        TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION,
        WITHDRAWN,
        NULL;


        public static ResearchStudyStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("administratively-completed".equals(codeString)) {
                return ADMINISTRATIVELYCOMPLETED;
            }
            if ("approved".equals(codeString)) {
                return APPROVED;
            }
            if ("closed-to-accrual".equals(codeString)) {
                return CLOSEDTOACCRUAL;
            }
            if ("closed-to-accrual-and-intervention".equals(codeString)) {
                return CLOSEDTOACCRUALANDINTERVENTION;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("disapproved".equals(codeString)) {
                return DISAPPROVED;
            }
            if ("in-review".equals(codeString)) {
                return INREVIEW;
            }
            if ("temporarily-closed-to-accrual".equals(codeString)) {
                return TEMPORARILYCLOSEDTOACCRUAL;
            }
            if ("temporarily-closed-to-accrual-and-intervention".equals(codeString)) {
                return TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION;
            }
            if ("withdrawn".equals(codeString)) {
                return WITHDRAWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ADMINISTRATIVELYCOMPLETED: {
                    return "administratively-completed";
                }
                case APPROVED: {
                    return "approved";
                }
                case CLOSEDTOACCRUAL: {
                    return "closed-to-accrual";
                }
                case CLOSEDTOACCRUALANDINTERVENTION: {
                    return "closed-to-accrual-and-intervention";
                }
                case COMPLETED: {
                    return "completed";
                }
                case DISAPPROVED: {
                    return "disapproved";
                }
                case INREVIEW: {
                    return "in-review";
                }
                case TEMPORARILYCLOSEDTOACCRUAL: {
                    return "temporarily-closed-to-accrual";
                }
                case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                    return "temporarily-closed-to-accrual-and-intervention";
                }
                case WITHDRAWN: {
                    return "withdrawn";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case ADMINISTRATIVELYCOMPLETED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case APPROVED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case CLOSEDTOACCRUAL: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case CLOSEDTOACCRUALANDINTERVENTION: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case DISAPPROVED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case INREVIEW: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case TEMPORARILYCLOSEDTOACCRUAL: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case WITHDRAWN: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "Study is opened for accrual.";
                }
                case ADMINISTRATIVELYCOMPLETED: {
                    return "Study is completed prematurely and will not resume; patients are no longer examined nor treated.";
                }
                case APPROVED: {
                    return "Protocol is approved by the review board.";
                }
                case CLOSEDTOACCRUAL: {
                    return "Study is closed for accrual; patients can be examined and treated.";
                }
                case CLOSEDTOACCRUALANDINTERVENTION: {
                    return "Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment or intervention but are still being followed according to the primary objective of the study.";
                }
                case COMPLETED: {
                    return "Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment\nor intervention but are still being followed according to the primary objective of the study.";
                }
                case DISAPPROVED: {
                    return "Protocol was disapproved by the review board.";
                }
                case INREVIEW: {
                    return "Protocol is submitted to the review board for approval.";
                }
                case TEMPORARILYCLOSEDTOACCRUAL: {
                    return "Study is temporarily closed for accrual; can be potentially resumed in the future; patients can be examined and treated.";
                }
                case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                    return "Study is temporarily closed for accrual and intervention and potentially can be resumed in the future.";
                }
                case WITHDRAWN: {
                    return "Protocol was withdrawn by the lead organization.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ADMINISTRATIVELYCOMPLETED: {
                    return "Administratively Completed";
                }
                case APPROVED: {
                    return "Approved";
                }
                case CLOSEDTOACCRUAL: {
                    return "Closed to Accrual";
                }
                case CLOSEDTOACCRUALANDINTERVENTION: {
                    return "Closed to Accrual and Intervention";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case DISAPPROVED: {
                    return "Disapproved";
                }
                case INREVIEW: {
                    return "In Review";
                }
                case TEMPORARILYCLOSEDTOACCRUAL: {
                    return "Temporarily Closed to Accrual";
                }
                case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                    return "Temporarily Closed to Accrual and Intervention";
                }
                case WITHDRAWN: {
                    return "Withdrawn";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

