/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.StrandType;

public class StrandTypeEnumFactory
implements EnumFactory<StrandType> {
    @Override
    public StrandType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("watson".equals(codeString)) {
            return StrandType.WATSON;
        }
        if ("crick".equals(codeString)) {
            return StrandType.CRICK;
        }
        throw new IllegalArgumentException("Unknown StrandType code '" + codeString + "'");
    }

    @Override
    public String toCode(StrandType code) {
        if (code == StrandType.NULL) {
            return null;
        }
        if (code == StrandType.WATSON) {
            return "watson";
        }
        if (code == StrandType.CRICK) {
            return "crick";
        }
        return "?";
    }

    @Override
    public String toSystem(StrandType code) {
        return code.getSystem();
    }
}

