/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ICoding;
import org.hl7.fhir.r4.model.PrimitiveType;

@DatatypeDef(name="code", isSpecialization=true)
public class Enumeration<T extends Enum<?>>
extends PrimitiveType<T>
implements IBaseEnumeration<T>,
ICoding {
    private static final long serialVersionUID = 1L;
    private EnumFactory<T> myEnumFactory;

    @Deprecated
    public Enumeration() {
    }

    public Enumeration(EnumFactory<T> theEnumFactory) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
    }

    public Enumeration(EnumFactory<T> theEnumFactory, String theValue) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
        this.setValueAsString(theValue);
    }

    public Enumeration(EnumFactory<T> theEnumFactory, T theValue) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
        this.setValue((Object)theValue);
    }

    public Enumeration(EnumFactory<T> theEnumFactory, T theValue, Element source) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
        this.setValue((Object)theValue);
        this.setId(source.getId());
        this.getExtension().addAll(source.getExtension());
    }

    @Override
    public Enumeration<T> copy() {
        Enumeration<Enum> dst = new Enumeration<Enum>(this.myEnumFactory, (Enum)this.getValue());
        if (this.extension != null) {
            dst.extension = new ArrayList();
            for (Extension i : this.extension) {
                dst.extension.add(i.copy());
            }
        }
        return dst;
    }

    @Override
    protected String encode(T theValue) {
        return this.myEnumFactory.toCode(theValue);
    }

    @Override
    public String fhirType() {
        return "code";
    }

    public EnumFactory<T> getEnumFactory() {
        return this.myEnumFactory;
    }

    @Override
    protected T parse(String theValue) {
        if (this.myEnumFactory != null) {
            return this.myEnumFactory.fromCode(theValue);
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput theIn) throws IOException, ClassNotFoundException {
        this.myEnumFactory = (EnumFactory)theIn.readObject();
        super.readExternal(theIn);
    }

    public String toSystem() {
        return this.getEnumFactory().toSystem((Enum)this.getValue());
    }

    @Override
    public void writeExternal(ObjectOutput theOut) throws IOException {
        theOut.writeObject(this.myEnumFactory);
        super.writeExternal(theOut);
    }

    @Override
    public String getSystem() {
        return this.myEnumFactory.toSystem(this.myEnumFactory.fromCode(this.asStringValue()));
    }

    @Override
    public boolean hasSystem() {
        return this.myEnumFactory.toSystem(this.myEnumFactory.fromCode(this.asStringValue())) != null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasVersion() {
        return false;
    }

    @Override
    public boolean supportsVersion() {
        return false;
    }

    @Override
    public String getCode() {
        return this.asStringValue();
    }

    @Override
    public boolean hasCode() {
        return this.asStringValue() != null;
    }

    @Override
    public String getDisplay() {
        return null;
    }

    @Override
    public boolean hasDisplay() {
        return false;
    }

    @Override
    public boolean supportsDisplay() {
        return false;
    }
}

