/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.SynthesisType;

public class SynthesisTypeEnumFactory
implements EnumFactory<SynthesisType> {
    @Override
    public SynthesisType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("std-MA".equals(codeString)) {
            return SynthesisType.STDMA;
        }
        if ("IPD-MA".equals(codeString)) {
            return SynthesisType.IPDMA;
        }
        if ("indirect-NMA".equals(codeString)) {
            return SynthesisType.INDIRECTNMA;
        }
        if ("combined-NMA".equals(codeString)) {
            return SynthesisType.COMBINEDNMA;
        }
        if ("range".equals(codeString)) {
            return SynthesisType.RANGE;
        }
        if ("classification".equals(codeString)) {
            return SynthesisType.CLASSIFICATION;
        }
        throw new IllegalArgumentException("Unknown SynthesisType code '" + codeString + "'");
    }

    @Override
    public String toCode(SynthesisType code) {
        if (code == SynthesisType.NULL) {
            return null;
        }
        if (code == SynthesisType.STDMA) {
            return "std-MA";
        }
        if (code == SynthesisType.IPDMA) {
            return "IPD-MA";
        }
        if (code == SynthesisType.INDIRECTNMA) {
            return "indirect-NMA";
        }
        if (code == SynthesisType.COMBINEDNMA) {
            return "combined-NMA";
        }
        if (code == SynthesisType.RANGE) {
            return "range";
        }
        if (code == SynthesisType.CLASSIFICATION) {
            return "classification";
        }
        return "?";
    }

    @Override
    public String toSystem(SynthesisType code) {
        return code.getSystem();
    }
}

