/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.profilemodel.gen;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.profilemodel.PEBuilder;
import org.hl7.fhir.r4.profilemodel.PEDefinition;
import org.hl7.fhir.r4.profilemodel.PEType;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class PECodeGenerator {
    private String folder;
    private IWorkerContext workerContext;
    private String canonical;
    private String pkgName;
    private ExtensionPolicy extensionPolicy;
    private boolean narrative;
    private boolean contained;
    private boolean meta;
    private String language;
    private boolean keyElementsOnly;
    private String genDate = PECodeGenerator.DEFAULT_DATE();
    private StringBuilder imports = new StringBuilder();

    public static final String DEFAULT_DATE() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US"));
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date());
    }

    public PECodeGenerator(IWorkerContext workerContext) {
        this.workerContext = workerContext;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public void setCanonical(String canonical) {
        this.canonical = canonical;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public ExtensionPolicy getExtensionPolicy() {
        return this.extensionPolicy;
    }

    public void setExtensionPolicy(ExtensionPolicy extensionPolicy) {
        this.extensionPolicy = extensionPolicy;
    }

    public boolean isNarrative() {
        return this.narrative;
    }

    public void setNarrative(boolean narrative) {
        this.narrative = narrative;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public void setMeta(boolean meta) {
        this.meta = meta;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isKeyElementsOnly() {
        return this.keyElementsOnly;
    }

    public void setKeyElementsOnly(boolean keyElementsOnly) {
        this.keyElementsOnly = keyElementsOnly;
    }

    public boolean isContained() {
        return this.contained;
    }

    public void setContained(boolean contained) {
        this.contained = contained;
    }

    public String getGenDate() {
        return this.genDate;
    }

    public void setGenDate(String genDate) {
        this.genDate = genDate;
    }

    public void execute() throws IOException {
        PEDefinition source = new PEBuilder(this.workerContext, PEBuilder.PEElementPropertiesPolicy.EXTENSION, true).buildPEDefinition(this.canonical);
        this.w(this.imports, "import java.util.List;");
        this.w(this.imports, "import java.util.ArrayList;");
        this.w(this.imports, "import javax.annotation.Nullable;");
        this.w(this.imports, "import java.util.Date;\r\n");
        this.w(this.imports);
        this.w(this.imports, "import org.hl7.fhir.r5.context.IWorkerContext;");
        this.w(this.imports, "import org.hl7.fhir.r5.model.*;");
        this.w(this.imports, "import org.hl7.fhir.r5.profilemodel.PEBuilder;");
        this.w(this.imports, "import org.hl7.fhir.r5.profilemodel.PEInstance;");
        this.w(this.imports, "import org.hl7.fhir.r5.profilemodel.PEBuilder.PEElementPropertiesPolicy;");
        this.w(this.imports, "import org.hl7.fhir.r5.profilemodel.gen.PEGeneratedBase;");
        PEGenClass cls = this.genClass(source);
        StringBuilder b = new StringBuilder();
        this.w(b, "package " + this.pkgName + ";");
        this.w(b);
        if (source.getProfile().hasCopyright()) {
            this.jdoc(b, source.getProfile().getCopyright(), 0, false);
        }
        this.w(b, this.imports.toString());
        cls.write(b, source.getProfile().getCopyright());
        TextFile.stringToFile((String)b.toString(), (String)Utilities.path((String[])new String[]{this.folder, cls.name + ".java"}));
    }

    public void jdoc(StringBuilder b, String doco, int indent, boolean jdoc) {
        if (!Utilities.noString((String)doco)) {
            String pfx = Utilities.padLeft((String)"", (char)' ', (int)indent);
            this.w(b, pfx + "/*" + (jdoc ? "*" : ""));
            for (String line : doco.split("\\R")) {
                for (String nl : this.naturalLines(line)) {
                    this.w(b, pfx + " * " + nl);
                }
                this.w(b, pfx + " *");
            }
            this.w(b, pfx + " */");
        }
    }

    private List<String> naturalLines(String line) {
        ArrayList<String> lines = new ArrayList<String>();
        while (line.length() > 80) {
            int cutpoint;
            for (cutpoint = 80; cutpoint > 0 && line.charAt(cutpoint) != ' '; --cutpoint) {
            }
            cutpoint = cutpoint == 0 ? 80 : ++cutpoint;
            lines.add(line.substring(0, cutpoint));
            line = line.substring(cutpoint);
        }
        lines.add(line);
        return lines;
    }

    private void w(StringBuilder b) {
        b.append("\r\n");
    }

    private void w(StringBuilder b, String line) {
        b.append(line);
        this.w(b);
    }

    private PEGenClass genClass(PEDefinition source) {
        PEGenClass cls = new PEGenClass();
        cls.name = source.getProfile().getName();
        cls.base = source.getProfile().getType();
        cls.doco = source.documentation();
        cls.url = source.getProfile().getVersionedUrl();
        cls.isResource = source.getProfile().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
        cls.genId();
        for (PEDefinition child : source.children()) {
            if (!this.genForField(source, child)) continue;
            cls.defineField(source, child);
        }
        return cls;
    }

    private boolean genForField(PEDefinition source, PEDefinition child) {
        if (child.definition().getBase().getPath().equals("Resource.meta")) {
            return this.meta;
        }
        if (child.definition().getBase().getPath().equals("DomainResource.text")) {
            return this.narrative;
        }
        if (child.definition().getBase().getPath().equals("Resource.language")) {
            return this.language == null;
        }
        if (child.definition().getBase().getPath().endsWith(".extension") || child.definition().getBase().getPath().endsWith(".modifierExtension")) {
            return this.extensionPolicy == ExtensionPolicy.Complexes;
        }
        if (child.definition().getBase().getPath().equals("DomainResource.contained")) {
            return this.contained;
        }
        return !this.keyElementsOnly || child.isKeyElement();
    }

    private String getPrimitiveType(StructureDefinition sd) {
        if (sd.getType().equals("string")) {
            return "String";
        }
        if (sd.getType().equals("code")) {
            return "String";
        }
        if (sd.getType().equals("markdown")) {
            return "String";
        }
        if (sd.getType().equals("base64Binary")) {
            return "byte[]";
        }
        if (sd.getType().equals("uri")) {
            return "String";
        }
        if (sd.getType().equals("url")) {
            return "String";
        }
        if (sd.getType().equals("canonical")) {
            return "String";
        }
        if (sd.getType().equals("oid")) {
            return "String";
        }
        if (sd.getType().equals("integer")) {
            return "int";
        }
        if (sd.getType().equals("integer64")) {
            return "long";
        }
        if (sd.getType().equals("unsignedInt")) {
            return "int";
        }
        if (sd.getType().equals("positiveInt")) {
            return "int";
        }
        if (sd.getType().equals("boolean")) {
            return "boolean";
        }
        if (sd.getType().equals("decimal")) {
            return "BigDecimal";
        }
        if (sd.getType().equals("dateTime")) {
            return "Date";
        }
        if (sd.getType().equals("date")) {
            return "Date";
        }
        if (sd.getType().equals("id")) {
            return "String";
        }
        if (sd.getType().equals("instant")) {
            return "Date";
        }
        if (sd.getType().equals("time")) {
            return "String";
        }
        return "??";
    }

    private class PEGenClass {
        private String name;
        private String base;
        private String doco;
        private String url;
        private boolean isResource;
        private StringBuilder fields = new StringBuilder();
        private StringBuilder load = new StringBuilder();
        private StringBuilder save = new StringBuilder();
        private StringBuilder clear = new StringBuilder();
        private StringBuilder copy = new StringBuilder();
        private StringBuilder accessors = new StringBuilder();
        private StringBuilder hash = new StringBuilder();

        private PEGenClass() {
        }

        public void genId() {
            if (this.isResource) {
                this.genField(true, "id", "String", "id", "", false, "");
                this.genAccessors(true, false, "id", "String", "", "String", "String", "Id", "Ids", false, "", false);
                this.genLoad(true, false, "id", "id", "IdType", "", "String", "String", "Id", "Ids", false, false, null);
                this.genSave(true, false, "id", "id", "IdType", "", "String", "String", "Id", "Ids", false, false, false, null);
                this.genClear(false, "id");
            }
        }

        public void write(StringBuilder b, String copyright) {
            PECodeGenerator.this.w(b);
            if (copyright != null) {
                PECodeGenerator.this.w(b, "/*");
                PECodeGenerator.this.w(b, copyright);
                PECodeGenerator.this.w(b, " */");
                PECodeGenerator.this.w(b);
            }
            PECodeGenerator.this.w(b, "// Generated by the HAPI Java Profile Generator, " + PECodeGenerator.this.genDate);
            PECodeGenerator.this.w(b);
            PECodeGenerator.this.jdoc(b, this.doco, 0, true);
            PECodeGenerator.this.w(b, "public class " + this.name + " extends PEGeneratedBase {");
            PECodeGenerator.this.w(b);
            if (this.url != null) {
                PECodeGenerator.this.w(b, "  private static final String CANONICAL_URL = \"" + this.url + "\";");
                PECodeGenerator.this.w(b);
            }
            PECodeGenerator.this.w(b, this.fields.toString());
            PECodeGenerator.this.jdoc(b, "Parameter-less constructor. If you use this, the fixed values won't be filled out - they'll be missing. They'll be filled in if/when you call build, so they won't be missing from the resource, only from this particular object model", 2, true);
            PECodeGenerator.this.w(b, "  public " + this.name + "() {");
            PECodeGenerator.this.w(b, "    // todo");
            PECodeGenerator.this.w(b, "  }");
            PECodeGenerator.this.w(b);
            if (this.isResource) {
                PECodeGenerator.this.jdoc(b, "Construct an instance of the object, and fill out all the fixed values ", 2, true);
                PECodeGenerator.this.w(b, "  public " + this.name + "(IWorkerContext context) {");
                PECodeGenerator.this.w(b, "    workerContext = context;");
                PECodeGenerator.this.w(b, "    PEBuilder builder = new PEBuilder(context, PEElementPropertiesPolicy.EXTENSION, true);");
                PECodeGenerator.this.w(b, "    PEInstance src = builder.buildPEInstance(CANONICAL_URL, builder.createResource(CANONICAL_URL, false));");
                PECodeGenerator.this.w(b, "    load(src);");
                PECodeGenerator.this.w(b, "  }");
                PECodeGenerator.this.w(b);
                PECodeGenerator.this.jdoc(b, "Populate an instance of the object based on this source object ", 2, true);
                PECodeGenerator.this.w(b, "  public static " + this.name + " fromSource(IWorkerContext context, " + this.base + " source) {");
                PECodeGenerator.this.w(b, "    " + this.name + " theThing = new " + this.name + "();");
                PECodeGenerator.this.w(b, "    theThing.workerContext = context;");
                PECodeGenerator.this.w(b, "    PEBuilder builder = new PEBuilder(context, PEElementPropertiesPolicy.EXTENSION, true);");
                PECodeGenerator.this.w(b, "    PEInstance src = builder.buildPEInstance(CANONICAL_URL, source);");
                PECodeGenerator.this.w(b, "    theThing.load(src);");
                PECodeGenerator.this.w(b, "    return theThing;");
                PECodeGenerator.this.w(b, "  }");
                PECodeGenerator.this.w(b);
            } else {
                PECodeGenerator.this.jdoc(b, "Used when loading other models ", 2, true);
                PECodeGenerator.this.w(b, "  public static " + this.name + " fromSource(PEInstance source) {");
                PECodeGenerator.this.w(b, "    " + this.name + " theThing = new " + this.name + "();");
                PECodeGenerator.this.w(b, "    theThing.workerContext = source.getContext();");
                PECodeGenerator.this.w(b, "    theThing.load(source);");
                PECodeGenerator.this.w(b, "    return theThing;");
                PECodeGenerator.this.w(b, "  }");
            }
            PECodeGenerator.this.w(b);
            PECodeGenerator.this.w(b, "  public void load(PEInstance src) {");
            PECodeGenerator.this.w(b, "    clear();");
            PECodeGenerator.this.w(b, this.load.toString());
            PECodeGenerator.this.w(b, "  }");
            PECodeGenerator.this.w(b);
            if (this.isResource) {
                PECodeGenerator.this.jdoc(b, "Build an instance of the object based on this source object ", 2, true);
                PECodeGenerator.this.w(b, "  public " + this.base + " build(IWorkerContext context) {");
                PECodeGenerator.this.w(b, "    workerContext = context;");
                PECodeGenerator.this.w(b, "    " + this.base + " theThing = new " + this.base + "();");
                PECodeGenerator.this.w(b, "    PEBuilder builder = new PEBuilder(context, PEElementPropertiesPolicy.EXTENSION, true);");
                PECodeGenerator.this.w(b, "    PEInstance tgt = builder.buildPEInstance(CANONICAL_URL, theThing);");
                PECodeGenerator.this.w(b, "    save(tgt, false);");
                PECodeGenerator.this.w(b, "    return theThing;");
                PECodeGenerator.this.w(b, "  }");
                PECodeGenerator.this.w(b);
                PECodeGenerator.this.jdoc(b, "Save this profile class into an existing resource (overwriting anything that exists in the profile) ", 2, true);
                PECodeGenerator.this.w(b, "  public void save(IWorkerContext context, " + this.base + " dest, boolean nulls) {");
                PECodeGenerator.this.w(b, "    workerContext = context;");
                PECodeGenerator.this.w(b, "    PEBuilder builder = new PEBuilder(context, PEElementPropertiesPolicy.EXTENSION, true);");
                PECodeGenerator.this.w(b, "    PEInstance tgt = builder.buildPEInstance(CANONICAL_URL, dest);");
                PECodeGenerator.this.w(b, "    save(tgt, nulls);");
                PECodeGenerator.this.w(b, "  }");
                PECodeGenerator.this.w(b);
            }
            PECodeGenerator.this.w(b, "  public void save(PEInstance tgt, boolean nulls) {");
            PECodeGenerator.this.w(b, this.save.toString());
            PECodeGenerator.this.w(b, "  }");
            PECodeGenerator.this.w(b);
            PECodeGenerator.this.w(b, this.accessors.toString());
            PECodeGenerator.this.w(b);
            PECodeGenerator.this.w(b, "  public void clear() {");
            PECodeGenerator.this.w(b, this.clear.toString());
            PECodeGenerator.this.w(b, "  }");
            PECodeGenerator.this.w(b);
            PECodeGenerator.this.w(b, "}");
        }

        private void defineField(PEDefinition source, PEDefinition field) {
            StructureDefinition sd;
            if (field.types().size() == 1 && (sd = PECodeGenerator.this.workerContext.fetchTypeDefinition(field.types().get(0).getUrl())) != null) {
                String name;
                boolean isPrim = sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
                boolean isAbstract = sd.getAbstract();
                String sname = name = field.name().replace("[x]", "");
                String type = null;
                String init = "";
                String ptype = type;
                if (isPrim) {
                    type = Utilities.capitalize((String)(field.types().get(0).getName() + "Type"));
                    ptype = PECodeGenerator.this.getPrimitiveType(sd);
                } else {
                    type = field.types().get(0).getName();
                }
                Object ltype = type;
                if (field.isList()) {
                    ltype = "List<" + type + ">";
                    init = "new ArrayList<>()";
                    if (!Utilities.existsInList((String)name, (String[])new String[]{"contained"})) {
                        name = Utilities.pluralize((String)name, (int)2);
                    }
                }
                String cname = Utilities.capitalize((String)name);
                String csname = Utilities.capitalize((String)sname);
                String nn = field.min() == 1 ? "// @NotNull" : "";
                boolean isExtension = field.isExtension();
                this.genField(isPrim, name, ptype, (String)ltype, nn, field.isList(), field.shortDocumentation());
                this.genAccessors(isPrim, isAbstract, name, type, init, ptype, (String)ltype, cname, csname, field.isList(), field.documentation(), field.fixedValue());
                this.genLoad(isPrim, isAbstract, name, sname, type, init, ptype, (String)ltype, cname, csname, field.isList(), field.fixedValue(), field.types().get(0));
                this.genSave(isPrim, isAbstract, name, sname, type, init, ptype, (String)ltype, cname, csname, field.isList(), field.fixedValue(), isExtension, field.types().get(0));
                this.genClear(field.isList(), name);
            }
        }

        private void genClear(boolean list, String name) {
            if (list) {
                PECodeGenerator.this.w(this.clear, "    " + name + ".clear();");
            } else {
                PECodeGenerator.this.w(this.clear, "    " + name + " = null;");
            }
        }

        private void genLoad(boolean isPrim, boolean isAbstract, String name, String sname, String type, String init, String ptype, String ltype, String cname, String csname, boolean isList, boolean isFixed, PEType typeInfo) {
            if (isList) {
                PECodeGenerator.this.w(this.load, "    for (PEInstance item : src.children(\"" + sname + "\")) {");
                PECodeGenerator.this.w(this.load, "      " + name + ".add((" + type + ") item.asDataType());");
                PECodeGenerator.this.w(this.load, "    }");
            } else if (isPrim) {
                PECodeGenerator.this.w(this.load, "    if (src.hasChild(\"" + name + "\")) {");
                if ("CodeType".equals(type)) {
                    PECodeGenerator.this.w(this.load, "      " + name + " = src.child(\"" + name + "\").asDataType().primitiveValue();");
                } else {
                    PECodeGenerator.this.w(this.load, "      " + name + " = ((" + type + ") src.child(\"" + name + "\").asDataType()).getValue();");
                }
                PECodeGenerator.this.w(this.load, "    }");
            } else if (typeInfo != null && typeInfo.getUrl() != null && !typeInfo.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition")) {
                PECodeGenerator.this.w(this.load, "    if (src.hasChild(\"" + name + "\")) {");
                PECodeGenerator.this.w(this.load, "      " + name + " = " + type + ".fromSource(src.child(\"" + name + "\"));");
                PECodeGenerator.this.w(this.load, "    }");
            } else {
                PECodeGenerator.this.w(this.load, "    if (src.hasChild(\"" + name + "\")) {");
                PECodeGenerator.this.w(this.load, "      " + name + " = (" + type + ") src.child(\"" + name + "\").asDataType();");
                PECodeGenerator.this.w(this.load, "    }");
            }
        }

        private void genSave(boolean isPrim, boolean isAbstract, String name, String sname, String type, String init, String ptype, String ltype, String cname, String csname, boolean isList, boolean isFixed, boolean isExtension, PEType typeInfo) {
            PECodeGenerator.this.w(this.save, "    tgt.clear(\"" + sname + "\");");
            if (isList) {
                PECodeGenerator.this.w(this.save, "    for (" + type + " item : " + name + ") {");
                if (isExtension) {
                    PECodeGenerator.this.w(this.save, "      tgt.makeChild(\"" + sname + "\").data().setProperty(\"value[x]\", item);");
                } else {
                    PECodeGenerator.this.w(this.save, "      tgt.addChild(\"" + sname + "\", item);");
                }
                PECodeGenerator.this.w(this.save, "    }");
            } else if (isPrim) {
                PECodeGenerator.this.w(this.save, "    if (" + name + " != null) {");
                if (isExtension) {
                    PECodeGenerator.this.w(this.save, "      tgt.makeChild(\"" + sname + "\").data().setProperty(\"value[x]\", new " + type + "(" + name + "));");
                } else if (Utilities.existsInList((String)type, (String[])new String[]{"DateType", "InstantType", "DateTimeType"})) {
                    PECodeGenerator.this.w(this.save, "      tgt.addChild(\"" + sname + "\", new " + type + "(" + name + "));");
                } else {
                    PECodeGenerator.this.w(this.save, "      tgt.makeChild(\"" + sname + "\").data().setProperty(\"value\", new " + type + "(" + name + "));");
                }
                PECodeGenerator.this.w(this.save, "    }");
            } else if (typeInfo != null && typeInfo.getUrl() != null && !typeInfo.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition")) {
                PECodeGenerator.this.w(this.save, "    if (" + name + " != null) {");
                PECodeGenerator.this.w(this.save, "      " + name + ".save(tgt.makeChild(\"" + sname + "\"), nulls);");
                PECodeGenerator.this.w(this.save, "    }");
            } else if (isExtension) {
                PECodeGenerator.this.w(this.save, "    if (" + name + " != null) {");
                PECodeGenerator.this.w(this.save, "      tgt.makeChild(\"" + sname + "\").data().setProperty(\"value[x]\", " + name + ");");
                PECodeGenerator.this.w(this.save, "    }");
            } else {
                PECodeGenerator.this.w(this.save, "    if (" + name + " != null) {");
                PECodeGenerator.this.w(this.save, "      tgt.addChild(\"" + sname + "\", " + name + ");");
                PECodeGenerator.this.w(this.save, "    }");
            }
        }

        private void genAccessors(boolean isPrim, boolean isAbstract, String name, String type, String init, String ptype, String ltype, String cname, String csname, boolean isList, String shortDoco, boolean isFixed) {
            PECodeGenerator.this.jdoc(this.accessors, this.doco, 2, true);
            if (isPrim && PECodeGenerator.this.extensionPolicy != ExtensionPolicy.Primitives && !isList) {
                PECodeGenerator.this.w(this.accessors, "  public " + ptype + " get" + cname + "() {");
                PECodeGenerator.this.w(this.accessors, "    return " + name + ";");
                PECodeGenerator.this.w(this.accessors, "  }");
                PECodeGenerator.this.w(this.accessors);
                PECodeGenerator.this.w(this.accessors, "  public " + this.name + " set" + cname + "(" + ptype + " value) {");
                PECodeGenerator.this.w(this.accessors, "    this." + name + " = value;");
                PECodeGenerator.this.w(this.accessors, "    return this;");
                PECodeGenerator.this.w(this.accessors, "  }");
                PECodeGenerator.this.w(this.accessors);
                PECodeGenerator.this.w(this.accessors, "  public boolean has" + cname + "() {");
                PECodeGenerator.this.w(this.accessors, "    return " + name + " != null;");
                PECodeGenerator.this.w(this.accessors, "  }");
            } else {
                if (isPrim && !isList) {
                    PECodeGenerator.this.w(this.accessors, "  public " + ptype + " get" + cname + "() {");
                    PECodeGenerator.this.w(this.accessors, "    if (" + name + " == null) { " + name + " = new " + type + "(); }");
                    PECodeGenerator.this.w(this.accessors, "    return " + name + ".getValue();");
                    PECodeGenerator.this.w(this.accessors, "  }");
                    PECodeGenerator.this.w(this.accessors, "  public " + ltype + " get" + cname + "Element() {");
                } else if (isAbstract && !isList) {
                    PECodeGenerator.this.w(this.accessors, "  public @Nullable " + ltype + " get" + cname + "() { // " + ltype + " is abstract ");
                } else {
                    PECodeGenerator.this.w(this.accessors, "  public " + ltype + " get" + cname + "() {");
                }
                if (isList) {
                    PECodeGenerator.this.w(this.accessors, "    if (" + name + " == null) { " + name + " = " + init + "; }");
                } else if (!isAbstract) {
                    PECodeGenerator.this.w(this.accessors, "    if (" + name + " == null) { " + name + " = new " + type + "(); }");
                }
                PECodeGenerator.this.w(this.accessors, "    return " + name + ";");
                PECodeGenerator.this.w(this.accessors, "  }");
                PECodeGenerator.this.w(this.accessors);
                if (isList) {
                    PECodeGenerator.this.w(this.accessors, "  public boolean has" + cname + "() {");
                    PECodeGenerator.this.w(this.accessors, "    return " + name + " != null && !" + name + ".isEmpty();");
                    PECodeGenerator.this.w(this.accessors, "  }");
                    PECodeGenerator.this.w(this.accessors);
                    if (!isAbstract) {
                        PECodeGenerator.this.w(this.accessors, "  public " + type + " add" + csname + "() {");
                        PECodeGenerator.this.w(this.accessors, "    " + type + " theThing = new " + type + "();");
                        PECodeGenerator.this.w(this.accessors, "    get" + cname + "().add(theThing);");
                        PECodeGenerator.this.w(this.accessors, "    return theThing;");
                        PECodeGenerator.this.w(this.accessors, "  }");
                        PECodeGenerator.this.w(this.accessors);
                    }
                    PECodeGenerator.this.w(this.accessors, "  public boolean has" + csname + "(" + type + " item) {");
                    PECodeGenerator.this.w(this.accessors, "    return has" + cname + "() && " + name + ".contains(item);");
                    PECodeGenerator.this.w(this.accessors, "  }");
                    PECodeGenerator.this.w(this.accessors);
                    PECodeGenerator.this.w(this.accessors, "  public void remove" + csname + "(" + type + " item) {");
                    PECodeGenerator.this.w(this.accessors, "    if (has" + csname + "(item)) {");
                    PECodeGenerator.this.w(this.accessors, "      " + name + ".remove(item);");
                    PECodeGenerator.this.w(this.accessors, "    }");
                    PECodeGenerator.this.w(this.accessors, "  }");
                    PECodeGenerator.this.w(this.accessors);
                } else if (isPrim) {
                    if (!isFixed) {
                        PECodeGenerator.this.w(this.accessors, "  public " + this.name + " set" + cname + "(" + ptype + " value) {");
                        PECodeGenerator.this.w(this.accessors, "    if (" + name + " == null) { " + name + " = new " + type + "(); }");
                        PECodeGenerator.this.w(this.accessors, "    " + name + ".setValue(value);");
                        PECodeGenerator.this.w(this.accessors, "    return this;");
                        PECodeGenerator.this.w(this.accessors, "  }");
                        PECodeGenerator.this.w(this.accessors, "  public " + this.name + " set" + cname + "Element(" + type + " value) {");
                        PECodeGenerator.this.w(this.accessors, "    this." + name + " = value;");
                        PECodeGenerator.this.w(this.accessors, "    return this;");
                        PECodeGenerator.this.w(this.accessors, "  }");
                    }
                    PECodeGenerator.this.w(this.accessors, "  public boolean has" + cname + "() {");
                    PECodeGenerator.this.w(this.accessors, "    return " + name + " != null && " + name + ".hasValue();");
                    PECodeGenerator.this.w(this.accessors, "  }");
                    PECodeGenerator.this.w(this.accessors);
                } else {
                    if (!isFixed) {
                        PECodeGenerator.this.w(this.accessors, "  public " + this.name + " set" + cname + "(" + type + " value) {");
                        PECodeGenerator.this.w(this.accessors, "    this." + name + " = value;");
                        PECodeGenerator.this.w(this.accessors, "    return this;");
                        PECodeGenerator.this.w(this.accessors, "  }");
                    }
                    PECodeGenerator.this.w(this.accessors, "  public boolean has" + cname + "() {");
                    PECodeGenerator.this.w(this.accessors, "    return " + name + " != null;");
                    PECodeGenerator.this.w(this.accessors, "  }");
                }
            }
            PECodeGenerator.this.w(this.accessors);
        }

        private void genField(boolean isPrim, String name, String ptype, String ltype, String nn, boolean isList, String shortDoco) {
            if (isPrim && PECodeGenerator.this.extensionPolicy != ExtensionPolicy.Primitives && !isList) {
                PECodeGenerator.this.w(this.fields, "  private " + ptype + " " + name + ";" + nn + "  // " + shortDoco);
            } else if (isList) {
                PECodeGenerator.this.w(this.fields, "  private " + ltype + " " + name + " = new ArrayList<>();" + nn + "  // " + shortDoco);
            } else {
                PECodeGenerator.this.w(this.fields, "  private " + ltype + " " + name + ";" + nn + "  // " + shortDoco);
            }
        }
    }

    public static enum ExtensionPolicy {
        None,
        Complexes,
        Primitives;

    }
}

