/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CodesystemAltcodeKind;

public class CodesystemAltcodeKindEnumFactory
implements EnumFactory<CodesystemAltcodeKind> {
    @Override
    public CodesystemAltcodeKind fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("alternate".equals(codeString)) {
            return CodesystemAltcodeKind.ALTERNATE;
        }
        if ("deprecated".equals(codeString)) {
            return CodesystemAltcodeKind.DEPRECATED;
        }
        if ("case-insensitive".equals(codeString)) {
            return CodesystemAltcodeKind.CASEINSENSITIVE;
        }
        if ("case-sensitive".equals(codeString)) {
            return CodesystemAltcodeKind.CASESENSITIVE;
        }
        if ("expression".equals(codeString)) {
            return CodesystemAltcodeKind.EXPRESSION;
        }
        throw new IllegalArgumentException("Unknown CodesystemAltcodeKind code '" + codeString + "'");
    }

    @Override
    public String toCode(CodesystemAltcodeKind code) {
        if (code == CodesystemAltcodeKind.NULL) {
            return null;
        }
        if (code == CodesystemAltcodeKind.ALTERNATE) {
            return "alternate";
        }
        if (code == CodesystemAltcodeKind.DEPRECATED) {
            return "deprecated";
        }
        if (code == CodesystemAltcodeKind.CASEINSENSITIVE) {
            return "case-insensitive";
        }
        if (code == CodesystemAltcodeKind.CASESENSITIVE) {
            return "case-sensitive";
        }
        if (code == CodesystemAltcodeKind.EXPRESSION) {
            return "expression";
        }
        return "?";
    }

    @Override
    public String toSystem(CodesystemAltcodeKind code) {
        return code.getSystem();
    }
}

