package org.hl7.fhir.r4.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0

import org.hl7.fhir.r4.model.EnumFactory;

public class V3DentitionEnumFactory implements EnumFactory<V3Dentition> {

  public V3Dentition fromCode(String codeString) throws IllegalArgumentException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("ArtificialDentition".equals(codeString))
      return V3Dentition.ARTIFICIALDENTITION;
    if ("TID10a".equals(codeString))
      return V3Dentition.TID10A;
    if ("TID10i".equals(codeString))
      return V3Dentition.TID10I;
    if ("TID10p".equals(codeString))
      return V3Dentition.TID10P;
    if ("TID10pd".equals(codeString))
      return V3Dentition.TID10PD;
    if ("TID10pm".equals(codeString))
      return V3Dentition.TID10PM;
    if ("TID11a".equals(codeString))
      return V3Dentition.TID11A;
    if ("TID11i".equals(codeString))
      return V3Dentition.TID11I;
    if ("TID11p".equals(codeString))
      return V3Dentition.TID11P;
    if ("TID11pd".equals(codeString))
      return V3Dentition.TID11PD;
    if ("TID11pm".equals(codeString))
      return V3Dentition.TID11PM;
    if ("TID12a".equals(codeString))
      return V3Dentition.TID12A;
    if ("TID12i".equals(codeString))
      return V3Dentition.TID12I;
    if ("TID12p".equals(codeString))
      return V3Dentition.TID12P;
    if ("TID12pd".equals(codeString))
      return V3Dentition.TID12PD;
    if ("TID12pm".equals(codeString))
      return V3Dentition.TID12PM;
    if ("TID13a".equals(codeString))
      return V3Dentition.TID13A;
    if ("TID13i".equals(codeString))
      return V3Dentition.TID13I;
    if ("TID13p".equals(codeString))
      return V3Dentition.TID13P;
    if ("TID13pd".equals(codeString))
      return V3Dentition.TID13PD;
    if ("TID13pm".equals(codeString))
      return V3Dentition.TID13PM;
    if ("TID14a".equals(codeString))
      return V3Dentition.TID14A;
    if ("TID14i".equals(codeString))
      return V3Dentition.TID14I;
    if ("TID14p".equals(codeString))
      return V3Dentition.TID14P;
    if ("TID14pd".equals(codeString))
      return V3Dentition.TID14PD;
    if ("TID14pm".equals(codeString))
      return V3Dentition.TID14PM;
    if ("TID15a".equals(codeString))
      return V3Dentition.TID15A;
    if ("TID15i".equals(codeString))
      return V3Dentition.TID15I;
    if ("TID15p".equals(codeString))
      return V3Dentition.TID15P;
    if ("TID15pd".equals(codeString))
      return V3Dentition.TID15PD;
    if ("TID15pm".equals(codeString))
      return V3Dentition.TID15PM;
    if ("TID16a".equals(codeString))
      return V3Dentition.TID16A;
    if ("TID16i".equals(codeString))
      return V3Dentition.TID16I;
    if ("TID16p".equals(codeString))
      return V3Dentition.TID16P;
    if ("TID16pd".equals(codeString))
      return V3Dentition.TID16PD;
    if ("TID16pm".equals(codeString))
      return V3Dentition.TID16PM;
    if ("TID17a".equals(codeString))
      return V3Dentition.TID17A;
    if ("TID17ad".equals(codeString))
      return V3Dentition.TID17AD;
    if ("TID17am".equals(codeString))
      return V3Dentition.TID17AM;
    if ("TID17i".equals(codeString))
      return V3Dentition.TID17I;
    if ("TID17id".equals(codeString))
      return V3Dentition.TID17ID;
    if ("TID17im".equals(codeString))
      return V3Dentition.TID17IM;
    if ("TID17p".equals(codeString))
      return V3Dentition.TID17P;
    if ("TID17pd".equals(codeString))
      return V3Dentition.TID17PD;
    if ("TID17pm".equals(codeString))
      return V3Dentition.TID17PM;
    if ("TID18a".equals(codeString))
      return V3Dentition.TID18A;
    if ("TID18ad".equals(codeString))
      return V3Dentition.TID18AD;
    if ("TID18am".equals(codeString))
      return V3Dentition.TID18AM;
    if ("TID18i".equals(codeString))
      return V3Dentition.TID18I;
    if ("TID18id".equals(codeString))
      return V3Dentition.TID18ID;
    if ("TID18im".equals(codeString))
      return V3Dentition.TID18IM;
    if ("TID18p".equals(codeString))
      return V3Dentition.TID18P;
    if ("TID18pd".equals(codeString))
      return V3Dentition.TID18PD;
    if ("TID18pm".equals(codeString))
      return V3Dentition.TID18PM;
    if ("TID19a".equals(codeString))
      return V3Dentition.TID19A;
    if ("TID19ad".equals(codeString))
      return V3Dentition.TID19AD;
    if ("TID19am".equals(codeString))
      return V3Dentition.TID19AM;
    if ("TID19i".equals(codeString))
      return V3Dentition.TID19I;
    if ("TID19id".equals(codeString))
      return V3Dentition.TID19ID;
    if ("TID19im".equals(codeString))
      return V3Dentition.TID19IM;
    if ("TID19p".equals(codeString))
      return V3Dentition.TID19P;
    if ("TID19pd".equals(codeString))
      return V3Dentition.TID19PD;
    if ("TID19pm".equals(codeString))
      return V3Dentition.TID19PM;
    if ("TID1a".equals(codeString))
      return V3Dentition.TID1A;
    if ("TID1i".equals(codeString))
      return V3Dentition.TID1I;
    if ("TID1p".equals(codeString))
      return V3Dentition.TID1P;
    if ("TID1pd".equals(codeString))
      return V3Dentition.TID1PD;
    if ("TID1pm".equals(codeString))
      return V3Dentition.TID1PM;
    if ("TID20a".equals(codeString))
      return V3Dentition.TID20A;
    if ("TID20i".equals(codeString))
      return V3Dentition.TID20I;
    if ("TID20p".equals(codeString))
      return V3Dentition.TID20P;
    if ("TID20pd".equals(codeString))
      return V3Dentition.TID20PD;
    if ("TID20pm".equals(codeString))
      return V3Dentition.TID20PM;
    if ("TID21a".equals(codeString))
      return V3Dentition.TID21A;
    if ("TID21i".equals(codeString))
      return V3Dentition.TID21I;
    if ("TID21p".equals(codeString))
      return V3Dentition.TID21P;
    if ("TID21pd".equals(codeString))
      return V3Dentition.TID21PD;
    if ("TID21pm".equals(codeString))
      return V3Dentition.TID21PM;
    if ("TID22a".equals(codeString))
      return V3Dentition.TID22A;
    if ("TID22i".equals(codeString))
      return V3Dentition.TID22I;
    if ("TID22p".equals(codeString))
      return V3Dentition.TID22P;
    if ("TID22pd".equals(codeString))
      return V3Dentition.TID22PD;
    if ("TID22pm".equals(codeString))
      return V3Dentition.TID22PM;
    if ("TID23a".equals(codeString))
      return V3Dentition.TID23A;
    if ("TID23i".equals(codeString))
      return V3Dentition.TID23I;
    if ("TID23p".equals(codeString))
      return V3Dentition.TID23P;
    if ("TID23pd".equals(codeString))
      return V3Dentition.TID23PD;
    if ("TID23pm".equals(codeString))
      return V3Dentition.TID23PM;
    if ("TID24a".equals(codeString))
      return V3Dentition.TID24A;
    if ("TID24i".equals(codeString))
      return V3Dentition.TID24I;
    if ("TID24p".equals(codeString))
      return V3Dentition.TID24P;
    if ("TID24pd".equals(codeString))
      return V3Dentition.TID24PD;
    if ("TID24pm".equals(codeString))
      return V3Dentition.TID24PM;
    if ("TID25a".equals(codeString))
      return V3Dentition.TID25A;
    if ("TID25i".equals(codeString))
      return V3Dentition.TID25I;
    if ("TID25p".equals(codeString))
      return V3Dentition.TID25P;
    if ("TID25pd".equals(codeString))
      return V3Dentition.TID25PD;
    if ("TID25pm".equals(codeString))
      return V3Dentition.TID25PM;
    if ("TID26a".equals(codeString))
      return V3Dentition.TID26A;
    if ("TID26i".equals(codeString))
      return V3Dentition.TID26I;
    if ("TID26p".equals(codeString))
      return V3Dentition.TID26P;
    if ("TID26pd".equals(codeString))
      return V3Dentition.TID26PD;
    if ("TID26pm".equals(codeString))
      return V3Dentition.TID26PM;
    if ("TID27a".equals(codeString))
      return V3Dentition.TID27A;
    if ("TID27i".equals(codeString))
      return V3Dentition.TID27I;
    if ("TID27p".equals(codeString))
      return V3Dentition.TID27P;
    if ("TID27pd".equals(codeString))
      return V3Dentition.TID27PD;
    if ("TID27pm".equals(codeString))
      return V3Dentition.TID27PM;
    if ("TID28a".equals(codeString))
      return V3Dentition.TID28A;
    if ("TID28i".equals(codeString))
      return V3Dentition.TID28I;
    if ("TID28p".equals(codeString))
      return V3Dentition.TID28P;
    if ("TID28pd".equals(codeString))
      return V3Dentition.TID28PD;
    if ("TID28pm".equals(codeString))
      return V3Dentition.TID28PM;
    if ("TID29a".equals(codeString))
      return V3Dentition.TID29A;
    if ("TID29i".equals(codeString))
      return V3Dentition.TID29I;
    if ("TID29p".equals(codeString))
      return V3Dentition.TID29P;
    if ("TID29pd".equals(codeString))
      return V3Dentition.TID29PD;
    if ("TID29pm".equals(codeString))
      return V3Dentition.TID29PM;
    if ("TID2a".equals(codeString))
      return V3Dentition.TID2A;
    if ("TID2i".equals(codeString))
      return V3Dentition.TID2I;
    if ("TID2p".equals(codeString))
      return V3Dentition.TID2P;
    if ("TID2pd".equals(codeString))
      return V3Dentition.TID2PD;
    if ("TID2pm".equals(codeString))
      return V3Dentition.TID2PM;
    if ("TID30a".equals(codeString))
      return V3Dentition.TID30A;
    if ("TID30ad".equals(codeString))
      return V3Dentition.TID30AD;
    if ("TID30am".equals(codeString))
      return V3Dentition.TID30AM;
    if ("TID30i".equals(codeString))
      return V3Dentition.TID30I;
    if ("TID30id".equals(codeString))
      return V3Dentition.TID30ID;
    if ("TID30im".equals(codeString))
      return V3Dentition.TID30IM;
    if ("TID30p".equals(codeString))
      return V3Dentition.TID30P;
    if ("TID30pd".equals(codeString))
      return V3Dentition.TID30PD;
    if ("TID30pm".equals(codeString))
      return V3Dentition.TID30PM;
    if ("TID31a".equals(codeString))
      return V3Dentition.TID31A;
    if ("TID31ad".equals(codeString))
      return V3Dentition.TID31AD;
    if ("TID31am".equals(codeString))
      return V3Dentition.TID31AM;
    if ("TID31i".equals(codeString))
      return V3Dentition.TID31I;
    if ("TID31id".equals(codeString))
      return V3Dentition.TID31ID;
    if ("TID31im".equals(codeString))
      return V3Dentition.TID31IM;
    if ("TID31p".equals(codeString))
      return V3Dentition.TID31P;
    if ("TID31pd".equals(codeString))
      return V3Dentition.TID31PD;
    if ("TID31pm".equals(codeString))
      return V3Dentition.TID31PM;
    if ("TID32a".equals(codeString))
      return V3Dentition.TID32A;
    if ("TID32ad".equals(codeString))
      return V3Dentition.TID32AD;
    if ("TID32am".equals(codeString))
      return V3Dentition.TID32AM;
    if ("TID32i".equals(codeString))
      return V3Dentition.TID32I;
    if ("TID32id".equals(codeString))
      return V3Dentition.TID32ID;
    if ("TID32im".equals(codeString))
      return V3Dentition.TID32IM;
    if ("TID32p".equals(codeString))
      return V3Dentition.TID32P;
    if ("TID32pd".equals(codeString))
      return V3Dentition.TID32PD;
    if ("TID32pm".equals(codeString))
      return V3Dentition.TID32PM;
    if ("TID3a".equals(codeString))
      return V3Dentition.TID3A;
    if ("TID3i".equals(codeString))
      return V3Dentition.TID3I;
    if ("TID3p".equals(codeString))
      return V3Dentition.TID3P;
    if ("TID3pd".equals(codeString))
      return V3Dentition.TID3PD;
    if ("TID3pm".equals(codeString))
      return V3Dentition.TID3PM;
    if ("TID4a".equals(codeString))
      return V3Dentition.TID4A;
    if ("TID4i".equals(codeString))
      return V3Dentition.TID4I;
    if ("TID4p".equals(codeString))
      return V3Dentition.TID4P;
    if ("TID4pd".equals(codeString))
      return V3Dentition.TID4PD;
    if ("TID4pm".equals(codeString))
      return V3Dentition.TID4PM;
    if ("TID5a".equals(codeString))
      return V3Dentition.TID5A;
    if ("TID5i".equals(codeString))
      return V3Dentition.TID5I;
    if ("TID5p".equals(codeString))
      return V3Dentition.TID5P;
    if ("TID5pd".equals(codeString))
      return V3Dentition.TID5PD;
    if ("TID5pm".equals(codeString))
      return V3Dentition.TID5PM;
    if ("TID6a".equals(codeString))
      return V3Dentition.TID6A;
    if ("TID6i".equals(codeString))
      return V3Dentition.TID6I;
    if ("TID6p".equals(codeString))
      return V3Dentition.TID6P;
    if ("TID6pd".equals(codeString))
      return V3Dentition.TID6PD;
    if ("TID6pm".equals(codeString))
      return V3Dentition.TID6PM;
    if ("TID7a".equals(codeString))
      return V3Dentition.TID7A;
    if ("TID7i".equals(codeString))
      return V3Dentition.TID7I;
    if ("TID7p".equals(codeString))
      return V3Dentition.TID7P;
    if ("TID7pd".equals(codeString))
      return V3Dentition.TID7PD;
    if ("TID7pm".equals(codeString))
      return V3Dentition.TID7PM;
    if ("TID8a".equals(codeString))
      return V3Dentition.TID8A;
    if ("TID8i".equals(codeString))
      return V3Dentition.TID8I;
    if ("TID8p".equals(codeString))
      return V3Dentition.TID8P;
    if ("TID8pd".equals(codeString))
      return V3Dentition.TID8PD;
    if ("TID8pm".equals(codeString))
      return V3Dentition.TID8PM;
    if ("TID9a".equals(codeString))
      return V3Dentition.TID9A;
    if ("TID9i".equals(codeString))
      return V3Dentition.TID9I;
    if ("TID9p".equals(codeString))
      return V3Dentition.TID9P;
    if ("TID9pd".equals(codeString))
      return V3Dentition.TID9PD;
    if ("TID9pm".equals(codeString))
      return V3Dentition.TID9PM;
    if ("PermanentDentition".equals(codeString))
      return V3Dentition.PERMANENTDENTITION;
    if ("TID1".equals(codeString))
      return V3Dentition.TID1;
    if ("TID10".equals(codeString))
      return V3Dentition.TID10;
    if ("TID11".equals(codeString))
      return V3Dentition.TID11;
    if ("TID12".equals(codeString))
      return V3Dentition.TID12;
    if ("TID13".equals(codeString))
      return V3Dentition.TID13;
    if ("TID14".equals(codeString))
      return V3Dentition.TID14;
    if ("TID15".equals(codeString))
      return V3Dentition.TID15;
    if ("TID16".equals(codeString))
      return V3Dentition.TID16;
    if ("TID17".equals(codeString))
      return V3Dentition.TID17;
    if ("TID17d".equals(codeString))
      return V3Dentition.TID17D;
    if ("TID17m".equals(codeString))
      return V3Dentition.TID17M;
    if ("TID18".equals(codeString))
      return V3Dentition.TID18;
    if ("TID18d".equals(codeString))
      return V3Dentition.TID18D;
    if ("TID18m".equals(codeString))
      return V3Dentition.TID18M;
    if ("TID19".equals(codeString))
      return V3Dentition.TID19;
    if ("TID19d".equals(codeString))
      return V3Dentition.TID19D;
    if ("TID19m".equals(codeString))
      return V3Dentition.TID19M;
    if ("TID2".equals(codeString))
      return V3Dentition.TID2;
    if ("TID20".equals(codeString))
      return V3Dentition.TID20;
    if ("TID21".equals(codeString))
      return V3Dentition.TID21;
    if ("TID22".equals(codeString))
      return V3Dentition.TID22;
    if ("TID23".equals(codeString))
      return V3Dentition.TID23;
    if ("TID24".equals(codeString))
      return V3Dentition.TID24;
    if ("TID25".equals(codeString))
      return V3Dentition.TID25;
    if ("TID26".equals(codeString))
      return V3Dentition.TID26;
    if ("TID27".equals(codeString))
      return V3Dentition.TID27;
    if ("TID28".equals(codeString))
      return V3Dentition.TID28;
    if ("TID29".equals(codeString))
      return V3Dentition.TID29;
    if ("TID3".equals(codeString))
      return V3Dentition.TID3;
    if ("TID30".equals(codeString))
      return V3Dentition.TID30;
    if ("TID30d".equals(codeString))
      return V3Dentition.TID30D;
    if ("TID30m".equals(codeString))
      return V3Dentition.TID30M;
    if ("TID31".equals(codeString))
      return V3Dentition.TID31;
    if ("TID31d".equals(codeString))
      return V3Dentition.TID31D;
    if ("TID31m".equals(codeString))
      return V3Dentition.TID31M;
    if ("TID32".equals(codeString))
      return V3Dentition.TID32;
    if ("TID32d".equals(codeString))
      return V3Dentition.TID32D;
    if ("TID32m".equals(codeString))
      return V3Dentition.TID32M;
    if ("TID4".equals(codeString))
      return V3Dentition.TID4;
    if ("TID5".equals(codeString))
      return V3Dentition.TID5;
    if ("TID6".equals(codeString))
      return V3Dentition.TID6;
    if ("TID7".equals(codeString))
      return V3Dentition.TID7;
    if ("TID8".equals(codeString))
      return V3Dentition.TID8;
    if ("TID9".equals(codeString))
      return V3Dentition.TID9;
    if ("PrimaryDentition".equals(codeString))
      return V3Dentition.PRIMARYDENTITION;
    if ("TIDA".equals(codeString))
      return V3Dentition.TIDA;
    if ("TIDB".equals(codeString))
      return V3Dentition.TIDB;
    if ("TIDC".equals(codeString))
      return V3Dentition.TIDC;
    if ("TIDD".equals(codeString))
      return V3Dentition.TIDD;
    if ("TIDE".equals(codeString))
      return V3Dentition.TIDE;
    if ("TIDF".equals(codeString))
      return V3Dentition.TIDF;
    if ("TIDG".equals(codeString))
      return V3Dentition.TIDG;
    if ("TIDH".equals(codeString))
      return V3Dentition.TIDH;
    if ("TIDI".equals(codeString))
      return V3Dentition.TIDI;
    if ("TIDJ".equals(codeString))
      return V3Dentition.TIDJ;
    if ("TIDK".equals(codeString))
      return V3Dentition.TIDK;
    if ("TIDL".equals(codeString))
      return V3Dentition.TIDL;
    if ("TIDM".equals(codeString))
      return V3Dentition.TIDM;
    if ("TIDN".equals(codeString))
      return V3Dentition.TIDN;
    if ("TIDO".equals(codeString))
      return V3Dentition.TIDO;
    if ("TIDP".equals(codeString))
      return V3Dentition.TIDP;
    if ("TIDQ".equals(codeString))
      return V3Dentition.TIDQ;
    if ("TIDR".equals(codeString))
      return V3Dentition.TIDR;
    if ("TIDS".equals(codeString))
      return V3Dentition.TIDS;
    if ("TIDT".equals(codeString))
      return V3Dentition.TIDT;
    if ("SupernumeraryTooth".equals(codeString))
      return V3Dentition.SUPERNUMERARYTOOTH;
    if ("TID10s".equals(codeString))
      return V3Dentition.TID10S;
    if ("TID11s".equals(codeString))
      return V3Dentition.TID11S;
    if ("TID12s".equals(codeString))
      return V3Dentition.TID12S;
    if ("TID13s".equals(codeString))
      return V3Dentition.TID13S;
    if ("TID14s".equals(codeString))
      return V3Dentition.TID14S;
    if ("TID15s".equals(codeString))
      return V3Dentition.TID15S;
    if ("TID16s".equals(codeString))
      return V3Dentition.TID16S;
    if ("TID17s".equals(codeString))
      return V3Dentition.TID17S;
    if ("TID18s".equals(codeString))
      return V3Dentition.TID18S;
    if ("TID19s".equals(codeString))
      return V3Dentition.TID19S;
    if ("TID1s".equals(codeString))
      return V3Dentition.TID1S;
    if ("TID20s".equals(codeString))
      return V3Dentition.TID20S;
    if ("TID21s".equals(codeString))
      return V3Dentition.TID21S;
    if ("TID22s".equals(codeString))
      return V3Dentition.TID22S;
    if ("TID23s".equals(codeString))
      return V3Dentition.TID23S;
    if ("TID24s".equals(codeString))
      return V3Dentition.TID24S;
    if ("TID25s".equals(codeString))
      return V3Dentition.TID25S;
    if ("TID26s".equals(codeString))
      return V3Dentition.TID26S;
    if ("TID27s".equals(codeString))
      return V3Dentition.TID27S;
    if ("TID28s".equals(codeString))
      return V3Dentition.TID28S;
    if ("TID29s".equals(codeString))
      return V3Dentition.TID29S;
    if ("TID2s".equals(codeString))
      return V3Dentition.TID2S;
    if ("TID30s".equals(codeString))
      return V3Dentition.TID30S;
    if ("TID31s".equals(codeString))
      return V3Dentition.TID31S;
    if ("TID32s".equals(codeString))
      return V3Dentition.TID32S;
    if ("TID3s".equals(codeString))
      return V3Dentition.TID3S;
    if ("TID4s".equals(codeString))
      return V3Dentition.TID4S;
    if ("TID5s".equals(codeString))
      return V3Dentition.TID5S;
    if ("TID6s".equals(codeString))
      return V3Dentition.TID6S;
    if ("TID7s".equals(codeString))
      return V3Dentition.TID7S;
    if ("TID8s".equals(codeString))
      return V3Dentition.TID8S;
    if ("TID9s".equals(codeString))
      return V3Dentition.TID9S;
    if ("TIDAs".equals(codeString))
      return V3Dentition.TIDAS;
    if ("TIDBs".equals(codeString))
      return V3Dentition.TIDBS;
    if ("TIDCs".equals(codeString))
      return V3Dentition.TIDCS;
    if ("TIDDs".equals(codeString))
      return V3Dentition.TIDDS;
    if ("TIDEs".equals(codeString))
      return V3Dentition.TIDES;
    if ("TIDFs".equals(codeString))
      return V3Dentition.TIDFS;
    if ("TIDGs".equals(codeString))
      return V3Dentition.TIDGS;
    if ("TIDHs".equals(codeString))
      return V3Dentition.TIDHS;
    if ("TIDIs".equals(codeString))
      return V3Dentition.TIDIS;
    if ("TIDJs".equals(codeString))
      return V3Dentition.TIDJS;
    if ("TIDKs".equals(codeString))
      return V3Dentition.TIDKS;
    if ("TIDLs".equals(codeString))
      return V3Dentition.TIDLS;
    if ("TIDMs".equals(codeString))
      return V3Dentition.TIDMS;
    if ("TIDNs".equals(codeString))
      return V3Dentition.TIDNS;
    if ("TIDOs".equals(codeString))
      return V3Dentition.TIDOS;
    if ("TIDPs".equals(codeString))
      return V3Dentition.TIDPS;
    if ("TIDQs".equals(codeString))
      return V3Dentition.TIDQS;
    if ("TIDRs".equals(codeString))
      return V3Dentition.TIDRS;
    if ("TIDSs".equals(codeString))
      return V3Dentition.TIDSS;
    if ("TIDTs".equals(codeString))
      return V3Dentition.TIDTS;
    throw new IllegalArgumentException("Unknown V3Dentition code '" + codeString + "'");
  }

  public String toCode(V3Dentition code) {
       if (code == V3Dentition.NULL)
           return null;
       if (code == V3Dentition.ARTIFICIALDENTITION)
      return "ArtificialDentition";
    if (code == V3Dentition.TID10A)
      return "TID10a";
    if (code == V3Dentition.TID10I)
      return "TID10i";
    if (code == V3Dentition.TID10P)
      return "TID10p";
    if (code == V3Dentition.TID10PD)
      return "TID10pd";
    if (code == V3Dentition.TID10PM)
      return "TID10pm";
    if (code == V3Dentition.TID11A)
      return "TID11a";
    if (code == V3Dentition.TID11I)
      return "TID11i";
    if (code == V3Dentition.TID11P)
      return "TID11p";
    if (code == V3Dentition.TID11PD)
      return "TID11pd";
    if (code == V3Dentition.TID11PM)
      return "TID11pm";
    if (code == V3Dentition.TID12A)
      return "TID12a";
    if (code == V3Dentition.TID12I)
      return "TID12i";
    if (code == V3Dentition.TID12P)
      return "TID12p";
    if (code == V3Dentition.TID12PD)
      return "TID12pd";
    if (code == V3Dentition.TID12PM)
      return "TID12pm";
    if (code == V3Dentition.TID13A)
      return "TID13a";
    if (code == V3Dentition.TID13I)
      return "TID13i";
    if (code == V3Dentition.TID13P)
      return "TID13p";
    if (code == V3Dentition.TID13PD)
      return "TID13pd";
    if (code == V3Dentition.TID13PM)
      return "TID13pm";
    if (code == V3Dentition.TID14A)
      return "TID14a";
    if (code == V3Dentition.TID14I)
      return "TID14i";
    if (code == V3Dentition.TID14P)
      return "TID14p";
    if (code == V3Dentition.TID14PD)
      return "TID14pd";
    if (code == V3Dentition.TID14PM)
      return "TID14pm";
    if (code == V3Dentition.TID15A)
      return "TID15a";
    if (code == V3Dentition.TID15I)
      return "TID15i";
    if (code == V3Dentition.TID15P)
      return "TID15p";
    if (code == V3Dentition.TID15PD)
      return "TID15pd";
    if (code == V3Dentition.TID15PM)
      return "TID15pm";
    if (code == V3Dentition.TID16A)
      return "TID16a";
    if (code == V3Dentition.TID16I)
      return "TID16i";
    if (code == V3Dentition.TID16P)
      return "TID16p";
    if (code == V3Dentition.TID16PD)
      return "TID16pd";
    if (code == V3Dentition.TID16PM)
      return "TID16pm";
    if (code == V3Dentition.TID17A)
      return "TID17a";
    if (code == V3Dentition.TID17AD)
      return "TID17ad";
    if (code == V3Dentition.TID17AM)
      return "TID17am";
    if (code == V3Dentition.TID17I)
      return "TID17i";
    if (code == V3Dentition.TID17ID)
      return "TID17id";
    if (code == V3Dentition.TID17IM)
      return "TID17im";
    if (code == V3Dentition.TID17P)
      return "TID17p";
    if (code == V3Dentition.TID17PD)
      return "TID17pd";
    if (code == V3Dentition.TID17PM)
      return "TID17pm";
    if (code == V3Dentition.TID18A)
      return "TID18a";
    if (code == V3Dentition.TID18AD)
      return "TID18ad";
    if (code == V3Dentition.TID18AM)
      return "TID18am";
    if (code == V3Dentition.TID18I)
      return "TID18i";
    if (code == V3Dentition.TID18ID)
      return "TID18id";
    if (code == V3Dentition.TID18IM)
      return "TID18im";
    if (code == V3Dentition.TID18P)
      return "TID18p";
    if (code == V3Dentition.TID18PD)
      return "TID18pd";
    if (code == V3Dentition.TID18PM)
      return "TID18pm";
    if (code == V3Dentition.TID19A)
      return "TID19a";
    if (code == V3Dentition.TID19AD)
      return "TID19ad";
    if (code == V3Dentition.TID19AM)
      return "TID19am";
    if (code == V3Dentition.TID19I)
      return "TID19i";
    if (code == V3Dentition.TID19ID)
      return "TID19id";
    if (code == V3Dentition.TID19IM)
      return "TID19im";
    if (code == V3Dentition.TID19P)
      return "TID19p";
    if (code == V3Dentition.TID19PD)
      return "TID19pd";
    if (code == V3Dentition.TID19PM)
      return "TID19pm";
    if (code == V3Dentition.TID1A)
      return "TID1a";
    if (code == V3Dentition.TID1I)
      return "TID1i";
    if (code == V3Dentition.TID1P)
      return "TID1p";
    if (code == V3Dentition.TID1PD)
      return "TID1pd";
    if (code == V3Dentition.TID1PM)
      return "TID1pm";
    if (code == V3Dentition.TID20A)
      return "TID20a";
    if (code == V3Dentition.TID20I)
      return "TID20i";
    if (code == V3Dentition.TID20P)
      return "TID20p";
    if (code == V3Dentition.TID20PD)
      return "TID20pd";
    if (code == V3Dentition.TID20PM)
      return "TID20pm";
    if (code == V3Dentition.TID21A)
      return "TID21a";
    if (code == V3Dentition.TID21I)
      return "TID21i";
    if (code == V3Dentition.TID21P)
      return "TID21p";
    if (code == V3Dentition.TID21PD)
      return "TID21pd";
    if (code == V3Dentition.TID21PM)
      return "TID21pm";
    if (code == V3Dentition.TID22A)
      return "TID22a";
    if (code == V3Dentition.TID22I)
      return "TID22i";
    if (code == V3Dentition.TID22P)
      return "TID22p";
    if (code == V3Dentition.TID22PD)
      return "TID22pd";
    if (code == V3Dentition.TID22PM)
      return "TID22pm";
    if (code == V3Dentition.TID23A)
      return "TID23a";
    if (code == V3Dentition.TID23I)
      return "TID23i";
    if (code == V3Dentition.TID23P)
      return "TID23p";
    if (code == V3Dentition.TID23PD)
      return "TID23pd";
    if (code == V3Dentition.TID23PM)
      return "TID23pm";
    if (code == V3Dentition.TID24A)
      return "TID24a";
    if (code == V3Dentition.TID24I)
      return "TID24i";
    if (code == V3Dentition.TID24P)
      return "TID24p";
    if (code == V3Dentition.TID24PD)
      return "TID24pd";
    if (code == V3Dentition.TID24PM)
      return "TID24pm";
    if (code == V3Dentition.TID25A)
      return "TID25a";
    if (code == V3Dentition.TID25I)
      return "TID25i";
    if (code == V3Dentition.TID25P)
      return "TID25p";
    if (code == V3Dentition.TID25PD)
      return "TID25pd";
    if (code == V3Dentition.TID25PM)
      return "TID25pm";
    if (code == V3Dentition.TID26A)
      return "TID26a";
    if (code == V3Dentition.TID26I)
      return "TID26i";
    if (code == V3Dentition.TID26P)
      return "TID26p";
    if (code == V3Dentition.TID26PD)
      return "TID26pd";
    if (code == V3Dentition.TID26PM)
      return "TID26pm";
    if (code == V3Dentition.TID27A)
      return "TID27a";
    if (code == V3Dentition.TID27I)
      return "TID27i";
    if (code == V3Dentition.TID27P)
      return "TID27p";
    if (code == V3Dentition.TID27PD)
      return "TID27pd";
    if (code == V3Dentition.TID27PM)
      return "TID27pm";
    if (code == V3Dentition.TID28A)
      return "TID28a";
    if (code == V3Dentition.TID28I)
      return "TID28i";
    if (code == V3Dentition.TID28P)
      return "TID28p";
    if (code == V3Dentition.TID28PD)
      return "TID28pd";
    if (code == V3Dentition.TID28PM)
      return "TID28pm";
    if (code == V3Dentition.TID29A)
      return "TID29a";
    if (code == V3Dentition.TID29I)
      return "TID29i";
    if (code == V3Dentition.TID29P)
      return "TID29p";
    if (code == V3Dentition.TID29PD)
      return "TID29pd";
    if (code == V3Dentition.TID29PM)
      return "TID29pm";
    if (code == V3Dentition.TID2A)
      return "TID2a";
    if (code == V3Dentition.TID2I)
      return "TID2i";
    if (code == V3Dentition.TID2P)
      return "TID2p";
    if (code == V3Dentition.TID2PD)
      return "TID2pd";
    if (code == V3Dentition.TID2PM)
      return "TID2pm";
    if (code == V3Dentition.TID30A)
      return "TID30a";
    if (code == V3Dentition.TID30AD)
      return "TID30ad";
    if (code == V3Dentition.TID30AM)
      return "TID30am";
    if (code == V3Dentition.TID30I)
      return "TID30i";
    if (code == V3Dentition.TID30ID)
      return "TID30id";
    if (code == V3Dentition.TID30IM)
      return "TID30im";
    if (code == V3Dentition.TID30P)
      return "TID30p";
    if (code == V3Dentition.TID30PD)
      return "TID30pd";
    if (code == V3Dentition.TID30PM)
      return "TID30pm";
    if (code == V3Dentition.TID31A)
      return "TID31a";
    if (code == V3Dentition.TID31AD)
      return "TID31ad";
    if (code == V3Dentition.TID31AM)
      return "TID31am";
    if (code == V3Dentition.TID31I)
      return "TID31i";
    if (code == V3Dentition.TID31ID)
      return "TID31id";
    if (code == V3Dentition.TID31IM)
      return "TID31im";
    if (code == V3Dentition.TID31P)
      return "TID31p";
    if (code == V3Dentition.TID31PD)
      return "TID31pd";
    if (code == V3Dentition.TID31PM)
      return "TID31pm";
    if (code == V3Dentition.TID32A)
      return "TID32a";
    if (code == V3Dentition.TID32AD)
      return "TID32ad";
    if (code == V3Dentition.TID32AM)
      return "TID32am";
    if (code == V3Dentition.TID32I)
      return "TID32i";
    if (code == V3Dentition.TID32ID)
      return "TID32id";
    if (code == V3Dentition.TID32IM)
      return "TID32im";
    if (code == V3Dentition.TID32P)
      return "TID32p";
    if (code == V3Dentition.TID32PD)
      return "TID32pd";
    if (code == V3Dentition.TID32PM)
      return "TID32pm";
    if (code == V3Dentition.TID3A)
      return "TID3a";
    if (code == V3Dentition.TID3I)
      return "TID3i";
    if (code == V3Dentition.TID3P)
      return "TID3p";
    if (code == V3Dentition.TID3PD)
      return "TID3pd";
    if (code == V3Dentition.TID3PM)
      return "TID3pm";
    if (code == V3Dentition.TID4A)
      return "TID4a";
    if (code == V3Dentition.TID4I)
      return "TID4i";
    if (code == V3Dentition.TID4P)
      return "TID4p";
    if (code == V3Dentition.TID4PD)
      return "TID4pd";
    if (code == V3Dentition.TID4PM)
      return "TID4pm";
    if (code == V3Dentition.TID5A)
      return "TID5a";
    if (code == V3Dentition.TID5I)
      return "TID5i";
    if (code == V3Dentition.TID5P)
      return "TID5p";
    if (code == V3Dentition.TID5PD)
      return "TID5pd";
    if (code == V3Dentition.TID5PM)
      return "TID5pm";
    if (code == V3Dentition.TID6A)
      return "TID6a";
    if (code == V3Dentition.TID6I)
      return "TID6i";
    if (code == V3Dentition.TID6P)
      return "TID6p";
    if (code == V3Dentition.TID6PD)
      return "TID6pd";
    if (code == V3Dentition.TID6PM)
      return "TID6pm";
    if (code == V3Dentition.TID7A)
      return "TID7a";
    if (code == V3Dentition.TID7I)
      return "TID7i";
    if (code == V3Dentition.TID7P)
      return "TID7p";
    if (code == V3Dentition.TID7PD)
      return "TID7pd";
    if (code == V3Dentition.TID7PM)
      return "TID7pm";
    if (code == V3Dentition.TID8A)
      return "TID8a";
    if (code == V3Dentition.TID8I)
      return "TID8i";
    if (code == V3Dentition.TID8P)
      return "TID8p";
    if (code == V3Dentition.TID8PD)
      return "TID8pd";
    if (code == V3Dentition.TID8PM)
      return "TID8pm";
    if (code == V3Dentition.TID9A)
      return "TID9a";
    if (code == V3Dentition.TID9I)
      return "TID9i";
    if (code == V3Dentition.TID9P)
      return "TID9p";
    if (code == V3Dentition.TID9PD)
      return "TID9pd";
    if (code == V3Dentition.TID9PM)
      return "TID9pm";
    if (code == V3Dentition.PERMANENTDENTITION)
      return "PermanentDentition";
    if (code == V3Dentition.TID1)
      return "TID1";
    if (code == V3Dentition.TID10)
      return "TID10";
    if (code == V3Dentition.TID11)
      return "TID11";
    if (code == V3Dentition.TID12)
      return "TID12";
    if (code == V3Dentition.TID13)
      return "TID13";
    if (code == V3Dentition.TID14)
      return "TID14";
    if (code == V3Dentition.TID15)
      return "TID15";
    if (code == V3Dentition.TID16)
      return "TID16";
    if (code == V3Dentition.TID17)
      return "TID17";
    if (code == V3Dentition.TID17D)
      return "TID17d";
    if (code == V3Dentition.TID17M)
      return "TID17m";
    if (code == V3Dentition.TID18)
      return "TID18";
    if (code == V3Dentition.TID18D)
      return "TID18d";
    if (code == V3Dentition.TID18M)
      return "TID18m";
    if (code == V3Dentition.TID19)
      return "TID19";
    if (code == V3Dentition.TID19D)
      return "TID19d";
    if (code == V3Dentition.TID19M)
      return "TID19m";
    if (code == V3Dentition.TID2)
      return "TID2";
    if (code == V3Dentition.TID20)
      return "TID20";
    if (code == V3Dentition.TID21)
      return "TID21";
    if (code == V3Dentition.TID22)
      return "TID22";
    if (code == V3Dentition.TID23)
      return "TID23";
    if (code == V3Dentition.TID24)
      return "TID24";
    if (code == V3Dentition.TID25)
      return "TID25";
    if (code == V3Dentition.TID26)
      return "TID26";
    if (code == V3Dentition.TID27)
      return "TID27";
    if (code == V3Dentition.TID28)
      return "TID28";
    if (code == V3Dentition.TID29)
      return "TID29";
    if (code == V3Dentition.TID3)
      return "TID3";
    if (code == V3Dentition.TID30)
      return "TID30";
    if (code == V3Dentition.TID30D)
      return "TID30d";
    if (code == V3Dentition.TID30M)
      return "TID30m";
    if (code == V3Dentition.TID31)
      return "TID31";
    if (code == V3Dentition.TID31D)
      return "TID31d";
    if (code == V3Dentition.TID31M)
      return "TID31m";
    if (code == V3Dentition.TID32)
      return "TID32";
    if (code == V3Dentition.TID32D)
      return "TID32d";
    if (code == V3Dentition.TID32M)
      return "TID32m";
    if (code == V3Dentition.TID4)
      return "TID4";
    if (code == V3Dentition.TID5)
      return "TID5";
    if (code == V3Dentition.TID6)
      return "TID6";
    if (code == V3Dentition.TID7)
      return "TID7";
    if (code == V3Dentition.TID8)
      return "TID8";
    if (code == V3Dentition.TID9)
      return "TID9";
    if (code == V3Dentition.PRIMARYDENTITION)
      return "PrimaryDentition";
    if (code == V3Dentition.TIDA)
      return "TIDA";
    if (code == V3Dentition.TIDB)
      return "TIDB";
    if (code == V3Dentition.TIDC)
      return "TIDC";
    if (code == V3Dentition.TIDD)
      return "TIDD";
    if (code == V3Dentition.TIDE)
      return "TIDE";
    if (code == V3Dentition.TIDF)
      return "TIDF";
    if (code == V3Dentition.TIDG)
      return "TIDG";
    if (code == V3Dentition.TIDH)
      return "TIDH";
    if (code == V3Dentition.TIDI)
      return "TIDI";
    if (code == V3Dentition.TIDJ)
      return "TIDJ";
    if (code == V3Dentition.TIDK)
      return "TIDK";
    if (code == V3Dentition.TIDL)
      return "TIDL";
    if (code == V3Dentition.TIDM)
      return "TIDM";
    if (code == V3Dentition.TIDN)
      return "TIDN";
    if (code == V3Dentition.TIDO)
      return "TIDO";
    if (code == V3Dentition.TIDP)
      return "TIDP";
    if (code == V3Dentition.TIDQ)
      return "TIDQ";
    if (code == V3Dentition.TIDR)
      return "TIDR";
    if (code == V3Dentition.TIDS)
      return "TIDS";
    if (code == V3Dentition.TIDT)
      return "TIDT";
    if (code == V3Dentition.SUPERNUMERARYTOOTH)
      return "SupernumeraryTooth";
    if (code == V3Dentition.TID10S)
      return "TID10s";
    if (code == V3Dentition.TID11S)
      return "TID11s";
    if (code == V3Dentition.TID12S)
      return "TID12s";
    if (code == V3Dentition.TID13S)
      return "TID13s";
    if (code == V3Dentition.TID14S)
      return "TID14s";
    if (code == V3Dentition.TID15S)
      return "TID15s";
    if (code == V3Dentition.TID16S)
      return "TID16s";
    if (code == V3Dentition.TID17S)
      return "TID17s";
    if (code == V3Dentition.TID18S)
      return "TID18s";
    if (code == V3Dentition.TID19S)
      return "TID19s";
    if (code == V3Dentition.TID1S)
      return "TID1s";
    if (code == V3Dentition.TID20S)
      return "TID20s";
    if (code == V3Dentition.TID21S)
      return "TID21s";
    if (code == V3Dentition.TID22S)
      return "TID22s";
    if (code == V3Dentition.TID23S)
      return "TID23s";
    if (code == V3Dentition.TID24S)
      return "TID24s";
    if (code == V3Dentition.TID25S)
      return "TID25s";
    if (code == V3Dentition.TID26S)
      return "TID26s";
    if (code == V3Dentition.TID27S)
      return "TID27s";
    if (code == V3Dentition.TID28S)
      return "TID28s";
    if (code == V3Dentition.TID29S)
      return "TID29s";
    if (code == V3Dentition.TID2S)
      return "TID2s";
    if (code == V3Dentition.TID30S)
      return "TID30s";
    if (code == V3Dentition.TID31S)
      return "TID31s";
    if (code == V3Dentition.TID32S)
      return "TID32s";
    if (code == V3Dentition.TID3S)
      return "TID3s";
    if (code == V3Dentition.TID4S)
      return "TID4s";
    if (code == V3Dentition.TID5S)
      return "TID5s";
    if (code == V3Dentition.TID6S)
      return "TID6s";
    if (code == V3Dentition.TID7S)
      return "TID7s";
    if (code == V3Dentition.TID8S)
      return "TID8s";
    if (code == V3Dentition.TID9S)
      return "TID9s";
    if (code == V3Dentition.TIDAS)
      return "TIDAs";
    if (code == V3Dentition.TIDBS)
      return "TIDBs";
    if (code == V3Dentition.TIDCS)
      return "TIDCs";
    if (code == V3Dentition.TIDDS)
      return "TIDDs";
    if (code == V3Dentition.TIDES)
      return "TIDEs";
    if (code == V3Dentition.TIDFS)
      return "TIDFs";
    if (code == V3Dentition.TIDGS)
      return "TIDGs";
    if (code == V3Dentition.TIDHS)
      return "TIDHs";
    if (code == V3Dentition.TIDIS)
      return "TIDIs";
    if (code == V3Dentition.TIDJS)
      return "TIDJs";
    if (code == V3Dentition.TIDKS)
      return "TIDKs";
    if (code == V3Dentition.TIDLS)
      return "TIDLs";
    if (code == V3Dentition.TIDMS)
      return "TIDMs";
    if (code == V3Dentition.TIDNS)
      return "TIDNs";
    if (code == V3Dentition.TIDOS)
      return "TIDOs";
    if (code == V3Dentition.TIDPS)
      return "TIDPs";
    if (code == V3Dentition.TIDQS)
      return "TIDQs";
    if (code == V3Dentition.TIDRS)
      return "TIDRs";
    if (code == V3Dentition.TIDSS)
      return "TIDSs";
    if (code == V3Dentition.TIDTS)
      return "TIDTs";
    return "?";
   }

  public String toSystem(V3Dentition code) {
    return code.getSystem();
  }

}