/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ContactDetail")
public class ContactDetail
extends Type
implements ICompositeType {
    @Child(name="name", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact.")
    protected StringType name;
    @Child(name="telecom", type={ContactPoint.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for individual or organization", formalDefinition="The contact details for the individual (if a name was provided) or the organization.")
    protected List<ContactPoint> telecom;
    private static final long serialVersionUID = 816838773L;

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ContactDetail.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ContactDetail setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ContactDetail setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public ContactDetail setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public ContactDetail addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("name", "string", "The name of an individual to contact.", 0, 1, this.name));
        children.add(new Property("telecom", "ContactPoint", "The contact details for the individual (if a name was provided) or the organization.", 0, Integer.MAX_VALUE, this.telecom));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3373707: {
                return new Property("name", "string", "The name of an individual to contact.", 0, 1, this.name);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "The contact details for the individual (if a name was provided) or the organization.", 0, Integer.MAX_VALUE, this.telecom);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = null;
        } else if (name.equals("telecom")) {
            this.getTelecom().remove(this.castToContactPoint(value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return this.getNameElement();
            }
            case -1429363305: {
                return this.addTelecom();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return new String[]{"string"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property ContactDetail.name");
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ContactDetail";
    }

    @Override
    public ContactDetail copy() {
        ContactDetail dst = new ContactDetail();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ContactDetail dst) {
        super.copyValues(dst);
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint i : this.telecom) {
                dst.telecom.add(i.copy());
            }
        }
    }

    @Override
    protected ContactDetail typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ContactDetail)) {
            return false;
        }
        ContactDetail o = (ContactDetail)other_;
        return ContactDetail.compareDeep(this.name, o.name, true) && ContactDetail.compareDeep(this.telecom, o.telecom, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ContactDetail)) {
            return false;
        }
        ContactDetail o = (ContactDetail)other_;
        return ContactDetail.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.telecom});
    }
}

