/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DetectedIssue", profile="http://hl7.org/fhir/StructureDefinition/DetectedIssue")
public class DetectedIssue
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for the detected issue", formalDefinition="Business identifier associated with the detected issue record.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="Indicates the status of the detected issue.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    protected Enumeration<DetectedIssueStatus> status;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Issue Category, e.g. drug-drug, duplicate therapy, etc.", formalDefinition="Identifies the general type of issue identified.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-category")
    protected CodeableConcept code;
    @Child(name="severity", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="high | moderate | low", formalDefinition="Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-severity")
    protected Enumeration<DetectedIssueSeverity> severity;
    @Child(name="patient", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Associated patient", formalDefinition="Indicates the patient whose record the detected issue is associated with.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="identified", type={DateTimeType.class, Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When identified", formalDefinition="The date or period when the detected issue was initially identified.")
    protected Type identified;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The provider or device that identified the issue", formalDefinition="Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="implicated", type={Reference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Problem resource", formalDefinition="Indicates the resource representing the current activity or proposed activity that is potentially problematic.")
    protected List<Reference> implicated;
    protected List<Resource> implicatedTarget;
    @Child(name="evidence", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supporting evidence", formalDefinition="Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.")
    protected List<DetectedIssueEvidenceComponent> evidence;
    @Child(name="detail", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description and context", formalDefinition="A textual explanation of the detected issue.")
    protected StringType detail;
    @Child(name="reference", type={UriType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Authority for issue", formalDefinition="The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.")
    protected UriType reference;
    @Child(name="mitigation", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Step taken to address", formalDefinition="Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.")
    protected List<DetectedIssueMitigationComponent> mitigation;
    private static final long serialVersionUID = 1404426283L;
    @SearchParamDefinition(name="identifier", path="DetectedIssue.identifier", description="Unique id for the detected issue", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="DetectedIssue.code", description="Issue Category, e.g. drug-drug, duplicate therapy, etc.", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identified", path="DetectedIssue.identified", description="When identified", type="date")
    public static final String SP_IDENTIFIED = "identified";
    public static final DateClientParam IDENTIFIED = new DateClientParam("identified");
    @SearchParamDefinition(name="patient", path="DetectedIssue.patient", description="Associated patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DetectedIssue:patient").toLocked();
    @SearchParamDefinition(name="author", path="DetectedIssue.author", description="The provider or device that identified the issue", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DetectedIssue:author").toLocked();
    @SearchParamDefinition(name="implicated", path="DetectedIssue.implicated", description="Problem resource", type="reference")
    public static final String SP_IMPLICATED = "implicated";
    public static final ReferenceClientParam IMPLICATED = new ReferenceClientParam("implicated");
    public static final Include INCLUDE_IMPLICATED = new Include("DetectedIssue:implicated").toLocked();

    public DetectedIssue() {
    }

    public DetectedIssue(Enumeration<DetectedIssueStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DetectedIssue setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DetectedIssue addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<DetectedIssueStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DetectedIssueStatus>(new DetectedIssueStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DetectedIssue setStatusElement(Enumeration<DetectedIssueStatus> value) {
        this.status = value;
        return this;
    }

    public DetectedIssueStatus getStatus() {
        return this.status == null ? null : (DetectedIssueStatus)((Object)this.status.getValue());
    }

    public DetectedIssue setStatus(DetectedIssueStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DetectedIssueStatus>(new DetectedIssueStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DetectedIssue setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<DetectedIssueSeverity> getSeverityElement() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
        }
        return this.severity;
    }

    public boolean hasSeverityElement() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public DetectedIssue setSeverityElement(Enumeration<DetectedIssueSeverity> value) {
        this.severity = value;
        return this;
    }

    public DetectedIssueSeverity getSeverity() {
        return this.severity == null ? null : (DetectedIssueSeverity)((Object)this.severity.getValue());
    }

    public DetectedIssue setSeverity(DetectedIssueSeverity value) {
        if (value == null) {
            this.severity = null;
        } else {
            if (this.severity == null) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public DetectedIssue setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public DetectedIssue setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Type getIdentified() {
        return this.identified;
    }

    public DateTimeType getIdentifiedDateTimeType() throws FHIRException {
        if (this.identified == null) {
            this.identified = new DateTimeType();
        }
        if (!(this.identified instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.identified.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.identified;
    }

    public boolean hasIdentifiedDateTimeType() {
        return this.identified instanceof DateTimeType;
    }

    public Period getIdentifiedPeriod() throws FHIRException {
        if (this.identified == null) {
            this.identified = new Period();
        }
        if (!(this.identified instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.identified.getClass().getName() + " was encountered");
        }
        return (Period)this.identified;
    }

    public boolean hasIdentifiedPeriod() {
        return this.identified instanceof Period;
    }

    public boolean hasIdentified() {
        return this.identified != null && !this.identified.isEmpty();
    }

    public DetectedIssue setIdentified(Type value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for DetectedIssue.identified[x]: " + value.fhirType());
        }
        this.identified = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public DetectedIssue setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public DetectedIssue setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public List<Reference> getImplicated() {
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        return this.implicated;
    }

    public DetectedIssue setImplicated(List<Reference> theImplicated) {
        this.implicated = theImplicated;
        return this;
    }

    public boolean hasImplicated() {
        if (this.implicated == null) {
            return false;
        }
        for (Reference item : this.implicated) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImplicated() {
        Reference t = new Reference();
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return t;
    }

    public DetectedIssue addImplicated(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return this;
    }

    public Reference getImplicatedFirstRep() {
        if (this.getImplicated().isEmpty()) {
            this.addImplicated();
        }
        return this.getImplicated().get(0);
    }

    public List<DetectedIssueEvidenceComponent> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        return this.evidence;
    }

    public DetectedIssue setEvidence(List<DetectedIssueEvidenceComponent> theEvidence) {
        this.evidence = theEvidence;
        return this;
    }

    public boolean hasEvidence() {
        if (this.evidence == null) {
            return false;
        }
        for (DetectedIssueEvidenceComponent item : this.evidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetectedIssueEvidenceComponent addEvidence() {
        DetectedIssueEvidenceComponent t = new DetectedIssueEvidenceComponent();
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        this.evidence.add(t);
        return t;
    }

    public DetectedIssue addEvidence(DetectedIssueEvidenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        this.evidence.add(t);
        return this;
    }

    public DetectedIssueEvidenceComponent getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public StringType getDetailElement() {
        if (this.detail == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.detail");
            }
            if (Configuration.doAutoCreate()) {
                this.detail = new StringType();
            }
        }
        return this.detail;
    }

    public boolean hasDetailElement() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public boolean hasDetail() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public DetectedIssue setDetailElement(StringType value) {
        this.detail = value;
        return this;
    }

    public String getDetail() {
        return this.detail == null ? null : (String)this.detail.getValue();
    }

    public DetectedIssue setDetail(String value) {
        if (Utilities.noString((String)value)) {
            this.detail = null;
        } else {
            if (this.detail == null) {
                this.detail = new StringType();
            }
            this.detail.setValue(value);
        }
        return this;
    }

    public UriType getReferenceElement() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new UriType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public DetectedIssue setReferenceElement(UriType value) {
        this.reference = value;
        return this;
    }

    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public DetectedIssue setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public List<DetectedIssueMitigationComponent> getMitigation() {
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        return this.mitigation;
    }

    public DetectedIssue setMitigation(List<DetectedIssueMitigationComponent> theMitigation) {
        this.mitigation = theMitigation;
        return this;
    }

    public boolean hasMitigation() {
        if (this.mitigation == null) {
            return false;
        }
        for (DetectedIssueMitigationComponent item : this.mitigation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetectedIssueMitigationComponent addMitigation() {
        DetectedIssueMitigationComponent t = new DetectedIssueMitigationComponent();
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return t;
    }

    public DetectedIssue addMitigation(DetectedIssueMitigationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return this;
    }

    public DetectedIssueMitigationComponent getMitigationFirstRep() {
        if (this.getMitigation().isEmpty()) {
            this.addMitigation();
        }
        return this.getMitigation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier associated with the detected issue record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", SP_CODE, "Indicates the status of the detected issue.", 0, 1, this.status));
        children.add(new Property(SP_CODE, "CodeableConcept", "Identifies the general type of issue identified.", 0, 1, this.code));
        children.add(new Property("severity", SP_CODE, "Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.", 0, 1, this.severity));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Indicates the patient whose record the detected issue is associated with.", 0, 1, this.patient));
        children.add(new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device)", "Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.", 0, 1, this.author));
        children.add(new Property(SP_IMPLICATED, "Reference(Any)", "Indicates the resource representing the current activity or proposed activity that is potentially problematic.", 0, Integer.MAX_VALUE, this.implicated));
        children.add(new Property("evidence", "", "Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.evidence));
        children.add(new Property("detail", "string", "A textual explanation of the detected issue.", 0, 1, this.detail));
        children.add(new Property("reference", "uri", "The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.", 0, 1, this.reference));
        children.add(new Property("mitigation", "", "Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.", 0, Integer.MAX_VALUE, this.mitigation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier associated with the detected issue record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", SP_CODE, "Indicates the status of the detected issue.", 0, 1, this.status);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Identifies the general type of issue identified.", 0, 1, this.code);
            }
            case 1478300413: {
                return new Property("severity", SP_CODE, "Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.", 0, 1, this.severity);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Indicates the patient whose record the detected issue is associated with.", 0, 1, this.patient);
            }
            case 569355781: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -1618432869: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -968788650: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case 520482364: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device)", "Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.", 0, 1, this.author);
            }
            case -810216884: {
                return new Property(SP_IMPLICATED, "Reference(Any)", "Indicates the resource representing the current activity or proposed activity that is potentially problematic.", 0, Integer.MAX_VALUE, this.implicated);
            }
            case 382967383: {
                return new Property("evidence", "", "Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.evidence);
            }
            case -1335224239: {
                return new Property("detail", "string", "A textual explanation of the detected issue.", 0, 1, this.detail);
            }
            case -925155509: {
                return new Property("reference", "uri", "The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.", 0, 1, this.reference);
            }
            case 1293793087: {
                return new Property("mitigation", "", "Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.", 0, Integer.MAX_VALUE, this.mitigation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case -1618432869: {
                Base[] baseArray;
                if (this.identified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.identified;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.author;
                }
                return baseArray;
            }
            case -810216884: {
                return this.implicated == null ? new Base[]{} : this.implicated.toArray(new Base[this.implicated.size()]);
            }
            case 382967383: {
                return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
            }
            case -1335224239: {
                Base[] baseArray;
                if (this.detail == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.detail;
                }
                return baseArray;
            }
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.reference;
                }
                return baseArray;
            }
            case 1293793087: {
                return this.mitigation == null ? new Base[]{} : this.mitigation.toArray(new Base[this.mitigation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new DetectedIssueStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case 1478300413: {
                value = new DetectedIssueSeverityEnumFactory().fromType(this.castToCode(value));
                this.severity = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -1618432869: {
                this.identified = this.castToType(value);
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case -810216884: {
                this.getImplicated().add(this.castToReference(value));
                return value;
            }
            case 382967383: {
                this.getEvidence().add((DetectedIssueEvidenceComponent)((Object)value));
                return value;
            }
            case -1335224239: {
                this.detail = this.castToString(value);
                return value;
            }
            case -925155509: {
                this.reference = this.castToUri(value);
                return value;
            }
            case 1293793087: {
                this.getMitigation().add((DetectedIssueMitigationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new DetectedIssueStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("severity")) {
            value = new DetectedIssueSeverityEnumFactory().fromType(this.castToCode(value));
            this.severity = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("identified[x]")) {
            this.identified = this.castToType(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_IMPLICATED)) {
            this.getImplicated().add(this.castToReference(value));
        } else if (name.equals("evidence")) {
            this.getEvidence().add((DetectedIssueEvidenceComponent)((Object)value));
        } else if (name.equals("detail")) {
            this.detail = this.castToString(value);
        } else if (name.equals("reference")) {
            this.reference = this.castToUri(value);
        } else if (name.equals("mitigation")) {
            this.getMitigation().add((DetectedIssueMitigationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            this.status = null;
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals("severity")) {
            this.severity = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("identified[x]")) {
            this.identified = null;
        } else if (name.equals(SP_AUTHOR)) {
            this.author = null;
        } else if (name.equals(SP_IMPLICATED)) {
            this.getImplicated().remove(this.castToReference(value));
        } else if (name.equals("evidence")) {
            this.getEvidence().remove((DetectedIssueEvidenceComponent)value);
        } else if (name.equals("detail")) {
            this.detail = null;
        } else if (name.equals("reference")) {
            this.reference = null;
        } else if (name.equals("mitigation")) {
            this.getMitigation().remove((DetectedIssueMitigationComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1478300413: {
                return this.getSeverityElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 569355781: {
                return this.getIdentified();
            }
            case -1618432869: {
                return this.getIdentified();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -810216884: {
                return this.addImplicated();
            }
            case 382967383: {
                return this.addEvidence();
            }
            case -1335224239: {
                return this.getDetailElement();
            }
            case -925155509: {
                return this.getReferenceElement();
            }
            case 1293793087: {
                return this.addMitigation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{SP_CODE};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -1618432869: {
                return new String[]{"dateTime", "Period"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -810216884: {
                return new String[]{"Reference"};
            }
            case 382967383: {
                return new String[0];
            }
            case -1335224239: {
                return new String[]{"string"};
            }
            case -925155509: {
                return new String[]{"uri"};
            }
            case 1293793087: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property DetectedIssue.status");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("severity")) {
            throw new FHIRException("Cannot call addChild on a singleton property DetectedIssue.severity");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("identifiedDateTime")) {
            this.identified = new DateTimeType();
            return this.identified;
        }
        if (name.equals("identifiedPeriod")) {
            this.identified = new Period();
            return this.identified;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_IMPLICATED)) {
            return this.addImplicated();
        }
        if (name.equals("evidence")) {
            return this.addEvidence();
        }
        if (name.equals("detail")) {
            throw new FHIRException("Cannot call addChild on a singleton property DetectedIssue.detail");
        }
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a singleton property DetectedIssue.reference");
        }
        if (name.equals("mitigation")) {
            return this.addMitigation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DetectedIssue";
    }

    @Override
    public DetectedIssue copy() {
        DetectedIssue dst = new DetectedIssue();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DetectedIssue dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.identified = this.identified == null ? null : this.identified.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.implicated != null) {
            dst.implicated = new ArrayList<Reference>();
            for (Reference reference2 : this.implicated) {
                dst.implicated.add(reference2.copy());
            }
        }
        if (this.evidence != null) {
            dst.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
            for (DetectedIssueEvidenceComponent detectedIssueEvidenceComponent : this.evidence) {
                dst.evidence.add(detectedIssueEvidenceComponent.copy());
            }
        }
        dst.detail = this.detail == null ? null : this.detail.copy();
        UriType uriType = dst.reference = this.reference == null ? null : this.reference.copy();
        if (this.mitigation != null) {
            dst.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
            for (DetectedIssueMitigationComponent detectedIssueMitigationComponent : this.mitigation) {
                dst.mitigation.add(detectedIssueMitigationComponent.copy());
            }
        }
    }

    protected DetectedIssue typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other_;
        return DetectedIssue.compareDeep(this.identifier, o.identifier, true) && DetectedIssue.compareDeep(this.status, o.status, true) && DetectedIssue.compareDeep(this.code, o.code, true) && DetectedIssue.compareDeep(this.severity, o.severity, true) && DetectedIssue.compareDeep(this.patient, o.patient, true) && DetectedIssue.compareDeep(this.identified, o.identified, true) && DetectedIssue.compareDeep(this.author, o.author, true) && DetectedIssue.compareDeep(this.implicated, o.implicated, true) && DetectedIssue.compareDeep(this.evidence, o.evidence, true) && DetectedIssue.compareDeep(this.detail, o.detail, true) && DetectedIssue.compareDeep(this.reference, o.reference, true) && DetectedIssue.compareDeep(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other_;
        return DetectedIssue.compareValues(this.status, o.status, true) && DetectedIssue.compareValues(this.severity, o.severity, true) && DetectedIssue.compareValues(this.detail, o.detail, true) && DetectedIssue.compareValues(this.reference, o.reference, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.code, this.severity, this.patient, this.identified, this.author, this.implicated, this.evidence, this.detail, this.reference, this.mitigation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DetectedIssue;
    }

    public static class DetectedIssueStatusEnumFactory
    implements EnumFactory<DetectedIssueStatus> {
        @Override
        public DetectedIssueStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return DetectedIssueStatus.REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return DetectedIssueStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return DetectedIssueStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return DetectedIssueStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return DetectedIssueStatus.CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return DetectedIssueStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DetectedIssueStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return DetectedIssueStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        public Enumeration<DetectedIssueStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.NULL, code);
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.REGISTERED, code);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.PRELIMINARY, code);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.FINAL, code);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.AMENDED, code);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.CORRECTED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DetectedIssueStatus code) {
            if (code == DetectedIssueStatus.NULL) {
                return null;
            }
            if (code == DetectedIssueStatus.REGISTERED) {
                return "registered";
            }
            if (code == DetectedIssueStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == DetectedIssueStatus.FINAL) {
                return "final";
            }
            if (code == DetectedIssueStatus.AMENDED) {
                return "amended";
            }
            if (code == DetectedIssueStatus.CORRECTED) {
                return "corrected";
            }
            if (code == DetectedIssueStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DetectedIssueStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DetectedIssueStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(DetectedIssueStatus code) {
            return code.getSystem();
        }
    }

    public static enum DetectedIssueStatus {
        REGISTERED,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CORRECTED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static DetectedIssueStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the observation is registered, but there is no result yet available.";
                }
                case PRELIMINARY: {
                    return "This is an initial or interim observation: data may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The observation is complete and there are no further actions needed. Additional information such \"released\", \"signed\", etc would be represented using [Provenance](provenance.html) which provides not only the act but also the actors and dates and other related data. These act states would be associated with an observation status of `preliminary` until they are all completed and then a status of `final` would be applied.";
                }
                case AMENDED: {
                    return "Subsequent to being Final, the observation has been modified subsequent.  This includes updates/new information and corrections.";
                }
                case CORRECTED: {
                    return "Subsequent to being Final, the observation has been modified to correct an error in the test result.";
                }
                case CANCELLED: {
                    return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The observation has been withdrawn following previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DetectedIssueSeverityEnumFactory
    implements EnumFactory<DetectedIssueSeverity> {
        @Override
        public DetectedIssueSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("high".equals(codeString)) {
                return DetectedIssueSeverity.HIGH;
            }
            if ("moderate".equals(codeString)) {
                return DetectedIssueSeverity.MODERATE;
            }
            if ("low".equals(codeString)) {
                return DetectedIssueSeverity.LOW;
            }
            throw new IllegalArgumentException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public Enumeration<DetectedIssueSeverity> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.NULL, code);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.HIGH, code);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.MODERATE, code);
            }
            if ("low".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.LOW, code);
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(DetectedIssueSeverity code) {
            if (code == DetectedIssueSeverity.NULL) {
                return null;
            }
            if (code == DetectedIssueSeverity.HIGH) {
                return "high";
            }
            if (code == DetectedIssueSeverity.MODERATE) {
                return "moderate";
            }
            if (code == DetectedIssueSeverity.LOW) {
                return "low";
            }
            return "?";
        }

        @Override
        public String toSystem(DetectedIssueSeverity code) {
            return code.getSystem();
        }
    }

    public static enum DetectedIssueSeverity {
        HIGH,
        MODERATE,
        LOW,
        NULL;


        public static DetectedIssueSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HIGH: {
                    return "high";
                }
                case MODERATE: {
                    return "moderate";
                }
                case LOW: {
                    return "low";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HIGH: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case LOW: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HIGH: {
                    return "Indicates the issue may be life-threatening or has the potential to cause permanent injury.";
                }
                case MODERATE: {
                    return "Indicates the issue may result in noticeable adverse consequences but is unlikely to be life-threatening or cause permanent injury.";
                }
                case LOW: {
                    return "Indicates the issue may result in some adverse consequences but is unlikely to substantially affect the situation of the subject.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HIGH: {
                    return "High";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case LOW: {
                    return "Low";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class DetectedIssueEvidenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Manifestation", formalDefinition="A manifestation that led to the recording of this detected issue.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/manifestation-or-symptom")
        protected List<CodeableConcept> code;
        @Child(name="detail", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting information", formalDefinition="Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = 1135831276L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public DetectedIssueEvidenceComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public DetectedIssueEvidenceComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public DetectedIssueEvidenceComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public DetectedIssueEvidenceComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DetectedIssue.SP_CODE, "CodeableConcept", "A manifestation that led to the recording of this detected issue.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("detail", "Reference(Any)", "Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(DetectedIssue.SP_CODE, "CodeableConcept", "A manifestation that led to the recording of this detected issue.", 0, Integer.MAX_VALUE, this.code);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DetectedIssue.SP_CODE)) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(DetectedIssue.SP_CODE)) {
                this.getCode().remove(this.castToCodeableConcept(value));
            } else if (name.equals("detail")) {
                this.getDetail().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DetectedIssue.SP_CODE)) {
                return this.addCode();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetectedIssueEvidenceComponent copy() {
            DetectedIssueEvidenceComponent dst = new DetectedIssueEvidenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetectedIssueEvidenceComponent dst) {
            super.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueEvidenceComponent)) {
                return false;
            }
            DetectedIssueEvidenceComponent o = (DetectedIssueEvidenceComponent)other_;
            return DetectedIssueEvidenceComponent.compareDeep(this.code, o.code, true) && DetectedIssueEvidenceComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueEvidenceComponent)) {
                return false;
            }
            DetectedIssueEvidenceComponent o = (DetectedIssueEvidenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.detail});
        }

        @Override
        public String fhirType() {
            return "DetectedIssue.evidence";
        }
    }

    @Block
    public static class DetectedIssueMitigationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What mitigation?", formalDefinition="Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-mitigation-action")
        protected CodeableConcept action;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date committed", formalDefinition="Indicates when the mitigating action was documented.")
        protected DateTimeType date;
        @Child(name="author", type={Practitioner.class, PractitionerRole.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is committing?", formalDefinition="Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.")
        protected Reference author;
        protected Resource authorTarget;
        private static final long serialVersionUID = -1928864832L;

        public DetectedIssueMitigationComponent() {
        }

        public DetectedIssueMitigationComponent(CodeableConcept action) {
            this.action = action;
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public DetectedIssueMitigationComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetectedIssueMitigationComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetectedIssueMitigationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public DetectedIssueMitigationComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        public Resource getAuthorTarget() {
            return this.authorTarget;
        }

        public DetectedIssueMitigationComponent setAuthorTarget(Resource value) {
            this.authorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "CodeableConcept", "Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.", 0, 1, this.action));
            children.add(new Property("date", "dateTime", "Indicates when the mitigating action was documented.", 0, 1, this.date));
            children.add(new Property(DetectedIssue.SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.", 0, 1, this.author));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.", 0, 1, this.action);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Indicates when the mitigating action was documented.", 0, 1, this.date);
                }
                case -1406328437: {
                    return new Property(DetectedIssue.SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.", 0, 1, this.author);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.author;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
                case -1406328437: {
                    this.author = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = null;
            } else if (name.equals("date")) {
                this.date = null;
            } else if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1406328437: {
                    return this.getAuthor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a singleton property DetectedIssue.date");
            }
            if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = new Reference();
                return this.author;
            }
            return super.addChild(name);
        }

        @Override
        public DetectedIssueMitigationComponent copy() {
            DetectedIssueMitigationComponent dst = new DetectedIssueMitigationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetectedIssueMitigationComponent dst) {
            super.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.author = this.author == null ? null : this.author.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other_;
            return DetectedIssueMitigationComponent.compareDeep(this.action, o.action, true) && DetectedIssueMitigationComponent.compareDeep(this.date, o.date, true) && DetectedIssueMitigationComponent.compareDeep(this.author, o.author, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other_;
            return DetectedIssueMitigationComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.action, this.date, this.author});
        }

        @Override
        public String fhirType() {
            return "DetectedIssue.mitigation";
        }
    }
}

