/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/StructureDefinition/Device")
public class Device
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by manufacturers other organizations or owners.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={DeviceDefinition.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The reference to the definition for the device", formalDefinition="The reference to the definition for the device.")
    protected Reference definition;
    protected DeviceDefinition definitionTarget;
    @Child(name="udiCarrier", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.")
    protected List<DeviceUdiCarrierComponent> udiCarrier;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error | unknown", formalDefinition="Status of the Device availability.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-status")
    protected Enumeration<FHIRDeviceStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="online | paused | standby | offline | not-ready | transduc-discon | hw-discon | off", formalDefinition="Reason for the dtatus of the Device availability.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-status-reason")
    protected List<CodeableConcept> statusReason;
    @Child(name="distinctIdentifier", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The distinct identification string", formalDefinition="The distinct identification string as required by regulation for a human cell, tissue, or cellular and tissue-based product.")
    protected StringType distinctIdentifier;
    @Child(name="manufacturer", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer.")
    protected StringType manufacturer;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date when the device was made", formalDefinition="The date and time when the device was manufactured.")
    protected DateTimeType manufactureDate;
    @Child(name="expirationDate", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date and time of expiry of this device (if applicable)", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable).")
    protected DateTimeType expirationDate;
    @Child(name="lotNumber", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer.")
    protected StringType lotNumber;
    @Child(name="serialNumber", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Serial number assigned by the manufacturer", formalDefinition="The serial number assigned by the organization when the device was manufactured.")
    protected StringType serialNumber;
    @Child(name="deviceName", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The name of the device as given by the manufacturer", formalDefinition="This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.")
    protected List<DeviceDeviceNameComponent> deviceName;
    @Child(name="modelNumber", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The model number for the device", formalDefinition="The model number for the device.")
    protected StringType modelNumber;
    @Child(name="partNumber", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The part number of the device", formalDefinition="The part number of the device.")
    protected StringType partNumber;
    @Child(name="type", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The kind or type of device", formalDefinition="The kind or type of device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
    protected CodeableConcept type;
    @Child(name="specialization", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication", formalDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.")
    protected List<DeviceSpecializationComponent> specialization;
    @Child(name="version", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The actual design of the device or software version running on the device", formalDefinition="The actual design of the device or software version running on the device.")
    protected List<DeviceVersionComponent> version;
    @Child(name="property", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties", formalDefinition="The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.")
    protected List<DevicePropertyComponent> property;
    @Child(name="patient", type={Patient.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient to whom Device is affixed", formalDefinition="Patient information, If the device is affixed to a person.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="owner", type={Organization.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="contact", type={ContactPoint.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="location", type={Location.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the device is found", formalDefinition="The place where the device can be found.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="url", type={UriType.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    @Child(name="note", type={Annotation.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="safety", type={CodeableConcept.class}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Safety Characteristics of Device", formalDefinition="Provides additional safety characteristics about a medical device.  For example devices containing latex.")
    protected List<CodeableConcept> safety;
    @Child(name="parent", type={Device.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The parent device", formalDefinition="The parent device.")
    protected Reference parent;
    protected Device parentTarget;
    private static final long serialVersionUID = -298380419L;
    @SearchParamDefinition(name="udi-di", path="Device.udiCarrier.deviceIdentifier", description="The udi Device Identifier (DI)", type="string")
    public static final String SP_UDI_DI = "udi-di";
    public static final StringClientParam UDI_DI = new StringClientParam("udi-di");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="udi-carrier", path="Device.udiCarrier.carrierHRF", description="UDI Barcode (RFID or other technology) string in *HRF* format.", type="string")
    public static final String SP_UDI_CARRIER = "udi-carrier";
    public static final StringClientParam UDI_CARRIER = new StringClientParam("udi-carrier");
    @SearchParamDefinition(name="device-name", path="Device.deviceName.name | Device.type.coding.display | Device.type.text", description="A server defined search that may match any of the string fields in Device.deviceName or Device.type.", type="string")
    public static final String SP_DEVICE_NAME = "device-name";
    public static final StringClientParam DEVICE_NAME = new StringClientParam("device-name");
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Device:patient").toLocked();
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Device:organization").toLocked();
    @SearchParamDefinition(name="model", path="Device.modelNumber", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Device:location").toLocked();
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="status", path="Device.status", description="active | inactive | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Device setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Device addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getDefinition() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new Reference();
            }
        }
        return this.definition;
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public Device setDefinition(Reference value) {
        this.definition = value;
        return this;
    }

    public DeviceDefinition getDefinitionTarget() {
        if (this.definitionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definitionTarget = new DeviceDefinition();
            }
        }
        return this.definitionTarget;
    }

    public Device setDefinitionTarget(DeviceDefinition value) {
        this.definitionTarget = value;
        return this;
    }

    public List<DeviceUdiCarrierComponent> getUdiCarrier() {
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        return this.udiCarrier;
    }

    public Device setUdiCarrier(List<DeviceUdiCarrierComponent> theUdiCarrier) {
        this.udiCarrier = theUdiCarrier;
        return this;
    }

    public boolean hasUdiCarrier() {
        if (this.udiCarrier == null) {
            return false;
        }
        for (DeviceUdiCarrierComponent item : this.udiCarrier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceUdiCarrierComponent addUdiCarrier() {
        DeviceUdiCarrierComponent t = new DeviceUdiCarrierComponent();
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        this.udiCarrier.add(t);
        return t;
    }

    public Device addUdiCarrier(DeviceUdiCarrierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        this.udiCarrier.add(t);
        return this;
    }

    public DeviceUdiCarrierComponent getUdiCarrierFirstRep() {
        if (this.getUdiCarrier().isEmpty()) {
            this.addUdiCarrier();
        }
        return this.getUdiCarrier().get(0);
    }

    public Enumeration<FHIRDeviceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Device setStatusElement(Enumeration<FHIRDeviceStatus> value) {
        this.status = value;
        return this;
    }

    public FHIRDeviceStatus getStatus() {
        return this.status == null ? null : (FHIRDeviceStatus)((Object)this.status.getValue());
    }

    public Device setStatus(FHIRDeviceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public Device setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public Device addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public StringType getDistinctIdentifierElement() {
        if (this.distinctIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.distinctIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.distinctIdentifier = new StringType();
            }
        }
        return this.distinctIdentifier;
    }

    public boolean hasDistinctIdentifierElement() {
        return this.distinctIdentifier != null && !this.distinctIdentifier.isEmpty();
    }

    public boolean hasDistinctIdentifier() {
        return this.distinctIdentifier != null && !this.distinctIdentifier.isEmpty();
    }

    public Device setDistinctIdentifierElement(StringType value) {
        this.distinctIdentifier = value;
        return this;
    }

    public String getDistinctIdentifier() {
        return this.distinctIdentifier == null ? null : (String)this.distinctIdentifier.getValue();
    }

    public Device setDistinctIdentifier(String value) {
        if (Utilities.noString((String)value)) {
            this.distinctIdentifier = null;
        } else {
            if (this.distinctIdentifier == null) {
                this.distinctIdentifier = new StringType();
            }
            this.distinctIdentifier.setValue(value);
        }
        return this;
    }

    public StringType getManufacturerElement() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new StringType();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturerElement() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Device setManufacturerElement(StringType value) {
        this.manufacturer = value;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer == null ? null : (String)this.manufacturer.getValue();
    }

    public Device setManufacturer(String value) {
        if (Utilities.noString((String)value)) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(value);
        }
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public Device setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public Device setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateTimeType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Device setExpirationDateElement(DateTimeType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Device setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateTimeType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Device setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Device setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public StringType getSerialNumberElement() {
        if (this.serialNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.serialNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.serialNumber = new StringType();
            }
        }
        return this.serialNumber;
    }

    public boolean hasSerialNumberElement() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public Device setSerialNumberElement(StringType value) {
        this.serialNumber = value;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber == null ? null : (String)this.serialNumber.getValue();
    }

    public Device setSerialNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.serialNumber = null;
        } else {
            if (this.serialNumber == null) {
                this.serialNumber = new StringType();
            }
            this.serialNumber.setValue(value);
        }
        return this;
    }

    public List<DeviceDeviceNameComponent> getDeviceName() {
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        return this.deviceName;
    }

    public Device setDeviceName(List<DeviceDeviceNameComponent> theDeviceName) {
        this.deviceName = theDeviceName;
        return this;
    }

    public boolean hasDeviceName() {
        if (this.deviceName == null) {
            return false;
        }
        for (DeviceDeviceNameComponent item : this.deviceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDeviceNameComponent addDeviceName() {
        DeviceDeviceNameComponent t = new DeviceDeviceNameComponent();
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return t;
    }

    public Device addDeviceName(DeviceDeviceNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return this;
    }

    public DeviceDeviceNameComponent getDeviceNameFirstRep() {
        if (this.getDeviceName().isEmpty()) {
            this.addDeviceName();
        }
        return this.getDeviceName().get(0);
    }

    public StringType getModelNumberElement() {
        if (this.modelNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.modelNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.modelNumber = new StringType();
            }
        }
        return this.modelNumber;
    }

    public boolean hasModelNumberElement() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public boolean hasModelNumber() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public Device setModelNumberElement(StringType value) {
        this.modelNumber = value;
        return this;
    }

    public String getModelNumber() {
        return this.modelNumber == null ? null : (String)this.modelNumber.getValue();
    }

    public Device setModelNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.modelNumber = null;
        } else {
            if (this.modelNumber == null) {
                this.modelNumber = new StringType();
            }
            this.modelNumber.setValue(value);
        }
        return this;
    }

    public StringType getPartNumberElement() {
        if (this.partNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.partNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.partNumber = new StringType();
            }
        }
        return this.partNumber;
    }

    public boolean hasPartNumberElement() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public boolean hasPartNumber() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public Device setPartNumberElement(StringType value) {
        this.partNumber = value;
        return this;
    }

    public String getPartNumber() {
        return this.partNumber == null ? null : (String)this.partNumber.getValue();
    }

    public Device setPartNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.partNumber = null;
        } else {
            if (this.partNumber == null) {
                this.partNumber = new StringType();
            }
            this.partNumber.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Device setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<DeviceSpecializationComponent> getSpecialization() {
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        return this.specialization;
    }

    public Device setSpecialization(List<DeviceSpecializationComponent> theSpecialization) {
        this.specialization = theSpecialization;
        return this;
    }

    public boolean hasSpecialization() {
        if (this.specialization == null) {
            return false;
        }
        for (DeviceSpecializationComponent item : this.specialization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceSpecializationComponent addSpecialization() {
        DeviceSpecializationComponent t = new DeviceSpecializationComponent();
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        this.specialization.add(t);
        return t;
    }

    public Device addSpecialization(DeviceSpecializationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        this.specialization.add(t);
        return this;
    }

    public DeviceSpecializationComponent getSpecializationFirstRep() {
        if (this.getSpecialization().isEmpty()) {
            this.addSpecialization();
        }
        return this.getSpecialization().get(0);
    }

    public List<DeviceVersionComponent> getVersion() {
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        return this.version;
    }

    public Device setVersion(List<DeviceVersionComponent> theVersion) {
        this.version = theVersion;
        return this;
    }

    public boolean hasVersion() {
        if (this.version == null) {
            return false;
        }
        for (DeviceVersionComponent item : this.version) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceVersionComponent addVersion() {
        DeviceVersionComponent t = new DeviceVersionComponent();
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        this.version.add(t);
        return t;
    }

    public Device addVersion(DeviceVersionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        this.version.add(t);
        return this;
    }

    public DeviceVersionComponent getVersionFirstRep() {
        if (this.getVersion().isEmpty()) {
            this.addVersion();
        }
        return this.getVersion().get(0);
    }

    public List<DevicePropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        return this.property;
    }

    public Device setProperty(List<DevicePropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (DevicePropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DevicePropertyComponent addProperty() {
        DevicePropertyComponent t = new DevicePropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public Device addProperty(DevicePropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public DevicePropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Device setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Device setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Device setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public Device setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Device setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Device addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Device setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Device setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Device setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Device setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Device setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Device addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getSafety() {
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        return this.safety;
    }

    public Device setSafety(List<CodeableConcept> theSafety) {
        this.safety = theSafety;
        return this;
    }

    public boolean hasSafety() {
        if (this.safety == null) {
            return false;
        }
        for (CodeableConcept item : this.safety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSafety() {
        CodeableConcept t = new CodeableConcept();
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return t;
    }

    public Device addSafety(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return this;
    }

    public CodeableConcept getSafetyFirstRep() {
        if (this.getSafety().isEmpty()) {
            this.addSafety();
        }
        return this.getSafety().get(0);
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public Device setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public Device getParentTarget() {
        if (this.parentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parentTarget = new Device();
            }
        }
        return this.parentTarget;
    }

    public Device setParentTarget(Device value) {
        this.parentTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("definition", "Reference(DeviceDefinition)", "The reference to the definition for the device.", 0, 1, this.definition));
        children.add(new Property("udiCarrier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiCarrier));
        children.add(new Property(SP_STATUS, "code", "Status of the Device availability.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Reason for the dtatus of the Device availability.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property("distinctIdentifier", "string", "The distinct identification string as required by regulation for a human cell, tissue, or cellular and tissue-based product.", 0, 1, this.distinctIdentifier));
        children.add(new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, 1, this.manufacturer));
        children.add(new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate));
        children.add(new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate));
        children.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber));
        children.add(new Property("serialNumber", "string", "The serial number assigned by the organization when the device was manufactured.", 0, 1, this.serialNumber));
        children.add(new Property("deviceName", "", "This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.", 0, Integer.MAX_VALUE, this.deviceName));
        children.add(new Property("modelNumber", "string", "The model number for the device.", 0, 1, this.modelNumber));
        children.add(new Property("partNumber", "string", "The part number of the device.", 0, 1, this.partNumber));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind or type of device.", 0, 1, this.type));
        children.add(new Property("specialization", "", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization));
        children.add(new Property("version", "", "The actual design of the device or software version running on the device.", 0, Integer.MAX_VALUE, this.version));
        children.add(new Property("property", "", "The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient information, If the device is affixed to a person.", 0, 1, this.patient));
        children.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner));
        children.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location));
        children.add(new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url));
        children.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety));
        children.add(new Property("parent", "Reference(Device)", "The parent device.", 0, 1, this.parent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property("definition", "Reference(DeviceDefinition)", "The reference to the definition for the device.", 0, 1, this.definition);
            }
            case -1343558178: {
                return new Property("udiCarrier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiCarrier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status of the Device availability.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Reason for the dtatus of the Device availability.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case -1836176187: {
                return new Property("distinctIdentifier", "string", "The distinct identification string as required by regulation for a human cell, tissue, or cellular and tissue-based product.", 0, 1, this.distinctIdentifier);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case 416714767: {
                return new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate);
            }
            case -668811523: {
                return new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate);
            }
            case 462547450: {
                return new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber);
            }
            case 83787357: {
                return new Property("serialNumber", "string", "The serial number assigned by the organization when the device was manufactured.", 0, 1, this.serialNumber);
            }
            case 780988929: {
                return new Property("deviceName", "", "This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.", 0, Integer.MAX_VALUE, this.deviceName);
            }
            case 346619858: {
                return new Property("modelNumber", "string", "The model number for the device.", 0, 1, this.modelNumber);
            }
            case -731502308: {
                return new Property("partNumber", "string", "The part number of the device.", 0, 1, this.partNumber);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind or type of device.", 0, 1, this.type);
            }
            case 682815883: {
                return new Property("specialization", "", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization);
            }
            case 351608024: {
                return new Property("version", "", "The actual design of the device or software version running on the device.", 0, Integer.MAX_VALUE, this.version);
            }
            case -993141291: {
                return new Property("property", "", "The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient information, If the device is affixed to a person.", 0, 1, this.patient);
            }
            case 106164915: {
                return new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location);
            }
            case 116079: {
                return new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note);
            }
            case -909893934: {
                return new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety);
            }
            case -995424086: {
                return new Property("parent", "Reference(Device)", "The parent device.", 0, 1, this.parent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.definition;
                }
                return baseArray;
            }
            case -1343558178: {
                return this.udiCarrier == null ? new Base[]{} : this.udiCarrier.toArray(new Base[this.udiCarrier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case -1836176187: {
                Base[] baseArray;
                if (this.distinctIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.distinctIdentifier;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 416714767: {
                Base[] baseArray;
                if (this.manufactureDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.manufactureDate;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.expirationDate;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.lotNumber;
                }
                return baseArray;
            }
            case 83787357: {
                Base[] baseArray;
                if (this.serialNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.serialNumber;
                }
                return baseArray;
            }
            case 780988929: {
                return this.deviceName == null ? new Base[]{} : this.deviceName.toArray(new Base[this.deviceName.size()]);
            }
            case 346619858: {
                Base[] baseArray;
                if (this.modelNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.modelNumber;
                }
                return baseArray;
            }
            case -731502308: {
                Base[] baseArray;
                if (this.partNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.partNumber;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.type;
                }
                return baseArray;
            }
            case 682815883: {
                return this.specialization == null ? new Base[]{} : this.specialization.toArray(new Base[this.specialization.size()]);
            }
            case 351608024: {
                return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.patient;
                }
                return baseArray;
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.location;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.url;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -909893934: {
                return this.safety == null ? new Base[]{} : this.safety.toArray(new Base[this.safety.size()]);
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.parent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.definition = this.castToReference(value);
                return value;
            }
            case -1343558178: {
                this.getUdiCarrier().add((DeviceUdiCarrierComponent)((Object)value));
                return value;
            }
            case -892481550: {
                value = new FHIRDeviceStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1836176187: {
                this.distinctIdentifier = this.castToString(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = this.castToString(value);
                return value;
            }
            case 416714767: {
                this.manufactureDate = this.castToDateTime(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = this.castToDateTime(value);
                return value;
            }
            case 462547450: {
                this.lotNumber = this.castToString(value);
                return value;
            }
            case 83787357: {
                this.serialNumber = this.castToString(value);
                return value;
            }
            case 780988929: {
                this.getDeviceName().add((DeviceDeviceNameComponent)((Object)value));
                return value;
            }
            case 346619858: {
                this.modelNumber = this.castToString(value);
                return value;
            }
            case -731502308: {
                this.partNumber = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 682815883: {
                this.getSpecialization().add((DeviceSpecializationComponent)((Object)value));
                return value;
            }
            case 351608024: {
                this.getVersion().add((DeviceVersionComponent)((Object)value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((DevicePropertyComponent)((Object)value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactPoint(value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -909893934: {
                this.getSafety().add(this.castToCodeableConcept(value));
                return value;
            }
            case -995424086: {
                this.parent = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("definition")) {
            this.definition = this.castToReference(value);
        } else if (name.equals("udiCarrier")) {
            this.getUdiCarrier().add((DeviceUdiCarrierComponent)((Object)value));
        } else if (name.equals(SP_STATUS)) {
            value = new FHIRDeviceStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("distinctIdentifier")) {
            this.distinctIdentifier = this.castToString(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToString(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = this.castToDateTime(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = this.castToDateTime(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals("serialNumber")) {
            this.serialNumber = this.castToString(value);
        } else if (name.equals("deviceName")) {
            this.getDeviceName().add((DeviceDeviceNameComponent)((Object)value));
        } else if (name.equals("modelNumber")) {
            this.modelNumber = this.castToString(value);
        } else if (name.equals("partNumber")) {
            this.partNumber = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("specialization")) {
            this.getSpecialization().add((DeviceSpecializationComponent)((Object)value));
        } else if (name.equals("version")) {
            this.getVersion().add((DeviceVersionComponent)((Object)value));
        } else if (name.equals("property")) {
            this.getProperty().add((DevicePropertyComponent)((Object)value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("owner")) {
            this.owner = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("safety")) {
            this.getSafety().add(this.castToCodeableConcept(value));
        } else if (name.equals("parent")) {
            this.parent = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals("definition")) {
            this.definition = null;
        } else if (name.equals("udiCarrier")) {
            this.getUdiCarrier().remove((DeviceUdiCarrierComponent)value);
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().remove(this.castToCodeableConcept(value));
        } else if (name.equals("distinctIdentifier")) {
            this.distinctIdentifier = null;
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = null;
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = null;
        } else if (name.equals("expirationDate")) {
            this.expirationDate = null;
        } else if (name.equals("lotNumber")) {
            this.lotNumber = null;
        } else if (name.equals("serialNumber")) {
            this.serialNumber = null;
        } else if (name.equals("deviceName")) {
            this.getDeviceName().remove((DeviceDeviceNameComponent)value);
        } else if (name.equals("modelNumber")) {
            this.modelNumber = null;
        } else if (name.equals("partNumber")) {
            this.partNumber = null;
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals("specialization")) {
            this.getSpecialization().remove((DeviceSpecializationComponent)value);
        } else if (name.equals("version")) {
            this.getVersion().remove((DeviceVersionComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().remove((DevicePropertyComponent)value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("owner")) {
            this.owner = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(this.castToContactPoint(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = null;
        } else if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals("note")) {
            this.getNote().remove(this.castToAnnotation(value));
        } else if (name.equals("safety")) {
            this.getSafety().remove(this.castToCodeableConcept(value));
        } else if (name.equals("parent")) {
            this.parent = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.getDefinition();
            }
            case -1343558178: {
                return this.addUdiCarrier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case -1836176187: {
                return this.getDistinctIdentifierElement();
            }
            case -1969347631: {
                return this.getManufacturerElement();
            }
            case 416714767: {
                return this.getManufactureDateElement();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case 462547450: {
                return this.getLotNumberElement();
            }
            case 83787357: {
                return this.getSerialNumberElement();
            }
            case 780988929: {
                return this.addDeviceName();
            }
            case 346619858: {
                return this.getModelNumberElement();
            }
            case -731502308: {
                return this.getPartNumberElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 682815883: {
                return this.addSpecialization();
            }
            case 351608024: {
                return this.addVersion();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -909893934: {
                return this.addSafety();
            }
            case -995424086: {
                return this.getParent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -1343558178: {
                return new String[0];
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case -1836176187: {
                return new String[]{"string"};
            }
            case -1969347631: {
                return new String[]{"string"};
            }
            case 416714767: {
                return new String[]{"dateTime"};
            }
            case -668811523: {
                return new String[]{"dateTime"};
            }
            case 462547450: {
                return new String[]{"string"};
            }
            case 83787357: {
                return new String[]{"string"};
            }
            case 780988929: {
                return new String[0];
            }
            case 346619858: {
                return new String[]{"string"};
            }
            case -731502308: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 682815883: {
                return new String[0];
            }
            case 351608024: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 116079: {
                return new String[]{"uri"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -909893934: {
                return new String[]{"CodeableConcept"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("definition")) {
            this.definition = new Reference();
            return this.definition;
        }
        if (name.equals("udiCarrier")) {
            return this.addUdiCarrier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.status");
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals("distinctIdentifier")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.distinctIdentifier");
        }
        if (name.equals(SP_MANUFACTURER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.manufacturer");
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.manufactureDate");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.expirationDate");
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.lotNumber");
        }
        if (name.equals("serialNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.serialNumber");
        }
        if (name.equals("deviceName")) {
            return this.addDeviceName();
        }
        if (name.equals("modelNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.modelNumber");
        }
        if (name.equals("partNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.partNumber");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("specialization")) {
            return this.addSpecialization();
        }
        if (name.equals("version")) {
            return this.addVersion();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.url");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("safety")) {
            return this.addSafety();
        }
        if (name.equals("parent")) {
            this.parent = new Reference();
            return this.parent;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Device";
    }

    @Override
    public Device copy() {
        Device dst = new Device();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Device dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Reference reference = dst.definition = this.definition == null ? null : this.definition.copy();
        if (this.udiCarrier != null) {
            dst.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
            for (DeviceUdiCarrierComponent deviceUdiCarrierComponent : this.udiCarrier) {
                dst.udiCarrier.add(deviceUdiCarrierComponent.copy());
            }
        }
        Enumeration<FHIRDeviceStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.statusReason) {
                dst.statusReason.add(codeableConcept.copy());
            }
        }
        dst.distinctIdentifier = this.distinctIdentifier == null ? null : this.distinctIdentifier.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        StringType stringType = dst.serialNumber = this.serialNumber == null ? null : this.serialNumber.copy();
        if (this.deviceName != null) {
            dst.deviceName = new ArrayList<DeviceDeviceNameComponent>();
            for (DeviceDeviceNameComponent deviceDeviceNameComponent : this.deviceName) {
                dst.deviceName.add(deviceDeviceNameComponent.copy());
            }
        }
        dst.modelNumber = this.modelNumber == null ? null : this.modelNumber.copy();
        dst.partNumber = this.partNumber == null ? null : this.partNumber.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.specialization != null) {
            dst.specialization = new ArrayList<DeviceSpecializationComponent>();
            for (DeviceSpecializationComponent deviceSpecializationComponent : this.specialization) {
                dst.specialization.add(deviceSpecializationComponent.copy());
            }
        }
        if (this.version != null) {
            dst.version = new ArrayList<DeviceVersionComponent>();
            for (DeviceVersionComponent deviceVersionComponent : this.version) {
                dst.version.add(deviceVersionComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<DevicePropertyComponent>();
            for (DevicePropertyComponent devicePropertyComponent : this.property) {
                dst.property.add(devicePropertyComponent.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference2 = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.safety != null) {
            dst.safety = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.safety) {
                dst.safety.add(codeableConcept2.copy());
            }
        }
        dst.parent = this.parent == null ? null : this.parent.copy();
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareDeep(this.identifier, o.identifier, true) && Device.compareDeep(this.definition, o.definition, true) && Device.compareDeep(this.udiCarrier, o.udiCarrier, true) && Device.compareDeep(this.status, o.status, true) && Device.compareDeep(this.statusReason, o.statusReason, true) && Device.compareDeep(this.distinctIdentifier, o.distinctIdentifier, true) && Device.compareDeep(this.manufacturer, o.manufacturer, true) && Device.compareDeep(this.manufactureDate, o.manufactureDate, true) && Device.compareDeep(this.expirationDate, o.expirationDate, true) && Device.compareDeep(this.lotNumber, o.lotNumber, true) && Device.compareDeep(this.serialNumber, o.serialNumber, true) && Device.compareDeep(this.deviceName, o.deviceName, true) && Device.compareDeep(this.modelNumber, o.modelNumber, true) && Device.compareDeep(this.partNumber, o.partNumber, true) && Device.compareDeep(this.type, o.type, true) && Device.compareDeep(this.specialization, o.specialization, true) && Device.compareDeep(this.version, o.version, true) && Device.compareDeep(this.property, o.property, true) && Device.compareDeep(this.patient, o.patient, true) && Device.compareDeep(this.owner, o.owner, true) && Device.compareDeep(this.contact, o.contact, true) && Device.compareDeep(this.location, o.location, true) && Device.compareDeep(this.url, o.url, true) && Device.compareDeep(this.note, o.note, true) && Device.compareDeep(this.safety, o.safety, true) && Device.compareDeep(this.parent, o.parent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareValues(this.status, o.status, true) && Device.compareValues(this.distinctIdentifier, o.distinctIdentifier, true) && Device.compareValues(this.manufacturer, o.manufacturer, true) && Device.compareValues(this.manufactureDate, o.manufactureDate, true) && Device.compareValues(this.expirationDate, o.expirationDate, true) && Device.compareValues(this.lotNumber, o.lotNumber, true) && Device.compareValues(this.serialNumber, o.serialNumber, true) && Device.compareValues(this.modelNumber, o.modelNumber, true) && Device.compareValues(this.partNumber, o.partNumber, true) && Device.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.udiCarrier, this.status, this.statusReason, this.distinctIdentifier, this.manufacturer, this.manufactureDate, this.expirationDate, this.lotNumber, this.serialNumber, this.deviceName, this.modelNumber, this.partNumber, this.type, this.specialization, this.version, this.property, this.patient, this.owner, this.contact, this.location, this.url, this.note, this.safety, this.parent});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }

    @Block
    public static class DeviceUdiCarrierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="deviceIdentifier", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Mandatory fixed portion of UDI", formalDefinition="The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.")
        protected StringType deviceIdentifier;
        @Child(name="issuer", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="UDI Issuing Organization", formalDefinition="Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.")
        protected UriType issuer;
        @Child(name="jurisdiction", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Regional UDI authority", formalDefinition="The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.")
        protected UriType jurisdiction;
        @Child(name="carrierAIDC", type={Base64BinaryType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Machine Readable Barcode String", formalDefinition="The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.")
        protected Base64BinaryType carrierAIDC;
        @Child(name="carrierHRF", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Human Readable Barcode String", formalDefinition="The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.")
        protected StringType carrierHRF;
        @Child(name="entryType", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="barcode | rfid | manual +", formalDefinition="A coded entry to indicate how the data was entered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/udi-entry-type")
        protected Enumeration<UDIEntryType> entryType;
        private static final long serialVersionUID = -191630425L;

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceUdiCarrierComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceUdiCarrierComponent setDeviceIdentifier(String value) {
            if (Utilities.noString((String)value)) {
                this.deviceIdentifier = null;
            } else {
                if (this.deviceIdentifier == null) {
                    this.deviceIdentifier = new StringType();
                }
                this.deviceIdentifier.setValue(value);
            }
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceUdiCarrierComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceUdiCarrierComponent setIssuer(String value) {
            if (Utilities.noString((String)value)) {
                this.issuer = null;
            } else {
                if (this.issuer == null) {
                    this.issuer = new UriType();
                }
                this.issuer.setValue(value);
            }
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceUdiCarrierComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceUdiCarrierComponent setJurisdiction(String value) {
            if (Utilities.noString((String)value)) {
                this.jurisdiction = null;
            } else {
                if (this.jurisdiction == null) {
                    this.jurisdiction = new UriType();
                }
                this.jurisdiction.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getCarrierAIDCElement() {
            if (this.carrierAIDC == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.carrierAIDC");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierAIDC = new Base64BinaryType();
                }
            }
            return this.carrierAIDC;
        }

        public boolean hasCarrierAIDCElement() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public boolean hasCarrierAIDC() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public DeviceUdiCarrierComponent setCarrierAIDCElement(Base64BinaryType value) {
            this.carrierAIDC = value;
            return this;
        }

        public byte[] getCarrierAIDC() {
            return this.carrierAIDC == null ? null : this.carrierAIDC.getValue();
        }

        public DeviceUdiCarrierComponent setCarrierAIDC(byte[] value) {
            if (value == null) {
                this.carrierAIDC = null;
            } else {
                if (this.carrierAIDC == null) {
                    this.carrierAIDC = new Base64BinaryType();
                }
                this.carrierAIDC.setValue(value);
            }
            return this;
        }

        public StringType getCarrierHRFElement() {
            if (this.carrierHRF == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.carrierHRF");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierHRF = new StringType();
                }
            }
            return this.carrierHRF;
        }

        public boolean hasCarrierHRFElement() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public boolean hasCarrierHRF() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public DeviceUdiCarrierComponent setCarrierHRFElement(StringType value) {
            this.carrierHRF = value;
            return this;
        }

        public String getCarrierHRF() {
            return this.carrierHRF == null ? null : (String)this.carrierHRF.getValue();
        }

        public DeviceUdiCarrierComponent setCarrierHRF(String value) {
            if (Utilities.noString((String)value)) {
                this.carrierHRF = null;
            } else {
                if (this.carrierHRF == null) {
                    this.carrierHRF = new StringType();
                }
                this.carrierHRF.setValue(value);
            }
            return this;
        }

        public Enumeration<UDIEntryType> getEntryTypeElement() {
            if (this.entryType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.entryType");
                }
                if (Configuration.doAutoCreate()) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
            }
            return this.entryType;
        }

        public boolean hasEntryTypeElement() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public boolean hasEntryType() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public DeviceUdiCarrierComponent setEntryTypeElement(Enumeration<UDIEntryType> value) {
            this.entryType = value;
            return this;
        }

        public UDIEntryType getEntryType() {
            return this.entryType == null ? null : (UDIEntryType)((Object)this.entryType.getValue());
        }

        public DeviceUdiCarrierComponent setEntryType(UDIEntryType value) {
            if (value == null) {
                this.entryType = null;
            } else {
                if (this.entryType == null) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
                this.entryType.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier));
            children.add(new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.", 0, 1, this.issuer));
            children.add(new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.", 0, 1, this.jurisdiction));
            children.add(new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC));
            children.add(new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF));
            children.add(new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.", 0, 1, this.issuer);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.", 0, 1, this.jurisdiction);
                }
                case -768521825: {
                    return new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC);
                }
                case 806499972: {
                    return new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF);
                }
                case -479362356: {
                    return new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case -768521825: {
                    Base[] baseArray;
                    if (this.carrierAIDC == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.carrierAIDC;
                    }
                    return baseArray;
                }
                case 806499972: {
                    Base[] baseArray;
                    if (this.carrierHRF == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.carrierHRF;
                    }
                    return baseArray;
                }
                case -479362356: {
                    Base[] baseArray;
                    if (this.entryType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.entryType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    this.deviceIdentifier = this.castToString(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = this.castToUri(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = this.castToUri(value);
                    return value;
                }
                case -768521825: {
                    this.carrierAIDC = this.castToBase64Binary(value);
                    return value;
                }
                case 806499972: {
                    this.carrierHRF = this.castToString(value);
                    return value;
                }
                case -479362356: {
                    value = new UDIEntryTypeEnumFactory().fromType(this.castToCode(value));
                    this.entryType = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = this.castToString(value);
            } else if (name.equals("issuer")) {
                this.issuer = this.castToUri(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = this.castToUri(value);
            } else if (name.equals("carrierAIDC")) {
                this.carrierAIDC = this.castToBase64Binary(value);
            } else if (name.equals("carrierHRF")) {
                this.carrierHRF = this.castToString(value);
            } else if (name.equals("entryType")) {
                value = new UDIEntryTypeEnumFactory().fromType(this.castToCode(value));
                this.entryType = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = null;
            } else if (name.equals("issuer")) {
                this.issuer = null;
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = null;
            } else if (name.equals("carrierAIDC")) {
                this.carrierAIDC = null;
            } else if (name.equals("carrierHRF")) {
                this.carrierHRF = null;
            } else if (name.equals("entryType")) {
                this.entryType = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
                case -768521825: {
                    return this.getCarrierAIDCElement();
                }
                case 806499972: {
                    return this.getCarrierHRFElement();
                }
                case -479362356: {
                    return this.getEntryTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return new String[]{"string"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
                case -768521825: {
                    return new String[]{"base64Binary"};
                }
                case 806499972: {
                    return new String[]{"string"};
                }
                case -479362356: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.deviceIdentifier");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.issuer");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.jurisdiction");
            }
            if (name.equals("carrierAIDC")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.carrierAIDC");
            }
            if (name.equals("carrierHRF")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.carrierHRF");
            }
            if (name.equals("entryType")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.entryType");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceUdiCarrierComponent copy() {
            DeviceUdiCarrierComponent dst = new DeviceUdiCarrierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceUdiCarrierComponent dst) {
            super.copyValues(dst);
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.carrierAIDC = this.carrierAIDC == null ? null : this.carrierAIDC.copy();
            dst.carrierHRF = this.carrierHRF == null ? null : this.carrierHRF.copy();
            dst.entryType = this.entryType == null ? null : this.entryType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiCarrierComponent)) {
                return false;
            }
            DeviceUdiCarrierComponent o = (DeviceUdiCarrierComponent)other_;
            return DeviceUdiCarrierComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiCarrierComponent.compareDeep(this.issuer, o.issuer, true) && DeviceUdiCarrierComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && DeviceUdiCarrierComponent.compareDeep(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiCarrierComponent.compareDeep(this.carrierHRF, o.carrierHRF, true) && DeviceUdiCarrierComponent.compareDeep(this.entryType, o.entryType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiCarrierComponent)) {
                return false;
            }
            DeviceUdiCarrierComponent o = (DeviceUdiCarrierComponent)other_;
            return DeviceUdiCarrierComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiCarrierComponent.compareValues(this.issuer, o.issuer, true) && DeviceUdiCarrierComponent.compareValues(this.jurisdiction, o.jurisdiction, true) && DeviceUdiCarrierComponent.compareValues(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiCarrierComponent.compareValues(this.carrierHRF, o.carrierHRF, true) && DeviceUdiCarrierComponent.compareValues(this.entryType, o.entryType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.deviceIdentifier, this.issuer, this.jurisdiction, this.carrierAIDC, this.carrierHRF, this.entryType});
        }

        @Override
        public String fhirType() {
            return "Device.udiCarrier";
        }
    }

    public static class FHIRDeviceStatusEnumFactory
    implements EnumFactory<FHIRDeviceStatus> {
        @Override
        public FHIRDeviceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FHIRDeviceStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FHIRDeviceStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FHIRDeviceStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return FHIRDeviceStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public Enumeration<FHIRDeviceStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRDeviceStatus code) {
            if (code == FHIRDeviceStatus.NULL) {
                return null;
            }
            if (code == FHIRDeviceStatus.ACTIVE) {
                return "active";
            }
            if (code == FHIRDeviceStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FHIRDeviceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FHIRDeviceStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRDeviceStatus code) {
            return code.getSystem();
        }
    }

    public static enum FHIRDeviceStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static FHIRDeviceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/device-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/device-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The device is available for use.  Note: For *implanted devices*  this means that the device is implanted in the patient.";
                }
                case INACTIVE: {
                    return "The device is no longer available for use (e.g. lost, expired, damaged).  Note: For *implanted devices*  this means that the device has been removed from the patient.";
                }
                case ENTEREDINERROR: {
                    return "The device was entered in error and voided.";
                }
                case UNKNOWN: {
                    return "The status of the device has not been determined.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class DeviceDeviceNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of the device", formalDefinition="The name of the device.")
        protected StringType name;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="udi-label-name | user-friendly-name | patient-reported-name | manufacturer-name | model-name | other", formalDefinition="The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-nametype")
        protected Enumeration<DeviceNameType> type;
        private static final long serialVersionUID = 918983440L;

        public DeviceDeviceNameComponent() {
        }

        public DeviceDeviceNameComponent(StringType name, Enumeration<DeviceNameType> type) {
            this.name = name;
            this.type = type;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDeviceNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DeviceDeviceNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DeviceDeviceNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<DeviceNameType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDeviceNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DeviceNameType>(new DeviceNameTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDeviceNameComponent setTypeElement(Enumeration<DeviceNameType> value) {
            this.type = value;
            return this;
        }

        public DeviceNameType getType() {
            return this.type == null ? null : (DeviceNameType)((Object)this.type.getValue());
        }

        public DeviceDeviceNameComponent setType(DeviceNameType value) {
            if (this.type == null) {
                this.type = new Enumeration<DeviceNameType>(new DeviceNameTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name of the device.", 0, 1, this.name));
            children.add(new Property(Device.SP_TYPE, "code", "The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name of the device.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property(Device.SP_TYPE, "code", "The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new DeviceNameTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Device.SP_TYPE)) {
                value = new DeviceNameTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = null;
            } else if (name.equals(Device.SP_TYPE)) {
                this.type = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.name");
            }
            if (name.equals(Device.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.type");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDeviceNameComponent copy() {
            DeviceDeviceNameComponent dst = new DeviceDeviceNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDeviceNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDeviceNameComponent)) {
                return false;
            }
            DeviceDeviceNameComponent o = (DeviceDeviceNameComponent)other_;
            return DeviceDeviceNameComponent.compareDeep(this.name, o.name, true) && DeviceDeviceNameComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDeviceNameComponent)) {
                return false;
            }
            DeviceDeviceNameComponent o = (DeviceDeviceNameComponent)other_;
            return DeviceDeviceNameComponent.compareValues(this.name, o.name, true) && DeviceDeviceNameComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type});
        }

        @Override
        public String fhirType() {
            return "Device.deviceName";
        }
    }

    @Block
    public static class DeviceSpecializationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="systemType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The standard that is used to operate and communicate", formalDefinition="The standard that is used to operate and communicate.")
        protected CodeableConcept systemType;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version of the standard that is used to operate and communicate", formalDefinition="The version of the standard that is used to operate and communicate.")
        protected StringType version;
        private static final long serialVersionUID = 1557342629L;

        public DeviceSpecializationComponent() {
        }

        public DeviceSpecializationComponent(CodeableConcept systemType) {
            this.systemType = systemType;
        }

        public CodeableConcept getSystemType() {
            if (this.systemType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceSpecializationComponent.systemType");
                }
                if (Configuration.doAutoCreate()) {
                    this.systemType = new CodeableConcept();
                }
            }
            return this.systemType;
        }

        public boolean hasSystemType() {
            return this.systemType != null && !this.systemType.isEmpty();
        }

        public DeviceSpecializationComponent setSystemType(CodeableConcept value) {
            this.systemType = value;
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceSpecializationComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public DeviceSpecializationComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public DeviceSpecializationComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("systemType", "CodeableConcept", "The standard that is used to operate and communicate.", 0, 1, this.systemType));
            children.add(new Property("version", "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 642893321: {
                    return new Property("systemType", "CodeableConcept", "The standard that is used to operate and communicate.", 0, 1, this.systemType);
                }
                case 351608024: {
                    return new Property("version", "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    Base[] baseArray;
                    if (this.systemType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.systemType;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    this.systemType = this.castToCodeableConcept(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = this.castToCodeableConcept(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = null;
            } else if (name.equals("version")) {
                this.version = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return this.getSystemType();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return new String[]{"CodeableConcept"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = new CodeableConcept();
                return this.systemType;
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.version");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceSpecializationComponent copy() {
            DeviceSpecializationComponent dst = new DeviceSpecializationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceSpecializationComponent dst) {
            super.copyValues(dst);
            dst.systemType = this.systemType == null ? null : this.systemType.copy();
            dst.version = this.version == null ? null : this.version.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceSpecializationComponent)) {
                return false;
            }
            DeviceSpecializationComponent o = (DeviceSpecializationComponent)other_;
            return DeviceSpecializationComponent.compareDeep(this.systemType, o.systemType, true) && DeviceSpecializationComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceSpecializationComponent)) {
                return false;
            }
            DeviceSpecializationComponent o = (DeviceSpecializationComponent)other_;
            return DeviceSpecializationComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.systemType, this.version});
        }

        @Override
        public String fhirType() {
            return "Device.specialization";
        }
    }

    @Block
    public static class DeviceVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the device version", formalDefinition="The type of the device version.")
        protected CodeableConcept type;
        @Child(name="component", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A single component of the device version", formalDefinition="A single component of the device version.")
        protected Identifier component;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version text", formalDefinition="The version text.")
        protected StringType value;
        private static final long serialVersionUID = 645214295L;

        public DeviceVersionComponent() {
        }

        public DeviceVersionComponent(StringType value) {
            this.value = value;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceVersionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Identifier getComponent() {
            if (this.component == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.component");
                }
                if (Configuration.doAutoCreate()) {
                    this.component = new Identifier();
                }
            }
            return this.component;
        }

        public boolean hasComponent() {
            return this.component != null && !this.component.isEmpty();
        }

        public DeviceVersionComponent setComponent(Identifier value) {
            this.component = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DeviceVersionComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public DeviceVersionComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_TYPE, "CodeableConcept", "The type of the device version.", 0, 1, this.type));
            children.add(new Property("component", "Identifier", "A single component of the device version.", 0, 1, this.component));
            children.add(new Property("value", "string", "The version text.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Device.SP_TYPE, "CodeableConcept", "The type of the device version.", 0, 1, this.type);
                }
                case -1399907075: {
                    return new Property("component", "Identifier", "A single component of the device version.", 0, 1, this.component);
                }
                case 111972721: {
                    return new Property("value", "string", "The version text.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    Base[] baseArray;
                    if (this.component == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.component;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1399907075: {
                    this.component = this.castToIdentifier(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("component")) {
                this.component = this.castToIdentifier(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("component")) {
                this.component = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1399907075: {
                    return this.getComponent();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1399907075: {
                    return new String[]{"Identifier"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("component")) {
                this.component = new Identifier();
                return this.component;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Device.value");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceVersionComponent copy() {
            DeviceVersionComponent dst = new DeviceVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceVersionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.component = this.component == null ? null : this.component.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceVersionComponent)) {
                return false;
            }
            DeviceVersionComponent o = (DeviceVersionComponent)other_;
            return DeviceVersionComponent.compareDeep(this.type, o.type, true) && DeviceVersionComponent.compareDeep(this.component, o.component, true) && DeviceVersionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceVersionComponent)) {
                return false;
            }
            DeviceVersionComponent o = (DeviceVersionComponent)other_;
            return DeviceVersionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.component, this.value});
        }

        @Override
        public String fhirType() {
            return "Device.version";
        }
    }

    @Block
    public static class DevicePropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that specifies the property DeviceDefinitionPropetyCode (Extensible)", formalDefinition="Code that specifies the property DeviceDefinitionPropetyCode (Extensible).")
        protected CodeableConcept type;
        @Child(name="valueQuantity", type={Quantity.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value as a quantity", formalDefinition="Property value as a quantity.")
        protected List<Quantity> valueQuantity;
        @Child(name="valueCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value as a code, e.g., NTP4 (synced to NTP)", formalDefinition="Property value as a code, e.g., NTP4 (synced to NTP).")
        protected List<CodeableConcept> valueCode;
        private static final long serialVersionUID = 1512172633L;

        public DevicePropertyComponent() {
        }

        public DevicePropertyComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DevicePropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DevicePropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Quantity> getValueQuantity() {
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            return this.valueQuantity;
        }

        public DevicePropertyComponent setValueQuantity(List<Quantity> theValueQuantity) {
            this.valueQuantity = theValueQuantity;
            return this;
        }

        public boolean hasValueQuantity() {
            if (this.valueQuantity == null) {
                return false;
            }
            for (Quantity item : this.valueQuantity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValueQuantity() {
            Quantity t = new Quantity();
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return t;
        }

        public DevicePropertyComponent addValueQuantity(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return this;
        }

        public Quantity getValueQuantityFirstRep() {
            if (this.getValueQuantity().isEmpty()) {
                this.addValueQuantity();
            }
            return this.getValueQuantity().get(0);
        }

        public List<CodeableConcept> getValueCode() {
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            return this.valueCode;
        }

        public DevicePropertyComponent setValueCode(List<CodeableConcept> theValueCode) {
            this.valueCode = theValueCode;
            return this;
        }

        public boolean hasValueCode() {
            if (this.valueCode == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return t;
        }

        public DevicePropertyComponent addValueCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return this;
        }

        public CodeableConcept getValueCodeFirstRep() {
            if (this.getValueCode().isEmpty()) {
                this.addValueCode();
            }
            return this.getValueCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_TYPE, "CodeableConcept", "Code that specifies the property DeviceDefinitionPropetyCode (Extensible).", 0, 1, this.type));
            children.add(new Property("valueQuantity", "Quantity", "Property value as a quantity.", 0, Integer.MAX_VALUE, this.valueQuantity));
            children.add(new Property("valueCode", "CodeableConcept", "Property value as a code, e.g., NTP4 (synced to NTP).", 0, Integer.MAX_VALUE, this.valueCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Device.SP_TYPE, "CodeableConcept", "Code that specifies the property DeviceDefinitionPropetyCode (Extensible).", 0, 1, this.type);
                }
                case -2029823716: {
                    return new Property("valueQuantity", "Quantity", "Property value as a quantity.", 0, Integer.MAX_VALUE, this.valueQuantity);
                }
                case -766209282: {
                    return new Property("valueCode", "CodeableConcept", "Property value as a code, e.g., NTP4 (synced to NTP).", 0, Integer.MAX_VALUE, this.valueCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -2029823716: {
                    return this.valueQuantity == null ? new Base[]{} : this.valueQuantity.toArray(new Base[this.valueQuantity.size()]);
                }
                case -766209282: {
                    return this.valueCode == null ? new Base[]{} : this.valueCode.toArray(new Base[this.valueCode.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -2029823716: {
                    this.getValueQuantity().add(this.castToQuantity(value));
                    return value;
                }
                case -766209282: {
                    this.getValueCode().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().add(this.castToQuantity(value));
            } else if (name.equals("valueCode")) {
                this.getValueCode().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().remove(this.castToQuantity(value));
            } else if (name.equals("valueCode")) {
                this.getValueCode().remove(this.castToCodeableConcept(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -2029823716: {
                    return this.addValueQuantity();
                }
                case -766209282: {
                    return this.addValueCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2029823716: {
                    return new String[]{"Quantity"};
                }
                case -766209282: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                return this.addValueQuantity();
            }
            if (name.equals("valueCode")) {
                return this.addValueCode();
            }
            return super.addChild(name);
        }

        @Override
        public DevicePropertyComponent copy() {
            DevicePropertyComponent dst = new DevicePropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DevicePropertyComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.valueQuantity != null) {
                dst.valueQuantity = new ArrayList<Quantity>();
                for (Quantity quantity : this.valueQuantity) {
                    dst.valueQuantity.add(quantity.copy());
                }
            }
            if (this.valueCode != null) {
                dst.valueCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.valueCode) {
                    dst.valueCode.add(codeableConcept2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DevicePropertyComponent)) {
                return false;
            }
            DevicePropertyComponent o = (DevicePropertyComponent)other_;
            return DevicePropertyComponent.compareDeep(this.type, o.type, true) && DevicePropertyComponent.compareDeep(this.valueQuantity, o.valueQuantity, true) && DevicePropertyComponent.compareDeep(this.valueCode, o.valueCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DevicePropertyComponent)) {
                return false;
            }
            DevicePropertyComponent o = (DevicePropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.valueQuantity, this.valueCode});
        }

        @Override
        public String fhirType() {
            return "Device.property";
        }
    }

    public static class DeviceNameTypeEnumFactory
    implements EnumFactory<DeviceNameType> {
        @Override
        public DeviceNameType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("udi-label-name".equals(codeString)) {
                return DeviceNameType.UDILABELNAME;
            }
            if ("user-friendly-name".equals(codeString)) {
                return DeviceNameType.USERFRIENDLYNAME;
            }
            if ("patient-reported-name".equals(codeString)) {
                return DeviceNameType.PATIENTREPORTEDNAME;
            }
            if ("manufacturer-name".equals(codeString)) {
                return DeviceNameType.MANUFACTURERNAME;
            }
            if ("model-name".equals(codeString)) {
                return DeviceNameType.MODELNAME;
            }
            if ("other".equals(codeString)) {
                return DeviceNameType.OTHER;
            }
            throw new IllegalArgumentException("Unknown DeviceNameType code '" + codeString + "'");
        }

        public Enumeration<DeviceNameType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.NULL, code);
            }
            if ("udi-label-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.UDILABELNAME, code);
            }
            if ("user-friendly-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.USERFRIENDLYNAME, code);
            }
            if ("patient-reported-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.PATIENTREPORTEDNAME, code);
            }
            if ("manufacturer-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.MANUFACTURERNAME, code);
            }
            if ("model-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.MODELNAME, code);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.OTHER, code);
            }
            throw new FHIRException("Unknown DeviceNameType code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceNameType code) {
            if (code == DeviceNameType.NULL) {
                return null;
            }
            if (code == DeviceNameType.UDILABELNAME) {
                return "udi-label-name";
            }
            if (code == DeviceNameType.USERFRIENDLYNAME) {
                return "user-friendly-name";
            }
            if (code == DeviceNameType.PATIENTREPORTEDNAME) {
                return "patient-reported-name";
            }
            if (code == DeviceNameType.MANUFACTURERNAME) {
                return "manufacturer-name";
            }
            if (code == DeviceNameType.MODELNAME) {
                return "model-name";
            }
            if (code == DeviceNameType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceNameType code) {
            return code.getSystem();
        }
    }

    public static enum DeviceNameType {
        UDILABELNAME,
        USERFRIENDLYNAME,
        PATIENTREPORTEDNAME,
        MANUFACTURERNAME,
        MODELNAME,
        OTHER,
        NULL;


        public static DeviceNameType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("udi-label-name".equals(codeString)) {
                return UDILABELNAME;
            }
            if ("user-friendly-name".equals(codeString)) {
                return USERFRIENDLYNAME;
            }
            if ("patient-reported-name".equals(codeString)) {
                return PATIENTREPORTEDNAME;
            }
            if ("manufacturer-name".equals(codeString)) {
                return MANUFACTURERNAME;
            }
            if ("model-name".equals(codeString)) {
                return MODELNAME;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceNameType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UDILABELNAME: {
                    return "udi-label-name";
                }
                case USERFRIENDLYNAME: {
                    return "user-friendly-name";
                }
                case PATIENTREPORTEDNAME: {
                    return "patient-reported-name";
                }
                case MANUFACTURERNAME: {
                    return "manufacturer-name";
                }
                case MODELNAME: {
                    return "model-name";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UDILABELNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case USERFRIENDLYNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case PATIENTREPORTEDNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case MANUFACTURERNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case MODELNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UDILABELNAME: {
                    return "UDI Label name.";
                }
                case USERFRIENDLYNAME: {
                    return "User Friendly name.";
                }
                case PATIENTREPORTEDNAME: {
                    return "Patient Reported name.";
                }
                case MANUFACTURERNAME: {
                    return "Manufacturer name.";
                }
                case MODELNAME: {
                    return "Model name.";
                }
                case OTHER: {
                    return "other.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UDILABELNAME: {
                    return "UDI Label name";
                }
                case USERFRIENDLYNAME: {
                    return "User Friendly name";
                }
                case PATIENTREPORTEDNAME: {
                    return "Patient Reported name";
                }
                case MANUFACTURERNAME: {
                    return "Manufacturer name";
                }
                case MODELNAME: {
                    return "Model name";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class UDIEntryTypeEnumFactory
    implements EnumFactory<UDIEntryType> {
        @Override
        public UDIEntryType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return UDIEntryType.BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return UDIEntryType.RFID;
            }
            if ("manual".equals(codeString)) {
                return UDIEntryType.MANUAL;
            }
            if ("card".equals(codeString)) {
                return UDIEntryType.CARD;
            }
            if ("self-reported".equals(codeString)) {
                return UDIEntryType.SELFREPORTED;
            }
            if ("unknown".equals(codeString)) {
                return UDIEntryType.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public Enumeration<UDIEntryType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.NULL, code);
            }
            if ("barcode".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.BARCODE, code);
            }
            if ("rfid".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.RFID, code);
            }
            if ("manual".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.MANUAL, code);
            }
            if ("card".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.CARD, code);
            }
            if ("self-reported".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.SELFREPORTED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.UNKNOWN, code);
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        @Override
        public String toCode(UDIEntryType code) {
            if (code == UDIEntryType.NULL) {
                return null;
            }
            if (code == UDIEntryType.BARCODE) {
                return "barcode";
            }
            if (code == UDIEntryType.RFID) {
                return "rfid";
            }
            if (code == UDIEntryType.MANUAL) {
                return "manual";
            }
            if (code == UDIEntryType.CARD) {
                return "card";
            }
            if (code == UDIEntryType.SELFREPORTED) {
                return "self-reported";
            }
            if (code == UDIEntryType.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(UDIEntryType code) {
            return code.getSystem();
        }
    }

    public static enum UDIEntryType {
        BARCODE,
        RFID,
        MANUAL,
        CARD,
        SELFREPORTED,
        UNKNOWN,
        NULL;


        public static UDIEntryType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return RFID;
            }
            if ("manual".equals(codeString)) {
                return MANUAL;
            }
            if ("card".equals(codeString)) {
                return CARD;
            }
            if ("self-reported".equals(codeString)) {
                return SELFREPORTED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BARCODE: {
                    return "barcode";
                }
                case RFID: {
                    return "rfid";
                }
                case MANUAL: {
                    return "manual";
                }
                case CARD: {
                    return "card";
                }
                case SELFREPORTED: {
                    return "self-reported";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BARCODE: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case RFID: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case MANUAL: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case CARD: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case SELFREPORTED: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BARCODE: {
                    return "a barcodescanner captured the data from the device label.";
                }
                case RFID: {
                    return "An RFID chip reader captured the data from the device label.";
                }
                case MANUAL: {
                    return "The data was read from the label by a person and manually entered. (e.g.  via a keyboard).";
                }
                case CARD: {
                    return "The data originated from a patient's implant card and was read by an operator.";
                }
                case SELFREPORTED: {
                    return "The data originated from a patient source and was not directly scanned or read from a label or card.";
                }
                case UNKNOWN: {
                    return "The method of data capture has not been determined.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BARCODE: {
                    return "Barcode";
                }
                case RFID: {
                    return "RFID";
                }
                case MANUAL: {
                    return "Manual";
                }
                case CARD: {
                    return "Card";
                }
                case SELFREPORTED: {
                    return "Self Reported";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

