/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductPharmaceutical", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductPharmaceutical")
public class MedicinalProductPharmaceutical
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the pharmaceutical medicinal product", formalDefinition="An identifier for the pharmaceutical medicinal product.")
    protected List<Identifier> identifier;
    @Child(name="administrableDoseForm", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The administrable dose form, after necessary reconstitution", formalDefinition="The administrable dose form, after necessary reconstitution.")
    protected CodeableConcept administrableDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="ingredient", type={MedicinalProductIngredient.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Ingredient", formalDefinition="Ingredient.")
    protected List<Reference> ingredient;
    protected List<MedicinalProductIngredient> ingredientTarget;
    @Child(name="device", type={DeviceDefinition.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Accompanying device", formalDefinition="Accompanying device.")
    protected List<Reference> device;
    protected List<DeviceDefinition> deviceTarget;
    @Child(name="characteristics", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Characteristics e.g. a products onset of action", formalDefinition="Characteristics e.g. a products onset of action.")
    protected List<MedicinalProductPharmaceuticalCharacteristicsComponent> characteristics;
    @Child(name="routeOfAdministration", type={}, order=6, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body", formalDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body.")
    protected List<MedicinalProductPharmaceuticalRouteOfAdministrationComponent> routeOfAdministration;
    private static final long serialVersionUID = -1201548050L;
    @SearchParamDefinition(name="identifier", path="MedicinalProductPharmaceutical.identifier", description="An identifier for the pharmaceutical medicinal product", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="route", path="MedicinalProductPharmaceutical.routeOfAdministration.code", description="Coded expression for the route", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="target-species", path="MedicinalProductPharmaceutical.routeOfAdministration.targetSpecies.code", description="Coded expression for the species", type="token")
    public static final String SP_TARGET_SPECIES = "target-species";
    public static final TokenClientParam TARGET_SPECIES = new TokenClientParam("target-species");

    public MedicinalProductPharmaceutical() {
    }

    public MedicinalProductPharmaceutical(CodeableConcept administrableDoseForm) {
        this.administrableDoseForm = administrableDoseForm;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductPharmaceutical setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getAdministrableDoseForm() {
        if (this.administrableDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPharmaceutical.administrableDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.administrableDoseForm = new CodeableConcept();
            }
        }
        return this.administrableDoseForm;
    }

    public boolean hasAdministrableDoseForm() {
        return this.administrableDoseForm != null && !this.administrableDoseForm.isEmpty();
    }

    public MedicinalProductPharmaceutical setAdministrableDoseForm(CodeableConcept value) {
        this.administrableDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPharmaceutical.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public MedicinalProductPharmaceutical setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public MedicinalProductPharmaceutical setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public MedicinalProductPharmaceutical setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public List<MedicinalProductPharmaceuticalCharacteristicsComponent> getCharacteristics() {
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        return this.characteristics;
    }

    public MedicinalProductPharmaceutical setCharacteristics(List<MedicinalProductPharmaceuticalCharacteristicsComponent> theCharacteristics) {
        this.characteristics = theCharacteristics;
        return this;
    }

    public boolean hasCharacteristics() {
        if (this.characteristics == null) {
            return false;
        }
        for (MedicinalProductPharmaceuticalCharacteristicsComponent item : this.characteristics) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPharmaceuticalCharacteristicsComponent addCharacteristics() {
        MedicinalProductPharmaceuticalCharacteristicsComponent t = new MedicinalProductPharmaceuticalCharacteristicsComponent();
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        this.characteristics.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addCharacteristics(MedicinalProductPharmaceuticalCharacteristicsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        this.characteristics.add(t);
        return this;
    }

    public MedicinalProductPharmaceuticalCharacteristicsComponent getCharacteristicsFirstRep() {
        if (this.getCharacteristics().isEmpty()) {
            this.addCharacteristics();
        }
        return this.getCharacteristics().get(0);
    }

    public List<MedicinalProductPharmaceuticalRouteOfAdministrationComponent> getRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationComponent>();
        }
        return this.routeOfAdministration;
    }

    public MedicinalProductPharmaceutical setRouteOfAdministration(List<MedicinalProductPharmaceuticalRouteOfAdministrationComponent> theRouteOfAdministration) {
        this.routeOfAdministration = theRouteOfAdministration;
        return this;
    }

    public boolean hasRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            return false;
        }
        for (MedicinalProductPharmaceuticalRouteOfAdministrationComponent item : this.routeOfAdministration) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPharmaceuticalRouteOfAdministrationComponent addRouteOfAdministration() {
        MedicinalProductPharmaceuticalRouteOfAdministrationComponent t = new MedicinalProductPharmaceuticalRouteOfAdministrationComponent();
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationComponent>();
        }
        this.routeOfAdministration.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addRouteOfAdministration(MedicinalProductPharmaceuticalRouteOfAdministrationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationComponent>();
        }
        this.routeOfAdministration.add(t);
        return this;
    }

    public MedicinalProductPharmaceuticalRouteOfAdministrationComponent getRouteOfAdministrationFirstRep() {
        if (this.getRouteOfAdministration().isEmpty()) {
            this.addRouteOfAdministration();
        }
        return this.getRouteOfAdministration().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation));
        children.add(new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("device", "Reference(DeviceDefinition)", "Accompanying device.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("characteristics", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.characteristics));
        children.add(new Property("routeOfAdministration", "", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1446105202: {
                return new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation);
            }
            case -206409263: {
                return new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -1335157162: {
                return new Property("device", "Reference(DeviceDefinition)", "Accompanying device.", 0, Integer.MAX_VALUE, this.device);
            }
            case -1529171400: {
                return new Property("characteristics", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.characteristics);
            }
            case 1742084734: {
                return new Property("routeOfAdministration", "", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1446105202: {
                Base[] baseArray;
                if (this.administrableDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.administrableDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case -1529171400: {
                return this.characteristics == null ? new Base[]{} : this.characteristics.toArray(new Base[this.characteristics.size()]);
            }
            case 1742084734: {
                return this.routeOfAdministration == null ? new Base[]{} : this.routeOfAdministration.toArray(new Base[this.routeOfAdministration.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 1446105202: {
                this.administrableDoseForm = this.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = this.castToCodeableConcept(value);
                return value;
            }
            case -206409263: {
                this.getIngredient().add(this.castToReference(value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(this.castToReference(value));
                return value;
            }
            case -1529171400: {
                this.getCharacteristics().add((MedicinalProductPharmaceuticalCharacteristicsComponent)value);
                return value;
            }
            case 1742084734: {
                this.getRouteOfAdministration().add((MedicinalProductPharmaceuticalRouteOfAdministrationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = this.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = this.castToCodeableConcept(value);
        } else if (name.equals("ingredient")) {
            this.getIngredient().add(this.castToReference(value));
        } else if (name.equals("device")) {
            this.getDevice().add(this.castToReference(value));
        } else if (name.equals("characteristics")) {
            this.getCharacteristics().add((MedicinalProductPharmaceuticalCharacteristicsComponent)value);
        } else if (name.equals("routeOfAdministration")) {
            this.getRouteOfAdministration().add((MedicinalProductPharmaceuticalRouteOfAdministrationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = null;
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = null;
        } else if (name.equals("ingredient")) {
            this.getIngredient().remove(this.castToReference(value));
        } else if (name.equals("device")) {
            this.getDevice().remove(this.castToReference(value));
        } else if (name.equals("characteristics")) {
            this.getCharacteristics().remove((MedicinalProductPharmaceuticalCharacteristicsComponent)value);
        } else if (name.equals("routeOfAdministration")) {
            this.getRouteOfAdministration().remove((MedicinalProductPharmaceuticalRouteOfAdministrationComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1446105202: {
                return this.getAdministrableDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case -1529171400: {
                return this.addCharacteristics();
            }
            case 1742084734: {
                return this.addRouteOfAdministration();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1446105202: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1529171400: {
                return new String[0];
            }
            case 1742084734: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = new CodeableConcept();
            return this.administrableDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("device")) {
            return this.addDevice();
        }
        if (name.equals("characteristics")) {
            return this.addCharacteristics();
        }
        if (name.equals("routeOfAdministration")) {
            return this.addRouteOfAdministration();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductPharmaceutical";
    }

    @Override
    public MedicinalProductPharmaceutical copy() {
        MedicinalProductPharmaceutical dst = new MedicinalProductPharmaceutical();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductPharmaceutical dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.administrableDoseForm = this.administrableDoseForm == null ? null : this.administrableDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference : this.device) {
                dst.device.add(reference.copy());
            }
        }
        if (this.characteristics != null) {
            dst.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
            for (MedicinalProductPharmaceuticalCharacteristicsComponent medicinalProductPharmaceuticalCharacteristicsComponent : this.characteristics) {
                dst.characteristics.add(medicinalProductPharmaceuticalCharacteristicsComponent.copy());
            }
        }
        if (this.routeOfAdministration != null) {
            dst.routeOfAdministration = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationComponent>();
            for (MedicinalProductPharmaceuticalRouteOfAdministrationComponent medicinalProductPharmaceuticalRouteOfAdministrationComponent : this.routeOfAdministration) {
                dst.routeOfAdministration.add(medicinalProductPharmaceuticalRouteOfAdministrationComponent.copy());
            }
        }
    }

    protected MedicinalProductPharmaceutical typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPharmaceutical)) {
            return false;
        }
        MedicinalProductPharmaceutical o = (MedicinalProductPharmaceutical)other_;
        return MedicinalProductPharmaceutical.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPharmaceutical.compareDeep(this.administrableDoseForm, o.administrableDoseForm, true) && MedicinalProductPharmaceutical.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && MedicinalProductPharmaceutical.compareDeep(this.ingredient, o.ingredient, true) && MedicinalProductPharmaceutical.compareDeep(this.device, o.device, true) && MedicinalProductPharmaceutical.compareDeep(this.characteristics, o.characteristics, true) && MedicinalProductPharmaceutical.compareDeep(this.routeOfAdministration, o.routeOfAdministration, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPharmaceutical)) {
            return false;
        }
        MedicinalProductPharmaceutical o = (MedicinalProductPharmaceutical)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.administrableDoseForm, this.unitOfPresentation, this.ingredient, this.device, this.characteristics, this.routeOfAdministration});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductPharmaceutical;
    }

    @Block
    public static class MedicinalProductPharmaceuticalCharacteristicsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A coded characteristic", formalDefinition="A coded characteristic.")
        protected CodeableConcept code;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of characteristic e.g. assigned or pending", formalDefinition="The status of characteristic e.g. assigned or pending.")
        protected CodeableConcept status;
        private static final long serialVersionUID = 1414556635L;

        public MedicinalProductPharmaceuticalCharacteristicsComponent() {
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalCharacteristicsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalCharacteristicsComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A coded characteristic.", 0, 1, this.code));
            children.add(new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A coded characteristic.", 0, 1, this.code);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("status")) {
                this.status = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -892481550: {
                    return this.getStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPharmaceuticalCharacteristicsComponent copy() {
            MedicinalProductPharmaceuticalCharacteristicsComponent dst = new MedicinalProductPharmaceuticalCharacteristicsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPharmaceuticalCharacteristicsComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.status = this.status == null ? null : this.status.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalCharacteristicsComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalCharacteristicsComponent o = (MedicinalProductPharmaceuticalCharacteristicsComponent)other_;
            return MedicinalProductPharmaceuticalCharacteristicsComponent.compareDeep(this.code, o.code, true) && MedicinalProductPharmaceuticalCharacteristicsComponent.compareDeep(this.status, o.status, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalCharacteristicsComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalCharacteristicsComponent o = (MedicinalProductPharmaceuticalCharacteristicsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.status});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPharmaceutical.characteristics";
        }
    }

    @Block
    public static class MedicinalProductPharmaceuticalRouteOfAdministrationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the route", formalDefinition="Coded expression for the route.")
        protected CodeableConcept code;
        @Child(name="firstDose", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement", formalDefinition="The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.")
        protected Quantity firstDose;
        @Child(name="maxSingleDose", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement", formalDefinition="The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.")
        protected Quantity maxSingleDose;
        @Child(name="maxDosePerDay", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Quantity maxDosePerDay;
        @Child(name="maxDosePerTreatmentPeriod", type={Ratio.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Ratio maxDosePerTreatmentPeriod;
        @Child(name="maxTreatmentPeriod", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Duration maxTreatmentPeriod;
        @Child(name="targetSpecies", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A species for which this route applies", formalDefinition="A species for which this route applies.")
        protected List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent> targetSpecies;
        private static final long serialVersionUID = 854394783L;

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent() {
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Quantity getFirstDose() {
            if (this.firstDose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.firstDose");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstDose = new Quantity();
                }
            }
            return this.firstDose;
        }

        public boolean hasFirstDose() {
            return this.firstDose != null && !this.firstDose.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setFirstDose(Quantity value) {
            this.firstDose = value;
            return this;
        }

        public Quantity getMaxSingleDose() {
            if (this.maxSingleDose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.maxSingleDose");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxSingleDose = new Quantity();
                }
            }
            return this.maxSingleDose;
        }

        public boolean hasMaxSingleDose() {
            return this.maxSingleDose != null && !this.maxSingleDose.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setMaxSingleDose(Quantity value) {
            this.maxSingleDose = value;
            return this;
        }

        public Quantity getMaxDosePerDay() {
            if (this.maxDosePerDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.maxDosePerDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerDay = new Quantity();
                }
            }
            return this.maxDosePerDay;
        }

        public boolean hasMaxDosePerDay() {
            return this.maxDosePerDay != null && !this.maxDosePerDay.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setMaxDosePerDay(Quantity value) {
            this.maxDosePerDay = value;
            return this;
        }

        public Ratio getMaxDosePerTreatmentPeriod() {
            if (this.maxDosePerTreatmentPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.maxDosePerTreatmentPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerTreatmentPeriod = new Ratio();
                }
            }
            return this.maxDosePerTreatmentPeriod;
        }

        public boolean hasMaxDosePerTreatmentPeriod() {
            return this.maxDosePerTreatmentPeriod != null && !this.maxDosePerTreatmentPeriod.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setMaxDosePerTreatmentPeriod(Ratio value) {
            this.maxDosePerTreatmentPeriod = value;
            return this;
        }

        public Duration getMaxTreatmentPeriod() {
            if (this.maxTreatmentPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationComponent.maxTreatmentPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxTreatmentPeriod = new Duration();
                }
            }
            return this.maxTreatmentPeriod;
        }

        public boolean hasMaxTreatmentPeriod() {
            return this.maxTreatmentPeriod != null && !this.maxTreatmentPeriod.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setMaxTreatmentPeriod(Duration value) {
            this.maxTreatmentPeriod = value;
            return this;
        }

        public List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent> getTargetSpecies() {
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent>();
            }
            return this.targetSpecies;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent setTargetSpecies(List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent> theTargetSpecies) {
            this.targetSpecies = theTargetSpecies;
            return this;
        }

        public boolean hasTargetSpecies() {
            if (this.targetSpecies == null) {
                return false;
            }
            for (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent item : this.targetSpecies) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent addTargetSpecies() {
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent t = new MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent();
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent>();
            }
            this.targetSpecies.add(t);
            return t;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent addTargetSpecies(MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent>();
            }
            this.targetSpecies.add(t);
            return this;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent getTargetSpeciesFirstRep() {
            if (this.getTargetSpecies().isEmpty()) {
                this.addTargetSpecies();
            }
            return this.getTargetSpecies().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Coded expression for the route.", 0, 1, this.code));
            children.add(new Property("firstDose", "Quantity", "The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.", 0, 1, this.firstDose));
            children.add(new Property("maxSingleDose", "Quantity", "The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.", 0, 1, this.maxSingleDose));
            children.add(new Property("maxDosePerDay", "Quantity", "The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerDay));
            children.add(new Property("maxDosePerTreatmentPeriod", "Ratio", "The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerTreatmentPeriod));
            children.add(new Property("maxTreatmentPeriod", "Duration", "The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxTreatmentPeriod));
            children.add(new Property("targetSpecies", "", "A species for which this route applies.", 0, Integer.MAX_VALUE, this.targetSpecies));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded expression for the route.", 0, 1, this.code);
                }
                case 132551405: {
                    return new Property("firstDose", "Quantity", "The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.", 0, 1, this.firstDose);
                }
                case -259207927: {
                    return new Property("maxSingleDose", "Quantity", "The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.", 0, 1, this.maxSingleDose);
                }
                case -2017475520: {
                    return new Property("maxDosePerDay", "Quantity", "The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerDay);
                }
                case -608040195: {
                    return new Property("maxDosePerTreatmentPeriod", "Ratio", "The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerTreatmentPeriod);
                }
                case 920698453: {
                    return new Property("maxTreatmentPeriod", "Duration", "The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxTreatmentPeriod);
                }
                case 295481963: {
                    return new Property("targetSpecies", "", "A species for which this route applies.", 0, Integer.MAX_VALUE, this.targetSpecies);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 132551405: {
                    Base[] baseArray;
                    if (this.firstDose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.firstDose;
                    }
                    return baseArray;
                }
                case -259207927: {
                    Base[] baseArray;
                    if (this.maxSingleDose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.maxSingleDose;
                    }
                    return baseArray;
                }
                case -2017475520: {
                    Base[] baseArray;
                    if (this.maxDosePerDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.maxDosePerDay;
                    }
                    return baseArray;
                }
                case -608040195: {
                    Base[] baseArray;
                    if (this.maxDosePerTreatmentPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.maxDosePerTreatmentPeriod;
                    }
                    return baseArray;
                }
                case 920698453: {
                    Base[] baseArray;
                    if (this.maxTreatmentPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.maxTreatmentPeriod;
                    }
                    return baseArray;
                }
                case 295481963: {
                    return this.targetSpecies == null ? new Base[]{} : this.targetSpecies.toArray(new Base[this.targetSpecies.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 132551405: {
                    this.firstDose = this.castToQuantity(value);
                    return value;
                }
                case -259207927: {
                    this.maxSingleDose = this.castToQuantity(value);
                    return value;
                }
                case -2017475520: {
                    this.maxDosePerDay = this.castToQuantity(value);
                    return value;
                }
                case -608040195: {
                    this.maxDosePerTreatmentPeriod = this.castToRatio(value);
                    return value;
                }
                case 920698453: {
                    this.maxTreatmentPeriod = this.castToDuration(value);
                    return value;
                }
                case 295481963: {
                    this.getTargetSpecies().add((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("firstDose")) {
                this.firstDose = this.castToQuantity(value);
            } else if (name.equals("maxSingleDose")) {
                this.maxSingleDose = this.castToQuantity(value);
            } else if (name.equals("maxDosePerDay")) {
                this.maxDosePerDay = this.castToQuantity(value);
            } else if (name.equals("maxDosePerTreatmentPeriod")) {
                this.maxDosePerTreatmentPeriod = this.castToRatio(value);
            } else if (name.equals("maxTreatmentPeriod")) {
                this.maxTreatmentPeriod = this.castToDuration(value);
            } else if (name.equals("targetSpecies")) {
                this.getTargetSpecies().add((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("firstDose")) {
                this.firstDose = null;
            } else if (name.equals("maxSingleDose")) {
                this.maxSingleDose = null;
            } else if (name.equals("maxDosePerDay")) {
                this.maxDosePerDay = null;
            } else if (name.equals("maxDosePerTreatmentPeriod")) {
                this.maxDosePerTreatmentPeriod = null;
            } else if (name.equals("maxTreatmentPeriod")) {
                this.maxTreatmentPeriod = null;
            } else if (name.equals("targetSpecies")) {
                this.getTargetSpecies().remove((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 132551405: {
                    return this.getFirstDose();
                }
                case -259207927: {
                    return this.getMaxSingleDose();
                }
                case -2017475520: {
                    return this.getMaxDosePerDay();
                }
                case -608040195: {
                    return this.getMaxDosePerTreatmentPeriod();
                }
                case 920698453: {
                    return this.getMaxTreatmentPeriod();
                }
                case 295481963: {
                    return this.addTargetSpecies();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 132551405: {
                    return new String[]{"Quantity"};
                }
                case -259207927: {
                    return new String[]{"Quantity"};
                }
                case -2017475520: {
                    return new String[]{"Quantity"};
                }
                case -608040195: {
                    return new String[]{"Ratio"};
                }
                case 920698453: {
                    return new String[]{"Duration"};
                }
                case 295481963: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("firstDose")) {
                this.firstDose = new Quantity();
                return this.firstDose;
            }
            if (name.equals("maxSingleDose")) {
                this.maxSingleDose = new Quantity();
                return this.maxSingleDose;
            }
            if (name.equals("maxDosePerDay")) {
                this.maxDosePerDay = new Quantity();
                return this.maxDosePerDay;
            }
            if (name.equals("maxDosePerTreatmentPeriod")) {
                this.maxDosePerTreatmentPeriod = new Ratio();
                return this.maxDosePerTreatmentPeriod;
            }
            if (name.equals("maxTreatmentPeriod")) {
                this.maxTreatmentPeriod = new Duration();
                return this.maxTreatmentPeriod;
            }
            if (name.equals("targetSpecies")) {
                return this.addTargetSpecies();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPharmaceuticalRouteOfAdministrationComponent copy() {
            MedicinalProductPharmaceuticalRouteOfAdministrationComponent dst = new MedicinalProductPharmaceuticalRouteOfAdministrationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPharmaceuticalRouteOfAdministrationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.firstDose = this.firstDose == null ? null : this.firstDose.copy();
            dst.maxSingleDose = this.maxSingleDose == null ? null : this.maxSingleDose.copy();
            dst.maxDosePerDay = this.maxDosePerDay == null ? null : this.maxDosePerDay.copy();
            dst.maxDosePerTreatmentPeriod = this.maxDosePerTreatmentPeriod == null ? null : this.maxDosePerTreatmentPeriod.copy();
            Duration duration = dst.maxTreatmentPeriod = this.maxTreatmentPeriod == null ? null : this.maxTreatmentPeriod.copy();
            if (this.targetSpecies != null) {
                dst.targetSpecies = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent>();
                for (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent i : this.targetSpecies) {
                    dst.targetSpecies.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationComponent)other_;
            return MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.code, o.code, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.firstDose, o.firstDose, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.maxSingleDose, o.maxSingleDose, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.maxDosePerDay, o.maxDosePerDay, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.maxDosePerTreatmentPeriod, o.maxDosePerTreatmentPeriod, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.maxTreatmentPeriod, o.maxTreatmentPeriod, true) && MedicinalProductPharmaceuticalRouteOfAdministrationComponent.compareDeep(this.targetSpecies, o.targetSpecies, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.firstDose, this.maxSingleDose, this.maxDosePerDay, this.maxDosePerTreatmentPeriod, this.maxTreatmentPeriod, this.targetSpecies});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPharmaceutical.routeOfAdministration";
        }
    }

    @Block
    public static class MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="tissue", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk", formalDefinition="Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.")
        protected CodeableConcept tissue;
        @Child(name="value", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the time", formalDefinition="A value for the time.")
        protected Quantity value;
        @Child(name="supportingInformation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Extra information about the withdrawal period", formalDefinition="Extra information about the withdrawal period.")
        protected StringType supportingInformation;
        private static final long serialVersionUID = -1113691238L;

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent() {
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(CodeableConcept tissue, Quantity value) {
            this.tissue = tissue;
            this.value = value;
        }

        public CodeableConcept getTissue() {
            if (this.tissue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.tissue");
                }
                if (Configuration.doAutoCreate()) {
                    this.tissue = new CodeableConcept();
                }
            }
            return this.tissue;
        }

        public boolean hasTissue() {
            return this.tissue != null && !this.tissue.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setTissue(CodeableConcept value) {
            this.tissue = value;
            return this;
        }

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public StringType getSupportingInformationElement() {
            if (this.supportingInformation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.supportingInformation");
                }
                if (Configuration.doAutoCreate()) {
                    this.supportingInformation = new StringType();
                }
            }
            return this.supportingInformation;
        }

        public boolean hasSupportingInformationElement() {
            return this.supportingInformation != null && !this.supportingInformation.isEmpty();
        }

        public boolean hasSupportingInformation() {
            return this.supportingInformation != null && !this.supportingInformation.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setSupportingInformationElement(StringType value) {
            this.supportingInformation = value;
            return this;
        }

        public String getSupportingInformation() {
            return this.supportingInformation == null ? null : (String)this.supportingInformation.getValue();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setSupportingInformation(String value) {
            if (Utilities.noString((String)value)) {
                this.supportingInformation = null;
            } else {
                if (this.supportingInformation == null) {
                    this.supportingInformation = new StringType();
                }
                this.supportingInformation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("tissue", "CodeableConcept", "Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.", 0, 1, this.tissue));
            children.add(new Property("value", "Quantity", "A value for the time.", 0, 1, this.value));
            children.add(new Property("supportingInformation", "string", "Extra information about the withdrawal period.", 0, 1, this.supportingInformation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -873475867: {
                    return new Property("tissue", "CodeableConcept", "Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.", 0, 1, this.tissue);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "A value for the time.", 0, 1, this.value);
                }
                case -1248768647: {
                    return new Property("supportingInformation", "string", "Extra information about the withdrawal period.", 0, 1, this.supportingInformation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    Base[] baseArray;
                    if (this.tissue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.tissue;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1248768647: {
                    Base[] baseArray;
                    if (this.supportingInformation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.supportingInformation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    this.tissue = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToQuantity(value);
                    return value;
                }
                case -1248768647: {
                    this.supportingInformation = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("tissue")) {
                this.tissue = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToQuantity(value);
            } else if (name.equals("supportingInformation")) {
                this.supportingInformation = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("tissue")) {
                this.tissue = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else if (name.equals("supportingInformation")) {
                this.supportingInformation = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    return this.getTissue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1248768647: {
                    return this.getSupportingInformationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case -1248768647: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("tissue")) {
                this.tissue = new CodeableConcept();
                return this.tissue;
            }
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("supportingInformation")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductPharmaceutical.supportingInformation");
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent copy() {
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent dst = new MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent dst) {
            super.copyValues(dst);
            dst.tissue = this.tissue == null ? null : this.tissue.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.supportingInformation = this.supportingInformation == null ? null : this.supportingInformation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)other_;
            return MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.tissue, o.tissue, true) && MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.value, o.value, true) && MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.supportingInformation, o.supportingInformation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)other_;
            return MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareValues(this.supportingInformation, o.supportingInformation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.tissue, this.value, this.supportingInformation});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPharmaceutical.routeOfAdministration.targetSpecies.withdrawalPeriod";
        }
    }

    @Block
    public static class MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the species", formalDefinition="Coded expression for the species.")
        protected CodeableConcept code;
        @Child(name="withdrawalPeriod", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A species specific time during which consumption of animal product is not appropriate", formalDefinition="A species specific time during which consumption of animal product is not appropriate.")
        protected List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> withdrawalPeriod;
        private static final long serialVersionUID = -664052812L;

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent() {
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> getWithdrawalPeriod() {
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            return this.withdrawalPeriod;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent setWithdrawalPeriod(List<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> theWithdrawalPeriod) {
            this.withdrawalPeriod = theWithdrawalPeriod;
            return this;
        }

        public boolean hasWithdrawalPeriod() {
            if (this.withdrawalPeriod == null) {
                return false;
            }
            for (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent item : this.withdrawalPeriod) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent addWithdrawalPeriod() {
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent t = new MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            this.withdrawalPeriod.add(t);
            return t;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent addWithdrawalPeriod(MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent t) {
            if (t == null) {
                return this;
            }
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            this.withdrawalPeriod.add(t);
            return this;
        }

        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent getWithdrawalPeriodFirstRep() {
            if (this.getWithdrawalPeriod().isEmpty()) {
                this.addWithdrawalPeriod();
            }
            return this.getWithdrawalPeriod().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Coded expression for the species.", 0, 1, this.code));
            children.add(new Property("withdrawalPeriod", "", "A species specific time during which consumption of animal product is not appropriate.", 0, Integer.MAX_VALUE, this.withdrawalPeriod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded expression for the species.", 0, 1, this.code);
                }
                case -98450730: {
                    return new Property("withdrawalPeriod", "", "A species specific time during which consumption of animal product is not appropriate.", 0, Integer.MAX_VALUE, this.withdrawalPeriod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -98450730: {
                    return this.withdrawalPeriod == null ? new Base[]{} : this.withdrawalPeriod.toArray(new Base[this.withdrawalPeriod.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -98450730: {
                    this.getWithdrawalPeriod().add((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("withdrawalPeriod")) {
                this.getWithdrawalPeriod().add((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("withdrawalPeriod")) {
                this.getWithdrawalPeriod().remove((MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -98450730: {
                    return this.addWithdrawalPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -98450730: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("withdrawalPeriod")) {
                return this.addWithdrawalPeriod();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent copy() {
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent dst = new MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.withdrawalPeriod != null) {
                dst.withdrawalPeriod = new ArrayList<MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
                for (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent i : this.withdrawalPeriod) {
                    dst.withdrawalPeriod.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)other_;
            return MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent.compareDeep(this.code, o.code, true) && MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent.compareDeep(this.withdrawalPeriod, o.withdrawalPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent o = (MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.withdrawalPeriod});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPharmaceutical.routeOfAdministration.targetSpecies";
        }
    }
}

