/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ResearchElementType;

public class ResearchElementTypeEnumFactory
implements EnumFactory<ResearchElementType> {
    @Override
    public ResearchElementType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("population".equals(codeString)) {
            return ResearchElementType.POPULATION;
        }
        if ("exposure".equals(codeString)) {
            return ResearchElementType.EXPOSURE;
        }
        if ("outcome".equals(codeString)) {
            return ResearchElementType.OUTCOME;
        }
        throw new IllegalArgumentException("Unknown ResearchElementType code '" + codeString + "'");
    }

    @Override
    public String toCode(ResearchElementType code) {
        if (code == ResearchElementType.NULL) {
            return null;
        }
        if (code == ResearchElementType.POPULATION) {
            return "population";
        }
        if (code == ResearchElementType.EXPOSURE) {
            return "exposure";
        }
        if (code == ResearchElementType.OUTCOME) {
            return "outcome";
        }
        return "?";
    }

    @Override
    public String toSystem(ResearchElementType code) {
        return code.getSystem();
    }
}

