/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.elementmodel.ObjectConverter;
import org.hl7.fhir.r4.fhirpath.ExpressionNode;
import org.hl7.fhir.r4.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r4.fhirpath.FHIRPathFunctionDefinition;
import org.hl7.fhir.r4.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r4.fhirpath.TypeDetails;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ConceptTranslationEngine;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class TerminologyFunctions {

    public static class TranslateFunction
    extends TerminologyFunctionBase {
        @Override
        public String name() {
            return "translate";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Translate from terminology to another", 2, 3);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Parameters");
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            if (focus.size() == 0) {
                return new ArrayList<Base>();
            }
            if (focus.size() != 1) {
                throw this.makeExceptionPlural(engine, focus.size(), "FHIRPATH_FOCUS", "expand", focus.size());
            }
            Base base = focus.get(0);
            ArrayList<Base> result = new ArrayList<Base>();
            if (base.fhirType().equals("TerminologyServices") && parameters.size() > 1) {
                List<Base> param1 = parameters.get(0);
                if (param1.size() != 1) {
                    throw this.makeExceptionPlural(engine, param1.size(), "FHIRPATH_PARAMETER_CARD", "valueSet", focus.size());
                }
                ConceptMap cm = null;
                if (param1.get(0).isPrimitive()) {
                    cm = engine.getWorker().fetchResource(ConceptMap.class, param1.get(0).primitiveValue());
                }
                if (cm != null) {
                    List<Base> param2 = parameters.get(1);
                    if (param2.size() != 1) {
                        throw this.makeExceptionPlural(engine, param1.size(), "FHIRPATH_PARAMETER_CARD", "coded", focus.size());
                    }
                    Base coded = param2.get(0);
                    if (coded.isPrimitive()) {
                        Parameters p = new ConceptTranslationEngine(engine.getWorker()).translateCode(coded.primitiveValue(), cm);
                        result.add(p);
                    } else if ("Coding".equals(coded.fhirType())) {
                        Coding coding = coded instanceof Coding ? (Coding)coded : ObjectConverter.readAsCoding((Element)coded);
                        Parameters p = new ConceptTranslationEngine(engine.getWorker()).translateCoding(coding, cm);
                        result.add(p);
                    }
                }
            }
            return result;
        }
    }

    public static class ValidateVSFunction
    extends TerminologyFunctionBase {
        @Override
        public String name() {
            return "validateVS";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Validate a code against a ValueSet", 2, 3);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Parameters");
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            if (focus.size() == 0) {
                return new ArrayList<Base>();
            }
            if (focus.size() != 1) {
                throw this.makeExceptionPlural(engine, focus.size(), "FHIRPATH_FOCUS", "expand", focus.size());
            }
            Base base = focus.get(0);
            ArrayList<Base> result = new ArrayList<Base>();
            if (base.fhirType().equals("TerminologyServices") && parameters.size() > 1) {
                List<Base> param1 = parameters.get(0);
                if (param1.size() != 1) {
                    throw this.makeExceptionPlural(engine, param1.size(), "FHIRPATH_PARAMETER_CARD", "valueSet", focus.size());
                }
                ValueSet vs = null;
                if (param1.get(0).isPrimitive()) {
                    vs = engine.getWorker().fetchResource(ValueSet.class, param1.get(0).primitiveValue());
                }
                if (vs != null) {
                    List<Base> param2 = parameters.get(1);
                    if (param2.size() != 1) {
                        throw this.makeExceptionPlural(engine, param1.size(), "FHIRPATH_PARAMETER_CARD", "coded", focus.size());
                    }
                    Base coded = param2.get(0);
                    if (coded.isPrimitive()) {
                        IWorkerContext.ValidationResult vr = engine.getWorker().validateCode(ValidationOptions.defaults(), coded.primitiveValue(), vs);
                        result.add(vr.getOrMakeParameters());
                    } else if ("Coding".equals(coded.fhirType())) {
                        Coding coding = coded instanceof Coding ? (Coding)coded : ObjectConverter.readAsCoding((Element)coded);
                        IWorkerContext.ValidationResult vr = engine.getWorker().validateCode(ValidationOptions.defaults(), coded.primitiveValue(), vs);
                        result.add(vr.getOrMakeParameters());
                    } else if ("CodeableConcept".equals(coded.fhirType())) {
                        CodeableConcept cc = coded instanceof CodeableConcept ? (CodeableConcept)coded : ObjectConverter.readAsCodeableConcept((Element)coded);
                        IWorkerContext.ValidationResult vr = engine.getWorker().validateCode(ValidationOptions.defaults(), coded.primitiveValue(), vs);
                        result.add(vr.getOrMakeParameters());
                    }
                }
            }
            return result;
        }
    }

    public static class ExpandFunction
    extends TerminologyFunctionBase {
        @Override
        public String name() {
            return "expand";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Perform a value set expansion", 1, 2);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Resource");
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            if (focus.size() == 0) {
                return new ArrayList<Base>();
            }
            if (focus.size() != 1) {
                throw this.makeExceptionPlural(engine, focus.size(), "FHIRPATH_FOCUS", "expand", focus.size());
            }
            Base base = focus.get(0);
            ArrayList<Base> result = new ArrayList<Base>();
            if (base.fhirType().equals("TerminologyServices") && parameters.size() > 0) {
                List<Base> param1 = parameters.get(0);
                if (param1.size() != 1) {
                    throw this.makeExceptionPlural(engine, param1.size(), "FHIRPATH_PARAMETER_CARD", "valueSet", focus.size());
                }
                ValueSet vs = null;
                if (param1.get(0).isPrimitive()) {
                    vs = engine.getWorker().fetchResource(ValueSet.class, param1.get(0).primitiveValue());
                }
                if (vs != null) {
                    ValueSetExpander.ValueSetExpansionOutcome exp = engine.getWorker().expandVS(vs, true, false);
                    if (exp.isOk() && exp.getValueset() != null) {
                        result.add(exp.getValueset());
                    }
                } else {
                    throw new Error("Not supported yet");
                }
            }
            return result;
        }
    }

    public static class TerminologiesObject
    extends Base {
        @Override
        public String fhirType() {
            return "TerminologyServices";
        }

        @Override
        protected void listChildren(List<Property> result) {
        }

        @Override
        public String getIdBase() {
            return null;
        }

        @Override
        public void setIdBase(String value) {
        }

        @Override
        public Base copy() {
            return this;
        }
    }

    public static abstract class TerminologyFunctionBase
    extends FHIRPathFunctionDefinition {
        protected FHIRException makeExceptionPlural(FHIRPathEngine engine, Integer num, String constName, Object ... args) {
            String fmt = engine.getWorker().formatMessagePlural(num, constName, args);
            return new PathEngineException(fmt, constName);
        }

        protected FHIRException makeException(FHIRPathEngine engine, ExpressionNode holder, String constName, Object ... args) {
            String fmt = engine.getWorker().formatMessage(constName, args);
            return new PathEngineException(fmt, constName);
        }
    }
}

