/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;

@Deprecated
public class ProtoBufGenerator {
    private IWorkerContext context;
    private StructureDefinition definition;
    private OutputStreamWriter destination;
    private int cursor;
    private Message message;

    public ProtoBufGenerator(IWorkerContext context) {
        this.context = context;
    }

    public ProtoBufGenerator(IWorkerContext context, StructureDefinition definition, OutputStreamWriter destination) {
        this.context = context;
        this.definition = definition;
        this.destination = destination;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public StructureDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(StructureDefinition definition) {
        this.definition = definition;
    }

    public OutputStreamWriter getDestination() {
        return this.destination;
    }

    public void setDestination(OutputStreamWriter destination) {
        this.destination = destination;
    }

    public void build() throws FHIRException {
        if (this.definition == null) {
            throw new FHIRException("A definition must be provided");
        }
        if (this.destination == null) {
            throw new FHIRException("A destination must be provided");
        }
        if (this.definition.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new FHIRException("derivation = constraint is not supported yet");
        }
        this.message = new Message(this.definition.getSnapshot().getElement().get(0).getPath());
        this.cursor = 1;
        while (this.cursor < this.definition.getSnapshot().getElement().size()) {
            ElementDefinition ed = this.definition.getSnapshot().getElement().get(0);
            Field fld = new Field();
            fld.name = this.tail(ed.getPath());
            fld.required = ed.getMin() == 1;
            fld.repeating = !ed.getMax().equals("1");
            this.message.fields.add(fld);
            if (ed.getType().size() != 1) {
                fld.type = "Unknown";
                continue;
            }
            StructureDefinition td = this.context.fetchTypeDefinition(ed.getTypeFirstRep().getWorkingCode());
            if (td == null) {
                fld.type = "Unresolved";
                continue;
            }
            if (td.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                fld.type = this.protoTypeForFhirType(ed.getTypeFirstRep().getWorkingCode());
                fld = new Field();
                fld.name = this.tail(ed.getPath()) + "Extra";
                fld.repeating = !ed.getMax().equals("1");
                fld.type = "Primitive";
                this.message.fields.add(fld);
                continue;
            }
            fld.type = ed.getTypeFirstRep().getWorkingCode();
        }
    }

    private String protoTypeForFhirType(String code) {
        if (Utilities.existsInList((String)code, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            return "int23";
        }
        if (code.equals("boolean")) {
            return "bool";
        }
        return "string";
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private class Message {
        private String name;
        private List<Field> fields = new ArrayList<Field>();
        private List<Message> messages = new ArrayList<Message>();

        public Message(String name) {
            this.name = name;
        }
    }

    private class Field {
        private String name;
        private boolean required;
        private boolean repeating;
        private String type;

        private Field() {
        }
    }
}

