/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.utils.sql.Cell;
import org.hl7.fhir.r4.utils.sql.Column;
import org.hl7.fhir.r4.utils.sql.ColumnKind;
import org.hl7.fhir.r4.utils.sql.Storage;
import org.hl7.fhir.r4.utils.sql.Store;
import org.hl7.fhir.r4.utils.sql.Validator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class StorageSqlite3
implements Storage {
    private Connection conn;
    private int nextKey = 0;

    public StorageSqlite3(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Store createStore(String name, List<Column> columns) {
        try {
            CommaSeparatedStringBuilder fields = new CommaSeparatedStringBuilder(", ");
            CommaSeparatedStringBuilder values = new CommaSeparatedStringBuilder(", ");
            StringBuilder b = new StringBuilder();
            b.append("Create Table " + name + " ( ");
            b.append("ViewRowKey integer NOT NULL");
            for (Column column : columns) {
                b.append(", " + column.getName() + " " + this.sqliteType(column.getKind()) + " NULL");
                fields.append(column.getName());
                values.append("?");
            }
            b.append(", PRIMARY KEY (ViewRowKey))\r\n");
            this.conn.createStatement().execute(b.toString());
            String isql = "Insert into " + name + " (ViewRowKey, " + fields.toString() + ") values (?, " + values.toString() + ")";
            PreparedStatement psql = this.conn.prepareStatement(isql);
            return new SQLiteStore(name, psql);
        }
        catch (Exception e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private String sqliteType(ColumnKind type) {
        switch (type) {
            case DateTime: {
                return "Text";
            }
            case Decimal: {
                return "Real";
            }
            case Integer: {
                return "Integer";
            }
            case String: {
                return "Text";
            }
            case Time: {
                return "Text";
            }
            case Binary: {
                return "Text";
            }
            case Boolean: {
                return "Integer";
            }
            case Complex: {
                throw new FHIRException("SQLite runner does not handle complexes");
            }
        }
        return null;
    }

    @Override
    public void addRow(Store store, List<Cell> cells) {
        try {
            SQLiteStore sqls = (SQLiteStore)store;
            PreparedStatement p = sqls.getP();
            p.setInt(1, ++this.nextKey);
            block13: for (int i = 0; i < cells.size(); ++i) {
                Cell c = cells.get(i);
                switch (c.getColumn().getKind()) {
                    case Null: {
                        p.setNull(i + 2, -9);
                    }
                    case Binary: {
                        p.setBytes(i + 2, c.getValues().size() == 0 ? null : c.getValues().get(0).getValueBinary());
                        continue block13;
                    }
                    case Boolean: {
                        p.setBoolean(i + 2, c.getValues().size() == 0 ? false : c.getValues().get(0).getValueBoolean());
                        continue block13;
                    }
                    case DateTime: {
                        p.setDate(i + 2, c.getValues().size() == 0 ? null : new Date(c.getValues().get(0).getValueDate().getTime()));
                        continue block13;
                    }
                    case Decimal: {
                        p.setString(i + 2, c.getValues().size() == 0 ? null : c.getValues().get(0).getValueString());
                        continue block13;
                    }
                    case Integer: {
                        p.setInt(i + 2, c.getValues().size() == 0 ? 0 : c.getValues().get(0).getValueInt());
                        continue block13;
                    }
                    case String: {
                        p.setString(i + 2, c.getValues().size() == 0 ? null : c.getValues().get(0).getValueString());
                        continue block13;
                    }
                    case Time: {
                        p.setString(i + 2, c.getValues().size() == 0 ? null : c.getValues().get(0).getValueString());
                        continue block13;
                    }
                    case Complex: {
                        throw new FHIRException("SQLite runner does not handle complexes");
                    }
                }
            }
            p.execute();
        }
        catch (Exception e) {
            throw new FHIRException((Throwable)e);
        }
    }

    @Override
    public void finish(Store store) {
    }

    @Override
    public Validator.TrueFalseOrUnknown supportsArrays() {
        return Validator.TrueFalseOrUnknown.FALSE;
    }

    @Override
    public Validator.TrueFalseOrUnknown supportsComplexTypes() {
        return Validator.TrueFalseOrUnknown.FALSE;
    }

    @Override
    public Validator.TrueFalseOrUnknown needsName() {
        return Validator.TrueFalseOrUnknown.TRUE;
    }

    @Override
    public String getKeyForSourceResource(Base res) {
        throw new Error("Key management for resources isn't decided yet");
    }

    @Override
    public String getKeyForTargetResource(Base res) {
        throw new Error("Key management for resources isn't decided yet");
    }

    public static class SQLiteStore
    extends Store {
        private PreparedStatement p;

        protected SQLiteStore(String name, PreparedStatement p) {
            super(name);
            this.p = p;
        }

        public PreparedStatement getP() {
            return this.p;
        }
    }
}

