/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.OIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class ContextUtilities
implements ProfileUtilities.ProfileKnowledgeProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextUtilities.class);
    private IWorkerContext context;
    @Deprecated
    private boolean suppressDebugMessages;
    private Map<String, String> oidCache = new HashMap<String, String>();
    private List<StructureDefinition> allStructuresList = new ArrayList<StructureDefinition>();
    private List<String> canonicalResourceNames;
    private List<String> concreteResourceNames;
    private Set<String> concreteResourceNameSet;

    public boolean isSuppressDebugMessages() {
        return false;
    }

    public ContextUtilities(IWorkerContext context) {
        this.context = context;
    }

    public String oid2Uri(String oid) {
        if (oid != null && oid.startsWith("urn:oid:")) {
            oid = oid.substring(8);
        }
        if (this.oidCache.containsKey(oid)) {
            return this.oidCache.get(oid);
        }
        String uri = OIDUtilities.getUriForOid((String)oid);
        if (uri != null) {
            this.oidCache.put(oid, uri);
            return uri;
        }
        CodeSystem cs = this.context.fetchCodeSystem("http://terminology.hl7.org/CodeSystem/v2-tables");
        if (cs != null) {
            for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
                for (CodeSystem.ConceptPropertyComponent cp : cc.getProperty()) {
                    if (!Utilities.existsInList((String)cp.getCode(), (String[])new String[]{"v2-table-oid", "v2-cs-oid"}) || !oid.equals(cp.getValue().primitiveValue())) continue;
                    for (CodeSystem.ConceptPropertyComponent cp2 : cc.getProperty()) {
                        if (!"v2-cs-uri".equals(cp2.getCode())) continue;
                        this.oidCache.put(oid, cp2.getValue().primitiveValue());
                        return cp2.getValue().primitiveValue();
                    }
                }
            }
        }
        for (CodeSystem css : this.context.fetchResourcesByType(CodeSystem.class)) {
            if (("urn:oid:" + oid).equals(css.getUrl())) {
                this.oidCache.put(oid, css.getUrl());
                return css.getUrl();
            }
            for (Identifier id : css.getIdentifier()) {
                if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !("urn:oid:" + oid).equals(id.getValue())) continue;
                this.oidCache.put(oid, css.getUrl());
                return css.getUrl();
            }
        }
        for (NamingSystem ns : this.context.fetchResourcesByType(NamingSystem.class)) {
            if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
            this.oidCache.put(oid, null);
            return null;
        }
        this.oidCache.put(oid, null);
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTypeNames() {
        HashSet<String> result = new HashSet<String>();
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        return Utilities.sorted(result);
    }

    public Set<String> getTypeNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || !VersionUtilities.versionMatches((String)this.context.getVersion(), (String)sd.getFhirVersion().toCode())) continue;
            result.add(sd.getName());
        }
        return result;
    }

    @Override
    public String getLinkForUrl(String corePath, String url) {
        if (url == null) {
            return null;
        }
        if (this.context.hasResource(Resource.class, url)) {
            Resource cr = this.context.fetchResource(Resource.class, url);
            return cr.getUserString("path");
        }
        return null;
    }

    protected String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "noname";
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    private boolean hasUrlProperty(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(sd.getType() + ".url")) continue;
            return true;
        }
        return false;
    }

    public List<String> getCanonicalResourceNames() {
        if (this.canonicalResourceNames == null) {
            this.canonicalResourceNames = new ArrayList<String>();
            HashSet<String> names = new HashSet<String>();
            for (StructureDefinition sd : this.allStructures()) {
                if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getAbstract() || !this.hasUrlProperty(sd)) continue;
                names.add(sd.getType());
            }
            this.canonicalResourceNames.addAll(Utilities.sorted(names));
        }
        return this.canonicalResourceNames;
    }

    public List<StructureDefinition> allStructures() {
        if (this.allStructuresList.isEmpty()) {
            HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
            for (StructureDefinition sd : this.getStructures()) {
                if (set.contains(sd)) continue;
                try {
                    this.generateSnapshot(sd);
                }
                catch (Exception e) {
                    log.debug("Unable to generate snapshot @2 for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage(), (Throwable)e);
                }
                this.allStructuresList.add(sd);
                set.add(sd);
            }
        }
        return this.allStructuresList;
    }

    public List<StructureDefinition> getStructures() {
        return this.context.fetchResourcesByType(StructureDefinition.class);
    }

    public void generateSnapshot(StructureDefinition p) throws DefinitionException, FHIRException {
        if (!p.hasSnapshot() || this.isProfileNeedsRegenerate(p)) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException(this.context.formatMessage("Profile___has_no_base_and_no_snapshot", p.getName(), p.getUrl()));
            }
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, p.getBaseDefinition(), p);
            if (sd == null && "http://hl7.org/fhir/StructureDefinition/Base".equals(p.getBaseDefinition())) {
                throw new Error("Not done yet");
            }
            if (sd == null) {
                throw new DefinitionException(this.context.formatMessage("Profile___base__could_not_be_resolved", p.getName(), p.getUrl(), p.getBaseDefinition()));
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this.context, msgs, this);
            pu.setThrowException(false);
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                pu.sortDifferential(sd, p, p.getUrl(), errors);
            }
            pu.setDebug(false);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getUserString("path"), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), sd.getUserString("webroot"), p.getName());
            for (ValidationMessage msg : msgs) {
                if (msg.getLevel() != ValidationMessage.IssueSeverity.ERROR && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                if (!msg.isIgnorableError()) {
                    throw new DefinitionException(this.context.formatMessage("Profile___element__Error_generating_snapshot_", p.getName(), p.getUrl(), msg.getLocation(), msg.getMessage()));
                }
                log.error(msg.getMessage());
            }
            if (!p.hasSnapshot()) {
                throw new FHIRException(this.context.formatMessage("Profile___Error_generating_snapshot", p.getName(), p.getUrl()));
            }
            pu = null;
        }
    }

    private boolean isProfileNeedsRegenerate(StructureDefinition p) {
        boolean needs;
        boolean bl = needs = !p.hasUserData("hack.regnerated") && Utilities.existsInList((String)p.getUrl(), (String[])new String[]{"http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse"});
        if (needs) {
            p.setUserData("hack.regnerated", "yes");
        }
        return needs;
    }

    @Override
    public boolean isPrimitiveType(String type) {
        return this.context.isPrimitiveType(type);
    }

    @Override
    public boolean isDatatype(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE || sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE) && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        if (this.getConcreteResourceSet().contains(t)) {
            return true;
        }
        try {
            sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, String url, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    public StructureDefinition fetchByJsonName(String key) {
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
            if (ed == null) continue;
            return sd;
        }
        return null;
    }

    public Set<String> getConcreteResourceSet() {
        if (this.concreteResourceNameSet == null) {
            this.concreteResourceNameSet = new HashSet<String>();
            for (StructureDefinition sd : this.getStructures()) {
                if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getAbstract() || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
                this.concreteResourceNameSet.add(sd.getType());
            }
        }
        return this.concreteResourceNameSet;
    }

    public List<String> getConcreteResources() {
        if (this.concreteResourceNames == null) {
            this.concreteResourceNames = new ArrayList<String>();
            this.concreteResourceNames.addAll(Utilities.sorted(this.getConcreteResourceSet()));
        }
        return this.concreteResourceNames;
    }

    public List<StructureMap> listMaps(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        String start = url.substring(0, url.indexOf("*"));
        String end = url.substring(url.indexOf("*") + 1);
        for (StructureMap map : this.context.fetchResourcesByType(StructureMap.class)) {
            String u = map.getUrl();
            if (!u.startsWith(start) || !u.endsWith(end)) continue;
            res.add(map);
        }
        return res;
    }

    public List<String> fetchCodeSystemVersions(String system) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem cs : this.context.fetchResourcesByType(CodeSystem.class)) {
            if (!system.equals(cs.getUrl()) || !cs.hasVersion()) continue;
            res.add(cs.getVersion());
        }
        return res;
    }

    public StructureDefinition findType(String typeName) {
        StructureDefinition t = this.context.fetchTypeDefinition(typeName);
        if (t != null) {
            return t;
        }
        ArrayList<StructureDefinition> candidates = new ArrayList<StructureDefinition>();
        for (StructureDefinition sd : this.getStructures()) {
            if (!sd.getType().equals(typeName)) continue;
            candidates.add(sd);
        }
        if (candidates.size() == 1) {
            return (StructureDefinition)candidates.get(0);
        }
        return null;
    }

    public StructureDefinition fetchProfileByIdentifier(String tid) {
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            for (Identifier ii : sd.getIdentifier()) {
                if (!tid.equals(ii.getValue())) continue;
                return sd;
            }
        }
        return null;
    }

    public boolean isAbstractType(String typeName) {
        StructureDefinition sd = this.context.fetchTypeDefinition(typeName);
        if (sd != null) {
            return sd.getAbstract();
        }
        return false;
    }

    public boolean isDomainResource(String typeName) {
        StructureDefinition sd = this.context.fetchTypeDefinition(typeName);
        while (sd != null) {
            if ("DomainResource".equals(sd.getType())) {
                return true;
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return false;
    }

    public IWorkerContext getWorker() {
        return this.context;
    }

    @Deprecated
    @Generated
    public void setSuppressDebugMessages(boolean suppressDebugMessages) {
        this.suppressDebugMessages = suppressDebugMessages;
    }
}

