/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.profilemodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.ContextUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceFactory;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.profilemodel.PEDefinition;
import org.hl7.fhir.r4.profilemodel.PEDefinitionElement;
import org.hl7.fhir.r4.profilemodel.PEDefinitionExtension;
import org.hl7.fhir.r4.profilemodel.PEDefinitionResource;
import org.hl7.fhir.r4.profilemodel.PEDefinitionSlice;
import org.hl7.fhir.r4.profilemodel.PEDefinitionSubExtension;
import org.hl7.fhir.r4.profilemodel.PEDefinitionTypeSlice;
import org.hl7.fhir.r4.profilemodel.PEInstance;
import org.hl7.fhir.r4.profilemodel.PEType;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class PEBuilder {
    private IWorkerContext context;
    private ProfileUtilities pu;
    private ContextUtilities cu;
    private PEElementPropertiesPolicy elementProps;
    private boolean fixedPropsDefault;
    private FHIRPathEngine fpe;

    public PEBuilder(IWorkerContext context, PEElementPropertiesPolicy elementProps, boolean fixedPropsDefault) {
        this.context = context;
        this.elementProps = elementProps;
        this.fixedPropsDefault = fixedPropsDefault;
        this.pu = new ProfileUtilities(context, null, null);
        this.cu = new ContextUtilities(context);
        this.fpe = new FHIRPathEngine(context, this.pu);
    }

    public PEDefinition buildPEDefinition(StructureDefinition profile) {
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + profile.getVersionedUrl() + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, null);
    }

    public PEDefinition buildPEDefinition(String url) {
        StructureDefinition profile = this.getProfile(url);
        if (profile == null) {
            throw new DefinitionException("Unable to find profile for URL '" + url + "'");
        }
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + url + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, profile.getName());
    }

    public PEDefinition buildPEDefinition(String url, String version) {
        StructureDefinition profile = this.getProfile(url, version);
        if (profile == null) {
            throw new DefinitionException("Unable to find profile for URL '" + url + "'");
        }
        if (!profile.hasSnapshot()) {
            throw new DefinitionException("Profile '" + url + "' does not have a snapshot");
        }
        return new PEDefinitionResource(this, profile, profile.getName());
    }

    public PEInstance buildPEInstance(String url, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(url);
        return this.loadInstance(defn, resource);
    }

    public PEInstance buildPEInstance(StructureDefinition profile, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(profile);
        return this.loadInstance(defn, resource);
    }

    public PEInstance buildPEInstance(String url, String version, Resource resource) {
        PEDefinition defn = this.buildPEDefinition(url, version);
        return this.loadInstance(defn, resource);
    }

    public Resource createResource(String url, String version, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(url, version);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    public Resource createResource(StructureDefinition profile, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(profile);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    public Resource createResource(String url, boolean meta) {
        PEDefinition definition = this.buildPEDefinition(url);
        Resource res = ResourceFactory.createResource(definition.types().get(0).getType());
        this.populateByProfile(res, definition);
        if (meta) {
            res.getMeta().addProfile(definition.profile.getUrl());
        }
        return res;
    }

    private StructureDefinition getProfile(String url) {
        return this.context.fetchResource(StructureDefinition.class, url);
    }

    private StructureDefinition getProfile(String url, String version) {
        return this.context.fetchResource(StructureDefinition.class, url, version);
    }

    protected List<PEDefinition> listChildren(boolean allFixed, PEDefinition parent, StructureDefinition profileStructure, ElementDefinition definition, String url, String ... omitList) {
        StructureDefinition profile = profileStructure;
        boolean inExtension = profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && "Extension".equals(profile.getType());
        List<ElementDefinition> list = ProfileUtilities.getChildList(profile, definition);
        if (definition.getType().size() == 1 || !definition.getPath().contains(".") || list.isEmpty()) {
            assert (url == null || this.checkType(definition, url));
            ArrayList<PEDefinition> res = new ArrayList<PEDefinition>();
            if (list.size() == 0) {
                profile = this.context.fetchResource(StructureDefinition.class, url);
                if (profile == null) {
                    throw new FHIRException("Unable to resolve profile " + url);
                }
                list = ProfileUtilities.getChildList(profile, profile.getSnapshot().getElementFirstRep());
            }
            if (list.size() > 0) {
                HashSet<String> names = new HashSet<String>();
                int i = 0;
                while (i < list.size()) {
                    ElementDefinition defn = list.get(i);
                    if (!defn.getMax().equals("0") && (allFixed || this.include(defn))) {
                        if (this.passElementPropsCheck(defn, inExtension) && !Utilities.existsInList((String)defn.getName(), (String[])omitList)) {
                            String name = this.uniquefy(names, defn.getName());
                            PEDefinitionElement pe = new PEDefinitionElement(this, name, profile, defn, parent.path());
                            pe.setRecursing(definition == defn || profile.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && profile.getType().equals("Extension"));
                            if (this.context.isPrimitiveType(definition.getTypeFirstRep().getWorkingCode()) && "value".equals(pe.name())) {
                                pe.setMustHaveValue(definition.getMustHaveValue());
                            }
                            pe.setInFixedValue(definition.hasFixed() || definition.hasPattern() || parent.isInFixedValue());
                            if (defn.hasSlicing()) {
                                if (defn.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED) {
                                    res.add(pe);
                                    pe.setSlicer(true);
                                }
                                ++i;
                                while (i < list.size() && list.get(i).getPath().equals(defn.getPath())) {
                                    StructureDefinition ext = this.getExtensionDefinition(list.get(i));
                                    if (ext != null) {
                                        res.add(new PEDefinitionExtension(this, this.uniquefy(names, list.get(i).getSliceName()), profile, list.get(i), defn, ext, parent.path()));
                                    } else if (this.isTypeSlicing(defn)) {
                                        res.add(new PEDefinitionTypeSlice(this, this.uniquefy(names, list.get(i).getSliceName()), profile, list.get(i), defn, parent.path()));
                                    } else if (ProfileUtilities.isComplexExtension(profile) && defn.getPath().endsWith(".extension")) {
                                        res.add(new PEDefinitionSubExtension(this, profile, list.get(i), parent.path()));
                                    } else {
                                        res.add(new PEDefinitionSlice(this, this.uniquefy(names, list.get(i).getSliceName()), profile, list.get(i), defn, parent.path()));
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            res.add(pe);
                            ++i;
                            continue;
                        }
                        ++i;
                        continue;
                    }
                    ++i;
                }
            }
            return res;
        }
        if (list.isEmpty()) {
            throw new DefinitionException("not done yet!");
        }
        throw new DefinitionException("not done yet");
    }

    private String uniquefy(Set<String> names, String name) {
        if (names.contains(name)) {
            int i = 0;
            while (names.contains((String)name + i)) {
                ++i;
            }
            name = (String)name + i;
        }
        names.add((String)name);
        return name;
    }

    protected PEDefinition makeChild(PEDefinition parent, StructureDefinition profileStructure, ElementDefinition definition) {
        PEDefinitionElement pe = new PEDefinitionElement(this, profileStructure, definition, parent.path());
        if (this.context.isPrimitiveType(definition.getTypeFirstRep().getWorkingCode()) && "value".equals(pe.name())) {
            pe.setMustHaveValue(definition.getMustHaveValue());
        }
        pe.setInFixedValue(definition.hasFixed() || definition.hasPattern() || parent.isInFixedValue());
        return pe;
    }

    private boolean passElementPropsCheck(ElementDefinition bdefn, boolean inExtension) {
        if (inExtension) {
            return !Utilities.existsInList((String)bdefn.getBase().getPath(), (String[])new String[]{"Element.id"});
        }
        switch (this.elementProps) {
            case EXTENSION: {
                return !Utilities.existsInList((String)bdefn.getBase().getPath(), (String[])new String[]{"Element.id"});
            }
            case NONE: {
                return !Utilities.existsInList((String)bdefn.getBase().getPath(), (String[])new String[]{"Element.id", "Element.extension"});
            }
        }
        return true;
    }

    private boolean isTypeSlicing(ElementDefinition defn) {
        ElementDefinition.ElementDefinitionSlicingComponent sl = defn.getSlicing();
        return sl.getRules() == ElementDefinition.SlicingRules.CLOSED && sl.getDiscriminator().size() == 1 && sl.getDiscriminatorFirstRep().getType() == ElementDefinition.DiscriminatorType.TYPE && "$this".equals(sl.getDiscriminatorFirstRep().getPath());
    }

    private boolean include(ElementDefinition defn) {
        if (this.fixedPropsDefault) {
            return true;
        }
        return !defn.hasFixed() && !defn.hasPattern();
    }

    protected List<PEDefinition> listSlices(StructureDefinition profileStructure, ElementDefinition definition, PEDefinition parent) {
        List<ElementDefinition> list = ProfileUtilities.getSliceList(profileStructure, definition);
        ArrayList<PEDefinition> res = new ArrayList<PEDefinition>();
        for (ElementDefinition ed : list) {
            if (profileStructure.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && profileStructure.getType().equals("Extension")) {
                res.add(new PEDefinitionSubExtension(this, profileStructure, ed, parent.path()));
                continue;
            }
            PEDefinitionElement pe = new PEDefinitionElement(this, profileStructure, ed, parent.path());
            pe.setRecursing(definition == ed || profileStructure.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && profileStructure.getType().equals("Extension"));
            res.add(pe);
        }
        return res;
    }

    private boolean checkType(ElementDefinition defn, String url) {
        for (ElementDefinition.TypeRefComponent t : defn.getType()) {
            if (("http://hl7.org/fhir/StructureDefinition/" + t.getWorkingCode()).equals(url)) {
                return true;
            }
            for (CanonicalType u : t.getProfile()) {
                if (!url.equals(u.getValue())) continue;
                return true;
            }
        }
        return !defn.getPath().contains(".");
    }

    private StructureDefinition getExtensionDefinition(ElementDefinition ed) {
        if ("Extension".equals(ed.getTypeFirstRep().getWorkingCode()) && ed.getTypeFirstRep().getProfile().size() == 1) {
            return this.context.fetchResource(StructureDefinition.class, ed.getTypeFirstRep().getProfile().get(0).asStringValue());
        }
        return null;
    }

    private ElementDefinition getByName(List<ElementDefinition> blist, String name) {
        for (ElementDefinition ed : blist) {
            if (!name.equals(ed.getName())) continue;
            return ed;
        }
        return null;
    }

    protected PEType makeType(ElementDefinition.TypeRefComponent t) {
        if (t.hasProfile()) {
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)t.getProfile().get(0).getValue());
            if (sd == null) {
                return new PEType(this.tail((String)t.getProfile().get(0).getValue()), t.getWorkingCode(), (String)t.getProfile().get(0).getValue());
            }
            return new PEType(sd.getName(), t.getWorkingCode(), (String)t.getProfile().get(0).getValue());
        }
        return this.makeType(t.getWorkingCode());
    }

    protected PEType makeType(ElementDefinition.TypeRefComponent t, CanonicalType u) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)u.getValue());
        if (sd == null) {
            return new PEType(this.tail((String)u.getValue()), t.getWorkingCode(), (String)u.getValue());
        }
        return new PEType(sd.getName(), t.getWorkingCode(), (String)u.getValue());
    }

    protected PEType makeType(String tn, String url) {
        return new PEType(tn, tn, url);
    }

    protected PEType makeType(String tn) {
        return new PEType(tn, tn, "http://hl7.org/fhir/StructureDefinition/" + tn);
    }

    private String tail(String value) {
        return value.contains("/") ? value.substring(value.lastIndexOf("/") + 1) : value;
    }

    protected List<ElementDefinition> getChildren(StructureDefinition profileStructure, ElementDefinition definition) {
        return ProfileUtilities.getChildList(profileStructure, definition);
    }

    private PEInstance loadInstance(PEDefinition defn, Resource resource) {
        return new PEInstance(this, defn, resource, resource, defn.name());
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    protected void populateByProfile(Base base, PEDefinition definition) {
        if (definition.types().size() == 1) {
            for (PEDefinition pe : definition.directChildren(true)) {
                if (pe.hasFixedValue()) {
                    if (pe.definition().hasPattern()) {
                        base.setProperty(pe.schemaName(), pe.definition().getPattern());
                        continue;
                    }
                    base.setProperty(pe.schemaName(), pe.definition().getFixed());
                    continue;
                }
                if (pe.isSlicer() || pe.max() != 1) continue;
                for (int i = 0; i < pe.min(); ++i) {
                    Base b = null;
                    if (pe.schemaName().endsWith("[x]")) {
                        if (pe.types().size() == 1) {
                            b = base.addChild(pe.schemaName().replace("[x]", Utilities.capitalize((String)pe.types().get(0).getType())));
                        }
                    } else {
                        b = !pe.isBaseList() ? base.makeProperty(pe.schemaName().hashCode(), pe.schemaName()) : base.addChild(pe.schemaName());
                    }
                    if (b == null) continue;
                    this.populateByProfile(b, pe);
                }
            }
        }
    }

    public String makeSliceExpression(StructureDefinition profile, ElementDefinition.ElementDefinitionSlicingComponent slicing, ElementDefinition definition) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" and ");
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
            switch (d.getType()) {
                case EXISTS: {
                    throw new DefinitionException("The discriminator type 'exists' is not supported by the PEBuilder");
                }
                case PATTERN: {
                    throw new DefinitionException("The discriminator type 'pattern' is not supported by the PEBuilder");
                }
                case PROFILE: {
                    throw new DefinitionException("The discriminator type 'profile' is not supported by the PEBuilder");
                }
                case TYPE: {
                    throw new DefinitionException("The discriminator type 'type' is not supported by the PEBuilder");
                }
                case VALUE: {
                    String path = d.getPath();
                    ElementDefinition ed = this.getChildElement(profile, definition, path);
                    if (ed == null) {
                        throw new DefinitionException("The discriminator path '" + path + "' could not be resolved by the PEBuilder");
                    }
                    if (ed.hasFixed()) {
                        if (!ed.getFixed().isPrimitive()) {
                            throw new DefinitionException("The discriminator path '" + path + "' has a fixed value that is not a primitive (" + ed.getFixed().fhirType() + ") - this is not supported by the PEBuilder");
                        }
                        b.append(path + " = '" + ed.getFixed().primitiveValue() + "'");
                        break;
                    }
                    if (ed.hasPattern()) {
                        throw new DefinitionException("The discriminator path '" + path + "' has a pattern on the element '" + ed.getId() + "' - this is not supported by the PEBuilder");
                    }
                    if (ed.hasBinding()) {
                        if (ed.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                            throw new DefinitionException("The discriminator path '" + path + "' has a binding on the element '" + ed.getId() + "' but the strength is not required - this is not supported by the PEBuilder");
                        }
                        ValueSet vs = this.context.fetchResource(ValueSet.class, ed.getBinding().getValueSet());
                        if (vs == null) {
                            throw new DefinitionException("The discriminator path '" + path + "' has a binding on the element '" + ed.getId() + "' but the valueSet '" + ed.getBinding().getValueSet() + "' is not known - this is not supported by the PEBuilder");
                        }
                        ValueSetExpander.ValueSetExpansionOutcome exp = this.context.expandVS(vs, true, false);
                        if (exp.isOk()) {
                            CommaSeparatedStringBuilder bs = new CommaSeparatedStringBuilder(" | ");
                            for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                                bs.append("'" + cc.getCode() + "'");
                            }
                            b.append(path + " in (" + bs.toString() + ")");
                            break;
                        }
                        throw new DefinitionException("The discriminator path '" + path + "' has a binding on the element '" + ed.getId() + "' but the valueSet '" + ed.getBinding().getValueSet() + "' could not be expanded: " + exp.getError());
                    }
                    throw new DefinitionException("The discriminator path '" + path + "' has no fixed or pattern value or a binding on the element '" + ed.getId() + "' - this is not supported by the PEBuilder");
                }
                case NULL: {
                    throw new DefinitionException("The discriminator type 'null' is not supported by the PEBuilder");
                }
                default: {
                    throw new DefinitionException("The discriminator type '??' is not supported by the PEBuilder");
                }
            }
        }
        return b.toString();
    }

    private ElementDefinition getChildElement(StructureDefinition profile, ElementDefinition definition, String path) {
        String head = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        String tail = path.contains(".") ? path.substring(path.indexOf(".") + 1) : null;
        ElementDefinition focus = definition;
        do {
            List<ElementDefinition> elements = ProfileUtilities.getChildList(profile, focus);
            if (elements.size() == 0) {
                profile = focus.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, focus.getTypeFirstRep().getProfile().get(0).asStringValue()) : this.context.fetchTypeDefinition(focus.getTypeFirstRep().getWorkingCode());
                elements = ProfileUtilities.getChildList(profile, profile.getSnapshot().getElementFirstRep());
            }
            focus = this.getByName(elements, head);
            if (tail != null) {
                head = tail.contains(".") ? tail.substring(0, tail.indexOf(".")) : tail;
                tail = tail.contains(".") ? tail.substring(tail.indexOf(".") + 1) : null;
                continue;
            }
            head = null;
        } while (head != null && focus != null);
        return focus;
    }

    public List<Base> exec(Resource resource, Base data, String fhirpath) {
        return this.fpe.evaluate((Object)this, resource, resource, data, fhirpath);
    }

    public boolean isResource(String name) {
        return this.cu.isResource(name);
    }

    public static enum PEElementPropertiesPolicy {
        NONE,
        EXTENSION,
        EXTENSION_ID;

    }
}

