/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.elementmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.elementmodel.Element;
import org.hl7.fhir.r4b.elementmodel.JsonParser;
import org.hl7.fhir.r4b.elementmodel.ParserBase;
import org.hl7.fhir.r4b.formats.IParser;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SHCParser
extends ParserBase {
    private JsonParser jsonParser;
    private Map<JsonElement, JsonTrackingParser.LocationData> map;
    private List<String> types = new ArrayList<String>();
    private static final int BUFFER_SIZE = 1024;
    public static final String CURRENT_PACKAGE = "hl7.fhir.uv.shc-vaccination#0.6.2";
    private static final int MAX_ALLOWED_SHC_LENGTH = 1195;

    public SHCParser(IWorkerContext context) {
        super(context);
        this.jsonParser = new JsonParser(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ParserBase.NamedElement> parse(InputStream stream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        ArrayList<ParserBase.NamedElement> res = new ArrayList<ParserBase.NamedElement>();
        String src = TextFile.streamToString((InputStream)stream).trim();
        ArrayList<String> list = new ArrayList<String>();
        String pfx = null;
        if (src.startsWith("{")) {
            JsonObject json = JsonTrackingParser.parseJson((String)src);
            if (!this.checkProperty(json, "$", "verifiableCredential", true, "Array")) return res;
            pfx = "verifiableCredential";
            JsonArray arr = json.getAsJsonArray("verifiableCredential");
            int i = 0;
            for (JsonElement e : arr) {
                if (!(e instanceof JsonPrimitive)) {
                    this.logError(this.line(e), this.col(e), "$.verifiableCredential[" + i + "]", ValidationMessage.IssueType.STRUCTURE, "Wrong Property verifiableCredential in JSON Payload. Expected : String but found " + JSONUtil.type((JsonElement)e), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    list.add(e.getAsString());
                }
                ++i;
            }
        } else {
            list.add(src);
        }
        int c = 0;
        for (String ssrc : list) {
            String prefix = pfx == null ? "" : pfx + "[" + Integer.toString(c) + "].";
            ++c;
            JWT jwt = null;
            try {
                jwt = this.decodeJWT(ssrc);
            }
            catch (Exception e) {
                this.logError(1, 1, prefix + "JWT", ValidationMessage.IssueType.INVALID, "Unable to decode JWT token", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            this.map = jwt.map;
            this.checkNamedProperties(jwt.getPayload(), prefix + "payload", "iss", "nbf", "vc");
            this.checkProperty(jwt.getPayload(), prefix + "payload", "iss", true, "String");
            this.logError(1, 1, prefix + "JWT", ValidationMessage.IssueType.INFORMATIONAL, "The FHIR Validator does not check the JWT signature (see https://demo-portals.smarthealth.cards/VerifierPortal.html or https://github.com/smart-on-fhir/health-cards-dev-tools) (Issuer = '" + jwt.getPayload().get("iss").getAsString() + "')", ValidationMessage.IssueSeverity.INFORMATION);
            this.checkProperty(jwt.getPayload(), prefix + "payload", "nbf", true, "Number");
            JsonObject vc = jwt.getPayload().getAsJsonObject("vc");
            if (vc == null) {
                this.logError(1, 1, "JWT", ValidationMessage.IssueType.STRUCTURE, "Unable to find property 'vc' in the payload", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            String path = prefix + "payload.vc";
            this.checkNamedProperties(vc, path, "type", "credentialSubject");
            if (!this.checkProperty(vc, path, "type", true, "Array")) {
                return res;
            }
            JsonArray type = vc.getAsJsonArray("type");
            int i = 0;
            for (JsonElement e : type) {
                if (!(e instanceof JsonPrimitive)) {
                    this.logError(this.line(e), this.col(e), path + ".type[" + i + "]", ValidationMessage.IssueType.STRUCTURE, "Wrong Property Type in JSON Payload. Expected : String but found " + JSONUtil.type((JsonElement)e), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    this.types.add(e.getAsString());
                }
                ++i;
            }
            if (!this.types.contains("https://smarthealth.cards#health-card")) {
                this.logError(this.line((JsonElement)vc), this.col((JsonElement)vc), path, ValidationMessage.IssueType.STRUCTURE, "Card does not claim to be of type https://smarthealth.cards#health-card, cannot validate", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            if (!this.checkProperty(vc, path, "credentialSubject", true, "Object")) {
                return res;
            }
            JsonObject cs = vc.getAsJsonObject("credentialSubject");
            if (!this.checkProperty(cs, path = path + ".credentialSubject", "fhirVersion", true, "String")) {
                return res;
            }
            JsonElement fv = cs.get("fhirVersion");
            if (!VersionUtilities.versionsCompatible((String)this.context.getVersion(), (String)fv.getAsString())) {
                this.logError(this.line(fv), this.col(fv), path + ".fhirVersion", ValidationMessage.IssueType.STRUCTURE, "Card claims to be of version " + fv.getAsString() + ", cannot be validated against version " + this.context.getVersion(), ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            if (!this.checkProperty(cs, path, "fhirBundle", true, "Object")) {
                return res;
            }
            Element e = this.jsonParser.parse(cs.getAsJsonObject("fhirBundle"), this.map);
            if (e == null) continue;
            res.add(new ParserBase.NamedElement(path, e));
        }
        return res;
    }

    @Override
    public String getImpliedProfile() {
        if (this.types.contains("https://smarthealth.cards#covid19") && this.types.contains("https://smarthealth.cards#immunization")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-vaccination-bundle-dm";
        }
        if (this.types.contains("https://smarthealth.cards#covid19") && this.types.contains("https://smarthealth.cards#laboratory")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-covid19-laboratory-bundle-dm";
        }
        if (this.types.contains("https://smarthealth.cards#laboratory")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-infectious-disease-laboratory-bundle-dm";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkProperty(JsonObject obj, String path, String name, boolean required, String type) {
        JsonElement e = obj.get(name);
        if (e != null) {
            String t = JSONUtil.type((JsonElement)e);
            if (type.equals(t)) return true;
            this.logError(this.line(e), this.col(e), path + "." + name, ValidationMessage.IssueType.STRUCTURE, "Wrong Property Type in JSON Payload. Expected : " + type + " but found " + t, ValidationMessage.IssueSeverity.ERROR);
            return false;
        } else {
            if (!required) return true;
            this.logError(this.line((JsonElement)obj), this.col((JsonElement)obj), path, ValidationMessage.IssueType.STRUCTURE, "Missing Property in JSON Payload: " + name, ValidationMessage.IssueSeverity.ERROR);
        }
        return false;
    }

    private void checkNamedProperties(JsonObject obj, String path, String ... names) {
        for (Map.Entry e : obj.entrySet()) {
            if (Utilities.existsInList((String)((String)e.getKey()), (String[])names)) continue;
            this.logError(this.line((JsonElement)e.getValue()), this.col((JsonElement)e.getValue()), path + "." + (String)e.getKey(), ValidationMessage.IssueType.STRUCTURE, "Unknown Property in JSON Payload", ValidationMessage.IssueSeverity.WARNING);
        }
    }

    private int line(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getLine();
    }

    private int col(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getCol();
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        throw new FHIRFormatError("Writing resources is not supported for the SHC format");
    }

    public static String decodeQRCode(String src) {
        StringBuilder b = new StringBuilder();
        if (!src.startsWith("shc:/")) {
            throw new FHIRException("Unable to process smart health card (didn't start with shc:/)");
        }
        for (int i = 5; i < src.length(); i += 2) {
            String s = src.substring(i, i + 2);
            byte v = Byte.parseByte(s);
            char c = (char)(45 + v);
            b.append(c);
        }
        return b.toString();
    }

    public JWT decodeJWT(String jwt) throws IOException, DataFormatException {
        byte[] payloadJson;
        byte[] headerJson;
        if (jwt.startsWith("shc:/")) {
            jwt = SHCParser.decodeQRCode(jwt);
        }
        if (jwt.length() > 1195) {
            this.logError(-1, -1, "jwt", ValidationMessage.IssueType.TOOLONG, "JWT Payload limit length is 1195 bytes for a single image - this has " + jwt.length() + " bytes", ValidationMessage.IssueSeverity.ERROR);
        }
        String[] parts = SHCParser.splitToken(jwt);
        try {
            headerJson = Base64.getUrlDecoder().decode(parts[0]);
            payloadJson = Base64.getUrlDecoder().decode(parts[1]);
        }
        catch (NullPointerException e) {
            throw new FHIRException("The UTF-8 Charset isn't initialized.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new FHIRException("The input is not a valid base 64 encoded string.", (Throwable)e);
        }
        JWT res = new JWT();
        res.header = JsonTrackingParser.parseJson((byte[])headerJson);
        if ("DEF".equals(JSONUtil.str((JsonObject)res.header, (String)"zip"))) {
            payloadJson = SHCParser.inflate(payloadJson);
        }
        res.payload = JsonTrackingParser.parse((String)TextFile.bytesToString((byte[])payloadJson), res.map, (boolean)true);
        return res;
    }

    static String[] splitToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new FHIRException(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }

    public static final byte[] inflate(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static class JWT {
        private JsonObject header;
        private JsonObject payload;
        public Map<JsonElement, JsonTrackingParser.LocationData> map = new HashMap<JsonElement, JsonTrackingParser.LocationData>();

        public JsonObject getHeader() {
            return this.header;
        }

        public void setHeader(JsonObject header) {
            this.header = header;
        }

        public JsonObject getPayload() {
            return this.payload;
        }

        public void setPayload(JsonObject payload) {
            this.payload = payload;
        }
    }
}

