/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.formats;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4b.formats.JsonCreator;
import org.hl7.fhir.utilities.Utilities;

public class JsonCreatorDirect
implements JsonCreator {
    private Writer writer;
    private boolean pretty;
    private boolean named;
    private List<Boolean> valued = new ArrayList<Boolean>();
    private int indent;

    public JsonCreatorDirect(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setIndent(String indent) {
        this.pretty = !Utilities.noString((String)indent);
    }

    @Override
    public void beginObject() throws IOException {
        this.checkState();
        this.writer.write("{");
        this.stepIn();
        if (!this.valued.isEmpty()) {
            this.valued.set(0, true);
        }
        this.valued.add(0, false);
    }

    public void stepIn() throws IOException {
        if (this.pretty) {
            ++this.indent;
            this.writer.write("\r\n");
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write("  ");
            }
        }
    }

    public void stepOut() throws IOException {
        if (this.pretty) {
            --this.indent;
            this.writer.write("\r\n");
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write("  ");
            }
        }
    }

    private void checkState() throws IOException {
        if (this.named) {
            if (this.pretty) {
                this.writer.write(" : ");
            } else {
                this.writer.write(":");
            }
            this.named = false;
        }
        if (!this.valued.isEmpty() && this.valued.get(0).booleanValue()) {
            this.writer.write(",");
            if (this.pretty) {
                this.writer.write("\r\n");
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write("  ");
                }
            }
            this.valued.set(0, false);
        }
    }

    @Override
    public void endObject() throws IOException {
        this.stepOut();
        this.writer.write("}");
        this.valued.remove(0);
    }

    @Override
    public void nullValue() throws IOException {
        this.checkState();
        this.writer.write("null");
        this.valued.set(0, true);
    }

    @Override
    public void name(String name) throws IOException {
        this.checkState();
        this.writer.write("\"" + name + "\"");
        this.named = true;
    }

    @Override
    public void value(String value) throws IOException {
        this.checkState();
        this.writer.write("\"" + Utilities.escapeJson((String)value) + "\"");
        this.valued.set(0, true);
    }

    @Override
    public void value(Boolean value) throws IOException {
        this.checkState();
        if (value == null) {
            this.writer.write("null");
        } else if (value.booleanValue()) {
            this.writer.write("true");
        } else {
            this.writer.write("false");
        }
        this.valued.set(0, true);
    }

    @Override
    public void value(BigDecimal value) throws IOException {
        this.checkState();
        if (value == null) {
            this.writer.write("null");
        } else {
            this.writer.write(value.toString());
        }
        this.valued.set(0, true);
    }

    @Override
    public void valueNum(String value) throws IOException {
        this.checkState();
        if (value == null) {
            this.writer.write("null");
        } else {
            this.writer.write(value);
        }
        this.valued.set(0, true);
    }

    @Override
    public void value(Integer value) throws IOException {
        this.checkState();
        if (value == null) {
            this.writer.write("null");
        } else {
            this.writer.write(value.toString());
        }
        this.valued.set(0, true);
    }

    @Override
    public void beginArray() throws IOException {
        this.checkState();
        this.writer.write("[");
        if (!this.valued.isEmpty()) {
            this.valued.set(0, true);
        }
        this.valued.add(0, false);
    }

    @Override
    public void endArray() throws IOException {
        this.writer.write("]");
        this.valued.remove(0);
    }

    @Override
    public void finish() throws IOException {
        this.writer.flush();
    }

    @Override
    public void link(String href) {
    }

    @Override
    public void anchor(String name) {
    }
}

