/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Expression;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.renderers.ResourceRenderer;
import org.hl7.fhir.r4b.renderers.utils.BaseWrappers;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireResponseRenderer
extends ResourceRenderer {
    public QuestionnaireResponseRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (QuestionnaireResponse)q);
    }

    public boolean render(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderTree(x, qr);
            }
            case LINKS: {
                return this.renderLinks(x, qr);
            }
            case TREE: {
                return this.renderTree(x, qr);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + qr.getId(), false);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, (List<HierarchicalTableGenerator.Row>)model.getRows(), qr);
        List<BaseWrappers.BaseWrapper> items = qr.children("item");
        for (BaseWrappers.BaseWrapper i : items) {
            hasExt = this.renderTreeItem(gen, (List<HierarchicalTableGenerator.Row>)row.getSubRows(), qr, i) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    public boolean renderTree(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, (List<HierarchicalTableGenerator.Row>)model.getRows(), q);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent i : q.getItem()) {
            hasExt = this.renderTreeItem(gen, (List<HierarchicalTableGenerator.Row>)row.getSubRows(), q, i) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getId(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "QuestionnaireResponse", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "", null, null));
        return r;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getId(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "QuestionnaireResponse", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "", null, null));
        return r;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q, BaseWrappers.BaseWrapper i) throws IOException {
        boolean hasItem;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        List<BaseWrappers.BaseWrapper> items = i.children("item");
        List<BaseWrappers.BaseWrapper> answers = i.children("answer");
        boolean bl = hasItem = items != null && !items.isEmpty();
        if (answers != null) {
            for (BaseWrappers.BaseWrapper a : answers) {
                hasItem = a.has("item");
            }
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", "Group");
        } else {
            r.setIcon("icon-q-string.png", "Item");
        }
        String linkId = i.has("linkId") ? i.get("linkId").primitiveValue() : "??";
        String text = i.has("text") ? i.get("text").primitiveValue() : "";
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + linkId, linkId, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, text, null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        if (answers.size() == 0) {
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
            for (BaseWrappers.BaseWrapper si : items) {
                this.renderTreeItem(gen, (List<HierarchicalTableGenerator.Row>)r.getSubRows(), q, si);
            }
        } else if (answers.size() == 1) {
            BaseWrappers.BaseWrapper ans = answers.get(0);
            this.renderAnswer(gen, q, r, ans);
        } else {
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, null, null, null));
            for (BaseWrappers.BaseWrapper ans : answers) {
                HierarchicalTableGenerator.Row ar = new HierarchicalTableGenerator.Row(gen);
                ar.setIcon("icon-q-string.png", "Item");
                ar.getSubRows().add(ar);
                List list6 = ar.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, null, null, null));
                List list7 = ar.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, text, null, null));
                List list8 = ar.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, null, null, null, null, null));
                this.renderAnswer(gen, q, ar, ans);
            }
        }
        return hasExt;
    }

    public void renderAnswer(HierarchicalTableGenerator gen, BaseWrappers.ResourceWrapper q, HierarchicalTableGenerator.Row r, BaseWrappers.BaseWrapper ans) throws UnsupportedEncodingException, IOException {
        Base b = ans.get("value[x]");
        if (b == null) {
            List list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "null!", null, null));
        } else if (b.isPrimitive()) {
            List list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, b.primitiveValue(), null, null));
        } else {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "span");
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, "span");
            p.getChildren().add(x);
            cell.addPiece(p);
            this.render(x, (DataType)b);
            r.getCells().add(cell);
        }
        List<BaseWrappers.BaseWrapper> items = ans.children("item");
        for (BaseWrappers.BaseWrapper si : items) {
            this.renderTreeItem(gen, (List<HierarchicalTableGenerator.Row>)r.getSubRows(), q, si);
        }
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q, QuestionnaireResponse.QuestionnaireResponseItemComponent i) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        boolean hasItem = i.hasItem();
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent a : i.getAnswer()) {
            hasItem = a.hasItem();
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", "Group");
        } else {
            r.setIcon("icon-q-string.png", "Item");
        }
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), i.getLinkId(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, i.getText(), null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, QuestionnaireResponse.QuestionnaireResponseItemComponent i, HierarchicalTableGenerator.Cell defn) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
            }
        } else {
            List list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, QuestionnaireResponse.QuestionnaireResponseItemComponent i) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i.getDefinition());
            }
        } else {
            x.tx(i.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(url).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    public boolean renderForm(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        return false;
    }

    public boolean renderForm(XhtmlNode x, BaseWrappers.ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        d.tx("todo");
        return hasExt;
    }

    private boolean renderLinks(XhtmlNode x, QuestionnaireResponse q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getSelfLink(), "package.tgz"}) + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    private boolean renderLinks(XhtmlNode x, BaseWrappers.ResourceWrapper q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getSelfLink(), "package.tgz"}) + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }
}

