/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers.utils;

import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.conformance.ProfileUtilities;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.FhirPublication;
import org.hl7.fhir.r4b.renderers.utils.Resolver;
import org.hl7.fhir.r4b.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class RenderingContext {
    private IWorkerContext worker;
    private MarkDownProcessor markdown;
    private ResourceRendererMode mode;
    private Resolver.IReferenceResolver resolver;
    private ILiquidTemplateProvider templateProvider;
    private FHIRPathEngine.IEvaluationContext services;
    private ITypeParser parser;
    private String lang;
    private String localPrefix;
    private String specificationLink;
    private String selfLink;
    private int headerLevelContext;
    private boolean canonicalUrlsAsLinks;
    private boolean pretty;
    private boolean header;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions();
    private boolean noSlowLookup;
    private String tooCostlyNoteEmpty;
    private String tooCostlyNoteNotEmpty;
    private String tooCostlyNoteEmptyDependent;
    private String tooCostlyNoteNotEmptyDependent;
    private List<String> codeSystemPropList = new ArrayList<String>();
    private ProfileUtilities profileUtilities;
    private String definitionsTarget;
    private String destDir;
    private boolean inlineGraphics;
    private QuestionnaireRendererMode questionnaireMode = QuestionnaireRendererMode.FORM;
    private boolean addGeneratedNarrativeHeader = true;
    private FhirPublication targetVersion;
    private Locale locale;
    private ZoneId timeZoneId;
    private DateTimeFormatter dateTimeFormat;
    private DateTimeFormatter dateFormat;

    public RenderingContext(IWorkerContext worker, MarkDownProcessor markdown, ValidationOptions terminologyServiceOptions, String specLink, String localPrefix, String lang, ResourceRendererMode mode) {
        this.worker = worker;
        this.markdown = markdown;
        this.lang = lang;
        this.specificationLink = specLink;
        this.localPrefix = localPrefix;
        this.mode = mode;
        if (terminologyServiceOptions != null) {
            this.terminologyServiceOptions = terminologyServiceOptions;
        }
        this.locale = new Locale.Builder().setLanguageTag("en-US").build();
        this.profileUtilities = new ProfileUtilities(worker, null, null);
    }

    public IWorkerContext getContext() {
        return this.worker;
    }

    public ProfileUtilities getProfileUtilities() {
        return this.profileUtilities;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    public RenderingContext setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
        return this;
    }

    public MarkDownProcessor getMarkdown() {
        if (this.markdown == null) {
            this.markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
        }
        return this.markdown;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSpecificationLink() {
        return this.specificationLink;
    }

    public String getLocalPrefix() {
        return this.localPrefix;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public String getTooCostlyNoteEmpty() {
        return this.tooCostlyNoteEmpty;
    }

    public RenderingContext setTooCostlyNoteEmpty(String tooCostlyNoteEmpty) {
        this.tooCostlyNoteEmpty = tooCostlyNoteEmpty;
        return this;
    }

    public String getTooCostlyNoteNotEmpty() {
        return this.tooCostlyNoteNotEmpty;
    }

    public RenderingContext setTooCostlyNoteNotEmpty(String tooCostlyNoteNotEmpty) {
        this.tooCostlyNoteNotEmpty = tooCostlyNoteNotEmpty;
        return this;
    }

    public String getTooCostlyNoteEmptyDependent() {
        return this.tooCostlyNoteEmptyDependent;
    }

    public RenderingContext setTooCostlyNoteEmptyDependent(String tooCostlyNoteEmptyDependent) {
        this.tooCostlyNoteEmptyDependent = tooCostlyNoteEmptyDependent;
        return this;
    }

    public String getTooCostlyNoteNotEmptyDependent() {
        return this.tooCostlyNoteNotEmptyDependent;
    }

    public RenderingContext setTooCostlyNoteNotEmptyDependent(String tooCostlyNoteNotEmptyDependent) {
        this.tooCostlyNoteNotEmptyDependent = tooCostlyNoteNotEmptyDependent;
        return this;
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public RenderingContext setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
        return this;
    }

    public Resolver.IReferenceResolver getResolver() {
        return this.resolver;
    }

    public RenderingContext setResolver(Resolver.IReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public RenderingContext setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
        return this;
    }

    public boolean isNoSlowLookup() {
        return this.noSlowLookup;
    }

    public RenderingContext setNoSlowLookup(boolean noSlowLookup) {
        this.noSlowLookup = noSlowLookup;
        return this;
    }

    public String getDefinitionsTarget() {
        return this.definitionsTarget;
    }

    public RenderingContext setDefinitionsTarget(String definitionsTarget) {
        this.definitionsTarget = definitionsTarget;
        return this;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public RenderingContext setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public RenderingContext setProfileUtilities(ProfileUtilities profileUtilities) {
        this.profileUtilities = profileUtilities;
        return this;
    }

    public ILiquidTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public RenderingContext setTemplateProvider(ILiquidTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
        return this;
    }

    public FHIRPathEngine.IEvaluationContext getServices() {
        return this.services;
    }

    public RenderingContext setServices(FHIRPathEngine.IEvaluationContext services) {
        this.services = services;
        return this;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public RenderingContext setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public ITypeParser getParser() {
        return this.parser;
    }

    public RenderingContext setParser(ITypeParser parser) {
        this.parser = parser;
        return this;
    }

    public List<String> getCodeSystemPropList() {
        return this.codeSystemPropList;
    }

    public RenderingContext setCodeSystemPropList(List<String> codeSystemPropList) {
        this.codeSystemPropList = codeSystemPropList;
        return this;
    }

    public RenderingContext copy() {
        RenderingContext res = new RenderingContext(this.worker, this.markdown, this.terminologyServiceOptions, this.specificationLink, this.localPrefix, this.lang, this.mode);
        res.resolver = this.resolver;
        res.templateProvider = this.templateProvider;
        res.services = this.services;
        res.parser = this.parser;
        res.headerLevelContext = this.headerLevelContext;
        res.canonicalUrlsAsLinks = this.canonicalUrlsAsLinks;
        res.pretty = this.pretty;
        res.noSlowLookup = this.noSlowLookup;
        res.tooCostlyNoteEmpty = this.tooCostlyNoteEmpty;
        res.tooCostlyNoteNotEmpty = this.tooCostlyNoteNotEmpty;
        res.tooCostlyNoteEmptyDependent = this.tooCostlyNoteEmptyDependent;
        res.tooCostlyNoteNotEmptyDependent = this.tooCostlyNoteNotEmptyDependent;
        res.codeSystemPropList.addAll(this.codeSystemPropList);
        res.profileUtilities = this.profileUtilities;
        res.definitionsTarget = this.definitionsTarget;
        res.destDir = this.destDir;
        res.addGeneratedNarrativeHeader = this.addGeneratedNarrativeHeader;
        return res;
    }

    public boolean isInlineGraphics() {
        return this.inlineGraphics;
    }

    public RenderingContext setInlineGraphics(boolean inlineGraphics) {
        this.inlineGraphics = inlineGraphics;
        return this;
    }

    public boolean isHeader() {
        return this.header;
    }

    public RenderingContext setHeader(boolean header) {
        this.header = header;
        return this;
    }

    public QuestionnaireRendererMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public RenderingContext setQuestionnaireMode(QuestionnaireRendererMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public RenderingContext setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public String fixReference(String ref) {
        if (!Utilities.isAbsoluteUrl((String)ref)) {
            return (this.localPrefix == null ? "" : this.localPrefix) + ref;
        }
        if (ref.startsWith("http://hl7.org/fhir") && !ref.substring(20).contains("/")) {
            return this.specificationLink + ref.substring(20);
        }
        return ref;
    }

    public RenderingContext setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public RenderingContext setLocalPrefix(String localPrefix) {
        this.localPrefix = localPrefix;
        return this;
    }

    public boolean isAddGeneratedNarrativeHeader() {
        return this.addGeneratedNarrativeHeader;
    }

    public RenderingContext setAddGeneratedNarrativeHeader(boolean addGeneratedNarrativeHeader) {
        this.addGeneratedNarrativeHeader = addGeneratedNarrativeHeader;
        return this;
    }

    public FhirPublication getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(FhirPublication targetVersion) {
        this.targetVersion = targetVersion;
    }

    public boolean isTechnicalMode() {
        return this.mode == ResourceRendererMode.TECHNICAL;
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateTimeFormatter dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public DateTimeFormatter getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    public ResourceRendererMode getMode() {
        return this.mode;
    }

    public void setMode(ResourceRendererMode mode) {
        this.mode = mode;
    }

    public static enum QuestionnaireRendererMode {
        FORM,
        TREE,
        LOGIC,
        DEFNS,
        LINKS;

    }

    public static enum ResourceRendererMode {
        END_USER,
        TECHNICAL;

    }

    public static interface ITypeParser {
        public Base parseType(String var1, String var2) throws FHIRFormatError, IOException, FHIRException;
    }

    public static interface ILiquidTemplateProvider {
        public String findTemplate(RenderingContext var1, DomainResource var2);

        public String findTemplate(RenderingContext var1, String var2);
    }
}

