/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.utilities.DateTimeUtil;
import org.hl7.fhir.utilities.Utilities;

public abstract class BaseDateTimeType
extends PrimitiveType<Date> {
    static final long NANOS_PER_MILLIS = 1000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    private static final Map<String, TimeZone> timezoneCache = new ConcurrentHashMap<String, TimeZone>();
    private static final long serialVersionUID = 1L;
    private String myFractionalSeconds;
    private TemporalPrecisionEnum myPrecision = null;
    private TimeZone myTimeZone;
    private boolean myTimeZoneZulu = false;

    public BaseDateTimeType() {
    }

    public BaseDateTimeType(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.setValue(theDate, thePrecision);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    public BaseDateTimeType(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimeZone) {
        this(theDate, thePrecision);
        this.setTimeZone(theTimeZone);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    public BaseDateTimeType(String theString) {
        this.setValueAsString(theString);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    private void validatePrecisionAndThrowIllegalArgumentException() {
        if (!this.isPrecisionAllowed(this.getPrecision())) {
            throw new IllegalArgumentException("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support " + this.getPrecision() + " precision): " + this.getValueAsString());
        }
    }

    public void add(int theField, int theValue) {
        switch (theField) {
            case 1: {
                this.setValue(DateUtils.addYears((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 2: {
                this.setValue(DateUtils.addMonths((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 5: {
                this.setValue(DateUtils.addDays((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 10: {
                this.setValue(DateUtils.addHours((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 12: {
                this.setValue(DateUtils.addMinutes((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 13: {
                this.setValue(DateUtils.addSeconds((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 14: {
                this.setValue(DateUtils.addMilliseconds((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            default: {
                throw new DataFormatException("Unknown field constant: " + theField);
            }
        }
    }

    public boolean after(DateTimeType theDateTimeType) {
        this.validateBeforeOrAfter(theDateTimeType);
        return ((Date)this.getValue()).after((Date)theDateTimeType.getValue());
    }

    public boolean before(DateTimeType theDateTimeType) {
        this.validateBeforeOrAfter(theDateTimeType);
        return ((Date)this.getValue()).before((Date)theDateTimeType.getValue());
    }

    private void clearTimeZone() {
        this.myTimeZone = null;
        this.myTimeZoneZulu = false;
    }

    @Override
    protected String encode(Date theValue) {
        if (theValue == null) {
            return null;
        }
        GregorianCalendar cal = this.myTimeZoneZulu ? new GregorianCalendar(this.getTimeZone("GMT")) : (this.myTimeZone != null ? new GregorianCalendar(this.myTimeZone) : new GregorianCalendar());
        cal.setTime(theValue);
        StringBuilder b = new StringBuilder();
        this.leftPadWithZeros(cal.get(1), 4, b);
        if (this.myPrecision.ordinal() > TemporalPrecisionEnum.YEAR.ordinal()) {
            b.append('-');
            this.leftPadWithZeros(cal.get(2) + 1, 2, b);
            if (this.myPrecision.ordinal() > TemporalPrecisionEnum.MONTH.ordinal()) {
                b.append('-');
                this.leftPadWithZeros(cal.get(5), 2, b);
                if (this.myPrecision.ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
                    b.append('T');
                    this.leftPadWithZeros(cal.get(11), 2, b);
                    b.append(':');
                    this.leftPadWithZeros(cal.get(12), 2, b);
                    if (this.myPrecision.ordinal() > TemporalPrecisionEnum.MINUTE.ordinal()) {
                        b.append(':');
                        this.leftPadWithZeros(cal.get(13), 2, b);
                        if (this.myPrecision.ordinal() > TemporalPrecisionEnum.SECOND.ordinal()) {
                            b.append('.');
                            b.append(this.myFractionalSeconds);
                            for (int i = this.myFractionalSeconds.length(); i < 3; ++i) {
                                b.append('0');
                            }
                        }
                    }
                    if (this.myTimeZoneZulu) {
                        b.append('Z');
                    } else if (this.myTimeZone != null) {
                        int offset = this.myTimeZone.getOffset(theValue.getTime());
                        if (offset >= 0) {
                            b.append('+');
                        } else {
                            b.append('-');
                            offset = Math.abs(offset);
                        }
                        int hoursOffset = (int)((long)offset / 3600000L);
                        this.leftPadWithZeros(hoursOffset, 2, b);
                        b.append(':');
                        int minutesOffset = (int)((long)offset % 3600000L);
                        minutesOffset = (int)((long)minutesOffset / 60000L);
                        this.leftPadWithZeros(minutesOffset, 2, b);
                    }
                }
            }
        }
        return b.toString();
    }

    public Integer getDay() {
        return this.getFieldValue(5);
    }

    protected abstract TemporalPrecisionEnum getDefaultPrecisionForDatatype();

    private Integer getFieldValue(int theField) {
        if (this.getValue() == null) {
            return null;
        }
        GregorianCalendar cal = this.getValueAsCalendar();
        return cal.get(theField);
    }

    public Integer getHour() {
        return this.getFieldValue(11);
    }

    public Integer getMillis() {
        return this.getFieldValue(14);
    }

    public Integer getMinute() {
        return this.getFieldValue(12);
    }

    public Integer getMonth() {
        return this.getFieldValue(2);
    }

    public float getSecondsMilli() {
        int sec = this.getSecond();
        int milli = this.getMillis();
        String s = Integer.toString(sec) + "." + Utilities.padLeft((String)Integer.toString(milli), (char)'0', (int)3);
        return Float.parseFloat(s);
    }

    public Long getNanos() {
        if (StringUtils.isBlank((CharSequence)this.myFractionalSeconds)) {
            return null;
        }
        String retVal = StringUtils.rightPad((String)this.myFractionalSeconds, (int)9, (char)'0');
        retVal = retVal.substring(0, 9);
        return Long.parseLong(retVal);
    }

    private int getOffsetIndex(String theValueString) {
        int plusIndex = theValueString.indexOf(43, 16);
        int minusIndex = theValueString.indexOf(45, 16);
        int zIndex = theValueString.indexOf(90, 16);
        int retVal = Math.max(Math.max(plusIndex, minusIndex), zIndex);
        if (retVal == -1) {
            return -1;
        }
        if (retVal - 2 != plusIndex + minusIndex + zIndex) {
            this.throwBadDateFormat(theValueString);
        }
        return retVal;
    }

    public TemporalPrecisionEnum getPrecision() {
        if (this.myPrecision == null) {
            return this.getDefaultPrecisionForDatatype();
        }
        return this.myPrecision;
    }

    public Integer getSecond() {
        return this.getFieldValue(13);
    }

    public TimeZone getTimeZone() {
        if (this.myTimeZoneZulu) {
            return this.getTimeZone("GMT");
        }
        return this.myTimeZone;
    }

    public GregorianCalendar getValueAsCalendar() {
        if (this.getValue() == null) {
            return null;
        }
        GregorianCalendar cal = this.getTimeZone() != null ? new GregorianCalendar(this.getTimeZone()) : new GregorianCalendar();
        cal.setTime((Date)this.getValue());
        return cal;
    }

    public Integer getYear() {
        return this.getFieldValue(1);
    }

    abstract boolean isPrecisionAllowed(TemporalPrecisionEnum var1);

    public boolean isTimeZoneZulu() {
        return this.myTimeZoneZulu;
    }

    public boolean isToday() {
        Validate.notNull((Object)((Date)this.getValue()), (String)(this.getClass().getSimpleName() + " contains null value"), (Object[])new Object[0]);
        return DateUtils.isSameDay((Date)new Date(), (Date)((Date)this.getValue()));
    }

    private void leftPadWithZeros(int theInteger, int theLength, StringBuilder theTarget) {
        String string = Integer.toString(theInteger);
        for (int i = string.length(); i < theLength; ++i) {
            theTarget.append('0');
        }
        theTarget.append(string);
    }

    @Override
    protected Date parse(String theValue) throws DataFormatException {
        int length;
        GregorianCalendar cal = new GregorianCalendar(0, 0, 0);
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        String value = theValue;
        boolean fractionalSecondsSet = false;
        if (value.length() > 0 && (value.charAt(0) == ' ' || value.charAt(value.length() - 1) == ' ')) {
            value = value.trim();
        }
        if ((length = value.length()) == 0) {
            return null;
        }
        if (length < 4) {
            this.throwBadDateFormat(value);
        }
        TemporalPrecisionEnum precision = null;
        cal.set(1, this.parseInt(value, value.substring(0, 4), 0, 9999));
        precision = TemporalPrecisionEnum.YEAR;
        if (length > 4) {
            this.validateCharAtIndexIs(value, 4, '-');
            this.validateLengthIsAtLeast(value, 7);
            int monthVal = this.parseInt(value, value.substring(5, 7), 1, 12) - 1;
            cal.set(2, monthVal);
            precision = TemporalPrecisionEnum.MONTH;
            if (length > 7) {
                this.validateCharAtIndexIs(value, 7, '-');
                this.validateLengthIsAtLeast(value, 10);
                cal.set(5, 1);
                int actualMaximum = ((Calendar)cal).getActualMaximum(5);
                cal.set(5, this.parseInt(value, value.substring(8, 10), 1, actualMaximum));
                precision = TemporalPrecisionEnum.DAY;
                if (length > 10) {
                    String time;
                    this.validateLengthIsAtLeast(value, 17);
                    this.validateCharAtIndexIs(value, 10, 'T');
                    int offsetIdx = this.getOffsetIndex(value);
                    if (offsetIdx == -1) {
                        time = value.substring(11);
                    } else {
                        time = value.substring(11, offsetIdx);
                        String offsetString = value.substring(offsetIdx);
                        this.setTimeZone(value, offsetString);
                        ((Calendar)cal).setTimeZone(this.getTimeZone());
                    }
                    int timeLength = time.length();
                    this.validateCharAtIndexIs(value, 13, ':');
                    cal.set(11, this.parseInt(value, value.substring(11, 13), 0, 23));
                    cal.set(12, this.parseInt(value, value.substring(14, 16), 0, 59));
                    precision = TemporalPrecisionEnum.MINUTE;
                    if (timeLength > 5) {
                        this.validateLengthIsAtLeast(value, 19);
                        this.validateCharAtIndexIs(value, 16, ':');
                        cal.set(13, this.parseInt(value, value.substring(17, 19), 0, 60));
                        precision = TemporalPrecisionEnum.SECOND;
                        if (timeLength > 8) {
                            int millis;
                            String millisString;
                            this.validateCharAtIndexIs(value, 19, '.');
                            this.validateLengthIsAtLeast(value, 20);
                            int endIndex = this.getOffsetIndex(value);
                            if (endIndex == -1) {
                                endIndex = value.length();
                            }
                            if (endIndex > 23) {
                                this.myFractionalSeconds = value.substring(20, endIndex);
                                fractionalSecondsSet = true;
                                endIndex = 23;
                                millisString = value.substring(20, endIndex);
                                millis = this.parseInt(value, millisString, 0, 999);
                            } else {
                                millisString = value.substring(20, endIndex);
                                millis = this.parseInt(value, millisString, 0, 999);
                                this.myFractionalSeconds = millisString;
                                fractionalSecondsSet = true;
                            }
                            if (millisString.length() == 1) {
                                millis *= 100;
                            } else if (millisString.length() == 2) {
                                millis *= 10;
                            }
                            cal.set(14, millis);
                            precision = TemporalPrecisionEnum.MILLI;
                        }
                    }
                }
            } else {
                cal.set(5, 1);
            }
        } else {
            cal.set(5, 1);
        }
        if (!fractionalSecondsSet) {
            this.myFractionalSeconds = "";
        }
        this.myPrecision = precision;
        return cal.getTime();
    }

    private int parseInt(String theValue, String theSubstring, int theLowerBound, int theUpperBound) {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(theSubstring);
        }
        catch (NumberFormatException e) {
            this.throwBadDateFormat(theValue);
        }
        if (retVal < theLowerBound || retVal > theUpperBound) {
            this.throwBadDateFormat(theValue);
        }
        return retVal;
    }

    public BaseDateTimeType setDay(int theDay) {
        this.setFieldValue(5, theDay, null, 0, 31);
        return this;
    }

    private void setFieldValue(int theField, int theValue, String theFractionalSeconds, int theMinimum, int theMaximum) {
        this.validateValueInRange(theValue, theMinimum, theMaximum);
        GregorianCalendar cal = this.getValue() == null ? new GregorianCalendar(0, 0, 0) : this.getValueAsCalendar();
        if (theField != -1) {
            cal.set(theField, theValue);
        }
        if (theFractionalSeconds != null) {
            this.myFractionalSeconds = theFractionalSeconds;
        } else if (theField == 14) {
            this.myFractionalSeconds = StringUtils.leftPad((String)Integer.toString(theValue), (int)3, (char)'0');
        }
        super.setValue(cal.getTime());
    }

    public BaseDateTimeType setHour(int theHour) {
        this.setFieldValue(11, theHour, null, 0, 23);
        return this;
    }

    public BaseDateTimeType setMillis(int theMillis) {
        this.setFieldValue(14, theMillis, null, 0, 999);
        return this;
    }

    public BaseDateTimeType setMinute(int theMinute) {
        this.setFieldValue(12, theMinute, null, 0, 59);
        return this;
    }

    public BaseDateTimeType setMonth(int theMonth) {
        this.setFieldValue(2, theMonth, null, 0, 11);
        return this;
    }

    public BaseDateTimeType setNanos(long theNanos) {
        this.validateValueInRange(theNanos, 0L, 999999999L);
        String fractionalSeconds = StringUtils.leftPad((String)Long.toString(theNanos), (int)9, (char)'0');
        for (int i = fractionalSeconds.length(); i > 0; --i) {
            if (fractionalSeconds.charAt(i - 1) == '0') continue;
            fractionalSeconds = fractionalSeconds.substring(0, i);
            break;
        }
        int millis = (int)(theNanos / 1000000L);
        this.setFieldValue(14, millis, fractionalSeconds, 0, 999);
        return this;
    }

    public void setPrecision(TemporalPrecisionEnum thePrecision) throws DataFormatException {
        if (thePrecision == null) {
            throw new NullPointerException("Precision may not be null");
        }
        this.myPrecision = thePrecision;
        this.updateStringValue();
    }

    public BaseDateTimeType setSecond(int theSecond) {
        this.setFieldValue(13, theSecond, null, 0, 59);
        return this;
    }

    private BaseDateTimeType setTimeZone(String theWholeValue, String theValue) {
        if (StringUtils.isBlank((CharSequence)theValue)) {
            this.throwBadDateFormat(theWholeValue);
        } else if (theValue.charAt(0) == 'Z') {
            this.myTimeZone = null;
            this.myTimeZoneZulu = true;
        } else if (theValue.length() != 6) {
            this.throwBadDateFormat(theWholeValue, "Timezone offset must be in the form \"Z\", \"-HH:mm\", or \"+HH:mm\"");
        } else if (theValue.charAt(3) != ':' || theValue.charAt(0) != '+' && theValue.charAt(0) != '-') {
            this.throwBadDateFormat(theWholeValue, "Timezone offset must be in the form \"Z\", \"-HH:mm\", or \"+HH:mm\"");
        } else {
            this.parseInt(theWholeValue, theValue.substring(1, 3), 0, 23);
            this.parseInt(theWholeValue, theValue.substring(4, 6), 0, 59);
            this.myTimeZoneZulu = false;
            this.myTimeZone = this.getTimeZone("GMT" + theValue);
        }
        return this;
    }

    public BaseDateTimeType setTimeZone(TimeZone theTimeZone) {
        this.myTimeZone = theTimeZone;
        this.myTimeZoneZulu = false;
        this.updateStringValue();
        return this;
    }

    public BaseDateTimeType setTimeZoneZulu(boolean theTimeZoneZulu) {
        this.myTimeZoneZulu = theTimeZoneZulu;
        this.myTimeZone = null;
        this.updateStringValue();
        return this;
    }

    public BaseDateTimeType setValue(Date theValue) {
        this.setValue(theValue, this.getPrecision());
        return this;
    }

    public void setValue(Date theValue, TemporalPrecisionEnum thePrecision) throws DataFormatException {
        if (this.getTimeZone() == null) {
            this.setTimeZone(TimeZone.getDefault());
        }
        this.myPrecision = thePrecision;
        this.myFractionalSeconds = "";
        if (theValue != null) {
            long millis = theValue.getTime() % 1000L;
            if (millis < 0L) {
                millis = 1000L + millis;
            }
            String fractionalSeconds = Integer.toString((int)millis);
            this.myFractionalSeconds = StringUtils.leftPad((String)fractionalSeconds, (int)3, (char)'0');
        }
        super.setValue(theValue);
    }

    @Override
    public void setValueAsString(String theString) throws DataFormatException {
        this.clearTimeZone();
        super.setValueAsString(theString);
    }

    protected void setValueAsV3String(String theV3String) {
        if (StringUtils.isBlank((CharSequence)theV3String)) {
            this.setValue(null);
        } else {
            StringBuilder b = new StringBuilder();
            String timeZone = null;
            for (int i = 0; i < theV3String.length(); ++i) {
                char nextChar = theV3String.charAt(i);
                if (nextChar == '+' || nextChar == '-' || nextChar == 'Z') {
                    timeZone = theV3String.substring(i);
                    break;
                }
                if (i == 4 || i == 6) {
                    b.append('-');
                } else if (i == 8) {
                    b.append('T');
                } else if (i == 10 || i == 12) {
                    b.append(':');
                }
                b.append(nextChar);
            }
            if (b.length() == 13) {
                b.append(":00");
            }
            if (b.length() == 16) {
                b.append(":00");
            }
            if (timeZone != null && b.length() > 10) {
                if (timeZone.length() == 5) {
                    b.append(timeZone.substring(0, 3));
                    b.append(':');
                    b.append(timeZone.substring(3));
                } else {
                    b.append(timeZone);
                }
            }
            this.setValueAsString(b.toString());
        }
    }

    public BaseDateTimeType setYear(int theYear) {
        this.setFieldValue(1, theYear, null, 0, 9999);
        return this;
    }

    private void throwBadDateFormat(String theValue) {
        throw new DataFormatException("Invalid date/time format: \"" + theValue + "\"");
    }

    private void throwBadDateFormat(String theValue, String theMesssage) {
        throw new DataFormatException("Invalid date/time format: \"" + theValue + "\": " + theMesssage);
    }

    public Calendar toCalendar() {
        Calendar retVal = Calendar.getInstance();
        retVal.setTime((Date)this.getValue());
        retVal.setTimeZone(this.getTimeZone());
        return retVal;
    }

    public String toHumanDisplay() {
        return DateTimeUtil.toHumanDisplay((TimeZone)this.getTimeZone(), (TemporalPrecisionEnum)this.getPrecision(), (Date)((Date)this.getValue()), (String)this.getValueAsString());
    }

    public String toHumanDisplayLocalTimezone() {
        return DateTimeUtil.toHumanDisplayLocalTimezone((TemporalPrecisionEnum)this.getPrecision(), (Date)((Date)this.getValue()), (String)this.getValueAsString());
    }

    private void validateBeforeOrAfter(DateTimeType theDateTimeType) {
        if (this.getValue() == null) {
            throw new NullPointerException("This BaseDateTimeType does not contain a value (getValue() returns null)");
        }
        if (theDateTimeType == null) {
            throw new NullPointerException("theDateTimeType must not be null");
        }
        if (theDateTimeType.getValue() == null) {
            throw new NullPointerException("The given BaseDateTimeType does not contain a value (theDateTimeType.getValue() returns null)");
        }
    }

    private void validateCharAtIndexIs(String theValue, int theIndex, char theChar) {
        if (theValue.charAt(theIndex) != theChar) {
            this.throwBadDateFormat(theValue, "Expected character '" + theChar + "' at index " + theIndex + " but found " + theValue.charAt(theIndex));
        }
    }

    private void validateLengthIsAtLeast(String theValue, int theLength) {
        if (theValue.length() < theLength) {
            this.throwBadDateFormat(theValue);
        }
    }

    private void validateValueInRange(long theValue, long theMinimum, long theMaximum) {
        if (theValue < theMinimum || theValue > theMaximum) {
            throw new IllegalArgumentException("Value " + theValue + " is not between allowable range: " + theMinimum + " - " + theMaximum);
        }
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public BaseDateTimeType dateTimeValue() {
        return this;
    }

    public boolean hasTime() {
        return this.myPrecision == TemporalPrecisionEnum.MINUTE || this.myPrecision == TemporalPrecisionEnum.SECOND || this.myPrecision == TemporalPrecisionEnum.MILLI;
    }

    public Boolean equalsUsingFhirPathRules(BaseDateTimeType theOther) {
        Integer i;
        if (this.hasTimezone() != theOther.hasTimezone()) {
            if (!this.couldBeTheSameTime(this, theOther)) {
                return false;
            }
            return null;
        }
        BaseDateTimeType left = (BaseDateTimeType)this.copy();
        BaseDateTimeType right = (BaseDateTimeType)theOther.copy();
        if (left.hasTimezone() && left.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            left.setTimeZoneZulu(true);
        }
        if (right.hasTimezone() && right.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            right.setTimeZoneZulu(true);
        }
        return (i = BaseDateTimeType.compareTimes(left, right, null)) == null ? null : Boolean.valueOf(i == 0);
    }

    private boolean couldBeTheSameTime(BaseDateTimeType theArg1, BaseDateTimeType theArg2) {
        long lowLeft = ((Date)theArg1.getValue()).getTime();
        long highLeft = ((Date)theArg1.getHighEdge().getValue()).getTime();
        if (!theArg1.hasTimezone()) {
            lowLeft -= 50400000L;
            highLeft += 50400000L;
        }
        long lowRight = ((Date)theArg2.getValue()).getTime();
        long highRight = ((Date)theArg2.getHighEdge().getValue()).getTime();
        if (!theArg2.hasTimezone()) {
            lowRight -= 50400000L;
            highRight += 50400000L;
        }
        if (highRight < lowLeft) {
            return false;
        }
        return highLeft >= lowRight;
    }

    private BaseDateTimeType getHighEdge() {
        BaseDateTimeType result = (BaseDateTimeType)this.copy();
        switch (this.getPrecision()) {
            case DAY: {
                result.add(5, 1);
                break;
            }
            case MILLI: {
                break;
            }
            case MINUTE: {
                result.add(12, 1);
                break;
            }
            case MONTH: {
                result.add(2, 1);
                break;
            }
            case SECOND: {
                result.add(13, 1);
                break;
            }
            case YEAR: {
                result.add(1, 1);
                break;
            }
        }
        return result;
    }

    boolean hasTimezoneIfRequired() {
        return this.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal() || this.getTimeZone() != null;
    }

    boolean hasTimezone() {
        return this.getTimeZone() != null;
    }

    public static Integer compareTimes(BaseDateTimeType left, BaseDateTimeType right, Integer def) {
        if (left.getYear() < right.getYear()) {
            return -1;
        }
        if (left.getYear() > right.getYear()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.YEAR && right.getPrecision() == TemporalPrecisionEnum.YEAR) {
            return 0;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.YEAR || right.getPrecision() == TemporalPrecisionEnum.YEAR) {
            return def;
        }
        if (left.getMonth() < right.getMonth()) {
            return -1;
        }
        if (left.getMonth() > right.getMonth()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MONTH && right.getPrecision() == TemporalPrecisionEnum.MONTH) {
            return 0;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MONTH || right.getPrecision() == TemporalPrecisionEnum.MONTH) {
            return def;
        }
        if (left.getDay() < right.getDay()) {
            return -1;
        }
        if (left.getDay() > right.getDay()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.DAY && right.getPrecision() == TemporalPrecisionEnum.DAY) {
            return 0;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.DAY || right.getPrecision() == TemporalPrecisionEnum.DAY) {
            return def;
        }
        if (left.getHour() < right.getHour()) {
            return -1;
        }
        if (left.getHour() > right.getHour()) {
            return 1;
        }
        if (left.getMinute() < right.getMinute()) {
            return -1;
        }
        if (left.getMinute() > right.getMinute()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MINUTE && right.getPrecision() == TemporalPrecisionEnum.MINUTE) {
            return 0;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MINUTE || right.getPrecision() == TemporalPrecisionEnum.MINUTE) {
            return def;
        }
        if (left.getSecond() < right.getSecond()) {
            return -1;
        }
        if (left.getSecond() > right.getSecond()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.SECOND && right.getPrecision() == TemporalPrecisionEnum.SECOND) {
            return 0;
        }
        if (left.getSecondsMilli() < right.getSecondsMilli()) {
            return -1;
        }
        if (left.getSecondsMilli() > right.getSecondsMilli()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String fpValue() {
        return "@" + this.primitiveValue();
    }

    private TimeZone getTimeZone(String offset) {
        return timezoneCache.computeIfAbsent(offset, TimeZone::getTimeZone);
    }
}

