/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.conformance;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.conformance.AdditionalBindingsRenderer;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.elementmodel.ObjectConverter;
import org.hl7.fhir.r4b.elementmodel.Property;
import org.hl7.fhir.r4b.formats.IParser;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.ExpressionNode;
import org.hl7.fhir.r4b.model.Extension;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.IntegerType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.renderers.TerminologyRenderer;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.r4b.terminologies.ValueSetExpander;
import org.hl7.fhir.r4b.utils.FHIRPathEngine;
import org.hl7.fhir.r4b.utils.PublicationHacker;
import org.hl7.fhir.r4b.utils.ToolingExtensions;
import org.hl7.fhir.r4b.utils.TranslatingUtilities;
import org.hl7.fhir.r4b.utils.XVerExtensionManager;
import org.hl7.fhir.r4b.utils.formats.CSVWriter;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.SchematronWriter;

public class ProfileUtilities
extends TranslatingUtilities {
    private static final int MAX_RECURSION_LIMIT = 10;
    private static final String ROW_COLOR_ERROR = "#ffcccc";
    private static final String ROW_COLOR_FATAL = "#ff9999";
    private static final String ROW_COLOR_WARNING = "#ffebcc";
    private static final String ROW_COLOR_HINT = "#ebf5ff";
    private static final String ROW_COLOR_NOT_MUST_SUPPORT = "#d6eaf8";
    public static final int STATUS_OK = 0;
    public static final int STATUS_HINT = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_FATAL = 4;
    public static final String DERIVATION_EQUALS = "derivation.equals";
    public static final String DERIVATION_POINTER = "derived.pointer";
    public static final String IS_DERIVED = "derived.fact";
    public static final String UD_ERROR_STATUS = "error-status";
    private static final String GENERATED_IN_SNAPSHOT = "profileutilities.snapshot.processed";
    private static final boolean COPY_BINDING_EXTENSIONS = false;
    private static final boolean DONT_DO_THIS = false;
    private final boolean ADD_REFERENCE_TO_TABLE = true;
    private boolean useTableForFixedValues = true;
    private boolean debug;
    private final IWorkerContext context;
    private FHIRPathEngine fpe;
    private List<ValidationMessage> messages;
    private List<String> snapshotStack = new ArrayList<String>();
    private ProfileKnowledgeProvider pkp;
    private boolean igmode;
    private boolean exception;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions();
    private boolean newSlicingProcessing;
    private String defWebRoot;
    private boolean autoFixSliceNames;
    private XVerExtensionManager xver;
    private boolean wantFixDifferentialFirstElementType;
    private Set<String> masterSourceFileNames;
    private Map<ElementDefinition, List<ElementDefinition>> childMapCache = new HashMap<ElementDefinition, List<ElementDefinition>>();
    private static final int AGG_NONE = 0;
    private static final int AGG_IND = 1;
    private static final int AGG_GR = 2;
    private static final boolean TABLE_FORMAT_FOR_FIXED_VALUES = false;

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp, FHIRPathEngine fpe) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
        this.fpe = fpe;
        if (context != null && this.fpe == null) {
            this.fpe = new FHIRPathEngine(context, this);
        }
    }

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
        if (context != null) {
            this.fpe = new FHIRPathEngine(context, this);
        }
    }

    public boolean isIgmode() {
        return this.igmode;
    }

    public void setIgmode(boolean igmode) {
        this.igmode = igmode;
    }

    public boolean isWantFixDifferentialFirstElementType() {
        return this.wantFixDifferentialFirstElementType;
    }

    public void setWantFixDifferentialFirstElementType(boolean wantFixDifferentialFirstElementType) {
        this.wantFixDifferentialFirstElementType = wantFixDifferentialFirstElementType;
    }

    public boolean isAutoFixSliceNames() {
        return this.autoFixSliceNames;
    }

    public ProfileUtilities setAutoFixSliceNames(boolean autoFixSliceNames) {
        this.autoFixSliceNames = autoFixSliceNames;
        return this;
    }

    public List<ElementDefinition> getChildMap(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (this.childMapCache.containsKey(element)) {
            return this.childMapCache.get(element);
        }
        if (element.getContentReference() != null) {
            List<ElementDefinition> list = null;
            String id = null;
            if (element.getContentReference().startsWith("#")) {
                id = element.getContentReference().substring(1);
                list = profile.getSnapshot().getElement();
            } else if (element.getContentReference().contains("#")) {
                String ref = element.getContentReference();
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ref.substring(0, ref.indexOf("#")));
                if (sd == null) {
                    throw new DefinitionException("unable to process contentReference '" + element.getContentReference() + "' on element '" + element.getId() + "'");
                }
                list = sd.getSnapshot().getElement();
                id = ref.substring(ref.indexOf("#") + 1);
            } else {
                throw new DefinitionException("unable to process contentReference '" + element.getContentReference() + "' on element '" + element.getId() + "'");
            }
            for (ElementDefinition e2 : list) {
                if (!id.equals(e2.getId())) continue;
                return this.getChildMap(profile, e2);
            }
            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_name_reference__at_path_", element.getContentReference(), element.getPath()));
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (e = elements.get(index)).getPath().startsWith(path + "."); ++index) {
            if (e.getPath().substring(path.length() + 1).contains(".")) continue;
            res.add(e);
        }
        this.childMapCache.put(element, res);
        return res;
    }

    public List<ElementDefinition> getSliceList(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (!element.hasSlicing()) {
            throw new Error(this.context.formatMessage("getSliceList_should_only_be_called_when_the_element_has_slicing", new Object[0]));
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && ((e = elements.get(index)).getPath().startsWith(path + ".") || e.getPath().equals(path)); ++index) {
            if (!e.getPath().equals(element.getPath())) continue;
            res.add(e);
        }
        return res;
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id) {
        return this.getChildList(profile, path, id, false);
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id, boolean diff) {
        return this.getChildList(profile, path, id, diff, false);
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id, boolean diff, boolean refs) {
        boolean capturing;
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        boolean bl = capturing = id == null;
        if (id == null && !path.contains(".")) {
            capturing = true;
        }
        List<ElementDefinition> list = diff ? profile.getDifferential().getElement() : profile.getSnapshot().getElement();
        for (ElementDefinition e : list) {
            String tail;
            if (e == null) {
                throw new Error(this.context.formatMessage("element__null_", profile.getUrl()));
            }
            if (e.getId() == null) {
                throw new Error(this.context.formatMessage("element_id__null__on_", e.toString(), profile.getUrl()));
            }
            if (!capturing && id != null && e.getId().equals(id)) {
                capturing = true;
            }
            if (capturing && e.hasId() && id != null && !e.getId().equals(id) && e.getPath().equals(path)) break;
            if (!capturing) continue;
            String p = e.getPath();
            if (refs && !Utilities.noString((String)e.getContentReference()) && path.startsWith(p)) {
                if (path.length() > p.length()) {
                    return this.getChildList(profile, e.getContentReference() + "." + path.substring(p.length() + 1), null, diff);
                }
                if (e.getContentReference().startsWith("#")) {
                    return this.getChildList(profile, e.getContentReference().substring(1), null, diff);
                }
                if (e.getContentReference().contains("#")) {
                    String url = e.getContentReference().substring(0, e.getContentReference().indexOf("#"));
                    StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
                    if (sd == null) {
                        throw new DefinitionException("Unable to find Structure " + url);
                    }
                    return this.getChildList(sd, e.getContentReference().substring(e.getContentReference().indexOf("#") + 1), null, diff);
                }
                return this.getChildList(profile, e.getContentReference(), null, diff);
            }
            if (!p.startsWith(path + ".") || p.equals(path) || (tail = p.substring(path.length() + 1)).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element, boolean diff, boolean refs) {
        return this.getChildList(structure, element.getPath(), element.getId(), diff, refs);
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element, boolean diff) {
        return this.getChildList(structure, element.getPath(), element.getId(), diff);
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element) {
        if (element.hasContentReference()) {
            ElementDefinition target = element;
            for (ElementDefinition t : structure.getSnapshot().getElement()) {
                if (!t.getId().equals(element.getContentReference().substring(1))) continue;
                target = t;
            }
            return this.getChildList(structure, target.getPath(), target.getId(), false);
        }
        return this.getChildList(structure, element.getPath(), element.getId(), false);
    }

    public void updateMaps(StructureDefinition base, StructureDefinition derived) throws DefinitionException {
        if (base == null) {
            throw new DefinitionException(this.context.formatMessage("no_base_profile_provided", new Object[0]));
        }
        if (derived == null) {
            throw new DefinitionException(this.context.formatMessage("no_derived_structure_provided", new Object[0]));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent baseMap : base.getMapping()) {
            boolean found = false;
            for (StructureDefinition.StructureDefinitionMappingComponent derivedMap : derived.getMapping()) {
                if (derivedMap.getUri() == null || !derivedMap.getUri().equals(baseMap.getUri())) continue;
                found = true;
                break;
            }
            if (found) continue;
            derived.getMapping().add(baseMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSnapshot(StructureDefinition base, StructureDefinition derived, String url, String webUrl, String profileName) throws DefinitionException, FHIRException {
        if (base == null) {
            throw new DefinitionException(this.context.formatMessage("no_base_profile_provided", new Object[0]));
        }
        if (derived == null) {
            throw new DefinitionException(this.context.formatMessage("no_derived_structure_provided", new Object[0]));
        }
        this.checkNotGenerating(base, "Base for generating a snapshot for the profile " + derived.getUrl());
        this.checkNotGenerating(derived, "Focus for generating a snapshot");
        if (!base.hasType()) {
            throw new DefinitionException(this.context.formatMessage("Base_profile__has_no_type", base.getUrl()));
        }
        if (!derived.hasType()) {
            throw new DefinitionException(this.context.formatMessage("Derived_profile__has_no_type", derived.getUrl()));
        }
        if (!derived.hasDerivation()) {
            throw new DefinitionException(this.context.formatMessage("Derived_profile__has_no_derivation_value_and_so_cant_be_processed", derived.getUrl()));
        }
        if (!base.getType().equals(derived.getType()) && derived.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new DefinitionException(this.context.formatMessage("Base__Derived_profiles_have_different_types____vs___", base.getUrl(), base.getType(), derived.getUrl(), derived.getType()));
        }
        this.fixTypeOfResourceId(base);
        if (this.snapshotStack.contains(derived.getUrl())) {
            throw new DefinitionException(this.context.formatMessage("Circular_snapshot_references_detected_cannot_generate_snapshot_stack__", this.snapshotStack.toString()));
        }
        derived.setUserData("profileutils.snapshot.generating", true);
        this.snapshotStack.add(derived.getUrl());
        try {
            if (!Utilities.noString((String)webUrl) && !webUrl.endsWith("/")) {
                webUrl = webUrl + '/';
            }
            if (this.defWebRoot == null) {
                this.defWebRoot = webUrl;
            }
            derived.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
            try {
                this.checkDifferential(derived.getDifferential().getElement(), this.typeName(derived.getType()), derived.getUrl());
                this.checkDifferentialBaseType(derived);
                int baseCursor = 0;
                int diffCursor = 0;
                for (ElementDefinition e : derived.getDifferential().getElement()) {
                    e.clearUserData(GENERATED_IN_SNAPSHOT);
                }
                StructureDefinition.StructureDefinitionDifferentialComponent diff = this.cloneDiff(derived.getDifferential());
                StructureDefinition.StructureDefinitionSnapshotComponent baseSnapshot = base.getSnapshot();
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    Iterator<ElementDefinition> derivedType = derived.getType();
                    if (StructureDefinition.StructureDefinitionKind.LOGICAL.equals((Object)derived.getKind()) && derived.getType().contains("/")) {
                        derivedType = ((String)((Object)derivedType)).substring(((String)((Object)derivedType)).lastIndexOf("/") + 1);
                    }
                    baseSnapshot = this.cloneSnapshot(baseSnapshot, base.getType(), (String)((Object)derivedType));
                }
                this.processPaths("", derived.getSnapshot(), baseSnapshot, diff, baseCursor, diffCursor, baseSnapshot.getElement().size() - 1, derived.getDifferential().hasElement() ? derived.getDifferential().getElement().size() - 1 : -1, url, webUrl, derived.present(), null, null, false, base.getUrl(), null, false, null, null, new ArrayList<ElementRedirection>(), base);
                this.checkGroupConstraints(derived);
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    for (ElementDefinition e : diff.getElement()) {
                        if (e.hasUserData(GENERATED_IN_SNAPSHOT)) continue;
                        ElementDefinition outcome = this.updateURLs(url, webUrl, e.copy());
                        e.setUserData(GENERATED_IN_SNAPSHOT, outcome);
                        derived.getSnapshot().addElement(outcome);
                    }
                }
                if (derived.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL && !derived.getSnapshot().getElementFirstRep().getType().isEmpty()) {
                    throw new Error(this.context.formatMessage("type_on_first_snapshot_element_for__in__from_", derived.getSnapshot().getElementFirstRep().getPath(), derived.getUrl(), base.getUrl()));
                }
                this.updateMaps(base, derived);
                this.setIds(derived, false);
                if (this.debug) {
                    System.out.println("Differential: ");
                    for (ElementDefinition ed : derived.getDifferential().getElement()) {
                        System.out.println("  " + ed.getId() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                    }
                    System.out.println("Snapshot: ");
                    for (ElementDefinition ed : derived.getSnapshot().getElement()) {
                        System.out.println("  " + ed.getId() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                    }
                }
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                int ce = 0;
                for (ElementDefinition elementDefinition : diff.getElement()) {
                    if (!elementDefinition.hasUserData("diff-source")) {
                        throw new Error(this.context.formatMessage("Unxpected_internal_condition__no_source_on_diff_element", new Object[0]));
                    }
                    if (elementDefinition.hasUserData(DERIVATION_EQUALS)) {
                        ((Base)elementDefinition.getUserData("diff-source")).setUserData(DERIVATION_EQUALS, elementDefinition.getUserData(DERIVATION_EQUALS));
                    }
                    if (elementDefinition.hasUserData(DERIVATION_POINTER)) {
                        ((Base)elementDefinition.getUserData("diff-source")).setUserData(DERIVATION_POINTER, elementDefinition.getUserData(DERIVATION_POINTER));
                    }
                    if (elementDefinition.hasUserData(GENERATED_IN_SNAPSHOT)) continue;
                    b.append(elementDefinition.hasId() ? "id: " + elementDefinition.getId() : "path: " + elementDefinition.getPath());
                    ++ce;
                    if (!elementDefinition.hasId()) continue;
                    String msg = "No match found in the generated snapshot: check that the path and definitions are legal in the differential (including order)";
                    this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), msg, ValidationMessage.IssueSeverity.ERROR));
                }
                if (!Utilities.noString((String)b.toString())) {
                    String msg = "The profile " + derived.getUrl() + " has " + ce + " " + Utilities.pluralize((String)"element", (int)ce) + " in the differential (" + b.toString() + ") that don't have a matching element in the snapshot: check that the path and definitions are legal in the differential (including order)";
                    System.out.println("Error in snapshot generation: " + msg);
                    if (!this.debug) {
                        System.out.println("Differential: ");
                        for (ElementDefinition ed : derived.getDifferential().getElement()) {
                            System.out.println("  " + ed.getId() + " = " + ed.getPath() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                        }
                        System.out.println("Snapshot: ");
                        for (ElementDefinition ed : derived.getSnapshot().getElement()) {
                            System.out.println("  " + ed.getId() + " = " + ed.getPath() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                        }
                    }
                    if (this.exception) {
                        throw new DefinitionException(msg);
                    }
                    this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url, msg, ValidationMessage.IssueSeverity.ERROR));
                }
                for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                    for (ElementDefinition.ElementDefinitionMappingComponent mm : elementDefinition.getMapping()) {
                        if (!mm.hasMap()) continue;
                        mm.setMap(mm.getMap().trim());
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent s : elementDefinition.getConstraint()) {
                        String ref;
                        if (!s.hasSource() || Utilities.isAbsoluteUrl((String)(ref = s.getSource()))) continue;
                        if (ref.contains(".")) {
                            s.setSource("http://hl7.org/fhir/StructureDefinition/" + ref.substring(0, ref.indexOf(".")) + "#" + ref);
                            continue;
                        }
                        s.setSource("http://hl7.org/fhir/StructureDefinition/" + ref);
                    }
                }
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                        if (elementDefinition.hasBase()) continue;
                        elementDefinition.getBase().setPath(elementDefinition.getPath()).setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax());
                    }
                }
                for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                    for (ElementDefinition.TypeRefComponent t : elementDefinition.getType()) {
                        for (UriType uriType : t.getProfile()) {
                            boolean ok;
                            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue());
                            if (sd == null && this.xver != null && this.xver.matchingUrl((String)uriType.getValue()) && this.xver.status((String)uriType.getValue()) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                                sd = this.xver.makeDefinition((String)uriType.getValue());
                            }
                            if (sd == null) {
                                if (this.messages == null) continue;
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), "The type of profile " + (String)uriType.getValue() + " cannot be checked as the profile is not known", ValidationMessage.IssueSeverity.WARNING));
                                continue;
                            }
                            String wt = t.getWorkingCode();
                            if (elementDefinition.getPath().equals("Bundle.entry.response.outcome")) {
                                wt = "OperationOutcome";
                            }
                            if (sd.getType().equals(wt) || (ok = this.isCompatibleType(wt, sd))) continue;
                            String smsg = "The profile " + (String)uriType.getValue() + " has type " + sd.getType() + " which is not consistent with the stated type " + wt;
                            if (this.exception) {
                                throw new DefinitionException(smsg);
                            }
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), smsg, ValidationMessage.IssueSeverity.ERROR));
                        }
                    }
                }
            }
            catch (Exception e) {
                derived.setSnapshot(null);
                derived.clearUserData("profileutils.snapshot.generating");
                throw e;
            }
        }
        finally {
            derived.clearUserData("profileutils.snapshot.generating");
            this.snapshotStack.remove(derived.getUrl());
        }
    }

    private void fixTypeOfResourceId(StructureDefinition base) {
        if (base.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE && (base.getFhirVersion() == null || VersionUtilities.isR4Plus((String)base.getFhirVersion().toCode()))) {
            this.fixTypeOfResourceId(base.getSnapshot().getElement());
            this.fixTypeOfResourceId(base.getDifferential().getElement());
        }
    }

    private void fixTypeOfResourceId(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.hasBase() || !ed.getBase().getPath().equals("Resource.id")) continue;
            for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                tr.setCode("http://hl7.org/fhirpath/System.String");
                tr.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
                ToolingExtensions.addUrlExtension(tr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type", "id");
            }
        }
    }

    public void checkDifferentialBaseType(StructureDefinition derived) throws Error {
        if (derived.hasDifferential() && !derived.getDifferential().getElementFirstRep().getPath().contains(".") && !derived.getDifferential().getElementFirstRep().getType().isEmpty()) {
            if (this.wantFixDifferentialFirstElementType && this.typeMatchesAncestor(derived.getDifferential().getElementFirstRep().getType(), derived.getBaseDefinition())) {
                derived.getDifferential().getElementFirstRep().getType().clear();
            } else if (derived.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
                throw new Error(this.context.formatMessage("type_on_first_differential_element", new Object[0]));
            }
        }
    }

    private boolean typeMatchesAncestor(List<ElementDefinition.TypeRefComponent> type, String baseDefinition) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, baseDefinition);
        return sd != null && type.size() == 1 && sd.getType().equals(type.get(0).getCode());
    }

    private String typeName(String type) {
        if (Utilities.isAbsoluteUrl((String)type)) {
            return type.substring(type.lastIndexOf("/") + 1);
        }
        return type;
    }

    private void checkGroupConstraints(StructureDefinition derived) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        for (ElementDefinition element : derived.getSnapshot().getElement()) {
            if (toRemove.contains(element) || element.hasSlicing() || "0".equals(element.getMax())) continue;
            this.checkForChildrenInGroup(derived, toRemove, element);
        }
        derived.getSnapshot().getElement().removeAll(toRemove);
    }

    public void checkForChildrenInGroup(StructureDefinition derived, List<ElementDefinition> toRemove, ElementDefinition element) throws Error {
        List<ElementDefinition> children = this.getChildren(derived, element);
        List<ElementChoiceGroup> groups = this.readChoices(element, children);
        for (ElementChoiceGroup group : groups) {
            String name;
            String mandated = null;
            HashSet<String> names = new HashSet<String>();
            for (ElementDefinition ed : children) {
                name = this.tail(ed.getPath());
                if (names.contains(name)) {
                    throw new Error("huh?");
                }
                names.add(name);
                if (!group.getElements().contains(name) || ed.getMin() != 1) continue;
                if (mandated == null) {
                    mandated = name;
                    continue;
                }
                throw new Error("Error: there are two mandatory elements in " + derived.getUrl() + " when there can only be one: " + mandated + " and " + name);
            }
            if (mandated == null) continue;
            for (ElementDefinition ed : children) {
                name = this.tail(ed.getPath());
                if (!group.getElements().contains(name) || mandated.equals(name)) continue;
                ed.setMax("0");
                this.addAllChildren(derived, ed, toRemove);
            }
        }
    }

    private List<ElementDefinition> getChildren(StructureDefinition derived, ElementDefinition element) {
        ElementDefinition e;
        String p;
        List<ElementDefinition> elements = derived.getSnapshot().getElement();
        String path = element.getPath() + ".";
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (p = (e = elements.get(index)).getPath()).startsWith(path) && !e.hasSliceName(); ++index) {
            if (p.substring(path.length()).contains(".")) continue;
            list.add(e);
        }
        return list;
    }

    private void addAllChildren(StructureDefinition derived, ElementDefinition element, List<ElementDefinition> toRemove) {
        List<ElementDefinition> children = this.getChildList(derived, element);
        for (ElementDefinition child : children) {
            toRemove.add(child);
            this.addAllChildren(derived, child, toRemove);
        }
    }

    private void checkDifferential(List<ElementDefinition> elements, String type, String url) {
        boolean first = true;
        for (ElementDefinition ed : elements) {
            String[] pl;
            if (!ed.hasPath()) {
                throw new FHIRException(this.context.formatMessage("No_path_on_element_in_differential_in_", url));
            }
            String p = ed.getPath();
            if (p == null) {
                throw new FHIRException(this.context.formatMessage("No_path_value_on_element_in_differential_in_", url));
            }
            if (!(first && type.equals(p) || p.startsWith(type + "."))) {
                throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__must_start_with_", p, url, type, first ? " (or be '" + type + "')" : ""));
            }
            if (!p.contains(".")) continue;
            for (String pp : pl = p.split("\\.")) {
                if (pp.length() < 1) {
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__name_portion_mising_", p, url));
                }
                if (pp.length() > 64) {
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__name_portion_exceeds_64_chars_in_length", p, url));
                }
                for (char ch : pp.toCharArray()) {
                    if (Character.isWhitespace(ch)) {
                        throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__no_unicode_whitespace", p, url));
                    }
                    if (Utilities.existsInList((int)ch, (int[])new int[]{44, 58, 59, 39, 34, 47, 124, 63, 33, 64, 35, 36, 37, 94, 38, 42, 40, 41, 123, 125})) {
                        throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_character_", p, url, Character.valueOf(ch)));
                    }
                    if (ch >= ' ' && ch <= 'z') continue;
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_character_", p, url, Character.valueOf(ch)));
                }
                if (!pp.contains("[") && !pp.contains("]") || pp.endsWith("[x]") && !pp.substring(0, pp.length() - 3).contains("[") && !pp.substring(0, pp.length() - 3).contains("]")) continue;
                throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_characters_", p, url));
            }
        }
    }

    private boolean isCompatibleType(String base, StructureDefinition sdt) {
        StructureDefinition sdb = this.context.fetchTypeDefinition(base);
        if (sdb.getType().equals(sdt.getType())) {
            return true;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(sdt.getType());
        while (sd != null) {
            if (sd.getType().equals(sdb.getType())) {
                return true;
            }
            if (sd.getUrl().equals(sdb.getUrl())) {
                return true;
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return false;
    }

    private StructureDefinition.StructureDefinitionDifferentialComponent cloneDiff(StructureDefinition.StructureDefinitionDifferentialComponent source) {
        StructureDefinition.StructureDefinitionDifferentialComponent diff = new StructureDefinition.StructureDefinitionDifferentialComponent();
        for (ElementDefinition sed : source.getElement()) {
            ElementDefinition ted = sed.copy();
            diff.getElement().add(ted);
            ted.setUserData("diff-source", sed);
        }
        return diff;
    }

    private StructureDefinition.StructureDefinitionSnapshotComponent cloneSnapshot(StructureDefinition.StructureDefinitionSnapshotComponent source, String baseType, String derivedType) {
        StructureDefinition.StructureDefinitionSnapshotComponent diff = new StructureDefinition.StructureDefinitionSnapshotComponent();
        for (ElementDefinition sed : source.getElement()) {
            ElementDefinition ted = sed.copy();
            ted.setId(ted.getId().replaceFirst(baseType, derivedType));
            ted.setPath(ted.getPath().replaceFirst(baseType, derivedType));
            diff.getElement().add(ted);
        }
        return diff;
    }

    private String constraintSummary(ElementDefinition ed) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (ed.hasPattern()) {
            b.append("pattern=" + ed.getPattern().fhirType());
        }
        if (ed.hasFixed()) {
            b.append("fixed=" + ed.getFixed().fhirType());
        }
        if (ed.hasConstraint()) {
            b.append("constraints=" + ed.getConstraint().size());
        }
        return b.toString();
    }

    private String sliceSummary(ElementDefinition ed) {
        if (!ed.hasSlicing() && !ed.hasSliceName()) {
            return "";
        }
        if (ed.hasSliceName()) {
            return " (slicename = " + ed.getSliceName() + ")";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : ed.getSlicing().getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(d.getPath());
        }
        return " (slicing by " + b.toString() + ")";
    }

    private String typeSummary(ElementDefinition ed) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(tr.getWorkingCode());
        }
        return b.toString();
    }

    private String typeSummaryWithProfile(ElementDefinition ed) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(tr.getWorkingCode());
            if (!tr.hasProfile()) continue;
            b.append("(");
            b.append(tr.getProfile());
            b.append(")");
        }
        return b.toString();
    }

    private boolean findMatchingElement(String id, List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (ed.getId().equals(id)) {
                return true;
            }
            if (!id.endsWith("[x]") || !ed.getId().startsWith(id.substring(0, id.length() - 3)) || ed.getId().substring(id.length() - 3).contains(".")) continue;
            return true;
        }
        return false;
    }

    private ElementDefinition processPaths(String indent, StructureDefinition.StructureDefinitionSnapshotComponent result, StructureDefinition.StructureDefinitionSnapshotComponent base, StructureDefinition.StructureDefinitionDifferentialComponent differential, int baseCursor, int diffCursor, int baseLimit, int diffLimit, String url, String webUrl, String profileName, String contextPathSrc, String contextPathDst, boolean trimDifferential, String contextName, String resultPathBase, boolean slicingDone, ElementDefinition slicer, String typeSlicingPath, List<ElementRedirection> redirector, StructureDefinition srcSD) throws DefinitionException, FHIRException {
        if (this.debug) {
            System.out.println(indent + "PP @ " + resultPathBase + " / " + contextPathSrc + " : base = " + baseCursor + " to " + baseLimit + ", diff = " + diffCursor + " to " + diffLimit + " (slicing = " + slicingDone + ", k " + (redirector == null ? "null" : redirector.toString()) + ")");
        }
        ElementDefinition res = null;
        ArrayList<TypeSlice> typeList = new ArrayList<TypeSlice>();
        while (baseCursor <= baseLimit) {
            boolean isExtension;
            ElementDefinition currentBase = base.getElement().get(baseCursor);
            String cpath = this.fixedPathSource(contextPathSrc, currentBase.getPath(), redirector);
            if (this.debug) {
                System.out.println(indent + " - " + cpath + ": base = " + baseCursor + " (" + this.descED(base.getElement(), baseCursor) + ") to " + baseLimit + " (" + this.descED(base.getElement(), baseLimit) + "), diff = " + diffCursor + " (" + this.descED(differential.getElement(), diffCursor) + ") to " + diffLimit + " (" + this.descED(differential.getElement(), diffLimit) + ") (slicingDone = " + slicingDone + ") (diffpath= " + (differential.getElement().size() > diffCursor ? differential.getElement().get(diffCursor).getPath() : "n/a") + ")");
            }
            List<ElementDefinition> diffMatches = this.getDiffMatches(differential, cpath, diffCursor, diffLimit, profileName);
            if (!currentBase.hasSlicing() || cpath.equals(typeSlicingPath)) {
                ElementDefinition slicerElement;
                if (diffMatches.isEmpty()) {
                    ElementDefinition outcome = this.updateURLs(url, webUrl, currentBase.copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    this.updateFromBase(outcome, currentBase);
                    this.updateConstraintSources(outcome, srcSD.getUrl());
                    this.markDerived(outcome);
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path__outcomegetPath___resultPathBase__", outcome.getPath(), resultPathBase));
                    }
                    result.getElement().add(outcome);
                    if (this.hasInnerDiffMatches(differential, cpath, diffCursor, diffLimit, base.getElement(), true)) {
                        if (this.baseHasChildren(base, currentBase)) {
                            this.processPaths(indent + "  ", result, base, differential, baseCursor + 1, diffCursor, baseLimit, diffLimit, url, webUrl, profileName, contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                            baseCursor = this.indexOfFirstNonChild(base, currentBase, baseCursor + 1, baseLimit);
                        } else {
                            if (outcome.getType().size() == 0 && !outcome.hasContentReference()) {
                                throw new DefinitionException(this.context.formatMessage("_has_no_children__and_no_types_in_profile_", cpath, differential.getElement().get(diffCursor).getPath(), profileName));
                            }
                            boolean nonExtension = false;
                            if (outcome.getType().size() > 1) {
                                for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                                    if (t.getWorkingCode().equals("Reference")) continue;
                                    for (ElementDefinition ed : diffMatches) {
                                        if (ed == diffMatches.get(0) || ed.getPath().endsWith(".extension")) continue;
                                        nonExtension = true;
                                    }
                                }
                            }
                            int start = diffCursor;
                            while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), cpath + ".")) {
                                ++diffCursor;
                            }
                            if (nonExtension) {
                                throw new DefinitionException(this.context.formatMessage("_has_children__and_multiple_types__in_profile_", cpath, differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
                            }
                            if (outcome.hasContentReference()) {
                                int nbc;
                                int nbl;
                                ElementDefinitionResolution tgt = this.getElementById(srcSD, base.getElement(), outcome.getContentReference());
                                if (tgt == null) {
                                    throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_reference_to_", outcome.getContentReference()));
                                }
                                this.replaceFromContentReference(outcome, tgt.getElement());
                                if (tgt.getSource() != srcSD) {
                                    base = tgt.getSource().getSnapshot();
                                    for (nbl = nbc = base.getElement().indexOf(tgt.getElement()) + 1; nbl < base.getElement().size() && base.getElement().get(nbl).getPath().startsWith(tgt.getElement().getPath() + "."); ++nbl) {
                                    }
                                    this.processPaths(indent + "  ", result, base, differential, nbc, start - 1, nbl - 1, diffCursor - 1, url, webUrl, profileName, tgt.getElement().getPath(), diffMatches.get(0).getPath(), trimDifferential, contextName, resultPathBase, false, null, null, this.redirectorStack(redirector, outcome, cpath), tgt.getSource());
                                } else {
                                    for (nbl = nbc = base.getElement().indexOf(tgt.getElement()) + 1; nbl < base.getElement().size() && base.getElement().get(nbl).getPath().startsWith(tgt.getElement().getPath() + "."); ++nbl) {
                                    }
                                    System.out.println("Test!");
                                    this.processPaths(indent + "  ", result, base, differential, nbc, start, nbl - 1, diffCursor - 1, url, webUrl, profileName, tgt.getElement().getPath(), outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, this.redirectorStack(redirector, outcome, cpath), srcSD);
                                }
                            } else {
                                StructureDefinition dt;
                                StructureDefinition structureDefinition = dt = outcome.getType().size() > 1 ? this.context.fetchTypeDefinition("Element") : this.getProfileForDataType(outcome.getType().get(0), webUrl);
                                if (dt == null) {
                                    throw new DefinitionException(this.context.formatMessage("Unknown_type__at_", outcome.getType().get(0), cpath));
                                }
                                contextName = dt.getUrl();
                                if (redirector.isEmpty()) {
                                    this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, this.getWebUrl(dt, webUrl, indent), profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                                } else {
                                    this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, this.getWebUrl(dt, webUrl, indent), profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, this.redirectorStack(redirector, currentBase, cpath), srcSD);
                                }
                            }
                        }
                    }
                    ++baseCursor;
                    continue;
                }
                if (!(diffMatches.size() != 1 || !slicingDone && (this.isImplicitSlicing(diffMatches.get(0), cpath) || diffMatches.get(0).hasSlicing() || this.isExtension(diffMatches.get(0)) && diffMatches.get(0).hasSliceName()))) {
                    StructureDefinition dt;
                    ElementDefinition template = null;
                    if (diffMatches.get(0).hasType() && "Reference".equals(diffMatches.get(0).getType().get(0).getWorkingCode()) && !this.isValidType(diffMatches.get(0).getType().get(0), currentBase)) {
                        throw new DefinitionException(this.context.formatMessage("VALIDATION_VAL_ILLEGAL_TYPE_CONSTRAINT", url, diffMatches.get(0).getPath(), diffMatches.get(0).getType().get(0), currentBase.typeSummary()));
                    }
                    String id = diffMatches.get(0).getId();
                    String lid = this.tail(id);
                    if (lid.contains("/")) {
                        this.generateIds(result.getElement(), url, srcSD.getType());
                        String baseId = id.substring(0, id.length() - lid.length()) + lid.substring(0, lid.indexOf("/"));
                        template = this.getById(result.getElement(), baseId);
                    } else if (diffMatches.get(0).hasType() && diffMatches.get(0).getType().size() == 1 && diffMatches.get(0).getType().get(0).hasProfile() && !"Reference".equals(diffMatches.get(0).getType().get(0).getWorkingCode())) {
                        CanonicalType p = diffMatches.get(0).getType().get(0).getProfile().get(0);
                        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)p.getValue());
                        if (sd == null && this.xver != null && this.xver.matchingUrl((String)p.getValue())) {
                            switch (this.xver.status((String)p.getValue())) {
                                case BadVersion: {
                                    throw new FHIRException("Reference to invalid version in extension url " + (String)p.getValue());
                                }
                                case Invalid: {
                                    throw new FHIRException("Reference to invalid extension " + (String)p.getValue());
                                }
                                case Unknown: {
                                    throw new FHIRException("Reference to unknown extension " + (String)p.getValue());
                                }
                                case Valid: {
                                    sd = this.xver.makeDefinition((String)p.getValue());
                                    this.generateSnapshot(this.context.fetchTypeDefinition("Extension"), sd, sd.getUrl(), webUrl, sd.getName());
                                }
                            }
                        }
                        if (sd != null) {
                            ElementDefinition src;
                            if (!this.isMatchingType(sd, diffMatches.get(0).getType(), p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"))) {
                                throw new DefinitionException(this.context.formatMessage("Validation_VAL_Profile_WrongType2", sd.getUrl(), diffMatches.get(0).getPath(), sd.getType(), p.getValue(), diffMatches.get(0).getType().get(0).getWorkingCode()));
                            }
                            if (this.isGenerating(sd)) {
                                if (sd.getSnapshot().getElementFirstRep().isEmpty()) {
                                    throw new FHIRException(this.context.formatMessage("Attempt_to_use_a_snapshot_on_profile__as__before_it_is_generated", sd.getUrl(), "Source for first element"));
                                }
                            } else if (!sd.hasSnapshot()) {
                                StructureDefinition sdb = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                                if (sdb == null) {
                                    throw new DefinitionException(this.context.formatMessage("Unable_to_find_base__for_", sd.getBaseDefinition(), sd.getUrl()));
                                }
                                this.checkNotGenerating(sdb, "an extension base");
                                this.generateSnapshot(sdb, sd, sd.getUrl(), sdb.hasUserData("path") ? Utilities.extractBaseUrl((String)sdb.getUserString("path")) : webUrl, sd.getName());
                            }
                            if (p.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                                src = null;
                                String eid = p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element");
                                for (ElementDefinition t : sd.getSnapshot().getElement()) {
                                    if (!eid.equals(t.getId())) continue;
                                    src = t;
                                }
                                if (src == null) {
                                    throw new DefinitionException(this.context.formatMessage("Unable_to_find_element__in_", eid, p.getValue()));
                                }
                            } else {
                                src = sd.getSnapshot().getElement().get(0);
                            }
                            template = src.copy().setPath(currentBase.getPath());
                            template.setSliceName(null);
                            if (!"Extension".equals(diffMatches.get(0).getType().get(0).getCode())) {
                                template.setMin(currentBase.getMin());
                                template.setMax(currentBase.getMax());
                            }
                        }
                    }
                    template = template == null ? currentBase.copy() : this.fillOutFromBase(template, currentBase);
                    ElementDefinition outcome = this.updateURLs(url, webUrl, template);
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    if (res == null) {
                        res = outcome;
                    }
                    this.updateFromBase(outcome, currentBase);
                    if (diffMatches.get(0).hasSliceName()) {
                        outcome.setSliceName(diffMatches.get(0).getSliceName());
                        if (!(diffMatches.get(0).hasMin() || diffMatches.size() <= 1 && slicer != null && slicer.getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED || currentBase.hasSliceName() || cpath.endsWith("xtension.value[x]"))) {
                            outcome.setMin(0);
                        }
                    }
                    this.updateFromDefinition(outcome, diffMatches.get(0), profileName, trimDifferential, url, srcSD);
                    this.removeStatusExtensions(outcome);
                    outcome.setSlicing(null);
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                    }
                    result.getElement().add(outcome);
                    diffCursor = differential.getElement().indexOf(diffMatches.get(0)) + 1;
                    if (diffLimit < diffCursor || !outcome.getPath().contains(".") || !this.isDataType(outcome.getType()) && !this.isBaseResource(outcome.getType()) && !outcome.hasContentReference() || !this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".") || this.baseWalksInto(base.getElement(), ++baseCursor)) continue;
                    if (outcome.getType().size() > 1) {
                        Object ntr;
                        if (outcome.getPath().endsWith("[x]") && !diffMatches.get(0).getPath().endsWith("[x]")) {
                            String en = this.tail(outcome.getPath());
                            String tn = this.tail(diffMatches.get(0).getPath());
                            String t = tn.substring(en.length() - 3);
                            if (this.isPrimitive(Utilities.uncapitalize((String)t))) {
                                t = Utilities.uncapitalize((String)t);
                            }
                            if ((ntr = this.getByTypeName(outcome.getType(), t)).isEmpty()) {
                                ntr.add(new ElementDefinition.TypeRefComponent().setCode(t));
                            }
                            outcome.getType().clear();
                            outcome.getType().addAll((Collection<ElementDefinition.TypeRefComponent>)ntr);
                        }
                        if (outcome.getType().size() > 1) {
                            for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                                if (t.getCode().equals("Reference")) continue;
                                boolean nonExtension = false;
                                ntr = diffMatches.iterator();
                                while (ntr.hasNext()) {
                                    ElementDefinition ed = ntr.next();
                                    if (ed == diffMatches.get(0) || ed.getPath().endsWith(".extension")) continue;
                                    nonExtension = true;
                                }
                                if (!nonExtension) continue;
                                throw new DefinitionException(this.context.formatMessage("_has_children__and_multiple_types__in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
                            }
                        }
                    }
                    int start = diffCursor;
                    while (diffCursor <= diffLimit && differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                        ++diffCursor;
                    }
                    if (outcome.hasContentReference()) {
                        int nbc;
                        int nbl;
                        ElementDefinitionResolution tgt = this.getElementById(srcSD, base.getElement(), outcome.getContentReference());
                        if (tgt == null) {
                            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_reference_to_", outcome.getContentReference()));
                        }
                        this.replaceFromContentReference(outcome, tgt.getElement());
                        if (tgt.getSource() != srcSD) {
                            base = tgt.getSource().getSnapshot();
                            for (nbl = nbc = base.getElement().indexOf(tgt.getElement()) + 1; nbl < base.getElement().size() && base.getElement().get(nbl).getPath().startsWith(tgt.getElement().getPath() + "."); ++nbl) {
                            }
                            this.processPaths(indent + "  ", result, base, differential, nbc, start - 1, nbl - 1, diffCursor - 1, url, webUrl, profileName, tgt.getElement().getPath(), diffMatches.get(0).getPath(), trimDifferential, contextName, resultPathBase, false, null, null, this.redirectorStack(redirector, outcome, cpath), tgt.getSource());
                            continue;
                        }
                        for (nbl = nbc = base.getElement().indexOf(tgt.getElement()) + 1; nbl < base.getElement().size() && base.getElement().get(nbl).getPath().startsWith(tgt.getElement().getPath() + "."); ++nbl) {
                        }
                        this.processPaths(indent + "  ", result, base, differential, nbc, start - 1, nbl - 1, diffCursor - 1, url, webUrl, profileName, tgt.getElement().getPath(), diffMatches.get(0).getPath(), trimDifferential, contextName, resultPathBase, false, null, null, this.redirectorStack(redirector, outcome, cpath), srcSD);
                        continue;
                    }
                    StructureDefinition structureDefinition = dt = outcome.getType().size() == 1 ? this.getProfileForDataType(outcome.getType().get(0), webUrl) : this.getProfileForDataType("Element");
                    if (dt == null) {
                        throw new DefinitionException(this.context.formatMessage("_has_children__for_type__in_profile__but_cant_find_type", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
                    }
                    contextName = dt.getUrl();
                    this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, this.getWebUrl(dt, webUrl, indent), profileName + this.pathTail(diffMatches, 0), diffMatches.get(0).getPath(), outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, new ArrayList<ElementRedirection>(), srcSD);
                    continue;
                }
                if (this.diffsConstrainTypes(diffMatches, cpath, typeList)) {
                    boolean shortCut;
                    int start = 0;
                    int nbl = this.findEndOfElement(base, baseCursor);
                    int ndc = differential.getElement().indexOf(diffMatches.get(0));
                    ElementDefinition elementToRemove = null;
                    boolean bl = shortCut = !typeList.isEmpty() && ((TypeSlice)typeList.get(0)).type != null;
                    if (shortCut) {
                        if (!VersionUtilities.isR4Plus((String)this.context.getVersion()) || !this.newSlicingProcessing) {
                            ElementDefinition ed = new ElementDefinition();
                            ed.setPath(this.determineTypeSlicePath(diffMatches.get(0).getPath(), cpath));
                            for (TypeSlice ts : typeList) {
                                ed.addType().setCode(ts.type);
                            }
                            ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                            ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                            ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                            ed.getSlicing().setOrdered(false);
                            diffMatches.add(0, ed);
                            differential.getElement().add(ndc, ed);
                            elementToRemove = ed;
                        } else {
                            ElementDefinition ed = new ElementDefinition();
                            ed.setPath(this.determineTypeSlicePath(diffMatches.get(0).getPath(), cpath));
                            ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                            ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                            ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                            ed.getSlicing().setOrdered(false);
                            diffMatches.add(0, ed);
                            differential.getElement().add(ndc, ed);
                            elementToRemove = ed;
                        }
                    }
                    int ndl = this.findEndOfElement(differential, ndc);
                    if (diffMatches.get(0).getSlicing().hasOrdered() && diffMatches.get(0).getSlicing().getOrdered()) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingordered__true", cpath, url));
                    }
                    if (diffMatches.get(0).getSlicing().hasDiscriminator()) {
                        if (diffMatches.get(0).getSlicing().getDiscriminator().size() != 1) {
                            throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorcount__1", cpath, url));
                        }
                        if (diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getType() != ElementDefinition.DiscriminatorType.TYPE) {
                            throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatortype__type", cpath, url));
                        }
                        if (!"$this".equals(diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getPath())) {
                            throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorpath__this", cpath, url));
                        }
                    }
                    for (TypeSlice ts : typeList) {
                        if (ts.type == null) continue;
                        String tn = this.rootName(cpath) + Utilities.capitalize((String)ts.type);
                        if (!ts.defn.hasSliceName()) {
                            ts.defn.setSliceName(tn);
                        } else if (!ts.defn.getSliceName().equals(tn)) {
                            if (this.autoFixSliceNames) {
                                ts.defn.setSliceName(tn);
                            } else {
                                throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_name_must_be__but_is_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.getSliceName()));
                            }
                        }
                        if (!ts.defn.hasType()) {
                            ts.defn.addType().setCode(ts.type);
                            continue;
                        }
                        if (ts.defn.getType().size() > 1) {
                            throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_for_type__has_more_than_one_type_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.typeSummary()));
                        }
                        if (ts.defn.getType().get(0).getCode().equals(ts.type)) continue;
                        throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_for_type__has_wrong_type_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.typeSummary()));
                    }
                    ElementDefinition e = this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, 0), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, null, null, redirector, srcSD);
                    if (e == null) {
                        throw new FHIRException(this.context.formatMessage("Did_not_find_type_root_", diffMatches.get(0).getPath()));
                    }
                    e.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                    e.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                    e.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                    e.getSlicing().setOrdered(false);
                    String fixedType = null;
                    for (int i = ++start; i < diffMatches.size(); ++i) {
                        if (diffMatches.get(i).getMin() > 0) {
                            if (diffMatches.size() > i + 1) {
                                throw new FHIRException(this.context.formatMessage("Invalid_slicing__there_is_more_than_one_type_slice_at__but_one_of_them__has_min__1_so_the_other_slices_cannot_exist", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
                            }
                            e.setMin(1);
                            fixedType = this.determineFixedType(diffMatches, fixedType, i);
                        }
                        ndc = differential.getElement().indexOf(diffMatches.get(i));
                        ndl = this.findEndOfElement(differential, ndc);
                        ElementDefinition typeSliceElement = this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, i), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, e, null, redirector, srcSD);
                        if (typeList.size() <= start + 1) continue;
                        typeSliceElement.setMin(0);
                    }
                    if (elementToRemove != null) {
                        differential.getElement().remove(elementToRemove);
                        --ndl;
                    }
                    if (fixedType != null) {
                        Iterator<ElementDefinition.TypeRefComponent> iter = e.getType().iterator();
                        while (iter.hasNext()) {
                            ElementDefinition.TypeRefComponent tr = iter.next();
                            if (tr.getCode().equals(fixedType)) continue;
                            iter.remove();
                        }
                    }
                    if (!"0".equals(e.getMax())) {
                        Set<String> allowedTypes = this.getListOfTypes(e);
                        for (TypeSlice t : typeList) {
                            if (t.type != null) {
                                allowedTypes.remove(t.type);
                                continue;
                            }
                            if (!t.getDefn().hasSliceName() || t.getDefn().getType().size() != 1) continue;
                            allowedTypes.remove(t.getDefn().getType().get(0).getCode());
                        }
                        if (!allowedTypes.isEmpty()) {
                            if (cpath.contains("xtension.value")) {
                                Iterator<ElementDefinition.TypeRefComponent> iter = e.getType().iterator();
                                while (iter.hasNext()) {
                                    ElementDefinition.TypeRefComponent tr = iter.next();
                                    if (!allowedTypes.contains(tr.getCode())) continue;
                                    iter.remove();
                                }
                            } else {
                                e.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                            }
                        }
                    }
                    baseCursor = nbl + 1;
                    diffCursor = ndl + 1;
                    continue;
                }
                if (!this.unbounded(currentBase) && !this.isSlicedToOneOnly(diffMatches.get(0))) {
                    throw new DefinitionException(this.context.formatMessage("Attempt_to_a_slice_an_element_that_does_not_repeat__from__in_", currentBase.getPath(), currentBase.getPath(), contextName, url, diffMatches.get(0).getId(), this.sliceNames(diffMatches)));
                }
                if (!diffMatches.get(0).hasSlicing() && !this.isExtension(currentBase)) {
                    throw new DefinitionException(this.context.formatMessage("Differential_does_not_have_a_slice__b_of_____in_profile_", currentBase.getPath(), baseCursor, baseLimit, diffCursor, diffLimit, url, cpath));
                }
                int start = 0;
                int nbl = this.findEndOfElement(base, baseCursor);
                if (diffMatches.size() > 1 && diffMatches.get(0).hasSlicing() && (nbl > baseCursor || differential.getElement().indexOf(diffMatches.get(1)) > differential.getElement().indexOf(diffMatches.get(0)) + 1)) {
                    int ndc = differential.getElement().indexOf(diffMatches.get(0));
                    int ndl = this.findEndOfElement(differential, ndc);
                    ElementDefinition e = this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, 0), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, null, null, redirector, srcSD);
                    if (e == null) {
                        throw new FHIRException(this.context.formatMessage("Did_not_find_single_slice_", diffMatches.get(0).getPath()));
                    }
                    e.setSlicing(diffMatches.get(0).getSlicing());
                    slicerElement = e;
                } else {
                    ElementDefinition outcome = this.updateURLs(url, webUrl, currentBase.copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    this.updateFromBase(outcome, currentBase);
                    if (!diffMatches.get(0).hasSlicing()) {
                        outcome.setSlicing(this.makeExtensionSlicing());
                    } else {
                        outcome.setSlicing(diffMatches.get(0).getSlicing().copy());
                    }
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                    }
                    result.getElement().add(outcome);
                    slicerElement = outcome;
                    if (!diffMatches.get(0).hasSliceName()) {
                        this.updateFromDefinition(outcome, diffMatches.get(0), profileName, trimDifferential, url, srcSD);
                        this.removeStatusExtensions(outcome);
                        if (!outcome.hasContentReference() && !outcome.hasType()) {
                            throw new DefinitionException(this.context.formatMessage("Not_done_yet", new Object[0]));
                        }
                        if (this.hasInnerDiffMatches(differential, currentBase.getPath(), diffCursor, diffLimit, base.getElement(), false)) {
                            if (this.baseHasChildren(base, currentBase)) {
                                throw new Error("This situation is not yet handled (constrain slicing to 1..1 and fix base slice for inline structure - please report issue to grahame@fhir.org along with a test case that reproduces this error (@ " + cpath + " | " + currentBase.getPath() + ")");
                            }
                            StructureDefinition dt = this.getTypeForElement(differential, diffCursor, profileName, diffMatches, outcome, webUrl);
                            contextName = dt.getUrl();
                            start = ++diffCursor;
                            while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), cpath + ".")) {
                                ++diffCursor;
                            }
                            this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, --diffCursor, url, this.getWebUrl(dt, webUrl, indent), profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                        }
                        ++start;
                    } else {
                        this.checkExtensionDoco(outcome);
                    }
                }
                int ndc = diffCursor;
                int ndl = diffCursor;
                for (int i = ++start; i < diffMatches.size(); ++i) {
                    ndc = differential.getElement().indexOf(diffMatches.get(i));
                    ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, i), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, slicerElement, null, redirector, srcSD);
                }
                baseCursor = nbl + 1;
                diffCursor = ndl + 1;
                continue;
            }
            String path = currentBase.getPath();
            ElementDefinition original = currentBase;
            if (diffMatches.isEmpty()) {
                if (this.hasInnerDiffMatches(differential, path, diffCursor, diffLimit, base.getElement(), true)) {
                    ElementDefinition outcome = this.updateURLs(url, webUrl, currentBase.copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    this.updateFromBase(outcome, currentBase);
                    this.markDerived(outcome);
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                    }
                    result.getElement().add(outcome);
                    if (this.baseHasChildren(base, currentBase)) {
                        this.processPaths(indent + "  ", result, base, differential, baseCursor + 1, diffCursor, baseLimit, diffLimit, url, webUrl, profileName, contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                        baseCursor = this.indexOfFirstNonChild(base, currentBase, baseCursor, baseLimit);
                    } else {
                        StructureDefinition dt = this.getTypeForElement(differential, diffCursor, profileName, diffMatches, outcome, webUrl);
                        contextName = dt.getUrl();
                        int start = diffCursor;
                        if (differential.getElement().get(diffCursor).getPath().equals(cpath)) {
                            ++diffCursor;
                        }
                        while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), cpath + ".")) {
                            ++diffCursor;
                        }
                        if (diffCursor > start) {
                            this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, this.getWebUrl(dt, webUrl, indent), profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                        }
                    }
                    ++baseCursor;
                    continue;
                }
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path)) {
                    ElementDefinition outcome = this.updateURLs(url, webUrl, base.getElement().get(baseCursor).copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path_in_profile___vs_", profileName, outcome.getPath(), resultPathBase));
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
                continue;
            }
            if (this.diffsConstrainTypes(diffMatches, cpath, typeList)) {
                boolean shortCut;
                int start = 0;
                int nbl = this.findEndOfElement(base, baseCursor);
                int ndc = differential.getElement().indexOf(diffMatches.get(0));
                ElementDefinition elementToRemove = null;
                boolean bl = shortCut = !typeList.isEmpty() && ((TypeSlice)typeList.get(0)).type != null || diffMatches.get(0).hasSliceName() && !diffMatches.get(0).hasSlicing();
                if (shortCut) {
                    if (!VersionUtilities.isR4Plus((String)this.context.getVersion()) || !this.newSlicingProcessing) {
                        ElementDefinition ed = new ElementDefinition();
                        ed.setPath(this.determineTypeSlicePath(diffMatches.get(0).getPath(), cpath));
                        for (TypeSlice ts : typeList) {
                            ed.addType().setCode(ts.type);
                        }
                        ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                        ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                        ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                        ed.getSlicing().setOrdered(false);
                        diffMatches.add(0, ed);
                        differential.getElement().add(ndc, ed);
                        elementToRemove = ed;
                    } else {
                        ElementDefinition ed = new ElementDefinition();
                        ed.setPath(this.determineTypeSlicePath(diffMatches.get(0).getPath(), cpath));
                        ed.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                        ed.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                        ed.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                        ed.getSlicing().setOrdered(false);
                        diffMatches.add(0, ed);
                        differential.getElement().add(ndc, ed);
                        elementToRemove = ed;
                    }
                }
                int ndl = this.findEndOfElement(differential, ndc);
                if (diffMatches.get(0).getSlicing().hasOrdered() && diffMatches.get(0).getSlicing().getOrdered()) {
                    throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingordered__true", cpath, url));
                }
                if (diffMatches.get(0).getSlicing().hasDiscriminator()) {
                    if (diffMatches.get(0).getSlicing().getDiscriminator().size() != 1) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorcount__1", cpath, url));
                    }
                    if (diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getType() != ElementDefinition.DiscriminatorType.TYPE) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatortype__type", cpath, url));
                    }
                    if (!"$this".equals(diffMatches.get(0).getSlicing().getDiscriminatorFirstRep().getPath())) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__in__Type_slicing_with_slicingdiscriminatorpath__this", cpath, url));
                    }
                }
                for (TypeSlice ts : typeList) {
                    if (ts.type == null) continue;
                    String tn = this.rootName(cpath) + Utilities.capitalize((String)ts.type);
                    if (!ts.defn.hasSliceName()) {
                        ts.defn.setSliceName(tn);
                    } else if (!ts.defn.getSliceName().equals(tn)) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_name_must_be__but_is_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.getSliceName()));
                    }
                    if (!ts.defn.hasType()) {
                        ts.defn.addType().setCode(ts.type);
                        continue;
                    }
                    if (ts.defn.getType().size() > 1) {
                        throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_for_type__has_more_than_one_type_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.typeSummary()));
                    }
                    if (ts.defn.getType().get(0).getCode().equals(ts.type)) continue;
                    throw new FHIRException(this.context.formatMessage("Error_at_path__Slice_for_type__has_wrong_type_", !Utilities.noString((String)contextPathSrc) ? contextPathSrc : cpath, tn, ts.defn.typeSummary()));
                }
                ElementDefinition e = this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, 0), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, null, cpath, redirector, srcSD);
                if (e == null) {
                    throw new FHIRException(this.context.formatMessage("Did_not_find_type_root_", diffMatches.get(0).getPath()));
                }
                e.setSlicing(new ElementDefinition.ElementDefinitionSlicingComponent());
                e.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                e.getSlicing().setRules(ElementDefinition.SlicingRules.CLOSED);
                e.getSlicing().setOrdered(false);
                String fixedType = null;
                List<BaseTypeSlice> baseSlices = this.findBaseSlices(base, nbl);
                for (int i = ++start; i < diffMatches.size(); ++i) {
                    String type = this.determineFixedType(diffMatches, fixedType, i);
                    if (diffMatches.get(i).getMin() > 0) {
                        if (diffMatches.size() > i + 1) {
                            throw new FHIRException(this.context.formatMessage("Invalid_slicing__there_is_more_than_one_type_slice_at__but_one_of_them__has_min__1_so_the_other_slices_cannot_exist", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
                        }
                        fixedType = type;
                    }
                    ndc = differential.getElement().indexOf(diffMatches.get(i));
                    ndl = this.findEndOfElement(differential, ndc);
                    int sStart = baseCursor;
                    int sEnd = nbl;
                    BaseTypeSlice bs = this.chooseMatchingBaseSlice(baseSlices, type);
                    if (bs != null) {
                        sStart = bs.start;
                        sEnd = bs.end;
                        bs.handled = true;
                    }
                    this.processPaths(indent + "  ", result, base, differential, sStart, ndc, sEnd, ndl, url, webUrl, profileName + this.pathTail(diffMatches, i), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, e, cpath, redirector, srcSD);
                }
                if (elementToRemove != null) {
                    differential.getElement().remove(elementToRemove);
                    --ndl;
                }
                if (fixedType != null) {
                    Iterator<ElementDefinition.TypeRefComponent> iter = e.getType().iterator();
                    while (iter.hasNext()) {
                        ElementDefinition.TypeRefComponent tr = iter.next();
                        if (tr.getCode().equals(fixedType)) continue;
                        iter.remove();
                    }
                }
                for (BaseTypeSlice bs : baseSlices) {
                    if (bs.handled) continue;
                    StructureDefinition.StructureDefinitionDifferentialComponent fakeDiff = new StructureDefinition.StructureDefinitionDifferentialComponent();
                    fakeDiff.getElementFirstRep().setPath(bs.defn.getPath());
                    this.processPaths(indent + "  ", result, base, fakeDiff, bs.start, 0, bs.end, 0, url, webUrl, profileName + this.tail(bs.defn.getPath()), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, true, e, cpath, redirector, srcSD);
                }
                baseCursor = baseSlices.get(baseSlices.size() - 1).end + 1;
                diffCursor = ndl + 1;
                continue;
            }
            boolean closed = currentBase.getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED;
            int diffpos = 0;
            boolean bl = isExtension = cpath.endsWith(".extension") || cpath.endsWith(".modifierExtension");
            if (diffMatches.get(0).hasSlicing()) {
                ElementDefinition.ElementDefinitionSlicingComponent dSlice = diffMatches.get(0).getSlicing();
                ElementDefinition.ElementDefinitionSlicingComponent bSlice = currentBase.getSlicing();
                if (dSlice.hasOrderedElement() && bSlice.hasOrderedElement() && !this.orderMatches(dSlice.getOrderedElement(), bSlice.getOrderedElement())) {
                    throw new DefinitionException(this.context.formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___order___", ProfileUtilities.summarizeSlicing(dSlice), ProfileUtilities.summarizeSlicing(bSlice), path, contextName));
                }
                if (!this.discriminatorMatches(dSlice.getDiscriminator(), bSlice.getDiscriminator())) {
                    throw new DefinitionException(this.context.formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___disciminator___", ProfileUtilities.summarizeSlicing(dSlice), ProfileUtilities.summarizeSlicing(bSlice), path, contextName));
                }
                if (!currentBase.isChoice() && !this.ruleMatches(dSlice.getRules(), bSlice.getRules())) {
                    throw new DefinitionException(this.context.formatMessage("Slicing_rules_on_differential__do_not_match_those_on_base___rule___", ProfileUtilities.summarizeSlicing(dSlice), ProfileUtilities.summarizeSlicing(bSlice), path, contextName));
                }
            }
            ElementDefinition outcome = this.updateURLs(url, webUrl, currentBase.copy());
            outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
            this.updateFromBase(outcome, currentBase);
            if (diffMatches.get(0).hasSlicing() || !diffMatches.get(0).hasSliceName()) {
                this.updateFromSlicing(outcome.getSlicing(), diffMatches.get(0).getSlicing());
                this.updateFromDefinition(outcome, diffMatches.get(0), profileName, closed, url, srcSD);
                this.removeStatusExtensions(outcome);
            } else if (!diffMatches.get(0).hasSliceName()) {
                diffMatches.get(0).setUserData(GENERATED_IN_SNAPSHOT, outcome);
            }
            result.getElement().add(outcome);
            if (!diffMatches.get(0).hasSliceName()) {
                ++diffpos;
            }
            if (this.hasInnerDiffMatches(differential, cpath, diffCursor, diffLimit, base.getElement(), false)) {
                int nbl = this.findEndOfElement(base, baseCursor);
                int ndx = differential.getElement().indexOf(diffMatches.get(0));
                int ndc = ndx + (diffMatches.get(0).hasSlicing() ? 1 : 0);
                int ndl = this.findEndOfElement(differential, ndx);
                if (nbl == baseCursor) {
                    if (base.getElement().get(baseCursor).getType().size() != 1) {
                        throw new Error(this.context.formatMessage("Differential_walks_into____but_the_base_does_not_and_there_is_not_a_single_fixed_type_The_type_is__This_is_not_handled_yet", cpath, diffMatches.get(0).toString(), base.getElement().get(baseCursor).typeSummary()));
                    }
                    StructureDefinition dt = this.getProfileForDataType(base.getElement().get(baseCursor).getType().get(0), webUrl);
                    if (dt == null) {
                        throw new DefinitionException(this.context.formatMessage("Unknown_type__at_", outcome.getType().get(0), diffMatches.get(0).getPath()));
                    }
                    contextName = dt.getUrl();
                    while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), cpath + ".")) {
                        ++diffCursor;
                    }
                    this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, ndc, dt.getSnapshot().getElement().size() - 1, ndl, url, this.getWebUrl(dt, webUrl, indent), profileName, cpath, outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                } else {
                    this.processPaths(indent + "  ", result, base, differential, baseCursor + 1, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, 0), contextPathSrc, contextPathDst, trimDifferential, contextName, resultPathBase, false, null, null, null, srcSD);
                }
            } else if (currentBase.getType().get(0).getCode().equals("BackboneElement")) {
                int nbl = this.findEndOfElement(base, baseCursor);
                for (int i = baseCursor + 1; i <= nbl; ++i) {
                    outcome = this.updateURLs(url, webUrl, base.getElement().get(i).copy());
                    result.getElement().add(outcome);
                }
            }
            List<ElementDefinition> baseMatches = this.getSiblings(base.getElement(), currentBase);
            for (ElementDefinition baseItem : baseMatches) {
                baseCursor = base.getElement().indexOf(baseItem);
                outcome = this.updateURLs(url, webUrl, baseItem.copy());
                this.updateFromBase(outcome, currentBase);
                outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                outcome.setSlicing(null);
                if (!outcome.getPath().startsWith(resultPathBase)) {
                    throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                }
                if (diffpos < diffMatches.size() && diffMatches.get(diffpos).hasSliceName() && diffMatches.get(diffpos).getSliceName().equals(outcome.getSliceName())) {
                    int nbl = this.findEndOfElement(base, baseCursor);
                    int ndc = differential.getElement().indexOf(diffMatches.get(diffpos));
                    int ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(indent + "  ", result, base, differential, baseCursor, ndc, nbl, ndl, url, webUrl, profileName + this.pathTail(diffMatches, diffpos), contextPathSrc, contextPathDst, closed, contextName, resultPathBase, true, null, null, redirector, srcSD);
                    baseCursor = nbl;
                    diffCursor = ndl + 1;
                    ++diffpos;
                    continue;
                }
                result.getElement().add(outcome);
                ++baseCursor;
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path) && !base.getElement().get(baseCursor).getPath().equals(path)) {
                    outcome = this.updateURLs(url, webUrl, base.getElement().get(baseCursor).copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
                --baseCursor;
            }
            boolean checkImplicitTypes = false;
            if (closed && diffpos < diffMatches.size()) {
                if (currentBase.getPath().endsWith("[x]")) {
                    checkImplicitTypes = true;
                } else {
                    throw new DefinitionException(this.context.formatMessage("The_base_snapshot_marks_a_slicing_as_closed_but_the_differential_tries_to_extend_it_in__at__", profileName, path, cpath));
                }
            }
            if (diffpos != diffMatches.size()) {
                while (diffpos < diffMatches.size()) {
                    ElementDefinition diffItem = diffMatches.get(diffpos);
                    for (ElementDefinition baseItem : baseMatches) {
                        if (!baseItem.getSliceName().equals(diffItem.getSliceName())) continue;
                        throw new DefinitionException(this.context.formatMessage("Named_items_are_out_of_order_in_the_slice", new Object[0]));
                    }
                    outcome = this.updateURLs(url, webUrl, currentBase.copy());
                    outcome.setPath(this.fixedPathDest(contextPathDst, outcome.getPath(), redirector, contextPathSrc));
                    this.updateFromBase(outcome, currentBase);
                    outcome.setSlicing(null);
                    outcome.setMin(0);
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException(this.context.formatMessage("Adding_wrong_path", new Object[0]));
                    }
                    result.getElement().add(outcome);
                    this.updateFromDefinition(outcome, diffItem, profileName, trimDifferential, url, srcSD);
                    this.removeStatusExtensions(outcome);
                    diffCursor = differential.getElement().indexOf(diffItem) + 1;
                    if (!outcome.getType().isEmpty() && differential.getElement().size() > diffCursor && outcome.getPath().contains(".") && !this.baseWalksInto(base.getElement(), baseCursor) && differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                        ElementDefinition.TypeRefComponent t;
                        if (outcome.getType().size() > 1) {
                            for (ElementDefinition.TypeRefComponent t2 : outcome.getType()) {
                                if (t2.getCode().equals("Reference")) continue;
                                throw new DefinitionException(this.context.formatMessage("_has_children__and_multiple_types__in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
                            }
                        }
                        if ((t = outcome.getType().get(0)).getCode().equals("BackboneElement")) {
                            int baseMax;
                            int baseStart = base.getElement().indexOf(currentBase) + 1;
                            for (baseMax = baseStart + 1; baseMax < base.getElement().size() && base.getElement().get(baseMax).getPath().startsWith(currentBase.getPath() + "."); ++baseMax) {
                            }
                            int start = diffCursor;
                            while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                                ++diffCursor;
                            }
                            this.processPaths(indent + "  ", result, base, differential, baseStart, start - 1, baseMax - 1, diffCursor - 1, url, webUrl, profileName + this.pathTail(diffMatches, 0), base.getElement().get(0).getPath(), base.getElement().get(0).getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                        } else {
                            StructureDefinition dt = this.getProfileForDataType(outcome.getType().get(0), webUrl);
                            if (dt == null) {
                                throw new DefinitionException(this.context.formatMessage("_has_children__for_type__in_profile__but_cant_find_type", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
                            }
                            contextName = dt.getUrl();
                            int start = diffCursor;
                            while (differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) {
                                ++diffCursor;
                            }
                            this.processPaths(indent + "  ", result, dt.getSnapshot(), differential, 1, start - 1, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, this.getWebUrl(dt, webUrl, indent), profileName + this.pathTail(diffMatches, 0), diffMatches.get(0).getPath(), outcome.getPath(), trimDifferential, contextName, resultPathBase, false, null, null, redirector, srcSD);
                        }
                    }
                    ++diffpos;
                }
            }
            ++baseCursor;
        }
        int i = 0;
        for (ElementDefinition e : result.getElement()) {
            ++i;
            if (!e.hasMinElement() || e.getMinElement().getValue() != null) continue;
            throw new Error(this.context.formatMessage("null_min", new Object[0]));
        }
        return res;
    }

    private ElementDefinition getById(List<ElementDefinition> list, String baseId) {
        for (ElementDefinition t : list) {
            if (!baseId.equals(t.getId())) continue;
            return t;
        }
        return null;
    }

    private void updateConstraintSources(ElementDefinition ed, String url) {
        for (ElementDefinition.ElementDefinitionConstraintComponent c : ed.getConstraint()) {
            if (c.hasSource()) continue;
            c.setSource(url);
        }
    }

    private Set<String> getListOfTypes(ElementDefinition e) {
        HashSet<String> result = new HashSet<String>();
        for (ElementDefinition.TypeRefComponent t : e.getType()) {
            result.add(t.getCode());
        }
        return result;
    }

    public StructureDefinition getTypeForElement(StructureDefinition.StructureDefinitionDifferentialComponent differential, int diffCursor, String profileName, List<ElementDefinition> diffMatches, ElementDefinition outcome, String webUrl) {
        StructureDefinition dt;
        if (outcome.getType().size() == 0) {
            throw new DefinitionException(this.context.formatMessage("_has_no_children__and_no_types_in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), profileName));
        }
        if (outcome.getType().size() > 1) {
            for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new DefinitionException(this.context.formatMessage("_has_children__and_multiple_types__in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
            }
        }
        if ((dt = this.getProfileForDataType(outcome.getType().get(0), webUrl)) == null) {
            throw new DefinitionException(this.context.formatMessage("Unknown_type__at_", outcome.getType().get(0), diffMatches.get(0).getPath()));
        }
        return dt;
    }

    private String sliceNames(List<ElementDefinition> diffMatches) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition ed : diffMatches) {
            if (!ed.hasSliceName()) continue;
            b.append(ed.getSliceName());
        }
        return b.toString();
    }

    private boolean isMatchingType(StructureDefinition sd, List<ElementDefinition.TypeRefComponent> types, String inner) {
        while (sd != null) {
            for (ElementDefinition.TypeRefComponent tr : types) {
                if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition") && sd.getType().equals(tr.getCode())) {
                    return true;
                }
                if (inner == null && sd.getUrl().equals(tr.getCode())) {
                    return true;
                }
                if (inner == null) continue;
                ElementDefinition ed = null;
                for (ElementDefinition t : sd.getSnapshot().getElement()) {
                    if (!inner.equals(t.getId())) continue;
                    ed = t;
                }
                if (ed == null) continue;
                return this.isMatchingType(ed.getType(), types);
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return false;
    }

    private boolean isMatchingType(List<ElementDefinition.TypeRefComponent> test, List<ElementDefinition.TypeRefComponent> desired) {
        for (ElementDefinition.TypeRefComponent t : test) {
            for (ElementDefinition.TypeRefComponent d : desired) {
                if (!t.getCode().equals(d.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidType(ElementDefinition.TypeRefComponent t, ElementDefinition base) {
        for (ElementDefinition.TypeRefComponent tr : base.getType()) {
            if (tr.getCode().equals(t.getCode())) {
                return true;
            }
            if (!tr.getWorkingCode().equals(t.getCode())) continue;
            System.out.println("Type error: use of a simple type \"" + t.getCode() + "\" wrongly constraining " + base.getPath());
            return true;
        }
        return false;
    }

    private boolean isGenerating(StructureDefinition sd) {
        return sd.hasUserData("profileutils.snapshot.generating");
    }

    private void checkNotGenerating(StructureDefinition sd, String role) {
        if (sd.hasUserData("profileutils.snapshot.generating")) {
            throw new FHIRException(this.context.formatMessage("Attempt_to_use_a_snapshot_on_profile__as__before_it_is_generated", sd.getUrl(), role));
        }
    }

    private boolean isBaseResource(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getWorkingCode();
            if (!"Resource".equals(t)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String determineFixedType(List<ElementDefinition> diffMatches, String fixedType, int i) {
        if (diffMatches.get(i).getType().size() == 0 && diffMatches.get(i).hasSliceName()) {
            String n = this.tail(diffMatches.get(i).getPath()).replace("[x]", "");
            String t = diffMatches.get(i).getSliceName().substring(n.length());
            if (this.isDataType(t)) {
                return t;
            }
            if (!this.isPrimitive(Utilities.uncapitalize((String)t))) throw new FHIRException(this.context.formatMessage("Unexpected_condition_in_differential_typeslicetypelistsize__10_and_implicit_slice_name_does_not_contain_a_valid_type__at_", t, diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
            return Utilities.uncapitalize((String)t);
        }
        if (diffMatches.get(i).getType().size() != 1) throw new FHIRException(this.context.formatMessage("Unexpected_condition_in_differential_typeslicetypelistsize__1_at_", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
        return diffMatches.get(i).getType().get(0).getCode();
    }

    private BaseTypeSlice chooseMatchingBaseSlice(List<BaseTypeSlice> baseSlices, String type) {
        for (BaseTypeSlice bs : baseSlices) {
            if (!bs.type.equals(type)) continue;
            return bs;
        }
        return null;
    }

    private List<BaseTypeSlice> findBaseSlices(StructureDefinition.StructureDefinitionSnapshotComponent list, int start) {
        int i;
        ArrayList<BaseTypeSlice> res = new ArrayList<BaseTypeSlice>();
        ElementDefinition base = list.getElement().get(start);
        for (i = start + 1; i < list.getElement().size() && list.getElement().get(i).getPath().startsWith(base.getPath() + "."); ++i) {
        }
        while (i < list.getElement().size() && list.getElement().get(i).getPath().equals(base.getPath()) && list.getElement().get(i).hasSliceName()) {
            int s = i++;
            while (i < list.getElement().size() && list.getElement().get(i).getPath().startsWith(base.getPath() + ".")) {
                ++i;
            }
            res.add(new BaseTypeSlice(list.getElement().get(s), list.getElement().get(s).getTypeFirstRep().getCode(), s, i - 1));
        }
        return res;
    }

    private String getWebUrl(StructureDefinition dt, String webUrl, String indent) {
        if (dt.hasUserData("path")) {
            String url = dt.getUserString("path");
            int i = url.lastIndexOf("/");
            if (i < 1) {
                return this.defWebRoot;
            }
            return url.substring(0, i + 1);
        }
        return webUrl;
    }

    private void removeStatusExtensions(ElementDefinition outcome) {
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
    }

    private String descED(List<ElementDefinition> list, int index) {
        return index >= 0 && index < list.size() ? list.get(index).present() : "X";
    }

    private boolean baseHasChildren(StructureDefinition.StructureDefinitionSnapshotComponent base, ElementDefinition ed) {
        int index = base.getElement().indexOf(ed);
        if (index == -1 || index >= base.getElement().size() - 1) {
            return false;
        }
        String p = base.getElement().get(index + 1).getPath();
        return this.isChildOf(p, ed.getPath());
    }

    private boolean isChildOf(String sub, String focus) {
        if (focus.endsWith("[x]")) {
            focus = focus.substring(0, focus.length() - 3);
            return sub.startsWith(focus);
        }
        return sub.startsWith(focus + ".");
    }

    private int indexOfFirstNonChild(StructureDefinition.StructureDefinitionSnapshotComponent base, ElementDefinition currentBase, int i, int baseLimit) {
        return baseLimit + 1;
    }

    private String rootName(String cpath) {
        String t = this.tail(cpath);
        return t.replace("[x]", "");
    }

    private String determineTypeSlicePath(String path, String cpath) {
        String headP = path.substring(0, path.lastIndexOf("."));
        String tailC = cpath.substring(cpath.lastIndexOf(".") + 1);
        return headP + "." + tailC;
    }

    private boolean isImplicitSlicing(ElementDefinition ed, String path) {
        if (ed == null || ed.getPath() == null || path == null) {
            return false;
        }
        if (path.equals(ed.getPath())) {
            return false;
        }
        boolean ok = path.endsWith("[x]") && ed.getPath().startsWith(path.substring(0, path.length() - 3));
        return ok;
    }

    private boolean diffsConstrainTypes(List<ElementDefinition> diffMatches, String cPath, List<TypeSlice> typeList) {
        String p = diffMatches.get(0).getPath();
        if (!p.endsWith("[x]") && !cPath.endsWith("[x]")) {
            return false;
        }
        typeList.clear();
        String rn = this.tail(cPath);
        rn = rn.substring(0, rn.length() - 3);
        for (int i = 0; i < diffMatches.size(); ++i) {
            ElementDefinition ed = diffMatches.get(i);
            String n = this.tail(ed.getPath());
            if (!n.startsWith(rn)) {
                return false;
            }
            String s = n.substring(rn.length());
            if (s.contains(".")) continue;
            if (ed.hasSliceName() && ed.getType().size() == 1) {
                typeList.add(new TypeSlice(ed, ed.getTypeFirstRep().getWorkingCode()));
                continue;
            }
            if (ed.hasSliceName() && ed.getType().size() == 0) {
                if (this.isDataType(s)) {
                    typeList.add(new TypeSlice(ed, s));
                    continue;
                }
                if (this.isPrimitive(Utilities.uncapitalize((String)s))) {
                    typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)s)));
                    continue;
                }
                String tn = ed.getSliceName().substring(n.length());
                if (this.isDataType(tn)) {
                    typeList.add(new TypeSlice(ed, tn));
                    continue;
                }
                if (!this.isPrimitive(Utilities.uncapitalize((String)tn))) continue;
                typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)tn)));
                continue;
            }
            if (!ed.hasSliceName() && !s.equals("[x]")) {
                if (this.isDataType(s)) {
                    typeList.add(new TypeSlice(ed, s));
                    continue;
                }
                if (this.isConstrainedDataType(s)) {
                    typeList.add(new TypeSlice(ed, this.baseType(s)));
                    continue;
                }
                if (!this.isPrimitive(Utilities.uncapitalize((String)s))) continue;
                typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)s)));
                continue;
            }
            if (ed.hasSliceName() || !s.equals("[x]")) continue;
            typeList.add(new TypeSlice(ed, null));
        }
        return true;
    }

    private List<ElementRedirection> redirectorStack(List<ElementRedirection> redirector, ElementDefinition outcome, String path) {
        ArrayList<ElementRedirection> result = new ArrayList<ElementRedirection>();
        result.addAll(redirector);
        result.add(new ElementRedirection(outcome, path));
        return result;
    }

    private List<ElementDefinition.TypeRefComponent> getByTypeName(List<ElementDefinition.TypeRefComponent> type, String t) {
        ArrayList<ElementDefinition.TypeRefComponent> res = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent tr : type) {
            if (!t.equals(tr.getWorkingCode())) continue;
            res.add(tr);
        }
        return res;
    }

    private void replaceFromContentReference(ElementDefinition outcome, ElementDefinition tgt) {
        outcome.setContentReference(null);
        outcome.getType().clear();
        outcome.getType().addAll(tgt.getType());
    }

    private boolean baseWalksInto(List<ElementDefinition> elements, int cursor) {
        if (cursor >= elements.size()) {
            return false;
        }
        String path = elements.get(cursor).getPath();
        String prevPath = elements.get(cursor - 1).getPath();
        return path.startsWith(prevPath + ".");
    }

    private ElementDefinition fillOutFromBase(ElementDefinition profile, ElementDefinition usage) throws FHIRFormatError {
        ElementDefinition res = profile.copy();
        if (!res.hasSliceName()) {
            res.setSliceName(usage.getSliceName());
        }
        if (!res.hasLabel()) {
            res.setLabel(usage.getLabel());
        }
        for (Coding coding : usage.getCode()) {
            if (res.hasCode(coding)) continue;
            res.addCode(coding);
        }
        if (!res.hasDefinition()) {
            res.setDefinition(usage.getDefinition());
        }
        if (!res.hasShort() && usage.hasShort()) {
            res.setShort(usage.getShort());
        }
        if (!res.hasComment() && usage.hasComment()) {
            res.setComment(usage.getComment());
        }
        if (!res.hasRequirements() && usage.hasRequirements()) {
            res.setRequirements(usage.getRequirements());
        }
        for (StringType stringType : usage.getAlias()) {
            if (res.hasAlias((String)stringType.getValue())) continue;
            res.addAlias((String)stringType.getValue());
        }
        if (!res.hasMin() && usage.hasMin()) {
            res.setMin(usage.getMin());
        }
        if (!res.hasMax() && usage.hasMax()) {
            res.setMax(usage.getMax());
        }
        if (!res.hasFixed() && usage.hasFixed()) {
            res.setFixed(usage.getFixed());
        }
        if (!res.hasPattern() && usage.hasPattern()) {
            res.setPattern(usage.getPattern());
        }
        if (!res.hasExample() && usage.hasExample()) {
            res.setExample(usage.getExample());
        }
        if (!res.hasMinValue() && usage.hasMinValue()) {
            res.setMinValue(usage.getMinValue());
        }
        if (!res.hasMaxValue() && usage.hasMaxValue()) {
            res.setMaxValue(usage.getMaxValue());
        }
        if (!res.hasMaxLength() && usage.hasMaxLength()) {
            res.setMaxLength(usage.getMaxLength());
        }
        if (!res.hasMustSupport() && usage.hasMustSupport()) {
            res.setMustSupport(usage.getMustSupport());
        }
        if (!res.hasBinding() && usage.hasBinding()) {
            res.setBinding(usage.getBinding().copy());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : usage.getConstraint()) {
            if (res.hasConstraint(elementDefinitionConstraintComponent.getKey())) continue;
            res.addConstraint(elementDefinitionConstraintComponent);
        }
        for (Extension extension : usage.getExtension()) {
            if (res.hasExtension(extension.getUrl())) continue;
            res.addExtension(extension.copy());
        }
        return res;
    }

    private boolean checkExtensionDoco(ElementDefinition base) {
        boolean isExtension;
        boolean bl = isExtension = !(!base.getPath().equals("Extension") && !base.getPath().endsWith(".extension") && !base.getPath().endsWith(".modifierExtension") || base.hasBase() && "II.extension".equals(base.getBase().getPath()));
        if (isExtension) {
            base.setDefinition("An Extension");
            base.setShort("Extension");
            base.setCommentElement(null);
            base.setRequirementsElement(null);
            base.getAlias().clear();
            base.getMapping().clear();
        }
        return isExtension;
    }

    private String pathTail(List<ElementDefinition> diffMatches, int i) {
        ElementDefinition d = diffMatches.get(i);
        String s = d.getPath().contains(".") ? d.getPath().substring(d.getPath().lastIndexOf(".") + 1) : d.getPath();
        return "." + s + (d.hasType() && d.getType().get(0).hasProfile() ? "[" + d.getType().get(0).getProfile() + "]" : "");
    }

    private void markDerived(ElementDefinition outcome) {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : outcome.getConstraint()) {
            inv.setUserData(IS_DERIVED, true);
        }
    }

    public static String summarizeSlicing(ElementDefinition.ElementDefinitionSlicingComponent slice) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slice.getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(d.getType().toCode() + ":" + d.getPath());
        }
        b.append(" (");
        if (slice.hasOrdered()) {
            b.append(slice.getOrdered() ? "ordered" : "unordered");
        }
        b.append("/");
        if (slice.hasRules()) {
            b.append(slice.getRules().toCode());
        }
        b.append(")");
        if (slice.hasDescription()) {
            b.append(" \"");
            b.append(slice.getDescription());
            b.append("\"");
        }
        return b.toString();
    }

    private void updateFromBase(ElementDefinition derived, ElementDefinition base) {
        if (base.hasBase()) {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getBase().getPath());
            derived.getBase().setMin(base.getBase().getMin());
            derived.getBase().setMax(base.getBase().getMax());
        } else {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getPath());
            derived.getBase().setMin(base.getMin());
            derived.getBase().setMax(base.getMax());
        }
    }

    private boolean pathStartsWith(String p1, String p2) {
        return p1.startsWith(p2) || p2.endsWith("[x].") && p1.startsWith(p2.substring(0, p2.length() - 4));
    }

    private boolean pathMatches(String p1, String p2) {
        return p1.equals(p2) || p2.endsWith("[x]") && p1.startsWith(p2.substring(0, p2.length() - 3)) && !p1.substring(p2.length() - 3).contains(".");
    }

    private String fixedPathSource(String contextPath, String pathSimple, List<ElementRedirection> redirector) {
        if (contextPath == null) {
            return pathSimple;
        }
        if (redirector.size() > 0) {
            String ptail = null;
            ptail = contextPath.length() >= pathSimple.length() ? pathSimple.substring(pathSimple.indexOf(".") + 1) : pathSimple.substring(contextPath.length() + 1);
            return redirector.get(redirector.size() - 1).getPath() + "." + ptail;
        }
        String ptail = pathSimple.substring(pathSimple.indexOf(".") + 1);
        return contextPath + "." + ptail;
    }

    private String fixedPathDest(String contextPath, String pathSimple, List<ElementRedirection> redirector, String redirectSource) {
        String s;
        if (contextPath == null) {
            s = pathSimple;
        } else if (redirector.size() > 0) {
            String ptail = null;
            ptail = redirectSource.length() >= pathSimple.length() ? pathSimple.substring(pathSimple.indexOf(".") + 1) : pathSimple.substring(redirectSource.length() + 1);
            s = contextPath + "." + ptail;
        } else {
            String ptail = pathSimple.substring(pathSimple.indexOf(".") + 1);
            s = contextPath + "." + ptail;
        }
        return s;
    }

    private StructureDefinition getProfileForDataType(ElementDefinition.TypeRefComponent type, String webUrl) {
        StructureDefinition sd = null;
        if (type.hasProfile()) {
            sd = this.context.fetchResource(StructureDefinition.class, (String)type.getProfile().get(0).getValue());
            if (sd == null && this.xver != null && this.xver.matchingUrl((String)type.getProfile().get(0).getValue()) && this.xver.status((String)type.getProfile().get(0).getValue()) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                sd = this.xver.makeDefinition((String)type.getProfile().get(0).getValue());
                this.generateSnapshot(this.context.fetchTypeDefinition("Extension"), sd, sd.getUrl(), webUrl, sd.getName());
            }
            if (sd == null) {
                System.out.println("Failed to find referenced profile: " + type.getProfile());
            }
        }
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(type.getWorkingCode());
        }
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type.getWorkingCode());
        }
        return sd;
    }

    private StructureDefinition getProfileForDataType(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type);
        }
        return sd;
    }

    public static String typeCode(List<ElementDefinition.TypeRefComponent> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent type : types) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(type.getWorkingCode());
            if (type.hasTargetProfile()) {
                b.append("{" + type.getTargetProfile() + "}");
                continue;
            }
            if (!type.hasProfile()) continue;
            b.append("{" + type.getProfile() + "}");
        }
        return b.toString();
    }

    private boolean isDataType(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getWorkingCode();
            if (this.isDataType(t) || this.isPrimitive(t)) continue;
            return false;
        }
        return true;
    }

    private ElementDefinition updateURLs(String url, String webUrl, ElementDefinition element) {
        if (element != null) {
            ElementDefinition defn = element;
            if (defn.hasBinding() && defn.getBinding().hasValueSet() && defn.getBinding().getValueSet().startsWith("#")) {
                defn.getBinding().setValueSet(url + defn.getBinding().getValueSet());
            }
            for (ElementDefinition.TypeRefComponent t : defn.getType()) {
                for (UriType uriType : t.getProfile()) {
                    if (!((String)uriType.getValue()).startsWith("#")) continue;
                    uriType.setValue(url + t.getProfile());
                }
                for (UriType uriType : t.getTargetProfile()) {
                    if (!((String)uriType.getValue()).startsWith("#")) continue;
                    uriType.setValue(url + t.getTargetProfile());
                }
            }
            if (webUrl != null) {
                if (element.hasDefinition()) {
                    element.setDefinition(ProfileUtilities.processRelativeUrls(element.getDefinition(), webUrl, this.baseSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasComment()) {
                    element.setComment(ProfileUtilities.processRelativeUrls(element.getComment(), webUrl, this.baseSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasRequirements()) {
                    element.setRequirements(ProfileUtilities.processRelativeUrls(element.getRequirements(), webUrl, this.baseSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasMeaningWhenMissing()) {
                    element.setMeaningWhenMissing(ProfileUtilities.processRelativeUrls(element.getMeaningWhenMissing(), webUrl, this.baseSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
            }
        }
        return element;
    }

    public static String processRelativeUrls(String markdown, String webUrl, String basePath, List<String> resourceNames, Set<String> baseFilenames, Set<String> localFilenames, boolean processRelatives) {
        if (markdown == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < markdown.length(); ++i) {
            if (i < markdown.length() - 3 && markdown.substring(i, i + 2).equals("](")) {
                int j;
                for (j = i + 2; j < markdown.length() && markdown.charAt(j) != ')'; ++j) {
                }
                if (j < markdown.length()) {
                    String url = markdown.substring(i + 2, j);
                    if (!Utilities.isAbsoluteUrl((String)url) && !url.startsWith("..")) {
                        if (ProfileUtilities.isLikelySourceURLReference(url, resourceNames, baseFilenames, localFilenames)) {
                            b.append("](");
                            b.append(basePath);
                            ++i;
                            continue;
                        }
                        b.append("](");
                        if (processRelatives && webUrl != null && !ProfileUtilities.issLocalFileName(url, localFilenames)) {
                            b.append(webUrl);
                        }
                        ++i;
                        continue;
                    }
                    b.append(markdown.charAt(i));
                    continue;
                }
                b.append(markdown.charAt(i));
                continue;
            }
            b.append(markdown.charAt(i));
        }
        return b.toString();
    }

    public static boolean issLocalFileName(String url, Set<String> localFilenames) {
        if (localFilenames != null) {
            for (String n : localFilenames) {
                if (!url.startsWith(n.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLikelySourceURLReference(String url, List<String> resourceNames, Set<String> baseFilenames, Set<String> localFilenames) {
        if (resourceNames != null) {
            for (String n : resourceNames) {
                if (url.startsWith(n.toLowerCase() + ".html")) {
                    return true;
                }
                if (!url.startsWith(n.toLowerCase() + "-definitions.html")) continue;
                return true;
            }
        }
        if (localFilenames != null) {
            for (String n : localFilenames) {
                if (!url.startsWith(n.toLowerCase())) continue;
                return false;
            }
        }
        if (baseFilenames != null) {
            for (String n : baseFilenames) {
                if (!url.startsWith(n.toLowerCase())) continue;
                return true;
            }
        }
        return url.startsWith("extensibility.html") || url.startsWith("terminologies.html") || url.startsWith("observation.html") || url.startsWith("codesystem.html") || url.startsWith("fhirpath.html") || url.startsWith("datatypes.html") || url.startsWith("operations.html") || url.startsWith("resource.html") || url.startsWith("elementdefinition.html") || url.startsWith("element-definitions.html") || url.startsWith("snomedct.html") || url.startsWith("loinc.html") || url.startsWith("http.html") || url.startsWith("references") || url.startsWith("narrative.html") || url.startsWith("search.html") || url.startsWith("patient-operation-match.html") || url.startsWith("extension-") && url.contains(".html") || url.startsWith("resource-definitions.html");
    }

    private String baseSpecUrl() {
        if (VersionUtilities.isR5Ver((String)this.context.getVersion())) {
            return "http://build.fhir.org/";
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            return "http://hl7.org/fhir/R4/";
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            return "http://hl7.org/fhir/STU3/";
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            return "http://hl7.org/fhir/2016May/";
        }
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            return "http://hl7.org/fhir/DSTU2/";
        }
        if (VersionUtilities.isR4BVer((String)this.context.getVersion())) {
            return "http://hl7.org/fhir/2021Mar/";
        }
        return "";
    }

    private List<ElementDefinition> getSiblings(List<ElementDefinition> list, ElementDefinition current) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String path = current.getPath();
        for (int cursor = list.indexOf(current) + 1; cursor < list.size() && list.get(cursor).getPath().length() >= path.length(); ++cursor) {
            if (!this.pathMatches(list.get(cursor).getPath(), path)) continue;
            result.add(list.get(cursor));
        }
        return result;
    }

    private void updateFromSlicing(ElementDefinition.ElementDefinitionSlicingComponent dst, ElementDefinition.ElementDefinitionSlicingComponent src) {
        if (src.hasOrderedElement()) {
            dst.setOrderedElement(src.getOrderedElement().copy());
        }
        if (src.hasDiscriminator()) {
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : src.getDiscriminator()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : dst.getDiscriminator()) {
                    if (!this.matches(d, s)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dst.getDiscriminator().add(s);
            }
        }
        if (src.hasRulesElement()) {
            dst.setRulesElement((Enumeration<ElementDefinition.SlicingRules>)src.getRulesElement().copy());
        }
    }

    private boolean orderMatches(BooleanType diff, BooleanType base) {
        return diff == null || base == null || diff.getValue() == base.getValue();
    }

    private boolean discriminatorMatches(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> diff, List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> base) {
        if (diff.isEmpty() || base.isEmpty()) {
            return true;
        }
        if (diff.size() != base.size()) {
            return false;
        }
        for (int i = 0; i < diff.size(); ++i) {
            if (this.matches(diff.get(i), base.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c1, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c2) {
        return c1.getType().equals((Object)c2.getType()) && c1.getPath().equals(c2.getPath());
    }

    private boolean ruleMatches(ElementDefinition.SlicingRules diff, ElementDefinition.SlicingRules base) {
        return diff == null || base == null || diff == base || base == ElementDefinition.SlicingRules.OPEN || diff == ElementDefinition.SlicingRules.OPENATEND && base == ElementDefinition.SlicingRules.CLOSED;
    }

    private boolean isSlicedToOneOnly(ElementDefinition e) {
        return e.hasSlicing() && e.hasMaxElement() && e.getMax().equals("1");
    }

    private ElementDefinition.ElementDefinitionSlicingComponent makeExtensionSlicing() {
        ElementDefinition.ElementDefinitionSlicingComponent slice = new ElementDefinition.ElementDefinitionSlicingComponent();
        slice.addDiscriminator().setPath("url").setType(ElementDefinition.DiscriminatorType.VALUE);
        slice.setOrdered(false);
        slice.setRules(ElementDefinition.SlicingRules.OPEN);
        return slice;
    }

    private boolean isExtension(ElementDefinition currentBase) {
        return currentBase.getPath().endsWith(".extension") || currentBase.getPath().endsWith(".modifierExtension");
    }

    private boolean hasInnerDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, List<ElementDefinition> base, boolean allowSlices) throws DefinitionException {
        end = Math.min(context.getElement().size(), end);
        for (int i = start = Math.max(0, start); i <= end; ++i) {
            ElementDefinition ed = context.getElement().get(i);
            String statedPath = ed.getPath();
            if (!allowSlices && statedPath.equals(path) && ed.hasSliceName()) {
                return false;
            }
            if (statedPath.startsWith(path + ".")) {
                return true;
            }
            if (path.endsWith("[x]") && statedPath.startsWith(path.substring(0, path.length() - 3))) {
                return true;
            }
            if (i != start && !allowSlices && !statedPath.startsWith(path + ".") || i != start && allowSlices && !statedPath.startsWith(path)) break;
        }
        return false;
    }

    private List<ElementDefinition> getDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, String profileName) throws DefinitionException {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String[] p = path.split("\\.");
        for (int i = start; i <= end; ++i) {
            String statedPath = context.getElement().get(i).getPath();
            String[] sp = statedPath.split("\\.");
            boolean ok = sp.length == p.length;
            for (int j = 0; j < p.length; ++j) {
                ok = ok && sp.length > j && (p[j].equals(sp[j]) || this.isSameBase(p[j], sp[j]));
            }
            if (!ok) continue;
            result.add(context.getElement().get(i));
        }
        return result;
    }

    public boolean isSameBase(String p, String sp) {
        return p.endsWith("[x]") && sp.startsWith(p.substring(0, p.length() - 3)) || sp.endsWith("[x]") && p.startsWith(sp.substring(0, sp.length() - 3));
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionDifferentialComponent context, int cursor) {
        int result;
        if (cursor >= context.getElement().size()) {
            return result;
        }
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionSnapshotComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private boolean unbounded(ElementDefinition definition) {
        StringType max = definition.getMaxElement();
        if (max == null) {
            return false;
        }
        if (((String)max.getValue()).equals("1")) {
            return false;
        }
        return !((String)max.getValue()).equals("0");
    }

    private void updateFromDefinition(ElementDefinition dest, ElementDefinition source, String pn, boolean trimDifferential, String purl, StructureDefinition srcSD) throws DefinitionException, FHIRException {
        source.setUserData(GENERATED_IN_SNAPSHOT, dest);
        ElementDefinition base = dest;
        ElementDefinition derived = source;
        derived.setUserData(DERIVATION_POINTER, base);
        boolean isExtension = this.checkExtensionDoco(base);
        StructureDefinition profile = null;
        if (base.hasSliceName()) {
            StructureDefinition structureDefinition = profile = base.getType().size() == 1 && base.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, (String)base.getTypeFirstRep().getProfile().get(0).getValue()) : null;
        }
        if (profile == null) {
            StructureDefinition structureDefinition = profile = source.getType().size() == 1 && source.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, (String)source.getTypeFirstRep().getProfile().get(0).getValue()) : null;
        }
        if (profile != null) {
            Iterator<Element> e = profile.getSnapshot().getElement().get(0);
            String string = profile.getUserString("webroot");
            if (((ElementDefinition)((Object)e)).hasDefinition()) {
                base.setDefinition(ProfileUtilities.processRelativeUrls(((ElementDefinition)((Object)e)).getDefinition(), string, this.baseSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, true));
            }
            base.setShort(((ElementDefinition)((Object)e)).getShort());
            if (((ElementDefinition)((Object)e)).hasCommentElement()) {
                base.setCommentElement(((ElementDefinition)((Object)e)).getCommentElement());
            }
            if (((ElementDefinition)((Object)e)).hasRequirementsElement()) {
                base.setRequirementsElement(((ElementDefinition)((Object)e)).getRequirementsElement());
            }
            base.getAlias().clear();
            base.getAlias().addAll(((ElementDefinition)((Object)e)).getAlias());
            base.getMapping().clear();
            base.getMapping().addAll(((ElementDefinition)((Object)e)).getMapping());
        }
        if (derived != null) {
            if (derived.hasSliceName()) {
                base.setSliceName(derived.getSliceName());
            }
            if (derived.hasShortElement()) {
                if (!Base.compareDeep(derived.getShortElement(), base.getShortElement(), false)) {
                    base.setShortElement(derived.getShortElement().copy());
                } else if (trimDifferential) {
                    derived.setShortElement(null);
                } else if (derived.hasShortElement()) {
                    derived.getShortElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasDefinitionElement()) {
                if (derived.getDefinition().startsWith("...")) {
                    base.setDefinition(base.getDefinition() + "\r\n" + derived.getDefinition().substring(3));
                } else if (!Base.compareDeep(derived.getDefinitionElement(), base.getDefinitionElement(), false)) {
                    base.setDefinitionElement(derived.getDefinitionElement().copy());
                } else if (trimDifferential) {
                    derived.setDefinitionElement(null);
                } else if (derived.hasDefinitionElement()) {
                    derived.getDefinitionElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasCommentElement()) {
                if (derived.getComment().startsWith("...")) {
                    base.setComment(base.getComment() + "\r\n" + derived.getComment().substring(3));
                } else if (derived.hasCommentElement() != base.hasCommentElement() || !Base.compareDeep(derived.getCommentElement(), base.getCommentElement(), false)) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (trimDifferential) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (derived.hasCommentElement()) {
                    derived.getCommentElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasLabelElement()) {
                if (derived.getLabel().startsWith("...")) {
                    base.setLabel(base.getLabel() + "\r\n" + derived.getLabel().substring(3));
                } else if (!base.hasLabelElement() || !Base.compareDeep(derived.getLabelElement(), base.getLabelElement(), false)) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (trimDifferential) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (derived.hasLabelElement()) {
                    derived.getLabelElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirementsElement()) {
                if (derived.getRequirements().startsWith("...")) {
                    base.setRequirements(base.getRequirements() + "\r\n" + derived.getRequirements().substring(3));
                } else if (!base.hasRequirementsElement() || !Base.compareDeep(derived.getRequirementsElement(), base.getRequirementsElement(), false)) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (trimDifferential) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (derived.hasRequirementsElement()) {
                    derived.getRequirementsElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirements() && !base.getPath().contains(".")) {
                derived.setRequirements(null);
            }
            if (base.hasRequirements() && !base.getPath().contains(".")) {
                base.setRequirements(null);
            }
            if (derived.hasAlias()) {
                if (!Base.compareDeep(derived.getAlias(), base.getAlias(), false)) {
                    for (StringType stringType : derived.getAlias()) {
                        if (base.hasAlias((String)stringType.getValue())) continue;
                        base.getAlias().add(stringType.copy());
                    }
                } else if (trimDifferential) {
                    derived.getAlias().clear();
                } else {
                    for (StringType stringType : derived.getAlias()) {
                        stringType.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMinElement()) {
                if (!Base.compareDeep(derived.getMinElement(), base.getMinElement(), false)) {
                    if (derived.getMin() < base.getMin() && !derived.hasSliceName()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Element " + base.getPath() + ": derived min (" + Integer.toString(derived.getMin()) + ") cannot be less than base min (" + Integer.toString(base.getMin()) + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMinElement(derived.getMinElement().copy());
                } else if (trimDifferential) {
                    derived.setMinElement(null);
                } else {
                    derived.getMinElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxElement()) {
                if (!Base.compareDeep(derived.getMaxElement(), base.getMaxElement(), false)) {
                    if (this.isLargerMax(derived.getMax(), base.getMax())) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Element " + base.getPath() + ": derived max (" + derived.getMax() + ") cannot be greater than base max (" + base.getMax() + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMaxElement(derived.getMaxElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxElement(null);
                } else {
                    derived.getMaxElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasFixed()) {
                if (!Base.compareDeep(derived.getFixed(), base.getFixed(), true)) {
                    base.setFixed(derived.getFixed().copy());
                } else if (trimDifferential) {
                    derived.setFixed(null);
                } else {
                    derived.getFixed().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasPattern()) {
                if (!Base.compareDeep(derived.getPattern(), base.getPattern(), false)) {
                    base.setPattern(derived.getPattern().copy());
                } else if (trimDifferential) {
                    derived.setPattern(null);
                } else {
                    derived.getPattern().setUserData(DERIVATION_EQUALS, true);
                }
            }
            for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : derived.getExample()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionExampleComponent exS : base.getExample()) {
                    if (!Base.compareDeep(elementDefinitionExampleComponent, exS, false)) continue;
                    found = true;
                }
                if (!found) {
                    base.addExample(elementDefinitionExampleComponent.copy());
                    continue;
                }
                if (trimDifferential) {
                    derived.getExample().remove(elementDefinitionExampleComponent);
                    continue;
                }
                elementDefinitionExampleComponent.setUserData(DERIVATION_EQUALS, true);
            }
            if (derived.hasMaxLengthElement()) {
                if (!Base.compareDeep(derived.getMaxLengthElement(), base.getMaxLengthElement(), false)) {
                    base.setMaxLengthElement(derived.getMaxLengthElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxLengthElement(null);
                } else {
                    derived.getMaxLengthElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxValue()) {
                if (!Base.compareDeep(derived.getMaxValue(), base.getMaxValue(), false)) {
                    base.setMaxValue(derived.getMaxValue().copy());
                } else if (trimDifferential) {
                    derived.setMaxValue(null);
                } else {
                    derived.getMaxValue().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMinValue()) {
                if (!Base.compareDeep(derived.getMinValue(), base.getMinValue(), false)) {
                    base.setMinValue(derived.getMinValue().copy());
                } else if (trimDifferential) {
                    derived.setMinValue(null);
                } else {
                    derived.getMinValue().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMustSupportElement()) {
                if (!base.hasMustSupportElement() || !Base.compareDeep(derived.getMustSupportElement(), base.getMustSupportElement(), false)) {
                    if (base.hasMustSupport() && base.getMustSupport() && !derived.getMustSupport()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Illegal constraint [must-support = false] when [must-support = true] in the base profile", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMustSupportElement(derived.getMustSupportElement().copy());
                } else if (trimDifferential) {
                    derived.setMustSupportElement(null);
                } else {
                    derived.getMustSupportElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (isExtension) {
                if (!(!derived.hasIsModifierElement() || base.hasIsModifierElement() && Base.compareDeep(derived.getIsModifierElement(), base.getIsModifierElement(), false))) {
                    base.setIsModifierElement(derived.getIsModifierElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierElement(null);
                } else if (derived.hasIsModifierElement()) {
                    derived.getIsModifierElement().setUserData(DERIVATION_EQUALS, true);
                }
                if (!(!derived.hasIsModifierReasonElement() || base.hasIsModifierReasonElement() && Base.compareDeep(derived.getIsModifierReasonElement(), base.getIsModifierReasonElement(), false))) {
                    base.setIsModifierReasonElement(derived.getIsModifierReasonElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierReasonElement(null);
                } else if (derived.hasIsModifierReasonElement()) {
                    derived.getIsModifierReasonElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasBinding()) {
                if (!base.hasBinding() || !Base.compareDeep(derived.getBinding(), base.getBinding(), false)) {
                    if (base.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && derived.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "illegal attempt to change the binding on " + derived.getPath() + " from " + base.getBinding().getStrength().toCode() + " to " + derived.getBinding().getStrength().toCode(), ValidationMessage.IssueSeverity.ERROR));
                    } else if (base.hasBinding() && derived.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && base.getBinding().hasValueSet() && derived.getBinding().hasValueSet()) {
                        ValueSet baseVs = this.context.fetchResource(ValueSet.class, base.getBinding().getValueSet());
                        ValueSet valueSet = this.context.fetchResource(ValueSet.class, derived.getBinding().getValueSet());
                        if (baseVs == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSet() + " could not be located", ValidationMessage.IssueSeverity.WARNING));
                        } else if (valueSet == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " could not be located", ValidationMessage.IssueSeverity.WARNING));
                        } else {
                            ValueSetExpander.ValueSetExpansionOutcome expBase = this.context.expandVS(baseVs, true, false);
                            ValueSetExpander.ValueSetExpansionOutcome expDerived = this.context.expandVS(valueSet, true, false);
                            if (expBase.getValueset() == null) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSet() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                            } else if (expDerived.getValueset() == null) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                            } else if (ToolingExtensions.hasExtension(expBase.getValueset().getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Unable to check if " + derived.getBinding().getValueSet() + " is a proper subset of " + base.getBinding().getValueSet() + " - base value set is too large to check", ValidationMessage.IssueSeverity.WARNING));
                            } else if (!this.isSubset(expBase.getValueset(), expDerived.getValueset())) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " is not a subset of binding " + base.getBinding().getValueSet(), ValidationMessage.IssueSeverity.ERROR));
                            }
                        }
                    }
                    ElementDefinition.ElementDefinitionBindingComponent d = derived.getBinding();
                    ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = base.getBinding().copy();
                    elementDefinitionBindingComponent.getExtension().clear();
                    elementDefinitionBindingComponent.setDescription(null);
                    elementDefinitionBindingComponent.getExtension().addAll(d.getExtension());
                    if (d.hasStrength()) {
                        elementDefinitionBindingComponent.setStrength(d.getStrength());
                    }
                    if (d.hasDescription()) {
                        elementDefinitionBindingComponent.setDescription(d.getDescription());
                    }
                    if (d.hasValueSet()) {
                        elementDefinitionBindingComponent.setValueSet(d.getValueSet());
                    }
                    base.setBinding(elementDefinitionBindingComponent);
                } else if (trimDifferential) {
                    derived.setBinding(null);
                } else {
                    derived.getBinding().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasIsSummaryElement()) {
                if (!Base.compareDeep(derived.getIsSummaryElement(), base.getIsSummaryElement(), false)) {
                    if (base.hasIsSummary() && !this.context.getVersion().equals("1.4.0")) {
                        throw new Error(this.context.formatMessage("Error_in_profile__at__Base_isSummary___derived_isSummary__", purl, derived.getPath(), base.getIsSummaryElement().asStringValue(), derived.getIsSummaryElement().asStringValue()));
                    }
                    base.setIsSummaryElement(derived.getIsSummaryElement().copy());
                } else if (trimDifferential) {
                    derived.setIsSummaryElement(null);
                } else {
                    derived.getIsSummaryElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasType()) {
                if (!Base.compareDeep(derived.getType(), base.getType(), false)) {
                    if (base.hasType()) {
                        for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                            this.checkTypeDerivation(purl, srcSD, base, derived, typeRefComponent);
                        }
                    }
                    base.getType().clear();
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        ElementDefinition.TypeRefComponent tt = typeRefComponent.copy();
                        base.getType().add(tt);
                    }
                } else if (trimDifferential) {
                    derived.getType().clear();
                } else {
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        typeRefComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMapping()) {
                if (!Base.compareDeep(derived.getMapping(), base.getMapping(), false)) {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        boolean found = false;
                        for (ElementDefinition.ElementDefinitionMappingComponent d : base.getMapping()) {
                            found = found || d.getIdentity().equals(elementDefinitionMappingComponent.getIdentity()) && d.getMap().equals(elementDefinitionMappingComponent.getMap());
                        }
                        if (found) continue;
                        base.getMapping().add(elementDefinitionMappingComponent);
                    }
                } else if (trimDifferential) {
                    derived.getMapping().clear();
                } else {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        elementDefinitionMappingComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : base.getMapping()) {
                if (!elementDefinitionMappingComponent.hasMap()) continue;
                elementDefinitionMappingComponent.setMap(elementDefinitionMappingComponent.getMap().trim());
            }
            for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : base.getConstraint()) {
                elementDefinitionConstraintComponent.setUserData(IS_DERIVED, true);
                if (elementDefinitionConstraintComponent.hasSource()) continue;
                elementDefinitionConstraintComponent.setSource(srcSD.getUrl());
            }
            if (derived.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : derived.getConstraint()) {
                    if (base.hasConstraint(elementDefinitionConstraintComponent.getKey())) continue;
                    ElementDefinition.ElementDefinitionConstraintComponent inv = elementDefinitionConstraintComponent.copy();
                    base.getConstraint().add(inv);
                }
            }
            for (IdType idType : derived.getCondition()) {
                if (base.hasCondition(idType)) continue;
                base.getCondition().add(idType);
            }
            if (dest.hasBinding() && !this.hasBindableType(dest)) {
                dest.setBinding(null);
            }
            for (Extension extension : derived.getExtension()) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, extension.getUrl());
                if (sd == null || sd.getSnapshot() == null || sd.getSnapshot().getElementFirstRep().getMax().equals("1")) {
                    ToolingExtensions.removeExtension(dest, extension.getUrl());
                }
                dest.addExtension(extension.copy());
            }
        }
        if (dest.hasFixed()) {
            this.checkTypeOk(dest, dest.getFixed().fhirType(), srcSD);
        }
        if (dest.hasPattern()) {
            this.checkTypeOk(dest, dest.getPattern().fhirType(), srcSD);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkTypeDerivation(String purl, StructureDefinition srcSD, ElementDefinition base, ElementDefinition derived, ElementDefinition.TypeRefComponent ts) {
        boolean ok = false;
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        String t = ts.getWorkingCode();
        for (ElementDefinition.TypeRefComponent td : base.getType()) {
            StructureDefinition sdt;
            String tt = td.getWorkingCode();
            b.append(tt);
            if (td.hasCode() && tt.equals(t)) {
                ok = true;
            }
            if (!ok && (sdt = this.context.fetchTypeDefinition(tt)) != null && (sdt.getAbstract() || sdt.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL)) {
                void var13_15;
                StructureDefinition structureDefinition = this.context.fetchTypeDefinition(t);
                while (var13_15 != null && !ok) {
                    ok = var13_15.getType().equals(sdt.getType());
                    StructureDefinition structureDefinition2 = this.context.fetchResource(StructureDefinition.class, var13_15.getBaseDefinition());
                }
            }
            if (!ok || !ts.hasTargetProfile()) continue;
            for (UriType uriType : ts.getTargetProfile()) {
                boolean tgtOk;
                String url = (String)uriType.getValue();
                boolean bl = tgtOk = !td.hasTargetProfile() || td.hasTargetProfile(url);
                while (url != null && !tgtOk) {
                    StructureDefinition sd = this.context.fetchRawProfile(url);
                    if (sd == null) {
                        if (this.messages != null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, purl + "#" + derived.getPath(), "Cannot check whether the target profile " + url + " is valid constraint on the base because it is not known", ValidationMessage.IssueSeverity.WARNING));
                        }
                        url = null;
                        tgtOk = true;
                        continue;
                    }
                    url = sd.getBaseDefinition();
                    tgtOk = td.hasTargetProfile(url);
                }
                if (tgtOk) continue;
                if (this.messages == null) {
                    throw new FHIRException(this.context.formatMessage("Error_at__The_target_profile__is_not__valid_constraint_on_the_base_", purl, derived.getPath(), url, td.getTargetProfile()));
                }
                this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, derived.getPath(), "The target profile " + (String)uriType.getValue() + " is not a valid constraint on the base (" + td.getTargetProfile() + ") at " + derived.getPath(), ValidationMessage.IssueSeverity.ERROR));
            }
        }
        if (!ok) {
            throw new DefinitionException(this.context.formatMessage("StructureDefinition__at__illegal_constrained_type__from__in_", purl, derived.getPath(), t, b.toString(), srcSD.getUrl()));
        }
    }

    public void checkTypeOk(ElementDefinition dest, String ft, StructureDefinition sd) {
        boolean ok = false;
        HashSet<String> types = new HashSet<String>();
        if (dest.getPath().contains(".")) {
            for (ElementDefinition.TypeRefComponent t : dest.getType()) {
                if (t.hasCode()) {
                    types.add(t.getWorkingCode());
                }
                ok = ft.equals(t.getWorkingCode());
            }
        } else {
            types.add(sd.getType());
            ok = ft.equals(sd.getType());
        }
        if (!ok) {
            this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.CONFLICT, dest.getId(), "The fixed value has type '" + ft + "' which is not valid (valid " + Utilities.pluralize((String)"type", (int)dest.getType().size()) + ": " + ((Object)types).toString() + ")", ValidationMessage.IssueSeverity.ERROR));
        }
    }

    private boolean hasBindableType(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (Utilities.existsInList((String)tr.getWorkingCode(), (String[])new String[]{"Coding", "CodeableConcept", "Quantity", "uri", "string", "code"})) {
                return true;
            }
            StructureDefinition sd = this.context.fetchTypeDefinition(tr.getCode());
            if (sd == null || !sd.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-binding-style")) continue;
            return true;
        }
        return false;
    }

    private boolean isLargerMax(String derived, String base) {
        if ("*".equals(base)) {
            return false;
        }
        if ("*".equals(derived)) {
            return true;
        }
        return Integer.parseInt(derived) > Integer.parseInt(base);
    }

    private boolean isSubset(ValueSet expBase, ValueSet expDerived) {
        return this.codesInExpansion(expDerived.getExpansion().getContains(), expBase.getExpansion());
    }

    private boolean codesInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> contains, ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (!this.inExpansion(cc, expansion.getContains())) {
                return false;
            }
            if (this.codesInExpansion(cc.getContains(), expansion)) continue;
            return false;
        }
        return true;
    }

    private boolean inExpansion(ValueSet.ValueSetExpansionContainsComponent cc, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : contains) {
            if (cc.getSystem().equals(cc1.getSystem()) && cc.getCode().equals(cc1.getCode())) {
                return true;
            }
            if (!this.inExpansion(cc, cc1.getContains())) continue;
            return true;
        }
        return false;
    }

    public void closeDifferential(StructureDefinition base, StructureDefinition derived) throws FHIRException {
        for (ElementDefinition edb : base.getSnapshot().getElement()) {
            if (!this.isImmediateChild(edb) || edb.getPath().endsWith(".id")) continue;
            ElementDefinition edm = this.getMatchInDerived(edb, derived.getDifferential().getElement());
            if (edm == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edb.getPath());
                edd.setMax("0");
                continue;
            }
            if (!edb.hasSlicing()) continue;
            this.closeChildren(base, edb, derived, edm);
        }
        this.sortDifferential(base, derived, derived.getName(), new ArrayList<String>(), false);
    }

    private void closeChildren(StructureDefinition base, ElementDefinition edb, StructureDefinition derived, ElementDefinition edm) {
        String path = edb.getPath() + ".";
        int baseStart = base.getSnapshot().getElement().indexOf(edb);
        int baseEnd = this.findEnd(base.getSnapshot().getElement(), edb, baseStart + 1);
        int diffStart = derived.getDifferential().getElement().indexOf(edm);
        int diffEnd = this.findEnd(derived.getDifferential().getElement(), edm, diffStart + 1);
        for (int cBase = baseStart; cBase < baseEnd; ++cBase) {
            ElementDefinition edBase = base.getSnapshot().getElement().get(cBase);
            if (!this.isImmediateChild(edBase, edb)) continue;
            ElementDefinition edMatch = this.getMatchInDerived(edBase, derived.getDifferential().getElement(), diffStart, diffEnd);
            if (edMatch == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edBase.getPath());
                edd.setMax("0");
                continue;
            }
            this.closeChildren(base, edBase, derived, edMatch);
        }
    }

    private int findEnd(List<ElementDefinition> list, ElementDefinition ed, int cursor) {
        String path = ed.getPath() + ".";
        while (cursor < list.size() && list.get(cursor).getPath().startsWith(path)) {
            ++cursor;
        }
        return cursor;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list) {
        for (ElementDefinition t : list) {
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list, int start, int end) {
        for (int i = start; i < end; ++i) {
            ElementDefinition t = list.get(i);
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private boolean isImmediateChild(ElementDefinition ed) {
        String p = ed.getPath();
        if (!p.contains(".")) {
            return false;
        }
        return !(p = p.substring(p.indexOf(".") + 1)).contains(".");
    }

    private boolean isImmediateChild(ElementDefinition candidate, ElementDefinition base) {
        String p = candidate.getPath();
        if (!p.contains(".")) {
            return false;
        }
        if (!p.startsWith(base.getPath() + ".")) {
            return false;
        }
        return !(p = p.substring(base.getPath().length() + 1)).contains(".");
    }

    public XhtmlNode generateExtensionTable(String defFile, StructureDefinition ed, String imageFolder, boolean inlineGraphics, boolean full, String corePath, String imagePath, Set<String> outputTracker, RenderingContext rc) throws IOException, FHIRException {
        List<ElementDefinition> children;
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, ed.getId() + (full ? "f" : "n"), true);
        boolean deep = false;
        String m = "";
        boolean vdeep = false;
        if (ed.getSnapshot().getElementFirstRep().getIsModifier()) {
            m = "modifier_";
        }
        for (ElementDefinition eld : ed.getSnapshot().getElement()) {
            deep = deep || eld.getPath().contains("Extension.extension.");
            vdeep = vdeep || eld.getPath().contains("Extension.extension.extension.");
        }
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(r);
        String en = !full ? ed.getName() : (ed.getSnapshot().getElement().get(0).getIsModifier() ? "modifierExtension" : "extension");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName(), en, null, null));
        r.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.describeCardinality(ed.getSnapshot().getElement().get(0), null, new UnusedTracker()), null, null));
        ElementDefinition ved = null;
        if (full || vdeep) {
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, "", "", "Extension", null, null));
            r.setIcon(deep ? "icon_" + m + "extension_complex.png" : "icon_extension_simple.png", deep ? "Complex Extension" : "Simple Extension");
            children = this.getChildren(ed.getSnapshot().getElement(), ed.getSnapshot().getElement().get(0));
            for (ElementDefinition child : children) {
                if (child.getPath().endsWith(".id")) continue;
                ArrayList<StructureDefinition> sdl = new ArrayList<StructureDefinition>();
                sdl.add(ed);
                this.genElement(defFile == null ? "" : defFile + "-definitions.html#extension.", gen, r.getSubRows(), child, ed.getSnapshot().getElement(), sdl, true, defFile, true, full, corePath, imagePath, true, false, false, false, null, false, rc);
            }
        } else if (deep) {
            children = new ArrayList();
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().equals("Extension.extension")) continue;
                children.add(ted);
            }
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, "", "", "Extension", null, null));
            r.setIcon("icon_" + m + "extension_complex.png", "Complex Extension");
            for (ElementDefinition c : children) {
                ved = this.getValueFor(ed, c);
                ElementDefinition ued = this.getUrlFor(ed, c);
                if (ved == null || ued == null) continue;
                HierarchicalTableGenerator.Row r1 = new HierarchicalTableGenerator.Row(gen);
                r.getSubRows().add(r1);
                List list5 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName(), (String)((UriType)ued.getFixed()).getValue(), null, null));
                r1.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List list6 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, this.describeCardinality(c, null, new UnusedTracker()), null, null));
                this.genTypes(gen, r1, ved, defFile, ed, corePath, imagePath, false, false);
                HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
                cell.addMarkdown(c.getDefinition());
                r1.getCells().add(cell);
                r1.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
            }
        } else {
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().startsWith("Extension.value")) continue;
                ved = ted;
            }
            this.genTypes(gen, r, ved, defFile, ed, corePath, imagePath, false, false);
            r.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, "", "", "URL = " + ed.getUrl(), null, null);
        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator8);
        HierarchicalTableGenerator.Piece cc = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ed.getName() + ": ", null);
        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator9);
        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br")).addPiece(cc);
        c.addMarkdown(ed.getDescription());
        if (!full && !deep && !vdeep && ved != null && ved.hasBinding()) {
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, "br"));
            ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(ed, ved.getBinding(), ved.getPath());
            List list7 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator11);
            list7.add(this.checkForNoChange(elementDefinitionBindingComponent, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
            List list8 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent2 = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list8.add(this.checkForNoChange(elementDefinitionBindingComponent2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
            if (ved.getBinding().hasStrength()) {
                List list9 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent3 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator13);
                list9.add(this.checkForNoChange(elementDefinitionBindingComponent3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, " (", null)));
                List list10 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent4 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator14);
                list10.add(this.checkForNoChange(elementDefinitionBindingComponent4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, corePath + "terminologies.html#" + ved.getBinding().getStrength().toCode(), this.egt(ved.getBinding().getStrengthElement()), ved.getBinding().getStrength().getDefinition())));
                List list11 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, ")", null));
            }
            if (ved.getBinding().hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)ved.getBinding().getDescription())) {
                List list12 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator16);
                list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, ": ", null));
                c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context, ved.getBinding().getDescriptionElement()).asStringValue());
            }
        }
        HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator17);
        HierarchicalTableGenerator.Cell cell = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator18);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, ProfileUtilities.describeExtensionContext(ed), null));
        r.getCells().add(c);
        try {
            return gen.generate(model, corePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    private ElementDefinition getUrlFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().equals(c.getPath() + ".url")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private ElementDefinition getValueFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + ".value")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private HierarchicalTableGenerator.Cell genTypes(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row r, ElementDefinition e, String profileBaseFileName, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean mustSupportMode) {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(c);
        if (e.hasContentReference()) {
            ElementInStructure ed = this.getElementByName(profile.getSnapshot().getElement(), e.getContentReference(), profile);
            if (ed == null) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Unknown reference to %s", new Object[]{e.getContentReference()}), null));
            } else if (ed.getSource() == profile) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "See ", new Object[]{ed.getElement().getPath()}), null));
                List list2 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, "#" + ed.getElement().getPath(), this.tail(ed.getElement().getPath()), ed.getElement().getPath()));
            } else {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "See ", new Object[]{ed.getElement().getPath()}), null));
                List list3 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, this.pfx(corePath, ed.getSource().getUserString("path")) + "#" + ed.getElement().getPath(), this.tail(ed.getElement().getPath()) + " (" + ed.getSource().getType() + ")", ed.getElement().getPath()));
            }
            return c;
        }
        List<ElementDefinition.TypeRefComponent> types = e.getType();
        if (!e.hasType()) {
            if (root) {
                StructureDefinition bsd;
                StructureDefinition structureDefinition = bsd = profile == null ? null : this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition());
                if (bsd != null) {
                    if (bsd.hasUserData("path")) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, Utilities.isAbsoluteUrl((String)bsd.getUserString("path")) ? bsd.getUserString("path") : imagePath + bsd.getUserString("path"), bsd.getName(), null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, bsd.getName(), null));
                    }
                }
                return c;
            }
            if (e.hasContentReference()) {
                return c;
            }
            ElementDefinition d = (ElementDefinition)e.getUserData(DERIVATION_POINTER);
            if (d != null && d.hasType()) {
                types = new ArrayList<ElementDefinition.TypeRefComponent>();
                for (ElementDefinition.TypeRefComponent tr : d.getType()) {
                    ElementDefinition.TypeRefComponent tt = tr.copy();
                    tt.setUserData(DERIVATION_EQUALS, true);
                    types.add(tt);
                }
            } else {
                return c;
            }
        }
        boolean first = true;
        ElementDefinition.TypeRefComponent tl = null;
        for (ElementDefinition.TypeRefComponent t : types) {
            if (mustSupportMode && !ProfileUtilities.allTypesMustSupport(e) && !ProfileUtilities.isMustSupport(t)) continue;
            if (first) {
                first = false;
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
            }
            tl = t;
            if (t.hasTarget()) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", t.getWorkingCode(), null));
                if (!mustSupportMode && ProfileUtilities.isMustSupportDirect(t) && e.getMustSupport()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                }
                List list4 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "(", null));
                boolean tfirst = true;
                for (CanonicalType u : t.getTargetProfile()) {
                    if (mustSupportMode && !ProfileUtilities.allProfilesMustSupport(t.getTargetProfile()) && !ProfileUtilities.isMustSupport(u)) continue;
                    if (tfirst) {
                        tfirst = false;
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator6);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, " | ", null));
                    }
                    this.genTargetLink(gen, profileBaseFileName, corePath, c, t, (String)u.getValue());
                    if (mustSupportMode || !ProfileUtilities.isMustSupport(u) || !e.getMustSupport()) continue;
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This target must be supported"), "S", "white", "red", null, false);
                }
                List list5 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ")", null));
                if (t.getAggregation().size() <= 0) continue;
                List list6 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, corePath + "valueset-resource-aggregation-mode.html", " {", null));
                boolean firstA = true;
                for (Enumeration enumeration : t.getAggregation()) {
                    firstA = true;
                    if (true) {
                        firstA = false;
                    } else {
                        List list7 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, corePath + "valueset-resource-aggregation-mode.html", ", ", null));
                    }
                    List list8 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, corePath + "valueset-resource-aggregation-mode.html", ProfileUtilities.codeForAggregation((ElementDefinition.AggregationMode)((Object)enumeration.getValue())), ProfileUtilities.hintForAggregation((ElementDefinition.AggregationMode)((Object)enumeration.getValue()))));
                }
                List list9 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, corePath + "valueset-resource-aggregation-mode.html", "}", null));
                continue;
            }
            if (t.hasProfile() && (!t.getWorkingCode().equals("Extension") || this.isProfiledType(t.getProfile()))) {
                boolean pfirst = true;
                for (CanonicalType canonicalType : t.getProfile()) {
                    String ref;
                    if (mustSupportMode && !ProfileUtilities.allProfilesMustSupport(t.getProfile()) && !ProfileUtilities.isMustSupport(canonicalType)) continue;
                    if (pfirst) {
                        pfirst = false;
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
                    }
                    String string = ref = this.pkp == null ? null : this.pkp.getLinkForProfile(profile, (String)canonicalType.getValue());
                    if (ref != null) {
                        String[] parts = ref.split("\\|");
                        if (parts[0].startsWith("http:") || parts[0].startsWith("https:")) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, parts[0], parts[1], t.getWorkingCode())));
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (((String)canonicalType.getValue()).startsWith(corePath + "StructureDefinition") ? corePath : "") + parts[0], parts[1], t.getWorkingCode())));
                        }
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (((String)canonicalType.getValue()).startsWith(corePath) ? corePath : "") + ref, t.getWorkingCode(), null)));
                    }
                    if (mustSupportMode || !ProfileUtilities.isMustSupport(canonicalType) || !e.getMustSupport()) continue;
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This profile must be supported"), "S", "white", "red", null, false);
                }
                continue;
            }
            String tc = t.getWorkingCode();
            if (Utilities.isAbsoluteUrl((String)tc)) {
                StructureDefinition sd = this.context.fetchTypeDefinition(tc);
                if (sd == null) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, tc), tc, null)));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, tc), sd.getType(), null)));
                }
            } else if (this.pkp != null && this.pkp.hasLinkFor(tc)) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, tc), tc, null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, tc, null)));
            }
            if (mustSupportMode || !ProfileUtilities.isMustSupportDirect(t) || !e.getMustSupport()) continue;
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " ", null));
            c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
        }
        return c;
    }

    private String pfx(String prefix, String url) {
        return Utilities.isAbsoluteUrl((String)url) ? url : prefix + url;
    }

    public void genTargetLink(HierarchicalTableGenerator gen, String profileBaseFileName, String corePath, HierarchicalTableGenerator.Cell c, ElementDefinition.TypeRefComponent t, String u) {
        if (u.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, u);
            if (sd != null) {
                String disp = sd.hasTitle() ? sd.getTitle() : sd.getName();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.checkPrepend(corePath, sd.getUserString("path")), disp, null)));
            } else {
                String rn = u.substring(40);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.pkp.getLinkFor(corePath, rn), rn, null)));
            }
        } else if (Utilities.isAbsoluteUrl((String)u)) {
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, u);
            if (sd != null && this.pkp != null) {
                String disp = sd.hasTitle() ? sd.getTitle() : sd.getName();
                String ref = this.pkp.getLinkForProfile(null, sd.getUrl());
                if (ref != null && ref.contains("|")) {
                    ref = ref.substring(0, ref.indexOf("|"));
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, disp, null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, u, null)));
            }
        } else if (t.hasTargetProfile() && u.startsWith("#")) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + profileBaseFileName + "." + u.substring(1).toLowerCase() + ".html", u, null)));
        }
    }

    private boolean isProfiledType(List<CanonicalType> theProfile) {
        for (CanonicalType next : theProfile) {
            if (!StringUtils.defaultString((String)next.getValueAsString()).contains(":")) continue;
            return true;
        }
        return false;
    }

    public static String codeForAggregation(ElementDefinition.AggregationMode a) {
        switch (a) {
            case BUNDLED: {
                return "b";
            }
            case CONTAINED: {
                return "c";
            }
            case REFERENCED: {
                return "r";
            }
        }
        return "?";
    }

    public static String hintForAggregation(ElementDefinition.AggregationMode a) {
        if (a != null) {
            return a.getDefinition();
        }
        return null;
    }

    private String checkPrepend(String corePath, String path) {
        if (this.pkp != null && this.pkp.prependLinks() && !path.startsWith("http:") && !path.startsWith("https:")) {
            return corePath + path;
        }
        return path;
    }

    private ElementInStructure getElementByName(List<ElementDefinition> elements, String contentReference, StructureDefinition source) {
        if (contentReference.contains("#")) {
            String url = contentReference.substring(0, contentReference.indexOf("#"));
            contentReference = contentReference.substring(contentReference.indexOf("#"));
            if (Utilities.noString((String)url)) {
                url = source.getUrl();
            }
            if (!url.equals(source.getUrl())) {
                source = this.context.fetchResource(StructureDefinition.class, url);
                if (source == null) {
                    throw new FHIRException("Unable to resolve StructureDefinition " + url + " resolving content reference " + contentReference);
                }
                elements = source.getSnapshot().getElement();
            }
        }
        for (ElementDefinition ed : elements) {
            if (("#" + ed.getPath()).equals(contentReference)) {
                return new ElementInStructure(source, ed);
            }
            if (!("#" + ed.getId()).equals(contentReference)) continue;
            return new ElementInStructure(source, ed);
        }
        throw new Error("getElementByName: can't find " + contentReference + " in " + elements.toString() + " from " + source.getUrl());
    }

    private ElementDefinitionResolution getElementById(StructureDefinition source, List<ElementDefinition> elements, String contentReference) {
        if (!contentReference.startsWith("#") && contentReference.contains("#")) {
            String url = contentReference.substring(0, contentReference.indexOf("#"));
            contentReference = contentReference.substring(contentReference.indexOf("#"));
            if (!url.equals(source.getUrl())) {
                source = this.context.fetchResource(StructureDefinition.class, url);
                if (source == null) {
                    return null;
                }
                elements = source.getSnapshot().getElement();
            }
        }
        for (ElementDefinition ed : elements) {
            if (!ed.hasId() || !("#" + ed.getId()).equals(contentReference)) continue;
            return new ElementDefinitionResolution(source, ed);
        }
        return null;
    }

    public static String describeExtensionContext(StructureDefinition ext) {
        StringBuilder b = new StringBuilder();
        b.append("Use on ");
        for (int i = 0; i < ext.getContext().size(); ++i) {
            StructureDefinition.StructureDefinitionContextComponent ec = ext.getContext().get(i);
            if (i > 0) {
                b.append(i < ext.getContext().size() - 1 ? ", " : " or ");
            }
            b.append(ec.getType().getDisplay());
            b.append(" ");
            b.append(ec.getExpression());
        }
        if (ext.hasContextInvariant()) {
            b.append(", with <a href=\"structuredefinition-definitions.html#StructureDefinition.contextInvariant\">Context Invariant</a> = ");
            boolean first = true;
            for (StringType s : ext.getContextInvariant()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append("<code>" + (String)s.getValue() + "</code>");
            }
        }
        return b.toString();
    }

    private String describeCardinality(ElementDefinition definition, ElementDefinition fallback, UnusedTracker tracker) {
        StringType max;
        IntegerType min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType();
        StringType stringType = max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType();
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        tracker.used = !max.isEmpty() && !((String)max.getValue()).equals("0");
        if (min.isEmpty() && max.isEmpty()) {
            return null;
        }
        return (!min.hasValue() ? "" : Integer.toString((Integer)min.getValue())) + ".." + (!max.hasValue() ? "" : (String)max.getValue());
    }

    private HierarchicalTableGenerator.Cell genCardinality(HierarchicalTableGenerator gen, ElementDefinition definition, HierarchicalTableGenerator.Row row, boolean hasDef, UnusedTracker tracker, ElementDefinition fallback) {
        ElementDefinition base;
        StringType max;
        IntegerType min;
        IntegerType integerType = !hasDef ? new IntegerType() : (min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType());
        StringType stringType = !hasDef ? new StringType() : (max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType());
        if (min.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null && (base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER)).hasMinElement()) {
            min = base.getMinElement().copy();
            min.setUserData(DERIVATION_EQUALS, true);
        }
        if (max.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null && (base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER)).hasMaxElement()) {
            max = base.getMaxElement().copy();
            max.setUserData(DERIVATION_EQUALS, true);
        }
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        if (!max.isEmpty()) {
            tracker.used = !((String)max.getValue()).equals("0");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
        row.getCells().add(cell);
        if (!min.isEmpty() || !max.isEmpty()) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            cell.addPiece(this.checkForNoChange(min, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, !min.hasValue() ? "" : Integer.toString((Integer)min.getValue()), null)));
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            cell.addPiece(this.checkForNoChange(min, max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "..", null)));
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            cell.addPiece(this.checkForNoChange(max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, !max.hasValue() ? "" : (String)max.getValue(), null)));
        }
        return cell;
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element source, HierarchicalTableGenerator.Piece piece) {
        if (source.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    private String checkForNoChange(Element source) {
        if (source.hasUserData(DERIVATION_EQUALS)) {
            return "opacity: 0.5";
        }
        return null;
    }

    private HierarchicalTableGenerator.Piece applyAsUnchanged(HierarchicalTableGenerator.Piece piece) {
        piece.addStyle("opacity: 0.5");
        return piece;
    }

    private String applyAsUnchanged() {
        return "opacity: 0.5";
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element src1, Element src2, HierarchicalTableGenerator.Piece piece) {
        if (src1.hasUserData(DERIVATION_EQUALS) && src2.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    public XhtmlNode generateTable(String defFile, StructureDefinition profile, boolean diff, String imageFolder, boolean inlineGraphics, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean logicalModel, boolean allInvariants, Set<String> outputTracker, boolean active, boolean mustSupport, RenderingContext rc) throws IOException, FHIRException {
        ElementDefinition root;
        assert (diff != snapshot);
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, profile.getId() + (diff ? "d" : "s"), active);
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        if (diff) {
            list.addAll(profile.getDifferential().getElement());
        } else {
            list.addAll(profile.getSnapshot().getElement());
        }
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        if (list.isEmpty()) {
            root = new ElementDefinition().setPath(profile.getType());
            root.setId(profile.getType());
            list.add(root);
        } else if (((ElementDefinition)list.get(0)).getPath().contains(".")) {
            root = new ElementDefinition().setPath(profile.getType());
            root.setId(profile.getType());
            list.add(0, root);
        }
        if (diff) {
            this.insertMissingSparseElements(list);
        }
        this.genElement(defFile == null ? null : defFile + "#", gen, model.getRows(), (ElementDefinition)list.get(0), list, profiles, diff, profileBaseFileName, null, snapshot, corePath, imagePath, true, logicalModel, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list), allInvariants, null, mustSupport, rc);
        try {
            return gen.generate(model, imagePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(this.context.formatMessage("Error_generating_table_for_profile__", profile.getUrl(), e.getMessage()), (Throwable)e);
        }
    }

    private void insertMissingSparseElements(List<ElementDefinition> list) {
        for (int i = 1; i < list.size(); ++i) {
            int firstDiff;
            String[] pathCurrent = list.get(i).getPath().split("\\.");
            String[] pathLast = list.get(i - 1).getPath().split("\\.");
            for (firstDiff = 0; firstDiff < pathCurrent.length && firstDiff < pathLast.length && pathCurrent[firstDiff].equals(pathLast[firstDiff]); ++firstDiff) {
            }
            if (this.isSibling(pathCurrent, pathLast, firstDiff) || this.isChild(pathCurrent, pathLast, firstDiff)) continue;
            ElementDefinition parent = this.findParent(list, i, list.get(i).getPath());
            int parentDepth = Utilities.charCount((String)parent.getPath(), (char)'.') + 1;
            int childDepth = Utilities.charCount((String)list.get(i).getPath(), (char)'.') + 1;
            if (childDepth <= parentDepth + 1) continue;
            String basePath = parent.getPath();
            String baseId = parent.getId();
            for (int index = parentDepth; index >= firstDiff; --index) {
                String mtail = this.makeTail(pathCurrent, parentDepth, index);
                ElementDefinition root = new ElementDefinition().setPath(basePath + "." + mtail);
                root.setId(baseId + "." + mtail);
                list.add(i, root);
            }
        }
    }

    private ElementDefinition findParent(List<ElementDefinition> list, int i, String path) {
        while (i > 0 && !path.startsWith(list.get(i).getPath() + ".")) {
            --i;
        }
        return list.get(i);
    }

    private boolean isSibling(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length && firstDiff == pathCurrent.length - 1;
    }

    private boolean isChild(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length + 1 && firstDiff == pathLast.length;
    }

    private String makeTail(String[] pathCurrent, int start, int index) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(".");
        for (int i = start; i <= index; ++i) {
            b.append(pathCurrent[i]);
        }
        return b.toString();
    }

    private String makePath(String[] pathCurrent, int index) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(".");
        for (int i = 0; i <= index; ++i) {
            b.append(pathCurrent[i]);
        }
        return b.toString();
    }

    public XhtmlNode generateGrid(String defFile, StructureDefinition profile, String imageFolder, boolean inlineGraphics, String profileBaseFileName, String corePath, String imagePath, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = gen.initGridTable(corePath, profile.getId());
        List<ElementDefinition> list = profile.getSnapshot().getElement();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.genGridElement(defFile == null ? null : defFile + "#", gen, model.getRows(), list.get(0), list, profiles, true, profileBaseFileName, null, corePath, imagePath, true, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list));
        try {
            return gen.generate(model, imagePath, 1, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean usesMustSupport(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.hasMustSupport() || !ed.getMustSupport()) continue;
            return true;
        }
        return false;
    }

    private HierarchicalTableGenerator.Row genElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean isConstraintMode, boolean allInvariants, HierarchicalTableGenerator.Row slicingRow, boolean mustSupport, RenderingContext rc) throws IOException, FHIRException {
        HierarchicalTableGenerator.Row originalRow = slicingRow;
        StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
        HierarchicalTableGenerator.Row typesRow = null;
        List<ElementDefinition> children = this.getChildren(all, element);
        if (!this.onlyInformationIsMapping(all, element)) {
            HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
            row.setAnchor(element.getPath());
            row.setColor(this.getRowColor(element, isConstraintMode));
            if (element.hasSlicing()) {
                row.setLineColor(1);
            } else if (element.hasSliceName()) {
                row.setLineColor(2);
            } else {
                row.setLineColor(0);
            }
            boolean hasDef = element != null;
            boolean ext = false;
            if (this.tail(element.getPath()).equals("extension")) {
                if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex((String)element.getType().get(0).getProfile().get(0).getValue())) {
                    row.setIcon("icon_extension_complex.png", "Complex Extension");
                } else {
                    row.setIcon("icon_extension_simple.png", "Simple Extension");
                }
                ext = true;
            } else if (this.tail(element.getPath()).equals("modifierExtension")) {
                if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex((String)element.getType().get(0).getProfile().get(0).getValue())) {
                    row.setIcon("icon_modifier_extension_complex.png", "Complex Extension");
                } else {
                    row.setIcon("icon_modifier_extension_simple.png", "Simple Extension");
                }
            } else if (!hasDef || element.getType().size() == 0) {
                if (root && this.context.getResourceNames().contains(profile.getType())) {
                    row.setIcon("icon_resource.png", "Resource");
                } else {
                    row.setIcon("icon_element.gif", "Element");
                }
            } else if (hasDef && element.getType().size() > 1) {
                if (this.allAreReference(element.getType())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                } else {
                    row.setIcon("icon_choice.gif", "Choice of Types");
                    typesRow = row;
                }
            } else if (hasDef && element.getType().get(0).getWorkingCode() != null && element.getType().get(0).getWorkingCode().startsWith("@")) {
                row.setIcon("icon_reuse.png", "Reference to another Element");
            } else if (hasDef && this.isPrimitive(element.getType().get(0).getWorkingCode())) {
                row.setIcon("icon_primitive.png", "Primitive Data Type");
            } else if (hasDef && element.getType().get(0).hasTarget()) {
                row.setIcon("icon_reference.png", "Reference to another Resource");
            } else if (hasDef && this.isDataType(element.getType().get(0).getWorkingCode())) {
                row.setIcon("icon_datatype.gif", "Data Type");
            } else if (hasDef && Utilities.existsInList((String)element.getType().get(0).getWorkingCode(), (String[])new String[]{"Element", "BackboneElement"})) {
                row.setIcon("icon_element.gif", "Element");
            } else {
                row.setIcon("icon_resource.png", "Resource");
            }
            if (element.hasUserData("render.opaque")) {
                row.setOpacity("0.5");
            }
            UnusedTracker used = new UnusedTracker();
            String ref = defPath == null ? null : defPath + element.getId();
            String sName = this.tail(element.getPath());
            if (element.hasSliceName()) {
                sName = sName + ":" + element.getSliceName();
            }
            used.used = true;
            if (logicalModel && element.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) {
                sName = "@" + sName;
            }
            HierarchicalTableGenerator.Cell nc = this.genElementNameCell(gen, element, profileBaseFileName, snapshot, corePath, imagePath, root, logicalModel, allInvariants, profile, typesRow, row, hasDef, ext, used, ref, sName, all);
            this.genElementCells(gen, element, profileBaseFileName, snapshot, corePath, imagePath, root, logicalModel, allInvariants, profile, typesRow, row, hasDef, ext, used, ref, sName, nc, mustSupport, true, rc);
            if (element.hasSlicing()) {
                if (this.standardExtensionSlicing(element)) {
                    used.used = true;
                    showMissing = false;
                } else {
                    row.setIcon("icon_slice.png", "Slice Definition");
                    slicingRow = row;
                    for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                        for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                            p.addStyle("font-style: italic");
                        }
                    }
                }
            } else if (element.hasSliceName()) {
                row.setIcon("icon_slice_item.png", "Slice Item");
            }
            if (used.used || showMissing) {
                rows.add(row);
            }
            if (!used.used && !element.hasSlicing()) {
                for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                    for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                        p.setStyle("text-decoration:line-through");
                        p.setReference(null);
                    }
                }
            } else {
                HierarchicalTableGenerator.Row hrow;
                if (slicingRow != originalRow && !children.isEmpty()) {
                    hrow = new HierarchicalTableGenerator.Row(gen);
                    hrow.setAnchor(element.getPath());
                    hrow.setColor(this.getRowColor(element, isConstraintMode));
                    hrow.setLineColor(1);
                    hrow.setIcon("icon_element.gif", "Element");
                    List list = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, sName + ":All Slices", "", null));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list2 = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "Content/Rules for all slices", "", null));
                    row.getSubRows().add(hrow);
                    row = hrow;
                }
                if (typesRow != null && !children.isEmpty()) {
                    hrow = new HierarchicalTableGenerator.Row(gen);
                    hrow.setAnchor(element.getPath());
                    hrow.setColor(this.getRowColor(element, isConstraintMode));
                    hrow.setLineColor(1);
                    hrow.setIcon("icon_element.gif", "Element");
                    List list = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, sName + ":All Types", "", null));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list3 = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "Content/Rules for all Types", "", null));
                    row.getSubRows().add(hrow);
                    row = hrow;
                }
                HierarchicalTableGenerator.Row currRow = row;
                List<ElementChoiceGroup> groups = this.readChoices(element, children);
                boolean isExtension = Utilities.existsInList((String)this.tail(element.getPath()), (String[])new String[]{"extension", "modifierExtension"});
                if (!element.prohibited()) {
                    for (ElementDefinition child : children) {
                        if (!child.hasSliceName()) {
                            currRow = row;
                        }
                        HierarchicalTableGenerator.Row childRow = this.chooseChildRowByGroup(gen, currRow, groups, child, element, isConstraintMode);
                        if (!logicalModel && child.getPath().endsWith(".id") && (!child.getPath().endsWith(".id") || profile == null || profile.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT)) continue;
                        currRow = this.genElement(defPath, gen, childRow.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, snapshot, corePath, imagePath, false, logicalModel, isConstraintMode, allInvariants, currRow, mustSupport, rc);
                    }
                }
            }
            if (typesRow != null) {
                this.makeChoiceRows(typesRow.getSubRows(), element, gen, corePath, profileBaseFileName, mustSupport);
            }
        }
        return slicingRow;
    }

    private HierarchicalTableGenerator.Row chooseChildRowByGroup(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, List<ElementChoiceGroup> groups, ElementDefinition element, ElementDefinition parent, boolean isConstraintMode) {
        String name = this.tail(element.getPath());
        for (ElementChoiceGroup grp : groups) {
            if (!grp.getElements().contains(name)) continue;
            if (grp.getRow() == null) {
                grp.setRow(this.makeChoiceElementRow(gen, row, grp, parent, isConstraintMode));
            }
            return grp.getRow();
        }
        return row;
    }

    private HierarchicalTableGenerator.Row makeChoiceElementRow(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row prow, ElementChoiceGroup grp, ElementDefinition parent, boolean isConstraintMode) {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        row.setAnchor(parent.getPath() + "-" + grp.getName());
        row.setColor(this.getRowColor(parent, isConstraintMode));
        row.setLineColor(1);
        row.setIcon("icon_choice.gif", "Choice of Types");
        List list = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(Choice of one)", "", null));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List list2 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, (grp.mandatory ? "1" : "0") + "..1", "", null));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        prow.getSubRows().add(row);
        return row;
    }

    public HierarchicalTableGenerator.Cell genElementNameCell(HierarchicalTableGenerator gen, ElementDefinition element, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, StructureDefinition profile, HierarchicalTableGenerator.Row typesRow, HierarchicalTableGenerator.Row row, boolean hasDef, boolean ext, UnusedTracker used, String ref, String sName, List<ElementDefinition> elements) throws IOException {
        String hint = "";
        hint = this.checkAdd(hint, element.hasSliceName() ? this.translate("sd.table", "Slice") + " " + element.getSliceName() : "");
        if (hasDef && element.hasDefinition()) {
            hint = this.checkAdd(hint, hasDef && element.hasSliceName() ? ": " : "");
            hint = this.checkAdd(hint, !hasDef ? null : this.gt(element.getDefinitionElement()));
        }
        if (element.hasSlicing() && this.slicesExist(elements, element)) {
            sName = "Slices for " + sName;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, ref, sName, hint, null);
        row.getCells().add(left);
        return left;
    }

    private boolean slicesExist(List<ElementDefinition> elements, ElementDefinition element) {
        if (elements == null) {
            return true;
        }
        boolean found = false;
        int start = elements.indexOf(element);
        if (start < 0) {
            return false;
        }
        for (int i = start; i < elements.size(); ++i) {
            ElementDefinition ed = elements.get(i);
            if (ed.getPath().equals(element.getPath()) && ed.hasSliceName()) {
                found = true;
            }
            if (ed.getPath().length() < element.getPath().length()) break;
        }
        return found;
    }

    public List<HierarchicalTableGenerator.Cell> genElementCells(HierarchicalTableGenerator gen, ElementDefinition element, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, StructureDefinition profile, HierarchicalTableGenerator.Row typesRow, HierarchicalTableGenerator.Row row, boolean hasDef, boolean ext, UnusedTracker used, String ref, String sName, HierarchicalTableGenerator.Cell nameCell, boolean mustSupport, boolean allowSubRows, RenderingContext rc) throws IOException {
        ArrayList<HierarchicalTableGenerator.Cell> res = new ArrayList<HierarchicalTableGenerator.Cell>();
        HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(gc);
        res.add(gc);
        if (element != null && element.getIsModifier()) {
            this.checkForNoChange(element.getIsModifierElement(), gc.addStyledText(this.translate("sd.table", "This element is a modifier element"), "?!", null, null, null, false));
        }
        if (element != null && element.getMustSupport()) {
            this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText(this.translate("sd.table", "This element must be supported"), "S", "white", "red", null, false));
        }
        if (element != null && element.getIsSummary()) {
            this.checkForNoChange(element.getIsSummaryElement(), gc.addStyledText(this.translate("sd.table", "This element is included in summaries"), "\u03a3", null, null, null, false));
        }
        if (element != null && (this.hasNonBaseConstraints(element.getConstraint()) || this.hasNonBaseConditions(element.getCondition()))) {
            gc.addStyledText(this.translate("sd.table", "This element has or is affected by some invariants (" + this.listConstraintsAndConditions(element) + ")"), "I", null, null, null, false);
        }
        ExtensionContext extDefn = null;
        if (ext) {
            if (element != null && element.getType().size() == 1 && element.getType().get(0).hasProfile()) {
                String eurl = (String)element.getType().get(0).getProfile().get(0).getValue();
                extDefn = this.locateExtension(StructureDefinition.class, eurl);
                if (extDefn == null) {
                    res.add(this.genCardinality(gen, element, row, hasDef, used, null));
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "?gen-e1? " + element.getType().get(0).getProfile(), null, null)));
                    res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData(DERIVATION_POINTER), used.used, profile == null ? "" : profile.getUrl(), eurl, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
                } else {
                    String name = element.hasSliceName() ? element.getSliceName() : this.urltail(eurl);
                    ((HierarchicalTableGenerator.Piece)nameCell.getPieces().get(0)).setText(name);
                    ((HierarchicalTableGenerator.Piece)nameCell.getPieces().get(0)).setHint(this.translate("sd.table", "Extension URL") + " = " + extDefn.getUrl());
                    res.add(this.genCardinality(gen, element, row, hasDef, used, extDefn.getElement()));
                    ElementDefinition valueDefn = extDefn.getExtensionValueDefinition();
                    if (valueDefn != null && !"0".equals(valueDefn.getMax())) {
                        res.add(this.genTypes(gen, row, valueDefn, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(" + this.translate("sd.table", "Complex") + ")", null, null)));
                    }
                    res.add(this.generateDescription(gen, row, element, extDefn.getElement(), used.used, null, extDefn.getUrl(), profile, corePath, imagePath, root, logicalModel, allInvariants, valueDefn, snapshot, mustSupport, allowSubRows, rc));
                }
            } else {
                res.add(this.genCardinality(gen, element, row, hasDef, used, null));
                if ("0".equals(element.getMax())) {
                    res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(gen)));
                } else {
                    res.add(this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
                }
                res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData(DERIVATION_POINTER), used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
            }
        } else {
            res.add(this.genCardinality(gen, element, row, hasDef, used, null));
            if (hasDef && !"0".equals(element.getMax()) && typesRow == null) {
                res.add(this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
            } else {
                res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(gen)));
            }
            res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData(DERIVATION_POINTER), used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
        }
        return res;
    }

    private HierarchicalTableGenerator.Cell addCell(HierarchicalTableGenerator.Row row, HierarchicalTableGenerator.Cell cell) {
        row.getCells().add(cell);
        return cell;
    }

    private String checkAdd(String src, String app) {
        return app == null ? src : src + app;
    }

    private boolean hasNonBaseConditions(List<IdType> conditions) {
        for (IdType c : conditions) {
            if (this.isBaseCondition(c)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonBaseConstraints(List<ElementDefinition.ElementDefinitionConstraintComponent> constraints) {
        for (ElementDefinition.ElementDefinitionConstraintComponent c : constraints) {
            if (this.isBaseConstraint(c)) continue;
            return true;
        }
        return false;
    }

    private String listConstraintsAndConditions(ElementDefinition element) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionConstraintComponent con : element.getConstraint()) {
            if (this.isBaseConstraint(con)) continue;
            b.append(con.getKey());
        }
        for (IdType id : element.getCondition()) {
            if (this.isBaseCondition(id)) continue;
            b.append(id.asStringValue());
        }
        return b.toString();
    }

    private boolean isBaseCondition(IdType c) {
        String key = c.asStringValue();
        return key != null && key.startsWith("ele-") || key.startsWith("res-") || key.startsWith("ext-") || key.startsWith("dom-") || key.startsWith("dr-");
    }

    private boolean isBaseConstraint(ElementDefinition.ElementDefinitionConstraintComponent con) {
        String key = con.getKey();
        return key != null && key.startsWith("ele-") || key.startsWith("res-") || key.startsWith("ext-") || key.startsWith("dom-") || key.startsWith("dr-");
    }

    private void makeChoiceRows(List<HierarchicalTableGenerator.Row> subRows, ElementDefinition element, HierarchicalTableGenerator gen, String corePath, String profileBaseFileName, boolean mustSupportMode) {
        for (ElementDefinition.TypeRefComponent tr : element.getType()) {
            if (mustSupportMode && !ProfileUtilities.allTypesMustSupport(element) && !ProfileUtilities.isMustSupport(tr)) continue;
            HierarchicalTableGenerator.Row choicerow = new HierarchicalTableGenerator.Row(gen);
            String t = tr.getWorkingCode();
            if (this.isReference(t)) {
                List list = choicerow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), null, null));
                choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List list2 = choicerow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
                choicerow.setIcon("icon_reference.png", "Reference to another Resource");
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                choicerow.getCells().add(c);
                if (tr.getWorkingCode().equals("canonical")) {
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, corePath + "datatypes.html#canonical", "canonical", null));
                } else {
                    List list4 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, corePath + "references.html#Reference", "Reference", null));
                }
                if (!mustSupportMode && ProfileUtilities.isMustSupportDirect(tr) && element.getMustSupport()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                }
                List list5 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, "(", null));
                boolean first = true;
                for (CanonicalType rt : tr.getTargetProfile()) {
                    if (mustSupportMode && !ProfileUtilities.allProfilesMustSupport(tr.getTargetProfile()) && !ProfileUtilities.isMustSupport(rt)) continue;
                    if (!first) {
                        List list6 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator7);
                        list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, " | ", null));
                    }
                    this.genTargetLink(gen, profileBaseFileName, corePath, c, tr, (String)rt.getValue());
                    if (!mustSupportMode && ProfileUtilities.isMustSupport(rt) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator8);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This target must be supported"), "S", "white", "red", null, false);
                    }
                    first = false;
                }
                if (first) {
                    List list7 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator9);
                    list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, "Any", null));
                }
                List list8 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator10);
                list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ")", null));
            } else {
                StructureDefinition sd = this.context.fetchTypeDefinition(t);
                if (sd == null) {
                    System.out.println("Unable to find " + t);
                    sd = this.context.fetchTypeDefinition(t);
                } else if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                    List list = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), sd.getDescription(), null));
                    choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list9 = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list9.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator11, null, null, "", null, null));
                    choicerow.setIcon("icon_primitive.png", "Primitive Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator12, null, corePath + "datatypes.html#" + t, sd.getType(), null, null);
                    choicerow.getCells().add(c);
                    if (!mustSupportMode && ProfileUtilities.isMustSupport(tr) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator13);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                    }
                } else {
                    List list = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), sd.getDescription(), null));
                    choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list10 = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list10.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator14, null, null, "", null, null));
                    choicerow.setIcon("icon_datatype.gif", "Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator15);
                    HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator15, null, this.pkp.getLinkFor(corePath, t), sd.getType(), null, null);
                    choicerow.getCells().add(c);
                    if (!mustSupportMode && ProfileUtilities.isMustSupport(tr) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator16);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                    }
                }
                if (tr.hasProfile()) {
                    HierarchicalTableGenerator.Cell typeCell = (HierarchicalTableGenerator.Cell)choicerow.getCells().get(3);
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "(", null));
                    boolean first = true;
                    for (CanonicalType pt : tr.getProfile()) {
                        if (mustSupportMode && !ProfileUtilities.allProfilesMustSupport(tr.getProfile()) && !ProfileUtilities.isMustSupport(pt)) continue;
                        if (first) {
                            first = false;
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator17);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, " | ", null));
                        }
                        StructureDefinition psd = this.context.fetchResource(StructureDefinition.class, (String)pt.getValue());
                        if (psd == null) {
                            HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator18);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, "?gen-e2?", null));
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator19);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, psd.getUserString("path"), psd.getName(), psd.present()));
                        }
                        if (mustSupportMode || !ProfileUtilities.isMustSupport(pt) || !element.getMustSupport()) continue;
                        HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator20);
                        typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, " ", null));
                        typeCell.addStyledText(this.translate("sd.table", "This profile must be supported"), "S", "white", "red", null, false);
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, ")", null));
                }
            }
            choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
            subRows.add(choicerow);
        }
    }

    private boolean isReference(String t) {
        return t.equals("Reference") || t.equals("canonical");
    }

    private void genGridElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, String corePath, String imagePath, boolean root, boolean isConstraintMode) throws IOException, FHIRException {
        boolean isExtension;
        StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
        String s = this.tail(element.getPath());
        List<ElementDefinition> children = this.getChildren(all, element);
        boolean bl = isExtension = s.equals("extension") || s.equals("modifierExtension");
        if (!this.onlyInformationIsMapping(all, element)) {
            HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
            row.setAnchor(element.getPath());
            row.setColor(this.getRowColor(element, isConstraintMode));
            if (element.hasSlicing()) {
                row.setLineColor(1);
            } else if (element.hasSliceName()) {
                row.setLineColor(2);
            } else {
                row.setLineColor(0);
            }
            boolean hasDef = element != null;
            String ref = defPath == null ? null : defPath + element.getId();
            UnusedTracker used = new UnusedTracker();
            used.used = true;
            HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(gen);
            if (element.getType().size() == 1 && element.getType().get(0).isPrimitive()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())).addStyle("font-weight:bold"));
            } else {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())));
            }
            if (element.hasSliceName()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                String indent = StringUtils.repeat((char)'\u00a0', (int)(1 + 2 * element.getPath().split("\\.").length));
                List list2 = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, indent + "(" + element.getSliceName() + ")", null));
            }
            row.getCells().add(left);
            Object extDefn = null;
            this.genCardinality(gen, element, row, hasDef, used, null);
            if (hasDef && !"0".equals(element.getMax())) {
                this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, false);
            } else {
                row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
            }
            this.generateGridDescription(gen, row, element, null, used.used, null, null, profile, corePath, imagePath, root, null);
            rows.add(row);
            for (ElementDefinition child : children) {
                if (!child.getMustSupport()) continue;
                this.genGridElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, corePath, imagePath, false, isConstraintMode);
            }
        }
    }

    private ExtensionContext locateExtension(Class<StructureDefinition> class1, String value) {
        if (value.contains("#")) {
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return null;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                return new ExtensionContext(ext, ed);
            }
            return null;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        if (ext == null) {
            return null;
        }
        return new ExtensionContext(ext, ext.getSnapshot().getElement().get(0));
    }

    private boolean extensionIsComplex(String value) {
        if (value.contains("#")) {
            int j;
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return false;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                break;
            }
            if (ed == null) {
                return false;
            }
            int i = ext.getSnapshot().getElement().indexOf(ed);
            for (j = i + 1; j < ext.getSnapshot().getElement().size() && !ext.getSnapshot().getElement().get(j).getPath().equals(ed.getPath()); ++j) {
            }
            return j - i > 5;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        return ext != null && ext.getSnapshot().getElement().size() > 5;
    }

    public String getRowColor(ElementDefinition element, boolean isConstraintMode) {
        switch (element.getUserInt(UD_ERROR_STATUS)) {
            case 1: {
                return ROW_COLOR_HINT;
            }
            case 2: {
                return ROW_COLOR_WARNING;
            }
            case 3: {
                return ROW_COLOR_ERROR;
            }
            case 4: {
                return ROW_COLOR_FATAL;
            }
        }
        if (isConstraintMode && !element.getMustSupport() && !element.getIsModifier() && element.getPath().contains(".")) {
            return null;
        }
        return null;
    }

    private String urltail(String path) {
        if (path.contains("#")) {
            return path.substring(path.lastIndexOf(35) + 1);
        }
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    private boolean standardExtensionSlicing(ElementDefinition element) {
        String t = this.tail(element.getPath());
        return (t.equals("extension") || t.equals("modifierExtension")) && element.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED && element.getSlicing().getDiscriminator().size() == 1 && element.getSlicing().getDiscriminator().get(0).getPath().equals("url") && element.getSlicing().getDiscriminator().get(0).getType().equals((Object)ElementDefinition.DiscriminatorType.VALUE);
    }

    private HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, boolean snapshot, boolean mustSupportOnly, boolean allowSubRows, RenderingContext rc) throws IOException, FHIRException {
        return this.generateDescription(gen, row, definition, fallback, used, baseURL, url, profile, corePath, imagePath, root, logicalModel, allInvariants, null, snapshot, mustSupportOnly, allowSubRows, rc);
    }

    private HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, ElementDefinition valueDefn, boolean snapshot, boolean mustSupportOnly, boolean allowSubRows, RenderingContext rc) throws IOException, FHIRException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (logicalModel && ToolingExtensions.hasExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                if (root) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                } else if (!root && ToolingExtensions.hasExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace") && !ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").equals(ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"))) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                }
            }
            if (root && profile != null && profile.getAbstract()) {
                if (!c.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This is an abstract profile", null));
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                DataType dataType = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (definition != null && definition.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = definition.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(definition.getShortElement()), null)));
                } else if (fallback != null && fallback.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(fallback.getShortElement()), null).addStyle("opacity: 0.5"));
                }
                if (url != null) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    String ref = null;
                    String ref2 = null;
                    Object fixedUrl = null;
                    if (ed != null) {
                        String p = ed.getUserString("path");
                        if (p != null) {
                            String string = ref = p.startsWith("http:") || this.igmode ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                        }
                        if ((fixedUrl = this.getFixedUrl(ed)) != null) {
                            if (((String)fixedUrl).equals(url)) {
                                fixedUrl = null;
                            } else {
                                String p2;
                                StructureDefinition ed2 = this.context.fetchResource(StructureDefinition.class, (String)fixedUrl);
                                if (ed2 != null && (p2 = ed2.getUserString("path")) != null) {
                                    String string = ref2 = p2.startsWith("http:") || this.igmode ? p2 : Utilities.pathURL((String[])new String[]{corePath, p2});
                                }
                            }
                        }
                    }
                    if (fixedUrl == null) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "URL") + ": ", null).addStyle("font-weight:bold"));
                        List list4 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator4);
                        list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, ref, fullUrl, null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "URL") + ": ", null).addStyle("font-weight:bold"));
                        List list5 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator5);
                        list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, ref2, (String)fixedUrl, null));
                        List list6 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator6);
                        list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, this.translate("sd.table", " profiled by ") + " ", null).addStyle("font-weight:bold"));
                        List list7 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator7);
                        list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, ref, fullUrl, null));
                    }
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Slice") + ": ", null).addStyle("font-weight:bold"));
                    List list8 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator8);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (!definition.getPath().contains(".") && ToolingExtensions.hasExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-binding-style")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold"));
                    List list9 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator9);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, "This type can be bound to a value set using the ", null));
                    List list10 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator10);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-binding-style"), null));
                    List list11 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, " binding style", null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML") + ": ", null).addStyle("font-weight:bold"));
                        List list12 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator12);
                        list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name"), null));
                        List list13 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator13);
                        list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, " (", null));
                        List list14 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator14);
                        list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                        List list15 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator15);
                        list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, ")", null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Element Name") + ": ", null).addStyle("font-weight:bold"));
                        List list16 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator16);
                        list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name"), null));
                    }
                } else if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list17 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator17);
                    list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = this.makeUnifiedBinding(valueDefn.getBinding(), valueDefn);
                    } else if (definition.hasBinding()) {
                        binding = this.makeUnifiedBinding(definition.getBinding(), definition);
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        ProfileKnowledgeProvider.BindingResolution br = this.pkp == null ? this.makeNullBr(binding) : this.pkp.resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
                        List list18 = c.getPieces();
                        CanonicalType canonicalType = binding.getValueSetElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator18);
                        list18.add(this.checkForNoChange(canonicalType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
                        if (binding.hasStrength()) {
                            List list19 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator19);
                            list19.add(this.checkForNoChange(enumeration, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, " (", null)));
                            List list20 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration2 = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator20);
                            list20.add(this.checkForNoChange(enumeration2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, corePath + "terminologies.html#" + binding.getStrength().toCode(), this.egt(binding.getStrengthElement()), binding.getStrength().getDefinition())));
                            List list21 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration3 = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator21);
                            list21.add(this.checkForNoChange(enumeration3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, ")", null)));
                        }
                        if (binding.hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)binding.getDescription())) {
                            List list22 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator22);
                            list22.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, ": ", null));
                            c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context, binding.getDescriptionElement()).asStringValue(), this.checkForNoChange(PublicationHacker.fixBindingDescriptions(this.context, binding.getDescriptionElement())));
                        }
                        AdditionalBindingsRenderer abr = new AdditionalBindingsRenderer(this.pkp, corePath, profile, definition.getPath(), rc, null);
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                            abr.seeMaxBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"));
                        }
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet")) {
                            abr.seeMinBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet"));
                        }
                        if (binding.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/additional-binding")) {
                            abr.seeAdditionalBindings(binding.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding"));
                        }
                        abr.render(gen, c);
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (inv.hasSource() && profile != null && !inv.getSource().equals(profile.getUrl()) && !allInvariants) continue;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        List list23 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator23);
                        list23.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, this.gt(inv.getHumanElement()), null)));
                    }
                    if (definition.hasBase() && "*".equals(definition.getBase().getMax()) || definition.hasMax() && "*".equals(definition.getMax())) {
                        if (c.getPieces().size() > 0) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        if (definition.hasOrderMeaning()) {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This repeating element order: " + definition.getOrderMeaning(), null));
                        }
                    }
                    if (definition.hasFixed()) {
                        HierarchicalTableGenerator.Piece p;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Fixed Value") + ": ", null).addStyle("font-weight:bold")));
                        if (!this.useTableForFixedValues || !allowSubRows || definition.getFixed().isPrimitive()) {
                            String s = this.buildJson(definition.getFixed());
                            String link = null;
                            if (Utilities.isAbsoluteUrl((String)s)) {
                                link = this.pkp.getLinkForUrl(corePath, s);
                            }
                            List list24 = c.getPieces();
                            DataType dataType2 = definition.getFixed();
                            HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator24);
                            list24.add(this.checkForNoChange(dataType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, link, s, null).addStyle("color: darkgreen")));
                        } else {
                            List list25 = c.getPieces();
                            DataType dataType3 = definition.getFixed();
                            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator25);
                            list25.add(this.checkForNoChange(dataType3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, "As shown", null).addStyle("color: darkgreen")));
                            this.genFixedValue(gen, row, definition.getFixed(), snapshot, false, corePath, false);
                        }
                        if (this.isCoded(definition.getFixed()) && !this.hasDescription(definition.getFixed()) && (p = this.describeCoded(gen, definition.getFixed())) != null) {
                            c.getPieces().add(p);
                        }
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Required Pattern") + ": ", null).addStyle("font-weight:bold")));
                        if (!this.useTableForFixedValues || !allowSubRows || definition.getPattern().isPrimitive()) {
                            List list26 = c.getPieces();
                            DataType dataType4 = definition.getPattern();
                            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator26);
                            list26.add(this.checkForNoChange(dataType4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                        } else {
                            List list27 = c.getPieces();
                            DataType dataType5 = definition.getPattern();
                            HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator27);
                            list27.add(this.checkForNoChange(dataType5, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, null, "At least the following", null).addStyle("color: darkgreen")));
                            this.genFixedValue(gen, row, definition.getPattern(), snapshot, true, corePath, mustSupportOnly);
                        }
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Example") + ("".equals("General") ? "" : " " + ex.getLabel()) + ": ", null).addStyle("font-weight:bold")));
                            List list28 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator28);
                            list28.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list29 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator29);
                        list29.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator30);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                }
            }
        }
        return c;
    }

    private ProfileKnowledgeProvider.BindingResolution makeNullBr(ElementDefinition.ElementDefinitionBindingComponent binding) {
        ProfileKnowledgeProvider.BindingResolution br = new ProfileKnowledgeProvider.BindingResolution();
        br.url = "http://none.none/none";
        br.display = "todo";
        return br;
    }

    private ElementDefinition.ElementDefinitionBindingComponent makeUnifiedBinding(ElementDefinition.ElementDefinitionBindingComponent binding, ElementDefinition element) {
        if (!element.hasUserData(DERIVATION_POINTER)) {
            return binding;
        }
        ElementDefinition base = (ElementDefinition)element.getUserData(DERIVATION_POINTER);
        if (!base.hasBinding()) {
            return binding;
        }
        ElementDefinition.ElementDefinitionBindingComponent o = base.getBinding();
        ElementDefinition.ElementDefinitionBindingComponent b = new ElementDefinition.ElementDefinitionBindingComponent();
        b.setUserData(DERIVATION_POINTER, o);
        if (binding.hasValueSet()) {
            b.setValueSet(binding.getValueSet());
        } else if (o.hasValueSet()) {
            b.setValueSet(o.getValueSet());
            b.getValueSetElement().setUserData(DERIVATION_EQUALS, o.getValueSetElement());
        }
        if (binding.hasStrength()) {
            b.setStrength(binding.getStrength());
        } else if (o.hasStrength()) {
            b.setStrength(o.getStrength());
            b.getStrengthElement().setUserData(DERIVATION_EQUALS, o.getStrengthElement());
        }
        if (binding.hasDescription()) {
            b.setDescription(binding.getDescription());
        } else if (o.hasDescription()) {
            b.setDescription(o.getDescription());
            b.getDescriptionElement().setUserData(DERIVATION_EQUALS, o.getDescriptionElement());
        }
        return b;
    }

    private void genFixedValue(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row erow, DataType value, boolean snapshot, boolean pattern, String corePath, boolean skipnoValue) {
        String ref = this.pkp.getLinkFor(corePath, value.fhirType());
        ref = ref != null && ref.contains(".html") ? ref.substring(0, ref.indexOf(".html")) + "-definitions.html#" : "?gen-fv?";
        StructureDefinition sd = this.context.fetchTypeDefinition(value.fhirType());
        for (org.hl7.fhir.r4b.model.Property t : value.children()) {
            if (t.getValues().size() <= 0 && !snapshot) continue;
            ElementDefinition ed = this.findElementDefinition(sd, t.getName());
            if (t.getValues().size() == 0 || t.getValues().size() == 1 && t.getValues().get(0).isEmpty()) {
                if (skipnoValue) continue;
                HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
                erow.getSubRows().add(row);
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getBase().getPath().equals(ed.getPath()) ? ref + ed.getPath() : corePath + (VersionUtilities.isR5Ver((String)this.context.getVersion()) ? "types-definitions.html#" + ed.getBase().getPath() : "element-definitions.html#" + ed.getBase().getPath()), t.getName(), null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, null, null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (!pattern) {
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "0..0", null));
                    row.setIcon("icon_fixed.gif", "Fixed Value");
                } else if (this.isPrimitive(t.getTypeCode())) {
                    row.setIcon("icon_primitive.png", "Primitive Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else if (this.isReference(t.getTypeCode())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else {
                    row.setIcon("icon_datatype.gif", "Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (t.getTypeCode().contains("(")) {
                    String[] p;
                    String tc = t.getTypeCode();
                    String tn = tc.substring(0, tc.indexOf("("));
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, this.pkp.getLinkFor(corePath, tn), tn, null));
                    HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator8);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, "(", null));
                    for (String s : p = tc.substring(tc.indexOf("(") + 1, tc.indexOf(")")).split("\\|")) {
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, this.pkp.getLinkFor(corePath, s), s, null));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator10);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ")", null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, this.pkp.getLinkFor(corePath, t.getTypeCode()), t.getTypeCode(), null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, ed.getShort(), null));
                row.getCells().add(c);
                continue;
            }
            for (Base b : t.getValues()) {
                HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
                erow.getSubRows().add(row);
                row.setIcon("icon_fixed.gif", "Fixed Value");
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getBase().getPath().equals(ed.getPath()) ? ref + ed.getPath() : (VersionUtilities.isThisOrLater((String)"4.1", (String)this.context.getVersion()) ? corePath + "types-definitions.html#" + ed.getBase().getPath() : corePath + "element-definitions.html#" + ed.getBase().getPath()), t.getName(), null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator13);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, null, null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (pattern) {
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, "1.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator15);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, "1..1", null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (b.fhirType().contains("(")) {
                    String[] p;
                    String tc = b.fhirType();
                    String tn = tc.substring(0, tc.indexOf("("));
                    HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator16);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, this.pkp.getLinkFor(corePath, tn), tn, null));
                    HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator17);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, "(", null));
                    for (String s : p = tc.substring(tc.indexOf("(") + 1, tc.indexOf(")")).split("\\|")) {
                        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator18);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, this.pkp.getLinkFor(corePath, s), s, null));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator19);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, ")", null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator20);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, this.pkp.getLinkFor(corePath, b.fhirType()), b.fhirType(), null));
                }
                if (b.isPrimitive()) {
                    c = new HierarchicalTableGenerator.Cell(gen);
                    row.getCells().add(c);
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, ed.getShort(), null));
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, "br"));
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator23);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, "Fixed Value: ", null).addStyle("font-weight: bold"));
                    String s = b.primitiveValue();
                    String link = null;
                    if (Utilities.isAbsoluteUrl((String)s)) {
                        link = this.pkp.getLinkForUrl(corePath, s);
                    }
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator24);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, link, s, null).addStyle("color: darkgreen"));
                    continue;
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator25);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, ed.getShort(), null));
                HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator26);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, "br"));
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator27);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, null, "Fixed Value: ", null).addStyle("font-weight: bold"));
                List list3 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator28);
                list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, "(complex)", null).addStyle("color: darkgreen"));
                this.genFixedValue(gen, row, (DataType)b, snapshot, pattern, corePath, skipnoValue);
            }
        }
    }

    private ElementDefinition findElementDefinition(StructureDefinition sd, String name) {
        String path = sd.getType() + "." + name;
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(path)) continue;
            return ed;
        }
        throw new FHIRException(this.context.formatMessage("Unable_to_find_element_", path));
    }

    private String getFixedUrl(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals("Extension.url") || !ed.hasFixed() || !(ed.getFixed() instanceof UriType)) continue;
            return ed.getFixed().primitiveValue();
        }
        return null;
    }

    private HierarchicalTableGenerator.Piece describeCoded(HierarchicalTableGenerator gen, DataType fixed) {
        if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            IWorkerContext.ValidationResult vr = this.context.validateCode(this.terminologyServiceOptions, c.getSystem(), c.getVersion(), c.getCode(), c.getDisplay());
            if (vr.getDisplay() != null) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        } else if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            for (Coding c : cc.getCoding()) {
                IWorkerContext.ValidationResult vr = this.context.validateCode(this.terminologyServiceOptions, c.getSystem(), c.getVersion(), c.getCode(), c.getDisplay());
                if (vr.getDisplay() == null) continue;
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        }
        return null;
    }

    private boolean hasDescription(DataType fixed) {
        if (fixed instanceof Coding) {
            return ((Coding)fixed).hasDisplay();
        }
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            if (cc.hasText()) {
                return true;
            }
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplay()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCoded(DataType fixed) {
        return fixed instanceof Coding || fixed instanceof CodeableConcept || fixed instanceof CodeType || fixed instanceof Quantity;
    }

    private HierarchicalTableGenerator.Cell generateGridDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, ElementDefinition valueDefn) throws IOException, FHIRException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (definition.hasContentReference()) {
                ElementInStructure ed = this.getElementByName(profile.getSnapshot().getElement(), definition.getContentReference(), profile);
                if (ed == null) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Unknown reference to " + definition.getContentReference(), null));
                } else if (ed.getSource() == profile) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "#" + ed.getElement().getPath(), "See " + ed.getElement().getPath(), null));
                } else {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getSource().getUserData("path") + "#" + ed.getElement().getPath(), "See " + ed.getSource().getType() + "." + ed.getElement().getPath(), null));
                }
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                DataType dataType = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (url != null) {
                    String p;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    String ref = null;
                    if (ed != null && (p = ed.getUserString("path")) != null) {
                        ref = p.startsWith("http:") || this.igmode ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "URL: ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, ref, fullUrl, null));
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Slice: ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = valueDefn.getBinding();
                    } else if (definition.hasBinding()) {
                        binding = definition.getBinding();
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Binding: ", null).addStyle("font-weight:bold")));
                        List list4 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator4);
                        list4.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.pkp.prependLinks() ? br.url : corePath + br.url), br.display, null)));
                        if (binding.hasStrength()) {
                            List list5 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator5);
                            list5.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " (", null)));
                            List list6 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator6);
                            list6.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, corePath + "terminologies.html#" + binding.getStrength().toCode(), binding.getStrength().toCode(), binding.getStrength().getDefinition())));
                            List list7 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, ")", null));
                        }
                        if (binding.hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)binding.getDescription())) {
                            List list8 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator8);
                            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ": ", null));
                            c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context, binding.getDescriptionElement()).asStringValue());
                        }
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        if (inv.getHumanElement().hasExtension("http://hl7.org/fhir/StructureDefinition/rendering-markdown")) {
                            c.addMarkdown(inv.getHumanElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/rendering-markdown"));
                            continue;
                        }
                        List list9 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list9.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, inv.getHuman(), null)));
                    }
                    if (definition.hasFixed()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Fixed Value: ", null).addStyle("font-weight:bold")));
                        String s = this.buildJson(definition.getFixed());
                        String link = null;
                        if (Utilities.isAbsoluteUrl((String)s)) {
                            link = this.pkp.getLinkForUrl(corePath, s);
                        }
                        List list10 = c.getPieces();
                        DataType dataType2 = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list10.add(this.checkForNoChange(dataType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, link, s, null).addStyle("color: darkgreen")));
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Required Pattern: ", null).addStyle("font-weight:bold")));
                        List list11 = c.getPieces();
                        DataType dataType3 = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator11);
                        list11.add(this.checkForNoChange(dataType3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Example'" + ("".equals("General") ? "" : " " + ex.getLabel() + "'") + ": ", null).addStyle("font-weight:bold")));
                            List list12 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator12);
                            list12.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list13 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator13);
                        list13.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator14);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                    if (definition.hasDefinition()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Definition: ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator15);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
                        c.addMarkdown(definition.getDefinition());
                    }
                    if (definition.getComment() != null) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Comments: ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator16);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, "br"));
                        c.addMarkdown(definition.getComment());
                    }
                }
            }
        }
        return c;
    }

    private String buildJson(DataType value) throws IOException {
        if (value instanceof PrimitiveType) {
            return ((PrimitiveType)value).asStringValue();
        }
        IParser json = this.context.newJsonParser();
        return json.composeString(value, null);
    }

    public String describeSlice(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        return this.translate("sd.table", "%s, %s by %s", new Object[]{slicing.getOrdered() ? this.translate("sd.table", "Ordered") : this.translate("sd.table", "Unordered"), this.describe(slicing.getRules()), this.commas(slicing.getDiscriminator())});
    }

    private String commas(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> list) {
        CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent id : list) {
            c.append((id.hasType() ? id.getType().toCode() : "??") + ":" + id.getPath());
        }
        return c.toString();
    }

    private String describe(ElementDefinition.SlicingRules rules) {
        if (rules == null) {
            return this.translate("sd.table", "Unspecified");
        }
        switch (rules) {
            case CLOSED: {
                return this.translate("sd.table", "Closed");
            }
            case OPEN: {
                return this.translate("sd.table", "Open");
            }
            case OPENATEND: {
                return this.translate("sd.table", "Open At End");
            }
        }
        return "?gen-sr?";
    }

    private boolean onlyInformationIsMapping(List<ElementDefinition> list, ElementDefinition e) {
        return !e.hasSliceName() && !e.hasSlicing() && this.onlyInformationIsMapping(e) && this.getChildren(list, e).isEmpty();
    }

    private boolean onlyInformationIsMapping(ElementDefinition d) {
        return !d.hasShort() && !d.hasDefinition() && !d.hasRequirements() && !d.getAlias().isEmpty() && !d.hasMinElement() && !d.hasMax() && !d.getType().isEmpty() && !d.hasContentReference() && !d.hasExample() && !d.hasFixed() && !d.hasMaxLengthElement() && !d.getCondition().isEmpty() && !d.getConstraint().isEmpty() && !d.hasMustSupportElement() && !d.hasBinding();
    }

    private boolean allAreReference(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.hasTarget()) continue;
            return false;
        }
        return true;
    }

    private List<ElementDefinition> getChildren(List<ElementDefinition> all, ElementDefinition element) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = all.indexOf(element) + 1; i < all.size() && all.get(i).getPath().length() > element.getPath().length(); ++i) {
            if (!all.get(i).getPath().substring(0, element.getPath().length() + 1).equals(element.getPath() + ".") || all.get(i).getPath().substring(element.getPath().length() + 1).contains(".")) continue;
            result.add(all.get(i));
        }
        return result;
    }

    private String tail(String path) {
        if (path == null) {
            return "";
        }
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    private boolean isDataType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"Address", "Age", "Annotation", "Attachment", "CodeableConcept", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "Contributor", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    private boolean isConstrainedDataType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"SimpleQuantity", "MoneyQuantity"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT;
    }

    private String baseType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd != null) {
            return sd.getType();
        }
        if (Utilities.existsInList((String)value, (String[])new String[]{"SimpleQuantity", "MoneyQuantity"})) {
            return "Quantity";
        }
        throw new Error(this.context.formatMessage("Internal_error___type_not_known_", value));
    }

    public boolean isPrimitive(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public StructureDefinition getProfile(StructureDefinition source, String url) {
        StructureDefinition profile = null;
        String code = null;
        if (url.startsWith("#")) {
            profile = source;
            code = url.substring(1);
        } else if (this.context != null) {
            String[] parts = url.split("\\#");
            profile = this.context.fetchResource(StructureDefinition.class, parts[0]);
            String string = code = parts.length == 1 ? null : parts[1];
        }
        if (profile == null) {
            return null;
        }
        if (code == null) {
            return profile;
        }
        for (Resource r : profile.getContained()) {
            if (!(r instanceof StructureDefinition) || !r.getId().equals(code)) continue;
            return (StructureDefinition)r;
        }
        return null;
    }

    public void sortDifferential(StructureDefinition base, StructureDefinition diff, String name, List<String> errors, boolean errorIfChanges) throws FHIRException {
        ArrayList<ElementDefinition> original = new ArrayList<ElementDefinition>();
        original.addAll(diff.getDifferential().getElement());
        List<ElementDefinition> diffList = diff.getDifferential().getElement();
        int lastCount = diffList.size();
        if (diffList.isEmpty()) {
            return;
        }
        ElementDefinitionHolder edh = null;
        int i = 0;
        if (diffList.get(0).getPath().contains(".")) {
            String newPath = diffList.get(0).getPath().split("\\.")[0];
            ElementDefinition e = new ElementDefinition(newPath);
            edh = new ElementDefinitionHolder(e, true);
        } else {
            edh = new ElementDefinitionHolder(diffList.get(0));
            i = 1;
        }
        boolean hasSlicing = false;
        ArrayList<String> paths = new ArrayList<String>();
        for (ElementDefinition elt : diffList) {
            if (elt.hasSlicing() || paths.contains(elt.getPath())) {
                hasSlicing = true;
                break;
            }
            paths.add(elt.getPath());
        }
        if (!hasSlicing) {
            Collections.sort(diffList, new ElementNameCompare());
        }
        this.processElementsIntoTree(edh, i, diff.getDifferential().getElement());
        ElementDefinitionComparer cmp = new ElementDefinitionComparer(true, base.getSnapshot().getElement(), "", 0, name, base.getType());
        this.sortElements(edh, cmp, errors);
        ArrayList<ElementDefinition> newDiff = new ArrayList<ElementDefinition>();
        this.writeElements(edh, newDiff);
        if (errorIfChanges) {
            this.compareDiffs(original, newDiff, errors);
        }
        diffList.clear();
        diffList.addAll(newDiff);
        if (lastCount != diffList.size()) {
            errors.add("Sort failed: counts differ; at least one of the paths in the differential is illegal");
        }
    }

    private void compareDiffs(List<ElementDefinition> diffList, List<ElementDefinition> newDiff, List<String> errors) {
        if (diffList.size() != newDiff.size()) {
            errors.add("The diff list size changed when sorting - was " + diffList.size() + " is now " + newDiff.size());
        } else {
            for (int i = 0; i < Integer.min(diffList.size(), newDiff.size()); ++i) {
                ElementDefinition e = diffList.get(i);
                ElementDefinition n = newDiff.get(i);
                if (n.getPath().equals(e.getPath())) continue;
                errors.add("The element " + e.getPath() + " is out of order (and maybe others after it)");
                return;
            }
        }
    }

    private int processElementsIntoTree(ElementDefinitionHolder edh, int i, List<ElementDefinition> list) {
        String path = edh.getSelf().getPath();
        String prefix = path + ".";
        while (i < list.size() && list.get(i).getPath().startsWith(prefix)) {
            if (list.get(i).getPath().substring(prefix.length() + 1).contains(".")) {
                String newPath = prefix + list.get(i).getPath().substring(prefix.length()).split("\\.")[0];
                ElementDefinition e = new ElementDefinition(newPath);
                ElementDefinitionHolder child = new ElementDefinitionHolder(e, true);
                edh.getChildren().add(child);
                i = this.processElementsIntoTree(child, i, list);
                continue;
            }
            ElementDefinitionHolder child = new ElementDefinitionHolder(list.get(i));
            edh.getChildren().add(child);
            i = this.processElementsIntoTree(child, i + 1, list);
        }
        return i;
    }

    private void sortElements(ElementDefinitionHolder edh, ElementDefinitionComparer cmp, List<String> errors) throws FHIRException {
        if (edh.getChildren().size() == 1) {
            edh.getChildren().get(0).baseIndex = cmp.find(edh.getChildren().get(0).getSelf().getPath(), false);
        } else {
            Collections.sort(edh.getChildren(), cmp);
        }
        cmp.checkForErrors(errors);
        for (ElementDefinitionHolder child : edh.getChildren()) {
            ElementDefinitionComparer ccmp;
            if (child.getChildren().size() <= 0 || (ccmp = this.getComparer(cmp, child)) == null) continue;
            this.sortElements(child, ccmp, errors);
        }
    }

    public ElementDefinitionComparer getComparer(ElementDefinitionComparer cmp, ElementDefinitionHolder child) throws FHIRException, Error {
        ElementDefinitionComparer ccmp;
        ElementDefinition ed = (ElementDefinition)cmp.snapshot.get(child.getBaseIndex());
        if (ed.getType().isEmpty() || this.isAbstract(ed.getType().get(0).getWorkingCode()) || ed.getType().get(0).getWorkingCode().equals(ed.getPath())) {
            if (ed.hasType() && "Resource".equals(ed.getType().get(0).getWorkingCode()) && child.getSelf().hasType() && child.getSelf().getType().get(0).hasProfile()) {
                if (child.getSelf().getType().get(0).getProfile().size() > 1) {
                    throw new FHIRException(this.context.formatMessage("Unhandled_situation_resource_is_profiled_to_more_than_one_option__cannot_sort_profile", new Object[0]));
                }
                StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, (String)child.getSelf().getType().get(0).getProfile().get(0).getValue());
                while (profile != null && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                    profile = this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition());
                }
                ccmp = profile == null ? null : new ElementDefinitionComparer(true, profile.getSnapshot().getElement(), profile.getType(), child.getSelf().getPath().length(), cmp.name, profile.present());
            } else {
                ccmp = new ElementDefinitionComparer(true, cmp.snapshot, cmp.base, cmp.prefixLength, cmp.name, cmp.name);
            }
        } else if (ed.getType().get(0).getWorkingCode().equals("Extension") && child.getSelf().getType().size() == 1 && child.getSelf().getType().get(0).hasProfile()) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, (String)child.getSelf().getType().get(0).getProfile().get(0).getValue());
            ccmp = profile == null ? null : new ElementDefinitionComparer(true, profile.getSnapshot().getElement(), this.resolveType(ed.getType().get(0).getWorkingCode()), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (ed.getType().size() == 1 && !ed.getType().get(0).getWorkingCode().equals("*")) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), this.resolveType(ed.getType().get(0).getWorkingCode()), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (child.getSelf().getType().size() == 1) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(child.getSelf().getType().get(0).getWorkingCode()));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), child.getSelf().getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (ed.getPath().endsWith("[x]") && !child.getSelf().getPath().endsWith("[x]")) {
            StructureDefinition sd;
            String edLastNode = ed.getPath().replaceAll("(.*\\.)*(.*)", "$2");
            String childLastNode = child.getSelf().getPath().replaceAll("(.*\\.)*(.*)", "$2");
            String p = childLastNode.substring(edLastNode.length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize((String)p))) {
                p = Utilities.uncapitalize((String)p);
            }
            if ((sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(p))) == null) {
                throw new Error(this.context.formatMessage("Unable_to_find_profile__at_", p, ed.getId()));
            }
            ccmp = new ElementDefinitionComparer(false, sd.getSnapshot().getElement(), p, child.getSelf().getPath().length(), cmp.name, sd.present());
        } else if (child.getSelf().hasType() && child.getSelf().getType().get(0).getWorkingCode().equals("Reference")) {
            for (ElementDefinition.TypeRefComponent t : child.getSelf().getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new Error(this.context.formatMessage("Cant_have_children_on_an_element_with_a_polymorphic_type__you_must_slice_and_constrain_the_types_first_sortElements_", ed.getPath(), ProfileUtilities.typeCode(ed.getType())));
            }
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), ed.getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (!child.getSelf().hasType() && ed.getType().get(0).getWorkingCode().equals("Reference")) {
            for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new Error(this.context.formatMessage("Not_handled_yet_sortElements_", ed.getPath(), ProfileUtilities.typeCode(ed.getType())));
            }
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), ed.getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs("Element"));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), "Element", child.getSelf().getPath().length(), cmp.name, profile.present());
        }
        return ccmp;
    }

    private String resolveType(String code) {
        StructureDefinition sd;
        if (Utilities.isAbsoluteUrl((String)code) && (sd = this.context.fetchResource(StructureDefinition.class, code)) != null) {
            return sd.getType();
        }
        return code;
    }

    private static String sdNs(String type) {
        return ProfileUtilities.sdNs(type, null);
    }

    public static String sdNs(String type, String overrideVersionNs) {
        if (Utilities.isAbsoluteUrl((String)type)) {
            return type;
        }
        if (overrideVersionNs != null) {
            return Utilities.pathURL((String[])new String[]{overrideVersionNs, type});
        }
        return "http://hl7.org/fhir/StructureDefinition/" + type;
    }

    private boolean isAbstract(String code) {
        return code.equals("Element") || code.equals("BackboneElement") || code.equals("Resource") || code.equals("DomainResource");
    }

    private void writeElements(ElementDefinitionHolder edh, List<ElementDefinition> list) {
        if (!edh.isPlaceHolder()) {
            list.add(edh.getSelf());
        }
        for (ElementDefinitionHolder child : edh.getChildren()) {
            this.writeElements(child, list);
        }
    }

    public void generateSchematrons(OutputStream dest, StructureDefinition structure) throws IOException, DefinitionException {
        if (structure.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new DefinitionException(this.context.formatMessage("not_the_right_kind_of_structure_to_generate_schematrons_for", new Object[0]));
        }
        if (!structure.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, structure.getBaseDefinition());
        if (base != null) {
            SchematronWriter sch = new SchematronWriter(dest, SchematronWriter.SchematronType.PROFILE, base.getName());
            ElementDefinition ed = structure.getSnapshot().getElement().get(0);
            this.generateForChildren(sch, "f:" + ed.getPath(), ed, structure, base);
            sch.dump();
        }
    }

    public void generateCsvs(OutputStream dest, StructureDefinition structure, boolean asXml) throws IOException, DefinitionException, Exception {
        if (!structure.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        CSVWriter csv = new CSVWriter(dest, structure, asXml);
        for (ElementDefinition child : structure.getSnapshot().getElement()) {
            csv.processElement(child);
        }
        csv.dump();
    }

    private Slicer generateSlicer(ElementDefinition child, ElementDefinition.ElementDefinitionSlicingComponent slicing, StructureDefinition structure) {
        if (child.getPath().endsWith(".extension")) {
            ElementDefinition ued = this.getUrlFor(structure, child);
            if (!(ued != null && ued.hasFixed() || child.hasType() && child.getType().get(0).hasProfile())) {
                return new Slicer(false);
            }
            Slicer s = new Slicer(true);
            String url = ued == null || !ued.hasFixed() ? (String)child.getType().get(0).getProfile().get(0).getValue() : ((UriType)ued.getFixed()).asStringValue();
            s.name = " with URL = '" + url + "'";
            s.criteria = "[@url = '" + url + "']";
            return s;
        }
        return new Slicer(false);
    }

    private void generateForChildren(SchematronWriter sch, String xpath, ElementDefinition ed, StructureDefinition structure, StructureDefinition base) throws IOException {
        String name;
        List<ElementDefinition> children = this.getChildList(structure, ed);
        String sliceName = null;
        ElementDefinition.ElementDefinitionSlicingComponent slicing = null;
        for (ElementDefinition child : children) {
            Slicer slicer;
            name = this.tail(child.getPath());
            if (child.hasSlicing()) {
                sliceName = name;
                slicing = child.getSlicing();
            } else if (!name.equals(sliceName)) {
                slicing = null;
            }
            ElementDefinition based = this.getByPath(base, child.getPath());
            boolean doMin = child.getMin() > 0 && (based == null || child.getMin() != based.getMin());
            boolean doMax = child.hasMax() && !child.getMax().equals("*") && (based == null || !child.getMax().equals(based.getMax()));
            Slicer slicer2 = slicer = slicing == null ? new Slicer(true) : this.generateSlicer(child, slicing, structure);
            if (!slicer.check || !doMin && !doMax) continue;
            SchematronWriter.Section s = sch.section(xpath);
            SchematronWriter.Rule r = s.rule(xpath);
            if (doMin) {
                r.assrt("count(f:" + name + slicer.criteria + ") >= " + Integer.toString(child.getMin()), name + slicer.name + ": minimum cardinality of '" + name + "' is " + Integer.toString(child.getMin()));
            }
            if (!doMax) continue;
            r.assrt("count(f:" + name + slicer.criteria + ") <= " + child.getMax(), name + slicer.name + ": maximum cardinality of '" + name + "' is " + child.getMax());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            if (!inv.hasXpath()) continue;
            SchematronWriter.Section s = sch.section(ed.getPath());
            SchematronWriter.Rule r = s.rule(xpath);
            r.assrt(inv.getXpath(), (inv.hasId() ? inv.getId() + ": " : "") + inv.getHuman() + (inv.hasUserData(IS_DERIVED) ? " (inherited)" : ""));
        }
        if (!ed.hasContentReference()) {
            for (ElementDefinition child : children) {
                name = this.tail(child.getPath());
                this.generateForChildren(sch, xpath + "/f:" + name, child, structure, base);
            }
        }
    }

    private ElementDefinition getByPath(StructureDefinition base, String path) {
        for (ElementDefinition ed : base.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                return ed;
            }
            if (!ed.getPath().endsWith("[x]") || ed.getPath().length() > path.length() - 3 || !ed.getPath().substring(0, ed.getPath().length() - 3).equals(path.substring(0, ed.getPath().length() - 3))) continue;
            return ed;
        }
        return null;
    }

    public void setIds(StructureDefinition sd, boolean checkFirst) throws DefinitionException {
        if (!checkFirst || !sd.hasDifferential() || this.hasMissingIds(sd.getDifferential().getElement())) {
            if (!sd.hasDifferential()) {
                sd.setDifferential(new StructureDefinition.StructureDefinitionDifferentialComponent());
            }
            this.generateIds(sd.getDifferential().getElement(), sd.getUrl(), sd.getType());
        }
        if (!checkFirst || !sd.hasSnapshot() || this.hasMissingIds(sd.getSnapshot().getElement())) {
            if (!sd.hasSnapshot()) {
                sd.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
            }
            this.generateIds(sd.getSnapshot().getElement(), sd.getUrl(), sd.getType());
        }
    }

    private boolean hasMissingIds(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (ed.hasId()) continue;
            return true;
        }
        return false;
    }

    private void generateIds(List<ElementDefinition> list, String name, String type) throws DefinitionException {
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, String> idList = new HashMap<String, String>();
        HashMap<String, String> replacedIds = new HashMap<String, String>();
        SliceList sliceInfo = new SliceList();
        for (ElementDefinition ed : list) {
            String s;
            ArrayList<String> paths = new ArrayList<String>();
            if (!ed.hasPath()) {
                throw new DefinitionException(this.context.formatMessage("No_path_on_element_Definition__in_", Integer.toString(list.indexOf(ed)), name));
            }
            sliceInfo.seeElement(ed);
            String[] pl = ed.getPath().split("\\.");
            for (int i = paths.size(); i < pl.length; ++i) {
                paths.add(pl[i]);
            }
            String[] slices = sliceInfo.analyse(paths);
            StringBuilder b = new StringBuilder();
            b.append((String)paths.get(0));
            for (int i = 1; i < paths.size(); ++i) {
                b.append(".");
                s = (String)paths.get(i);
                String p = slices[i];
                b.append(this.fixChars(s));
                if (p == null) continue;
                b.append(":");
                b.append(p);
            }
            String bs = b.toString();
            if (ed.hasId()) {
                replacedIds.put(ed.getId(), ed.getPath());
            }
            ed.setId(bs);
            if (idList.containsKey(bs)) {
                if (this.exception || this.messages == null) {
                    throw new DefinitionException(this.context.formatMessage("Same_id_on_multiple_elements__in_", bs, idList.get(bs), ed.getPath(), name));
                }
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, name + "." + bs, "Duplicate Element id " + bs, ValidationMessage.IssueSeverity.ERROR));
            }
            idList.put(bs, ed.getPath());
            if (!ed.hasContentReference() || !ed.getContentReference().startsWith("#")) continue;
            s = ed.getContentReference();
            if (replacedIds.containsKey(s.substring(1))) {
                ed.setContentReference("http://hl7.org/fhir/StructureDefinition/" + type + "#" + (String)replacedIds.get(s.substring(1)));
                continue;
            }
            ed.setContentReference("http://hl7.org/fhir/StructureDefinition/" + type + s);
        }
    }

    private Object fixChars(String s) {
        return s.replace("_", "-");
    }

    private static String urlTail(String profile) {
        return profile.contains("/") ? profile.substring(profile.lastIndexOf("/") + 1) : profile;
    }

    private String checkName(String name) {
        StringBuilder b = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (Utilities.existsInList((int)c, (int[])new int[]{46, 32, 58, 34, 39, 40, 41, 38, 91, 93})) continue;
            b.append(c);
        }
        return b.toString().toLowerCase();
    }

    private int charCount(String path, char t) {
        int res = 0;
        for (char ch : path.toCharArray()) {
            if (ch != t) continue;
            ++res;
        }
        return res;
    }

    public List<org.hl7.fhir.r4b.elementmodel.Element> generateExamples(StructureDefinition sd, boolean evenWhenNoExamples) throws FHIRException {
        ArrayList<org.hl7.fhir.r4b.elementmodel.Element> examples = new ArrayList<org.hl7.fhir.r4b.elementmodel.Element>();
        if (sd.hasSnapshot()) {
            if (evenWhenNoExamples || this.hasAnyExampleValues(sd)) {
                examples.add(this.generateExample(sd, new BaseExampleValueAccessor()));
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.hasAnyExampleValues(sd, Integer.toString(i))) continue;
                examples.add(this.generateExample(sd, new ExtendedExampleValueAccessor(Integer.toString(i))));
            }
        }
        return examples;
    }

    private org.hl7.fhir.r4b.elementmodel.Element generateExample(StructureDefinition profile, ExampleValueAccessor accessor) throws FHIRException {
        ElementDefinition ed = profile.getSnapshot().getElementFirstRep();
        org.hl7.fhir.r4b.elementmodel.Element r = new org.hl7.fhir.r4b.elementmodel.Element(ed.getPath(), new Property(this.context, ed, profile));
        List<ElementDefinition> children = this.getChildMap(profile, ed);
        for (ElementDefinition child : children) {
            if (child.getPath().endsWith(".id")) {
                org.hl7.fhir.r4b.elementmodel.Element id = new org.hl7.fhir.r4b.elementmodel.Element("id", new Property(this.context, child, profile));
                id.setValue(profile.getId() + accessor.getId());
                r.getChildren().add(id);
                continue;
            }
            org.hl7.fhir.r4b.elementmodel.Element e = this.createExampleElement(profile, child, accessor);
            if (e == null) continue;
            r.getChildren().add(e);
        }
        return r;
    }

    private org.hl7.fhir.r4b.elementmodel.Element createExampleElement(StructureDefinition profile, ElementDefinition ed, ExampleValueAccessor accessor) throws FHIRException {
        DataType v = accessor.getExampleValue(ed);
        if (v != null) {
            return new ObjectConverter(this.context).convert(new Property(this.context, ed, profile), v);
        }
        org.hl7.fhir.r4b.elementmodel.Element res = new org.hl7.fhir.r4b.elementmodel.Element(this.tail(ed.getPath()), new Property(this.context, ed, profile));
        boolean hasValue = false;
        List<ElementDefinition> children = this.getChildMap(profile, ed);
        for (ElementDefinition child : children) {
            org.hl7.fhir.r4b.elementmodel.Element e;
            if (child.hasContentReference() || (e = this.createExampleElement(profile, child, accessor)) == null) continue;
            hasValue = true;
            res.getChildren().add(e);
        }
        if (hasValue) {
            return res;
        }
        return null;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd, String index) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                Extension exv = ToolingExtensions.getExtension(ex, "exValue");
                if (exv == null) continue;
                DataType value = exv.getValue();
                if (!index.equals(ndx) || value == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.hasExample()) continue;
            return true;
        }
        return false;
    }

    public void populateLogicalSnapshot(StructureDefinition sd) throws FHIRException {
        sd.getSnapshot().getElement().add(sd.getDifferential().getElementFirstRep().copy());
        if (sd.hasBaseDefinition()) {
            StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (base == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_find_base_definition_for_logical_model__from_", sd.getBaseDefinition(), sd.getUrl()));
            }
            this.copyElements(sd, base.getSnapshot().getElement());
        }
        this.copyElements(sd, sd.getDifferential().getElement());
    }

    private void copyElements(StructureDefinition sd, List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.getPath().contains(".")) continue;
            ElementDefinition n = ed.copy();
            n.setPath(sd.getSnapshot().getElementFirstRep().getPath() + "." + ed.getPath().substring(ed.getPath().indexOf(".") + 1));
            sd.getSnapshot().addElement(n);
        }
    }

    public void cleanUpDifferential(StructureDefinition sd) {
        if (sd.getDifferential().getElement().size() > 1) {
            this.cleanUpDifferential(sd, 1);
        }
    }

    private void cleanUpDifferential(StructureDefinition sd, int start) {
        int level = Utilities.charCount((String)sd.getDifferential().getElement().get(start).getPath(), (char)'.');
        int c = start;
        int len = sd.getDifferential().getElement().size();
        HashSet<String> paths = new HashSet<String>();
        while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') == level) {
            ElementDefinition ed = sd.getDifferential().getElement().get(c);
            if (!paths.contains(ed.getPath())) {
                int ic;
                paths.add(ed.getPath());
                for (ic = c + 1; ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level; ++ic) {
                }
                ElementDefinition slicer = null;
                ArrayList<ElementDefinition> slices = new ArrayList<ElementDefinition>();
                slices.add(ed);
                while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') == level) {
                    ElementDefinition edi = sd.getDifferential().getElement().get(ic);
                    if (ed.getPath().equals(edi.getPath())) {
                        if (slicer == null) {
                            slicer = new ElementDefinition();
                            slicer.setPath(edi.getPath());
                            slicer.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                            sd.getDifferential().getElement().add(c, slicer);
                            ++c;
                            ++ic;
                        }
                        slices.add(edi);
                    }
                    ++ic;
                    while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level) {
                        ++ic;
                    }
                }
                if (slicer != null) {
                    this.determineSlicing(slicer, slices);
                }
            }
            if (++c >= len || Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') <= level) continue;
            this.cleanUpDifferential(sd, c);
            ++c;
            while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') > level) {
                ++c;
            }
        }
    }

    private void determineSlicing(ElementDefinition slicer, List<ElementDefinition> slices) {
        int i = 0;
        for (ElementDefinition ed : slices) {
            if (ed.hasUserData("slice-name")) {
                ed.setSliceName(ed.getUserString("slice-name"));
                continue;
            }
            ed.setSliceName("slice-" + Integer.toString(++i));
        }
        if (slicer.getPath().endsWith(".extension") || slicer.getPath().endsWith(".modifierExtension")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("url");
        } else if (slicer.getPath().equals("DiagnosticReport.result")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("reference.code");
        } else if (slicer.getPath().equals("Observation.related")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("target.reference.code");
        } else if (slicer.getPath().equals("Bundle.entry")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("resource.@profile");
        } else {
            throw new Error("No slicing for " + slicer.getPath());
        }
    }

    public XhtmlNode generateSpanningTable(StructureDefinition profile, String imageFolder, boolean onlyConstraints, String constraintPrefix, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, false, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = this.initSpanningTable(gen, "", false, profile.getId());
        HashSet<String> processed = new HashSet<String>();
        SpanEntry span = this.buildSpanningTable("(focus)", "", profile, processed, onlyConstraints, constraintPrefix);
        this.genSpanEntry(gen, model.getRows(), span);
        return gen.generate(model, "", 0, outputTracker);
    }

    private SpanEntry buildSpanningTable(String name, String cardinality, StructureDefinition profile, Set<String> processed, boolean onlyConstraints, String constraintPrefix) throws IOException {
        SpanEntry res = this.buildSpanEntryFromProfile(name, cardinality, profile);
        boolean wantProcess = !processed.contains(profile.getUrl());
        processed.add(profile.getUrl());
        if (wantProcess && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                StructureDefinition sd;
                String uri;
                List<String> refProfiles;
                String card;
                if ("0".equals(ed.getMax()) || ed.getType().size() <= 0 || (card = this.getCardinality(ed, profile.getSnapshot().getElement())).endsWith(".0") || (refProfiles = this.listReferenceProfiles(ed)).size() <= 0 || (uri = refProfiles.get(0)) == null || (sd = this.context.fetchResource(StructureDefinition.class, uri)) == null || onlyConstraints && (sd.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT || constraintPrefix != null && !sd.getUrl().startsWith(constraintPrefix))) continue;
                res.getChildren().add(this.buildSpanningTable(this.nameForElement(ed), card, sd, processed, onlyConstraints, constraintPrefix));
            }
        }
        return res;
    }

    private String getCardinality(ElementDefinition ed, List<ElementDefinition> list) {
        int min = ed.getMin();
        int max = !ed.hasMax() || ed.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(ed.getMax());
        ElementDefinition ned = ed;
        while (ned != null && ned.getPath().contains(".")) {
            if ((ned = this.findParent(ned, list)) == null) continue;
            if ("0".equals(ned.getMax())) {
                max = 0;
            } else if (!ned.getMax().equals("1") && !ned.hasSlicing()) {
                max = Integer.MAX_VALUE;
            }
            if (ned.getMin() != 0) continue;
            min = 0;
        }
        return Integer.toString(min) + ".." + (max == Integer.MAX_VALUE ? "*" : Integer.toString(max));
    }

    private ElementDefinition findParent(ElementDefinition ed, List<ElementDefinition> list) {
        int i;
        for (i = list.indexOf(ed) - 1; i >= 0 && !ed.getPath().startsWith(list.get(i).getPath() + "."); --i) {
        }
        if (i == -1) {
            return null;
        }
        return list.get(i);
    }

    private List<String> listReferenceProfiles(ElementDefinition ed) {
        ArrayList<String> res = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (!tr.hasTarget() || !tr.hasTargetProfile()) continue;
            for (UriType uriType : tr.getTargetProfile()) {
                res.add((String)uriType.getValue());
            }
        }
        return res;
    }

    private String nameForElement(ElementDefinition ed) {
        return ed.getPath().substring(ed.getPath().indexOf(".") + 1);
    }

    private SpanEntry buildSpanEntryFromProfile(String name, String cardinality, StructureDefinition profile) throws IOException {
        SpanEntry res = new SpanEntry();
        res.setName(name);
        res.setCardinality(cardinality);
        res.setProfileLink(profile.getUserString("path"));
        res.setResType(profile.getType());
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, res.getResType());
        if (base != null) {
            res.setResLink(base.getUserString("path"));
        }
        res.setId(profile.getId());
        res.setProfile(profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT);
        StringBuilder b = new StringBuilder();
        b.append(res.getResType());
        boolean first = true;
        boolean open = false;
        if (profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            res.setDescription(profile.getName());
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                if (!this.isKeyProperty(ed.getBase().getPath()) || !ed.hasFixed()) continue;
                if (first) {
                    open = true;
                    first = false;
                    b.append("[");
                } else {
                    b.append(", ");
                }
                b.append(this.tail(ed.getBase().getPath()));
                b.append("=");
                b.append(this.summarize(ed.getFixed()));
            }
            if (open) {
                b.append("]");
            }
        } else {
            res.setDescription("Base FHIR " + profile.getName());
        }
        res.setType(b.toString());
        return res;
    }

    private String summarize(DataType value) throws IOException {
        if (value instanceof Coding) {
            return this.summarizeCoding((Coding)value);
        }
        if (value instanceof CodeableConcept) {
            return this.summarizeCodeableConcept((CodeableConcept)value);
        }
        return this.buildJson(value);
    }

    private String summarizeCoding(Coding value) {
        String uri = value.getSystem();
        String system = TerminologyRenderer.describeSystem(uri);
        if (Utilities.isURL((String)system) && system.equals("http://cap.org/protocols")) {
            system = "CAP Code";
        }
        return system + " " + value.getCode();
    }

    private String summarizeCodeableConcept(CodeableConcept value) {
        if (value.hasCoding()) {
            return this.summarizeCoding(value.getCodingFirstRep());
        }
        return value.getText();
    }

    private boolean isKeyProperty(String path) {
        return Utilities.existsInList((String)path, (String[])new String[]{"Observation.code"});
    }

    public HierarchicalTableGenerator.TableModel initSpanningTable(HierarchicalTableGenerator gen, String prefix, boolean isLogical, String id) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setDocoImg(prefix + "help16.png");
        model.setDocoRef(Utilities.pathURL((String[])new String[]{prefix, "formats.html#table"}));
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), "Property", "A profiled resource", null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), "Card.", "Minimum and Maximum # of times the the element can appear in the instance", null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), "Content", "What goes here", null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), "Description", "Description of the profile", null, 0));
        return model;
    }

    private void genSpanEntry(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, SpanEntry span) throws IOException {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        rows.add(row);
        row.setAnchor(span.getId());
        if (span.isProfile()) {
            row.setIcon("icon_profile.png", "Profile");
        } else {
            row.setIcon("icon_resource.png", "Resource");
        }
        List list = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, span.getName(), null, null));
        List list2 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, span.getCardinality(), null, null));
        List list3 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, span.getProfileLink(), span.getType(), null, null));
        List list4 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, span.getDescription(), null, null));
        for (SpanEntry child : span.getChildren()) {
            this.genSpanEntry(gen, row.getSubRows(), child);
        }
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent interpretR2Discriminator(String discriminator, boolean isExists) {
        if (discriminator.endsWith("@pattern")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PATTERN, discriminator.length() == 8 ? "" : discriminator.substring(0, discriminator.length() - 9));
        }
        if (discriminator.endsWith("@profile")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PROFILE, discriminator.length() == 8 ? "" : discriminator.substring(0, discriminator.length() - 9));
        }
        if (discriminator.endsWith("@type")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.TYPE, discriminator.length() == 5 ? "" : discriminator.substring(0, discriminator.length() - 6));
        }
        if (discriminator.endsWith("@exists")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.EXISTS, discriminator.length() == 7 ? "" : discriminator.substring(0, discriminator.length() - 8));
        }
        if (isExists) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.EXISTS, discriminator);
        }
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(ElementDefinition.DiscriminatorType.VALUE).setPath(discriminator);
    }

    private static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent makeDiscriminator(ElementDefinition.DiscriminatorType dType, String str) {
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(dType).setPath(Utilities.noString((String)str) ? "$this" : str);
    }

    public static String buildR2Discriminator(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t) throws FHIRException {
        switch (t.getType()) {
            case PROFILE: {
                return t.getPath() + "/@profile";
            }
            case PATTERN: {
                return t.getPath() + "/@pattern";
            }
            case TYPE: {
                return t.getPath() + "/@type";
            }
            case VALUE: {
                return t.getPath();
            }
            case EXISTS: {
                return t.getPath();
            }
        }
        throw new FHIRException("Unable to represent " + t.getType().toCode() + ":" + t.getPath() + " in R2");
    }

    public static StructureDefinition makeExtensionForVersionedURL(IWorkerContext context, String url) {
        String epath = url.substring(54);
        if (!epath.contains(".")) {
            return null;
        }
        String type = epath.substring(0, epath.indexOf("."));
        StructureDefinition sd = context.fetchTypeDefinition(type);
        if (sd == null) {
            return null;
        }
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.getPath().equals(epath)) continue;
            ed = t;
            break;
        }
        if (ed == null) {
            return null;
        }
        if ("Element".equals(ed.typeSummary()) || "BackboneElement".equals(ed.typeSummary())) {
            return null;
        }
        StructureDefinition template = context.fetchResource(StructureDefinition.class, "http://fhir-registry.smarthealthit.org/StructureDefinition/capabilities");
        StructureDefinition ext = template.copy();
        ext.setUrl(url);
        ext.setId("extension-" + epath);
        ext.setName("Extension-" + epath);
        ext.setTitle("Extension for r4 " + epath);
        ext.setStatus(sd.getStatus());
        ext.setDate(sd.getDate());
        ext.getContact().clear();
        ext.getContact().addAll(sd.getContact());
        ext.setFhirVersion(sd.getFhirVersion());
        ext.setDescription(ed.getDefinition());
        ext.getContext().clear();
        ext.addContext().setType(StructureDefinition.ExtensionContextType.ELEMENT).setExpression(epath.substring(0, epath.lastIndexOf(".")));
        ext.getDifferential().getElement().clear();
        ext.getSnapshot().getElement().get(3).setFixed(new UriType(url));
        ext.getSnapshot().getElement().set(4, ed.copy());
        ext.getSnapshot().getElement().get(4).setPath("Extension.value" + Utilities.capitalize((String)ed.typeSummary()));
        return ext;
    }

    public boolean isThrowException() {
        return this.exception;
    }

    public void setThrowException(boolean exception) {
        this.exception = exception;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public void setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public boolean isNewSlicingProcessing() {
        return this.newSlicingProcessing;
    }

    public void setNewSlicingProcessing(boolean newSlicingProcessing) {
        this.newSlicingProcessing = newSlicingProcessing;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDefWebRoot() {
        return this.defWebRoot;
    }

    public void setDefWebRoot(String defWebRoot) {
        this.defWebRoot = defWebRoot;
        if (!this.defWebRoot.endsWith("/")) {
            this.defWebRoot = this.defWebRoot + '/';
        }
    }

    public static StructureDefinition makeBaseDefinition(Enumerations.FHIRVersion fhirVersion) {
        StructureDefinition base = new StructureDefinition();
        base.setId("Base");
        base.setUrl("http://hl7.org/fhir/StructureDefinition/Base");
        base.setVersion(fhirVersion.toCode());
        base.setName("Base");
        base.setStatus(Enumerations.PublicationStatus.ACTIVE);
        base.setDate(new Date());
        base.setFhirVersion(fhirVersion);
        base.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        base.setAbstract(true);
        base.setType("Base");
        ElementDefinition e = base.getSnapshot().getElementFirstRep();
        e.setId("Base");
        e.setPath("Base");
        e.setMin(0);
        e.setMax("*");
        e.getBase().setPath("Base");
        e.getBase().setMin(0);
        e.getBase().setMax("*");
        e.setIsModifier(false);
        e = base.getDifferential().getElementFirstRep();
        e.setId("Base");
        e.setPath("Base");
        e.setMin(0);
        e.setMax("*");
        return base;
    }

    public XVerExtensionManager getXver() {
        return this.xver;
    }

    public ProfileUtilities setXver(XVerExtensionManager xver) {
        this.xver = xver;
        return this;
    }

    public List<ElementChoiceGroup> readChoices(ElementDefinition ed, List<ElementDefinition> children) {
        ArrayList<ElementChoiceGroup> result = new ArrayList<ElementChoiceGroup>();
        for (ElementDefinition.ElementDefinitionConstraintComponent c : ed.getConstraint()) {
            ElementChoiceGroup grp = this.processConstraint(children, c);
            if (grp == null) continue;
            result.add(grp);
        }
        return result;
    }

    private ElementChoiceGroup processConstraint(List<ElementDefinition> children, ElementDefinition.ElementDefinitionConstraintComponent c) {
        if (!c.hasExpression()) {
            return null;
        }
        ExpressionNode expr = null;
        try {
            expr = this.fpe.parse(c.getExpression());
        }
        catch (Exception e) {
            return null;
        }
        if (expr.getKind() != ExpressionNode.Kind.Group || expr.getOpNext() == null || expr.getOperation() != ExpressionNode.Operation.Equals && expr.getOperation() != ExpressionNode.Operation.LessOrEqual) {
            return null;
        }
        ExpressionNode n2 = expr.getOpNext();
        if (n2.getKind() != ExpressionNode.Kind.Constant || n2.getInner() != null || n2.getOpNext() != null || !"1".equals(n2.getConstant().primitiveValue())) {
            return null;
        }
        ElementChoiceGroup grp = new ElementChoiceGroup(c.getKey(), expr.getOperation() == ExpressionNode.Operation.Equals);
        for (ExpressionNode n1 = expr.getGroup(); n1 != null; n1 = n1.getOpNext()) {
            if (n1.getKind() != ExpressionNode.Kind.Name || n1.getInner() != null) {
                return null;
            }
            grp.elements.add(n1.getName());
            if (n1.getOperation() == null || n1.getOperation() == ExpressionNode.Operation.Union) {
                continue;
            }
            return null;
        }
        int total = 0;
        for (String n : grp.elements) {
            boolean found = false;
            for (ElementDefinition child : children) {
                String name = this.tail(child.getPath());
                if (!n.equals(name)) continue;
                found = true;
                if ("0".equals(child.getMax())) continue;
                ++total;
            }
            if (found) continue;
            return null;
        }
        if (total <= 1) {
            return null;
        }
        return grp;
    }

    public static boolean allTypesMustSupport(ElementDefinition e) {
        boolean all = true;
        boolean any = false;
        for (ElementDefinition.TypeRefComponent tr : e.getType()) {
            all = all && ProfileUtilities.isMustSupport(tr);
            any = any || ProfileUtilities.isMustSupport(tr);
        }
        return !all && !any;
    }

    public static boolean allProfilesMustSupport(List<CanonicalType> profiles) {
        boolean all = true;
        boolean any = false;
        for (CanonicalType u : profiles) {
            all = all && ProfileUtilities.isMustSupport(u);
            any = any || ProfileUtilities.isMustSupport(u);
        }
        return !all && !any;
    }

    public static boolean isMustSupportDirect(ElementDefinition.TypeRefComponent tr) {
        return "true".equals(ToolingExtensions.readStringExtension(tr, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"));
    }

    public static boolean isMustSupport(ElementDefinition.TypeRefComponent tr) {
        if ("true".equals(ToolingExtensions.readStringExtension(tr, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        if (ProfileUtilities.isMustSupport(tr.getProfile())) {
            return true;
        }
        return ProfileUtilities.isMustSupport(tr.getTargetProfile());
    }

    public static boolean isMustSupport(List<CanonicalType> profiles) {
        for (CanonicalType ct : profiles) {
            if (!ProfileUtilities.isMustSupport(ct)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMustSupport(CanonicalType profile) {
        return "true".equals(ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"));
    }

    public ElementDefinitionResolution resolveContentRef(StructureDefinition structure, ElementDefinition element) {
        return this.getElementById(structure, structure.getSnapshot().getElement(), element.getContentReference());
    }

    public Set<String> getMasterSourceFileNames() {
        return this.masterSourceFileNames;
    }

    public void setMasterSourceFileNames(Set<String> masterSourceFileNames) {
        this.masterSourceFileNames = masterSourceFileNames;
    }

    public class SpanEntry {
        private List<SpanEntry> children = new ArrayList<SpanEntry>();
        private boolean profile;
        private String id;
        private String name;
        private String resType;
        private String cardinality;
        private String description;
        private String profileLink;
        private String resLink;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResType() {
            return this.resType;
        }

        public void setResType(String resType) {
            this.resType = resType;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProfileLink() {
            return this.profileLink;
        }

        public void setProfileLink(String profileLink) {
            this.profileLink = profileLink;
        }

        public String getResLink() {
            return this.resLink;
        }

        public void setResLink(String resLink) {
            this.resLink = resLink;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isProfile() {
            return this.profile;
        }

        public void setProfile(boolean profile) {
            this.profile = profile;
        }

        public List<SpanEntry> getChildren() {
            return this.children;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    private class ExtendedExampleValueAccessor
    implements ExampleValueAccessor {
        private String index;

        public ExtendedExampleValueAccessor(String index) {
            this.index = index;
        }

        @Override
        public DataType getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                DataType value = ToolingExtensions.getExtension(ex, "exValue").getValue();
                if (!this.index.equals(ndx) || value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample-" + this.index;
        }
    }

    private class BaseExampleValueAccessor
    implements ExampleValueAccessor {
        private BaseExampleValueAccessor() {
        }

        @Override
        public DataType getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            if (ed.hasExample()) {
                return ed.getExample().get(0).getValue();
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample";
        }
    }

    private static interface ExampleValueAccessor {
        public DataType getExampleValue(ElementDefinition var1);

        public String getId();
    }

    public class SliceList {
        private Map<String, String> slices = new HashMap<String, String>();

        public void seeElement(ElementDefinition ed) {
            Iterator<Map.Entry<String, String>> iter = this.slices.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (entry.getKey().length() <= ed.getPath().length() && !entry.getKey().equals(ed.getPath())) continue;
                iter.remove();
            }
            if (ed.hasSliceName()) {
                this.slices.put(ed.getPath(), ed.getSliceName());
            }
        }

        public String[] analyse(List<String> paths) {
            String s = paths.get(0);
            String[] res = new String[paths.size()];
            res[0] = null;
            for (int i = 1; i < paths.size(); ++i) {
                res[i] = this.slices.containsKey(s = s + "." + paths.get(i)) ? this.slices.get(s) : null;
            }
            return res;
        }
    }

    private class Slicer
    extends ElementDefinition.ElementDefinitionSlicingComponent {
        String criteria = "";
        String name = "";
        boolean check;

        public Slicer(boolean cantCheck) {
            this.check = cantCheck;
        }
    }

    private static class ElementNameCompare
    implements Comparator<ElementDefinition> {
        private ElementNameCompare() {
        }

        @Override
        public int compare(ElementDefinition o1, ElementDefinition o2) {
            String path2;
            String path1 = ElementNameCompare.normalizePath(o1);
            int cmp = path1.compareTo(path2 = ElementNameCompare.normalizePath(o2));
            if (cmp == 0) {
                String name1 = o1.hasSliceName() ? o1.getSliceName() : "";
                String name2 = o2.hasSliceName() ? o2.getSliceName() : "";
                cmp = name1.compareTo(name2);
            }
            return cmp;
        }

        private static String normalizePath(ElementDefinition e) {
            if (!e.hasPath()) {
                return "";
            }
            String path = e.getPath();
            if (path.endsWith("[x]")) {
                path = path.substring(0, path.length() - 3);
            }
            return path;
        }
    }

    public static class ElementDefinitionComparer
    implements Comparator<ElementDefinitionHolder> {
        private boolean inExtension;
        private List<ElementDefinition> snapshot;
        private int prefixLength;
        private String base;
        private String name;
        private String baseName;
        private Set<String> errors = new HashSet<String>();

        public ElementDefinitionComparer(boolean inExtension, List<ElementDefinition> snapshot, String base, int prefixLength, String name, String baseName) {
            this.inExtension = inExtension;
            this.snapshot = snapshot;
            this.prefixLength = prefixLength;
            this.base = base;
            if (Utilities.isAbsoluteUrl((String)base)) {
                this.base = ProfileUtilities.urlTail(base);
            }
            this.name = name;
            this.baseName = baseName;
        }

        @Override
        public int compare(ElementDefinitionHolder o1, ElementDefinitionHolder o2) {
            if (o1.getBaseIndex() == 0) {
                o1.setBaseIndex(this.find(o1.getSelf().getPath(), true));
            }
            if (o2.getBaseIndex() == 0) {
                o2.setBaseIndex(this.find(o2.getSelf().getPath(), true));
            }
            return o1.getBaseIndex() - o2.getBaseIndex();
        }

        private int find(String path, boolean mandatory) {
            String op = path;
            int lc = 0;
            String actual = this.base + path.substring(this.prefixLength);
            for (int i = 0; i < this.snapshot.size(); ++i) {
                String p = this.snapshot.get(i).getPath();
                if (p.equals(actual)) {
                    return i;
                }
                if (p.endsWith("[x]") && actual.startsWith(p.substring(0, p.length() - 3)) && !actual.endsWith("[x]") && !actual.substring(p.length() - 3).contains(".")) {
                    return i;
                }
                if (actual.endsWith("[x]") && p.startsWith(actual.substring(0, actual.length() - 3)) && !p.substring(actual.length() - 3).contains(".")) {
                    return i;
                }
                if (!path.startsWith(p + ".") || !this.snapshot.get(i).hasContentReference()) continue;
                String ref = this.snapshot.get(i).getContentReference();
                path = ref.substring(1, 2).toUpperCase().equals(ref.substring(1, 2)) ? (actual = this.base + (ref.substring(1) + "." + path.substring(p.length() + 1)).substring(this.prefixLength)) : (ref.startsWith("http:") ? (actual = this.base + (ref.substring(ref.indexOf("#") + 1) + "." + path.substring(p.length() + 1)).substring(this.prefixLength)) : (actual = this.base + (path.substring(0, path.indexOf(".") + 1) + ref.substring(1) + "." + path.substring(p.length() + 1)).substring(this.prefixLength)));
                i = 0;
                if (++lc <= 10) continue;
                throw new Error("Internal recursion detection: find() loop path recursion > 10 - check paths are valid (for path " + path + "/" + op + ")");
            }
            if (mandatory) {
                if (this.prefixLength == 0) {
                    this.errors.add("Differential contains path " + path + " which is not found in the in base " + this.baseName);
                } else {
                    this.errors.add("Differential contains path " + path + " which is actually " + actual + ", which is not found in the in base " + this.baseName);
                }
            }
            return 0;
        }

        public void checkForErrors(List<String> errorList) {
            if (this.errors.size() > 0) {
                for (String s : this.errors) {
                    if (s.startsWith("!")) {
                        errorList.add("!StructureDefinition " + this.name + ": " + s.substring(1));
                        continue;
                    }
                    errorList.add("StructureDefinition " + this.name + ": " + s);
                }
            }
        }
    }

    public static class ElementDefinitionHolder {
        private String name;
        private ElementDefinition self;
        private int baseIndex = 0;
        private List<ElementDefinitionHolder> children;
        private boolean placeHolder = false;

        public ElementDefinitionHolder(ElementDefinition self, boolean isPlaceholder) {
            this.self = self;
            this.name = self.getPath();
            this.placeHolder = isPlaceholder;
            this.children = new ArrayList<ElementDefinitionHolder>();
        }

        public ElementDefinitionHolder(ElementDefinition self) {
            this(self, false);
        }

        public ElementDefinition getSelf() {
            return this.self;
        }

        public List<ElementDefinitionHolder> getChildren() {
            return this.children;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }

        public void setBaseIndex(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        public boolean isPlaceHolder() {
            return this.placeHolder;
        }

        public String toString() {
            if (this.self.hasSliceName()) {
                return this.self.getPath() + "(" + this.self.getSliceName() + ")";
            }
            return this.self.getPath();
        }
    }

    private class ElementInStructure {
        private StructureDefinition source;
        private ElementDefinition element;

        public ElementInStructure(StructureDefinition source, ElementDefinition ed) {
            this.source = source;
            this.element = ed;
        }

        public StructureDefinition getSource() {
            return this.source;
        }

        public ElementDefinition getElement() {
            return this.element;
        }
    }

    public static interface ProfileKnowledgeProvider {
        public boolean isDatatype(String var1);

        public boolean isResource(String var1);

        public boolean hasLinkFor(String var1);

        public String getLinkFor(String var1, String var2);

        public BindingResolution resolveBinding(StructureDefinition var1, ElementDefinition.ElementDefinitionBindingComponent var2, String var3) throws FHIRException;

        public BindingResolution resolveBinding(StructureDefinition var1, String var2, String var3) throws FHIRException;

        public String getLinkForProfile(StructureDefinition var1, String var2);

        public boolean prependLinks();

        public String getLinkForUrl(String var1, String var2);

        public static class BindingResolution {
            public String display;
            public String url;
        }
    }

    public static class UnusedTracker {
        private boolean used;
    }

    public class ExtensionContext {
        private ElementDefinition element;
        private StructureDefinition defn;

        public ExtensionContext(StructureDefinition ext, ElementDefinition ed) {
            this.defn = ext;
            this.element = ed;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public StructureDefinition getDefn() {
            return this.defn;
        }

        public String getUrl() {
            if (this.element == this.defn.getSnapshot().getElement().get(0)) {
                return this.defn.getUrl();
            }
            return this.element.getSliceName();
        }

        public ElementDefinition getExtensionValueDefinition() {
            for (int i = this.defn.getSnapshot().getElement().indexOf(this.element) + 1; i < this.defn.getSnapshot().getElement().size(); ++i) {
                ElementDefinition ed = this.defn.getSnapshot().getElement().get(i);
                if (ed.getPath().equals(this.element.getPath())) {
                    return null;
                }
                if (!ed.getPath().startsWith(this.element.getPath() + ".value") || ed.hasSlicing()) continue;
                return ed;
            }
            return null;
        }
    }

    public static class ElementChoiceGroup {
        private HierarchicalTableGenerator.Row row;
        private String name;
        private boolean mandatory;
        private List<String> elements = new ArrayList<String>();

        public ElementChoiceGroup(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public HierarchicalTableGenerator.Row getRow() {
            return this.row;
        }

        public List<String> getElements() {
            return this.elements;
        }

        public void setRow(HierarchicalTableGenerator.Row row) {
            this.row = row;
        }

        public String getName() {
            return this.name;
        }
    }

    public class BaseTypeSlice {
        private ElementDefinition defn;
        private String type;
        private int start;
        private int end;
        public boolean handled;

        public BaseTypeSlice(ElementDefinition defn, String type, int start, int end) {
            this.defn = defn;
            this.type = type;
            this.start = start;
            this.end = end;
        }
    }

    public class TypeSlice {
        private ElementDefinition defn;
        private String type;

        public TypeSlice(ElementDefinition defn, String type) {
            this.defn = defn;
            this.type = type;
        }

        public ElementDefinition getDefn() {
            return this.defn;
        }

        public String getType() {
            return this.type;
        }
    }

    public class ElementRedirection {
        private String path;
        private ElementDefinition element;

        public ElementRedirection(ElementDefinition element, String path) {
            this.path = path;
            this.element = element;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public String toString() {
            return this.element.toString() + " : " + this.path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class ElementDefinitionResolution {
        private StructureDefinition source;
        private ElementDefinition element;

        public ElementDefinitionResolution(StructureDefinition source, ElementDefinition element) {
            this.source = source;
            this.element = element;
        }

        public StructureDefinition getSource() {
            return this.source;
        }

        public ElementDefinition getElement() {
            return this.element;
        }
    }
}

