/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="HumanName")
public class HumanName
extends DataType
implements ICompositeType {
    @Child(name="use", type={CodeType.class}, order=0, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="usual | official | temp | nickname | anonymous | old | maiden", formalDefinition="Identifies the purpose for this name.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/name-use")
    protected Enumeration<NameUse> use;
    @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text representation of the full name", formalDefinition="Specifies the entire name as it should be displayed e.g. on an application UI. This may be provided instead of or as well as the specific parts.")
    protected StringType text;
    @Child(name="family", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Family name (often called 'Surname')", formalDefinition="The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.")
    protected StringType family;
    @Child(name="given", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Given names (not always 'first'). Includes middle names", formalDefinition="Given name.")
    protected List<StringType> given;
    @Child(name="prefix", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parts that come before the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.")
    protected List<StringType> prefix;
    @Child(name="suffix", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parts that come after the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.")
    protected List<StringType> suffix;
    @Child(name="period", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when name was/is in use", formalDefinition="Indicates the period of time when this name was valid for the named person.")
    protected Period period;
    private static final long serialVersionUID = -507469160L;

    public Enumeration<NameUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<NameUse>(new NameUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public HumanName setUseElement(Enumeration<NameUse> value) {
        this.use = value;
        return this;
    }

    public NameUse getUse() {
        return this.use == null ? null : (NameUse)((Object)this.use.getValue());
    }

    public HumanName setUse(NameUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<NameUse>(new NameUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public HumanName setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public HumanName setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    public StringType getFamilyElement() {
        if (this.family == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.family");
            }
            if (Configuration.doAutoCreate()) {
                this.family = new StringType();
            }
        }
        return this.family;
    }

    public boolean hasFamilyElement() {
        return this.family != null && !this.family.isEmpty();
    }

    public boolean hasFamily() {
        return this.family != null && !this.family.isEmpty();
    }

    public HumanName setFamilyElement(StringType value) {
        this.family = value;
        return this;
    }

    public String getFamily() {
        return this.family == null ? null : (String)this.family.getValue();
    }

    public HumanName setFamily(String value) {
        if (Utilities.noString((String)value)) {
            this.family = null;
        } else {
            if (this.family == null) {
                this.family = new StringType();
            }
            this.family.setValue(value);
        }
        return this;
    }

    public List<StringType> getGiven() {
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        return this.given;
    }

    public HumanName setGiven(List<StringType> theGiven) {
        this.given = theGiven;
        return this;
    }

    public boolean hasGiven() {
        if (this.given == null) {
            return false;
        }
        for (StringType item : this.given) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addGivenElement() {
        StringType t = new StringType();
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        this.given.add(t);
        return t;
    }

    public HumanName addGiven(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        this.given.add(t);
        return this;
    }

    public boolean hasGiven(String value) {
        if (this.given == null) {
            return false;
        }
        for (StringType v : this.given) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getPrefix() {
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        return this.prefix;
    }

    public HumanName setPrefix(List<StringType> thePrefix) {
        this.prefix = thePrefix;
        return this;
    }

    public boolean hasPrefix() {
        if (this.prefix == null) {
            return false;
        }
        for (StringType item : this.prefix) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addPrefixElement() {
        StringType t = new StringType();
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        this.prefix.add(t);
        return t;
    }

    public HumanName addPrefix(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        this.prefix.add(t);
        return this;
    }

    public boolean hasPrefix(String value) {
        if (this.prefix == null) {
            return false;
        }
        for (StringType v : this.prefix) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getSuffix() {
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        return this.suffix;
    }

    public HumanName setSuffix(List<StringType> theSuffix) {
        this.suffix = theSuffix;
        return this;
    }

    public boolean hasSuffix() {
        if (this.suffix == null) {
            return false;
        }
        for (StringType item : this.suffix) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSuffixElement() {
        StringType t = new StringType();
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        this.suffix.add(t);
        return t;
    }

    public HumanName addSuffix(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        this.suffix.add(t);
        return this;
    }

    public boolean hasSuffix(String value) {
        if (this.suffix == null) {
            return false;
        }
        for (StringType v : this.suffix) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public HumanName setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("use", "code", "Identifies the purpose for this name.", 0, 1, this.use));
        children.add(new Property("text", "string", "Specifies the entire name as it should be displayed e.g. on an application UI. This may be provided instead of or as well as the specific parts.", 0, 1, this.text));
        children.add(new Property("family", "string", "The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.", 0, 1, this.family));
        children.add(new Property("given", "string", "Given name.", 0, Integer.MAX_VALUE, this.given));
        children.add(new Property("prefix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.", 0, Integer.MAX_VALUE, this.prefix));
        children.add(new Property("suffix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.", 0, Integer.MAX_VALUE, this.suffix));
        children.add(new Property("period", "Period", "Indicates the period of time when this name was valid for the named person.", 0, 1, this.period));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116103: {
                return new Property("use", "code", "Identifies the purpose for this name.", 0, 1, this.use);
            }
            case 3556653: {
                return new Property("text", "string", "Specifies the entire name as it should be displayed e.g. on an application UI. This may be provided instead of or as well as the specific parts.", 0, 1, this.text);
            }
            case -1281860764: {
                return new Property("family", "string", "The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.", 0, 1, this.family);
            }
            case 98367357: {
                return new Property("given", "string", "Given name.", 0, Integer.MAX_VALUE, this.given);
            }
            case -980110702: {
                return new Property("prefix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.", 0, Integer.MAX_VALUE, this.prefix);
            }
            case -891422895: {
                return new Property("suffix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.", 0, Integer.MAX_VALUE, this.suffix);
            }
            case -991726143: {
                return new Property("period", "Period", "Indicates the period of time when this name was valid for the named person.", 0, 1, this.period);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.use;
                }
                return baseArray;
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.text;
                }
                return baseArray;
            }
            case -1281860764: {
                Base[] baseArray;
                if (this.family == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.family;
                }
                return baseArray;
            }
            case 98367357: {
                return this.given == null ? new Base[]{} : this.given.toArray(new Base[this.given.size()]);
            }
            case -980110702: {
                return this.prefix == null ? new Base[]{} : this.prefix.toArray(new Base[this.prefix.size()]);
            }
            case -891422895: {
                return this.suffix == null ? new Base[]{} : this.suffix.toArray(new Base[this.suffix.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116103: {
                value = new NameUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
                return value;
            }
            case 3556653: {
                this.text = TypeConvertor.castToString(value);
                return value;
            }
            case -1281860764: {
                this.family = TypeConvertor.castToString(value);
                return value;
            }
            case 98367357: {
                this.getGiven().add(TypeConvertor.castToString(value));
                return value;
            }
            case -980110702: {
                this.getPrefix().add(TypeConvertor.castToString(value));
                return value;
            }
            case -891422895: {
                this.getSuffix().add(TypeConvertor.castToString(value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            value = new NameUseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals("text")) {
            this.text = TypeConvertor.castToString(value);
        } else if (name.equals("family")) {
            this.family = TypeConvertor.castToString(value);
        } else if (name.equals("given")) {
            this.getGiven().add(TypeConvertor.castToString(value));
        } else if (name.equals("prefix")) {
            this.getPrefix().add(TypeConvertor.castToString(value));
        } else if (name.equals("suffix")) {
            this.getSuffix().add(TypeConvertor.castToString(value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return this.getUseElement();
            }
            case 3556653: {
                return this.getTextElement();
            }
            case -1281860764: {
                return this.getFamilyElement();
            }
            case 98367357: {
                return this.addGivenElement();
            }
            case -980110702: {
                return this.addPrefixElement();
            }
            case -891422895: {
                return this.addSuffixElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return new String[]{"code"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
            case -1281860764: {
                return new String[]{"string"};
            }
            case 98367357: {
                return new String[]{"string"};
            }
            case -980110702: {
                return new String[]{"string"};
            }
            case -891422895: {
                return new String[]{"string"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.use");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.text");
        }
        if (name.equals("family")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.family");
        }
        if (name.equals("given")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.given");
        }
        if (name.equals("prefix")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.prefix");
        }
        if (name.equals("suffix")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.suffix");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HumanName";
    }

    @Override
    public HumanName copy() {
        HumanName dst = new HumanName();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(HumanName dst) {
        super.copyValues(dst);
        dst.use = this.use == null ? null : this.use.copy();
        dst.text = this.text == null ? null : this.text.copy();
        StringType stringType = dst.family = this.family == null ? null : this.family.copy();
        if (this.given != null) {
            dst.given = new ArrayList<StringType>();
            for (StringType i : this.given) {
                dst.given.add(i.copy());
            }
        }
        if (this.prefix != null) {
            dst.prefix = new ArrayList<StringType>();
            for (StringType i : this.prefix) {
                dst.prefix.add(i.copy());
            }
        }
        if (this.suffix != null) {
            dst.suffix = new ArrayList<StringType>();
            for (StringType i : this.suffix) {
                dst.suffix.add(i.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
    }

    protected HumanName typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof HumanName)) {
            return false;
        }
        HumanName o = (HumanName)other_;
        return HumanName.compareDeep(this.use, o.use, true) && HumanName.compareDeep(this.text, o.text, true) && HumanName.compareDeep(this.family, o.family, true) && HumanName.compareDeep(this.given, o.given, true) && HumanName.compareDeep(this.prefix, o.prefix, true) && HumanName.compareDeep(this.suffix, o.suffix, true) && HumanName.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof HumanName)) {
            return false;
        }
        HumanName o = (HumanName)other_;
        return HumanName.compareValues(this.use, o.use, true) && HumanName.compareValues(this.text, o.text, true) && HumanName.compareValues(this.family, o.family, true) && HumanName.compareValues(this.given, o.given, true) && HumanName.compareValues(this.prefix, o.prefix, true) && HumanName.compareValues(this.suffix, o.suffix, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.use, this.text, this.family, this.given, this.prefix, this.suffix, this.period});
    }

    public String getGivenAsSingleString() {
        return HumanName.joinStringsSpaceSeparated(this.getGiven());
    }

    public String getPrefixAsSingleString() {
        return HumanName.joinStringsSpaceSeparated(this.getPrefix());
    }

    public String getSuffixAsSingleString() {
        return HumanName.joinStringsSpaceSeparated(this.getSuffix());
    }

    public String getNameAsSingleString() {
        ArrayList<StringType> nameParts = new ArrayList<StringType>();
        nameParts.addAll(this.getPrefix());
        nameParts.addAll(this.getGiven());
        nameParts.add(this.getFamilyElement());
        nameParts.addAll(this.getSuffix());
        if (nameParts.size() > 0) {
            return HumanName.joinStringsSpaceSeparated(nameParts);
        }
        return (String)this.getTextElement().getValue();
    }

    private static String joinStringsSpaceSeparated(List<? extends IPrimitiveType<String>> theStrings) {
        StringBuilder b = new StringBuilder();
        for (IPrimitiveType<String> iPrimitiveType : theStrings) {
            if (iPrimitiveType.isEmpty()) continue;
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append((String)iPrimitiveType.getValue());
        }
        return b.toString();
    }

    public static class NameUseEnumFactory
    implements EnumFactory<NameUse> {
        @Override
        public NameUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return NameUse.USUAL;
            }
            if ("official".equals(codeString)) {
                return NameUse.OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return NameUse.TEMP;
            }
            if ("nickname".equals(codeString)) {
                return NameUse.NICKNAME;
            }
            if ("anonymous".equals(codeString)) {
                return NameUse.ANONYMOUS;
            }
            if ("old".equals(codeString)) {
                return NameUse.OLD;
            }
            if ("maiden".equals(codeString)) {
                return NameUse.MAIDEN;
            }
            throw new IllegalArgumentException("Unknown NameUse code '" + codeString + "'");
        }

        public Enumeration<NameUse> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NameUse>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.USUAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.OFFICIAL);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.TEMP);
            }
            if ("nickname".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.NICKNAME);
            }
            if ("anonymous".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.ANONYMOUS);
            }
            if ("old".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.OLD);
            }
            if ("maiden".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.MAIDEN);
            }
            throw new FHIRException("Unknown NameUse code '" + codeString + "'");
        }

        @Override
        public String toCode(NameUse code) {
            if (code == NameUse.USUAL) {
                return "usual";
            }
            if (code == NameUse.OFFICIAL) {
                return "official";
            }
            if (code == NameUse.TEMP) {
                return "temp";
            }
            if (code == NameUse.NICKNAME) {
                return "nickname";
            }
            if (code == NameUse.ANONYMOUS) {
                return "anonymous";
            }
            if (code == NameUse.OLD) {
                return "old";
            }
            if (code == NameUse.MAIDEN) {
                return "maiden";
            }
            return "?";
        }

        @Override
        public String toSystem(NameUse code) {
            return code.getSystem();
        }
    }

    public static enum NameUse {
        USUAL,
        OFFICIAL,
        TEMP,
        NICKNAME,
        ANONYMOUS,
        OLD,
        MAIDEN,
        NULL;


        public static NameUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return USUAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("nickname".equals(codeString)) {
                return NICKNAME;
            }
            if ("anonymous".equals(codeString)) {
                return ANONYMOUS;
            }
            if ("old".equals(codeString)) {
                return OLD;
            }
            if ("maiden".equals(codeString)) {
                return MAIDEN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NameUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USUAL: {
                    return "usual";
                }
                case OFFICIAL: {
                    return "official";
                }
                case TEMP: {
                    return "temp";
                }
                case NICKNAME: {
                    return "nickname";
                }
                case ANONYMOUS: {
                    return "anonymous";
                }
                case OLD: {
                    return "old";
                }
                case MAIDEN: {
                    return "maiden";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USUAL: {
                    return "http://hl7.org/fhir/name-use";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/name-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/name-use";
                }
                case NICKNAME: {
                    return "http://hl7.org/fhir/name-use";
                }
                case ANONYMOUS: {
                    return "http://hl7.org/fhir/name-use";
                }
                case OLD: {
                    return "http://hl7.org/fhir/name-use";
                }
                case MAIDEN: {
                    return "http://hl7.org/fhir/name-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USUAL: {
                    return "Known as/conventional/the one you normally use.";
                }
                case OFFICIAL: {
                    return "The formal name as registered in an official (government) registry, but which name might not be commonly used. May be called \"legal name\".";
                }
                case TEMP: {
                    return "A temporary name. Name.period can provide more detailed information. This may also be used for temporary names assigned at birth or in emergency situations.";
                }
                case NICKNAME: {
                    return "A name that is used to address the person in an informal manner, but is not part of their formal or usual name.";
                }
                case ANONYMOUS: {
                    return "Anonymous assigned name, alias, or pseudonym (used to protect a person's identity for privacy reasons).";
                }
                case OLD: {
                    return "This name is no longer in use (or was never correct, but retained for records).";
                }
                case MAIDEN: {
                    return "A name used prior to changing name because of marriage. This name use is for use by applications that collect and store names that were used prior to a marriage. Marriage naming customs vary greatly around the world, and are constantly changing. This term is not gender specific. The use of this term does not imply any particular history for a person's name.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USUAL: {
                    return "Usual";
                }
                case OFFICIAL: {
                    return "Official";
                }
                case TEMP: {
                    return "Temp";
                }
                case NICKNAME: {
                    return "Nickname";
                }
                case ANONYMOUS: {
                    return "Anonymous";
                }
                case OLD: {
                    return "Old";
                }
                case MAIDEN: {
                    return "Name changed for Marriage";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

