/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.TypeConvertor;

@DatatypeDef(name="RatioRange")
public class RatioRange
extends DataType
implements ICompositeType {
    @Child(name="lowNumerator", type={Quantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Low Numerator limit", formalDefinition="The value of the low limit numerator.")
    protected Quantity lowNumerator;
    @Child(name="highNumerator", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High Numerator limit", formalDefinition="The value of the high limit numerator.")
    protected Quantity highNumerator;
    @Child(name="denominator", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Denominator value", formalDefinition="The value of the denominator.")
    protected Quantity denominator;
    private static final long serialVersionUID = -1691080287L;

    public Quantity getLowNumerator() {
        if (this.lowNumerator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RatioRange.lowNumerator");
            }
            if (Configuration.doAutoCreate()) {
                this.lowNumerator = new Quantity();
            }
        }
        return this.lowNumerator;
    }

    public boolean hasLowNumerator() {
        return this.lowNumerator != null && !this.lowNumerator.isEmpty();
    }

    public RatioRange setLowNumerator(Quantity value) {
        this.lowNumerator = value;
        return this;
    }

    public Quantity getHighNumerator() {
        if (this.highNumerator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RatioRange.highNumerator");
            }
            if (Configuration.doAutoCreate()) {
                this.highNumerator = new Quantity();
            }
        }
        return this.highNumerator;
    }

    public boolean hasHighNumerator() {
        return this.highNumerator != null && !this.highNumerator.isEmpty();
    }

    public RatioRange setHighNumerator(Quantity value) {
        this.highNumerator = value;
        return this;
    }

    public Quantity getDenominator() {
        if (this.denominator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RatioRange.denominator");
            }
            if (Configuration.doAutoCreate()) {
                this.denominator = new Quantity();
            }
        }
        return this.denominator;
    }

    public boolean hasDenominator() {
        return this.denominator != null && !this.denominator.isEmpty();
    }

    public RatioRange setDenominator(Quantity value) {
        this.denominator = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("lowNumerator", "Quantity", "The value of the low limit numerator.", 0, 1, this.lowNumerator));
        children.add(new Property("highNumerator", "Quantity", "The value of the high limit numerator.", 0, 1, this.highNumerator));
        children.add(new Property("denominator", "Quantity", "The value of the denominator.", 0, 1, this.denominator));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1003958677: {
                return new Property("lowNumerator", "Quantity", "The value of the low limit numerator.", 0, 1, this.lowNumerator);
            }
            case 311013127: {
                return new Property("highNumerator", "Quantity", "The value of the high limit numerator.", 0, 1, this.highNumerator);
            }
            case -1983274394: {
                return new Property("denominator", "Quantity", "The value of the denominator.", 0, 1, this.denominator);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1003958677: {
                Base[] baseArray;
                if (this.lowNumerator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.lowNumerator;
                }
                return baseArray;
            }
            case 311013127: {
                Base[] baseArray;
                if (this.highNumerator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.highNumerator;
                }
                return baseArray;
            }
            case -1983274394: {
                Base[] baseArray;
                if (this.denominator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.denominator;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1003958677: {
                this.lowNumerator = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 311013127: {
                this.highNumerator = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -1983274394: {
                this.denominator = TypeConvertor.castToQuantity(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("lowNumerator")) {
            this.lowNumerator = TypeConvertor.castToQuantity(value);
        } else if (name.equals("highNumerator")) {
            this.highNumerator = TypeConvertor.castToQuantity(value);
        } else if (name.equals("denominator")) {
            this.denominator = TypeConvertor.castToQuantity(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1003958677: {
                return this.getLowNumerator();
            }
            case 311013127: {
                return this.getHighNumerator();
            }
            case -1983274394: {
                return this.getDenominator();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1003958677: {
                return new String[]{"Quantity"};
            }
            case 311013127: {
                return new String[]{"Quantity"};
            }
            case -1983274394: {
                return new String[]{"Quantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("lowNumerator")) {
            this.lowNumerator = new Quantity();
            return this.lowNumerator;
        }
        if (name.equals("highNumerator")) {
            this.highNumerator = new Quantity();
            return this.highNumerator;
        }
        if (name.equals("denominator")) {
            this.denominator = new Quantity();
            return this.denominator;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RatioRange";
    }

    @Override
    public RatioRange copy() {
        RatioRange dst = new RatioRange();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RatioRange dst) {
        super.copyValues(dst);
        dst.lowNumerator = this.lowNumerator == null ? null : this.lowNumerator.copy();
        dst.highNumerator = this.highNumerator == null ? null : this.highNumerator.copy();
        dst.denominator = this.denominator == null ? null : this.denominator.copy();
    }

    protected RatioRange typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RatioRange)) {
            return false;
        }
        RatioRange o = (RatioRange)other_;
        return RatioRange.compareDeep(this.lowNumerator, o.lowNumerator, true) && RatioRange.compareDeep(this.highNumerator, o.highNumerator, true) && RatioRange.compareDeep(this.denominator, o.denominator, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RatioRange)) {
            return false;
        }
        RatioRange o = (RatioRange)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.lowNumerator, this.highNumerator, this.denominator});
    }
}

