/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.ContactPoint;
import org.hl7.fhir.r4b.model.DataRequirement;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.ParameterDefinition;
import org.hl7.fhir.r4b.model.RelatedArtifact;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.renderers.ResourceRenderer;
import org.hl7.fhir.r4b.renderers.utils.BaseWrappers;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.r4b.renderers.utils.Resolver;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class LibraryRenderer
extends ResourceRenderer {
    private static final int DATA_IMG_SIZE_CUTOFF = 4000;

    public LibraryRenderer(RenderingContext context) {
        super(context);
    }

    public LibraryRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (Library)dr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper lib) throws FHIRFormatError, DefinitionException, IOException {
        BaseWrappers.PropertyWrapper contents;
        BaseWrappers.PropertyWrapper dataRequirements;
        BaseWrappers.PropertyWrapper parameters;
        BaseWrappers.PropertyWrapper artifacts;
        BaseWrappers.PropertyWrapper authors = lib.getChildByName("author");
        BaseWrappers.PropertyWrapper editors = lib.getChildByName("editor");
        BaseWrappers.PropertyWrapper reviewers = lib.getChildByName("reviewer");
        BaseWrappers.PropertyWrapper endorsers = lib.getChildByName("endorser");
        if (authors != null && authors.hasValues() || editors != null && editors.hasValues() || reviewers != null && reviewers.hasValues() || endorsers != null && endorsers.hasValues()) {
            boolean email = this.hasCT(authors, "email") || this.hasCT(editors, "email") || this.hasCT(reviewers, "email") || this.hasCT(endorsers, "email");
            boolean phone = this.hasCT(authors, "phone") || this.hasCT(editors, "phone") || this.hasCT(reviewers, "phone") || this.hasCT(endorsers, "phone");
            boolean url = this.hasCT(authors, "url") || this.hasCT(editors, "url") || this.hasCT(reviewers, "url") || this.hasCT(endorsers, "url");
            x.h2().tx("Participants");
            XhtmlNode t = x.table("grid");
            if (authors != null) {
                for (BaseWrappers.BaseWrapper baseWrapper : authors.getValues()) {
                    this.participantRow(t, "Author", baseWrapper, email, phone, url);
                }
            }
            if (authors != null) {
                for (BaseWrappers.BaseWrapper baseWrapper : editors.getValues()) {
                    this.participantRow(t, "Editor", baseWrapper, email, phone, url);
                }
            }
            if (authors != null) {
                for (BaseWrappers.BaseWrapper baseWrapper : reviewers.getValues()) {
                    this.participantRow(t, "Reviewer", baseWrapper, email, phone, url);
                }
            }
            if (authors != null) {
                for (BaseWrappers.BaseWrapper baseWrapper : endorsers.getValues()) {
                    this.participantRow(t, "Endorser", baseWrapper, email, phone, url);
                }
            }
        }
        if ((artifacts = lib.getChildByName("relatedArtifact")) != null && artifacts.hasValues()) {
            x.h2().tx("Related Artifacts");
            XhtmlNode t = x.table("grid");
            boolean label = false;
            boolean display = false;
            boolean citation = false;
            for (BaseWrappers.BaseWrapper ra : artifacts.getValues()) {
                label = label || ra.has("label");
                display = display || ra.has("display");
                citation = citation || ra.has("citation");
            }
            for (BaseWrappers.BaseWrapper ra : artifacts.getValues()) {
                this.renderArtifact(t, ra, lib, label, display, citation);
            }
        }
        if ((parameters = lib.getChildByName("parameter")) != null && parameters.hasValues()) {
            x.h2().tx("Parameters");
            XhtmlNode t = x.table("grid");
            boolean doco = false;
            for (BaseWrappers.BaseWrapper baseWrapper : parameters.getValues()) {
                doco = doco || baseWrapper.has("documentation");
            }
            for (BaseWrappers.BaseWrapper baseWrapper : parameters.getValues()) {
                this.renderParameter(t, baseWrapper, doco);
            }
        }
        if ((dataRequirements = lib.getChildByName("dataRequirement")) != null && dataRequirements.hasValues()) {
            x.h2().tx("Data Requirements");
            for (BaseWrappers.BaseWrapper p : dataRequirements.getValues()) {
                this.renderDataRequirement(x, (DataRequirement)p.getBase());
            }
        }
        if ((contents = lib.getChildByName("content")) != null) {
            x.h2().tx("Contents");
            boolean isCql = false;
            boolean bl = false;
            for (BaseWrappers.BaseWrapper p : contents.getValues()) {
                void var12_38;
                Attachment att = (Attachment)p.getBase();
                this.renderAttachment(x, att, isCql, (int)var12_38, lib.getId());
                isCql = isCql || att.hasContentType() && att.getContentType().startsWith("text/cql");
                ++var12_38;
            }
        }
        return false;
    }

    private boolean hasCT(BaseWrappers.PropertyWrapper prop, String type) throws UnsupportedEncodingException, FHIRException, IOException {
        if (prop != null) {
            for (BaseWrappers.BaseWrapper cd : prop.getValues()) {
                BaseWrappers.PropertyWrapper telecoms = cd.getChildByName("telecom");
                if (this.getContactPoint(telecoms, type) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasCT(List<ContactDetail> list, String type) {
        for (ContactDetail cd : list) {
            for (ContactPoint t : cd.getTelecom()) {
                if (!type.equals(t.getSystem().toCode())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean render(XhtmlNode x, Library lib) throws FHIRFormatError, DefinitionException, IOException {
        if (lib.hasAuthor() || lib.hasEditor() || lib.hasReviewer() || lib.hasEndorser()) {
            boolean email = this.hasCT(lib.getAuthor(), "email") || this.hasCT(lib.getEditor(), "email") || this.hasCT(lib.getReviewer(), "email") || this.hasCT(lib.getEndorser(), "email");
            boolean phone = this.hasCT(lib.getAuthor(), "phone") || this.hasCT(lib.getEditor(), "phone") || this.hasCT(lib.getReviewer(), "phone") || this.hasCT(lib.getEndorser(), "phone");
            boolean url = this.hasCT(lib.getAuthor(), "url") || this.hasCT(lib.getEditor(), "url") || this.hasCT(lib.getReviewer(), "url") || this.hasCT(lib.getEndorser(), "url");
            x.h2().tx("Participants");
            XhtmlNode t = x.table("grid");
            for (ContactDetail cd : lib.getAuthor()) {
                this.participantRow(t, "Author", cd, email, phone, url);
            }
            for (ContactDetail cd : lib.getEditor()) {
                this.participantRow(t, "Editor", cd, email, phone, url);
            }
            for (ContactDetail cd : lib.getReviewer()) {
                this.participantRow(t, "Reviewer", cd, email, phone, url);
            }
            for (ContactDetail cd : lib.getEndorser()) {
                this.participantRow(t, "Endorser", cd, email, phone, url);
            }
        }
        if (lib.hasRelatedArtifact()) {
            x.h2().tx("Related Artifacts");
            XhtmlNode t = x.table("grid");
            boolean label = false;
            boolean display = false;
            boolean citation = false;
            for (RelatedArtifact ra : lib.getRelatedArtifact()) {
                label = label || ra.hasLabel();
                display = display || ra.hasDisplay();
                citation = citation || ra.hasCitation();
            }
            for (RelatedArtifact ra : lib.getRelatedArtifact()) {
                this.renderArtifact(t, ra, lib, label, display, citation);
            }
        }
        if (lib.hasParameter()) {
            x.h2().tx("Parameters");
            XhtmlNode t = x.table("grid");
            boolean doco = false;
            for (ParameterDefinition p : lib.getParameter()) {
                doco = doco || p.hasDocumentation();
            }
            for (ParameterDefinition p : lib.getParameter()) {
                this.renderParameter(t, p, doco);
            }
        }
        if (lib.hasDataRequirement()) {
            x.h2().tx("Data Requirements");
            for (DataRequirement p : lib.getDataRequirement()) {
                this.renderDataRequirement(x, p);
            }
        }
        if (lib.hasContent()) {
            x.h2().tx("Contents");
            boolean isCql = false;
            int counter = 0;
            for (Attachment att : lib.getContent()) {
                this.renderAttachment(x, att, isCql, counter, lib.getId());
                isCql = isCql || att.hasContentType() && att.getContentType().startsWith("text/cql");
                ++counter;
            }
        }
        return false;
    }

    private void renderParameter(XhtmlNode t, BaseWrappers.BaseWrapper p, boolean doco) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(p.has("name") ? p.get("name").primitiveValue() : null);
        tr.td().tx(p.has("use") ? p.get("use").primitiveValue() : null);
        tr.td().tx(p.has("min") ? p.get("min").primitiveValue() : null);
        tr.td().tx(p.has("max") ? p.get("max").primitiveValue() : null);
        tr.td().tx(p.has("type") ? p.get("type").primitiveValue() : null);
        if (doco) {
            tr.td().tx(p.has("documentation") ? p.get("documentation").primitiveValue() : null);
        }
    }

    private void renderParameter(XhtmlNode t, ParameterDefinition p, boolean doco) {
        XhtmlNode tr = t.tr();
        tr.td().tx(p.getName());
        tr.td().tx(p.getUse().getDisplay());
        tr.td().tx(p.getMin());
        tr.td().tx(p.getMax());
        tr.td().tx(p.getType().getDisplay());
        if (doco) {
            tr.td().tx(p.getDocumentation());
        }
    }

    private void renderArtifact(XhtmlNode t, BaseWrappers.BaseWrapper ra, BaseWrappers.ResourceWrapper lib, boolean label, boolean display, boolean citation) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(ra.has("type") ? ra.get("type").primitiveValue() : null);
        if (label) {
            tr.td().tx(ra.has("label") ? ra.get("label").primitiveValue() : null);
        }
        if (display) {
            tr.td().tx(ra.has("display") ? ra.get("display").primitiveValue() : null);
        }
        if (citation) {
            tr.td().markdown(ra.has("citation") ? ra.get("citation").primitiveValue() : null, "Citation");
        }
        if (ra.has("resource")) {
            this.renderCanonical(lib, tr.td(), ra.get("resource").primitiveValue());
        } else {
            tr.td().tx(ra.has("url") ? ra.get("url").primitiveValue() : null);
        }
    }

    private void renderArtifact(XhtmlNode t, RelatedArtifact ra, Resource lib, boolean label, boolean display, boolean citation) throws IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(ra.getType().getDisplay());
        if (label) {
            tr.td().tx(ra.getLabel());
        }
        if (display) {
            tr.td().tx(ra.getDisplay());
        }
        if (citation) {
            tr.td().markdown(ra.getCitation(), "Citation");
        }
        if (ra.hasResource()) {
            this.renderCanonical(lib, tr.td(), ra.getResource());
        } else {
            this.renderAttachment(tr.td(), ra.getDocument(), false, 0, lib.getId());
        }
    }

    private void participantRow(XhtmlNode t, String label, BaseWrappers.BaseWrapper cd, boolean email, boolean phone, boolean url) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(label);
        tr.td().tx(cd.get("name") != null ? cd.get("name").primitiveValue() : null);
        BaseWrappers.PropertyWrapper telecoms = cd.getChildByName("telecom");
        if (email) {
            this.renderContactPoint(tr.td(), this.getContactPoint(telecoms, "email"));
        }
        if (phone) {
            this.renderContactPoint(tr.td(), this.getContactPoint(telecoms, "phone"));
        }
        if (url) {
            this.renderContactPoint(tr.td(), this.getContactPoint(telecoms, "url"));
        }
    }

    private ContactPoint getContactPoint(BaseWrappers.PropertyWrapper telecoms, String value) throws UnsupportedEncodingException, FHIRException, IOException {
        for (BaseWrappers.BaseWrapper t : telecoms.getValues()) {
            String system;
            if (!t.has("system") || !value.equals(system = t.get("system").primitiveValue())) continue;
            return (ContactPoint)t.getBase();
        }
        return null;
    }

    private void participantRow(XhtmlNode t, String label, ContactDetail cd, boolean email, boolean phone, boolean url) {
        XhtmlNode tr = t.tr();
        tr.td().tx(label);
        tr.td().tx(cd.getName());
        if (email) {
            this.renderContactPoint(tr.td(), cd.getEmail());
        }
        if (phone) {
            this.renderContactPoint(tr.td(), cd.getPhone());
        }
        if (url) {
            this.renderContactPoint(tr.td(), cd.getUrl());
        }
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((Library)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }

    private void renderAttachment(XhtmlNode x, Attachment att, boolean noShowData, int counter, String baseId) {
        boolean ref;
        boolean bl = ref = !att.hasData() && att.hasUrl();
        if (ref) {
            XhtmlNode p = x.para();
            if (att.hasTitle()) {
                p.tx(att.getTitle());
                p.tx(": ");
            }
            p.code().ah(att.getUrl()).tx(att.getUrl());
            p.tx(" (");
            p.code().tx(att.getContentType());
            p.tx(this.lang(att));
            p.tx(")");
        } else if (!att.hasData()) {
            XhtmlNode p = x.para();
            if (att.hasTitle()) {
                p.tx(att.getTitle());
                p.tx(": ");
            }
            p.code().tx("No Content");
            p.tx(" (");
            p.code().tx(att.getContentType());
            p.tx(this.lang(att));
            p.tx(")");
        } else {
            String txt = this.getText(att);
            if (this.isImage(att.getContentType())) {
                XhtmlNode p = x.para();
                if (att.hasTitle()) {
                    p.tx(att.getTitle());
                    p.tx(": (");
                    p.code().tx(att.getContentType());
                    p.tx(this.lang(att));
                    p.tx(")");
                } else {
                    p.code().tx(att.getContentType() + this.lang(att));
                }
                if (att.getData().length < 4000) {
                    x.img("data: " + att.getContentType() + ">;base64," + this.b64(att.getData()), "data");
                } else {
                    String filename = "Library-" + baseId + (counter == 0 ? "" : "-" + Integer.toString(counter)) + "." + this.imgExtension(att.getContentType());
                    x.img(filename, "data");
                }
            } else if (txt != null && !noShowData) {
                XhtmlNode p = x.para();
                if (att.hasTitle()) {
                    p.tx(att.getTitle());
                    p.tx(": (");
                    p.code().tx(att.getContentType());
                    p.tx(this.lang(att));
                    p.tx(")");
                } else {
                    p.code().tx(att.getContentType() + this.lang(att));
                }
                String prismCode = this.determinePrismCode(att);
                if (prismCode != null && !this.tooBig(txt)) {
                    x.pre().code().setAttribute("class", "language-" + prismCode).tx(txt);
                } else {
                    x.pre().code().tx(txt);
                }
            } else {
                XhtmlNode p = x.para();
                if (att.hasTitle()) {
                    p.tx(att.getTitle());
                    p.tx(": ");
                }
                p.code().tx("Content not shown - (");
                p.code().tx(att.getContentType());
                p.tx(this.lang(att));
                p.tx(", size = " + Utilities.describeSize((int)att.getData().length) + ")");
            }
        }
    }

    private boolean tooBig(String txt) {
        return txt.length() > 16384;
    }

    private String imgExtension(String contentType) {
        if (contentType != null && contentType.startsWith("image/")) {
            if (contentType.startsWith("image/png")) {
                return "png";
            }
            if (contentType.startsWith("image/jpeg")) {
                return "jpg";
            }
        }
        return null;
    }

    private String b64(byte[] data) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])data);
        return new String(encodeBase64);
    }

    private boolean isImage(String contentType) {
        return this.imgExtension(contentType) != null;
    }

    private String lang(Attachment att) {
        if (att.hasLanguage()) {
            return ", language = " + this.describeLang(att.getLanguage());
        }
        return "";
    }

    private String getText(Attachment att) {
        try {
            String src2;
            try {
                src2 = new String(att.getData(), "UTF-8");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src2) {
                // empty catch block
            }
            try {
                src2 = new String(att.getData(), "UTF-16");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src3) {
                // empty catch block
            }
            try {
                src2 = new String(att.getData(), "ASCII");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src4) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean checkString(String src) {
        for (char ch : src.toCharArray()) {
            if (ch >= ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    private String determinePrismCode(Attachment att) {
        if (att.hasContentType()) {
            String ct = att.getContentType();
            if (ct.contains(";")) {
                ct = ct.substring(0, ct.indexOf(";"));
            }
            switch (ct) {
                case "text/html": {
                    return "html";
                }
                case "text/xml": {
                    return "xml";
                }
                case "application/xml": {
                    return "xml";
                }
                case "text/markdown": {
                    return "markdown";
                }
                case "application/js": {
                    return "JavaScript";
                }
                case "application/css": {
                    return "css";
                }
                case "text/x-csrc": {
                    return "c";
                }
                case "text/x-csharp": {
                    return "csharp";
                }
                case "text/x-c++src": {
                    return "cpp";
                }
                case "application/graphql": {
                    return "graphql";
                }
                case "application/x-java": {
                    return "java";
                }
                case "application/json": {
                    return "json";
                }
                case "text/json": {
                    return "json";
                }
                case "application/liquid": {
                    return "liquid";
                }
                case "text/x-pascal": {
                    return "pascal";
                }
                case "text/x-python": {
                    return "python";
                }
                case "text/x-rsrc": {
                    return "r";
                }
                case "text/x-ruby": {
                    return "ruby";
                }
                case "text/x-sas": {
                    return "sas";
                }
                case "text/x-sql": {
                    return "sql";
                }
                case "application/typescript": {
                    return "typescript";
                }
                case "text/cql": {
                    return "sql";
                }
            }
            if (att.getContentType().contains("json+") || att.getContentType().contains("+json")) {
                return "json";
            }
            if (att.getContentType().contains("xml+") || att.getContentType().contains("+xml")) {
                return "xml";
            }
        }
        return null;
    }
}

