/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r4b.comparison.ComparisonSession;
import org.hl7.fhir.r4b.comparison.ResourceComparer;
import org.hl7.fhir.r4b.comparison.StructuralMatch;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CodeSystemComparer
extends CanonicalResourceComparer {
    private CodeSystem right;

    public CodeSystemComparer(ComparisonSession session) {
        super(session);
    }

    public CodeSystemComparison compare(CodeSystem left, CodeSystem right) {
        if (left == null) {
            throw new DefinitionException("No CodeSystem provided (left)");
        }
        if (right == null) {
            throw new DefinitionException("No CodeSystem provided (right)");
        }
        CodeSystemComparison res = new CodeSystemComparison(left, right);
        this.session.identify(res);
        CodeSystem cs = new CodeSystem();
        res.setUnion(cs);
        this.session.identify(cs);
        cs.setName("Union" + left.getName() + "And" + right.getName());
        cs.setTitle("Union of " + left.getTitle() + " And " + right.getTitle());
        cs.setStatus(left.getStatus());
        cs.setDate(new Date());
        for (CodeSystem.PropertyComponent pL : left.getProperty()) {
            cs.addProperty(pL.copy());
        }
        for (CodeSystem.PropertyComponent pR : left.getProperty()) {
            CodeSystem.PropertyComponent pL = this.findProperty(left, pR);
            if (pL == null) {
                String code = this.getUniqued(pR.getCode(), cs.getProperty());
                cs.addProperty(pR.copy().setCode(code));
                continue;
            }
            res.getPropMap().put(pR.getCode(), pL.getCode());
        }
        CodeSystem cs1 = new CodeSystem();
        res.setIntersection(cs1);
        this.session.identify(cs1);
        cs1.setName("Intersection" + left.getName() + "And" + right.getName());
        cs1.setTitle("Intersection of " + left.getTitle() + " And " + right.getTitle());
        cs1.setStatus(left.getStatus());
        cs1.setDate(new Date());
        cs1.getProperty().addAll(cs.getProperty());
        this.compareMetadata(left, right, res.getMetadata(), res);
        this.comparePrimitives("caseSensitive", left.getCaseSensitiveElement(), right.getCaseSensitiveElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("hierarchyMeaning", left.getHierarchyMeaningElement(), right.getHierarchyMeaningElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("compositional", left.getCompositionalElement(), right.getCompositionalElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res);
        this.comparePrimitives("versionNeeded", left.getVersionNeededElement(), right.getVersionNeededElement(), res.getMetadata(), ValidationMessage.IssueSeverity.INFORMATION, res);
        this.comparePrimitives("content", left.getContentElement(), right.getContentElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res);
        this.compareConcepts(left.getConcept(), right.getConcept(), res.getCombined(), ((CodeSystem)res.getUnion()).getConcept(), ((CodeSystem)res.getIntersection()).getConcept(), (CodeSystem)res.getUnion(), (CodeSystem)res.getIntersection(), res, "CodeSystem.concept");
        return res;
    }

    private String getUniqued(String code, List<CodeSystem.PropertyComponent> list) {
        String res;
        boolean ok;
        int i = 0;
        do {
            ok = true;
            res = code + (i == 0 ? "" : Integer.valueOf(i));
            for (CodeSystem.PropertyComponent t : list) {
                if (!res.equals(t.getCode())) continue;
                ok = false;
            }
        } while (!ok);
        return res;
    }

    private CodeSystem.PropertyComponent findProperty(CodeSystem left, CodeSystem.PropertyComponent p) {
        for (CodeSystem.PropertyComponent t : left.getProperty()) {
            if (p.hasUri() && t.hasUri() && p.getUri().equals(t.getUri())) {
                return t;
            }
            if (p.hasUri() || t.hasUri() || !p.getCode().equals(t.getCode())) continue;
            return t;
        }
        return null;
    }

    private void compareConcepts(List<CodeSystem.ConceptDefinitionComponent> left, List<CodeSystem.ConceptDefinitionComponent> right, StructuralMatch<CodeSystem.ConceptDefinitionComponent> combined, List<CodeSystem.ConceptDefinitionComponent> union, List<CodeSystem.ConceptDefinitionComponent> intersection, CodeSystem csU, CodeSystem csI, CodeSystemComparison res, String path) {
        ArrayList<CodeSystem.ConceptDefinitionComponent> matchR = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
        for (CodeSystem.ConceptDefinitionComponent l : left) {
            CodeSystem.ConceptDefinitionComponent r = this.findInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<CodeSystem.ConceptDefinitionComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this concept", path)));
                continue;
            }
            matchR.add(r);
            CodeSystem.ConceptDefinitionComponent cdM = this.merge(l, r, csU.getProperty(), res);
            CodeSystem.ConceptDefinitionComponent cdI = this.intersect(l, r, res);
            union.add(cdM);
            intersection.add(cdI);
            StructuralMatch<CodeSystem.ConceptDefinitionComponent> sm = new StructuralMatch<CodeSystem.ConceptDefinitionComponent>(l, r);
            this.compare(sm.getMessages(), l, r, path + ".where(code='" + l.getCode() + "')", res);
            combined.getChildren().add(sm);
            this.compareConcepts(l.getConcept(), r.getConcept(), sm, cdM.getConcept(), cdI.getConcept(), csU, csI, res, path + ".where(code='" + l.getCode() + "').concept");
        }
        for (CodeSystem.ConceptDefinitionComponent r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<CodeSystem.ConceptDefinitionComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this concept", path), r));
        }
    }

    private CodeSystem.ConceptDefinitionComponent findInList(List<CodeSystem.ConceptDefinitionComponent> list, CodeSystem.ConceptDefinitionComponent item) {
        for (CodeSystem.ConceptDefinitionComponent t : list) {
            if (!t.getCode().equals(item.getCode())) continue;
            return t;
        }
        return null;
    }

    private void compare(List<ValidationMessage> msgs, CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r, String path, CodeSystemComparison res) {
        this.compareStrings(path, msgs, l.getDisplay(), r.getDisplay(), "display", ValidationMessage.IssueSeverity.WARNING, res);
        this.compareStrings(path, msgs, l.getDefinition(), r.getDefinition(), "definition", ValidationMessage.IssueSeverity.INFORMATION, res);
    }

    private void compareStrings(String path, List<ValidationMessage> msgs, String left, String right, String name, ValidationMessage.IssueSeverity level, CodeSystemComparison res) {
        if (!Utilities.noString((String)right)) {
            if (Utilities.noString((String)left)) {
                msgs.add(this.vmI(level, "Value for " + name + " added", path));
            } else if (!left.equals(right)) {
                if (level != ValidationMessage.IssueSeverity.NULL) {
                    res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + "." + name, "Changed value for " + name + ": '" + left + "' vs '" + right + "'", level));
                }
                msgs.add(this.vmI(level, name + " changed from left to right", path));
            }
        } else if (!Utilities.noString((String)left)) {
            msgs.add(this.vmI(level, "Value for " + name + " removed", path));
        }
    }

    private CodeSystem.ConceptDefinitionComponent merge(CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r, List<CodeSystem.PropertyComponent> destProps, CodeSystemComparison res) {
        CodeSystem.ConceptDefinitionComponent cd = l.copy();
        if (!l.hasDisplay() && r.hasDisplay()) {
            cd.setDisplay(r.getDisplay());
        }
        if (!l.hasDefinition() && r.hasDefinition()) {
            cd.setDefinition(r.getDefinition());
        }
        this.mergeProps(cd, l, r, destProps, res);
        this.mergeDesignations(cd, l, r);
        return cd;
    }

    private CodeSystem.ConceptDefinitionComponent intersect(CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r, CodeSystemComparison res) {
        CodeSystem.ConceptDefinitionComponent cd = l.copy();
        if (l.hasDisplay() && !r.hasDisplay()) {
            cd.setDisplay(null);
        }
        if (l.hasDefinition() && !r.hasDefinition()) {
            cd.setDefinition(null);
        }
        this.intersectProps(cd, l, r, res);
        return cd;
    }

    private void mergeDesignations(CodeSystem.ConceptDefinitionComponent cd, CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r) {
        for (CodeSystem.ConceptDefinitionDesignationComponent td : l.getDesignation()) {
            if (!this.hasDesignation(td, r.getDesignation())) continue;
            cd.getDesignation().add(td);
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent td : r.getDesignation()) {
            if (!this.hasDesignation(td, l.getDesignation())) continue;
            cd.getDesignation().add(td);
        }
    }

    private boolean hasDesignation(CodeSystem.ConceptDefinitionDesignationComponent td, List<CodeSystem.ConceptDefinitionDesignationComponent> designation) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : designation) {
            if (!this.designationsMatch(td, t)) continue;
            return true;
        }
        return false;
    }

    private boolean designationsMatch(CodeSystem.ConceptDefinitionDesignationComponent l, CodeSystem.ConceptDefinitionDesignationComponent r) {
        if (l.hasUse() != r.hasUse()) {
            return false;
        }
        if (l.hasLanguage() != r.hasLanguage()) {
            return false;
        }
        if (l.hasValue() != r.hasValue()) {
            return false;
        }
        if (l.hasUse() && l.getUse().equalsDeep(r.getUse())) {
            return false;
        }
        if (l.hasLanguage() && l.getLanguageElement().equalsDeep(r.getLanguageElement())) {
            return false;
        }
        return !l.hasValue() || !l.getValueElement().equalsDeep(r.getValueElement());
    }

    private void mergeProps(CodeSystem.ConceptDefinitionComponent cd, CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r, List<CodeSystem.PropertyComponent> destProps, CodeSystemComparison res) {
        ArrayList<CodeSystem.ConceptPropertyComponent> matchR = new ArrayList<CodeSystem.ConceptPropertyComponent>();
        for (CodeSystem.ConceptPropertyComponent lp : l.getProperty()) {
            CodeSystem.ConceptPropertyComponent rp = this.findRightProp(r.getProperty(), lp, res);
            if (rp == null) {
                cd.getProperty().add(lp);
                continue;
            }
            matchR.add(rp);
            cd.getProperty().add(lp);
            if (!lp.getValue().equalsDeep(rp.getValue())) continue;
            cd.getProperty().add(rp.setCode(res.getPropMap().get(rp.getCode())));
        }
        for (CodeSystem.ConceptPropertyComponent rp : r.getProperty()) {
            if (matchR.contains(rp)) continue;
            cd.getProperty().add(rp.setCode(res.getPropMap().get(rp.getCode())));
        }
    }

    private void intersectProps(CodeSystem.ConceptDefinitionComponent cd, CodeSystem.ConceptDefinitionComponent l, CodeSystem.ConceptDefinitionComponent r, CodeSystemComparison res) {
        for (CodeSystem.ConceptPropertyComponent lp : l.getProperty()) {
            CodeSystem.ConceptPropertyComponent rp = this.findRightProp(r.getProperty(), lp, res);
            if (rp == null) continue;
            cd.getProperty().add(lp);
        }
    }

    private CodeSystem.ConceptPropertyComponent findRightProp(List<CodeSystem.ConceptPropertyComponent> rightProperties, CodeSystem.ConceptPropertyComponent lp, CodeSystemComparison res) {
        for (CodeSystem.ConceptPropertyComponent p : rightProperties) {
            if (!res.getPropMap().get(p.getCode()).equals(lp.getCode())) continue;
            return p;
        }
        return null;
    }

    public XhtmlNode renderConcepts(CodeSystemComparison comparison, String id, String prefix) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(Utilities.path((String[])new String[]{"[tmp]", "compare"}), false);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, null, "Code", "The code for the concept", null, 100));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, null, "Display", "The display for the concept", null, 200, 2));
        for (CodeSystem.PropertyComponent propertyComponent : ((CodeSystem)comparison.getUnion()).getProperty()) {
            List list3 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, null, propertyComponent.getCode(), propertyComponent.getDescription(), null, 100, 2));
        }
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, null, "Comments", "Additional information about the comparison", null, 200));
        for (StructuralMatch structuralMatch : comparison.getCombined().getChildren()) {
            this.addRow(gen, model.getRows(), structuralMatch, comparison);
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<CodeSystem.ConceptDefinitionComponent> t, CodeSystemComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, t.either().getCode(), null, null));
        if (t.hasLeft() && t.hasRight()) {
            if (t.getLeft().hasDisplay() && t.getRight().hasDisplay()) {
                if (t.getLeft().getDisplay().equals(t.getRight().getDisplay())) {
                    List list2 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, t.getLeft().getDisplay(), null, null).span(2));
                } else {
                    List list3 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, t.getLeft().getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                    List list4 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, t.getRight().getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                }
            } else if (t.getLeft().hasDisplay()) {
                List list5 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, t.getLeft().getDisplay(), null, null));
                r.getCells().add(this.missingCell(gen, "#ffcc33"));
            } else if (t.getRight().hasDisplay()) {
                r.getCells().add(this.missingCell(gen, "#ffff4d"));
                List list6 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, t.getRight().getDisplay(), null, null));
            } else {
                r.getCells().add(this.missingCell(gen).span(2));
            }
            for (CodeSystem.PropertyComponent p : ((CodeSystem)comparison.getUnion()).getProperty()) {
                CodeSystem.ConceptPropertyComponent lp = this.getProp(t.getLeft(), p, false, comparison);
                CodeSystem.ConceptPropertyComponent rp = this.getProp(t.getRight(), p, true, comparison);
                if (lp != null && rp != null) {
                    if (lp.getValue().equals(rp.getValue())) {
                        List list7 = r.getCells();
                        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator7);
                        list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, t.getLeft().getDisplay(), null, null).span(2));
                        continue;
                    }
                    List list8 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator8);
                    list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, null, null, lp.getValue().toString(), null, null));
                    List list9 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator9);
                    list9.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator9, null, null, rp.getValue().toString(), null, null));
                    continue;
                }
                if (lp != null) {
                    List list10 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator10);
                    list10.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator10, null, null, lp.getValue().toString(), null, null));
                    r.getCells().add(this.missingCell(gen, "#ffcc33"));
                    continue;
                }
                if (rp != null) {
                    r.getCells().add(this.missingCell(gen, "#ffff4d"));
                    List list11 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list11.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator11, null, null, rp.getValue().toString(), null, null));
                    continue;
                }
                r.getCells().add(this.missingCell(gen).span(2));
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            List list12 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list12.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator12, null, null, t.either().getDisplay(), null, null));
            r.getCells().add(this.missingCell(gen));
            for (CodeSystem.PropertyComponent p : ((CodeSystem)comparison.getUnion()).getProperty()) {
                r.getCells().add(this.propertyCell(gen, t.getLeft(), p, false, comparison));
                r.getCells().add(this.missingCell(gen));
            }
        } else {
            r.setColor("#ffffb3");
            r.getCells().add(this.missingCell(gen));
            List list13 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list13.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator13, null, null, t.either().getDisplay(), null, null));
            for (CodeSystem.PropertyComponent p : ((CodeSystem)comparison.getUnion()).getProperty()) {
                r.getCells().add(this.missingCell(gen));
                r.getCells().add(this.propertyCell(gen, t.getLeft(), p, true, comparison));
            }
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
    }

    private HierarchicalTableGenerator.Cell propertyCell(HierarchicalTableGenerator gen, CodeSystem.ConceptDefinitionComponent cd, CodeSystem.PropertyComponent p, boolean right, CodeSystemComparison comp) {
        CodeSystem.ConceptPropertyComponent cp = this.getProp(cd, p, right, comp);
        if (cp == null) {
            return this.missingCell(gen, right ? "#ffcc33" : "#ffff4d");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        return new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, cp.getValue().toString(), null, null);
    }

    public CodeSystem.ConceptPropertyComponent getProp(CodeSystem.ConceptDefinitionComponent cd, CodeSystem.PropertyComponent p, boolean right, CodeSystemComparison comp) {
        String c = p.getCode();
        if (right) {
            c = comp.getPropMap().get(c);
        }
        CodeSystem.ConceptPropertyComponent cp = null;
        if (cd != null) {
            for (CodeSystem.ConceptPropertyComponent t : cd.getProperty()) {
                if (!t.getCode().equals(c)) continue;
                cp = t;
            }
        }
        return cp;
    }

    @Override
    protected String fhirType() {
        return "CodeSystem";
    }

    public class CodeSystemComparison
    extends CanonicalResourceComparer.CanonicalResourceComparison<CodeSystem> {
        private StructuralMatch<CodeSystem.ConceptDefinitionComponent> combined;
        private Map<String, String> propMap;

        public CodeSystemComparison(CodeSystem left, CodeSystem right) {
            super((CanonicalResourceComparer)CodeSystemComparer.this, (CanonicalResource)left, (CanonicalResource)right);
            this.propMap = new HashMap<String, String>();
            this.combined = new StructuralMatch();
        }

        public Map<String, String> getPropMap() {
            return this.propMap;
        }

        public StructuralMatch<CodeSystem.ConceptDefinitionComponent> getCombined() {
            return this.combined;
        }

        @Override
        protected String abbreviation() {
            return "cs";
        }

        @Override
        protected String summary() {
            return "CodeSystem: " + ((CodeSystem)this.left).present() + " vs " + ((CodeSystem)this.right).present();
        }

        @Override
        protected String fhirType() {
            return "CodeSystem";
        }

        @Override
        protected void countMessages(ResourceComparer.MessageCounts cnts) {
            super.countMessages(cnts);
            this.combined.countMessages(cnts);
        }
    }
}

