/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.r4b.model.PrimitiveType;

@DatatypeDef(name="integer64")
public class Integer64Type
extends PrimitiveType<Long> {
    private static final long serialVersionUID = 3L;

    public Integer64Type() {
    }

    public Integer64Type(long theInteger) {
        this.setValue((Object)theInteger);
    }

    public Integer64Type(String theIntegerAsString) {
        this.setValueAsString(theIntegerAsString);
    }

    public Integer64Type(Long theValue) {
        if (theValue != null) {
            this.setValue(theValue);
        }
    }

    @Override
    protected Long parse(String theValue) {
        try {
            return Long.parseLong(theValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected String encode(Long theValue) {
        return Long.toString(theValue);
    }

    @Override
    public Integer64Type copy() {
        Integer64Type ret = new Integer64Type((Long)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "integer64";
    }
}

